/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 8577:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__(5632);

/***/ }),

/***/ 556:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
var settle = __webpack_require__(494);
var cookies = __webpack_require__(8861);
var buildURL = __webpack_require__(1971);
var buildFullPath = __webpack_require__(8251);
var parseHeaders = __webpack_require__(5283);
var isURLSameOrigin = __webpack_require__(7858);
var transitionalDefaults = __webpack_require__(617);
var AxiosError = __webpack_require__(4808);
var CanceledError = __webpack_require__(1259);
var parseProtocol = __webpack_require__(8499);
module.exports = function xhrAdapter(config) {
  return new Promise(function dispatchXhrRequest(resolve, reject) {
    var requestData = config.data;
    var requestHeaders = config.headers;
    var responseType = config.responseType;
    var onCanceled;
    function done() {
      if (config.cancelToken) {
        config.cancelToken.unsubscribe(onCanceled);
      }
      if (config.signal) {
        config.signal.removeEventListener('abort', onCanceled);
      }
    }
    if (utils.isFormData(requestData) && utils.isStandardBrowserEnv()) {
      delete requestHeaders['Content-Type']; // Let the browser set it
    }

    var request = new XMLHttpRequest();

    // HTTP basic authentication
    if (config.auth) {
      var username = config.auth.username || '';
      var password = config.auth.password ? unescape(encodeURIComponent(config.auth.password)) : '';
      requestHeaders.Authorization = 'Basic ' + btoa(username + ':' + password);
    }
    var fullPath = buildFullPath(config.baseURL, config.url);
    request.open(config.method.toUpperCase(), buildURL(fullPath, config.params, config.paramsSerializer), true);

    // Set the request timeout in MS
    request.timeout = config.timeout;
    function onloadend() {
      if (!request) {
        return;
      }
      // Prepare the response
      var responseHeaders = 'getAllResponseHeaders' in request ? parseHeaders(request.getAllResponseHeaders()) : null;
      var responseData = !responseType || responseType === 'text' || responseType === 'json' ? request.responseText : request.response;
      var response = {
        data: responseData,
        status: request.status,
        statusText: request.statusText,
        headers: responseHeaders,
        config: config,
        request: request
      };
      settle(function _resolve(value) {
        resolve(value);
        done();
      }, function _reject(err) {
        reject(err);
        done();
      }, response);

      // Clean up request
      request = null;
    }
    if ('onloadend' in request) {
      // Use onloadend if available
      request.onloadend = onloadend;
    } else {
      // Listen for ready state to emulate onloadend
      request.onreadystatechange = function handleLoad() {
        if (!request || request.readyState !== 4) {
          return;
        }

        // The request errored out and we didn't get a response, this will be
        // handled by onerror instead
        // With one exception: request that using file: protocol, most browsers
        // will return status as 0 even though it's a successful request
        if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {
          return;
        }
        // readystate handler is calling before onerror or ontimeout handlers,
        // so we should call onloadend on the next 'tick'
        setTimeout(onloadend);
      };
    }

    // Handle browser request cancellation (as opposed to a manual cancellation)
    request.onabort = function handleAbort() {
      if (!request) {
        return;
      }
      reject(new AxiosError('Request aborted', AxiosError.ECONNABORTED, config, request));

      // Clean up request
      request = null;
    };

    // Handle low level network errors
    request.onerror = function handleError() {
      // Real errors are hidden from us by the browser
      // onerror should only fire if it's a network error
      reject(new AxiosError('Network Error', AxiosError.ERR_NETWORK, config, request, request));

      // Clean up request
      request = null;
    };

    // Handle timeout
    request.ontimeout = function handleTimeout() {
      var timeoutErrorMessage = config.timeout ? 'timeout of ' + config.timeout + 'ms exceeded' : 'timeout exceeded';
      var transitional = config.transitional || transitionalDefaults;
      if (config.timeoutErrorMessage) {
        timeoutErrorMessage = config.timeoutErrorMessage;
      }
      reject(new AxiosError(timeoutErrorMessage, transitional.clarifyTimeoutError ? AxiosError.ETIMEDOUT : AxiosError.ECONNABORTED, config, request));

      // Clean up request
      request = null;
    };

    // Add xsrf header
    // This is only done if running in a standard browser environment.
    // Specifically not if we're in a web worker, or react-native.
    if (utils.isStandardBrowserEnv()) {
      // Add xsrf header
      var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ? cookies.read(config.xsrfCookieName) : undefined;
      if (xsrfValue) {
        requestHeaders[config.xsrfHeaderName] = xsrfValue;
      }
    }

    // Add headers to the request
    if ('setRequestHeader' in request) {
      utils.forEach(requestHeaders, function setRequestHeader(val, key) {
        if (typeof requestData === 'undefined' && key.toLowerCase() === 'content-type') {
          // Remove Content-Type if data is undefined
          delete requestHeaders[key];
        } else {
          // Otherwise add header to the request
          request.setRequestHeader(key, val);
        }
      });
    }

    // Add withCredentials to request if needed
    if (!utils.isUndefined(config.withCredentials)) {
      request.withCredentials = !!config.withCredentials;
    }

    // Add responseType to request if needed
    if (responseType && responseType !== 'json') {
      request.responseType = config.responseType;
    }

    // Handle progress if needed
    if (typeof config.onDownloadProgress === 'function') {
      request.addEventListener('progress', config.onDownloadProgress);
    }

    // Not all browsers support upload events
    if (typeof config.onUploadProgress === 'function' && request.upload) {
      request.upload.addEventListener('progress', config.onUploadProgress);
    }
    if (config.cancelToken || config.signal) {
      // Handle cancellation
      // eslint-disable-next-line func-names
      onCanceled = function onCanceled(cancel) {
        if (!request) {
          return;
        }
        reject(!cancel || cancel && cancel.type ? new CanceledError() : cancel);
        request.abort();
        request = null;
      };
      config.cancelToken && config.cancelToken.subscribe(onCanceled);
      if (config.signal) {
        config.signal.aborted ? onCanceled() : config.signal.addEventListener('abort', onCanceled);
      }
    }
    if (!requestData) {
      requestData = null;
    }
    var protocol = parseProtocol(fullPath);
    if (protocol && ['http', 'https', 'file'].indexOf(protocol) === -1) {
      reject(new AxiosError('Unsupported protocol ' + protocol + ':', AxiosError.ERR_BAD_REQUEST, config));
      return;
    }

    // Send the request
    request.send(requestData);
  });
};

/***/ }),

/***/ 5632:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
var bind = __webpack_require__(8197);
var Axios = __webpack_require__(6764);
var mergeConfig = __webpack_require__(1530);
var defaults = __webpack_require__(5015);

/**
 * Create an instance of Axios
 *
 * @param {Object} defaultConfig The default config for the instance
 * @return {Axios} A new instance of Axios
 */
function createInstance(defaultConfig) {
  var context = new Axios(defaultConfig);
  var instance = bind(Axios.prototype.request, context);

  // Copy axios.prototype to instance
  utils.extend(instance, Axios.prototype, context);

  // Copy context to instance
  utils.extend(instance, context);

  // Factory for creating new instances
  instance.create = function create(instanceConfig) {
    return createInstance(mergeConfig(defaultConfig, instanceConfig));
  };
  return instance;
}

// Create the default instance to be exported
var axios = createInstance(defaults);

// Expose Axios class to allow class inheritance
axios.Axios = Axios;

// Expose Cancel & CancelToken
axios.CanceledError = __webpack_require__(1259);
axios.CancelToken = __webpack_require__(1081);
axios.isCancel = __webpack_require__(7109);
axios.VERSION = (__webpack_require__(9137).version);
axios.toFormData = __webpack_require__(5257);

// Expose AxiosError class
axios.AxiosError = __webpack_require__(4808);

// alias for CanceledError for backward compatibility
axios.Cancel = axios.CanceledError;

// Expose all/spread
axios.all = function all(promises) {
  return Promise.all(promises);
};
axios.spread = __webpack_require__(1870);

// Expose isAxiosError
axios.isAxiosError = __webpack_require__(5754);
module.exports = axios;

// Allow use of default import syntax in TypeScript
module.exports["default"] = axios;

/***/ }),

/***/ 1081:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var CanceledError = __webpack_require__(1259);

/**
 * A `CancelToken` is an object that can be used to request cancellation of an operation.
 *
 * @class
 * @param {Function} executor The executor function.
 */
function CancelToken(executor) {
  if (typeof executor !== 'function') {
    throw new TypeError('executor must be a function.');
  }
  var resolvePromise;
  this.promise = new Promise(function promiseExecutor(resolve) {
    resolvePromise = resolve;
  });
  var token = this;

  // eslint-disable-next-line func-names
  this.promise.then(function (cancel) {
    if (!token._listeners) return;
    var i;
    var l = token._listeners.length;
    for (i = 0; i < l; i++) {
      token._listeners[i](cancel);
    }
    token._listeners = null;
  });

  // eslint-disable-next-line func-names
  this.promise.then = function (onfulfilled) {
    var _resolve;
    // eslint-disable-next-line func-names
    var promise = new Promise(function (resolve) {
      token.subscribe(resolve);
      _resolve = resolve;
    }).then(onfulfilled);
    promise.cancel = function reject() {
      token.unsubscribe(_resolve);
    };
    return promise;
  };
  executor(function cancel(message) {
    if (token.reason) {
      // Cancellation has already been requested
      return;
    }
    token.reason = new CanceledError(message);
    resolvePromise(token.reason);
  });
}

/**
 * Throws a `CanceledError` if cancellation has been requested.
 */
CancelToken.prototype.throwIfRequested = function throwIfRequested() {
  if (this.reason) {
    throw this.reason;
  }
};

/**
 * Subscribe to the cancel signal
 */

CancelToken.prototype.subscribe = function subscribe(listener) {
  if (this.reason) {
    listener(this.reason);
    return;
  }
  if (this._listeners) {
    this._listeners.push(listener);
  } else {
    this._listeners = [listener];
  }
};

/**
 * Unsubscribe from the cancel signal
 */

CancelToken.prototype.unsubscribe = function unsubscribe(listener) {
  if (!this._listeners) {
    return;
  }
  var index = this._listeners.indexOf(listener);
  if (index !== -1) {
    this._listeners.splice(index, 1);
  }
};

/**
 * Returns an object that contains a new `CancelToken` and a function that, when called,
 * cancels the `CancelToken`.
 */
CancelToken.source = function source() {
  var cancel;
  var token = new CancelToken(function executor(c) {
    cancel = c;
  });
  return {
    token: token,
    cancel: cancel
  };
};
module.exports = CancelToken;

/***/ }),

/***/ 1259:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var AxiosError = __webpack_require__(4808);
var utils = __webpack_require__(5666);

/**
 * A `CanceledError` is an object that is thrown when an operation is canceled.
 *
 * @class
 * @param {string=} message The message.
 */
function CanceledError(message) {
  // eslint-disable-next-line no-eq-null,eqeqeq
  AxiosError.call(this, message == null ? 'canceled' : message, AxiosError.ERR_CANCELED);
  this.name = 'CanceledError';
}
utils.inherits(CanceledError, AxiosError, {
  __CANCEL__: true
});
module.exports = CanceledError;

/***/ }),

/***/ 7109:
/***/ (function(module) {

"use strict";


module.exports = function isCancel(value) {
  return !!(value && value.__CANCEL__);
};

/***/ }),

/***/ 6764:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
var buildURL = __webpack_require__(1971);
var InterceptorManager = __webpack_require__(1820);
var dispatchRequest = __webpack_require__(3506);
var mergeConfig = __webpack_require__(1530);
var buildFullPath = __webpack_require__(8251);
var validator = __webpack_require__(4544);
var validators = validator.validators;
/**
 * Create a new instance of Axios
 *
 * @param {Object} instanceConfig The default config for the instance
 */
function Axios(instanceConfig) {
  this.defaults = instanceConfig;
  this.interceptors = {
    request: new InterceptorManager(),
    response: new InterceptorManager()
  };
}

/**
 * Dispatch a request
 *
 * @param {Object} config The config specific for this request (merged with this.defaults)
 */
Axios.prototype.request = function request(configOrUrl, config) {
  /*eslint no-param-reassign:0*/
  // Allow for axios('example/url'[, config]) a la fetch API
  if (typeof configOrUrl === 'string') {
    config = config || {};
    config.url = configOrUrl;
  } else {
    config = configOrUrl || {};
  }
  config = mergeConfig(this.defaults, config);

  // Set config.method
  if (config.method) {
    config.method = config.method.toLowerCase();
  } else if (this.defaults.method) {
    config.method = this.defaults.method.toLowerCase();
  } else {
    config.method = 'get';
  }
  var transitional = config.transitional;
  if (transitional !== undefined) {
    validator.assertOptions(transitional, {
      silentJSONParsing: validators.transitional(validators.boolean),
      forcedJSONParsing: validators.transitional(validators.boolean),
      clarifyTimeoutError: validators.transitional(validators.boolean)
    }, false);
  }

  // filter out skipped interceptors
  var requestInterceptorChain = [];
  var synchronousRequestInterceptors = true;
  this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
    if (typeof interceptor.runWhen === 'function' && interceptor.runWhen(config) === false) {
      return;
    }
    synchronousRequestInterceptors = synchronousRequestInterceptors && interceptor.synchronous;
    requestInterceptorChain.unshift(interceptor.fulfilled, interceptor.rejected);
  });
  var responseInterceptorChain = [];
  this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
    responseInterceptorChain.push(interceptor.fulfilled, interceptor.rejected);
  });
  var promise;
  if (!synchronousRequestInterceptors) {
    var chain = [dispatchRequest, undefined];
    Array.prototype.unshift.apply(chain, requestInterceptorChain);
    chain = chain.concat(responseInterceptorChain);
    promise = Promise.resolve(config);
    while (chain.length) {
      promise = promise.then(chain.shift(), chain.shift());
    }
    return promise;
  }
  var newConfig = config;
  while (requestInterceptorChain.length) {
    var onFulfilled = requestInterceptorChain.shift();
    var onRejected = requestInterceptorChain.shift();
    try {
      newConfig = onFulfilled(newConfig);
    } catch (error) {
      onRejected(error);
      break;
    }
  }
  try {
    promise = dispatchRequest(newConfig);
  } catch (error) {
    return Promise.reject(error);
  }
  while (responseInterceptorChain.length) {
    promise = promise.then(responseInterceptorChain.shift(), responseInterceptorChain.shift());
  }
  return promise;
};
Axios.prototype.getUri = function getUri(config) {
  config = mergeConfig(this.defaults, config);
  var fullPath = buildFullPath(config.baseURL, config.url);
  return buildURL(fullPath, config.params, config.paramsSerializer);
};

// Provide aliases for supported request methods
utils.forEach(['delete', 'get', 'head', 'options'], function forEachMethodNoData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function (url, config) {
    return this.request(mergeConfig(config || {}, {
      method: method,
      url: url,
      data: (config || {}).data
    }));
  };
});
utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  /*eslint func-names:0*/

  function generateHTTPMethod(isForm) {
    return function httpMethod(url, data, config) {
      return this.request(mergeConfig(config || {}, {
        method: method,
        headers: isForm ? {
          'Content-Type': 'multipart/form-data'
        } : {},
        url: url,
        data: data
      }));
    };
  }
  Axios.prototype[method] = generateHTTPMethod();
  Axios.prototype[method + 'Form'] = generateHTTPMethod(true);
});
module.exports = Axios;

/***/ }),

/***/ 4808:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);

/**
 * Create an Error with the specified message, config, error code, request and response.
 *
 * @param {string} message The error message.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [config] The config.
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The created error.
 */
function AxiosError(message, code, config, request, response) {
  Error.call(this);
  this.message = message;
  this.name = 'AxiosError';
  code && (this.code = code);
  config && (this.config = config);
  request && (this.request = request);
  response && (this.response = response);
}
utils.inherits(AxiosError, Error, {
  toJSON: function toJSON() {
    return {
      // Standard
      message: this.message,
      name: this.name,
      // Microsoft
      description: this.description,
      number: this.number,
      // Mozilla
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      // Axios
      config: this.config,
      code: this.code,
      status: this.response && this.response.status ? this.response.status : null
    };
  }
});
var prototype = AxiosError.prototype;
var descriptors = {};
['ERR_BAD_OPTION_VALUE', 'ERR_BAD_OPTION', 'ECONNABORTED', 'ETIMEDOUT', 'ERR_NETWORK', 'ERR_FR_TOO_MANY_REDIRECTS', 'ERR_DEPRECATED', 'ERR_BAD_RESPONSE', 'ERR_BAD_REQUEST', 'ERR_CANCELED'
// eslint-disable-next-line func-names
].forEach(function (code) {
  descriptors[code] = {
    value: code
  };
});
Object.defineProperties(AxiosError, descriptors);
Object.defineProperty(prototype, 'isAxiosError', {
  value: true
});

// eslint-disable-next-line func-names
AxiosError.from = function (error, code, config, request, response, customProps) {
  var axiosError = Object.create(prototype);
  utils.toFlatObject(error, axiosError, function filter(obj) {
    return obj !== Error.prototype;
  });
  AxiosError.call(axiosError, error.message, code, config, request, response);
  axiosError.name = error.name;
  customProps && Object.assign(axiosError, customProps);
  return axiosError;
};
module.exports = AxiosError;

/***/ }),

/***/ 1820:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
function InterceptorManager() {
  this.handlers = [];
}

/**
 * Add a new interceptor to the stack
 *
 * @param {Function} fulfilled The function to handle `then` for a `Promise`
 * @param {Function} rejected The function to handle `reject` for a `Promise`
 *
 * @return {Number} An ID used to remove interceptor later
 */
InterceptorManager.prototype.use = function use(fulfilled, rejected, options) {
  this.handlers.push({
    fulfilled: fulfilled,
    rejected: rejected,
    synchronous: options ? options.synchronous : false,
    runWhen: options ? options.runWhen : null
  });
  return this.handlers.length - 1;
};

/**
 * Remove an interceptor from the stack
 *
 * @param {Number} id The ID that was returned by `use`
 */
InterceptorManager.prototype.eject = function eject(id) {
  if (this.handlers[id]) {
    this.handlers[id] = null;
  }
};

/**
 * Iterate over all the registered interceptors
 *
 * This method is particularly useful for skipping over any
 * interceptors that may have become `null` calling `eject`.
 *
 * @param {Function} fn The function to call for each interceptor
 */
InterceptorManager.prototype.forEach = function forEach(fn) {
  utils.forEach(this.handlers, function forEachHandler(h) {
    if (h !== null) {
      fn(h);
    }
  });
};
module.exports = InterceptorManager;

/***/ }),

/***/ 8251:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var isAbsoluteURL = __webpack_require__(7001);
var combineURLs = __webpack_require__(4851);

/**
 * Creates a new URL by combining the baseURL with the requestedURL,
 * only when the requestedURL is not already an absolute URL.
 * If the requestURL is absolute, this function returns the requestedURL untouched.
 *
 * @param {string} baseURL The base URL
 * @param {string} requestedURL Absolute or relative URL to combine
 * @returns {string} The combined full path
 */
module.exports = function buildFullPath(baseURL, requestedURL) {
  if (baseURL && !isAbsoluteURL(requestedURL)) {
    return combineURLs(baseURL, requestedURL);
  }
  return requestedURL;
};

/***/ }),

/***/ 3506:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
var transformData = __webpack_require__(2886);
var isCancel = __webpack_require__(7109);
var defaults = __webpack_require__(5015);
var CanceledError = __webpack_require__(1259);

/**
 * Throws a `CanceledError` if cancellation has been requested.
 */
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
  if (config.signal && config.signal.aborted) {
    throw new CanceledError();
  }
}

/**
 * Dispatch a request to the server using the configured adapter.
 *
 * @param {object} config The config that is to be used for the request
 * @returns {Promise} The Promise to be fulfilled
 */
module.exports = function dispatchRequest(config) {
  throwIfCancellationRequested(config);

  // Ensure headers exist
  config.headers = config.headers || {};

  // Transform request data
  config.data = transformData.call(config, config.data, config.headers, config.transformRequest);

  // Flatten headers
  config.headers = utils.merge(config.headers.common || {}, config.headers[config.method] || {}, config.headers);
  utils.forEach(['delete', 'get', 'head', 'post', 'put', 'patch', 'common'], function cleanHeaderConfig(method) {
    delete config.headers[method];
  });
  var adapter = config.adapter || defaults.adapter;
  return adapter(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);

    // Transform response data
    response.data = transformData.call(config, response.data, response.headers, config.transformResponse);
    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel(reason)) {
      throwIfCancellationRequested(config);

      // Transform response data
      if (reason && reason.response) {
        reason.response.data = transformData.call(config, reason.response.data, reason.response.headers, config.transformResponse);
      }
    }
    return Promise.reject(reason);
  });
};

/***/ }),

/***/ 1530:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);

/**
 * Config-specific merge-function which creates a new config-object
 * by merging two configuration objects together.
 *
 * @param {Object} config1
 * @param {Object} config2
 * @returns {Object} New object resulting from merging config2 to config1
 */
module.exports = function mergeConfig(config1, config2) {
  // eslint-disable-next-line no-param-reassign
  config2 = config2 || {};
  var config = {};
  function getMergedValue(target, source) {
    if (utils.isPlainObject(target) && utils.isPlainObject(source)) {
      return utils.merge(target, source);
    } else if (utils.isPlainObject(source)) {
      return utils.merge({}, source);
    } else if (utils.isArray(source)) {
      return source.slice();
    }
    return source;
  }

  // eslint-disable-next-line consistent-return
  function mergeDeepProperties(prop) {
    if (!utils.isUndefined(config2[prop])) {
      return getMergedValue(config1[prop], config2[prop]);
    } else if (!utils.isUndefined(config1[prop])) {
      return getMergedValue(undefined, config1[prop]);
    }
  }

  // eslint-disable-next-line consistent-return
  function valueFromConfig2(prop) {
    if (!utils.isUndefined(config2[prop])) {
      return getMergedValue(undefined, config2[prop]);
    }
  }

  // eslint-disable-next-line consistent-return
  function defaultToConfig2(prop) {
    if (!utils.isUndefined(config2[prop])) {
      return getMergedValue(undefined, config2[prop]);
    } else if (!utils.isUndefined(config1[prop])) {
      return getMergedValue(undefined, config1[prop]);
    }
  }

  // eslint-disable-next-line consistent-return
  function mergeDirectKeys(prop) {
    if (prop in config2) {
      return getMergedValue(config1[prop], config2[prop]);
    } else if (prop in config1) {
      return getMergedValue(undefined, config1[prop]);
    }
  }
  var mergeMap = {
    'url': valueFromConfig2,
    'method': valueFromConfig2,
    'data': valueFromConfig2,
    'baseURL': defaultToConfig2,
    'transformRequest': defaultToConfig2,
    'transformResponse': defaultToConfig2,
    'paramsSerializer': defaultToConfig2,
    'timeout': defaultToConfig2,
    'timeoutMessage': defaultToConfig2,
    'withCredentials': defaultToConfig2,
    'adapter': defaultToConfig2,
    'responseType': defaultToConfig2,
    'xsrfCookieName': defaultToConfig2,
    'xsrfHeaderName': defaultToConfig2,
    'onUploadProgress': defaultToConfig2,
    'onDownloadProgress': defaultToConfig2,
    'decompress': defaultToConfig2,
    'maxContentLength': defaultToConfig2,
    'maxBodyLength': defaultToConfig2,
    'beforeRedirect': defaultToConfig2,
    'transport': defaultToConfig2,
    'httpAgent': defaultToConfig2,
    'httpsAgent': defaultToConfig2,
    'cancelToken': defaultToConfig2,
    'socketPath': defaultToConfig2,
    'responseEncoding': defaultToConfig2,
    'validateStatus': mergeDirectKeys
  };
  utils.forEach(Object.keys(config1).concat(Object.keys(config2)), function computeConfigValue(prop) {
    var merge = mergeMap[prop] || mergeDeepProperties;
    var configValue = merge(prop);
    utils.isUndefined(configValue) && merge !== mergeDirectKeys || (config[prop] = configValue);
  });
  return config;
};

/***/ }),

/***/ 494:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var AxiosError = __webpack_require__(4808);

/**
 * Resolve or reject a Promise based on response status.
 *
 * @param {Function} resolve A function that resolves the promise.
 * @param {Function} reject A function that rejects the promise.
 * @param {object} response The response.
 */
module.exports = function settle(resolve, reject, response) {
  var validateStatus = response.config.validateStatus;
  if (!response.status || !validateStatus || validateStatus(response.status)) {
    resolve(response);
  } else {
    reject(new AxiosError('Request failed with status code ' + response.status, [AxiosError.ERR_BAD_REQUEST, AxiosError.ERR_BAD_RESPONSE][Math.floor(response.status / 100) - 4], response.config, response.request, response));
  }
};

/***/ }),

/***/ 2886:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
var defaults = __webpack_require__(5015);

/**
 * Transform the data for a request or a response
 *
 * @param {Object|String} data The data to be transformed
 * @param {Array} headers The headers for the request or response
 * @param {Array|Function} fns A single function or Array of functions
 * @returns {*} The resulting transformed data
 */
module.exports = function transformData(data, headers, fns) {
  var context = this || defaults;
  /*eslint no-param-reassign:0*/
  utils.forEach(fns, function transform(fn) {
    data = fn.call(context, data, headers);
  });
  return data;
};

/***/ }),

/***/ 5015:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
var normalizeHeaderName = __webpack_require__(9546);
var AxiosError = __webpack_require__(4808);
var transitionalDefaults = __webpack_require__(617);
var toFormData = __webpack_require__(5257);
var DEFAULT_CONTENT_TYPE = {
  'Content-Type': 'application/x-www-form-urlencoded'
};
function setContentTypeIfUnset(headers, value) {
  if (!utils.isUndefined(headers) && utils.isUndefined(headers['Content-Type'])) {
    headers['Content-Type'] = value;
  }
}
function getDefaultAdapter() {
  var adapter;
  if (typeof XMLHttpRequest !== 'undefined') {
    // For browsers use XHR adapter
    adapter = __webpack_require__(556);
  } else if (typeof process !== 'undefined' && Object.prototype.toString.call(process) === '[object process]') {
    // For node use HTTP adapter
    adapter = __webpack_require__(556);
  }
  return adapter;
}
function stringifySafely(rawValue, parser, encoder) {
  if (utils.isString(rawValue)) {
    try {
      (parser || JSON.parse)(rawValue);
      return utils.trim(rawValue);
    } catch (e) {
      if (e.name !== 'SyntaxError') {
        throw e;
      }
    }
  }
  return (encoder || JSON.stringify)(rawValue);
}
var defaults = {
  transitional: transitionalDefaults,
  adapter: getDefaultAdapter(),
  transformRequest: [function transformRequest(data, headers) {
    normalizeHeaderName(headers, 'Accept');
    normalizeHeaderName(headers, 'Content-Type');
    if (utils.isFormData(data) || utils.isArrayBuffer(data) || utils.isBuffer(data) || utils.isStream(data) || utils.isFile(data) || utils.isBlob(data)) {
      return data;
    }
    if (utils.isArrayBufferView(data)) {
      return data.buffer;
    }
    if (utils.isURLSearchParams(data)) {
      setContentTypeIfUnset(headers, 'application/x-www-form-urlencoded;charset=utf-8');
      return data.toString();
    }
    var isObjectPayload = utils.isObject(data);
    var contentType = headers && headers['Content-Type'];
    var isFileList;
    if ((isFileList = utils.isFileList(data)) || isObjectPayload && contentType === 'multipart/form-data') {
      var _FormData = this.env && this.env.FormData;
      return toFormData(isFileList ? {
        'files[]': data
      } : data, _FormData && new _FormData());
    } else if (isObjectPayload || contentType === 'application/json') {
      setContentTypeIfUnset(headers, 'application/json');
      return stringifySafely(data);
    }
    return data;
  }],
  transformResponse: [function transformResponse(data) {
    var transitional = this.transitional || defaults.transitional;
    var silentJSONParsing = transitional && transitional.silentJSONParsing;
    var forcedJSONParsing = transitional && transitional.forcedJSONParsing;
    var strictJSONParsing = !silentJSONParsing && this.responseType === 'json';
    if (strictJSONParsing || forcedJSONParsing && utils.isString(data) && data.length) {
      try {
        return JSON.parse(data);
      } catch (e) {
        if (strictJSONParsing) {
          if (e.name === 'SyntaxError') {
            throw AxiosError.from(e, AxiosError.ERR_BAD_RESPONSE, this, null, this.response);
          }
          throw e;
        }
      }
    }
    return data;
  }],
  /**
   * A timeout in milliseconds to abort a request. If set to 0 (default) a
   * timeout is not created.
   */
  timeout: 0,
  xsrfCookieName: 'XSRF-TOKEN',
  xsrfHeaderName: 'X-XSRF-TOKEN',
  maxContentLength: -1,
  maxBodyLength: -1,
  env: {
    FormData: __webpack_require__(2762)
  },
  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  },
  headers: {
    common: {
      'Accept': 'application/json, text/plain, */*'
    }
  }
};
utils.forEach(['delete', 'get', 'head'], function forEachMethodNoData(method) {
  defaults.headers[method] = {};
});
utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);
});
module.exports = defaults;

/***/ }),

/***/ 617:
/***/ (function(module) {

"use strict";


module.exports = {
  silentJSONParsing: true,
  forcedJSONParsing: true,
  clarifyTimeoutError: false
};

/***/ }),

/***/ 9137:
/***/ (function(module) {

module.exports = {
  "version": "0.27.2"
};

/***/ }),

/***/ 8197:
/***/ (function(module) {

"use strict";


module.exports = function bind(fn, thisArg) {
  return function wrap() {
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }
    return fn.apply(thisArg, args);
  };
};

/***/ }),

/***/ 1971:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
function encode(val) {
  return encodeURIComponent(val).replace(/%3A/gi, ':').replace(/%24/g, '$').replace(/%2C/gi, ',').replace(/%20/g, '+').replace(/%5B/gi, '[').replace(/%5D/gi, ']');
}

/**
 * Build a URL by appending params to the end
 *
 * @param {string} url The base of the url (e.g., http://www.google.com)
 * @param {object} [params] The params to be appended
 * @returns {string} The formatted url
 */
module.exports = function buildURL(url, params, paramsSerializer) {
  /*eslint no-param-reassign:0*/
  if (!params) {
    return url;
  }
  var serializedParams;
  if (paramsSerializer) {
    serializedParams = paramsSerializer(params);
  } else if (utils.isURLSearchParams(params)) {
    serializedParams = params.toString();
  } else {
    var parts = [];
    utils.forEach(params, function serialize(val, key) {
      if (val === null || typeof val === 'undefined') {
        return;
      }
      if (utils.isArray(val)) {
        key = key + '[]';
      } else {
        val = [val];
      }
      utils.forEach(val, function parseValue(v) {
        if (utils.isDate(v)) {
          v = v.toISOString();
        } else if (utils.isObject(v)) {
          v = JSON.stringify(v);
        }
        parts.push(encode(key) + '=' + encode(v));
      });
    });
    serializedParams = parts.join('&');
  }
  if (serializedParams) {
    var hashmarkIndex = url.indexOf('#');
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }
    url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;
  }
  return url;
};

/***/ }),

/***/ 4851:
/***/ (function(module) {

"use strict";


/**
 * Creates a new URL by combining the specified URLs
 *
 * @param {string} baseURL The base URL
 * @param {string} relativeURL The relative URL
 * @returns {string} The combined URL
 */
module.exports = function combineURLs(baseURL, relativeURL) {
  return relativeURL ? baseURL.replace(/\/+$/, '') + '/' + relativeURL.replace(/^\/+/, '') : baseURL;
};

/***/ }),

/***/ 8861:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
module.exports = utils.isStandardBrowserEnv() ?
// Standard browser envs support document.cookie
function standardBrowserEnv() {
  return {
    write: function write(name, value, expires, path, domain, secure) {
      var cookie = [];
      cookie.push(name + '=' + encodeURIComponent(value));
      if (utils.isNumber(expires)) {
        cookie.push('expires=' + new Date(expires).toGMTString());
      }
      if (utils.isString(path)) {
        cookie.push('path=' + path);
      }
      if (utils.isString(domain)) {
        cookie.push('domain=' + domain);
      }
      if (secure === true) {
        cookie.push('secure');
      }
      document.cookie = cookie.join('; ');
    },
    read: function read(name) {
      var match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));
      return match ? decodeURIComponent(match[3]) : null;
    },
    remove: function remove(name) {
      this.write(name, '', Date.now() - 86400000);
    }
  };
}() :
// Non standard browser env (web workers, react-native) lack needed support.
function nonStandardBrowserEnv() {
  return {
    write: function write() {},
    read: function read() {
      return null;
    },
    remove: function remove() {}
  };
}();

/***/ }),

/***/ 7001:
/***/ (function(module) {

"use strict";


/**
 * Determines whether the specified URL is absolute
 *
 * @param {string} url The URL to test
 * @returns {boolean} True if the specified URL is absolute, otherwise false
 */
module.exports = function isAbsoluteURL(url) {
  // A URL is considered absolute if it begins with "<scheme>://" or "//" (protocol-relative URL).
  // RFC 3986 defines scheme name as a sequence of characters beginning with a letter and followed
  // by any combination of letters, digits, plus, period, or hyphen.
  return /^([a-z][a-z\d+\-.]*:)?\/\//i.test(url);
};

/***/ }),

/***/ 5754:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);

/**
 * Determines whether the payload is an error thrown by Axios
 *
 * @param {*} payload The value to test
 * @returns {boolean} True if the payload is an error thrown by Axios, otherwise false
 */
module.exports = function isAxiosError(payload) {
  return utils.isObject(payload) && payload.isAxiosError === true;
};

/***/ }),

/***/ 7858:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
module.exports = utils.isStandardBrowserEnv() ?
// Standard browser envs have full support of the APIs needed to test
// whether the request URL is of the same origin as current location.
function standardBrowserEnv() {
  var msie = /(msie|trident)/i.test(navigator.userAgent);
  var urlParsingNode = document.createElement('a');
  var originURL;

  /**
  * Parse a URL to discover it's components
  *
  * @param {String} url The URL to be parsed
  * @returns {Object}
  */
  function resolveURL(url) {
    var href = url;
    if (msie) {
      // IE needs attribute set twice to normalize properties
      urlParsingNode.setAttribute('href', href);
      href = urlParsingNode.href;
    }
    urlParsingNode.setAttribute('href', href);

    // urlParsingNode provides the UrlUtils interface - http://url.spec.whatwg.org/#urlutils
    return {
      href: urlParsingNode.href,
      protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, '') : '',
      host: urlParsingNode.host,
      search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, '') : '',
      hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, '') : '',
      hostname: urlParsingNode.hostname,
      port: urlParsingNode.port,
      pathname: urlParsingNode.pathname.charAt(0) === '/' ? urlParsingNode.pathname : '/' + urlParsingNode.pathname
    };
  }
  originURL = resolveURL(window.location.href);

  /**
  * Determine if a URL shares the same origin as the current location
  *
  * @param {String} requestURL The URL to test
  * @returns {boolean} True if URL shares the same origin, otherwise false
  */
  return function isURLSameOrigin(requestURL) {
    var parsed = utils.isString(requestURL) ? resolveURL(requestURL) : requestURL;
    return parsed.protocol === originURL.protocol && parsed.host === originURL.host;
  };
}() :
// Non standard browser envs (web workers, react-native) lack needed support.
function nonStandardBrowserEnv() {
  return function isURLSameOrigin() {
    return true;
  };
}();

/***/ }),

/***/ 9546:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);
module.exports = function normalizeHeaderName(headers, normalizedName) {
  utils.forEach(headers, function processHeader(value, name) {
    if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
      headers[normalizedName] = value;
      delete headers[name];
    }
  });
};

/***/ }),

/***/ 2762:
/***/ (function(module) {

// eslint-disable-next-line strict
module.exports = null;

/***/ }),

/***/ 5283:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);

// Headers whose duplicates are ignored by node
// c.f. https://nodejs.org/api/http.html#http_message_headers
var ignoreDuplicateOf = ['age', 'authorization', 'content-length', 'content-type', 'etag', 'expires', 'from', 'host', 'if-modified-since', 'if-unmodified-since', 'last-modified', 'location', 'max-forwards', 'proxy-authorization', 'referer', 'retry-after', 'user-agent'];

/**
 * Parse headers into an object
 *
 * ```
 * Date: Wed, 27 Aug 2014 08:58:49 GMT
 * Content-Type: application/json
 * Connection: keep-alive
 * Transfer-Encoding: chunked
 * ```
 *
 * @param {String} headers Headers needing to be parsed
 * @returns {Object} Headers parsed into an object
 */
module.exports = function parseHeaders(headers) {
  var parsed = {};
  var key;
  var val;
  var i;
  if (!headers) {
    return parsed;
  }
  utils.forEach(headers.split('\n'), function parser(line) {
    i = line.indexOf(':');
    key = utils.trim(line.substr(0, i)).toLowerCase();
    val = utils.trim(line.substr(i + 1));
    if (key) {
      if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
        return;
      }
      if (key === 'set-cookie') {
        parsed[key] = (parsed[key] ? parsed[key] : []).concat([val]);
      } else {
        parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;
      }
    }
  });
  return parsed;
};

/***/ }),

/***/ 8499:
/***/ (function(module) {

"use strict";


module.exports = function parseProtocol(url) {
  var match = /^([-+\w]{1,25})(:?\/\/|:)/.exec(url);
  return match && match[1] || '';
};

/***/ }),

/***/ 1870:
/***/ (function(module) {

"use strict";


/**
 * Syntactic sugar for invoking a function and expanding an array for arguments.
 *
 * Common use case would be to use `Function.prototype.apply`.
 *
 *  ```js
 *  function f(x, y, z) {}
 *  var args = [1, 2, 3];
 *  f.apply(null, args);
 *  ```
 *
 * With `spread` this example can be re-written.
 *
 *  ```js
 *  spread(function(x, y, z) {})([1, 2, 3]);
 *  ```
 *
 * @param {Function} callback
 * @returns {Function}
 */
module.exports = function spread(callback) {
  return function wrap(arr) {
    return callback.apply(null, arr);
  };
};

/***/ }),

/***/ 5257:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(5666);

/**
 * Convert a data object to FormData
 * @param {Object} obj
 * @param {?Object} [formData]
 * @returns {Object}
 **/

function toFormData(obj, formData) {
  // eslint-disable-next-line no-param-reassign
  formData = formData || new FormData();
  var stack = [];
  function convertValue(value) {
    if (value === null) return '';
    if (utils.isDate(value)) {
      return value.toISOString();
    }
    if (utils.isArrayBuffer(value) || utils.isTypedArray(value)) {
      return typeof Blob === 'function' ? new Blob([value]) : Buffer.from(value);
    }
    return value;
  }
  function build(data, parentKey) {
    if (utils.isPlainObject(data) || utils.isArray(data)) {
      if (stack.indexOf(data) !== -1) {
        throw Error('Circular reference detected in ' + parentKey);
      }
      stack.push(data);
      utils.forEach(data, function each(value, key) {
        if (utils.isUndefined(value)) return;
        var fullKey = parentKey ? parentKey + '.' + key : key;
        var arr;
        if (value && !parentKey && typeof value === 'object') {
          if (utils.endsWith(key, '{}')) {
            // eslint-disable-next-line no-param-reassign
            value = JSON.stringify(value);
          } else if (utils.endsWith(key, '[]') && (arr = utils.toArray(value))) {
            // eslint-disable-next-line func-names
            arr.forEach(function (el) {
              !utils.isUndefined(el) && formData.append(fullKey, convertValue(el));
            });
            return;
          }
        }
        build(value, fullKey);
      });
      stack.pop();
    } else {
      formData.append(parentKey, convertValue(data));
    }
  }
  build(obj);
  return formData;
}
module.exports = toFormData;

/***/ }),

/***/ 4544:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var VERSION = (__webpack_require__(9137).version);
var AxiosError = __webpack_require__(4808);
var validators = {};

// eslint-disable-next-line func-names
['object', 'boolean', 'number', 'function', 'string', 'symbol'].forEach(function (type, i) {
  validators[type] = function validator(thing) {
    return typeof thing === type || 'a' + (i < 1 ? 'n ' : ' ') + type;
  };
});
var deprecatedWarnings = {};

/**
 * Transitional option validator
 * @param {function|boolean?} validator - set to false if the transitional option has been removed
 * @param {string?} version - deprecated version / removed since version
 * @param {string?} message - some message with additional info
 * @returns {function}
 */
validators.transitional = function transitional(validator, version, message) {
  function formatMessage(opt, desc) {
    return '[Axios v' + VERSION + '] Transitional option \'' + opt + '\'' + desc + (message ? '. ' + message : '');
  }

  // eslint-disable-next-line func-names
  return function (value, opt, opts) {
    if (validator === false) {
      throw new AxiosError(formatMessage(opt, ' has been removed' + (version ? ' in ' + version : '')), AxiosError.ERR_DEPRECATED);
    }
    if (version && !deprecatedWarnings[opt]) {
      deprecatedWarnings[opt] = true;
      // eslint-disable-next-line no-console
      console.warn(formatMessage(opt, ' has been deprecated since v' + version + ' and will be removed in the near future'));
    }
    return validator ? validator(value, opt, opts) : true;
  };
};

/**
 * Assert object's properties type
 * @param {object} options
 * @param {object} schema
 * @param {boolean?} allowUnknown
 */

function assertOptions(options, schema, allowUnknown) {
  if (typeof options !== 'object') {
    throw new AxiosError('options must be an object', AxiosError.ERR_BAD_OPTION_VALUE);
  }
  var keys = Object.keys(options);
  var i = keys.length;
  while (i-- > 0) {
    var opt = keys[i];
    var validator = schema[opt];
    if (validator) {
      var value = options[opt];
      var result = value === undefined || validator(value, opt, options);
      if (result !== true) {
        throw new AxiosError('option ' + opt + ' must be ' + result, AxiosError.ERR_BAD_OPTION_VALUE);
      }
      continue;
    }
    if (allowUnknown !== true) {
      throw new AxiosError('Unknown option ' + opt, AxiosError.ERR_BAD_OPTION);
    }
  }
}
module.exports = {
  assertOptions: assertOptions,
  validators: validators
};

/***/ }),

/***/ 5666:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var bind = __webpack_require__(8197);

// utils is a library of generic helper functions non-specific to axios

var toString = Object.prototype.toString;

// eslint-disable-next-line func-names
var kindOf = function (cache) {
  // eslint-disable-next-line func-names
  return function (thing) {
    var str = toString.call(thing);
    return cache[str] || (cache[str] = str.slice(8, -1).toLowerCase());
  };
}(Object.create(null));
function kindOfTest(type) {
  type = type.toLowerCase();
  return function isKindOf(thing) {
    return kindOf(thing) === type;
  };
}

/**
 * Determine if a value is an Array
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Array, otherwise false
 */
function isArray(val) {
  return Array.isArray(val);
}

/**
 * Determine if a value is undefined
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if the value is undefined, otherwise false
 */
function isUndefined(val) {
  return typeof val === 'undefined';
}

/**
 * Determine if a value is a Buffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Buffer, otherwise false
 */
function isBuffer(val) {
  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor) && typeof val.constructor.isBuffer === 'function' && val.constructor.isBuffer(val);
}

/**
 * Determine if a value is an ArrayBuffer
 *
 * @function
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an ArrayBuffer, otherwise false
 */
var isArrayBuffer = kindOfTest('ArrayBuffer');

/**
 * Determine if a value is a view on an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a view on an ArrayBuffer, otherwise false
 */
function isArrayBufferView(val) {
  var result;
  if (typeof ArrayBuffer !== 'undefined' && ArrayBuffer.isView) {
    result = ArrayBuffer.isView(val);
  } else {
    result = val && val.buffer && isArrayBuffer(val.buffer);
  }
  return result;
}

/**
 * Determine if a value is a String
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a String, otherwise false
 */
function isString(val) {
  return typeof val === 'string';
}

/**
 * Determine if a value is a Number
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Number, otherwise false
 */
function isNumber(val) {
  return typeof val === 'number';
}

/**
 * Determine if a value is an Object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Object, otherwise false
 */
function isObject(val) {
  return val !== null && typeof val === 'object';
}

/**
 * Determine if a value is a plain Object
 *
 * @param {Object} val The value to test
 * @return {boolean} True if value is a plain Object, otherwise false
 */
function isPlainObject(val) {
  if (kindOf(val) !== 'object') {
    return false;
  }
  var prototype = Object.getPrototypeOf(val);
  return prototype === null || prototype === Object.prototype;
}

/**
 * Determine if a value is a Date
 *
 * @function
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Date, otherwise false
 */
var isDate = kindOfTest('Date');

/**
 * Determine if a value is a File
 *
 * @function
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a File, otherwise false
 */
var isFile = kindOfTest('File');

/**
 * Determine if a value is a Blob
 *
 * @function
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Blob, otherwise false
 */
var isBlob = kindOfTest('Blob');

/**
 * Determine if a value is a FileList
 *
 * @function
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a File, otherwise false
 */
var isFileList = kindOfTest('FileList');

/**
 * Determine if a value is a Function
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Function, otherwise false
 */
function isFunction(val) {
  return toString.call(val) === '[object Function]';
}

/**
 * Determine if a value is a Stream
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Stream, otherwise false
 */
function isStream(val) {
  return isObject(val) && isFunction(val.pipe);
}

/**
 * Determine if a value is a FormData
 *
 * @param {Object} thing The value to test
 * @returns {boolean} True if value is an FormData, otherwise false
 */
function isFormData(thing) {
  var pattern = '[object FormData]';
  return thing && (typeof FormData === 'function' && thing instanceof FormData || toString.call(thing) === pattern || isFunction(thing.toString) && thing.toString() === pattern);
}

/**
 * Determine if a value is a URLSearchParams object
 * @function
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a URLSearchParams object, otherwise false
 */
var isURLSearchParams = kindOfTest('URLSearchParams');

/**
 * Trim excess whitespace off the beginning and end of a string
 *
 * @param {String} str The String to trim
 * @returns {String} The String freed of excess whitespace
 */
function trim(str) {
  return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g, '');
}

/**
 * Determine if we're running in a standard browser environment
 *
 * This allows axios to run in a web worker, and react-native.
 * Both environments support XMLHttpRequest, but not fully standard globals.
 *
 * web workers:
 *  typeof window -> undefined
 *  typeof document -> undefined
 *
 * react-native:
 *  navigator.product -> 'ReactNative'
 * nativescript
 *  navigator.product -> 'NativeScript' or 'NS'
 */
function isStandardBrowserEnv() {
  if (typeof navigator !== 'undefined' && (navigator.product === 'ReactNative' || navigator.product === 'NativeScript' || navigator.product === 'NS')) {
    return false;
  }
  return typeof window !== 'undefined' && typeof document !== 'undefined';
}

/**
 * Iterate over an Array or an Object invoking a function for each item.
 *
 * If `obj` is an Array callback will be called passing
 * the value, index, and complete array for each item.
 *
 * If 'obj' is an Object callback will be called passing
 * the value, key, and complete object for each property.
 *
 * @param {Object|Array} obj The object to iterate
 * @param {Function} fn The callback to invoke for each item
 */
function forEach(obj, fn) {
  // Don't bother if no value provided
  if (obj === null || typeof obj === 'undefined') {
    return;
  }

  // Force an array if not already something iterable
  if (typeof obj !== 'object') {
    /*eslint no-param-reassign:0*/
    obj = [obj];
  }
  if (isArray(obj)) {
    // Iterate over array values
    for (var i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    // Iterate over object keys
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        fn.call(null, obj[key], key, obj);
      }
    }
  }
}

/**
 * Accepts varargs expecting each argument to be an object, then
 * immutably merges the properties of each object and returns result.
 *
 * When multiple objects contain the same key the later object in
 * the arguments list will take precedence.
 *
 * Example:
 *
 * ```js
 * var result = merge({foo: 123}, {foo: 456});
 * console.log(result.foo); // outputs 456
 * ```
 *
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function merge( /* obj1, obj2, obj3, ... */
) {
  var result = {};
  function assignValue(val, key) {
    if (isPlainObject(result[key]) && isPlainObject(val)) {
      result[key] = merge(result[key], val);
    } else if (isPlainObject(val)) {
      result[key] = merge({}, val);
    } else if (isArray(val)) {
      result[key] = val.slice();
    } else {
      result[key] = val;
    }
  }
  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Extends object a by mutably adding to it the properties of object b.
 *
 * @param {Object} a The object to be extended
 * @param {Object} b The object to copy properties from
 * @param {Object} thisArg The object to bind function to
 * @return {Object} The resulting value of object a
 */
function extend(a, b, thisArg) {
  forEach(b, function assignValue(val, key) {
    if (thisArg && typeof val === 'function') {
      a[key] = bind(val, thisArg);
    } else {
      a[key] = val;
    }
  });
  return a;
}

/**
 * Remove byte order marker. This catches EF BB BF (the UTF-8 BOM)
 *
 * @param {string} content with BOM
 * @return {string} content value without BOM
 */
function stripBOM(content) {
  if (content.charCodeAt(0) === 0xFEFF) {
    content = content.slice(1);
  }
  return content;
}

/**
 * Inherit the prototype methods from one constructor into another
 * @param {function} constructor
 * @param {function} superConstructor
 * @param {object} [props]
 * @param {object} [descriptors]
 */

function inherits(constructor, superConstructor, props, descriptors) {
  constructor.prototype = Object.create(superConstructor.prototype, descriptors);
  constructor.prototype.constructor = constructor;
  props && Object.assign(constructor.prototype, props);
}

/**
 * Resolve object with deep prototype chain to a flat object
 * @param {Object} sourceObj source object
 * @param {Object} [destObj]
 * @param {Function} [filter]
 * @returns {Object}
 */

function toFlatObject(sourceObj, destObj, filter) {
  var props;
  var i;
  var prop;
  var merged = {};
  destObj = destObj || {};
  do {
    props = Object.getOwnPropertyNames(sourceObj);
    i = props.length;
    while (i-- > 0) {
      prop = props[i];
      if (!merged[prop]) {
        destObj[prop] = sourceObj[prop];
        merged[prop] = true;
      }
    }
    sourceObj = Object.getPrototypeOf(sourceObj);
  } while (sourceObj && (!filter || filter(sourceObj, destObj)) && sourceObj !== Object.prototype);
  return destObj;
}

/*
 * determines whether a string ends with the characters of a specified string
 * @param {String} str
 * @param {String} searchString
 * @param {Number} [position= 0]
 * @returns {boolean}
 */
function endsWith(str, searchString, position) {
  str = String(str);
  if (position === undefined || position > str.length) {
    position = str.length;
  }
  position -= searchString.length;
  var lastIndex = str.indexOf(searchString, position);
  return lastIndex !== -1 && lastIndex === position;
}

/**
 * Returns new array from array like object
 * @param {*} [thing]
 * @returns {Array}
 */
function toArray(thing) {
  if (!thing) return null;
  var i = thing.length;
  if (isUndefined(i)) return null;
  var arr = new Array(i);
  while (i-- > 0) {
    arr[i] = thing[i];
  }
  return arr;
}

// eslint-disable-next-line func-names
var isTypedArray = function (TypedArray) {
  // eslint-disable-next-line func-names
  return function (thing) {
    return TypedArray && thing instanceof TypedArray;
  };
}(typeof Uint8Array !== 'undefined' && Object.getPrototypeOf(Uint8Array));
module.exports = {
  isArray: isArray,
  isArrayBuffer: isArrayBuffer,
  isBuffer: isBuffer,
  isFormData: isFormData,
  isArrayBufferView: isArrayBufferView,
  isString: isString,
  isNumber: isNumber,
  isObject: isObject,
  isPlainObject: isPlainObject,
  isUndefined: isUndefined,
  isDate: isDate,
  isFile: isFile,
  isBlob: isBlob,
  isFunction: isFunction,
  isStream: isStream,
  isURLSearchParams: isURLSearchParams,
  isStandardBrowserEnv: isStandardBrowserEnv,
  forEach: forEach,
  merge: merge,
  extend: extend,
  trim: trim,
  stripBOM: stripBOM,
  inherits: inherits,
  toFlatObject: toFlatObject,
  kindOf: kindOf,
  kindOfTest: kindOfTest,
  endsWith: endsWith,
  toArray: toArray,
  isTypedArray: isTypedArray,
  isFileList: isFileList
};

/***/ }),

/***/ 2819:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
  'use strict';

  var hasOwn = {}.hasOwnProperty;
  var nativeCodeString = '[native code]';
  function classNames() {
    var classes = [];
    for (var i = 0; i < arguments.length; i++) {
      var arg = arguments[i];
      if (!arg) continue;
      var argType = typeof arg;
      if (argType === 'string' || argType === 'number') {
        classes.push(arg);
      } else if (Array.isArray(arg)) {
        if (arg.length) {
          var inner = classNames.apply(null, arg);
          if (inner) {
            classes.push(inner);
          }
        }
      } else if (argType === 'object') {
        if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
          classes.push(arg.toString());
          continue;
        }
        for (var key in arg) {
          if (hasOwn.call(arg, key) && arg[key]) {
            classes.push(key);
          }
        }
      }
    }
    return classes.join(' ');
  }
  if ( true && module.exports) {
    classNames.default = classNames;
    module.exports = classNames;
  } else if (true) {
    // register as 'classnames', consistent with npm package name
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
      return classNames;
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})();

/***/ }),

/***/ 1569:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "clsx": function() { return /* binding */ clsx; }
/* harmony export */ });
function r(e) {
  var t,
    f,
    n = "";
  if ("string" == typeof e || "number" == typeof e) n += e;else if ("object" == typeof e) if (Array.isArray(e)) for (t = 0; t < e.length; t++) e[t] && (f = r(e[t])) && (n && (n += " "), n += f);else for (t in e) e[t] && (n && (n += " "), n += t);
  return n;
}
function clsx() {
  for (var e, t, f = 0, n = ""; f < arguments.length;) (e = arguments[f++]) && (t = r(e)) && (n && (n += " "), n += t);
  return n;
}
/* harmony default export */ __webpack_exports__["default"] = (clsx);

/***/ }),

/***/ 8789:
/***/ (function(module) {

!function (t, e) {
   true ? module.exports = e() : 0;
}(this, function () {
  "use strict";

  var t = 1e3,
    e = 6e4,
    n = 36e5,
    r = "millisecond",
    i = "second",
    s = "minute",
    u = "hour",
    a = "day",
    o = "week",
    f = "month",
    h = "quarter",
    c = "year",
    d = "date",
    l = "Invalid Date",
    $ = /^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/,
    y = /\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g,
    M = {
      name: "en",
      weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
      months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
      ordinal: function ordinal(t) {
        var e = ["th", "st", "nd", "rd"],
          n = t % 100;
        return "[" + t + (e[(n - 20) % 10] || e[n] || e[0]) + "]";
      }
    },
    m = function m(t, e, n) {
      var r = String(t);
      return !r || r.length >= e ? t : "" + Array(e + 1 - r.length).join(n) + t;
    },
    v = {
      s: m,
      z: function z(t) {
        var e = -t.utcOffset(),
          n = Math.abs(e),
          r = Math.floor(n / 60),
          i = n % 60;
        return (e <= 0 ? "+" : "-") + m(r, 2, "0") + ":" + m(i, 2, "0");
      },
      m: function t(e, n) {
        if (e.date() < n.date()) return -t(n, e);
        var r = 12 * (n.year() - e.year()) + (n.month() - e.month()),
          i = e.clone().add(r, f),
          s = n - i < 0,
          u = e.clone().add(r + (s ? -1 : 1), f);
        return +(-(r + (n - i) / (s ? i - u : u - i)) || 0);
      },
      a: function a(t) {
        return t < 0 ? Math.ceil(t) || 0 : Math.floor(t);
      },
      p: function p(t) {
        return {
          M: f,
          y: c,
          w: o,
          d: a,
          D: d,
          h: u,
          m: s,
          s: i,
          ms: r,
          Q: h
        }[t] || String(t || "").toLowerCase().replace(/s$/, "");
      },
      u: function u(t) {
        return void 0 === t;
      }
    },
    g = "en",
    D = {};
  D[g] = M;
  var p = function p(t) {
      return t instanceof _;
    },
    S = function t(e, n, r) {
      var i;
      if (!e) return g;
      if ("string" == typeof e) {
        var s = e.toLowerCase();
        D[s] && (i = s), n && (D[s] = n, i = s);
        var u = e.split("-");
        if (!i && u.length > 1) return t(u[0]);
      } else {
        var a = e.name;
        D[a] = e, i = a;
      }
      return !r && i && (g = i), i || !r && g;
    },
    w = function w(t, e) {
      if (p(t)) return t.clone();
      var n = "object" == typeof e ? e : {};
      return n.date = t, n.args = arguments, new _(n);
    },
    O = v;
  O.l = S, O.i = p, O.w = function (t, e) {
    return w(t, {
      locale: e.$L,
      utc: e.$u,
      x: e.$x,
      $offset: e.$offset
    });
  };
  var _ = function () {
      function M(t) {
        this.$L = S(t.locale, null, !0), this.parse(t);
      }
      var m = M.prototype;
      return m.parse = function (t) {
        this.$d = function (t) {
          var e = t.date,
            n = t.utc;
          if (null === e) return new Date(NaN);
          if (O.u(e)) return new Date();
          if (e instanceof Date) return new Date(e);
          if ("string" == typeof e && !/Z$/i.test(e)) {
            var r = e.match($);
            if (r) {
              var i = r[2] - 1 || 0,
                s = (r[7] || "0").substring(0, 3);
              return n ? new Date(Date.UTC(r[1], i, r[3] || 1, r[4] || 0, r[5] || 0, r[6] || 0, s)) : new Date(r[1], i, r[3] || 1, r[4] || 0, r[5] || 0, r[6] || 0, s);
            }
          }
          return new Date(e);
        }(t), this.$x = t.x || {}, this.init();
      }, m.init = function () {
        var t = this.$d;
        this.$y = t.getFullYear(), this.$M = t.getMonth(), this.$D = t.getDate(), this.$W = t.getDay(), this.$H = t.getHours(), this.$m = t.getMinutes(), this.$s = t.getSeconds(), this.$ms = t.getMilliseconds();
      }, m.$utils = function () {
        return O;
      }, m.isValid = function () {
        return !(this.$d.toString() === l);
      }, m.isSame = function (t, e) {
        var n = w(t);
        return this.startOf(e) <= n && n <= this.endOf(e);
      }, m.isAfter = function (t, e) {
        return w(t) < this.startOf(e);
      }, m.isBefore = function (t, e) {
        return this.endOf(e) < w(t);
      }, m.$g = function (t, e, n) {
        return O.u(t) ? this[e] : this.set(n, t);
      }, m.unix = function () {
        return Math.floor(this.valueOf() / 1e3);
      }, m.valueOf = function () {
        return this.$d.getTime();
      }, m.startOf = function (t, e) {
        var n = this,
          r = !!O.u(e) || e,
          h = O.p(t),
          l = function l(t, e) {
            var i = O.w(n.$u ? Date.UTC(n.$y, e, t) : new Date(n.$y, e, t), n);
            return r ? i : i.endOf(a);
          },
          $ = function $(t, e) {
            return O.w(n.toDate()[t].apply(n.toDate("s"), (r ? [0, 0, 0, 0] : [23, 59, 59, 999]).slice(e)), n);
          },
          y = this.$W,
          M = this.$M,
          m = this.$D,
          v = "set" + (this.$u ? "UTC" : "");
        switch (h) {
          case c:
            return r ? l(1, 0) : l(31, 11);
          case f:
            return r ? l(1, M) : l(0, M + 1);
          case o:
            var g = this.$locale().weekStart || 0,
              D = (y < g ? y + 7 : y) - g;
            return l(r ? m - D : m + (6 - D), M);
          case a:
          case d:
            return $(v + "Hours", 0);
          case u:
            return $(v + "Minutes", 1);
          case s:
            return $(v + "Seconds", 2);
          case i:
            return $(v + "Milliseconds", 3);
          default:
            return this.clone();
        }
      }, m.endOf = function (t) {
        return this.startOf(t, !1);
      }, m.$set = function (t, e) {
        var n,
          o = O.p(t),
          h = "set" + (this.$u ? "UTC" : ""),
          l = (n = {}, n[a] = h + "Date", n[d] = h + "Date", n[f] = h + "Month", n[c] = h + "FullYear", n[u] = h + "Hours", n[s] = h + "Minutes", n[i] = h + "Seconds", n[r] = h + "Milliseconds", n)[o],
          $ = o === a ? this.$D + (e - this.$W) : e;
        if (o === f || o === c) {
          var y = this.clone().set(d, 1);
          y.$d[l]($), y.init(), this.$d = y.set(d, Math.min(this.$D, y.daysInMonth())).$d;
        } else l && this.$d[l]($);
        return this.init(), this;
      }, m.set = function (t, e) {
        return this.clone().$set(t, e);
      }, m.get = function (t) {
        return this[O.p(t)]();
      }, m.add = function (r, h) {
        var d,
          l = this;
        r = Number(r);
        var $ = O.p(h),
          y = function y(t) {
            var e = w(l);
            return O.w(e.date(e.date() + Math.round(t * r)), l);
          };
        if ($ === f) return this.set(f, this.$M + r);
        if ($ === c) return this.set(c, this.$y + r);
        if ($ === a) return y(1);
        if ($ === o) return y(7);
        var M = (d = {}, d[s] = e, d[u] = n, d[i] = t, d)[$] || 1,
          m = this.$d.getTime() + r * M;
        return O.w(m, this);
      }, m.subtract = function (t, e) {
        return this.add(-1 * t, e);
      }, m.format = function (t) {
        var e = this,
          n = this.$locale();
        if (!this.isValid()) return n.invalidDate || l;
        var r = t || "YYYY-MM-DDTHH:mm:ssZ",
          i = O.z(this),
          s = this.$H,
          u = this.$m,
          a = this.$M,
          o = n.weekdays,
          f = n.months,
          h = function h(t, n, i, s) {
            return t && (t[n] || t(e, r)) || i[n].slice(0, s);
          },
          c = function c(t) {
            return O.s(s % 12 || 12, t, "0");
          },
          d = n.meridiem || function (t, e, n) {
            var r = t < 12 ? "AM" : "PM";
            return n ? r.toLowerCase() : r;
          },
          $ = {
            YY: String(this.$y).slice(-2),
            YYYY: this.$y,
            M: a + 1,
            MM: O.s(a + 1, 2, "0"),
            MMM: h(n.monthsShort, a, f, 3),
            MMMM: h(f, a),
            D: this.$D,
            DD: O.s(this.$D, 2, "0"),
            d: String(this.$W),
            dd: h(n.weekdaysMin, this.$W, o, 2),
            ddd: h(n.weekdaysShort, this.$W, o, 3),
            dddd: o[this.$W],
            H: String(s),
            HH: O.s(s, 2, "0"),
            h: c(1),
            hh: c(2),
            a: d(s, u, !0),
            A: d(s, u, !1),
            m: String(u),
            mm: O.s(u, 2, "0"),
            s: String(this.$s),
            ss: O.s(this.$s, 2, "0"),
            SSS: O.s(this.$ms, 3, "0"),
            Z: i
          };
        return r.replace(y, function (t, e) {
          return e || $[t] || i.replace(":", "");
        });
      }, m.utcOffset = function () {
        return 15 * -Math.round(this.$d.getTimezoneOffset() / 15);
      }, m.diff = function (r, d, l) {
        var $,
          y = O.p(d),
          M = w(r),
          m = (M.utcOffset() - this.utcOffset()) * e,
          v = this - M,
          g = O.m(this, M);
        return g = ($ = {}, $[c] = g / 12, $[f] = g, $[h] = g / 3, $[o] = (v - m) / 6048e5, $[a] = (v - m) / 864e5, $[u] = v / n, $[s] = v / e, $[i] = v / t, $)[y] || v, l ? g : O.a(g);
      }, m.daysInMonth = function () {
        return this.endOf(f).$D;
      }, m.$locale = function () {
        return D[this.$L];
      }, m.locale = function (t, e) {
        if (!t) return this.$L;
        var n = this.clone(),
          r = S(t, e, !0);
        return r && (n.$L = r), n;
      }, m.clone = function () {
        return O.w(this.$d, this);
      }, m.toDate = function () {
        return new Date(this.valueOf());
      }, m.toJSON = function () {
        return this.isValid() ? this.toISOString() : null;
      }, m.toISOString = function () {
        return this.$d.toISOString();
      }, m.toString = function () {
        return this.$d.toUTCString();
      }, M;
    }(),
    T = _.prototype;
  return w.prototype = T, [["$ms", r], ["$s", i], ["$m", s], ["$H", u], ["$W", a], ["$M", f], ["$y", c], ["$D", d]].forEach(function (t) {
    T[t[1]] = function (e) {
      return this.$g(e, t[0], t[1]);
    };
  }), w.extend = function (t, e) {
    return t.$i || (t(e, _, w), t.$i = !0), w;
  }, w.locale = S, w.isDayjs = p, w.unix = function (t) {
    return w(1e3 * t);
  }, w.en = D[g], w.Ls = D, w.p = {}, w;
});

/***/ }),

/***/ 8053:
/***/ (function(module) {

!function (t, s) {
   true ? module.exports = s() : 0;
}(this, function () {
  "use strict";

  var t,
    s,
    n = 1e3,
    i = 6e4,
    e = 36e5,
    r = 864e5,
    o = /\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g,
    u = 31536e6,
    h = 2592e6,
    a = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/,
    d = {
      years: u,
      months: h,
      days: r,
      hours: e,
      minutes: i,
      seconds: n,
      milliseconds: 1,
      weeks: 6048e5
    },
    c = function c(t) {
      return t instanceof p;
    },
    f = function f(t, s, n) {
      return new p(t, n, s.$l);
    },
    m = function m(t) {
      return s.p(t) + "s";
    },
    l = function l(t) {
      return t < 0;
    },
    $ = function $(t) {
      return l(t) ? Math.ceil(t) : Math.floor(t);
    },
    y = function y(t) {
      return Math.abs(t);
    },
    g = function g(t, s) {
      return t ? l(t) ? {
        negative: !0,
        format: "" + y(t) + s
      } : {
        negative: !1,
        format: "" + t + s
      } : {
        negative: !1,
        format: ""
      };
    },
    p = function () {
      function l(t, s, n) {
        var i = this;
        if (this.$d = {}, this.$l = n, void 0 === t && (this.$ms = 0, this.parseFromMilliseconds()), s) return f(t * d[m(s)], this);
        if ("number" == typeof t) return this.$ms = t, this.parseFromMilliseconds(), this;
        if ("object" == typeof t) return Object.keys(t).forEach(function (s) {
          i.$d[m(s)] = t[s];
        }), this.calMilliseconds(), this;
        if ("string" == typeof t) {
          var e = t.match(a);
          if (e) {
            var r = e.slice(2).map(function (t) {
              return null != t ? Number(t) : 0;
            });
            return this.$d.years = r[0], this.$d.months = r[1], this.$d.weeks = r[2], this.$d.days = r[3], this.$d.hours = r[4], this.$d.minutes = r[5], this.$d.seconds = r[6], this.calMilliseconds(), this;
          }
        }
        return this;
      }
      var y = l.prototype;
      return y.calMilliseconds = function () {
        var t = this;
        this.$ms = Object.keys(this.$d).reduce(function (s, n) {
          return s + (t.$d[n] || 0) * d[n];
        }, 0);
      }, y.parseFromMilliseconds = function () {
        var t = this.$ms;
        this.$d.years = $(t / u), t %= u, this.$d.months = $(t / h), t %= h, this.$d.days = $(t / r), t %= r, this.$d.hours = $(t / e), t %= e, this.$d.minutes = $(t / i), t %= i, this.$d.seconds = $(t / n), t %= n, this.$d.milliseconds = t;
      }, y.toISOString = function () {
        var t = g(this.$d.years, "Y"),
          s = g(this.$d.months, "M"),
          n = +this.$d.days || 0;
        this.$d.weeks && (n += 7 * this.$d.weeks);
        var i = g(n, "D"),
          e = g(this.$d.hours, "H"),
          r = g(this.$d.minutes, "M"),
          o = this.$d.seconds || 0;
        this.$d.milliseconds && (o += this.$d.milliseconds / 1e3);
        var u = g(o, "S"),
          h = t.negative || s.negative || i.negative || e.negative || r.negative || u.negative,
          a = e.format || r.format || u.format ? "T" : "",
          d = (h ? "-" : "") + "P" + t.format + s.format + i.format + a + e.format + r.format + u.format;
        return "P" === d || "-P" === d ? "P0D" : d;
      }, y.toJSON = function () {
        return this.toISOString();
      }, y.format = function (t) {
        var n = t || "YYYY-MM-DDTHH:mm:ss",
          i = {
            Y: this.$d.years,
            YY: s.s(this.$d.years, 2, "0"),
            YYYY: s.s(this.$d.years, 4, "0"),
            M: this.$d.months,
            MM: s.s(this.$d.months, 2, "0"),
            D: this.$d.days,
            DD: s.s(this.$d.days, 2, "0"),
            H: this.$d.hours,
            HH: s.s(this.$d.hours, 2, "0"),
            m: this.$d.minutes,
            mm: s.s(this.$d.minutes, 2, "0"),
            s: this.$d.seconds,
            ss: s.s(this.$d.seconds, 2, "0"),
            SSS: s.s(this.$d.milliseconds, 3, "0")
          };
        return n.replace(o, function (t, s) {
          return s || String(i[t]);
        });
      }, y.as = function (t) {
        return this.$ms / d[m(t)];
      }, y.get = function (t) {
        var s = this.$ms,
          n = m(t);
        return "milliseconds" === n ? s %= 1e3 : s = "weeks" === n ? $(s / d[n]) : this.$d[n], 0 === s ? 0 : s;
      }, y.add = function (t, s, n) {
        var i;
        return i = s ? t * d[m(s)] : c(t) ? t.$ms : f(t, this).$ms, f(this.$ms + i * (n ? -1 : 1), this);
      }, y.subtract = function (t, s) {
        return this.add(t, s, !0);
      }, y.locale = function (t) {
        var s = this.clone();
        return s.$l = t, s;
      }, y.clone = function () {
        return f(this.$ms, this);
      }, y.humanize = function (s) {
        return t().add(this.$ms, "ms").locale(this.$l).fromNow(!s);
      }, y.milliseconds = function () {
        return this.get("milliseconds");
      }, y.asMilliseconds = function () {
        return this.as("milliseconds");
      }, y.seconds = function () {
        return this.get("seconds");
      }, y.asSeconds = function () {
        return this.as("seconds");
      }, y.minutes = function () {
        return this.get("minutes");
      }, y.asMinutes = function () {
        return this.as("minutes");
      }, y.hours = function () {
        return this.get("hours");
      }, y.asHours = function () {
        return this.as("hours");
      }, y.days = function () {
        return this.get("days");
      }, y.asDays = function () {
        return this.as("days");
      }, y.weeks = function () {
        return this.get("weeks");
      }, y.asWeeks = function () {
        return this.as("weeks");
      }, y.months = function () {
        return this.get("months");
      }, y.asMonths = function () {
        return this.as("months");
      }, y.years = function () {
        return this.get("years");
      }, y.asYears = function () {
        return this.as("years");
      }, l;
    }();
  return function (n, i, e) {
    t = e, s = e().$utils(), e.duration = function (t, s) {
      var n = e.locale();
      return f(t, {
        $l: n
      }, s);
    }, e.isDuration = c;
    var r = i.prototype.add,
      o = i.prototype.subtract;
    i.prototype.add = function (t, s) {
      return c(t) && (t = t.asMilliseconds()), r.bind(this)(t, s);
    }, i.prototype.subtract = function (t, s) {
      return c(t) && (t = t.asMilliseconds()), o.bind(this)(t, s);
    };
  };
});

/***/ }),

/***/ 7029:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var reactIs = __webpack_require__(4436);

/**
 * Copyright 2015, Yahoo! Inc.
 * Copyrights licensed under the New BSD License. See the accompanying LICENSE file for terms.
 */
var REACT_STATICS = {
  childContextTypes: true,
  contextType: true,
  contextTypes: true,
  defaultProps: true,
  displayName: true,
  getDefaultProps: true,
  getDerivedStateFromError: true,
  getDerivedStateFromProps: true,
  mixins: true,
  propTypes: true,
  type: true
};
var KNOWN_STATICS = {
  name: true,
  length: true,
  prototype: true,
  caller: true,
  callee: true,
  arguments: true,
  arity: true
};
var FORWARD_REF_STATICS = {
  '$$typeof': true,
  render: true,
  defaultProps: true,
  displayName: true,
  propTypes: true
};
var MEMO_STATICS = {
  '$$typeof': true,
  compare: true,
  defaultProps: true,
  displayName: true,
  propTypes: true,
  type: true
};
var TYPE_STATICS = {};
TYPE_STATICS[reactIs.ForwardRef] = FORWARD_REF_STATICS;
TYPE_STATICS[reactIs.Memo] = MEMO_STATICS;
function getStatics(component) {
  // React v16.11 and below
  if (reactIs.isMemo(component)) {
    return MEMO_STATICS;
  } // React v16.12 and above

  return TYPE_STATICS[component['$$typeof']] || REACT_STATICS;
}
var defineProperty = Object.defineProperty;
var getOwnPropertyNames = Object.getOwnPropertyNames;
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var getPrototypeOf = Object.getPrototypeOf;
var objectPrototype = Object.prototype;
function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
  if (typeof sourceComponent !== 'string') {
    // don't hoist over string (html) components
    if (objectPrototype) {
      var inheritedComponent = getPrototypeOf(sourceComponent);
      if (inheritedComponent && inheritedComponent !== objectPrototype) {
        hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
      }
    }
    var keys = getOwnPropertyNames(sourceComponent);
    if (getOwnPropertySymbols) {
      keys = keys.concat(getOwnPropertySymbols(sourceComponent));
    }
    var targetStatics = getStatics(targetComponent);
    var sourceStatics = getStatics(sourceComponent);
    for (var i = 0; i < keys.length; ++i) {
      var key = keys[i];
      if (!KNOWN_STATICS[key] && !(blacklist && blacklist[key]) && !(sourceStatics && sourceStatics[key]) && !(targetStatics && targetStatics[key])) {
        var descriptor = getOwnPropertyDescriptor(sourceComponent, key);
        try {
          // Avoid failures from read-only properties
          defineProperty(targetComponent, key, descriptor);
        } catch (e) {}
      }
    }
  }
  return targetComponent;
}
module.exports = hoistNonReactStatics;

/***/ }),

/***/ 2346:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


// A linked list to keep track of recently-used-ness
var _classCallCheck = (__webpack_require__(8403)["default"]);
var _createClass = (__webpack_require__(2467)["default"]);
var Yallist = __webpack_require__(6451);
var MAX = Symbol('max');
var LENGTH = Symbol('length');
var LENGTH_CALCULATOR = Symbol('lengthCalculator');
var ALLOW_STALE = Symbol('allowStale');
var MAX_AGE = Symbol('maxAge');
var DISPOSE = Symbol('dispose');
var NO_DISPOSE_ON_SET = Symbol('noDisposeOnSet');
var LRU_LIST = Symbol('lruList');
var CACHE = Symbol('cache');
var UPDATE_AGE_ON_GET = Symbol('updateAgeOnGet');
var naiveLength = function naiveLength() {
  return 1;
};

// lruList is a yallist where the head is the youngest
// item, and the tail is the oldest.  the list contains the Hit
// objects as the entries.
// Each Hit object has a reference to its Yallist.Node.  This
// never changes.
//
// cache is a Map (or PseudoMap) that matches the keys to
// the Yallist.Node object.
var LRUCache = /*#__PURE__*/function () {
  function LRUCache(options) {
    _classCallCheck(this, LRUCache);
    if (typeof options === 'number') options = {
      max: options
    };
    if (!options) options = {};
    if (options.max && (typeof options.max !== 'number' || options.max < 0)) throw new TypeError('max must be a non-negative number');
    // Kind of weird to have a default max of Infinity, but oh well.
    var max = this[MAX] = options.max || Infinity;
    var lc = options.length || naiveLength;
    this[LENGTH_CALCULATOR] = typeof lc !== 'function' ? naiveLength : lc;
    this[ALLOW_STALE] = options.stale || false;
    if (options.maxAge && typeof options.maxAge !== 'number') throw new TypeError('maxAge must be a number');
    this[MAX_AGE] = options.maxAge || 0;
    this[DISPOSE] = options.dispose;
    this[NO_DISPOSE_ON_SET] = options.noDisposeOnSet || false;
    this[UPDATE_AGE_ON_GET] = options.updateAgeOnGet || false;
    this.reset();
  }

  // resize the cache when the max changes.
  _createClass(LRUCache, [{
    key: "max",
    get: function get() {
      return this[MAX];
    },
    set: function set(mL) {
      if (typeof mL !== 'number' || mL < 0) throw new TypeError('max must be a non-negative number');
      this[MAX] = mL || Infinity;
      trim(this);
    }
  }, {
    key: "allowStale",
    get: function get() {
      return this[ALLOW_STALE];
    },
    set: function set(allowStale) {
      this[ALLOW_STALE] = !!allowStale;
    }
  }, {
    key: "maxAge",
    get: function get() {
      return this[MAX_AGE];
    }

    // resize the cache when the lengthCalculator changes.
    ,
    set: function set(mA) {
      if (typeof mA !== 'number') throw new TypeError('maxAge must be a non-negative number');
      this[MAX_AGE] = mA;
      trim(this);
    }
  }, {
    key: "lengthCalculator",
    get: function get() {
      return this[LENGTH_CALCULATOR];
    },
    set: function set(lC) {
      var _this = this;
      if (typeof lC !== 'function') lC = naiveLength;
      if (lC !== this[LENGTH_CALCULATOR]) {
        this[LENGTH_CALCULATOR] = lC;
        this[LENGTH] = 0;
        this[LRU_LIST].forEach(function (hit) {
          hit.length = _this[LENGTH_CALCULATOR](hit.value, hit.key);
          _this[LENGTH] += hit.length;
        });
      }
      trim(this);
    }
  }, {
    key: "length",
    get: function get() {
      return this[LENGTH];
    }
  }, {
    key: "itemCount",
    get: function get() {
      return this[LRU_LIST].length;
    }
  }, {
    key: "rforEach",
    value: function rforEach(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this[LRU_LIST].tail; walker !== null;) {
        var prev = walker.prev;
        forEachStep(this, fn, walker, thisp);
        walker = prev;
      }
    }
  }, {
    key: "forEach",
    value: function forEach(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this[LRU_LIST].head; walker !== null;) {
        var next = walker.next;
        forEachStep(this, fn, walker, thisp);
        walker = next;
      }
    }
  }, {
    key: "keys",
    value: function keys() {
      return this[LRU_LIST].toArray().map(function (k) {
        return k.key;
      });
    }
  }, {
    key: "values",
    value: function values() {
      return this[LRU_LIST].toArray().map(function (k) {
        return k.value;
      });
    }
  }, {
    key: "reset",
    value: function reset() {
      var _this2 = this;
      if (this[DISPOSE] && this[LRU_LIST] && this[LRU_LIST].length) {
        this[LRU_LIST].forEach(function (hit) {
          return _this2[DISPOSE](hit.key, hit.value);
        });
      }
      this[CACHE] = new Map(); // hash of items by key
      this[LRU_LIST] = new Yallist(); // list of items in order of use recency
      this[LENGTH] = 0; // length of items in the list
    }
  }, {
    key: "dump",
    value: function dump() {
      var _this3 = this;
      return this[LRU_LIST].map(function (hit) {
        return isStale(_this3, hit) ? false : {
          k: hit.key,
          v: hit.value,
          e: hit.now + (hit.maxAge || 0)
        };
      }).toArray().filter(function (h) {
        return h;
      });
    }
  }, {
    key: "dumpLru",
    value: function dumpLru() {
      return this[LRU_LIST];
    }
  }, {
    key: "set",
    value: function set(key, value, maxAge) {
      maxAge = maxAge || this[MAX_AGE];
      if (maxAge && typeof maxAge !== 'number') throw new TypeError('maxAge must be a number');
      var now = maxAge ? Date.now() : 0;
      var len = this[LENGTH_CALCULATOR](value, key);
      if (this[CACHE].has(key)) {
        if (len > this[MAX]) {
          _del(this, this[CACHE].get(key));
          return false;
        }
        var node = this[CACHE].get(key);
        var item = node.value;

        // dispose of the old one before overwriting
        // split out into 2 ifs for better coverage tracking
        if (this[DISPOSE]) {
          if (!this[NO_DISPOSE_ON_SET]) this[DISPOSE](key, item.value);
        }
        item.now = now;
        item.maxAge = maxAge;
        item.value = value;
        this[LENGTH] += len - item.length;
        item.length = len;
        this.get(key);
        trim(this);
        return true;
      }
      var hit = new Entry(key, value, len, now, maxAge);

      // oversized objects fall out of cache automatically.
      if (hit.length > this[MAX]) {
        if (this[DISPOSE]) this[DISPOSE](key, value);
        return false;
      }
      this[LENGTH] += hit.length;
      this[LRU_LIST].unshift(hit);
      this[CACHE].set(key, this[LRU_LIST].head);
      trim(this);
      return true;
    }
  }, {
    key: "has",
    value: function has(key) {
      if (!this[CACHE].has(key)) return false;
      var hit = this[CACHE].get(key).value;
      return !isStale(this, hit);
    }
  }, {
    key: "get",
    value: function get(key) {
      return _get(this, key, true);
    }
  }, {
    key: "peek",
    value: function peek(key) {
      return _get(this, key, false);
    }
  }, {
    key: "pop",
    value: function pop() {
      var node = this[LRU_LIST].tail;
      if (!node) return null;
      _del(this, node);
      return node.value;
    }
  }, {
    key: "del",
    value: function del(key) {
      _del(this, this[CACHE].get(key));
    }
  }, {
    key: "load",
    value: function load(arr) {
      // reset the cache
      this.reset();
      var now = Date.now();
      // A previous serialized cache has the most recent items first
      for (var l = arr.length - 1; l >= 0; l--) {
        var hit = arr[l];
        var expiresAt = hit.e || 0;
        if (expiresAt === 0)
          // the item was created without expiration in a non aged cache
          this.set(hit.k, hit.v);else {
          var maxAge = expiresAt - now;
          // dont add already expired items
          if (maxAge > 0) {
            this.set(hit.k, hit.v, maxAge);
          }
        }
      }
    }
  }, {
    key: "prune",
    value: function prune() {
      var _this4 = this;
      this[CACHE].forEach(function (value, key) {
        return _get(_this4, key, false);
      });
    }
  }]);
  return LRUCache;
}();
var _get = function _get(self, key, doUse) {
  var node = self[CACHE].get(key);
  if (node) {
    var hit = node.value;
    if (isStale(self, hit)) {
      _del(self, node);
      if (!self[ALLOW_STALE]) return undefined;
    } else {
      if (doUse) {
        if (self[UPDATE_AGE_ON_GET]) node.value.now = Date.now();
        self[LRU_LIST].unshiftNode(node);
      }
    }
    return hit.value;
  }
};
var isStale = function isStale(self, hit) {
  if (!hit || !hit.maxAge && !self[MAX_AGE]) return false;
  var diff = Date.now() - hit.now;
  return hit.maxAge ? diff > hit.maxAge : self[MAX_AGE] && diff > self[MAX_AGE];
};
var trim = function trim(self) {
  if (self[LENGTH] > self[MAX]) {
    for (var walker = self[LRU_LIST].tail; self[LENGTH] > self[MAX] && walker !== null;) {
      // We know that we're about to delete this one, and also
      // what the next least recently used key will be, so just
      // go ahead and set it now.
      var prev = walker.prev;
      _del(self, walker);
      walker = prev;
    }
  }
};
var _del = function _del(self, node) {
  if (node) {
    var hit = node.value;
    if (self[DISPOSE]) self[DISPOSE](hit.key, hit.value);
    self[LENGTH] -= hit.length;
    self[CACHE].delete(hit.key);
    self[LRU_LIST].removeNode(node);
  }
};
var Entry = /*#__PURE__*/_createClass(function Entry(key, value, length, now, maxAge) {
  _classCallCheck(this, Entry);
  this.key = key;
  this.value = value;
  this.length = length;
  this.now = now;
  this.maxAge = maxAge || 0;
});
var forEachStep = function forEachStep(self, fn, node, thisp) {
  var hit = node.value;
  if (isStale(self, hit)) {
    _del(self, node);
    if (!self[ALLOW_STALE]) hit = undefined;
  }
  if (hit) fn.call(thisp, hit.value, hit.key, self);
};
module.exports = LRUCache;

/***/ }),

/***/ 779:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = __webpack_require__(7106);
function emptyFunction() {}
function emptyFunctionWithReset() {}
emptyFunctionWithReset.resetWarningCache = emptyFunction;
module.exports = function () {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret) {
      // It is still safe when called from React.
      return;
    }
    var err = new Error('Calling PropTypes validators directly is not supported by the `prop-types` package. ' + 'Use PropTypes.checkPropTypes() to call them. ' + 'Read more at http://fb.me/use-check-prop-types');
    err.name = 'Invariant Violation';
    throw err;
  }
  ;
  shim.isRequired = shim;
  function getShim() {
    return shim;
  }
  ;
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bigint: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,
    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,
    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };
  ReactPropTypes.PropTypes = ReactPropTypes;
  return ReactPropTypes;
};

/***/ }),

/***/ 1226:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (false) { var throwOnDirectAccess, ReactIs; } else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = __webpack_require__(779)();
}

/***/ }),

/***/ 7106:
/***/ (function(module) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';
module.exports = ReactPropTypesSecret;

/***/ }),

/***/ 5478:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
/**
 * @license React
 * react-dom.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
/*
 Modernizr 3.0.0pre (Custom Build) | MIT
*/


var aa = __webpack_require__(9512),
  ca = __webpack_require__(4086);
function p(a) {
  for (var b = "https://reactjs.org/docs/error-decoder.html?invariant=" + a, c = 1; c < arguments.length; c++) b += "&args[]=" + encodeURIComponent(arguments[c]);
  return "Minified React error #" + a + "; visit " + b + " for the full message or use the non-minified dev environment for full errors and additional helpful warnings.";
}
var da = new Set(),
  ea = {};
function fa(a, b) {
  ha(a, b);
  ha(a + "Capture", b);
}
function ha(a, b) {
  ea[a] = b;
  for (a = 0; a < b.length; a++) da.add(b[a]);
}
var ia = !("undefined" === typeof window || "undefined" === typeof window.document || "undefined" === typeof window.document.createElement),
  ja = Object.prototype.hasOwnProperty,
  ka = /^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/,
  la = {},
  ma = {};
function oa(a) {
  if (ja.call(ma, a)) return !0;
  if (ja.call(la, a)) return !1;
  if (ka.test(a)) return ma[a] = !0;
  la[a] = !0;
  return !1;
}
function pa(a, b, c, d) {
  if (null !== c && 0 === c.type) return !1;
  switch (typeof b) {
    case "function":
    case "symbol":
      return !0;
    case "boolean":
      if (d) return !1;
      if (null !== c) return !c.acceptsBooleans;
      a = a.toLowerCase().slice(0, 5);
      return "data-" !== a && "aria-" !== a;
    default:
      return !1;
  }
}
function qa(a, b, c, d) {
  if (null === b || "undefined" === typeof b || pa(a, b, c, d)) return !0;
  if (d) return !1;
  if (null !== c) switch (c.type) {
    case 3:
      return !b;
    case 4:
      return !1 === b;
    case 5:
      return isNaN(b);
    case 6:
      return isNaN(b) || 1 > b;
  }
  return !1;
}
function v(a, b, c, d, e, f, g) {
  this.acceptsBooleans = 2 === b || 3 === b || 4 === b;
  this.attributeName = d;
  this.attributeNamespace = e;
  this.mustUseProperty = c;
  this.propertyName = a;
  this.type = b;
  this.sanitizeURL = f;
  this.removeEmptyString = g;
}
var z = {};
"children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(" ").forEach(function (a) {
  z[a] = new v(a, 0, !1, a, null, !1, !1);
});
[["acceptCharset", "accept-charset"], ["className", "class"], ["htmlFor", "for"], ["httpEquiv", "http-equiv"]].forEach(function (a) {
  var b = a[0];
  z[b] = new v(b, 1, !1, a[1], null, !1, !1);
});
["contentEditable", "draggable", "spellCheck", "value"].forEach(function (a) {
  z[a] = new v(a, 2, !1, a.toLowerCase(), null, !1, !1);
});
["autoReverse", "externalResourcesRequired", "focusable", "preserveAlpha"].forEach(function (a) {
  z[a] = new v(a, 2, !1, a, null, !1, !1);
});
"allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope".split(" ").forEach(function (a) {
  z[a] = new v(a, 3, !1, a.toLowerCase(), null, !1, !1);
});
["checked", "multiple", "muted", "selected"].forEach(function (a) {
  z[a] = new v(a, 3, !0, a, null, !1, !1);
});
["capture", "download"].forEach(function (a) {
  z[a] = new v(a, 4, !1, a, null, !1, !1);
});
["cols", "rows", "size", "span"].forEach(function (a) {
  z[a] = new v(a, 6, !1, a, null, !1, !1);
});
["rowSpan", "start"].forEach(function (a) {
  z[a] = new v(a, 5, !1, a.toLowerCase(), null, !1, !1);
});
var ra = /[\-:]([a-z])/g;
function sa(a) {
  return a[1].toUpperCase();
}
"accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height".split(" ").forEach(function (a) {
  var b = a.replace(ra, sa);
  z[b] = new v(b, 1, !1, a, null, !1, !1);
});
"xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type".split(" ").forEach(function (a) {
  var b = a.replace(ra, sa);
  z[b] = new v(b, 1, !1, a, "http://www.w3.org/1999/xlink", !1, !1);
});
["xml:base", "xml:lang", "xml:space"].forEach(function (a) {
  var b = a.replace(ra, sa);
  z[b] = new v(b, 1, !1, a, "http://www.w3.org/XML/1998/namespace", !1, !1);
});
["tabIndex", "crossOrigin"].forEach(function (a) {
  z[a] = new v(a, 1, !1, a.toLowerCase(), null, !1, !1);
});
z.xlinkHref = new v("xlinkHref", 1, !1, "xlink:href", "http://www.w3.org/1999/xlink", !0, !1);
["src", "href", "action", "formAction"].forEach(function (a) {
  z[a] = new v(a, 1, !1, a.toLowerCase(), null, !0, !0);
});
function ta(a, b, c, d) {
  var e = z.hasOwnProperty(b) ? z[b] : null;
  if (null !== e ? 0 !== e.type : d || !(2 < b.length) || "o" !== b[0] && "O" !== b[0] || "n" !== b[1] && "N" !== b[1]) qa(b, c, e, d) && (c = null), d || null === e ? oa(b) && (null === c ? a.removeAttribute(b) : a.setAttribute(b, "" + c)) : e.mustUseProperty ? a[e.propertyName] = null === c ? 3 === e.type ? !1 : "" : c : (b = e.attributeName, d = e.attributeNamespace, null === c ? a.removeAttribute(b) : (e = e.type, c = 3 === e || 4 === e && !0 === c ? "" : "" + c, d ? a.setAttributeNS(d, b, c) : a.setAttribute(b, c)));
}
var ua = aa.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED,
  va = Symbol.for("react.element"),
  wa = Symbol.for("react.portal"),
  ya = Symbol.for("react.fragment"),
  za = Symbol.for("react.strict_mode"),
  Aa = Symbol.for("react.profiler"),
  Ba = Symbol.for("react.provider"),
  Ca = Symbol.for("react.context"),
  Da = Symbol.for("react.forward_ref"),
  Ea = Symbol.for("react.suspense"),
  Fa = Symbol.for("react.suspense_list"),
  Ga = Symbol.for("react.memo"),
  Ha = Symbol.for("react.lazy");
Symbol.for("react.scope");
Symbol.for("react.debug_trace_mode");
var Ia = Symbol.for("react.offscreen");
Symbol.for("react.legacy_hidden");
Symbol.for("react.cache");
Symbol.for("react.tracing_marker");
var Ja = Symbol.iterator;
function Ka(a) {
  if (null === a || "object" !== typeof a) return null;
  a = Ja && a[Ja] || a["@@iterator"];
  return "function" === typeof a ? a : null;
}
var A = Object.assign,
  La;
function Ma(a) {
  if (void 0 === La) try {
    throw Error();
  } catch (c) {
    var b = c.stack.trim().match(/\n( *(at )?)/);
    La = b && b[1] || "";
  }
  return "\n" + La + a;
}
var Na = !1;
function Oa(a, b) {
  if (!a || Na) return "";
  Na = !0;
  var c = Error.prepareStackTrace;
  Error.prepareStackTrace = void 0;
  try {
    if (b) {
      if (b = function b() {
        throw Error();
      }, Object.defineProperty(b.prototype, "props", {
        set: function set() {
          throw Error();
        }
      }), "object" === typeof Reflect && Reflect.construct) {
        try {
          Reflect.construct(b, []);
        } catch (l) {
          var d = l;
        }
        Reflect.construct(a, [], b);
      } else {
        try {
          b.call();
        } catch (l) {
          d = l;
        }
        a.call(b.prototype);
      }
    } else {
      try {
        throw Error();
      } catch (l) {
        d = l;
      }
      a();
    }
  } catch (l) {
    if (l && d && "string" === typeof l.stack) {
      for (var e = l.stack.split("\n"), f = d.stack.split("\n"), g = e.length - 1, h = f.length - 1; 1 <= g && 0 <= h && e[g] !== f[h];) h--;
      for (; 1 <= g && 0 <= h; g--, h--) if (e[g] !== f[h]) {
        if (1 !== g || 1 !== h) {
          do if (g--, h--, 0 > h || e[g] !== f[h]) {
            var k = "\n" + e[g].replace(" at new ", " at ");
            a.displayName && k.includes("<anonymous>") && (k = k.replace("<anonymous>", a.displayName));
            return k;
          } while (1 <= g && 0 <= h);
        }
        break;
      }
    }
  } finally {
    Na = !1, Error.prepareStackTrace = c;
  }
  return (a = a ? a.displayName || a.name : "") ? Ma(a) : "";
}
function Pa(a) {
  switch (a.tag) {
    case 5:
      return Ma(a.type);
    case 16:
      return Ma("Lazy");
    case 13:
      return Ma("Suspense");
    case 19:
      return Ma("SuspenseList");
    case 0:
    case 2:
    case 15:
      return a = Oa(a.type, !1), a;
    case 11:
      return a = Oa(a.type.render, !1), a;
    case 1:
      return a = Oa(a.type, !0), a;
    default:
      return "";
  }
}
function Qa(a) {
  if (null == a) return null;
  if ("function" === typeof a) return a.displayName || a.name || null;
  if ("string" === typeof a) return a;
  switch (a) {
    case ya:
      return "Fragment";
    case wa:
      return "Portal";
    case Aa:
      return "Profiler";
    case za:
      return "StrictMode";
    case Ea:
      return "Suspense";
    case Fa:
      return "SuspenseList";
  }
  if ("object" === typeof a) switch (a.$$typeof) {
    case Ca:
      return (a.displayName || "Context") + ".Consumer";
    case Ba:
      return (a._context.displayName || "Context") + ".Provider";
    case Da:
      var b = a.render;
      a = a.displayName;
      a || (a = b.displayName || b.name || "", a = "" !== a ? "ForwardRef(" + a + ")" : "ForwardRef");
      return a;
    case Ga:
      return b = a.displayName || null, null !== b ? b : Qa(a.type) || "Memo";
    case Ha:
      b = a._payload;
      a = a._init;
      try {
        return Qa(a(b));
      } catch (c) {}
  }
  return null;
}
function Ra(a) {
  var b = a.type;
  switch (a.tag) {
    case 24:
      return "Cache";
    case 9:
      return (b.displayName || "Context") + ".Consumer";
    case 10:
      return (b._context.displayName || "Context") + ".Provider";
    case 18:
      return "DehydratedFragment";
    case 11:
      return a = b.render, a = a.displayName || a.name || "", b.displayName || ("" !== a ? "ForwardRef(" + a + ")" : "ForwardRef");
    case 7:
      return "Fragment";
    case 5:
      return b;
    case 4:
      return "Portal";
    case 3:
      return "Root";
    case 6:
      return "Text";
    case 16:
      return Qa(b);
    case 8:
      return b === za ? "StrictMode" : "Mode";
    case 22:
      return "Offscreen";
    case 12:
      return "Profiler";
    case 21:
      return "Scope";
    case 13:
      return "Suspense";
    case 19:
      return "SuspenseList";
    case 25:
      return "TracingMarker";
    case 1:
    case 0:
    case 17:
    case 2:
    case 14:
    case 15:
      if ("function" === typeof b) return b.displayName || b.name || null;
      if ("string" === typeof b) return b;
  }
  return null;
}
function Sa(a) {
  switch (typeof a) {
    case "boolean":
    case "number":
    case "string":
    case "undefined":
      return a;
    case "object":
      return a;
    default:
      return "";
  }
}
function Ta(a) {
  var b = a.type;
  return (a = a.nodeName) && "input" === a.toLowerCase() && ("checkbox" === b || "radio" === b);
}
function Ua(a) {
  var b = Ta(a) ? "checked" : "value",
    c = Object.getOwnPropertyDescriptor(a.constructor.prototype, b),
    d = "" + a[b];
  if (!a.hasOwnProperty(b) && "undefined" !== typeof c && "function" === typeof c.get && "function" === typeof c.set) {
    var e = c.get,
      f = c.set;
    Object.defineProperty(a, b, {
      configurable: !0,
      get: function get() {
        return e.call(this);
      },
      set: function set(a) {
        d = "" + a;
        f.call(this, a);
      }
    });
    Object.defineProperty(a, b, {
      enumerable: c.enumerable
    });
    return {
      getValue: function getValue() {
        return d;
      },
      setValue: function setValue(a) {
        d = "" + a;
      },
      stopTracking: function stopTracking() {
        a._valueTracker = null;
        delete a[b];
      }
    };
  }
}
function Va(a) {
  a._valueTracker || (a._valueTracker = Ua(a));
}
function Wa(a) {
  if (!a) return !1;
  var b = a._valueTracker;
  if (!b) return !0;
  var c = b.getValue();
  var d = "";
  a && (d = Ta(a) ? a.checked ? "true" : "false" : a.value);
  a = d;
  return a !== c ? (b.setValue(a), !0) : !1;
}
function Xa(a) {
  a = a || ("undefined" !== typeof document ? document : void 0);
  if ("undefined" === typeof a) return null;
  try {
    return a.activeElement || a.body;
  } catch (b) {
    return a.body;
  }
}
function Ya(a, b) {
  var c = b.checked;
  return A({}, b, {
    defaultChecked: void 0,
    defaultValue: void 0,
    value: void 0,
    checked: null != c ? c : a._wrapperState.initialChecked
  });
}
function Za(a, b) {
  var c = null == b.defaultValue ? "" : b.defaultValue,
    d = null != b.checked ? b.checked : b.defaultChecked;
  c = Sa(null != b.value ? b.value : c);
  a._wrapperState = {
    initialChecked: d,
    initialValue: c,
    controlled: "checkbox" === b.type || "radio" === b.type ? null != b.checked : null != b.value
  };
}
function ab(a, b) {
  b = b.checked;
  null != b && ta(a, "checked", b, !1);
}
function bb(a, b) {
  ab(a, b);
  var c = Sa(b.value),
    d = b.type;
  if (null != c) {
    if ("number" === d) {
      if (0 === c && "" === a.value || a.value != c) a.value = "" + c;
    } else a.value !== "" + c && (a.value = "" + c);
  } else if ("submit" === d || "reset" === d) {
    a.removeAttribute("value");
    return;
  }
  b.hasOwnProperty("value") ? cb(a, b.type, c) : b.hasOwnProperty("defaultValue") && cb(a, b.type, Sa(b.defaultValue));
  null == b.checked && null != b.defaultChecked && (a.defaultChecked = !!b.defaultChecked);
}
function db(a, b, c) {
  if (b.hasOwnProperty("value") || b.hasOwnProperty("defaultValue")) {
    var d = b.type;
    if (!("submit" !== d && "reset" !== d || void 0 !== b.value && null !== b.value)) return;
    b = "" + a._wrapperState.initialValue;
    c || b === a.value || (a.value = b);
    a.defaultValue = b;
  }
  c = a.name;
  "" !== c && (a.name = "");
  a.defaultChecked = !!a._wrapperState.initialChecked;
  "" !== c && (a.name = c);
}
function cb(a, b, c) {
  if ("number" !== b || Xa(a.ownerDocument) !== a) null == c ? a.defaultValue = "" + a._wrapperState.initialValue : a.defaultValue !== "" + c && (a.defaultValue = "" + c);
}
var eb = Array.isArray;
function fb(a, b, c, d) {
  a = a.options;
  if (b) {
    b = {};
    for (var e = 0; e < c.length; e++) b["$" + c[e]] = !0;
    for (c = 0; c < a.length; c++) e = b.hasOwnProperty("$" + a[c].value), a[c].selected !== e && (a[c].selected = e), e && d && (a[c].defaultSelected = !0);
  } else {
    c = "" + Sa(c);
    b = null;
    for (e = 0; e < a.length; e++) {
      if (a[e].value === c) {
        a[e].selected = !0;
        d && (a[e].defaultSelected = !0);
        return;
      }
      null !== b || a[e].disabled || (b = a[e]);
    }
    null !== b && (b.selected = !0);
  }
}
function gb(a, b) {
  if (null != b.dangerouslySetInnerHTML) throw Error(p(91));
  return A({}, b, {
    value: void 0,
    defaultValue: void 0,
    children: "" + a._wrapperState.initialValue
  });
}
function hb(a, b) {
  var c = b.value;
  if (null == c) {
    c = b.children;
    b = b.defaultValue;
    if (null != c) {
      if (null != b) throw Error(p(92));
      if (eb(c)) {
        if (1 < c.length) throw Error(p(93));
        c = c[0];
      }
      b = c;
    }
    null == b && (b = "");
    c = b;
  }
  a._wrapperState = {
    initialValue: Sa(c)
  };
}
function ib(a, b) {
  var c = Sa(b.value),
    d = Sa(b.defaultValue);
  null != c && (c = "" + c, c !== a.value && (a.value = c), null == b.defaultValue && a.defaultValue !== c && (a.defaultValue = c));
  null != d && (a.defaultValue = "" + d);
}
function jb(a) {
  var b = a.textContent;
  b === a._wrapperState.initialValue && "" !== b && null !== b && (a.value = b);
}
function kb(a) {
  switch (a) {
    case "svg":
      return "http://www.w3.org/2000/svg";
    case "math":
      return "http://www.w3.org/1998/Math/MathML";
    default:
      return "http://www.w3.org/1999/xhtml";
  }
}
function lb(a, b) {
  return null == a || "http://www.w3.org/1999/xhtml" === a ? kb(b) : "http://www.w3.org/2000/svg" === a && "foreignObject" === b ? "http://www.w3.org/1999/xhtml" : a;
}
var mb,
  nb = function (a) {
    return "undefined" !== typeof MSApp && MSApp.execUnsafeLocalFunction ? function (b, c, d, e) {
      MSApp.execUnsafeLocalFunction(function () {
        return a(b, c, d, e);
      });
    } : a;
  }(function (a, b) {
    if ("http://www.w3.org/2000/svg" !== a.namespaceURI || "innerHTML" in a) a.innerHTML = b;else {
      mb = mb || document.createElement("div");
      mb.innerHTML = "<svg>" + b.valueOf().toString() + "</svg>";
      for (b = mb.firstChild; a.firstChild;) a.removeChild(a.firstChild);
      for (; b.firstChild;) a.appendChild(b.firstChild);
    }
  });
function ob(a, b) {
  if (b) {
    var c = a.firstChild;
    if (c && c === a.lastChild && 3 === c.nodeType) {
      c.nodeValue = b;
      return;
    }
  }
  a.textContent = b;
}
var pb = {
    animationIterationCount: !0,
    aspectRatio: !0,
    borderImageOutset: !0,
    borderImageSlice: !0,
    borderImageWidth: !0,
    boxFlex: !0,
    boxFlexGroup: !0,
    boxOrdinalGroup: !0,
    columnCount: !0,
    columns: !0,
    flex: !0,
    flexGrow: !0,
    flexPositive: !0,
    flexShrink: !0,
    flexNegative: !0,
    flexOrder: !0,
    gridArea: !0,
    gridRow: !0,
    gridRowEnd: !0,
    gridRowSpan: !0,
    gridRowStart: !0,
    gridColumn: !0,
    gridColumnEnd: !0,
    gridColumnSpan: !0,
    gridColumnStart: !0,
    fontWeight: !0,
    lineClamp: !0,
    lineHeight: !0,
    opacity: !0,
    order: !0,
    orphans: !0,
    tabSize: !0,
    widows: !0,
    zIndex: !0,
    zoom: !0,
    fillOpacity: !0,
    floodOpacity: !0,
    stopOpacity: !0,
    strokeDasharray: !0,
    strokeDashoffset: !0,
    strokeMiterlimit: !0,
    strokeOpacity: !0,
    strokeWidth: !0
  },
  qb = ["Webkit", "ms", "Moz", "O"];
Object.keys(pb).forEach(function (a) {
  qb.forEach(function (b) {
    b = b + a.charAt(0).toUpperCase() + a.substring(1);
    pb[b] = pb[a];
  });
});
function rb(a, b, c) {
  return null == b || "boolean" === typeof b || "" === b ? "" : c || "number" !== typeof b || 0 === b || pb.hasOwnProperty(a) && pb[a] ? ("" + b).trim() : b + "px";
}
function sb(a, b) {
  a = a.style;
  for (var c in b) if (b.hasOwnProperty(c)) {
    var d = 0 === c.indexOf("--"),
      e = rb(c, b[c], d);
    "float" === c && (c = "cssFloat");
    d ? a.setProperty(c, e) : a[c] = e;
  }
}
var tb = A({
  menuitem: !0
}, {
  area: !0,
  base: !0,
  br: !0,
  col: !0,
  embed: !0,
  hr: !0,
  img: !0,
  input: !0,
  keygen: !0,
  link: !0,
  meta: !0,
  param: !0,
  source: !0,
  track: !0,
  wbr: !0
});
function ub(a, b) {
  if (b) {
    if (tb[a] && (null != b.children || null != b.dangerouslySetInnerHTML)) throw Error(p(137, a));
    if (null != b.dangerouslySetInnerHTML) {
      if (null != b.children) throw Error(p(60));
      if ("object" !== typeof b.dangerouslySetInnerHTML || !("__html" in b.dangerouslySetInnerHTML)) throw Error(p(61));
    }
    if (null != b.style && "object" !== typeof b.style) throw Error(p(62));
  }
}
function vb(a, b) {
  if (-1 === a.indexOf("-")) return "string" === typeof b.is;
  switch (a) {
    case "annotation-xml":
    case "color-profile":
    case "font-face":
    case "font-face-src":
    case "font-face-uri":
    case "font-face-format":
    case "font-face-name":
    case "missing-glyph":
      return !1;
    default:
      return !0;
  }
}
var wb = null;
function xb(a) {
  a = a.target || a.srcElement || window;
  a.correspondingUseElement && (a = a.correspondingUseElement);
  return 3 === a.nodeType ? a.parentNode : a;
}
var yb = null,
  zb = null,
  Ab = null;
function Bb(a) {
  if (a = Cb(a)) {
    if ("function" !== typeof yb) throw Error(p(280));
    var b = a.stateNode;
    b && (b = Db(b), yb(a.stateNode, a.type, b));
  }
}
function Eb(a) {
  zb ? Ab ? Ab.push(a) : Ab = [a] : zb = a;
}
function Fb() {
  if (zb) {
    var a = zb,
      b = Ab;
    Ab = zb = null;
    Bb(a);
    if (b) for (a = 0; a < b.length; a++) Bb(b[a]);
  }
}
function Gb(a, b) {
  return a(b);
}
function Hb() {}
var Ib = !1;
function Jb(a, b, c) {
  if (Ib) return a(b, c);
  Ib = !0;
  try {
    return Gb(a, b, c);
  } finally {
    if (Ib = !1, null !== zb || null !== Ab) Hb(), Fb();
  }
}
function Kb(a, b) {
  var c = a.stateNode;
  if (null === c) return null;
  var d = Db(c);
  if (null === d) return null;
  c = d[b];
  a: switch (b) {
    case "onClick":
    case "onClickCapture":
    case "onDoubleClick":
    case "onDoubleClickCapture":
    case "onMouseDown":
    case "onMouseDownCapture":
    case "onMouseMove":
    case "onMouseMoveCapture":
    case "onMouseUp":
    case "onMouseUpCapture":
    case "onMouseEnter":
      (d = !d.disabled) || (a = a.type, d = !("button" === a || "input" === a || "select" === a || "textarea" === a));
      a = !d;
      break a;
    default:
      a = !1;
  }
  if (a) return null;
  if (c && "function" !== typeof c) throw Error(p(231, b, typeof c));
  return c;
}
var Lb = !1;
if (ia) try {
  var Mb = {};
  Object.defineProperty(Mb, "passive", {
    get: function get() {
      Lb = !0;
    }
  });
  window.addEventListener("test", Mb, Mb);
  window.removeEventListener("test", Mb, Mb);
} catch (a) {
  Lb = !1;
}
function Nb(a, b, c, d, e, f, g, h, k) {
  var l = Array.prototype.slice.call(arguments, 3);
  try {
    b.apply(c, l);
  } catch (m) {
    this.onError(m);
  }
}
var Ob = !1,
  Pb = null,
  Qb = !1,
  Rb = null,
  Sb = {
    onError: function onError(a) {
      Ob = !0;
      Pb = a;
    }
  };
function Tb(a, b, c, d, e, f, g, h, k) {
  Ob = !1;
  Pb = null;
  Nb.apply(Sb, arguments);
}
function Ub(a, b, c, d, e, f, g, h, k) {
  Tb.apply(this, arguments);
  if (Ob) {
    if (Ob) {
      var l = Pb;
      Ob = !1;
      Pb = null;
    } else throw Error(p(198));
    Qb || (Qb = !0, Rb = l);
  }
}
function Vb(a) {
  var b = a,
    c = a;
  if (a.alternate) for (; b.return;) b = b.return;else {
    a = b;
    do b = a, 0 !== (b.flags & 4098) && (c = b.return), a = b.return; while (a);
  }
  return 3 === b.tag ? c : null;
}
function Wb(a) {
  if (13 === a.tag) {
    var b = a.memoizedState;
    null === b && (a = a.alternate, null !== a && (b = a.memoizedState));
    if (null !== b) return b.dehydrated;
  }
  return null;
}
function Xb(a) {
  if (Vb(a) !== a) throw Error(p(188));
}
function Yb(a) {
  var b = a.alternate;
  if (!b) {
    b = Vb(a);
    if (null === b) throw Error(p(188));
    return b !== a ? null : a;
  }
  for (var c = a, d = b;;) {
    var e = c.return;
    if (null === e) break;
    var f = e.alternate;
    if (null === f) {
      d = e.return;
      if (null !== d) {
        c = d;
        continue;
      }
      break;
    }
    if (e.child === f.child) {
      for (f = e.child; f;) {
        if (f === c) return Xb(e), a;
        if (f === d) return Xb(e), b;
        f = f.sibling;
      }
      throw Error(p(188));
    }
    if (c.return !== d.return) c = e, d = f;else {
      for (var g = !1, h = e.child; h;) {
        if (h === c) {
          g = !0;
          c = e;
          d = f;
          break;
        }
        if (h === d) {
          g = !0;
          d = e;
          c = f;
          break;
        }
        h = h.sibling;
      }
      if (!g) {
        for (h = f.child; h;) {
          if (h === c) {
            g = !0;
            c = f;
            d = e;
            break;
          }
          if (h === d) {
            g = !0;
            d = f;
            c = e;
            break;
          }
          h = h.sibling;
        }
        if (!g) throw Error(p(189));
      }
    }
    if (c.alternate !== d) throw Error(p(190));
  }
  if (3 !== c.tag) throw Error(p(188));
  return c.stateNode.current === c ? a : b;
}
function Zb(a) {
  a = Yb(a);
  return null !== a ? $b(a) : null;
}
function $b(a) {
  if (5 === a.tag || 6 === a.tag) return a;
  for (a = a.child; null !== a;) {
    var b = $b(a);
    if (null !== b) return b;
    a = a.sibling;
  }
  return null;
}
var ac = ca.unstable_scheduleCallback,
  bc = ca.unstable_cancelCallback,
  cc = ca.unstable_shouldYield,
  dc = ca.unstable_requestPaint,
  B = ca.unstable_now,
  ec = ca.unstable_getCurrentPriorityLevel,
  fc = ca.unstable_ImmediatePriority,
  gc = ca.unstable_UserBlockingPriority,
  hc = ca.unstable_NormalPriority,
  ic = ca.unstable_LowPriority,
  jc = ca.unstable_IdlePriority,
  kc = null,
  lc = null;
function mc(a) {
  if (lc && "function" === typeof lc.onCommitFiberRoot) try {
    lc.onCommitFiberRoot(kc, a, void 0, 128 === (a.current.flags & 128));
  } catch (b) {}
}
var oc = Math.clz32 ? Math.clz32 : nc,
  pc = Math.log,
  qc = Math.LN2;
function nc(a) {
  a >>>= 0;
  return 0 === a ? 32 : 31 - (pc(a) / qc | 0) | 0;
}
var rc = 64,
  sc = 4194304;
function tc(a) {
  switch (a & -a) {
    case 1:
      return 1;
    case 2:
      return 2;
    case 4:
      return 4;
    case 8:
      return 8;
    case 16:
      return 16;
    case 32:
      return 32;
    case 64:
    case 128:
    case 256:
    case 512:
    case 1024:
    case 2048:
    case 4096:
    case 8192:
    case 16384:
    case 32768:
    case 65536:
    case 131072:
    case 262144:
    case 524288:
    case 1048576:
    case 2097152:
      return a & 4194240;
    case 4194304:
    case 8388608:
    case 16777216:
    case 33554432:
    case 67108864:
      return a & 130023424;
    case 134217728:
      return 134217728;
    case 268435456:
      return 268435456;
    case 536870912:
      return 536870912;
    case 1073741824:
      return 1073741824;
    default:
      return a;
  }
}
function uc(a, b) {
  var c = a.pendingLanes;
  if (0 === c) return 0;
  var d = 0,
    e = a.suspendedLanes,
    f = a.pingedLanes,
    g = c & 268435455;
  if (0 !== g) {
    var h = g & ~e;
    0 !== h ? d = tc(h) : (f &= g, 0 !== f && (d = tc(f)));
  } else g = c & ~e, 0 !== g ? d = tc(g) : 0 !== f && (d = tc(f));
  if (0 === d) return 0;
  if (0 !== b && b !== d && 0 === (b & e) && (e = d & -d, f = b & -b, e >= f || 16 === e && 0 !== (f & 4194240))) return b;
  0 !== (d & 4) && (d |= c & 16);
  b = a.entangledLanes;
  if (0 !== b) for (a = a.entanglements, b &= d; 0 < b;) c = 31 - oc(b), e = 1 << c, d |= a[c], b &= ~e;
  return d;
}
function vc(a, b) {
  switch (a) {
    case 1:
    case 2:
    case 4:
      return b + 250;
    case 8:
    case 16:
    case 32:
    case 64:
    case 128:
    case 256:
    case 512:
    case 1024:
    case 2048:
    case 4096:
    case 8192:
    case 16384:
    case 32768:
    case 65536:
    case 131072:
    case 262144:
    case 524288:
    case 1048576:
    case 2097152:
      return b + 5E3;
    case 4194304:
    case 8388608:
    case 16777216:
    case 33554432:
    case 67108864:
      return -1;
    case 134217728:
    case 268435456:
    case 536870912:
    case 1073741824:
      return -1;
    default:
      return -1;
  }
}
function wc(a, b) {
  for (var c = a.suspendedLanes, d = a.pingedLanes, e = a.expirationTimes, f = a.pendingLanes; 0 < f;) {
    var g = 31 - oc(f),
      h = 1 << g,
      k = e[g];
    if (-1 === k) {
      if (0 === (h & c) || 0 !== (h & d)) e[g] = vc(h, b);
    } else k <= b && (a.expiredLanes |= h);
    f &= ~h;
  }
}
function xc(a) {
  a = a.pendingLanes & -1073741825;
  return 0 !== a ? a : a & 1073741824 ? 1073741824 : 0;
}
function yc() {
  var a = rc;
  rc <<= 1;
  0 === (rc & 4194240) && (rc = 64);
  return a;
}
function zc(a) {
  for (var b = [], c = 0; 31 > c; c++) b.push(a);
  return b;
}
function Ac(a, b, c) {
  a.pendingLanes |= b;
  536870912 !== b && (a.suspendedLanes = 0, a.pingedLanes = 0);
  a = a.eventTimes;
  b = 31 - oc(b);
  a[b] = c;
}
function Bc(a, b) {
  var c = a.pendingLanes & ~b;
  a.pendingLanes = b;
  a.suspendedLanes = 0;
  a.pingedLanes = 0;
  a.expiredLanes &= b;
  a.mutableReadLanes &= b;
  a.entangledLanes &= b;
  b = a.entanglements;
  var d = a.eventTimes;
  for (a = a.expirationTimes; 0 < c;) {
    var e = 31 - oc(c),
      f = 1 << e;
    b[e] = 0;
    d[e] = -1;
    a[e] = -1;
    c &= ~f;
  }
}
function Cc(a, b) {
  var c = a.entangledLanes |= b;
  for (a = a.entanglements; c;) {
    var d = 31 - oc(c),
      e = 1 << d;
    e & b | a[d] & b && (a[d] |= b);
    c &= ~e;
  }
}
var C = 0;
function Dc(a) {
  a &= -a;
  return 1 < a ? 4 < a ? 0 !== (a & 268435455) ? 16 : 536870912 : 4 : 1;
}
var Ec,
  Fc,
  Gc,
  Hc,
  Ic,
  Jc = !1,
  Kc = [],
  Lc = null,
  Mc = null,
  Nc = null,
  Oc = new Map(),
  Pc = new Map(),
  Qc = [],
  Rc = "mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset submit".split(" ");
function Sc(a, b) {
  switch (a) {
    case "focusin":
    case "focusout":
      Lc = null;
      break;
    case "dragenter":
    case "dragleave":
      Mc = null;
      break;
    case "mouseover":
    case "mouseout":
      Nc = null;
      break;
    case "pointerover":
    case "pointerout":
      Oc.delete(b.pointerId);
      break;
    case "gotpointercapture":
    case "lostpointercapture":
      Pc.delete(b.pointerId);
  }
}
function Tc(a, b, c, d, e, f) {
  if (null === a || a.nativeEvent !== f) return a = {
    blockedOn: b,
    domEventName: c,
    eventSystemFlags: d,
    nativeEvent: f,
    targetContainers: [e]
  }, null !== b && (b = Cb(b), null !== b && Fc(b)), a;
  a.eventSystemFlags |= d;
  b = a.targetContainers;
  null !== e && -1 === b.indexOf(e) && b.push(e);
  return a;
}
function Uc(a, b, c, d, e) {
  switch (b) {
    case "focusin":
      return Lc = Tc(Lc, a, b, c, d, e), !0;
    case "dragenter":
      return Mc = Tc(Mc, a, b, c, d, e), !0;
    case "mouseover":
      return Nc = Tc(Nc, a, b, c, d, e), !0;
    case "pointerover":
      var f = e.pointerId;
      Oc.set(f, Tc(Oc.get(f) || null, a, b, c, d, e));
      return !0;
    case "gotpointercapture":
      return f = e.pointerId, Pc.set(f, Tc(Pc.get(f) || null, a, b, c, d, e)), !0;
  }
  return !1;
}
function Vc(a) {
  var b = Wc(a.target);
  if (null !== b) {
    var c = Vb(b);
    if (null !== c) if (b = c.tag, 13 === b) {
      if (b = Wb(c), null !== b) {
        a.blockedOn = b;
        Ic(a.priority, function () {
          Gc(c);
        });
        return;
      }
    } else if (3 === b && c.stateNode.current.memoizedState.isDehydrated) {
      a.blockedOn = 3 === c.tag ? c.stateNode.containerInfo : null;
      return;
    }
  }
  a.blockedOn = null;
}
function Xc(a) {
  if (null !== a.blockedOn) return !1;
  for (var b = a.targetContainers; 0 < b.length;) {
    var c = Yc(a.domEventName, a.eventSystemFlags, b[0], a.nativeEvent);
    if (null === c) {
      c = a.nativeEvent;
      var d = new c.constructor(c.type, c);
      wb = d;
      c.target.dispatchEvent(d);
      wb = null;
    } else return b = Cb(c), null !== b && Fc(b), a.blockedOn = c, !1;
    b.shift();
  }
  return !0;
}
function Zc(a, b, c) {
  Xc(a) && c.delete(b);
}
function $c() {
  Jc = !1;
  null !== Lc && Xc(Lc) && (Lc = null);
  null !== Mc && Xc(Mc) && (Mc = null);
  null !== Nc && Xc(Nc) && (Nc = null);
  Oc.forEach(Zc);
  Pc.forEach(Zc);
}
function ad(a, b) {
  a.blockedOn === b && (a.blockedOn = null, Jc || (Jc = !0, ca.unstable_scheduleCallback(ca.unstable_NormalPriority, $c)));
}
function bd(a) {
  function b(b) {
    return ad(b, a);
  }
  if (0 < Kc.length) {
    ad(Kc[0], a);
    for (var c = 1; c < Kc.length; c++) {
      var d = Kc[c];
      d.blockedOn === a && (d.blockedOn = null);
    }
  }
  null !== Lc && ad(Lc, a);
  null !== Mc && ad(Mc, a);
  null !== Nc && ad(Nc, a);
  Oc.forEach(b);
  Pc.forEach(b);
  for (c = 0; c < Qc.length; c++) d = Qc[c], d.blockedOn === a && (d.blockedOn = null);
  for (; 0 < Qc.length && (c = Qc[0], null === c.blockedOn);) Vc(c), null === c.blockedOn && Qc.shift();
}
var cd = ua.ReactCurrentBatchConfig,
  dd = !0;
function ed(a, b, c, d) {
  var e = C,
    f = cd.transition;
  cd.transition = null;
  try {
    C = 1, fd(a, b, c, d);
  } finally {
    C = e, cd.transition = f;
  }
}
function gd(a, b, c, d) {
  var e = C,
    f = cd.transition;
  cd.transition = null;
  try {
    C = 4, fd(a, b, c, d);
  } finally {
    C = e, cd.transition = f;
  }
}
function fd(a, b, c, d) {
  if (dd) {
    var e = Yc(a, b, c, d);
    if (null === e) hd(a, b, d, id, c), Sc(a, d);else if (Uc(e, a, b, c, d)) d.stopPropagation();else if (Sc(a, d), b & 4 && -1 < Rc.indexOf(a)) {
      for (; null !== e;) {
        var f = Cb(e);
        null !== f && Ec(f);
        f = Yc(a, b, c, d);
        null === f && hd(a, b, d, id, c);
        if (f === e) break;
        e = f;
      }
      null !== e && d.stopPropagation();
    } else hd(a, b, d, null, c);
  }
}
var id = null;
function Yc(a, b, c, d) {
  id = null;
  a = xb(d);
  a = Wc(a);
  if (null !== a) if (b = Vb(a), null === b) a = null;else if (c = b.tag, 13 === c) {
    a = Wb(b);
    if (null !== a) return a;
    a = null;
  } else if (3 === c) {
    if (b.stateNode.current.memoizedState.isDehydrated) return 3 === b.tag ? b.stateNode.containerInfo : null;
    a = null;
  } else b !== a && (a = null);
  id = a;
  return null;
}
function jd(a) {
  switch (a) {
    case "cancel":
    case "click":
    case "close":
    case "contextmenu":
    case "copy":
    case "cut":
    case "auxclick":
    case "dblclick":
    case "dragend":
    case "dragstart":
    case "drop":
    case "focusin":
    case "focusout":
    case "input":
    case "invalid":
    case "keydown":
    case "keypress":
    case "keyup":
    case "mousedown":
    case "mouseup":
    case "paste":
    case "pause":
    case "play":
    case "pointercancel":
    case "pointerdown":
    case "pointerup":
    case "ratechange":
    case "reset":
    case "resize":
    case "seeked":
    case "submit":
    case "touchcancel":
    case "touchend":
    case "touchstart":
    case "volumechange":
    case "change":
    case "selectionchange":
    case "textInput":
    case "compositionstart":
    case "compositionend":
    case "compositionupdate":
    case "beforeblur":
    case "afterblur":
    case "beforeinput":
    case "blur":
    case "fullscreenchange":
    case "focus":
    case "hashchange":
    case "popstate":
    case "select":
    case "selectstart":
      return 1;
    case "drag":
    case "dragenter":
    case "dragexit":
    case "dragleave":
    case "dragover":
    case "mousemove":
    case "mouseout":
    case "mouseover":
    case "pointermove":
    case "pointerout":
    case "pointerover":
    case "scroll":
    case "toggle":
    case "touchmove":
    case "wheel":
    case "mouseenter":
    case "mouseleave":
    case "pointerenter":
    case "pointerleave":
      return 4;
    case "message":
      switch (ec()) {
        case fc:
          return 1;
        case gc:
          return 4;
        case hc:
        case ic:
          return 16;
        case jc:
          return 536870912;
        default:
          return 16;
      }
    default:
      return 16;
  }
}
var kd = null,
  ld = null,
  md = null;
function nd() {
  if (md) return md;
  var a,
    b = ld,
    c = b.length,
    d,
    e = "value" in kd ? kd.value : kd.textContent,
    f = e.length;
  for (a = 0; a < c && b[a] === e[a]; a++);
  var g = c - a;
  for (d = 1; d <= g && b[c - d] === e[f - d]; d++);
  return md = e.slice(a, 1 < d ? 1 - d : void 0);
}
function od(a) {
  var b = a.keyCode;
  "charCode" in a ? (a = a.charCode, 0 === a && 13 === b && (a = 13)) : a = b;
  10 === a && (a = 13);
  return 32 <= a || 13 === a ? a : 0;
}
function pd() {
  return !0;
}
function qd() {
  return !1;
}
function rd(a) {
  function b(b, d, e, f, g) {
    this._reactName = b;
    this._targetInst = e;
    this.type = d;
    this.nativeEvent = f;
    this.target = g;
    this.currentTarget = null;
    for (var c in a) a.hasOwnProperty(c) && (b = a[c], this[c] = b ? b(f) : f[c]);
    this.isDefaultPrevented = (null != f.defaultPrevented ? f.defaultPrevented : !1 === f.returnValue) ? pd : qd;
    this.isPropagationStopped = qd;
    return this;
  }
  A(b.prototype, {
    preventDefault: function preventDefault() {
      this.defaultPrevented = !0;
      var a = this.nativeEvent;
      a && (a.preventDefault ? a.preventDefault() : "unknown" !== typeof a.returnValue && (a.returnValue = !1), this.isDefaultPrevented = pd);
    },
    stopPropagation: function stopPropagation() {
      var a = this.nativeEvent;
      a && (a.stopPropagation ? a.stopPropagation() : "unknown" !== typeof a.cancelBubble && (a.cancelBubble = !0), this.isPropagationStopped = pd);
    },
    persist: function persist() {},
    isPersistent: pd
  });
  return b;
}
var sd = {
    eventPhase: 0,
    bubbles: 0,
    cancelable: 0,
    timeStamp: function timeStamp(a) {
      return a.timeStamp || Date.now();
    },
    defaultPrevented: 0,
    isTrusted: 0
  },
  td = rd(sd),
  ud = A({}, sd, {
    view: 0,
    detail: 0
  }),
  vd = rd(ud),
  wd,
  xd,
  yd,
  Ad = A({}, ud, {
    screenX: 0,
    screenY: 0,
    clientX: 0,
    clientY: 0,
    pageX: 0,
    pageY: 0,
    ctrlKey: 0,
    shiftKey: 0,
    altKey: 0,
    metaKey: 0,
    getModifierState: zd,
    button: 0,
    buttons: 0,
    relatedTarget: function relatedTarget(a) {
      return void 0 === a.relatedTarget ? a.fromElement === a.srcElement ? a.toElement : a.fromElement : a.relatedTarget;
    },
    movementX: function movementX(a) {
      if ("movementX" in a) return a.movementX;
      a !== yd && (yd && "mousemove" === a.type ? (wd = a.screenX - yd.screenX, xd = a.screenY - yd.screenY) : xd = wd = 0, yd = a);
      return wd;
    },
    movementY: function movementY(a) {
      return "movementY" in a ? a.movementY : xd;
    }
  }),
  Bd = rd(Ad),
  Cd = A({}, Ad, {
    dataTransfer: 0
  }),
  Dd = rd(Cd),
  Ed = A({}, ud, {
    relatedTarget: 0
  }),
  Fd = rd(Ed),
  Gd = A({}, sd, {
    animationName: 0,
    elapsedTime: 0,
    pseudoElement: 0
  }),
  Hd = rd(Gd),
  Id = A({}, sd, {
    clipboardData: function clipboardData(a) {
      return "clipboardData" in a ? a.clipboardData : window.clipboardData;
    }
  }),
  Jd = rd(Id),
  Kd = A({}, sd, {
    data: 0
  }),
  Ld = rd(Kd),
  Md = {
    Esc: "Escape",
    Spacebar: " ",
    Left: "ArrowLeft",
    Up: "ArrowUp",
    Right: "ArrowRight",
    Down: "ArrowDown",
    Del: "Delete",
    Win: "OS",
    Menu: "ContextMenu",
    Apps: "ContextMenu",
    Scroll: "ScrollLock",
    MozPrintableKey: "Unidentified"
  },
  Nd = {
    8: "Backspace",
    9: "Tab",
    12: "Clear",
    13: "Enter",
    16: "Shift",
    17: "Control",
    18: "Alt",
    19: "Pause",
    20: "CapsLock",
    27: "Escape",
    32: " ",
    33: "PageUp",
    34: "PageDown",
    35: "End",
    36: "Home",
    37: "ArrowLeft",
    38: "ArrowUp",
    39: "ArrowRight",
    40: "ArrowDown",
    45: "Insert",
    46: "Delete",
    112: "F1",
    113: "F2",
    114: "F3",
    115: "F4",
    116: "F5",
    117: "F6",
    118: "F7",
    119: "F8",
    120: "F9",
    121: "F10",
    122: "F11",
    123: "F12",
    144: "NumLock",
    145: "ScrollLock",
    224: "Meta"
  },
  Od = {
    Alt: "altKey",
    Control: "ctrlKey",
    Meta: "metaKey",
    Shift: "shiftKey"
  };
function Pd(a) {
  var b = this.nativeEvent;
  return b.getModifierState ? b.getModifierState(a) : (a = Od[a]) ? !!b[a] : !1;
}
function zd() {
  return Pd;
}
var Qd = A({}, ud, {
    key: function key(a) {
      if (a.key) {
        var b = Md[a.key] || a.key;
        if ("Unidentified" !== b) return b;
      }
      return "keypress" === a.type ? (a = od(a), 13 === a ? "Enter" : String.fromCharCode(a)) : "keydown" === a.type || "keyup" === a.type ? Nd[a.keyCode] || "Unidentified" : "";
    },
    code: 0,
    location: 0,
    ctrlKey: 0,
    shiftKey: 0,
    altKey: 0,
    metaKey: 0,
    repeat: 0,
    locale: 0,
    getModifierState: zd,
    charCode: function charCode(a) {
      return "keypress" === a.type ? od(a) : 0;
    },
    keyCode: function keyCode(a) {
      return "keydown" === a.type || "keyup" === a.type ? a.keyCode : 0;
    },
    which: function which(a) {
      return "keypress" === a.type ? od(a) : "keydown" === a.type || "keyup" === a.type ? a.keyCode : 0;
    }
  }),
  Rd = rd(Qd),
  Sd = A({}, Ad, {
    pointerId: 0,
    width: 0,
    height: 0,
    pressure: 0,
    tangentialPressure: 0,
    tiltX: 0,
    tiltY: 0,
    twist: 0,
    pointerType: 0,
    isPrimary: 0
  }),
  Td = rd(Sd),
  Ud = A({}, ud, {
    touches: 0,
    targetTouches: 0,
    changedTouches: 0,
    altKey: 0,
    metaKey: 0,
    ctrlKey: 0,
    shiftKey: 0,
    getModifierState: zd
  }),
  Vd = rd(Ud),
  Wd = A({}, sd, {
    propertyName: 0,
    elapsedTime: 0,
    pseudoElement: 0
  }),
  Xd = rd(Wd),
  Yd = A({}, Ad, {
    deltaX: function deltaX(a) {
      return "deltaX" in a ? a.deltaX : "wheelDeltaX" in a ? -a.wheelDeltaX : 0;
    },
    deltaY: function deltaY(a) {
      return "deltaY" in a ? a.deltaY : "wheelDeltaY" in a ? -a.wheelDeltaY : "wheelDelta" in a ? -a.wheelDelta : 0;
    },
    deltaZ: 0,
    deltaMode: 0
  }),
  Zd = rd(Yd),
  $d = [9, 13, 27, 32],
  ae = ia && "CompositionEvent" in window,
  be = null;
ia && "documentMode" in document && (be = document.documentMode);
var ce = ia && "TextEvent" in window && !be,
  de = ia && (!ae || be && 8 < be && 11 >= be),
  ee = String.fromCharCode(32),
  fe = !1;
function ge(a, b) {
  switch (a) {
    case "keyup":
      return -1 !== $d.indexOf(b.keyCode);
    case "keydown":
      return 229 !== b.keyCode;
    case "keypress":
    case "mousedown":
    case "focusout":
      return !0;
    default:
      return !1;
  }
}
function he(a) {
  a = a.detail;
  return "object" === typeof a && "data" in a ? a.data : null;
}
var ie = !1;
function je(a, b) {
  switch (a) {
    case "compositionend":
      return he(b);
    case "keypress":
      if (32 !== b.which) return null;
      fe = !0;
      return ee;
    case "textInput":
      return a = b.data, a === ee && fe ? null : a;
    default:
      return null;
  }
}
function ke(a, b) {
  if (ie) return "compositionend" === a || !ae && ge(a, b) ? (a = nd(), md = ld = kd = null, ie = !1, a) : null;
  switch (a) {
    case "paste":
      return null;
    case "keypress":
      if (!(b.ctrlKey || b.altKey || b.metaKey) || b.ctrlKey && b.altKey) {
        if (b.char && 1 < b.char.length) return b.char;
        if (b.which) return String.fromCharCode(b.which);
      }
      return null;
    case "compositionend":
      return de && "ko" !== b.locale ? null : b.data;
    default:
      return null;
  }
}
var le = {
  color: !0,
  date: !0,
  datetime: !0,
  "datetime-local": !0,
  email: !0,
  month: !0,
  number: !0,
  password: !0,
  range: !0,
  search: !0,
  tel: !0,
  text: !0,
  time: !0,
  url: !0,
  week: !0
};
function me(a) {
  var b = a && a.nodeName && a.nodeName.toLowerCase();
  return "input" === b ? !!le[a.type] : "textarea" === b ? !0 : !1;
}
function ne(a, b, c, d) {
  Eb(d);
  b = oe(b, "onChange");
  0 < b.length && (c = new td("onChange", "change", null, c, d), a.push({
    event: c,
    listeners: b
  }));
}
var pe = null,
  qe = null;
function re(a) {
  se(a, 0);
}
function te(a) {
  var b = ue(a);
  if (Wa(b)) return a;
}
function ve(a, b) {
  if ("change" === a) return b;
}
var we = !1;
if (ia) {
  var xe;
  if (ia) {
    var ye = ("oninput" in document);
    if (!ye) {
      var ze = document.createElement("div");
      ze.setAttribute("oninput", "return;");
      ye = "function" === typeof ze.oninput;
    }
    xe = ye;
  } else xe = !1;
  we = xe && (!document.documentMode || 9 < document.documentMode);
}
function Ae() {
  pe && (pe.detachEvent("onpropertychange", Be), qe = pe = null);
}
function Be(a) {
  if ("value" === a.propertyName && te(qe)) {
    var b = [];
    ne(b, qe, a, xb(a));
    Jb(re, b);
  }
}
function Ce(a, b, c) {
  "focusin" === a ? (Ae(), pe = b, qe = c, pe.attachEvent("onpropertychange", Be)) : "focusout" === a && Ae();
}
function De(a) {
  if ("selectionchange" === a || "keyup" === a || "keydown" === a) return te(qe);
}
function Ee(a, b) {
  if ("click" === a) return te(b);
}
function Fe(a, b) {
  if ("input" === a || "change" === a) return te(b);
}
function Ge(a, b) {
  return a === b && (0 !== a || 1 / a === 1 / b) || a !== a && b !== b;
}
var He = "function" === typeof Object.is ? Object.is : Ge;
function Ie(a, b) {
  if (He(a, b)) return !0;
  if ("object" !== typeof a || null === a || "object" !== typeof b || null === b) return !1;
  var c = Object.keys(a),
    d = Object.keys(b);
  if (c.length !== d.length) return !1;
  for (d = 0; d < c.length; d++) {
    var e = c[d];
    if (!ja.call(b, e) || !He(a[e], b[e])) return !1;
  }
  return !0;
}
function Je(a) {
  for (; a && a.firstChild;) a = a.firstChild;
  return a;
}
function Ke(a, b) {
  var c = Je(a);
  a = 0;
  for (var d; c;) {
    if (3 === c.nodeType) {
      d = a + c.textContent.length;
      if (a <= b && d >= b) return {
        node: c,
        offset: b - a
      };
      a = d;
    }
    a: {
      for (; c;) {
        if (c.nextSibling) {
          c = c.nextSibling;
          break a;
        }
        c = c.parentNode;
      }
      c = void 0;
    }
    c = Je(c);
  }
}
function Le(a, b) {
  return a && b ? a === b ? !0 : a && 3 === a.nodeType ? !1 : b && 3 === b.nodeType ? Le(a, b.parentNode) : "contains" in a ? a.contains(b) : a.compareDocumentPosition ? !!(a.compareDocumentPosition(b) & 16) : !1 : !1;
}
function Me() {
  for (var a = window, b = Xa(); b instanceof a.HTMLIFrameElement;) {
    try {
      var c = "string" === typeof b.contentWindow.location.href;
    } catch (d) {
      c = !1;
    }
    if (c) a = b.contentWindow;else break;
    b = Xa(a.document);
  }
  return b;
}
function Ne(a) {
  var b = a && a.nodeName && a.nodeName.toLowerCase();
  return b && ("input" === b && ("text" === a.type || "search" === a.type || "tel" === a.type || "url" === a.type || "password" === a.type) || "textarea" === b || "true" === a.contentEditable);
}
function Oe(a) {
  var b = Me(),
    c = a.focusedElem,
    d = a.selectionRange;
  if (b !== c && c && c.ownerDocument && Le(c.ownerDocument.documentElement, c)) {
    if (null !== d && Ne(c)) if (b = d.start, a = d.end, void 0 === a && (a = b), "selectionStart" in c) c.selectionStart = b, c.selectionEnd = Math.min(a, c.value.length);else if (a = (b = c.ownerDocument || document) && b.defaultView || window, a.getSelection) {
      a = a.getSelection();
      var e = c.textContent.length,
        f = Math.min(d.start, e);
      d = void 0 === d.end ? f : Math.min(d.end, e);
      !a.extend && f > d && (e = d, d = f, f = e);
      e = Ke(c, f);
      var g = Ke(c, d);
      e && g && (1 !== a.rangeCount || a.anchorNode !== e.node || a.anchorOffset !== e.offset || a.focusNode !== g.node || a.focusOffset !== g.offset) && (b = b.createRange(), b.setStart(e.node, e.offset), a.removeAllRanges(), f > d ? (a.addRange(b), a.extend(g.node, g.offset)) : (b.setEnd(g.node, g.offset), a.addRange(b)));
    }
    b = [];
    for (a = c; a = a.parentNode;) 1 === a.nodeType && b.push({
      element: a,
      left: a.scrollLeft,
      top: a.scrollTop
    });
    "function" === typeof c.focus && c.focus();
    for (c = 0; c < b.length; c++) a = b[c], a.element.scrollLeft = a.left, a.element.scrollTop = a.top;
  }
}
var Pe = ia && "documentMode" in document && 11 >= document.documentMode,
  Qe = null,
  Re = null,
  Se = null,
  Te = !1;
function Ue(a, b, c) {
  var d = c.window === c ? c.document : 9 === c.nodeType ? c : c.ownerDocument;
  Te || null == Qe || Qe !== Xa(d) || (d = Qe, "selectionStart" in d && Ne(d) ? d = {
    start: d.selectionStart,
    end: d.selectionEnd
  } : (d = (d.ownerDocument && d.ownerDocument.defaultView || window).getSelection(), d = {
    anchorNode: d.anchorNode,
    anchorOffset: d.anchorOffset,
    focusNode: d.focusNode,
    focusOffset: d.focusOffset
  }), Se && Ie(Se, d) || (Se = d, d = oe(Re, "onSelect"), 0 < d.length && (b = new td("onSelect", "select", null, b, c), a.push({
    event: b,
    listeners: d
  }), b.target = Qe)));
}
function Ve(a, b) {
  var c = {};
  c[a.toLowerCase()] = b.toLowerCase();
  c["Webkit" + a] = "webkit" + b;
  c["Moz" + a] = "moz" + b;
  return c;
}
var We = {
    animationend: Ve("Animation", "AnimationEnd"),
    animationiteration: Ve("Animation", "AnimationIteration"),
    animationstart: Ve("Animation", "AnimationStart"),
    transitionend: Ve("Transition", "TransitionEnd")
  },
  Xe = {},
  Ye = {};
ia && (Ye = document.createElement("div").style, "AnimationEvent" in window || (delete We.animationend.animation, delete We.animationiteration.animation, delete We.animationstart.animation), "TransitionEvent" in window || delete We.transitionend.transition);
function Ze(a) {
  if (Xe[a]) return Xe[a];
  if (!We[a]) return a;
  var b = We[a],
    c;
  for (c in b) if (b.hasOwnProperty(c) && c in Ye) return Xe[a] = b[c];
  return a;
}
var $e = Ze("animationend"),
  af = Ze("animationiteration"),
  bf = Ze("animationstart"),
  cf = Ze("transitionend"),
  df = new Map(),
  ef = "abort auxClick cancel canPlay canPlayThrough click close contextMenu copy cut drag dragEnd dragEnter dragExit dragLeave dragOver dragStart drop durationChange emptied encrypted ended error gotPointerCapture input invalid keyDown keyPress keyUp load loadedData loadedMetadata loadStart lostPointerCapture mouseDown mouseMove mouseOut mouseOver mouseUp paste pause play playing pointerCancel pointerDown pointerMove pointerOut pointerOver pointerUp progress rateChange reset resize seeked seeking stalled submit suspend timeUpdate touchCancel touchEnd touchStart volumeChange scroll toggle touchMove waiting wheel".split(" ");
function ff(a, b) {
  df.set(a, b);
  fa(b, [a]);
}
for (var gf = 0; gf < ef.length; gf++) {
  var hf = ef[gf],
    jf = hf.toLowerCase(),
    kf = hf[0].toUpperCase() + hf.slice(1);
  ff(jf, "on" + kf);
}
ff($e, "onAnimationEnd");
ff(af, "onAnimationIteration");
ff(bf, "onAnimationStart");
ff("dblclick", "onDoubleClick");
ff("focusin", "onFocus");
ff("focusout", "onBlur");
ff(cf, "onTransitionEnd");
ha("onMouseEnter", ["mouseout", "mouseover"]);
ha("onMouseLeave", ["mouseout", "mouseover"]);
ha("onPointerEnter", ["pointerout", "pointerover"]);
ha("onPointerLeave", ["pointerout", "pointerover"]);
fa("onChange", "change click focusin focusout input keydown keyup selectionchange".split(" "));
fa("onSelect", "focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" "));
fa("onBeforeInput", ["compositionend", "keypress", "textInput", "paste"]);
fa("onCompositionEnd", "compositionend focusout keydown keypress keyup mousedown".split(" "));
fa("onCompositionStart", "compositionstart focusout keydown keypress keyup mousedown".split(" "));
fa("onCompositionUpdate", "compositionupdate focusout keydown keypress keyup mousedown".split(" "));
var lf = "abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange resize seeked seeking stalled suspend timeupdate volumechange waiting".split(" "),
  mf = new Set("cancel close invalid load scroll toggle".split(" ").concat(lf));
function nf(a, b, c) {
  var d = a.type || "unknown-event";
  a.currentTarget = c;
  Ub(d, b, void 0, a);
  a.currentTarget = null;
}
function se(a, b) {
  b = 0 !== (b & 4);
  for (var c = 0; c < a.length; c++) {
    var d = a[c],
      e = d.event;
    d = d.listeners;
    a: {
      var f = void 0;
      if (b) for (var g = d.length - 1; 0 <= g; g--) {
        var h = d[g],
          k = h.instance,
          l = h.currentTarget;
        h = h.listener;
        if (k !== f && e.isPropagationStopped()) break a;
        nf(e, h, l);
        f = k;
      } else for (g = 0; g < d.length; g++) {
        h = d[g];
        k = h.instance;
        l = h.currentTarget;
        h = h.listener;
        if (k !== f && e.isPropagationStopped()) break a;
        nf(e, h, l);
        f = k;
      }
    }
  }
  if (Qb) throw a = Rb, Qb = !1, Rb = null, a;
}
function D(a, b) {
  var c = b[of];
  void 0 === c && (c = b[of] = new Set());
  var d = a + "__bubble";
  c.has(d) || (pf(b, a, 2, !1), c.add(d));
}
function qf(a, b, c) {
  var d = 0;
  b && (d |= 4);
  pf(c, a, d, b);
}
var rf = "_reactListening" + Math.random().toString(36).slice(2);
function sf(a) {
  if (!a[rf]) {
    a[rf] = !0;
    da.forEach(function (b) {
      "selectionchange" !== b && (mf.has(b) || qf(b, !1, a), qf(b, !0, a));
    });
    var b = 9 === a.nodeType ? a : a.ownerDocument;
    null === b || b[rf] || (b[rf] = !0, qf("selectionchange", !1, b));
  }
}
function pf(a, b, c, d) {
  switch (jd(b)) {
    case 1:
      var e = ed;
      break;
    case 4:
      e = gd;
      break;
    default:
      e = fd;
  }
  c = e.bind(null, b, c, a);
  e = void 0;
  !Lb || "touchstart" !== b && "touchmove" !== b && "wheel" !== b || (e = !0);
  d ? void 0 !== e ? a.addEventListener(b, c, {
    capture: !0,
    passive: e
  }) : a.addEventListener(b, c, !0) : void 0 !== e ? a.addEventListener(b, c, {
    passive: e
  }) : a.addEventListener(b, c, !1);
}
function hd(a, b, c, d, e) {
  var f = d;
  if (0 === (b & 1) && 0 === (b & 2) && null !== d) a: for (;;) {
    if (null === d) return;
    var g = d.tag;
    if (3 === g || 4 === g) {
      var h = d.stateNode.containerInfo;
      if (h === e || 8 === h.nodeType && h.parentNode === e) break;
      if (4 === g) for (g = d.return; null !== g;) {
        var k = g.tag;
        if (3 === k || 4 === k) if (k = g.stateNode.containerInfo, k === e || 8 === k.nodeType && k.parentNode === e) return;
        g = g.return;
      }
      for (; null !== h;) {
        g = Wc(h);
        if (null === g) return;
        k = g.tag;
        if (5 === k || 6 === k) {
          d = f = g;
          continue a;
        }
        h = h.parentNode;
      }
    }
    d = d.return;
  }
  Jb(function () {
    var d = f,
      e = xb(c),
      g = [];
    a: {
      var h = df.get(a);
      if (void 0 !== h) {
        var k = td,
          n = a;
        switch (a) {
          case "keypress":
            if (0 === od(c)) break a;
          case "keydown":
          case "keyup":
            k = Rd;
            break;
          case "focusin":
            n = "focus";
            k = Fd;
            break;
          case "focusout":
            n = "blur";
            k = Fd;
            break;
          case "beforeblur":
          case "afterblur":
            k = Fd;
            break;
          case "click":
            if (2 === c.button) break a;
          case "auxclick":
          case "dblclick":
          case "mousedown":
          case "mousemove":
          case "mouseup":
          case "mouseout":
          case "mouseover":
          case "contextmenu":
            k = Bd;
            break;
          case "drag":
          case "dragend":
          case "dragenter":
          case "dragexit":
          case "dragleave":
          case "dragover":
          case "dragstart":
          case "drop":
            k = Dd;
            break;
          case "touchcancel":
          case "touchend":
          case "touchmove":
          case "touchstart":
            k = Vd;
            break;
          case $e:
          case af:
          case bf:
            k = Hd;
            break;
          case cf:
            k = Xd;
            break;
          case "scroll":
            k = vd;
            break;
          case "wheel":
            k = Zd;
            break;
          case "copy":
          case "cut":
          case "paste":
            k = Jd;
            break;
          case "gotpointercapture":
          case "lostpointercapture":
          case "pointercancel":
          case "pointerdown":
          case "pointermove":
          case "pointerout":
          case "pointerover":
          case "pointerup":
            k = Td;
        }
        var t = 0 !== (b & 4),
          J = !t && "scroll" === a,
          x = t ? null !== h ? h + "Capture" : null : h;
        t = [];
        for (var w = d, u; null !== w;) {
          u = w;
          var F = u.stateNode;
          5 === u.tag && null !== F && (u = F, null !== x && (F = Kb(w, x), null != F && t.push(tf(w, F, u))));
          if (J) break;
          w = w.return;
        }
        0 < t.length && (h = new k(h, n, null, c, e), g.push({
          event: h,
          listeners: t
        }));
      }
    }
    if (0 === (b & 7)) {
      a: {
        h = "mouseover" === a || "pointerover" === a;
        k = "mouseout" === a || "pointerout" === a;
        if (h && c !== wb && (n = c.relatedTarget || c.fromElement) && (Wc(n) || n[uf])) break a;
        if (k || h) {
          h = e.window === e ? e : (h = e.ownerDocument) ? h.defaultView || h.parentWindow : window;
          if (k) {
            if (n = c.relatedTarget || c.toElement, k = d, n = n ? Wc(n) : null, null !== n && (J = Vb(n), n !== J || 5 !== n.tag && 6 !== n.tag)) n = null;
          } else k = null, n = d;
          if (k !== n) {
            t = Bd;
            F = "onMouseLeave";
            x = "onMouseEnter";
            w = "mouse";
            if ("pointerout" === a || "pointerover" === a) t = Td, F = "onPointerLeave", x = "onPointerEnter", w = "pointer";
            J = null == k ? h : ue(k);
            u = null == n ? h : ue(n);
            h = new t(F, w + "leave", k, c, e);
            h.target = J;
            h.relatedTarget = u;
            F = null;
            Wc(e) === d && (t = new t(x, w + "enter", n, c, e), t.target = u, t.relatedTarget = J, F = t);
            J = F;
            if (k && n) b: {
              t = k;
              x = n;
              w = 0;
              for (u = t; u; u = vf(u)) w++;
              u = 0;
              for (F = x; F; F = vf(F)) u++;
              for (; 0 < w - u;) t = vf(t), w--;
              for (; 0 < u - w;) x = vf(x), u--;
              for (; w--;) {
                if (t === x || null !== x && t === x.alternate) break b;
                t = vf(t);
                x = vf(x);
              }
              t = null;
            } else t = null;
            null !== k && wf(g, h, k, t, !1);
            null !== n && null !== J && wf(g, J, n, t, !0);
          }
        }
      }
      a: {
        h = d ? ue(d) : window;
        k = h.nodeName && h.nodeName.toLowerCase();
        if ("select" === k || "input" === k && "file" === h.type) var na = ve;else if (me(h)) {
          if (we) na = Fe;else {
            na = De;
            var xa = Ce;
          }
        } else (k = h.nodeName) && "input" === k.toLowerCase() && ("checkbox" === h.type || "radio" === h.type) && (na = Ee);
        if (na && (na = na(a, d))) {
          ne(g, na, c, e);
          break a;
        }
        xa && xa(a, h, d);
        "focusout" === a && (xa = h._wrapperState) && xa.controlled && "number" === h.type && cb(h, "number", h.value);
      }
      xa = d ? ue(d) : window;
      switch (a) {
        case "focusin":
          if (me(xa) || "true" === xa.contentEditable) Qe = xa, Re = d, Se = null;
          break;
        case "focusout":
          Se = Re = Qe = null;
          break;
        case "mousedown":
          Te = !0;
          break;
        case "contextmenu":
        case "mouseup":
        case "dragend":
          Te = !1;
          Ue(g, c, e);
          break;
        case "selectionchange":
          if (Pe) break;
        case "keydown":
        case "keyup":
          Ue(g, c, e);
      }
      var $a;
      if (ae) b: {
        switch (a) {
          case "compositionstart":
            var ba = "onCompositionStart";
            break b;
          case "compositionend":
            ba = "onCompositionEnd";
            break b;
          case "compositionupdate":
            ba = "onCompositionUpdate";
            break b;
        }
        ba = void 0;
      } else ie ? ge(a, c) && (ba = "onCompositionEnd") : "keydown" === a && 229 === c.keyCode && (ba = "onCompositionStart");
      ba && (de && "ko" !== c.locale && (ie || "onCompositionStart" !== ba ? "onCompositionEnd" === ba && ie && ($a = nd()) : (kd = e, ld = "value" in kd ? kd.value : kd.textContent, ie = !0)), xa = oe(d, ba), 0 < xa.length && (ba = new Ld(ba, a, null, c, e), g.push({
        event: ba,
        listeners: xa
      }), $a ? ba.data = $a : ($a = he(c), null !== $a && (ba.data = $a))));
      if ($a = ce ? je(a, c) : ke(a, c)) d = oe(d, "onBeforeInput"), 0 < d.length && (e = new Ld("onBeforeInput", "beforeinput", null, c, e), g.push({
        event: e,
        listeners: d
      }), e.data = $a);
    }
    se(g, b);
  });
}
function tf(a, b, c) {
  return {
    instance: a,
    listener: b,
    currentTarget: c
  };
}
function oe(a, b) {
  for (var c = b + "Capture", d = []; null !== a;) {
    var e = a,
      f = e.stateNode;
    5 === e.tag && null !== f && (e = f, f = Kb(a, c), null != f && d.unshift(tf(a, f, e)), f = Kb(a, b), null != f && d.push(tf(a, f, e)));
    a = a.return;
  }
  return d;
}
function vf(a) {
  if (null === a) return null;
  do a = a.return; while (a && 5 !== a.tag);
  return a ? a : null;
}
function wf(a, b, c, d, e) {
  for (var f = b._reactName, g = []; null !== c && c !== d;) {
    var h = c,
      k = h.alternate,
      l = h.stateNode;
    if (null !== k && k === d) break;
    5 === h.tag && null !== l && (h = l, e ? (k = Kb(c, f), null != k && g.unshift(tf(c, k, h))) : e || (k = Kb(c, f), null != k && g.push(tf(c, k, h))));
    c = c.return;
  }
  0 !== g.length && a.push({
    event: b,
    listeners: g
  });
}
var xf = /\r\n?/g,
  yf = /\u0000|\uFFFD/g;
function zf(a) {
  return ("string" === typeof a ? a : "" + a).replace(xf, "\n").replace(yf, "");
}
function Af(a, b, c) {
  b = zf(b);
  if (zf(a) !== b && c) throw Error(p(425));
}
function Bf() {}
var Cf = null,
  Df = null;
function Ef(a, b) {
  return "textarea" === a || "noscript" === a || "string" === typeof b.children || "number" === typeof b.children || "object" === typeof b.dangerouslySetInnerHTML && null !== b.dangerouslySetInnerHTML && null != b.dangerouslySetInnerHTML.__html;
}
var Ff = "function" === typeof setTimeout ? setTimeout : void 0,
  Gf = "function" === typeof clearTimeout ? clearTimeout : void 0,
  Hf = "function" === typeof Promise ? Promise : void 0,
  Jf = "function" === typeof queueMicrotask ? queueMicrotask : "undefined" !== typeof Hf ? function (a) {
    return Hf.resolve(null).then(a).catch(If);
  } : Ff;
function If(a) {
  setTimeout(function () {
    throw a;
  });
}
function Kf(a, b) {
  var c = b,
    d = 0;
  do {
    var e = c.nextSibling;
    a.removeChild(c);
    if (e && 8 === e.nodeType) if (c = e.data, "/$" === c) {
      if (0 === d) {
        a.removeChild(e);
        bd(b);
        return;
      }
      d--;
    } else "$" !== c && "$?" !== c && "$!" !== c || d++;
    c = e;
  } while (c);
  bd(b);
}
function Lf(a) {
  for (; null != a; a = a.nextSibling) {
    var b = a.nodeType;
    if (1 === b || 3 === b) break;
    if (8 === b) {
      b = a.data;
      if ("$" === b || "$!" === b || "$?" === b) break;
      if ("/$" === b) return null;
    }
  }
  return a;
}
function Mf(a) {
  a = a.previousSibling;
  for (var b = 0; a;) {
    if (8 === a.nodeType) {
      var c = a.data;
      if ("$" === c || "$!" === c || "$?" === c) {
        if (0 === b) return a;
        b--;
      } else "/$" === c && b++;
    }
    a = a.previousSibling;
  }
  return null;
}
var Nf = Math.random().toString(36).slice(2),
  Of = "__reactFiber$" + Nf,
  Pf = "__reactProps$" + Nf,
  uf = "__reactContainer$" + Nf,
  of = "__reactEvents$" + Nf,
  Qf = "__reactListeners$" + Nf,
  Rf = "__reactHandles$" + Nf;
function Wc(a) {
  var b = a[Of];
  if (b) return b;
  for (var c = a.parentNode; c;) {
    if (b = c[uf] || c[Of]) {
      c = b.alternate;
      if (null !== b.child || null !== c && null !== c.child) for (a = Mf(a); null !== a;) {
        if (c = a[Of]) return c;
        a = Mf(a);
      }
      return b;
    }
    a = c;
    c = a.parentNode;
  }
  return null;
}
function Cb(a) {
  a = a[Of] || a[uf];
  return !a || 5 !== a.tag && 6 !== a.tag && 13 !== a.tag && 3 !== a.tag ? null : a;
}
function ue(a) {
  if (5 === a.tag || 6 === a.tag) return a.stateNode;
  throw Error(p(33));
}
function Db(a) {
  return a[Pf] || null;
}
var Sf = [],
  Tf = -1;
function Uf(a) {
  return {
    current: a
  };
}
function E(a) {
  0 > Tf || (a.current = Sf[Tf], Sf[Tf] = null, Tf--);
}
function G(a, b) {
  Tf++;
  Sf[Tf] = a.current;
  a.current = b;
}
var Vf = {},
  H = Uf(Vf),
  Wf = Uf(!1),
  Xf = Vf;
function Yf(a, b) {
  var c = a.type.contextTypes;
  if (!c) return Vf;
  var d = a.stateNode;
  if (d && d.__reactInternalMemoizedUnmaskedChildContext === b) return d.__reactInternalMemoizedMaskedChildContext;
  var e = {},
    f;
  for (f in c) e[f] = b[f];
  d && (a = a.stateNode, a.__reactInternalMemoizedUnmaskedChildContext = b, a.__reactInternalMemoizedMaskedChildContext = e);
  return e;
}
function Zf(a) {
  a = a.childContextTypes;
  return null !== a && void 0 !== a;
}
function $f() {
  E(Wf);
  E(H);
}
function ag(a, b, c) {
  if (H.current !== Vf) throw Error(p(168));
  G(H, b);
  G(Wf, c);
}
function bg(a, b, c) {
  var d = a.stateNode;
  b = b.childContextTypes;
  if ("function" !== typeof d.getChildContext) return c;
  d = d.getChildContext();
  for (var e in d) if (!(e in b)) throw Error(p(108, Ra(a) || "Unknown", e));
  return A({}, c, d);
}
function cg(a) {
  a = (a = a.stateNode) && a.__reactInternalMemoizedMergedChildContext || Vf;
  Xf = H.current;
  G(H, a);
  G(Wf, Wf.current);
  return !0;
}
function dg(a, b, c) {
  var d = a.stateNode;
  if (!d) throw Error(p(169));
  c ? (a = bg(a, b, Xf), d.__reactInternalMemoizedMergedChildContext = a, E(Wf), E(H), G(H, a)) : E(Wf);
  G(Wf, c);
}
var eg = null,
  fg = !1,
  gg = !1;
function hg(a) {
  null === eg ? eg = [a] : eg.push(a);
}
function ig(a) {
  fg = !0;
  hg(a);
}
function jg() {
  if (!gg && null !== eg) {
    gg = !0;
    var a = 0,
      b = C;
    try {
      var c = eg;
      for (C = 1; a < c.length; a++) {
        var d = c[a];
        do d = d(!0); while (null !== d);
      }
      eg = null;
      fg = !1;
    } catch (e) {
      throw null !== eg && (eg = eg.slice(a + 1)), ac(fc, jg), e;
    } finally {
      C = b, gg = !1;
    }
  }
  return null;
}
var kg = [],
  lg = 0,
  mg = null,
  ng = 0,
  og = [],
  pg = 0,
  qg = null,
  rg = 1,
  sg = "";
function tg(a, b) {
  kg[lg++] = ng;
  kg[lg++] = mg;
  mg = a;
  ng = b;
}
function ug(a, b, c) {
  og[pg++] = rg;
  og[pg++] = sg;
  og[pg++] = qg;
  qg = a;
  var d = rg;
  a = sg;
  var e = 32 - oc(d) - 1;
  d &= ~(1 << e);
  c += 1;
  var f = 32 - oc(b) + e;
  if (30 < f) {
    var g = e - e % 5;
    f = (d & (1 << g) - 1).toString(32);
    d >>= g;
    e -= g;
    rg = 1 << 32 - oc(b) + e | c << e | d;
    sg = f + a;
  } else rg = 1 << f | c << e | d, sg = a;
}
function vg(a) {
  null !== a.return && (tg(a, 1), ug(a, 1, 0));
}
function wg(a) {
  for (; a === mg;) mg = kg[--lg], kg[lg] = null, ng = kg[--lg], kg[lg] = null;
  for (; a === qg;) qg = og[--pg], og[pg] = null, sg = og[--pg], og[pg] = null, rg = og[--pg], og[pg] = null;
}
var xg = null,
  yg = null,
  I = !1,
  zg = null;
function Ag(a, b) {
  var c = Bg(5, null, null, 0);
  c.elementType = "DELETED";
  c.stateNode = b;
  c.return = a;
  b = a.deletions;
  null === b ? (a.deletions = [c], a.flags |= 16) : b.push(c);
}
function Cg(a, b) {
  switch (a.tag) {
    case 5:
      var c = a.type;
      b = 1 !== b.nodeType || c.toLowerCase() !== b.nodeName.toLowerCase() ? null : b;
      return null !== b ? (a.stateNode = b, xg = a, yg = Lf(b.firstChild), !0) : !1;
    case 6:
      return b = "" === a.pendingProps || 3 !== b.nodeType ? null : b, null !== b ? (a.stateNode = b, xg = a, yg = null, !0) : !1;
    case 13:
      return b = 8 !== b.nodeType ? null : b, null !== b ? (c = null !== qg ? {
        id: rg,
        overflow: sg
      } : null, a.memoizedState = {
        dehydrated: b,
        treeContext: c,
        retryLane: 1073741824
      }, c = Bg(18, null, null, 0), c.stateNode = b, c.return = a, a.child = c, xg = a, yg = null, !0) : !1;
    default:
      return !1;
  }
}
function Dg(a) {
  return 0 !== (a.mode & 1) && 0 === (a.flags & 128);
}
function Eg(a) {
  if (I) {
    var b = yg;
    if (b) {
      var c = b;
      if (!Cg(a, b)) {
        if (Dg(a)) throw Error(p(418));
        b = Lf(c.nextSibling);
        var d = xg;
        b && Cg(a, b) ? Ag(d, c) : (a.flags = a.flags & -4097 | 2, I = !1, xg = a);
      }
    } else {
      if (Dg(a)) throw Error(p(418));
      a.flags = a.flags & -4097 | 2;
      I = !1;
      xg = a;
    }
  }
}
function Fg(a) {
  for (a = a.return; null !== a && 5 !== a.tag && 3 !== a.tag && 13 !== a.tag;) a = a.return;
  xg = a;
}
function Gg(a) {
  if (a !== xg) return !1;
  if (!I) return Fg(a), I = !0, !1;
  var b;
  (b = 3 !== a.tag) && !(b = 5 !== a.tag) && (b = a.type, b = "head" !== b && "body" !== b && !Ef(a.type, a.memoizedProps));
  if (b && (b = yg)) {
    if (Dg(a)) throw Hg(), Error(p(418));
    for (; b;) Ag(a, b), b = Lf(b.nextSibling);
  }
  Fg(a);
  if (13 === a.tag) {
    a = a.memoizedState;
    a = null !== a ? a.dehydrated : null;
    if (!a) throw Error(p(317));
    a: {
      a = a.nextSibling;
      for (b = 0; a;) {
        if (8 === a.nodeType) {
          var c = a.data;
          if ("/$" === c) {
            if (0 === b) {
              yg = Lf(a.nextSibling);
              break a;
            }
            b--;
          } else "$" !== c && "$!" !== c && "$?" !== c || b++;
        }
        a = a.nextSibling;
      }
      yg = null;
    }
  } else yg = xg ? Lf(a.stateNode.nextSibling) : null;
  return !0;
}
function Hg() {
  for (var a = yg; a;) a = Lf(a.nextSibling);
}
function Ig() {
  yg = xg = null;
  I = !1;
}
function Jg(a) {
  null === zg ? zg = [a] : zg.push(a);
}
var Kg = ua.ReactCurrentBatchConfig;
function Lg(a, b) {
  if (a && a.defaultProps) {
    b = A({}, b);
    a = a.defaultProps;
    for (var c in a) void 0 === b[c] && (b[c] = a[c]);
    return b;
  }
  return b;
}
var Mg = Uf(null),
  Ng = null,
  Og = null,
  Pg = null;
function Qg() {
  Pg = Og = Ng = null;
}
function Rg(a) {
  var b = Mg.current;
  E(Mg);
  a._currentValue = b;
}
function Sg(a, b, c) {
  for (; null !== a;) {
    var d = a.alternate;
    (a.childLanes & b) !== b ? (a.childLanes |= b, null !== d && (d.childLanes |= b)) : null !== d && (d.childLanes & b) !== b && (d.childLanes |= b);
    if (a === c) break;
    a = a.return;
  }
}
function Tg(a, b) {
  Ng = a;
  Pg = Og = null;
  a = a.dependencies;
  null !== a && null !== a.firstContext && (0 !== (a.lanes & b) && (Ug = !0), a.firstContext = null);
}
function Vg(a) {
  var b = a._currentValue;
  if (Pg !== a) if (a = {
    context: a,
    memoizedValue: b,
    next: null
  }, null === Og) {
    if (null === Ng) throw Error(p(308));
    Og = a;
    Ng.dependencies = {
      lanes: 0,
      firstContext: a
    };
  } else Og = Og.next = a;
  return b;
}
var Wg = null;
function Xg(a) {
  null === Wg ? Wg = [a] : Wg.push(a);
}
function Yg(a, b, c, d) {
  var e = b.interleaved;
  null === e ? (c.next = c, Xg(b)) : (c.next = e.next, e.next = c);
  b.interleaved = c;
  return Zg(a, d);
}
function Zg(a, b) {
  a.lanes |= b;
  var c = a.alternate;
  null !== c && (c.lanes |= b);
  c = a;
  for (a = a.return; null !== a;) a.childLanes |= b, c = a.alternate, null !== c && (c.childLanes |= b), c = a, a = a.return;
  return 3 === c.tag ? c.stateNode : null;
}
var $g = !1;
function ah(a) {
  a.updateQueue = {
    baseState: a.memoizedState,
    firstBaseUpdate: null,
    lastBaseUpdate: null,
    shared: {
      pending: null,
      interleaved: null,
      lanes: 0
    },
    effects: null
  };
}
function bh(a, b) {
  a = a.updateQueue;
  b.updateQueue === a && (b.updateQueue = {
    baseState: a.baseState,
    firstBaseUpdate: a.firstBaseUpdate,
    lastBaseUpdate: a.lastBaseUpdate,
    shared: a.shared,
    effects: a.effects
  });
}
function ch(a, b) {
  return {
    eventTime: a,
    lane: b,
    tag: 0,
    payload: null,
    callback: null,
    next: null
  };
}
function dh(a, b, c) {
  var d = a.updateQueue;
  if (null === d) return null;
  d = d.shared;
  if (0 !== (K & 2)) {
    var e = d.pending;
    null === e ? b.next = b : (b.next = e.next, e.next = b);
    d.pending = b;
    return Zg(a, c);
  }
  e = d.interleaved;
  null === e ? (b.next = b, Xg(d)) : (b.next = e.next, e.next = b);
  d.interleaved = b;
  return Zg(a, c);
}
function eh(a, b, c) {
  b = b.updateQueue;
  if (null !== b && (b = b.shared, 0 !== (c & 4194240))) {
    var d = b.lanes;
    d &= a.pendingLanes;
    c |= d;
    b.lanes = c;
    Cc(a, c);
  }
}
function fh(a, b) {
  var c = a.updateQueue,
    d = a.alternate;
  if (null !== d && (d = d.updateQueue, c === d)) {
    var e = null,
      f = null;
    c = c.firstBaseUpdate;
    if (null !== c) {
      do {
        var g = {
          eventTime: c.eventTime,
          lane: c.lane,
          tag: c.tag,
          payload: c.payload,
          callback: c.callback,
          next: null
        };
        null === f ? e = f = g : f = f.next = g;
        c = c.next;
      } while (null !== c);
      null === f ? e = f = b : f = f.next = b;
    } else e = f = b;
    c = {
      baseState: d.baseState,
      firstBaseUpdate: e,
      lastBaseUpdate: f,
      shared: d.shared,
      effects: d.effects
    };
    a.updateQueue = c;
    return;
  }
  a = c.lastBaseUpdate;
  null === a ? c.firstBaseUpdate = b : a.next = b;
  c.lastBaseUpdate = b;
}
function gh(a, b, c, d) {
  var e = a.updateQueue;
  $g = !1;
  var f = e.firstBaseUpdate,
    g = e.lastBaseUpdate,
    h = e.shared.pending;
  if (null !== h) {
    e.shared.pending = null;
    var k = h,
      l = k.next;
    k.next = null;
    null === g ? f = l : g.next = l;
    g = k;
    var m = a.alternate;
    null !== m && (m = m.updateQueue, h = m.lastBaseUpdate, h !== g && (null === h ? m.firstBaseUpdate = l : h.next = l, m.lastBaseUpdate = k));
  }
  if (null !== f) {
    var q = e.baseState;
    g = 0;
    m = l = k = null;
    h = f;
    do {
      var r = h.lane,
        y = h.eventTime;
      if ((d & r) === r) {
        null !== m && (m = m.next = {
          eventTime: y,
          lane: 0,
          tag: h.tag,
          payload: h.payload,
          callback: h.callback,
          next: null
        });
        a: {
          var n = a,
            t = h;
          r = b;
          y = c;
          switch (t.tag) {
            case 1:
              n = t.payload;
              if ("function" === typeof n) {
                q = n.call(y, q, r);
                break a;
              }
              q = n;
              break a;
            case 3:
              n.flags = n.flags & -65537 | 128;
            case 0:
              n = t.payload;
              r = "function" === typeof n ? n.call(y, q, r) : n;
              if (null === r || void 0 === r) break a;
              q = A({}, q, r);
              break a;
            case 2:
              $g = !0;
          }
        }
        null !== h.callback && 0 !== h.lane && (a.flags |= 64, r = e.effects, null === r ? e.effects = [h] : r.push(h));
      } else y = {
        eventTime: y,
        lane: r,
        tag: h.tag,
        payload: h.payload,
        callback: h.callback,
        next: null
      }, null === m ? (l = m = y, k = q) : m = m.next = y, g |= r;
      h = h.next;
      if (null === h) if (h = e.shared.pending, null === h) break;else r = h, h = r.next, r.next = null, e.lastBaseUpdate = r, e.shared.pending = null;
    } while (1);
    null === m && (k = q);
    e.baseState = k;
    e.firstBaseUpdate = l;
    e.lastBaseUpdate = m;
    b = e.shared.interleaved;
    if (null !== b) {
      e = b;
      do g |= e.lane, e = e.next; while (e !== b);
    } else null === f && (e.shared.lanes = 0);
    hh |= g;
    a.lanes = g;
    a.memoizedState = q;
  }
}
function ih(a, b, c) {
  a = b.effects;
  b.effects = null;
  if (null !== a) for (b = 0; b < a.length; b++) {
    var d = a[b],
      e = d.callback;
    if (null !== e) {
      d.callback = null;
      d = c;
      if ("function" !== typeof e) throw Error(p(191, e));
      e.call(d);
    }
  }
}
var jh = new aa.Component().refs;
function kh(a, b, c, d) {
  b = a.memoizedState;
  c = c(d, b);
  c = null === c || void 0 === c ? b : A({}, b, c);
  a.memoizedState = c;
  0 === a.lanes && (a.updateQueue.baseState = c);
}
var nh = {
  isMounted: function isMounted(a) {
    return (a = a._reactInternals) ? Vb(a) === a : !1;
  },
  enqueueSetState: function enqueueSetState(a, b, c) {
    a = a._reactInternals;
    var d = L(),
      e = lh(a),
      f = ch(d, e);
    f.payload = b;
    void 0 !== c && null !== c && (f.callback = c);
    b = dh(a, f, e);
    null !== b && (mh(b, a, e, d), eh(b, a, e));
  },
  enqueueReplaceState: function enqueueReplaceState(a, b, c) {
    a = a._reactInternals;
    var d = L(),
      e = lh(a),
      f = ch(d, e);
    f.tag = 1;
    f.payload = b;
    void 0 !== c && null !== c && (f.callback = c);
    b = dh(a, f, e);
    null !== b && (mh(b, a, e, d), eh(b, a, e));
  },
  enqueueForceUpdate: function enqueueForceUpdate(a, b) {
    a = a._reactInternals;
    var c = L(),
      d = lh(a),
      e = ch(c, d);
    e.tag = 2;
    void 0 !== b && null !== b && (e.callback = b);
    b = dh(a, e, d);
    null !== b && (mh(b, a, d, c), eh(b, a, d));
  }
};
function oh(a, b, c, d, e, f, g) {
  a = a.stateNode;
  return "function" === typeof a.shouldComponentUpdate ? a.shouldComponentUpdate(d, f, g) : b.prototype && b.prototype.isPureReactComponent ? !Ie(c, d) || !Ie(e, f) : !0;
}
function ph(a, b, c) {
  var d = !1,
    e = Vf;
  var f = b.contextType;
  "object" === typeof f && null !== f ? f = Vg(f) : (e = Zf(b) ? Xf : H.current, d = b.contextTypes, f = (d = null !== d && void 0 !== d) ? Yf(a, e) : Vf);
  b = new b(c, f);
  a.memoizedState = null !== b.state && void 0 !== b.state ? b.state : null;
  b.updater = nh;
  a.stateNode = b;
  b._reactInternals = a;
  d && (a = a.stateNode, a.__reactInternalMemoizedUnmaskedChildContext = e, a.__reactInternalMemoizedMaskedChildContext = f);
  return b;
}
function qh(a, b, c, d) {
  a = b.state;
  "function" === typeof b.componentWillReceiveProps && b.componentWillReceiveProps(c, d);
  "function" === typeof b.UNSAFE_componentWillReceiveProps && b.UNSAFE_componentWillReceiveProps(c, d);
  b.state !== a && nh.enqueueReplaceState(b, b.state, null);
}
function rh(a, b, c, d) {
  var e = a.stateNode;
  e.props = c;
  e.state = a.memoizedState;
  e.refs = jh;
  ah(a);
  var f = b.contextType;
  "object" === typeof f && null !== f ? e.context = Vg(f) : (f = Zf(b) ? Xf : H.current, e.context = Yf(a, f));
  e.state = a.memoizedState;
  f = b.getDerivedStateFromProps;
  "function" === typeof f && (kh(a, b, f, c), e.state = a.memoizedState);
  "function" === typeof b.getDerivedStateFromProps || "function" === typeof e.getSnapshotBeforeUpdate || "function" !== typeof e.UNSAFE_componentWillMount && "function" !== typeof e.componentWillMount || (b = e.state, "function" === typeof e.componentWillMount && e.componentWillMount(), "function" === typeof e.UNSAFE_componentWillMount && e.UNSAFE_componentWillMount(), b !== e.state && nh.enqueueReplaceState(e, e.state, null), gh(a, c, e, d), e.state = a.memoizedState);
  "function" === typeof e.componentDidMount && (a.flags |= 4194308);
}
function sh(a, b, c) {
  a = c.ref;
  if (null !== a && "function" !== typeof a && "object" !== typeof a) {
    if (c._owner) {
      c = c._owner;
      if (c) {
        if (1 !== c.tag) throw Error(p(309));
        var d = c.stateNode;
      }
      if (!d) throw Error(p(147, a));
      var e = d,
        f = "" + a;
      if (null !== b && null !== b.ref && "function" === typeof b.ref && b.ref._stringRef === f) return b.ref;
      b = function b(a) {
        var b = e.refs;
        b === jh && (b = e.refs = {});
        null === a ? delete b[f] : b[f] = a;
      };
      b._stringRef = f;
      return b;
    }
    if ("string" !== typeof a) throw Error(p(284));
    if (!c._owner) throw Error(p(290, a));
  }
  return a;
}
function th(a, b) {
  a = Object.prototype.toString.call(b);
  throw Error(p(31, "[object Object]" === a ? "object with keys {" + Object.keys(b).join(", ") + "}" : a));
}
function uh(a) {
  var b = a._init;
  return b(a._payload);
}
function vh(a) {
  function b(b, c) {
    if (a) {
      var d = b.deletions;
      null === d ? (b.deletions = [c], b.flags |= 16) : d.push(c);
    }
  }
  function c(c, d) {
    if (!a) return null;
    for (; null !== d;) b(c, d), d = d.sibling;
    return null;
  }
  function d(a, b) {
    for (a = new Map(); null !== b;) null !== b.key ? a.set(b.key, b) : a.set(b.index, b), b = b.sibling;
    return a;
  }
  function e(a, b) {
    a = wh(a, b);
    a.index = 0;
    a.sibling = null;
    return a;
  }
  function f(b, c, d) {
    b.index = d;
    if (!a) return b.flags |= 1048576, c;
    d = b.alternate;
    if (null !== d) return d = d.index, d < c ? (b.flags |= 2, c) : d;
    b.flags |= 2;
    return c;
  }
  function g(b) {
    a && null === b.alternate && (b.flags |= 2);
    return b;
  }
  function h(a, b, c, d) {
    if (null === b || 6 !== b.tag) return b = xh(c, a.mode, d), b.return = a, b;
    b = e(b, c);
    b.return = a;
    return b;
  }
  function k(a, b, c, d) {
    var f = c.type;
    if (f === ya) return m(a, b, c.props.children, d, c.key);
    if (null !== b && (b.elementType === f || "object" === typeof f && null !== f && f.$$typeof === Ha && uh(f) === b.type)) return d = e(b, c.props), d.ref = sh(a, b, c), d.return = a, d;
    d = yh(c.type, c.key, c.props, null, a.mode, d);
    d.ref = sh(a, b, c);
    d.return = a;
    return d;
  }
  function l(a, b, c, d) {
    if (null === b || 4 !== b.tag || b.stateNode.containerInfo !== c.containerInfo || b.stateNode.implementation !== c.implementation) return b = zh(c, a.mode, d), b.return = a, b;
    b = e(b, c.children || []);
    b.return = a;
    return b;
  }
  function m(a, b, c, d, f) {
    if (null === b || 7 !== b.tag) return b = Ah(c, a.mode, d, f), b.return = a, b;
    b = e(b, c);
    b.return = a;
    return b;
  }
  function q(a, b, c) {
    if ("string" === typeof b && "" !== b || "number" === typeof b) return b = xh("" + b, a.mode, c), b.return = a, b;
    if ("object" === typeof b && null !== b) {
      switch (b.$$typeof) {
        case va:
          return c = yh(b.type, b.key, b.props, null, a.mode, c), c.ref = sh(a, null, b), c.return = a, c;
        case wa:
          return b = zh(b, a.mode, c), b.return = a, b;
        case Ha:
          var d = b._init;
          return q(a, d(b._payload), c);
      }
      if (eb(b) || Ka(b)) return b = Ah(b, a.mode, c, null), b.return = a, b;
      th(a, b);
    }
    return null;
  }
  function r(a, b, c, d) {
    var e = null !== b ? b.key : null;
    if ("string" === typeof c && "" !== c || "number" === typeof c) return null !== e ? null : h(a, b, "" + c, d);
    if ("object" === typeof c && null !== c) {
      switch (c.$$typeof) {
        case va:
          return c.key === e ? k(a, b, c, d) : null;
        case wa:
          return c.key === e ? l(a, b, c, d) : null;
        case Ha:
          return e = c._init, r(a, b, e(c._payload), d);
      }
      if (eb(c) || Ka(c)) return null !== e ? null : m(a, b, c, d, null);
      th(a, c);
    }
    return null;
  }
  function y(a, b, c, d, e) {
    if ("string" === typeof d && "" !== d || "number" === typeof d) return a = a.get(c) || null, h(b, a, "" + d, e);
    if ("object" === typeof d && null !== d) {
      switch (d.$$typeof) {
        case va:
          return a = a.get(null === d.key ? c : d.key) || null, k(b, a, d, e);
        case wa:
          return a = a.get(null === d.key ? c : d.key) || null, l(b, a, d, e);
        case Ha:
          var f = d._init;
          return y(a, b, c, f(d._payload), e);
      }
      if (eb(d) || Ka(d)) return a = a.get(c) || null, m(b, a, d, e, null);
      th(b, d);
    }
    return null;
  }
  function n(e, g, h, k) {
    for (var l = null, m = null, u = g, w = g = 0, x = null; null !== u && w < h.length; w++) {
      u.index > w ? (x = u, u = null) : x = u.sibling;
      var n = r(e, u, h[w], k);
      if (null === n) {
        null === u && (u = x);
        break;
      }
      a && u && null === n.alternate && b(e, u);
      g = f(n, g, w);
      null === m ? l = n : m.sibling = n;
      m = n;
      u = x;
    }
    if (w === h.length) return c(e, u), I && tg(e, w), l;
    if (null === u) {
      for (; w < h.length; w++) u = q(e, h[w], k), null !== u && (g = f(u, g, w), null === m ? l = u : m.sibling = u, m = u);
      I && tg(e, w);
      return l;
    }
    for (u = d(e, u); w < h.length; w++) x = y(u, e, w, h[w], k), null !== x && (a && null !== x.alternate && u.delete(null === x.key ? w : x.key), g = f(x, g, w), null === m ? l = x : m.sibling = x, m = x);
    a && u.forEach(function (a) {
      return b(e, a);
    });
    I && tg(e, w);
    return l;
  }
  function t(e, g, h, k) {
    var l = Ka(h);
    if ("function" !== typeof l) throw Error(p(150));
    h = l.call(h);
    if (null == h) throw Error(p(151));
    for (var u = l = null, m = g, w = g = 0, x = null, n = h.next(); null !== m && !n.done; w++, n = h.next()) {
      m.index > w ? (x = m, m = null) : x = m.sibling;
      var t = r(e, m, n.value, k);
      if (null === t) {
        null === m && (m = x);
        break;
      }
      a && m && null === t.alternate && b(e, m);
      g = f(t, g, w);
      null === u ? l = t : u.sibling = t;
      u = t;
      m = x;
    }
    if (n.done) return c(e, m), I && tg(e, w), l;
    if (null === m) {
      for (; !n.done; w++, n = h.next()) n = q(e, n.value, k), null !== n && (g = f(n, g, w), null === u ? l = n : u.sibling = n, u = n);
      I && tg(e, w);
      return l;
    }
    for (m = d(e, m); !n.done; w++, n = h.next()) n = y(m, e, w, n.value, k), null !== n && (a && null !== n.alternate && m.delete(null === n.key ? w : n.key), g = f(n, g, w), null === u ? l = n : u.sibling = n, u = n);
    a && m.forEach(function (a) {
      return b(e, a);
    });
    I && tg(e, w);
    return l;
  }
  function J(a, d, f, h) {
    "object" === typeof f && null !== f && f.type === ya && null === f.key && (f = f.props.children);
    if ("object" === typeof f && null !== f) {
      switch (f.$$typeof) {
        case va:
          a: {
            for (var k = f.key, l = d; null !== l;) {
              if (l.key === k) {
                k = f.type;
                if (k === ya) {
                  if (7 === l.tag) {
                    c(a, l.sibling);
                    d = e(l, f.props.children);
                    d.return = a;
                    a = d;
                    break a;
                  }
                } else if (l.elementType === k || "object" === typeof k && null !== k && k.$$typeof === Ha && uh(k) === l.type) {
                  c(a, l.sibling);
                  d = e(l, f.props);
                  d.ref = sh(a, l, f);
                  d.return = a;
                  a = d;
                  break a;
                }
                c(a, l);
                break;
              } else b(a, l);
              l = l.sibling;
            }
            f.type === ya ? (d = Ah(f.props.children, a.mode, h, f.key), d.return = a, a = d) : (h = yh(f.type, f.key, f.props, null, a.mode, h), h.ref = sh(a, d, f), h.return = a, a = h);
          }
          return g(a);
        case wa:
          a: {
            for (l = f.key; null !== d;) {
              if (d.key === l) {
                if (4 === d.tag && d.stateNode.containerInfo === f.containerInfo && d.stateNode.implementation === f.implementation) {
                  c(a, d.sibling);
                  d = e(d, f.children || []);
                  d.return = a;
                  a = d;
                  break a;
                } else {
                  c(a, d);
                  break;
                }
              } else b(a, d);
              d = d.sibling;
            }
            d = zh(f, a.mode, h);
            d.return = a;
            a = d;
          }
          return g(a);
        case Ha:
          return l = f._init, J(a, d, l(f._payload), h);
      }
      if (eb(f)) return n(a, d, f, h);
      if (Ka(f)) return t(a, d, f, h);
      th(a, f);
    }
    return "string" === typeof f && "" !== f || "number" === typeof f ? (f = "" + f, null !== d && 6 === d.tag ? (c(a, d.sibling), d = e(d, f), d.return = a, a = d) : (c(a, d), d = xh(f, a.mode, h), d.return = a, a = d), g(a)) : c(a, d);
  }
  return J;
}
var Bh = vh(!0),
  Ch = vh(!1),
  Dh = {},
  Eh = Uf(Dh),
  Fh = Uf(Dh),
  Gh = Uf(Dh);
function Hh(a) {
  if (a === Dh) throw Error(p(174));
  return a;
}
function Ih(a, b) {
  G(Gh, b);
  G(Fh, a);
  G(Eh, Dh);
  a = b.nodeType;
  switch (a) {
    case 9:
    case 11:
      b = (b = b.documentElement) ? b.namespaceURI : lb(null, "");
      break;
    default:
      a = 8 === a ? b.parentNode : b, b = a.namespaceURI || null, a = a.tagName, b = lb(b, a);
  }
  E(Eh);
  G(Eh, b);
}
function Jh() {
  E(Eh);
  E(Fh);
  E(Gh);
}
function Kh(a) {
  Hh(Gh.current);
  var b = Hh(Eh.current);
  var c = lb(b, a.type);
  b !== c && (G(Fh, a), G(Eh, c));
}
function Lh(a) {
  Fh.current === a && (E(Eh), E(Fh));
}
var M = Uf(0);
function Mh(a) {
  for (var b = a; null !== b;) {
    if (13 === b.tag) {
      var c = b.memoizedState;
      if (null !== c && (c = c.dehydrated, null === c || "$?" === c.data || "$!" === c.data)) return b;
    } else if (19 === b.tag && void 0 !== b.memoizedProps.revealOrder) {
      if (0 !== (b.flags & 128)) return b;
    } else if (null !== b.child) {
      b.child.return = b;
      b = b.child;
      continue;
    }
    if (b === a) break;
    for (; null === b.sibling;) {
      if (null === b.return || b.return === a) return null;
      b = b.return;
    }
    b.sibling.return = b.return;
    b = b.sibling;
  }
  return null;
}
var Nh = [];
function Oh() {
  for (var a = 0; a < Nh.length; a++) Nh[a]._workInProgressVersionPrimary = null;
  Nh.length = 0;
}
var Ph = ua.ReactCurrentDispatcher,
  Qh = ua.ReactCurrentBatchConfig,
  Rh = 0,
  N = null,
  O = null,
  P = null,
  Sh = !1,
  Th = !1,
  Uh = 0,
  Vh = 0;
function Q() {
  throw Error(p(321));
}
function Wh(a, b) {
  if (null === b) return !1;
  for (var c = 0; c < b.length && c < a.length; c++) if (!He(a[c], b[c])) return !1;
  return !0;
}
function Xh(a, b, c, d, e, f) {
  Rh = f;
  N = b;
  b.memoizedState = null;
  b.updateQueue = null;
  b.lanes = 0;
  Ph.current = null === a || null === a.memoizedState ? Yh : Zh;
  a = c(d, e);
  if (Th) {
    f = 0;
    do {
      Th = !1;
      Uh = 0;
      if (25 <= f) throw Error(p(301));
      f += 1;
      P = O = null;
      b.updateQueue = null;
      Ph.current = $h;
      a = c(d, e);
    } while (Th);
  }
  Ph.current = ai;
  b = null !== O && null !== O.next;
  Rh = 0;
  P = O = N = null;
  Sh = !1;
  if (b) throw Error(p(300));
  return a;
}
function bi() {
  var a = 0 !== Uh;
  Uh = 0;
  return a;
}
function ci() {
  var a = {
    memoizedState: null,
    baseState: null,
    baseQueue: null,
    queue: null,
    next: null
  };
  null === P ? N.memoizedState = P = a : P = P.next = a;
  return P;
}
function di() {
  if (null === O) {
    var a = N.alternate;
    a = null !== a ? a.memoizedState : null;
  } else a = O.next;
  var b = null === P ? N.memoizedState : P.next;
  if (null !== b) P = b, O = a;else {
    if (null === a) throw Error(p(310));
    O = a;
    a = {
      memoizedState: O.memoizedState,
      baseState: O.baseState,
      baseQueue: O.baseQueue,
      queue: O.queue,
      next: null
    };
    null === P ? N.memoizedState = P = a : P = P.next = a;
  }
  return P;
}
function ei(a, b) {
  return "function" === typeof b ? b(a) : b;
}
function fi(a) {
  var b = di(),
    c = b.queue;
  if (null === c) throw Error(p(311));
  c.lastRenderedReducer = a;
  var d = O,
    e = d.baseQueue,
    f = c.pending;
  if (null !== f) {
    if (null !== e) {
      var g = e.next;
      e.next = f.next;
      f.next = g;
    }
    d.baseQueue = e = f;
    c.pending = null;
  }
  if (null !== e) {
    f = e.next;
    d = d.baseState;
    var h = g = null,
      k = null,
      l = f;
    do {
      var m = l.lane;
      if ((Rh & m) === m) null !== k && (k = k.next = {
        lane: 0,
        action: l.action,
        hasEagerState: l.hasEagerState,
        eagerState: l.eagerState,
        next: null
      }), d = l.hasEagerState ? l.eagerState : a(d, l.action);else {
        var q = {
          lane: m,
          action: l.action,
          hasEagerState: l.hasEagerState,
          eagerState: l.eagerState,
          next: null
        };
        null === k ? (h = k = q, g = d) : k = k.next = q;
        N.lanes |= m;
        hh |= m;
      }
      l = l.next;
    } while (null !== l && l !== f);
    null === k ? g = d : k.next = h;
    He(d, b.memoizedState) || (Ug = !0);
    b.memoizedState = d;
    b.baseState = g;
    b.baseQueue = k;
    c.lastRenderedState = d;
  }
  a = c.interleaved;
  if (null !== a) {
    e = a;
    do f = e.lane, N.lanes |= f, hh |= f, e = e.next; while (e !== a);
  } else null === e && (c.lanes = 0);
  return [b.memoizedState, c.dispatch];
}
function gi(a) {
  var b = di(),
    c = b.queue;
  if (null === c) throw Error(p(311));
  c.lastRenderedReducer = a;
  var d = c.dispatch,
    e = c.pending,
    f = b.memoizedState;
  if (null !== e) {
    c.pending = null;
    var g = e = e.next;
    do f = a(f, g.action), g = g.next; while (g !== e);
    He(f, b.memoizedState) || (Ug = !0);
    b.memoizedState = f;
    null === b.baseQueue && (b.baseState = f);
    c.lastRenderedState = f;
  }
  return [f, d];
}
function hi() {}
function ii(a, b) {
  var c = N,
    d = di(),
    e = b(),
    f = !He(d.memoizedState, e);
  f && (d.memoizedState = e, Ug = !0);
  d = d.queue;
  ji(ki.bind(null, c, d, a), [a]);
  if (d.getSnapshot !== b || f || null !== P && P.memoizedState.tag & 1) {
    c.flags |= 2048;
    li(9, mi.bind(null, c, d, e, b), void 0, null);
    if (null === R) throw Error(p(349));
    0 !== (Rh & 30) || ni(c, b, e);
  }
  return e;
}
function ni(a, b, c) {
  a.flags |= 16384;
  a = {
    getSnapshot: b,
    value: c
  };
  b = N.updateQueue;
  null === b ? (b = {
    lastEffect: null,
    stores: null
  }, N.updateQueue = b, b.stores = [a]) : (c = b.stores, null === c ? b.stores = [a] : c.push(a));
}
function mi(a, b, c, d) {
  b.value = c;
  b.getSnapshot = d;
  oi(b) && pi(a);
}
function ki(a, b, c) {
  return c(function () {
    oi(b) && pi(a);
  });
}
function oi(a) {
  var b = a.getSnapshot;
  a = a.value;
  try {
    var c = b();
    return !He(a, c);
  } catch (d) {
    return !0;
  }
}
function pi(a) {
  var b = Zg(a, 1);
  null !== b && mh(b, a, 1, -1);
}
function qi(a) {
  var b = ci();
  "function" === typeof a && (a = a());
  b.memoizedState = b.baseState = a;
  a = {
    pending: null,
    interleaved: null,
    lanes: 0,
    dispatch: null,
    lastRenderedReducer: ei,
    lastRenderedState: a
  };
  b.queue = a;
  a = a.dispatch = ri.bind(null, N, a);
  return [b.memoizedState, a];
}
function li(a, b, c, d) {
  a = {
    tag: a,
    create: b,
    destroy: c,
    deps: d,
    next: null
  };
  b = N.updateQueue;
  null === b ? (b = {
    lastEffect: null,
    stores: null
  }, N.updateQueue = b, b.lastEffect = a.next = a) : (c = b.lastEffect, null === c ? b.lastEffect = a.next = a : (d = c.next, c.next = a, a.next = d, b.lastEffect = a));
  return a;
}
function si() {
  return di().memoizedState;
}
function ti(a, b, c, d) {
  var e = ci();
  N.flags |= a;
  e.memoizedState = li(1 | b, c, void 0, void 0 === d ? null : d);
}
function ui(a, b, c, d) {
  var e = di();
  d = void 0 === d ? null : d;
  var f = void 0;
  if (null !== O) {
    var g = O.memoizedState;
    f = g.destroy;
    if (null !== d && Wh(d, g.deps)) {
      e.memoizedState = li(b, c, f, d);
      return;
    }
  }
  N.flags |= a;
  e.memoizedState = li(1 | b, c, f, d);
}
function vi(a, b) {
  return ti(8390656, 8, a, b);
}
function ji(a, b) {
  return ui(2048, 8, a, b);
}
function wi(a, b) {
  return ui(4, 2, a, b);
}
function xi(a, b) {
  return ui(4, 4, a, b);
}
function yi(a, b) {
  if ("function" === typeof b) return a = a(), b(a), function () {
    b(null);
  };
  if (null !== b && void 0 !== b) return a = a(), b.current = a, function () {
    b.current = null;
  };
}
function zi(a, b, c) {
  c = null !== c && void 0 !== c ? c.concat([a]) : null;
  return ui(4, 4, yi.bind(null, b, a), c);
}
function Ai() {}
function Bi(a, b) {
  var c = di();
  b = void 0 === b ? null : b;
  var d = c.memoizedState;
  if (null !== d && null !== b && Wh(b, d[1])) return d[0];
  c.memoizedState = [a, b];
  return a;
}
function Ci(a, b) {
  var c = di();
  b = void 0 === b ? null : b;
  var d = c.memoizedState;
  if (null !== d && null !== b && Wh(b, d[1])) return d[0];
  a = a();
  c.memoizedState = [a, b];
  return a;
}
function Di(a, b, c) {
  if (0 === (Rh & 21)) return a.baseState && (a.baseState = !1, Ug = !0), a.memoizedState = c;
  He(c, b) || (c = yc(), N.lanes |= c, hh |= c, a.baseState = !0);
  return b;
}
function Ei(a, b) {
  var c = C;
  C = 0 !== c && 4 > c ? c : 4;
  a(!0);
  var d = Qh.transition;
  Qh.transition = {};
  try {
    a(!1), b();
  } finally {
    C = c, Qh.transition = d;
  }
}
function Fi() {
  return di().memoizedState;
}
function Gi(a, b, c) {
  var d = lh(a);
  c = {
    lane: d,
    action: c,
    hasEagerState: !1,
    eagerState: null,
    next: null
  };
  if (Hi(a)) Ii(b, c);else if (c = Yg(a, b, c, d), null !== c) {
    var e = L();
    mh(c, a, d, e);
    Ji(c, b, d);
  }
}
function ri(a, b, c) {
  var d = lh(a),
    e = {
      lane: d,
      action: c,
      hasEagerState: !1,
      eagerState: null,
      next: null
    };
  if (Hi(a)) Ii(b, e);else {
    var f = a.alternate;
    if (0 === a.lanes && (null === f || 0 === f.lanes) && (f = b.lastRenderedReducer, null !== f)) try {
      var g = b.lastRenderedState,
        h = f(g, c);
      e.hasEagerState = !0;
      e.eagerState = h;
      if (He(h, g)) {
        var k = b.interleaved;
        null === k ? (e.next = e, Xg(b)) : (e.next = k.next, k.next = e);
        b.interleaved = e;
        return;
      }
    } catch (l) {} finally {}
    c = Yg(a, b, e, d);
    null !== c && (e = L(), mh(c, a, d, e), Ji(c, b, d));
  }
}
function Hi(a) {
  var b = a.alternate;
  return a === N || null !== b && b === N;
}
function Ii(a, b) {
  Th = Sh = !0;
  var c = a.pending;
  null === c ? b.next = b : (b.next = c.next, c.next = b);
  a.pending = b;
}
function Ji(a, b, c) {
  if (0 !== (c & 4194240)) {
    var d = b.lanes;
    d &= a.pendingLanes;
    c |= d;
    b.lanes = c;
    Cc(a, c);
  }
}
var ai = {
    readContext: Vg,
    useCallback: Q,
    useContext: Q,
    useEffect: Q,
    useImperativeHandle: Q,
    useInsertionEffect: Q,
    useLayoutEffect: Q,
    useMemo: Q,
    useReducer: Q,
    useRef: Q,
    useState: Q,
    useDebugValue: Q,
    useDeferredValue: Q,
    useTransition: Q,
    useMutableSource: Q,
    useSyncExternalStore: Q,
    useId: Q,
    unstable_isNewReconciler: !1
  },
  Yh = {
    readContext: Vg,
    useCallback: function useCallback(a, b) {
      ci().memoizedState = [a, void 0 === b ? null : b];
      return a;
    },
    useContext: Vg,
    useEffect: vi,
    useImperativeHandle: function useImperativeHandle(a, b, c) {
      c = null !== c && void 0 !== c ? c.concat([a]) : null;
      return ti(4194308, 4, yi.bind(null, b, a), c);
    },
    useLayoutEffect: function useLayoutEffect(a, b) {
      return ti(4194308, 4, a, b);
    },
    useInsertionEffect: function useInsertionEffect(a, b) {
      return ti(4, 2, a, b);
    },
    useMemo: function useMemo(a, b) {
      var c = ci();
      b = void 0 === b ? null : b;
      a = a();
      c.memoizedState = [a, b];
      return a;
    },
    useReducer: function useReducer(a, b, c) {
      var d = ci();
      b = void 0 !== c ? c(b) : b;
      d.memoizedState = d.baseState = b;
      a = {
        pending: null,
        interleaved: null,
        lanes: 0,
        dispatch: null,
        lastRenderedReducer: a,
        lastRenderedState: b
      };
      d.queue = a;
      a = a.dispatch = Gi.bind(null, N, a);
      return [d.memoizedState, a];
    },
    useRef: function useRef(a) {
      var b = ci();
      a = {
        current: a
      };
      return b.memoizedState = a;
    },
    useState: qi,
    useDebugValue: Ai,
    useDeferredValue: function useDeferredValue(a) {
      return ci().memoizedState = a;
    },
    useTransition: function useTransition() {
      var a = qi(!1),
        b = a[0];
      a = Ei.bind(null, a[1]);
      ci().memoizedState = a;
      return [b, a];
    },
    useMutableSource: function useMutableSource() {},
    useSyncExternalStore: function useSyncExternalStore(a, b, c) {
      var d = N,
        e = ci();
      if (I) {
        if (void 0 === c) throw Error(p(407));
        c = c();
      } else {
        c = b();
        if (null === R) throw Error(p(349));
        0 !== (Rh & 30) || ni(d, b, c);
      }
      e.memoizedState = c;
      var f = {
        value: c,
        getSnapshot: b
      };
      e.queue = f;
      vi(ki.bind(null, d, f, a), [a]);
      d.flags |= 2048;
      li(9, mi.bind(null, d, f, c, b), void 0, null);
      return c;
    },
    useId: function useId() {
      var a = ci(),
        b = R.identifierPrefix;
      if (I) {
        var c = sg;
        var d = rg;
        c = (d & ~(1 << 32 - oc(d) - 1)).toString(32) + c;
        b = ":" + b + "R" + c;
        c = Uh++;
        0 < c && (b += "H" + c.toString(32));
        b += ":";
      } else c = Vh++, b = ":" + b + "r" + c.toString(32) + ":";
      return a.memoizedState = b;
    },
    unstable_isNewReconciler: !1
  },
  Zh = {
    readContext: Vg,
    useCallback: Bi,
    useContext: Vg,
    useEffect: ji,
    useImperativeHandle: zi,
    useInsertionEffect: wi,
    useLayoutEffect: xi,
    useMemo: Ci,
    useReducer: fi,
    useRef: si,
    useState: function useState() {
      return fi(ei);
    },
    useDebugValue: Ai,
    useDeferredValue: function useDeferredValue(a) {
      var b = di();
      return Di(b, O.memoizedState, a);
    },
    useTransition: function useTransition() {
      var a = fi(ei)[0],
        b = di().memoizedState;
      return [a, b];
    },
    useMutableSource: hi,
    useSyncExternalStore: ii,
    useId: Fi,
    unstable_isNewReconciler: !1
  },
  $h = {
    readContext: Vg,
    useCallback: Bi,
    useContext: Vg,
    useEffect: ji,
    useImperativeHandle: zi,
    useInsertionEffect: wi,
    useLayoutEffect: xi,
    useMemo: Ci,
    useReducer: gi,
    useRef: si,
    useState: function useState() {
      return gi(ei);
    },
    useDebugValue: Ai,
    useDeferredValue: function useDeferredValue(a) {
      var b = di();
      return null === O ? b.memoizedState = a : Di(b, O.memoizedState, a);
    },
    useTransition: function useTransition() {
      var a = gi(ei)[0],
        b = di().memoizedState;
      return [a, b];
    },
    useMutableSource: hi,
    useSyncExternalStore: ii,
    useId: Fi,
    unstable_isNewReconciler: !1
  };
function Ki(a, b) {
  try {
    var c = "",
      d = b;
    do c += Pa(d), d = d.return; while (d);
    var e = c;
  } catch (f) {
    e = "\nError generating stack: " + f.message + "\n" + f.stack;
  }
  return {
    value: a,
    source: b,
    stack: e,
    digest: null
  };
}
function Li(a, b, c) {
  return {
    value: a,
    source: null,
    stack: null != c ? c : null,
    digest: null != b ? b : null
  };
}
function Mi(a, b) {
  try {
    console.error(b.value);
  } catch (c) {
    setTimeout(function () {
      throw c;
    });
  }
}
var Ni = "function" === typeof WeakMap ? WeakMap : Map;
function Oi(a, b, c) {
  c = ch(-1, c);
  c.tag = 3;
  c.payload = {
    element: null
  };
  var d = b.value;
  c.callback = function () {
    Pi || (Pi = !0, Qi = d);
    Mi(a, b);
  };
  return c;
}
function Ri(a, b, c) {
  c = ch(-1, c);
  c.tag = 3;
  var d = a.type.getDerivedStateFromError;
  if ("function" === typeof d) {
    var e = b.value;
    c.payload = function () {
      return d(e);
    };
    c.callback = function () {
      Mi(a, b);
    };
  }
  var f = a.stateNode;
  null !== f && "function" === typeof f.componentDidCatch && (c.callback = function () {
    Mi(a, b);
    "function" !== typeof d && (null === Si ? Si = new Set([this]) : Si.add(this));
    var c = b.stack;
    this.componentDidCatch(b.value, {
      componentStack: null !== c ? c : ""
    });
  });
  return c;
}
function Ti(a, b, c) {
  var d = a.pingCache;
  if (null === d) {
    d = a.pingCache = new Ni();
    var e = new Set();
    d.set(b, e);
  } else e = d.get(b), void 0 === e && (e = new Set(), d.set(b, e));
  e.has(c) || (e.add(c), a = Ui.bind(null, a, b, c), b.then(a, a));
}
function Vi(a) {
  do {
    var b;
    if (b = 13 === a.tag) b = a.memoizedState, b = null !== b ? null !== b.dehydrated ? !0 : !1 : !0;
    if (b) return a;
    a = a.return;
  } while (null !== a);
  return null;
}
function Wi(a, b, c, d, e) {
  if (0 === (a.mode & 1)) return a === b ? a.flags |= 65536 : (a.flags |= 128, c.flags |= 131072, c.flags &= -52805, 1 === c.tag && (null === c.alternate ? c.tag = 17 : (b = ch(-1, 1), b.tag = 2, dh(c, b, 1))), c.lanes |= 1), a;
  a.flags |= 65536;
  a.lanes = e;
  return a;
}
var Xi = ua.ReactCurrentOwner,
  Ug = !1;
function Yi(a, b, c, d) {
  b.child = null === a ? Ch(b, null, c, d) : Bh(b, a.child, c, d);
}
function Zi(a, b, c, d, e) {
  c = c.render;
  var f = b.ref;
  Tg(b, e);
  d = Xh(a, b, c, d, f, e);
  c = bi();
  if (null !== a && !Ug) return b.updateQueue = a.updateQueue, b.flags &= -2053, a.lanes &= ~e, $i(a, b, e);
  I && c && vg(b);
  b.flags |= 1;
  Yi(a, b, d, e);
  return b.child;
}
function aj(a, b, c, d, e) {
  if (null === a) {
    var f = c.type;
    if ("function" === typeof f && !bj(f) && void 0 === f.defaultProps && null === c.compare && void 0 === c.defaultProps) return b.tag = 15, b.type = f, cj(a, b, f, d, e);
    a = yh(c.type, null, d, b, b.mode, e);
    a.ref = b.ref;
    a.return = b;
    return b.child = a;
  }
  f = a.child;
  if (0 === (a.lanes & e)) {
    var g = f.memoizedProps;
    c = c.compare;
    c = null !== c ? c : Ie;
    if (c(g, d) && a.ref === b.ref) return $i(a, b, e);
  }
  b.flags |= 1;
  a = wh(f, d);
  a.ref = b.ref;
  a.return = b;
  return b.child = a;
}
function cj(a, b, c, d, e) {
  if (null !== a) {
    var f = a.memoizedProps;
    if (Ie(f, d) && a.ref === b.ref) if (Ug = !1, b.pendingProps = d = f, 0 !== (a.lanes & e)) 0 !== (a.flags & 131072) && (Ug = !0);else return b.lanes = a.lanes, $i(a, b, e);
  }
  return dj(a, b, c, d, e);
}
function ej(a, b, c) {
  var d = b.pendingProps,
    e = d.children,
    f = null !== a ? a.memoizedState : null;
  if ("hidden" === d.mode) {
    if (0 === (b.mode & 1)) b.memoizedState = {
      baseLanes: 0,
      cachePool: null,
      transitions: null
    }, G(fj, gj), gj |= c;else {
      if (0 === (c & 1073741824)) return a = null !== f ? f.baseLanes | c : c, b.lanes = b.childLanes = 1073741824, b.memoizedState = {
        baseLanes: a,
        cachePool: null,
        transitions: null
      }, b.updateQueue = null, G(fj, gj), gj |= a, null;
      b.memoizedState = {
        baseLanes: 0,
        cachePool: null,
        transitions: null
      };
      d = null !== f ? f.baseLanes : c;
      G(fj, gj);
      gj |= d;
    }
  } else null !== f ? (d = f.baseLanes | c, b.memoizedState = null) : d = c, G(fj, gj), gj |= d;
  Yi(a, b, e, c);
  return b.child;
}
function hj(a, b) {
  var c = b.ref;
  if (null === a && null !== c || null !== a && a.ref !== c) b.flags |= 512, b.flags |= 2097152;
}
function dj(a, b, c, d, e) {
  var f = Zf(c) ? Xf : H.current;
  f = Yf(b, f);
  Tg(b, e);
  c = Xh(a, b, c, d, f, e);
  d = bi();
  if (null !== a && !Ug) return b.updateQueue = a.updateQueue, b.flags &= -2053, a.lanes &= ~e, $i(a, b, e);
  I && d && vg(b);
  b.flags |= 1;
  Yi(a, b, c, e);
  return b.child;
}
function ij(a, b, c, d, e) {
  if (Zf(c)) {
    var f = !0;
    cg(b);
  } else f = !1;
  Tg(b, e);
  if (null === b.stateNode) jj(a, b), ph(b, c, d), rh(b, c, d, e), d = !0;else if (null === a) {
    var g = b.stateNode,
      h = b.memoizedProps;
    g.props = h;
    var k = g.context,
      l = c.contextType;
    "object" === typeof l && null !== l ? l = Vg(l) : (l = Zf(c) ? Xf : H.current, l = Yf(b, l));
    var m = c.getDerivedStateFromProps,
      q = "function" === typeof m || "function" === typeof g.getSnapshotBeforeUpdate;
    q || "function" !== typeof g.UNSAFE_componentWillReceiveProps && "function" !== typeof g.componentWillReceiveProps || (h !== d || k !== l) && qh(b, g, d, l);
    $g = !1;
    var r = b.memoizedState;
    g.state = r;
    gh(b, d, g, e);
    k = b.memoizedState;
    h !== d || r !== k || Wf.current || $g ? ("function" === typeof m && (kh(b, c, m, d), k = b.memoizedState), (h = $g || oh(b, c, h, d, r, k, l)) ? (q || "function" !== typeof g.UNSAFE_componentWillMount && "function" !== typeof g.componentWillMount || ("function" === typeof g.componentWillMount && g.componentWillMount(), "function" === typeof g.UNSAFE_componentWillMount && g.UNSAFE_componentWillMount()), "function" === typeof g.componentDidMount && (b.flags |= 4194308)) : ("function" === typeof g.componentDidMount && (b.flags |= 4194308), b.memoizedProps = d, b.memoizedState = k), g.props = d, g.state = k, g.context = l, d = h) : ("function" === typeof g.componentDidMount && (b.flags |= 4194308), d = !1);
  } else {
    g = b.stateNode;
    bh(a, b);
    h = b.memoizedProps;
    l = b.type === b.elementType ? h : Lg(b.type, h);
    g.props = l;
    q = b.pendingProps;
    r = g.context;
    k = c.contextType;
    "object" === typeof k && null !== k ? k = Vg(k) : (k = Zf(c) ? Xf : H.current, k = Yf(b, k));
    var y = c.getDerivedStateFromProps;
    (m = "function" === typeof y || "function" === typeof g.getSnapshotBeforeUpdate) || "function" !== typeof g.UNSAFE_componentWillReceiveProps && "function" !== typeof g.componentWillReceiveProps || (h !== q || r !== k) && qh(b, g, d, k);
    $g = !1;
    r = b.memoizedState;
    g.state = r;
    gh(b, d, g, e);
    var n = b.memoizedState;
    h !== q || r !== n || Wf.current || $g ? ("function" === typeof y && (kh(b, c, y, d), n = b.memoizedState), (l = $g || oh(b, c, l, d, r, n, k) || !1) ? (m || "function" !== typeof g.UNSAFE_componentWillUpdate && "function" !== typeof g.componentWillUpdate || ("function" === typeof g.componentWillUpdate && g.componentWillUpdate(d, n, k), "function" === typeof g.UNSAFE_componentWillUpdate && g.UNSAFE_componentWillUpdate(d, n, k)), "function" === typeof g.componentDidUpdate && (b.flags |= 4), "function" === typeof g.getSnapshotBeforeUpdate && (b.flags |= 1024)) : ("function" !== typeof g.componentDidUpdate || h === a.memoizedProps && r === a.memoizedState || (b.flags |= 4), "function" !== typeof g.getSnapshotBeforeUpdate || h === a.memoizedProps && r === a.memoizedState || (b.flags |= 1024), b.memoizedProps = d, b.memoizedState = n), g.props = d, g.state = n, g.context = k, d = l) : ("function" !== typeof g.componentDidUpdate || h === a.memoizedProps && r === a.memoizedState || (b.flags |= 4), "function" !== typeof g.getSnapshotBeforeUpdate || h === a.memoizedProps && r === a.memoizedState || (b.flags |= 1024), d = !1);
  }
  return kj(a, b, c, d, f, e);
}
function kj(a, b, c, d, e, f) {
  hj(a, b);
  var g = 0 !== (b.flags & 128);
  if (!d && !g) return e && dg(b, c, !1), $i(a, b, f);
  d = b.stateNode;
  Xi.current = b;
  var h = g && "function" !== typeof c.getDerivedStateFromError ? null : d.render();
  b.flags |= 1;
  null !== a && g ? (b.child = Bh(b, a.child, null, f), b.child = Bh(b, null, h, f)) : Yi(a, b, h, f);
  b.memoizedState = d.state;
  e && dg(b, c, !0);
  return b.child;
}
function lj(a) {
  var b = a.stateNode;
  b.pendingContext ? ag(a, b.pendingContext, b.pendingContext !== b.context) : b.context && ag(a, b.context, !1);
  Ih(a, b.containerInfo);
}
function mj(a, b, c, d, e) {
  Ig();
  Jg(e);
  b.flags |= 256;
  Yi(a, b, c, d);
  return b.child;
}
var nj = {
  dehydrated: null,
  treeContext: null,
  retryLane: 0
};
function oj(a) {
  return {
    baseLanes: a,
    cachePool: null,
    transitions: null
  };
}
function pj(a, b, c) {
  var d = b.pendingProps,
    e = M.current,
    f = !1,
    g = 0 !== (b.flags & 128),
    h;
  (h = g) || (h = null !== a && null === a.memoizedState ? !1 : 0 !== (e & 2));
  if (h) f = !0, b.flags &= -129;else if (null === a || null !== a.memoizedState) e |= 1;
  G(M, e & 1);
  if (null === a) {
    Eg(b);
    a = b.memoizedState;
    if (null !== a && (a = a.dehydrated, null !== a)) return 0 === (b.mode & 1) ? b.lanes = 1 : "$!" === a.data ? b.lanes = 8 : b.lanes = 1073741824, null;
    g = d.children;
    a = d.fallback;
    return f ? (d = b.mode, f = b.child, g = {
      mode: "hidden",
      children: g
    }, 0 === (d & 1) && null !== f ? (f.childLanes = 0, f.pendingProps = g) : f = qj(g, d, 0, null), a = Ah(a, d, c, null), f.return = b, a.return = b, f.sibling = a, b.child = f, b.child.memoizedState = oj(c), b.memoizedState = nj, a) : rj(b, g);
  }
  e = a.memoizedState;
  if (null !== e && (h = e.dehydrated, null !== h)) return sj(a, b, g, d, h, e, c);
  if (f) {
    f = d.fallback;
    g = b.mode;
    e = a.child;
    h = e.sibling;
    var k = {
      mode: "hidden",
      children: d.children
    };
    0 === (g & 1) && b.child !== e ? (d = b.child, d.childLanes = 0, d.pendingProps = k, b.deletions = null) : (d = wh(e, k), d.subtreeFlags = e.subtreeFlags & 14680064);
    null !== h ? f = wh(h, f) : (f = Ah(f, g, c, null), f.flags |= 2);
    f.return = b;
    d.return = b;
    d.sibling = f;
    b.child = d;
    d = f;
    f = b.child;
    g = a.child.memoizedState;
    g = null === g ? oj(c) : {
      baseLanes: g.baseLanes | c,
      cachePool: null,
      transitions: g.transitions
    };
    f.memoizedState = g;
    f.childLanes = a.childLanes & ~c;
    b.memoizedState = nj;
    return d;
  }
  f = a.child;
  a = f.sibling;
  d = wh(f, {
    mode: "visible",
    children: d.children
  });
  0 === (b.mode & 1) && (d.lanes = c);
  d.return = b;
  d.sibling = null;
  null !== a && (c = b.deletions, null === c ? (b.deletions = [a], b.flags |= 16) : c.push(a));
  b.child = d;
  b.memoizedState = null;
  return d;
}
function rj(a, b) {
  b = qj({
    mode: "visible",
    children: b
  }, a.mode, 0, null);
  b.return = a;
  return a.child = b;
}
function tj(a, b, c, d) {
  null !== d && Jg(d);
  Bh(b, a.child, null, c);
  a = rj(b, b.pendingProps.children);
  a.flags |= 2;
  b.memoizedState = null;
  return a;
}
function sj(a, b, c, d, e, f, g) {
  if (c) {
    if (b.flags & 256) return b.flags &= -257, d = Li(Error(p(422))), tj(a, b, g, d);
    if (null !== b.memoizedState) return b.child = a.child, b.flags |= 128, null;
    f = d.fallback;
    e = b.mode;
    d = qj({
      mode: "visible",
      children: d.children
    }, e, 0, null);
    f = Ah(f, e, g, null);
    f.flags |= 2;
    d.return = b;
    f.return = b;
    d.sibling = f;
    b.child = d;
    0 !== (b.mode & 1) && Bh(b, a.child, null, g);
    b.child.memoizedState = oj(g);
    b.memoizedState = nj;
    return f;
  }
  if (0 === (b.mode & 1)) return tj(a, b, g, null);
  if ("$!" === e.data) {
    d = e.nextSibling && e.nextSibling.dataset;
    if (d) var h = d.dgst;
    d = h;
    f = Error(p(419));
    d = Li(f, d, void 0);
    return tj(a, b, g, d);
  }
  h = 0 !== (g & a.childLanes);
  if (Ug || h) {
    d = R;
    if (null !== d) {
      switch (g & -g) {
        case 4:
          e = 2;
          break;
        case 16:
          e = 8;
          break;
        case 64:
        case 128:
        case 256:
        case 512:
        case 1024:
        case 2048:
        case 4096:
        case 8192:
        case 16384:
        case 32768:
        case 65536:
        case 131072:
        case 262144:
        case 524288:
        case 1048576:
        case 2097152:
        case 4194304:
        case 8388608:
        case 16777216:
        case 33554432:
        case 67108864:
          e = 32;
          break;
        case 536870912:
          e = 268435456;
          break;
        default:
          e = 0;
      }
      e = 0 !== (e & (d.suspendedLanes | g)) ? 0 : e;
      0 !== e && e !== f.retryLane && (f.retryLane = e, Zg(a, e), mh(d, a, e, -1));
    }
    uj();
    d = Li(Error(p(421)));
    return tj(a, b, g, d);
  }
  if ("$?" === e.data) return b.flags |= 128, b.child = a.child, b = vj.bind(null, a), e._reactRetry = b, null;
  a = f.treeContext;
  yg = Lf(e.nextSibling);
  xg = b;
  I = !0;
  zg = null;
  null !== a && (og[pg++] = rg, og[pg++] = sg, og[pg++] = qg, rg = a.id, sg = a.overflow, qg = b);
  b = rj(b, d.children);
  b.flags |= 4096;
  return b;
}
function wj(a, b, c) {
  a.lanes |= b;
  var d = a.alternate;
  null !== d && (d.lanes |= b);
  Sg(a.return, b, c);
}
function xj(a, b, c, d, e) {
  var f = a.memoizedState;
  null === f ? a.memoizedState = {
    isBackwards: b,
    rendering: null,
    renderingStartTime: 0,
    last: d,
    tail: c,
    tailMode: e
  } : (f.isBackwards = b, f.rendering = null, f.renderingStartTime = 0, f.last = d, f.tail = c, f.tailMode = e);
}
function yj(a, b, c) {
  var d = b.pendingProps,
    e = d.revealOrder,
    f = d.tail;
  Yi(a, b, d.children, c);
  d = M.current;
  if (0 !== (d & 2)) d = d & 1 | 2, b.flags |= 128;else {
    if (null !== a && 0 !== (a.flags & 128)) a: for (a = b.child; null !== a;) {
      if (13 === a.tag) null !== a.memoizedState && wj(a, c, b);else if (19 === a.tag) wj(a, c, b);else if (null !== a.child) {
        a.child.return = a;
        a = a.child;
        continue;
      }
      if (a === b) break a;
      for (; null === a.sibling;) {
        if (null === a.return || a.return === b) break a;
        a = a.return;
      }
      a.sibling.return = a.return;
      a = a.sibling;
    }
    d &= 1;
  }
  G(M, d);
  if (0 === (b.mode & 1)) b.memoizedState = null;else switch (e) {
    case "forwards":
      c = b.child;
      for (e = null; null !== c;) a = c.alternate, null !== a && null === Mh(a) && (e = c), c = c.sibling;
      c = e;
      null === c ? (e = b.child, b.child = null) : (e = c.sibling, c.sibling = null);
      xj(b, !1, e, c, f);
      break;
    case "backwards":
      c = null;
      e = b.child;
      for (b.child = null; null !== e;) {
        a = e.alternate;
        if (null !== a && null === Mh(a)) {
          b.child = e;
          break;
        }
        a = e.sibling;
        e.sibling = c;
        c = e;
        e = a;
      }
      xj(b, !0, c, null, f);
      break;
    case "together":
      xj(b, !1, null, null, void 0);
      break;
    default:
      b.memoizedState = null;
  }
  return b.child;
}
function jj(a, b) {
  0 === (b.mode & 1) && null !== a && (a.alternate = null, b.alternate = null, b.flags |= 2);
}
function $i(a, b, c) {
  null !== a && (b.dependencies = a.dependencies);
  hh |= b.lanes;
  if (0 === (c & b.childLanes)) return null;
  if (null !== a && b.child !== a.child) throw Error(p(153));
  if (null !== b.child) {
    a = b.child;
    c = wh(a, a.pendingProps);
    b.child = c;
    for (c.return = b; null !== a.sibling;) a = a.sibling, c = c.sibling = wh(a, a.pendingProps), c.return = b;
    c.sibling = null;
  }
  return b.child;
}
function zj(a, b, c) {
  switch (b.tag) {
    case 3:
      lj(b);
      Ig();
      break;
    case 5:
      Kh(b);
      break;
    case 1:
      Zf(b.type) && cg(b);
      break;
    case 4:
      Ih(b, b.stateNode.containerInfo);
      break;
    case 10:
      var d = b.type._context,
        e = b.memoizedProps.value;
      G(Mg, d._currentValue);
      d._currentValue = e;
      break;
    case 13:
      d = b.memoizedState;
      if (null !== d) {
        if (null !== d.dehydrated) return G(M, M.current & 1), b.flags |= 128, null;
        if (0 !== (c & b.child.childLanes)) return pj(a, b, c);
        G(M, M.current & 1);
        a = $i(a, b, c);
        return null !== a ? a.sibling : null;
      }
      G(M, M.current & 1);
      break;
    case 19:
      d = 0 !== (c & b.childLanes);
      if (0 !== (a.flags & 128)) {
        if (d) return yj(a, b, c);
        b.flags |= 128;
      }
      e = b.memoizedState;
      null !== e && (e.rendering = null, e.tail = null, e.lastEffect = null);
      G(M, M.current);
      if (d) break;else return null;
    case 22:
    case 23:
      return b.lanes = 0, ej(a, b, c);
  }
  return $i(a, b, c);
}
var Aj, Bj, Cj, Dj;
Aj = function Aj(a, b) {
  for (var c = b.child; null !== c;) {
    if (5 === c.tag || 6 === c.tag) a.appendChild(c.stateNode);else if (4 !== c.tag && null !== c.child) {
      c.child.return = c;
      c = c.child;
      continue;
    }
    if (c === b) break;
    for (; null === c.sibling;) {
      if (null === c.return || c.return === b) return;
      c = c.return;
    }
    c.sibling.return = c.return;
    c = c.sibling;
  }
};
Bj = function Bj() {};
Cj = function Cj(a, b, c, d) {
  var e = a.memoizedProps;
  if (e !== d) {
    a = b.stateNode;
    Hh(Eh.current);
    var f = null;
    switch (c) {
      case "input":
        e = Ya(a, e);
        d = Ya(a, d);
        f = [];
        break;
      case "select":
        e = A({}, e, {
          value: void 0
        });
        d = A({}, d, {
          value: void 0
        });
        f = [];
        break;
      case "textarea":
        e = gb(a, e);
        d = gb(a, d);
        f = [];
        break;
      default:
        "function" !== typeof e.onClick && "function" === typeof d.onClick && (a.onclick = Bf);
    }
    ub(c, d);
    var g;
    c = null;
    for (l in e) if (!d.hasOwnProperty(l) && e.hasOwnProperty(l) && null != e[l]) if ("style" === l) {
      var h = e[l];
      for (g in h) h.hasOwnProperty(g) && (c || (c = {}), c[g] = "");
    } else "dangerouslySetInnerHTML" !== l && "children" !== l && "suppressContentEditableWarning" !== l && "suppressHydrationWarning" !== l && "autoFocus" !== l && (ea.hasOwnProperty(l) ? f || (f = []) : (f = f || []).push(l, null));
    for (l in d) {
      var k = d[l];
      h = null != e ? e[l] : void 0;
      if (d.hasOwnProperty(l) && k !== h && (null != k || null != h)) if ("style" === l) {
        if (h) {
          for (g in h) !h.hasOwnProperty(g) || k && k.hasOwnProperty(g) || (c || (c = {}), c[g] = "");
          for (g in k) k.hasOwnProperty(g) && h[g] !== k[g] && (c || (c = {}), c[g] = k[g]);
        } else c || (f || (f = []), f.push(l, c)), c = k;
      } else "dangerouslySetInnerHTML" === l ? (k = k ? k.__html : void 0, h = h ? h.__html : void 0, null != k && h !== k && (f = f || []).push(l, k)) : "children" === l ? "string" !== typeof k && "number" !== typeof k || (f = f || []).push(l, "" + k) : "suppressContentEditableWarning" !== l && "suppressHydrationWarning" !== l && (ea.hasOwnProperty(l) ? (null != k && "onScroll" === l && D("scroll", a), f || h === k || (f = [])) : (f = f || []).push(l, k));
    }
    c && (f = f || []).push("style", c);
    var l = f;
    if (b.updateQueue = l) b.flags |= 4;
  }
};
Dj = function Dj(a, b, c, d) {
  c !== d && (b.flags |= 4);
};
function Ej(a, b) {
  if (!I) switch (a.tailMode) {
    case "hidden":
      b = a.tail;
      for (var c = null; null !== b;) null !== b.alternate && (c = b), b = b.sibling;
      null === c ? a.tail = null : c.sibling = null;
      break;
    case "collapsed":
      c = a.tail;
      for (var d = null; null !== c;) null !== c.alternate && (d = c), c = c.sibling;
      null === d ? b || null === a.tail ? a.tail = null : a.tail.sibling = null : d.sibling = null;
  }
}
function S(a) {
  var b = null !== a.alternate && a.alternate.child === a.child,
    c = 0,
    d = 0;
  if (b) for (var e = a.child; null !== e;) c |= e.lanes | e.childLanes, d |= e.subtreeFlags & 14680064, d |= e.flags & 14680064, e.return = a, e = e.sibling;else for (e = a.child; null !== e;) c |= e.lanes | e.childLanes, d |= e.subtreeFlags, d |= e.flags, e.return = a, e = e.sibling;
  a.subtreeFlags |= d;
  a.childLanes = c;
  return b;
}
function Fj(a, b, c) {
  var d = b.pendingProps;
  wg(b);
  switch (b.tag) {
    case 2:
    case 16:
    case 15:
    case 0:
    case 11:
    case 7:
    case 8:
    case 12:
    case 9:
    case 14:
      return S(b), null;
    case 1:
      return Zf(b.type) && $f(), S(b), null;
    case 3:
      d = b.stateNode;
      Jh();
      E(Wf);
      E(H);
      Oh();
      d.pendingContext && (d.context = d.pendingContext, d.pendingContext = null);
      if (null === a || null === a.child) Gg(b) ? b.flags |= 4 : null === a || a.memoizedState.isDehydrated && 0 === (b.flags & 256) || (b.flags |= 1024, null !== zg && (Gj(zg), zg = null));
      Bj(a, b);
      S(b);
      return null;
    case 5:
      Lh(b);
      var e = Hh(Gh.current);
      c = b.type;
      if (null !== a && null != b.stateNode) Cj(a, b, c, d, e), a.ref !== b.ref && (b.flags |= 512, b.flags |= 2097152);else {
        if (!d) {
          if (null === b.stateNode) throw Error(p(166));
          S(b);
          return null;
        }
        a = Hh(Eh.current);
        if (Gg(b)) {
          d = b.stateNode;
          c = b.type;
          var f = b.memoizedProps;
          d[Of] = b;
          d[Pf] = f;
          a = 0 !== (b.mode & 1);
          switch (c) {
            case "dialog":
              D("cancel", d);
              D("close", d);
              break;
            case "iframe":
            case "object":
            case "embed":
              D("load", d);
              break;
            case "video":
            case "audio":
              for (e = 0; e < lf.length; e++) D(lf[e], d);
              break;
            case "source":
              D("error", d);
              break;
            case "img":
            case "image":
            case "link":
              D("error", d);
              D("load", d);
              break;
            case "details":
              D("toggle", d);
              break;
            case "input":
              Za(d, f);
              D("invalid", d);
              break;
            case "select":
              d._wrapperState = {
                wasMultiple: !!f.multiple
              };
              D("invalid", d);
              break;
            case "textarea":
              hb(d, f), D("invalid", d);
          }
          ub(c, f);
          e = null;
          for (var g in f) if (f.hasOwnProperty(g)) {
            var h = f[g];
            "children" === g ? "string" === typeof h ? d.textContent !== h && (!0 !== f.suppressHydrationWarning && Af(d.textContent, h, a), e = ["children", h]) : "number" === typeof h && d.textContent !== "" + h && (!0 !== f.suppressHydrationWarning && Af(d.textContent, h, a), e = ["children", "" + h]) : ea.hasOwnProperty(g) && null != h && "onScroll" === g && D("scroll", d);
          }
          switch (c) {
            case "input":
              Va(d);
              db(d, f, !0);
              break;
            case "textarea":
              Va(d);
              jb(d);
              break;
            case "select":
            case "option":
              break;
            default:
              "function" === typeof f.onClick && (d.onclick = Bf);
          }
          d = e;
          b.updateQueue = d;
          null !== d && (b.flags |= 4);
        } else {
          g = 9 === e.nodeType ? e : e.ownerDocument;
          "http://www.w3.org/1999/xhtml" === a && (a = kb(c));
          "http://www.w3.org/1999/xhtml" === a ? "script" === c ? (a = g.createElement("div"), a.innerHTML = "<script>\x3c/script>", a = a.removeChild(a.firstChild)) : "string" === typeof d.is ? a = g.createElement(c, {
            is: d.is
          }) : (a = g.createElement(c), "select" === c && (g = a, d.multiple ? g.multiple = !0 : d.size && (g.size = d.size))) : a = g.createElementNS(a, c);
          a[Of] = b;
          a[Pf] = d;
          Aj(a, b, !1, !1);
          b.stateNode = a;
          a: {
            g = vb(c, d);
            switch (c) {
              case "dialog":
                D("cancel", a);
                D("close", a);
                e = d;
                break;
              case "iframe":
              case "object":
              case "embed":
                D("load", a);
                e = d;
                break;
              case "video":
              case "audio":
                for (e = 0; e < lf.length; e++) D(lf[e], a);
                e = d;
                break;
              case "source":
                D("error", a);
                e = d;
                break;
              case "img":
              case "image":
              case "link":
                D("error", a);
                D("load", a);
                e = d;
                break;
              case "details":
                D("toggle", a);
                e = d;
                break;
              case "input":
                Za(a, d);
                e = Ya(a, d);
                D("invalid", a);
                break;
              case "option":
                e = d;
                break;
              case "select":
                a._wrapperState = {
                  wasMultiple: !!d.multiple
                };
                e = A({}, d, {
                  value: void 0
                });
                D("invalid", a);
                break;
              case "textarea":
                hb(a, d);
                e = gb(a, d);
                D("invalid", a);
                break;
              default:
                e = d;
            }
            ub(c, e);
            h = e;
            for (f in h) if (h.hasOwnProperty(f)) {
              var k = h[f];
              "style" === f ? sb(a, k) : "dangerouslySetInnerHTML" === f ? (k = k ? k.__html : void 0, null != k && nb(a, k)) : "children" === f ? "string" === typeof k ? ("textarea" !== c || "" !== k) && ob(a, k) : "number" === typeof k && ob(a, "" + k) : "suppressContentEditableWarning" !== f && "suppressHydrationWarning" !== f && "autoFocus" !== f && (ea.hasOwnProperty(f) ? null != k && "onScroll" === f && D("scroll", a) : null != k && ta(a, f, k, g));
            }
            switch (c) {
              case "input":
                Va(a);
                db(a, d, !1);
                break;
              case "textarea":
                Va(a);
                jb(a);
                break;
              case "option":
                null != d.value && a.setAttribute("value", "" + Sa(d.value));
                break;
              case "select":
                a.multiple = !!d.multiple;
                f = d.value;
                null != f ? fb(a, !!d.multiple, f, !1) : null != d.defaultValue && fb(a, !!d.multiple, d.defaultValue, !0);
                break;
              default:
                "function" === typeof e.onClick && (a.onclick = Bf);
            }
            switch (c) {
              case "button":
              case "input":
              case "select":
              case "textarea":
                d = !!d.autoFocus;
                break a;
              case "img":
                d = !0;
                break a;
              default:
                d = !1;
            }
          }
          d && (b.flags |= 4);
        }
        null !== b.ref && (b.flags |= 512, b.flags |= 2097152);
      }
      S(b);
      return null;
    case 6:
      if (a && null != b.stateNode) Dj(a, b, a.memoizedProps, d);else {
        if ("string" !== typeof d && null === b.stateNode) throw Error(p(166));
        c = Hh(Gh.current);
        Hh(Eh.current);
        if (Gg(b)) {
          d = b.stateNode;
          c = b.memoizedProps;
          d[Of] = b;
          if (f = d.nodeValue !== c) if (a = xg, null !== a) switch (a.tag) {
            case 3:
              Af(d.nodeValue, c, 0 !== (a.mode & 1));
              break;
            case 5:
              !0 !== a.memoizedProps.suppressHydrationWarning && Af(d.nodeValue, c, 0 !== (a.mode & 1));
          }
          f && (b.flags |= 4);
        } else d = (9 === c.nodeType ? c : c.ownerDocument).createTextNode(d), d[Of] = b, b.stateNode = d;
      }
      S(b);
      return null;
    case 13:
      E(M);
      d = b.memoizedState;
      if (null === a || null !== a.memoizedState && null !== a.memoizedState.dehydrated) {
        if (I && null !== yg && 0 !== (b.mode & 1) && 0 === (b.flags & 128)) Hg(), Ig(), b.flags |= 98560, f = !1;else if (f = Gg(b), null !== d && null !== d.dehydrated) {
          if (null === a) {
            if (!f) throw Error(p(318));
            f = b.memoizedState;
            f = null !== f ? f.dehydrated : null;
            if (!f) throw Error(p(317));
            f[Of] = b;
          } else Ig(), 0 === (b.flags & 128) && (b.memoizedState = null), b.flags |= 4;
          S(b);
          f = !1;
        } else null !== zg && (Gj(zg), zg = null), f = !0;
        if (!f) return b.flags & 65536 ? b : null;
      }
      if (0 !== (b.flags & 128)) return b.lanes = c, b;
      d = null !== d;
      d !== (null !== a && null !== a.memoizedState) && d && (b.child.flags |= 8192, 0 !== (b.mode & 1) && (null === a || 0 !== (M.current & 1) ? 0 === T && (T = 3) : uj()));
      null !== b.updateQueue && (b.flags |= 4);
      S(b);
      return null;
    case 4:
      return Jh(), Bj(a, b), null === a && sf(b.stateNode.containerInfo), S(b), null;
    case 10:
      return Rg(b.type._context), S(b), null;
    case 17:
      return Zf(b.type) && $f(), S(b), null;
    case 19:
      E(M);
      f = b.memoizedState;
      if (null === f) return S(b), null;
      d = 0 !== (b.flags & 128);
      g = f.rendering;
      if (null === g) {
        if (d) Ej(f, !1);else {
          if (0 !== T || null !== a && 0 !== (a.flags & 128)) for (a = b.child; null !== a;) {
            g = Mh(a);
            if (null !== g) {
              b.flags |= 128;
              Ej(f, !1);
              d = g.updateQueue;
              null !== d && (b.updateQueue = d, b.flags |= 4);
              b.subtreeFlags = 0;
              d = c;
              for (c = b.child; null !== c;) f = c, a = d, f.flags &= 14680066, g = f.alternate, null === g ? (f.childLanes = 0, f.lanes = a, f.child = null, f.subtreeFlags = 0, f.memoizedProps = null, f.memoizedState = null, f.updateQueue = null, f.dependencies = null, f.stateNode = null) : (f.childLanes = g.childLanes, f.lanes = g.lanes, f.child = g.child, f.subtreeFlags = 0, f.deletions = null, f.memoizedProps = g.memoizedProps, f.memoizedState = g.memoizedState, f.updateQueue = g.updateQueue, f.type = g.type, a = g.dependencies, f.dependencies = null === a ? null : {
                lanes: a.lanes,
                firstContext: a.firstContext
              }), c = c.sibling;
              G(M, M.current & 1 | 2);
              return b.child;
            }
            a = a.sibling;
          }
          null !== f.tail && B() > Hj && (b.flags |= 128, d = !0, Ej(f, !1), b.lanes = 4194304);
        }
      } else {
        if (!d) if (a = Mh(g), null !== a) {
          if (b.flags |= 128, d = !0, c = a.updateQueue, null !== c && (b.updateQueue = c, b.flags |= 4), Ej(f, !0), null === f.tail && "hidden" === f.tailMode && !g.alternate && !I) return S(b), null;
        } else 2 * B() - f.renderingStartTime > Hj && 1073741824 !== c && (b.flags |= 128, d = !0, Ej(f, !1), b.lanes = 4194304);
        f.isBackwards ? (g.sibling = b.child, b.child = g) : (c = f.last, null !== c ? c.sibling = g : b.child = g, f.last = g);
      }
      if (null !== f.tail) return b = f.tail, f.rendering = b, f.tail = b.sibling, f.renderingStartTime = B(), b.sibling = null, c = M.current, G(M, d ? c & 1 | 2 : c & 1), b;
      S(b);
      return null;
    case 22:
    case 23:
      return Ij(), d = null !== b.memoizedState, null !== a && null !== a.memoizedState !== d && (b.flags |= 8192), d && 0 !== (b.mode & 1) ? 0 !== (gj & 1073741824) && (S(b), b.subtreeFlags & 6 && (b.flags |= 8192)) : S(b), null;
    case 24:
      return null;
    case 25:
      return null;
  }
  throw Error(p(156, b.tag));
}
function Jj(a, b) {
  wg(b);
  switch (b.tag) {
    case 1:
      return Zf(b.type) && $f(), a = b.flags, a & 65536 ? (b.flags = a & -65537 | 128, b) : null;
    case 3:
      return Jh(), E(Wf), E(H), Oh(), a = b.flags, 0 !== (a & 65536) && 0 === (a & 128) ? (b.flags = a & -65537 | 128, b) : null;
    case 5:
      return Lh(b), null;
    case 13:
      E(M);
      a = b.memoizedState;
      if (null !== a && null !== a.dehydrated) {
        if (null === b.alternate) throw Error(p(340));
        Ig();
      }
      a = b.flags;
      return a & 65536 ? (b.flags = a & -65537 | 128, b) : null;
    case 19:
      return E(M), null;
    case 4:
      return Jh(), null;
    case 10:
      return Rg(b.type._context), null;
    case 22:
    case 23:
      return Ij(), null;
    case 24:
      return null;
    default:
      return null;
  }
}
var Kj = !1,
  U = !1,
  Lj = "function" === typeof WeakSet ? WeakSet : Set,
  V = null;
function Mj(a, b) {
  var c = a.ref;
  if (null !== c) if ("function" === typeof c) try {
    c(null);
  } catch (d) {
    W(a, b, d);
  } else c.current = null;
}
function Nj(a, b, c) {
  try {
    c();
  } catch (d) {
    W(a, b, d);
  }
}
var Oj = !1;
function Pj(a, b) {
  Cf = dd;
  a = Me();
  if (Ne(a)) {
    if ("selectionStart" in a) var c = {
      start: a.selectionStart,
      end: a.selectionEnd
    };else a: {
      c = (c = a.ownerDocument) && c.defaultView || window;
      var d = c.getSelection && c.getSelection();
      if (d && 0 !== d.rangeCount) {
        c = d.anchorNode;
        var e = d.anchorOffset,
          f = d.focusNode;
        d = d.focusOffset;
        try {
          c.nodeType, f.nodeType;
        } catch (F) {
          c = null;
          break a;
        }
        var g = 0,
          h = -1,
          k = -1,
          l = 0,
          m = 0,
          q = a,
          r = null;
        b: for (;;) {
          for (var y;;) {
            q !== c || 0 !== e && 3 !== q.nodeType || (h = g + e);
            q !== f || 0 !== d && 3 !== q.nodeType || (k = g + d);
            3 === q.nodeType && (g += q.nodeValue.length);
            if (null === (y = q.firstChild)) break;
            r = q;
            q = y;
          }
          for (;;) {
            if (q === a) break b;
            r === c && ++l === e && (h = g);
            r === f && ++m === d && (k = g);
            if (null !== (y = q.nextSibling)) break;
            q = r;
            r = q.parentNode;
          }
          q = y;
        }
        c = -1 === h || -1 === k ? null : {
          start: h,
          end: k
        };
      } else c = null;
    }
    c = c || {
      start: 0,
      end: 0
    };
  } else c = null;
  Df = {
    focusedElem: a,
    selectionRange: c
  };
  dd = !1;
  for (V = b; null !== V;) if (b = V, a = b.child, 0 !== (b.subtreeFlags & 1028) && null !== a) a.return = b, V = a;else for (; null !== V;) {
    b = V;
    try {
      var n = b.alternate;
      if (0 !== (b.flags & 1024)) switch (b.tag) {
        case 0:
        case 11:
        case 15:
          break;
        case 1:
          if (null !== n) {
            var t = n.memoizedProps,
              J = n.memoizedState,
              x = b.stateNode,
              w = x.getSnapshotBeforeUpdate(b.elementType === b.type ? t : Lg(b.type, t), J);
            x.__reactInternalSnapshotBeforeUpdate = w;
          }
          break;
        case 3:
          var u = b.stateNode.containerInfo;
          1 === u.nodeType ? u.textContent = "" : 9 === u.nodeType && u.documentElement && u.removeChild(u.documentElement);
          break;
        case 5:
        case 6:
        case 4:
        case 17:
          break;
        default:
          throw Error(p(163));
      }
    } catch (F) {
      W(b, b.return, F);
    }
    a = b.sibling;
    if (null !== a) {
      a.return = b.return;
      V = a;
      break;
    }
    V = b.return;
  }
  n = Oj;
  Oj = !1;
  return n;
}
function Qj(a, b, c) {
  var d = b.updateQueue;
  d = null !== d ? d.lastEffect : null;
  if (null !== d) {
    var e = d = d.next;
    do {
      if ((e.tag & a) === a) {
        var f = e.destroy;
        e.destroy = void 0;
        void 0 !== f && Nj(b, c, f);
      }
      e = e.next;
    } while (e !== d);
  }
}
function Rj(a, b) {
  b = b.updateQueue;
  b = null !== b ? b.lastEffect : null;
  if (null !== b) {
    var c = b = b.next;
    do {
      if ((c.tag & a) === a) {
        var d = c.create;
        c.destroy = d();
      }
      c = c.next;
    } while (c !== b);
  }
}
function Sj(a) {
  var b = a.ref;
  if (null !== b) {
    var c = a.stateNode;
    switch (a.tag) {
      case 5:
        a = c;
        break;
      default:
        a = c;
    }
    "function" === typeof b ? b(a) : b.current = a;
  }
}
function Tj(a) {
  var b = a.alternate;
  null !== b && (a.alternate = null, Tj(b));
  a.child = null;
  a.deletions = null;
  a.sibling = null;
  5 === a.tag && (b = a.stateNode, null !== b && (delete b[Of], delete b[Pf], delete b[of], delete b[Qf], delete b[Rf]));
  a.stateNode = null;
  a.return = null;
  a.dependencies = null;
  a.memoizedProps = null;
  a.memoizedState = null;
  a.pendingProps = null;
  a.stateNode = null;
  a.updateQueue = null;
}
function Uj(a) {
  return 5 === a.tag || 3 === a.tag || 4 === a.tag;
}
function Vj(a) {
  a: for (;;) {
    for (; null === a.sibling;) {
      if (null === a.return || Uj(a.return)) return null;
      a = a.return;
    }
    a.sibling.return = a.return;
    for (a = a.sibling; 5 !== a.tag && 6 !== a.tag && 18 !== a.tag;) {
      if (a.flags & 2) continue a;
      if (null === a.child || 4 === a.tag) continue a;else a.child.return = a, a = a.child;
    }
    if (!(a.flags & 2)) return a.stateNode;
  }
}
function Wj(a, b, c) {
  var d = a.tag;
  if (5 === d || 6 === d) a = a.stateNode, b ? 8 === c.nodeType ? c.parentNode.insertBefore(a, b) : c.insertBefore(a, b) : (8 === c.nodeType ? (b = c.parentNode, b.insertBefore(a, c)) : (b = c, b.appendChild(a)), c = c._reactRootContainer, null !== c && void 0 !== c || null !== b.onclick || (b.onclick = Bf));else if (4 !== d && (a = a.child, null !== a)) for (Wj(a, b, c), a = a.sibling; null !== a;) Wj(a, b, c), a = a.sibling;
}
function Xj(a, b, c) {
  var d = a.tag;
  if (5 === d || 6 === d) a = a.stateNode, b ? c.insertBefore(a, b) : c.appendChild(a);else if (4 !== d && (a = a.child, null !== a)) for (Xj(a, b, c), a = a.sibling; null !== a;) Xj(a, b, c), a = a.sibling;
}
var X = null,
  Yj = !1;
function Zj(a, b, c) {
  for (c = c.child; null !== c;) ak(a, b, c), c = c.sibling;
}
function ak(a, b, c) {
  if (lc && "function" === typeof lc.onCommitFiberUnmount) try {
    lc.onCommitFiberUnmount(kc, c);
  } catch (h) {}
  switch (c.tag) {
    case 5:
      U || Mj(c, b);
    case 6:
      var d = X,
        e = Yj;
      X = null;
      Zj(a, b, c);
      X = d;
      Yj = e;
      null !== X && (Yj ? (a = X, c = c.stateNode, 8 === a.nodeType ? a.parentNode.removeChild(c) : a.removeChild(c)) : X.removeChild(c.stateNode));
      break;
    case 18:
      null !== X && (Yj ? (a = X, c = c.stateNode, 8 === a.nodeType ? Kf(a.parentNode, c) : 1 === a.nodeType && Kf(a, c), bd(a)) : Kf(X, c.stateNode));
      break;
    case 4:
      d = X;
      e = Yj;
      X = c.stateNode.containerInfo;
      Yj = !0;
      Zj(a, b, c);
      X = d;
      Yj = e;
      break;
    case 0:
    case 11:
    case 14:
    case 15:
      if (!U && (d = c.updateQueue, null !== d && (d = d.lastEffect, null !== d))) {
        e = d = d.next;
        do {
          var f = e,
            g = f.destroy;
          f = f.tag;
          void 0 !== g && (0 !== (f & 2) ? Nj(c, b, g) : 0 !== (f & 4) && Nj(c, b, g));
          e = e.next;
        } while (e !== d);
      }
      Zj(a, b, c);
      break;
    case 1:
      if (!U && (Mj(c, b), d = c.stateNode, "function" === typeof d.componentWillUnmount)) try {
        d.props = c.memoizedProps, d.state = c.memoizedState, d.componentWillUnmount();
      } catch (h) {
        W(c, b, h);
      }
      Zj(a, b, c);
      break;
    case 21:
      Zj(a, b, c);
      break;
    case 22:
      c.mode & 1 ? (U = (d = U) || null !== c.memoizedState, Zj(a, b, c), U = d) : Zj(a, b, c);
      break;
    default:
      Zj(a, b, c);
  }
}
function bk(a) {
  var b = a.updateQueue;
  if (null !== b) {
    a.updateQueue = null;
    var c = a.stateNode;
    null === c && (c = a.stateNode = new Lj());
    b.forEach(function (b) {
      var d = ck.bind(null, a, b);
      c.has(b) || (c.add(b), b.then(d, d));
    });
  }
}
function dk(a, b) {
  var c = b.deletions;
  if (null !== c) for (var d = 0; d < c.length; d++) {
    var e = c[d];
    try {
      var f = a,
        g = b,
        h = g;
      a: for (; null !== h;) {
        switch (h.tag) {
          case 5:
            X = h.stateNode;
            Yj = !1;
            break a;
          case 3:
            X = h.stateNode.containerInfo;
            Yj = !0;
            break a;
          case 4:
            X = h.stateNode.containerInfo;
            Yj = !0;
            break a;
        }
        h = h.return;
      }
      if (null === X) throw Error(p(160));
      ak(f, g, e);
      X = null;
      Yj = !1;
      var k = e.alternate;
      null !== k && (k.return = null);
      e.return = null;
    } catch (l) {
      W(e, b, l);
    }
  }
  if (b.subtreeFlags & 12854) for (b = b.child; null !== b;) ek(b, a), b = b.sibling;
}
function ek(a, b) {
  var c = a.alternate,
    d = a.flags;
  switch (a.tag) {
    case 0:
    case 11:
    case 14:
    case 15:
      dk(b, a);
      fk(a);
      if (d & 4) {
        try {
          Qj(3, a, a.return), Rj(3, a);
        } catch (t) {
          W(a, a.return, t);
        }
        try {
          Qj(5, a, a.return);
        } catch (t) {
          W(a, a.return, t);
        }
      }
      break;
    case 1:
      dk(b, a);
      fk(a);
      d & 512 && null !== c && Mj(c, c.return);
      break;
    case 5:
      dk(b, a);
      fk(a);
      d & 512 && null !== c && Mj(c, c.return);
      if (a.flags & 32) {
        var e = a.stateNode;
        try {
          ob(e, "");
        } catch (t) {
          W(a, a.return, t);
        }
      }
      if (d & 4 && (e = a.stateNode, null != e)) {
        var f = a.memoizedProps,
          g = null !== c ? c.memoizedProps : f,
          h = a.type,
          k = a.updateQueue;
        a.updateQueue = null;
        if (null !== k) try {
          "input" === h && "radio" === f.type && null != f.name && ab(e, f);
          vb(h, g);
          var l = vb(h, f);
          for (g = 0; g < k.length; g += 2) {
            var m = k[g],
              q = k[g + 1];
            "style" === m ? sb(e, q) : "dangerouslySetInnerHTML" === m ? nb(e, q) : "children" === m ? ob(e, q) : ta(e, m, q, l);
          }
          switch (h) {
            case "input":
              bb(e, f);
              break;
            case "textarea":
              ib(e, f);
              break;
            case "select":
              var r = e._wrapperState.wasMultiple;
              e._wrapperState.wasMultiple = !!f.multiple;
              var y = f.value;
              null != y ? fb(e, !!f.multiple, y, !1) : r !== !!f.multiple && (null != f.defaultValue ? fb(e, !!f.multiple, f.defaultValue, !0) : fb(e, !!f.multiple, f.multiple ? [] : "", !1));
          }
          e[Pf] = f;
        } catch (t) {
          W(a, a.return, t);
        }
      }
      break;
    case 6:
      dk(b, a);
      fk(a);
      if (d & 4) {
        if (null === a.stateNode) throw Error(p(162));
        e = a.stateNode;
        f = a.memoizedProps;
        try {
          e.nodeValue = f;
        } catch (t) {
          W(a, a.return, t);
        }
      }
      break;
    case 3:
      dk(b, a);
      fk(a);
      if (d & 4 && null !== c && c.memoizedState.isDehydrated) try {
        bd(b.containerInfo);
      } catch (t) {
        W(a, a.return, t);
      }
      break;
    case 4:
      dk(b, a);
      fk(a);
      break;
    case 13:
      dk(b, a);
      fk(a);
      e = a.child;
      e.flags & 8192 && (f = null !== e.memoizedState, e.stateNode.isHidden = f, !f || null !== e.alternate && null !== e.alternate.memoizedState || (gk = B()));
      d & 4 && bk(a);
      break;
    case 22:
      m = null !== c && null !== c.memoizedState;
      a.mode & 1 ? (U = (l = U) || m, dk(b, a), U = l) : dk(b, a);
      fk(a);
      if (d & 8192) {
        l = null !== a.memoizedState;
        if ((a.stateNode.isHidden = l) && !m && 0 !== (a.mode & 1)) for (V = a, m = a.child; null !== m;) {
          for (q = V = m; null !== V;) {
            r = V;
            y = r.child;
            switch (r.tag) {
              case 0:
              case 11:
              case 14:
              case 15:
                Qj(4, r, r.return);
                break;
              case 1:
                Mj(r, r.return);
                var n = r.stateNode;
                if ("function" === typeof n.componentWillUnmount) {
                  d = r;
                  c = r.return;
                  try {
                    b = d, n.props = b.memoizedProps, n.state = b.memoizedState, n.componentWillUnmount();
                  } catch (t) {
                    W(d, c, t);
                  }
                }
                break;
              case 5:
                Mj(r, r.return);
                break;
              case 22:
                if (null !== r.memoizedState) {
                  hk(q);
                  continue;
                }
            }
            null !== y ? (y.return = r, V = y) : hk(q);
          }
          m = m.sibling;
        }
        a: for (m = null, q = a;;) {
          if (5 === q.tag) {
            if (null === m) {
              m = q;
              try {
                e = q.stateNode, l ? (f = e.style, "function" === typeof f.setProperty ? f.setProperty("display", "none", "important") : f.display = "none") : (h = q.stateNode, k = q.memoizedProps.style, g = void 0 !== k && null !== k && k.hasOwnProperty("display") ? k.display : null, h.style.display = rb("display", g));
              } catch (t) {
                W(a, a.return, t);
              }
            }
          } else if (6 === q.tag) {
            if (null === m) try {
              q.stateNode.nodeValue = l ? "" : q.memoizedProps;
            } catch (t) {
              W(a, a.return, t);
            }
          } else if ((22 !== q.tag && 23 !== q.tag || null === q.memoizedState || q === a) && null !== q.child) {
            q.child.return = q;
            q = q.child;
            continue;
          }
          if (q === a) break a;
          for (; null === q.sibling;) {
            if (null === q.return || q.return === a) break a;
            m === q && (m = null);
            q = q.return;
          }
          m === q && (m = null);
          q.sibling.return = q.return;
          q = q.sibling;
        }
      }
      break;
    case 19:
      dk(b, a);
      fk(a);
      d & 4 && bk(a);
      break;
    case 21:
      break;
    default:
      dk(b, a), fk(a);
  }
}
function fk(a) {
  var b = a.flags;
  if (b & 2) {
    try {
      a: {
        for (var c = a.return; null !== c;) {
          if (Uj(c)) {
            var d = c;
            break a;
          }
          c = c.return;
        }
        throw Error(p(160));
      }
      switch (d.tag) {
        case 5:
          var e = d.stateNode;
          d.flags & 32 && (ob(e, ""), d.flags &= -33);
          var f = Vj(a);
          Xj(a, f, e);
          break;
        case 3:
        case 4:
          var g = d.stateNode.containerInfo,
            h = Vj(a);
          Wj(a, h, g);
          break;
        default:
          throw Error(p(161));
      }
    } catch (k) {
      W(a, a.return, k);
    }
    a.flags &= -3;
  }
  b & 4096 && (a.flags &= -4097);
}
function ik(a, b, c) {
  V = a;
  jk(a, b, c);
}
function jk(a, b, c) {
  for (var d = 0 !== (a.mode & 1); null !== V;) {
    var e = V,
      f = e.child;
    if (22 === e.tag && d) {
      var g = null !== e.memoizedState || Kj;
      if (!g) {
        var h = e.alternate,
          k = null !== h && null !== h.memoizedState || U;
        h = Kj;
        var l = U;
        Kj = g;
        if ((U = k) && !l) for (V = e; null !== V;) g = V, k = g.child, 22 === g.tag && null !== g.memoizedState ? kk(e) : null !== k ? (k.return = g, V = k) : kk(e);
        for (; null !== f;) V = f, jk(f, b, c), f = f.sibling;
        V = e;
        Kj = h;
        U = l;
      }
      lk(a, b, c);
    } else 0 !== (e.subtreeFlags & 8772) && null !== f ? (f.return = e, V = f) : lk(a, b, c);
  }
}
function lk(a) {
  for (; null !== V;) {
    var b = V;
    if (0 !== (b.flags & 8772)) {
      var c = b.alternate;
      try {
        if (0 !== (b.flags & 8772)) switch (b.tag) {
          case 0:
          case 11:
          case 15:
            U || Rj(5, b);
            break;
          case 1:
            var d = b.stateNode;
            if (b.flags & 4 && !U) if (null === c) d.componentDidMount();else {
              var e = b.elementType === b.type ? c.memoizedProps : Lg(b.type, c.memoizedProps);
              d.componentDidUpdate(e, c.memoizedState, d.__reactInternalSnapshotBeforeUpdate);
            }
            var f = b.updateQueue;
            null !== f && ih(b, f, d);
            break;
          case 3:
            var g = b.updateQueue;
            if (null !== g) {
              c = null;
              if (null !== b.child) switch (b.child.tag) {
                case 5:
                  c = b.child.stateNode;
                  break;
                case 1:
                  c = b.child.stateNode;
              }
              ih(b, g, c);
            }
            break;
          case 5:
            var h = b.stateNode;
            if (null === c && b.flags & 4) {
              c = h;
              var k = b.memoizedProps;
              switch (b.type) {
                case "button":
                case "input":
                case "select":
                case "textarea":
                  k.autoFocus && c.focus();
                  break;
                case "img":
                  k.src && (c.src = k.src);
              }
            }
            break;
          case 6:
            break;
          case 4:
            break;
          case 12:
            break;
          case 13:
            if (null === b.memoizedState) {
              var l = b.alternate;
              if (null !== l) {
                var m = l.memoizedState;
                if (null !== m) {
                  var q = m.dehydrated;
                  null !== q && bd(q);
                }
              }
            }
            break;
          case 19:
          case 17:
          case 21:
          case 22:
          case 23:
          case 25:
            break;
          default:
            throw Error(p(163));
        }
        U || b.flags & 512 && Sj(b);
      } catch (r) {
        W(b, b.return, r);
      }
    }
    if (b === a) {
      V = null;
      break;
    }
    c = b.sibling;
    if (null !== c) {
      c.return = b.return;
      V = c;
      break;
    }
    V = b.return;
  }
}
function hk(a) {
  for (; null !== V;) {
    var b = V;
    if (b === a) {
      V = null;
      break;
    }
    var c = b.sibling;
    if (null !== c) {
      c.return = b.return;
      V = c;
      break;
    }
    V = b.return;
  }
}
function kk(a) {
  for (; null !== V;) {
    var b = V;
    try {
      switch (b.tag) {
        case 0:
        case 11:
        case 15:
          var c = b.return;
          try {
            Rj(4, b);
          } catch (k) {
            W(b, c, k);
          }
          break;
        case 1:
          var d = b.stateNode;
          if ("function" === typeof d.componentDidMount) {
            var e = b.return;
            try {
              d.componentDidMount();
            } catch (k) {
              W(b, e, k);
            }
          }
          var f = b.return;
          try {
            Sj(b);
          } catch (k) {
            W(b, f, k);
          }
          break;
        case 5:
          var g = b.return;
          try {
            Sj(b);
          } catch (k) {
            W(b, g, k);
          }
      }
    } catch (k) {
      W(b, b.return, k);
    }
    if (b === a) {
      V = null;
      break;
    }
    var h = b.sibling;
    if (null !== h) {
      h.return = b.return;
      V = h;
      break;
    }
    V = b.return;
  }
}
var mk = Math.ceil,
  nk = ua.ReactCurrentDispatcher,
  ok = ua.ReactCurrentOwner,
  pk = ua.ReactCurrentBatchConfig,
  K = 0,
  R = null,
  Y = null,
  Z = 0,
  gj = 0,
  fj = Uf(0),
  T = 0,
  qk = null,
  hh = 0,
  rk = 0,
  sk = 0,
  tk = null,
  uk = null,
  gk = 0,
  Hj = Infinity,
  vk = null,
  Pi = !1,
  Qi = null,
  Si = null,
  wk = !1,
  xk = null,
  yk = 0,
  zk = 0,
  Ak = null,
  Bk = -1,
  Ck = 0;
function L() {
  return 0 !== (K & 6) ? B() : -1 !== Bk ? Bk : Bk = B();
}
function lh(a) {
  if (0 === (a.mode & 1)) return 1;
  if (0 !== (K & 2) && 0 !== Z) return Z & -Z;
  if (null !== Kg.transition) return 0 === Ck && (Ck = yc()), Ck;
  a = C;
  if (0 !== a) return a;
  a = window.event;
  a = void 0 === a ? 16 : jd(a.type);
  return a;
}
function mh(a, b, c, d) {
  if (50 < zk) throw zk = 0, Ak = null, Error(p(185));
  Ac(a, c, d);
  if (0 === (K & 2) || a !== R) a === R && (0 === (K & 2) && (rk |= c), 4 === T && Dk(a, Z)), Ek(a, d), 1 === c && 0 === K && 0 === (b.mode & 1) && (Hj = B() + 500, fg && jg());
}
function Ek(a, b) {
  var c = a.callbackNode;
  wc(a, b);
  var d = uc(a, a === R ? Z : 0);
  if (0 === d) null !== c && bc(c), a.callbackNode = null, a.callbackPriority = 0;else if (b = d & -d, a.callbackPriority !== b) {
    null != c && bc(c);
    if (1 === b) 0 === a.tag ? ig(Fk.bind(null, a)) : hg(Fk.bind(null, a)), Jf(function () {
      0 === (K & 6) && jg();
    }), c = null;else {
      switch (Dc(d)) {
        case 1:
          c = fc;
          break;
        case 4:
          c = gc;
          break;
        case 16:
          c = hc;
          break;
        case 536870912:
          c = jc;
          break;
        default:
          c = hc;
      }
      c = Gk(c, Hk.bind(null, a));
    }
    a.callbackPriority = b;
    a.callbackNode = c;
  }
}
function Hk(a, b) {
  Bk = -1;
  Ck = 0;
  if (0 !== (K & 6)) throw Error(p(327));
  var c = a.callbackNode;
  if (Ik() && a.callbackNode !== c) return null;
  var d = uc(a, a === R ? Z : 0);
  if (0 === d) return null;
  if (0 !== (d & 30) || 0 !== (d & a.expiredLanes) || b) b = Jk(a, d);else {
    b = d;
    var e = K;
    K |= 2;
    var f = Kk();
    if (R !== a || Z !== b) vk = null, Hj = B() + 500, Lk(a, b);
    do try {
      Mk();
      break;
    } catch (h) {
      Nk(a, h);
    } while (1);
    Qg();
    nk.current = f;
    K = e;
    null !== Y ? b = 0 : (R = null, Z = 0, b = T);
  }
  if (0 !== b) {
    2 === b && (e = xc(a), 0 !== e && (d = e, b = Ok(a, e)));
    if (1 === b) throw c = qk, Lk(a, 0), Dk(a, d), Ek(a, B()), c;
    if (6 === b) Dk(a, d);else {
      e = a.current.alternate;
      if (0 === (d & 30) && !Pk(e) && (b = Jk(a, d), 2 === b && (f = xc(a), 0 !== f && (d = f, b = Ok(a, f))), 1 === b)) throw c = qk, Lk(a, 0), Dk(a, d), Ek(a, B()), c;
      a.finishedWork = e;
      a.finishedLanes = d;
      switch (b) {
        case 0:
        case 1:
          throw Error(p(345));
        case 2:
          Qk(a, uk, vk);
          break;
        case 3:
          Dk(a, d);
          if ((d & 130023424) === d && (b = gk + 500 - B(), 10 < b)) {
            if (0 !== uc(a, 0)) break;
            e = a.suspendedLanes;
            if ((e & d) !== d) {
              L();
              a.pingedLanes |= a.suspendedLanes & e;
              break;
            }
            a.timeoutHandle = Ff(Qk.bind(null, a, uk, vk), b);
            break;
          }
          Qk(a, uk, vk);
          break;
        case 4:
          Dk(a, d);
          if ((d & 4194240) === d) break;
          b = a.eventTimes;
          for (e = -1; 0 < d;) {
            var g = 31 - oc(d);
            f = 1 << g;
            g = b[g];
            g > e && (e = g);
            d &= ~f;
          }
          d = e;
          d = B() - d;
          d = (120 > d ? 120 : 480 > d ? 480 : 1080 > d ? 1080 : 1920 > d ? 1920 : 3E3 > d ? 3E3 : 4320 > d ? 4320 : 1960 * mk(d / 1960)) - d;
          if (10 < d) {
            a.timeoutHandle = Ff(Qk.bind(null, a, uk, vk), d);
            break;
          }
          Qk(a, uk, vk);
          break;
        case 5:
          Qk(a, uk, vk);
          break;
        default:
          throw Error(p(329));
      }
    }
  }
  Ek(a, B());
  return a.callbackNode === c ? Hk.bind(null, a) : null;
}
function Ok(a, b) {
  var c = tk;
  a.current.memoizedState.isDehydrated && (Lk(a, b).flags |= 256);
  a = Jk(a, b);
  2 !== a && (b = uk, uk = c, null !== b && Gj(b));
  return a;
}
function Gj(a) {
  null === uk ? uk = a : uk.push.apply(uk, a);
}
function Pk(a) {
  for (var b = a;;) {
    if (b.flags & 16384) {
      var c = b.updateQueue;
      if (null !== c && (c = c.stores, null !== c)) for (var d = 0; d < c.length; d++) {
        var e = c[d],
          f = e.getSnapshot;
        e = e.value;
        try {
          if (!He(f(), e)) return !1;
        } catch (g) {
          return !1;
        }
      }
    }
    c = b.child;
    if (b.subtreeFlags & 16384 && null !== c) c.return = b, b = c;else {
      if (b === a) break;
      for (; null === b.sibling;) {
        if (null === b.return || b.return === a) return !0;
        b = b.return;
      }
      b.sibling.return = b.return;
      b = b.sibling;
    }
  }
  return !0;
}
function Dk(a, b) {
  b &= ~sk;
  b &= ~rk;
  a.suspendedLanes |= b;
  a.pingedLanes &= ~b;
  for (a = a.expirationTimes; 0 < b;) {
    var c = 31 - oc(b),
      d = 1 << c;
    a[c] = -1;
    b &= ~d;
  }
}
function Fk(a) {
  if (0 !== (K & 6)) throw Error(p(327));
  Ik();
  var b = uc(a, 0);
  if (0 === (b & 1)) return Ek(a, B()), null;
  var c = Jk(a, b);
  if (0 !== a.tag && 2 === c) {
    var d = xc(a);
    0 !== d && (b = d, c = Ok(a, d));
  }
  if (1 === c) throw c = qk, Lk(a, 0), Dk(a, b), Ek(a, B()), c;
  if (6 === c) throw Error(p(345));
  a.finishedWork = a.current.alternate;
  a.finishedLanes = b;
  Qk(a, uk, vk);
  Ek(a, B());
  return null;
}
function Rk(a, b) {
  var c = K;
  K |= 1;
  try {
    return a(b);
  } finally {
    K = c, 0 === K && (Hj = B() + 500, fg && jg());
  }
}
function Sk(a) {
  null !== xk && 0 === xk.tag && 0 === (K & 6) && Ik();
  var b = K;
  K |= 1;
  var c = pk.transition,
    d = C;
  try {
    if (pk.transition = null, C = 1, a) return a();
  } finally {
    C = d, pk.transition = c, K = b, 0 === (K & 6) && jg();
  }
}
function Ij() {
  gj = fj.current;
  E(fj);
}
function Lk(a, b) {
  a.finishedWork = null;
  a.finishedLanes = 0;
  var c = a.timeoutHandle;
  -1 !== c && (a.timeoutHandle = -1, Gf(c));
  if (null !== Y) for (c = Y.return; null !== c;) {
    var d = c;
    wg(d);
    switch (d.tag) {
      case 1:
        d = d.type.childContextTypes;
        null !== d && void 0 !== d && $f();
        break;
      case 3:
        Jh();
        E(Wf);
        E(H);
        Oh();
        break;
      case 5:
        Lh(d);
        break;
      case 4:
        Jh();
        break;
      case 13:
        E(M);
        break;
      case 19:
        E(M);
        break;
      case 10:
        Rg(d.type._context);
        break;
      case 22:
      case 23:
        Ij();
    }
    c = c.return;
  }
  R = a;
  Y = a = wh(a.current, null);
  Z = gj = b;
  T = 0;
  qk = null;
  sk = rk = hh = 0;
  uk = tk = null;
  if (null !== Wg) {
    for (b = 0; b < Wg.length; b++) if (c = Wg[b], d = c.interleaved, null !== d) {
      c.interleaved = null;
      var e = d.next,
        f = c.pending;
      if (null !== f) {
        var g = f.next;
        f.next = e;
        d.next = g;
      }
      c.pending = d;
    }
    Wg = null;
  }
  return a;
}
function Nk(a, b) {
  do {
    var c = Y;
    try {
      Qg();
      Ph.current = ai;
      if (Sh) {
        for (var d = N.memoizedState; null !== d;) {
          var e = d.queue;
          null !== e && (e.pending = null);
          d = d.next;
        }
        Sh = !1;
      }
      Rh = 0;
      P = O = N = null;
      Th = !1;
      Uh = 0;
      ok.current = null;
      if (null === c || null === c.return) {
        T = 1;
        qk = b;
        Y = null;
        break;
      }
      a: {
        var f = a,
          g = c.return,
          h = c,
          k = b;
        b = Z;
        h.flags |= 32768;
        if (null !== k && "object" === typeof k && "function" === typeof k.then) {
          var l = k,
            m = h,
            q = m.tag;
          if (0 === (m.mode & 1) && (0 === q || 11 === q || 15 === q)) {
            var r = m.alternate;
            r ? (m.updateQueue = r.updateQueue, m.memoizedState = r.memoizedState, m.lanes = r.lanes) : (m.updateQueue = null, m.memoizedState = null);
          }
          var y = Vi(g);
          if (null !== y) {
            y.flags &= -257;
            Wi(y, g, h, f, b);
            y.mode & 1 && Ti(f, l, b);
            b = y;
            k = l;
            var n = b.updateQueue;
            if (null === n) {
              var t = new Set();
              t.add(k);
              b.updateQueue = t;
            } else n.add(k);
            break a;
          } else {
            if (0 === (b & 1)) {
              Ti(f, l, b);
              uj();
              break a;
            }
            k = Error(p(426));
          }
        } else if (I && h.mode & 1) {
          var J = Vi(g);
          if (null !== J) {
            0 === (J.flags & 65536) && (J.flags |= 256);
            Wi(J, g, h, f, b);
            Jg(Ki(k, h));
            break a;
          }
        }
        f = k = Ki(k, h);
        4 !== T && (T = 2);
        null === tk ? tk = [f] : tk.push(f);
        f = g;
        do {
          switch (f.tag) {
            case 3:
              f.flags |= 65536;
              b &= -b;
              f.lanes |= b;
              var x = Oi(f, k, b);
              fh(f, x);
              break a;
            case 1:
              h = k;
              var w = f.type,
                u = f.stateNode;
              if (0 === (f.flags & 128) && ("function" === typeof w.getDerivedStateFromError || null !== u && "function" === typeof u.componentDidCatch && (null === Si || !Si.has(u)))) {
                f.flags |= 65536;
                b &= -b;
                f.lanes |= b;
                var F = Ri(f, h, b);
                fh(f, F);
                break a;
              }
          }
          f = f.return;
        } while (null !== f);
      }
      Tk(c);
    } catch (na) {
      b = na;
      Y === c && null !== c && (Y = c = c.return);
      continue;
    }
    break;
  } while (1);
}
function Kk() {
  var a = nk.current;
  nk.current = ai;
  return null === a ? ai : a;
}
function uj() {
  if (0 === T || 3 === T || 2 === T) T = 4;
  null === R || 0 === (hh & 268435455) && 0 === (rk & 268435455) || Dk(R, Z);
}
function Jk(a, b) {
  var c = K;
  K |= 2;
  var d = Kk();
  if (R !== a || Z !== b) vk = null, Lk(a, b);
  do try {
    Uk();
    break;
  } catch (e) {
    Nk(a, e);
  } while (1);
  Qg();
  K = c;
  nk.current = d;
  if (null !== Y) throw Error(p(261));
  R = null;
  Z = 0;
  return T;
}
function Uk() {
  for (; null !== Y;) Vk(Y);
}
function Mk() {
  for (; null !== Y && !cc();) Vk(Y);
}
function Vk(a) {
  var b = Wk(a.alternate, a, gj);
  a.memoizedProps = a.pendingProps;
  null === b ? Tk(a) : Y = b;
  ok.current = null;
}
function Tk(a) {
  var b = a;
  do {
    var c = b.alternate;
    a = b.return;
    if (0 === (b.flags & 32768)) {
      if (c = Fj(c, b, gj), null !== c) {
        Y = c;
        return;
      }
    } else {
      c = Jj(c, b);
      if (null !== c) {
        c.flags &= 32767;
        Y = c;
        return;
      }
      if (null !== a) a.flags |= 32768, a.subtreeFlags = 0, a.deletions = null;else {
        T = 6;
        Y = null;
        return;
      }
    }
    b = b.sibling;
    if (null !== b) {
      Y = b;
      return;
    }
    Y = b = a;
  } while (null !== b);
  0 === T && (T = 5);
}
function Qk(a, b, c) {
  var d = C,
    e = pk.transition;
  try {
    pk.transition = null, C = 1, Xk(a, b, c, d);
  } finally {
    pk.transition = e, C = d;
  }
  return null;
}
function Xk(a, b, c, d) {
  do Ik(); while (null !== xk);
  if (0 !== (K & 6)) throw Error(p(327));
  c = a.finishedWork;
  var e = a.finishedLanes;
  if (null === c) return null;
  a.finishedWork = null;
  a.finishedLanes = 0;
  if (c === a.current) throw Error(p(177));
  a.callbackNode = null;
  a.callbackPriority = 0;
  var f = c.lanes | c.childLanes;
  Bc(a, f);
  a === R && (Y = R = null, Z = 0);
  0 === (c.subtreeFlags & 2064) && 0 === (c.flags & 2064) || wk || (wk = !0, Gk(hc, function () {
    Ik();
    return null;
  }));
  f = 0 !== (c.flags & 15990);
  if (0 !== (c.subtreeFlags & 15990) || f) {
    f = pk.transition;
    pk.transition = null;
    var g = C;
    C = 1;
    var h = K;
    K |= 4;
    ok.current = null;
    Pj(a, c);
    ek(c, a);
    Oe(Df);
    dd = !!Cf;
    Df = Cf = null;
    a.current = c;
    ik(c, a, e);
    dc();
    K = h;
    C = g;
    pk.transition = f;
  } else a.current = c;
  wk && (wk = !1, xk = a, yk = e);
  f = a.pendingLanes;
  0 === f && (Si = null);
  mc(c.stateNode, d);
  Ek(a, B());
  if (null !== b) for (d = a.onRecoverableError, c = 0; c < b.length; c++) e = b[c], d(e.value, {
    componentStack: e.stack,
    digest: e.digest
  });
  if (Pi) throw Pi = !1, a = Qi, Qi = null, a;
  0 !== (yk & 1) && 0 !== a.tag && Ik();
  f = a.pendingLanes;
  0 !== (f & 1) ? a === Ak ? zk++ : (zk = 0, Ak = a) : zk = 0;
  jg();
  return null;
}
function Ik() {
  if (null !== xk) {
    var a = Dc(yk),
      b = pk.transition,
      c = C;
    try {
      pk.transition = null;
      C = 16 > a ? 16 : a;
      if (null === xk) var d = !1;else {
        a = xk;
        xk = null;
        yk = 0;
        if (0 !== (K & 6)) throw Error(p(331));
        var e = K;
        K |= 4;
        for (V = a.current; null !== V;) {
          var f = V,
            g = f.child;
          if (0 !== (V.flags & 16)) {
            var h = f.deletions;
            if (null !== h) {
              for (var k = 0; k < h.length; k++) {
                var l = h[k];
                for (V = l; null !== V;) {
                  var m = V;
                  switch (m.tag) {
                    case 0:
                    case 11:
                    case 15:
                      Qj(8, m, f);
                  }
                  var q = m.child;
                  if (null !== q) q.return = m, V = q;else for (; null !== V;) {
                    m = V;
                    var r = m.sibling,
                      y = m.return;
                    Tj(m);
                    if (m === l) {
                      V = null;
                      break;
                    }
                    if (null !== r) {
                      r.return = y;
                      V = r;
                      break;
                    }
                    V = y;
                  }
                }
              }
              var n = f.alternate;
              if (null !== n) {
                var t = n.child;
                if (null !== t) {
                  n.child = null;
                  do {
                    var J = t.sibling;
                    t.sibling = null;
                    t = J;
                  } while (null !== t);
                }
              }
              V = f;
            }
          }
          if (0 !== (f.subtreeFlags & 2064) && null !== g) g.return = f, V = g;else b: for (; null !== V;) {
            f = V;
            if (0 !== (f.flags & 2048)) switch (f.tag) {
              case 0:
              case 11:
              case 15:
                Qj(9, f, f.return);
            }
            var x = f.sibling;
            if (null !== x) {
              x.return = f.return;
              V = x;
              break b;
            }
            V = f.return;
          }
        }
        var w = a.current;
        for (V = w; null !== V;) {
          g = V;
          var u = g.child;
          if (0 !== (g.subtreeFlags & 2064) && null !== u) u.return = g, V = u;else b: for (g = w; null !== V;) {
            h = V;
            if (0 !== (h.flags & 2048)) try {
              switch (h.tag) {
                case 0:
                case 11:
                case 15:
                  Rj(9, h);
              }
            } catch (na) {
              W(h, h.return, na);
            }
            if (h === g) {
              V = null;
              break b;
            }
            var F = h.sibling;
            if (null !== F) {
              F.return = h.return;
              V = F;
              break b;
            }
            V = h.return;
          }
        }
        K = e;
        jg();
        if (lc && "function" === typeof lc.onPostCommitFiberRoot) try {
          lc.onPostCommitFiberRoot(kc, a);
        } catch (na) {}
        d = !0;
      }
      return d;
    } finally {
      C = c, pk.transition = b;
    }
  }
  return !1;
}
function Yk(a, b, c) {
  b = Ki(c, b);
  b = Oi(a, b, 1);
  a = dh(a, b, 1);
  b = L();
  null !== a && (Ac(a, 1, b), Ek(a, b));
}
function W(a, b, c) {
  if (3 === a.tag) Yk(a, a, c);else for (; null !== b;) {
    if (3 === b.tag) {
      Yk(b, a, c);
      break;
    } else if (1 === b.tag) {
      var d = b.stateNode;
      if ("function" === typeof b.type.getDerivedStateFromError || "function" === typeof d.componentDidCatch && (null === Si || !Si.has(d))) {
        a = Ki(c, a);
        a = Ri(b, a, 1);
        b = dh(b, a, 1);
        a = L();
        null !== b && (Ac(b, 1, a), Ek(b, a));
        break;
      }
    }
    b = b.return;
  }
}
function Ui(a, b, c) {
  var d = a.pingCache;
  null !== d && d.delete(b);
  b = L();
  a.pingedLanes |= a.suspendedLanes & c;
  R === a && (Z & c) === c && (4 === T || 3 === T && (Z & 130023424) === Z && 500 > B() - gk ? Lk(a, 0) : sk |= c);
  Ek(a, b);
}
function Zk(a, b) {
  0 === b && (0 === (a.mode & 1) ? b = 1 : (b = sc, sc <<= 1, 0 === (sc & 130023424) && (sc = 4194304)));
  var c = L();
  a = Zg(a, b);
  null !== a && (Ac(a, b, c), Ek(a, c));
}
function vj(a) {
  var b = a.memoizedState,
    c = 0;
  null !== b && (c = b.retryLane);
  Zk(a, c);
}
function ck(a, b) {
  var c = 0;
  switch (a.tag) {
    case 13:
      var d = a.stateNode;
      var e = a.memoizedState;
      null !== e && (c = e.retryLane);
      break;
    case 19:
      d = a.stateNode;
      break;
    default:
      throw Error(p(314));
  }
  null !== d && d.delete(b);
  Zk(a, c);
}
var Wk;
Wk = function Wk(a, b, c) {
  if (null !== a) {
    if (a.memoizedProps !== b.pendingProps || Wf.current) Ug = !0;else {
      if (0 === (a.lanes & c) && 0 === (b.flags & 128)) return Ug = !1, zj(a, b, c);
      Ug = 0 !== (a.flags & 131072) ? !0 : !1;
    }
  } else Ug = !1, I && 0 !== (b.flags & 1048576) && ug(b, ng, b.index);
  b.lanes = 0;
  switch (b.tag) {
    case 2:
      var d = b.type;
      jj(a, b);
      a = b.pendingProps;
      var e = Yf(b, H.current);
      Tg(b, c);
      e = Xh(null, b, d, a, e, c);
      var f = bi();
      b.flags |= 1;
      "object" === typeof e && null !== e && "function" === typeof e.render && void 0 === e.$$typeof ? (b.tag = 1, b.memoizedState = null, b.updateQueue = null, Zf(d) ? (f = !0, cg(b)) : f = !1, b.memoizedState = null !== e.state && void 0 !== e.state ? e.state : null, ah(b), e.updater = nh, b.stateNode = e, e._reactInternals = b, rh(b, d, a, c), b = kj(null, b, d, !0, f, c)) : (b.tag = 0, I && f && vg(b), Yi(null, b, e, c), b = b.child);
      return b;
    case 16:
      d = b.elementType;
      a: {
        jj(a, b);
        a = b.pendingProps;
        e = d._init;
        d = e(d._payload);
        b.type = d;
        e = b.tag = $k(d);
        a = Lg(d, a);
        switch (e) {
          case 0:
            b = dj(null, b, d, a, c);
            break a;
          case 1:
            b = ij(null, b, d, a, c);
            break a;
          case 11:
            b = Zi(null, b, d, a, c);
            break a;
          case 14:
            b = aj(null, b, d, Lg(d.type, a), c);
            break a;
        }
        throw Error(p(306, d, ""));
      }
      return b;
    case 0:
      return d = b.type, e = b.pendingProps, e = b.elementType === d ? e : Lg(d, e), dj(a, b, d, e, c);
    case 1:
      return d = b.type, e = b.pendingProps, e = b.elementType === d ? e : Lg(d, e), ij(a, b, d, e, c);
    case 3:
      a: {
        lj(b);
        if (null === a) throw Error(p(387));
        d = b.pendingProps;
        f = b.memoizedState;
        e = f.element;
        bh(a, b);
        gh(b, d, null, c);
        var g = b.memoizedState;
        d = g.element;
        if (f.isDehydrated) {
          if (f = {
            element: d,
            isDehydrated: !1,
            cache: g.cache,
            pendingSuspenseBoundaries: g.pendingSuspenseBoundaries,
            transitions: g.transitions
          }, b.updateQueue.baseState = f, b.memoizedState = f, b.flags & 256) {
            e = Ki(Error(p(423)), b);
            b = mj(a, b, d, c, e);
            break a;
          } else if (d !== e) {
            e = Ki(Error(p(424)), b);
            b = mj(a, b, d, c, e);
            break a;
          } else for (yg = Lf(b.stateNode.containerInfo.firstChild), xg = b, I = !0, zg = null, c = Ch(b, null, d, c), b.child = c; c;) c.flags = c.flags & -3 | 4096, c = c.sibling;
        } else {
          Ig();
          if (d === e) {
            b = $i(a, b, c);
            break a;
          }
          Yi(a, b, d, c);
        }
        b = b.child;
      }
      return b;
    case 5:
      return Kh(b), null === a && Eg(b), d = b.type, e = b.pendingProps, f = null !== a ? a.memoizedProps : null, g = e.children, Ef(d, e) ? g = null : null !== f && Ef(d, f) && (b.flags |= 32), hj(a, b), Yi(a, b, g, c), b.child;
    case 6:
      return null === a && Eg(b), null;
    case 13:
      return pj(a, b, c);
    case 4:
      return Ih(b, b.stateNode.containerInfo), d = b.pendingProps, null === a ? b.child = Bh(b, null, d, c) : Yi(a, b, d, c), b.child;
    case 11:
      return d = b.type, e = b.pendingProps, e = b.elementType === d ? e : Lg(d, e), Zi(a, b, d, e, c);
    case 7:
      return Yi(a, b, b.pendingProps, c), b.child;
    case 8:
      return Yi(a, b, b.pendingProps.children, c), b.child;
    case 12:
      return Yi(a, b, b.pendingProps.children, c), b.child;
    case 10:
      a: {
        d = b.type._context;
        e = b.pendingProps;
        f = b.memoizedProps;
        g = e.value;
        G(Mg, d._currentValue);
        d._currentValue = g;
        if (null !== f) if (He(f.value, g)) {
          if (f.children === e.children && !Wf.current) {
            b = $i(a, b, c);
            break a;
          }
        } else for (f = b.child, null !== f && (f.return = b); null !== f;) {
          var h = f.dependencies;
          if (null !== h) {
            g = f.child;
            for (var k = h.firstContext; null !== k;) {
              if (k.context === d) {
                if (1 === f.tag) {
                  k = ch(-1, c & -c);
                  k.tag = 2;
                  var l = f.updateQueue;
                  if (null !== l) {
                    l = l.shared;
                    var m = l.pending;
                    null === m ? k.next = k : (k.next = m.next, m.next = k);
                    l.pending = k;
                  }
                }
                f.lanes |= c;
                k = f.alternate;
                null !== k && (k.lanes |= c);
                Sg(f.return, c, b);
                h.lanes |= c;
                break;
              }
              k = k.next;
            }
          } else if (10 === f.tag) g = f.type === b.type ? null : f.child;else if (18 === f.tag) {
            g = f.return;
            if (null === g) throw Error(p(341));
            g.lanes |= c;
            h = g.alternate;
            null !== h && (h.lanes |= c);
            Sg(g, c, b);
            g = f.sibling;
          } else g = f.child;
          if (null !== g) g.return = f;else for (g = f; null !== g;) {
            if (g === b) {
              g = null;
              break;
            }
            f = g.sibling;
            if (null !== f) {
              f.return = g.return;
              g = f;
              break;
            }
            g = g.return;
          }
          f = g;
        }
        Yi(a, b, e.children, c);
        b = b.child;
      }
      return b;
    case 9:
      return e = b.type, d = b.pendingProps.children, Tg(b, c), e = Vg(e), d = d(e), b.flags |= 1, Yi(a, b, d, c), b.child;
    case 14:
      return d = b.type, e = Lg(d, b.pendingProps), e = Lg(d.type, e), aj(a, b, d, e, c);
    case 15:
      return cj(a, b, b.type, b.pendingProps, c);
    case 17:
      return d = b.type, e = b.pendingProps, e = b.elementType === d ? e : Lg(d, e), jj(a, b), b.tag = 1, Zf(d) ? (a = !0, cg(b)) : a = !1, Tg(b, c), ph(b, d, e), rh(b, d, e, c), kj(null, b, d, !0, a, c);
    case 19:
      return yj(a, b, c);
    case 22:
      return ej(a, b, c);
  }
  throw Error(p(156, b.tag));
};
function Gk(a, b) {
  return ac(a, b);
}
function al(a, b, c, d) {
  this.tag = a;
  this.key = c;
  this.sibling = this.child = this.return = this.stateNode = this.type = this.elementType = null;
  this.index = 0;
  this.ref = null;
  this.pendingProps = b;
  this.dependencies = this.memoizedState = this.updateQueue = this.memoizedProps = null;
  this.mode = d;
  this.subtreeFlags = this.flags = 0;
  this.deletions = null;
  this.childLanes = this.lanes = 0;
  this.alternate = null;
}
function Bg(a, b, c, d) {
  return new al(a, b, c, d);
}
function bj(a) {
  a = a.prototype;
  return !(!a || !a.isReactComponent);
}
function $k(a) {
  if ("function" === typeof a) return bj(a) ? 1 : 0;
  if (void 0 !== a && null !== a) {
    a = a.$$typeof;
    if (a === Da) return 11;
    if (a === Ga) return 14;
  }
  return 2;
}
function wh(a, b) {
  var c = a.alternate;
  null === c ? (c = Bg(a.tag, b, a.key, a.mode), c.elementType = a.elementType, c.type = a.type, c.stateNode = a.stateNode, c.alternate = a, a.alternate = c) : (c.pendingProps = b, c.type = a.type, c.flags = 0, c.subtreeFlags = 0, c.deletions = null);
  c.flags = a.flags & 14680064;
  c.childLanes = a.childLanes;
  c.lanes = a.lanes;
  c.child = a.child;
  c.memoizedProps = a.memoizedProps;
  c.memoizedState = a.memoizedState;
  c.updateQueue = a.updateQueue;
  b = a.dependencies;
  c.dependencies = null === b ? null : {
    lanes: b.lanes,
    firstContext: b.firstContext
  };
  c.sibling = a.sibling;
  c.index = a.index;
  c.ref = a.ref;
  return c;
}
function yh(a, b, c, d, e, f) {
  var g = 2;
  d = a;
  if ("function" === typeof a) bj(a) && (g = 1);else if ("string" === typeof a) g = 5;else a: switch (a) {
    case ya:
      return Ah(c.children, e, f, b);
    case za:
      g = 8;
      e |= 8;
      break;
    case Aa:
      return a = Bg(12, c, b, e | 2), a.elementType = Aa, a.lanes = f, a;
    case Ea:
      return a = Bg(13, c, b, e), a.elementType = Ea, a.lanes = f, a;
    case Fa:
      return a = Bg(19, c, b, e), a.elementType = Fa, a.lanes = f, a;
    case Ia:
      return qj(c, e, f, b);
    default:
      if ("object" === typeof a && null !== a) switch (a.$$typeof) {
        case Ba:
          g = 10;
          break a;
        case Ca:
          g = 9;
          break a;
        case Da:
          g = 11;
          break a;
        case Ga:
          g = 14;
          break a;
        case Ha:
          g = 16;
          d = null;
          break a;
      }
      throw Error(p(130, null == a ? a : typeof a, ""));
  }
  b = Bg(g, c, b, e);
  b.elementType = a;
  b.type = d;
  b.lanes = f;
  return b;
}
function Ah(a, b, c, d) {
  a = Bg(7, a, d, b);
  a.lanes = c;
  return a;
}
function qj(a, b, c, d) {
  a = Bg(22, a, d, b);
  a.elementType = Ia;
  a.lanes = c;
  a.stateNode = {
    isHidden: !1
  };
  return a;
}
function xh(a, b, c) {
  a = Bg(6, a, null, b);
  a.lanes = c;
  return a;
}
function zh(a, b, c) {
  b = Bg(4, null !== a.children ? a.children : [], a.key, b);
  b.lanes = c;
  b.stateNode = {
    containerInfo: a.containerInfo,
    pendingChildren: null,
    implementation: a.implementation
  };
  return b;
}
function bl(a, b, c, d, e) {
  this.tag = b;
  this.containerInfo = a;
  this.finishedWork = this.pingCache = this.current = this.pendingChildren = null;
  this.timeoutHandle = -1;
  this.callbackNode = this.pendingContext = this.context = null;
  this.callbackPriority = 0;
  this.eventTimes = zc(0);
  this.expirationTimes = zc(-1);
  this.entangledLanes = this.finishedLanes = this.mutableReadLanes = this.expiredLanes = this.pingedLanes = this.suspendedLanes = this.pendingLanes = 0;
  this.entanglements = zc(0);
  this.identifierPrefix = d;
  this.onRecoverableError = e;
  this.mutableSourceEagerHydrationData = null;
}
function cl(a, b, c, d, e, f, g, h, k) {
  a = new bl(a, b, c, h, k);
  1 === b ? (b = 1, !0 === f && (b |= 8)) : b = 0;
  f = Bg(3, null, null, b);
  a.current = f;
  f.stateNode = a;
  f.memoizedState = {
    element: d,
    isDehydrated: c,
    cache: null,
    transitions: null,
    pendingSuspenseBoundaries: null
  };
  ah(f);
  return a;
}
function dl(a, b, c) {
  var d = 3 < arguments.length && void 0 !== arguments[3] ? arguments[3] : null;
  return {
    $$typeof: wa,
    key: null == d ? null : "" + d,
    children: a,
    containerInfo: b,
    implementation: c
  };
}
function el(a) {
  if (!a) return Vf;
  a = a._reactInternals;
  a: {
    if (Vb(a) !== a || 1 !== a.tag) throw Error(p(170));
    var b = a;
    do {
      switch (b.tag) {
        case 3:
          b = b.stateNode.context;
          break a;
        case 1:
          if (Zf(b.type)) {
            b = b.stateNode.__reactInternalMemoizedMergedChildContext;
            break a;
          }
      }
      b = b.return;
    } while (null !== b);
    throw Error(p(171));
  }
  if (1 === a.tag) {
    var c = a.type;
    if (Zf(c)) return bg(a, c, b);
  }
  return b;
}
function fl(a, b, c, d, e, f, g, h, k) {
  a = cl(c, d, !0, a, e, f, g, h, k);
  a.context = el(null);
  c = a.current;
  d = L();
  e = lh(c);
  f = ch(d, e);
  f.callback = void 0 !== b && null !== b ? b : null;
  dh(c, f, e);
  a.current.lanes = e;
  Ac(a, e, d);
  Ek(a, d);
  return a;
}
function gl(a, b, c, d) {
  var e = b.current,
    f = L(),
    g = lh(e);
  c = el(c);
  null === b.context ? b.context = c : b.pendingContext = c;
  b = ch(f, g);
  b.payload = {
    element: a
  };
  d = void 0 === d ? null : d;
  null !== d && (b.callback = d);
  a = dh(e, b, g);
  null !== a && (mh(a, e, g, f), eh(a, e, g));
  return g;
}
function hl(a) {
  a = a.current;
  if (!a.child) return null;
  switch (a.child.tag) {
    case 5:
      return a.child.stateNode;
    default:
      return a.child.stateNode;
  }
}
function il(a, b) {
  a = a.memoizedState;
  if (null !== a && null !== a.dehydrated) {
    var c = a.retryLane;
    a.retryLane = 0 !== c && c < b ? c : b;
  }
}
function jl(a, b) {
  il(a, b);
  (a = a.alternate) && il(a, b);
}
function kl() {
  return null;
}
var ll = "function" === typeof reportError ? reportError : function (a) {
  console.error(a);
};
function ml(a) {
  this._internalRoot = a;
}
nl.prototype.render = ml.prototype.render = function (a) {
  var b = this._internalRoot;
  if (null === b) throw Error(p(409));
  gl(a, b, null, null);
};
nl.prototype.unmount = ml.prototype.unmount = function () {
  var a = this._internalRoot;
  if (null !== a) {
    this._internalRoot = null;
    var b = a.containerInfo;
    Sk(function () {
      gl(null, a, null, null);
    });
    b[uf] = null;
  }
};
function nl(a) {
  this._internalRoot = a;
}
nl.prototype.unstable_scheduleHydration = function (a) {
  if (a) {
    var b = Hc();
    a = {
      blockedOn: null,
      target: a,
      priority: b
    };
    for (var c = 0; c < Qc.length && 0 !== b && b < Qc[c].priority; c++);
    Qc.splice(c, 0, a);
    0 === c && Vc(a);
  }
};
function ol(a) {
  return !(!a || 1 !== a.nodeType && 9 !== a.nodeType && 11 !== a.nodeType);
}
function pl(a) {
  return !(!a || 1 !== a.nodeType && 9 !== a.nodeType && 11 !== a.nodeType && (8 !== a.nodeType || " react-mount-point-unstable " !== a.nodeValue));
}
function ql() {}
function rl(a, b, c, d, e) {
  if (e) {
    if ("function" === typeof d) {
      var f = d;
      d = function d() {
        var a = hl(g);
        f.call(a);
      };
    }
    var g = fl(b, d, a, 0, null, !1, !1, "", ql);
    a._reactRootContainer = g;
    a[uf] = g.current;
    sf(8 === a.nodeType ? a.parentNode : a);
    Sk();
    return g;
  }
  for (; e = a.lastChild;) a.removeChild(e);
  if ("function" === typeof d) {
    var h = d;
    d = function d() {
      var a = hl(k);
      h.call(a);
    };
  }
  var k = cl(a, 0, !1, null, null, !1, !1, "", ql);
  a._reactRootContainer = k;
  a[uf] = k.current;
  sf(8 === a.nodeType ? a.parentNode : a);
  Sk(function () {
    gl(b, k, c, d);
  });
  return k;
}
function sl(a, b, c, d, e) {
  var f = c._reactRootContainer;
  if (f) {
    var g = f;
    if ("function" === typeof e) {
      var h = e;
      e = function e() {
        var a = hl(g);
        h.call(a);
      };
    }
    gl(b, g, a, e);
  } else g = rl(c, b, a, e, d);
  return hl(g);
}
Ec = function Ec(a) {
  switch (a.tag) {
    case 3:
      var b = a.stateNode;
      if (b.current.memoizedState.isDehydrated) {
        var c = tc(b.pendingLanes);
        0 !== c && (Cc(b, c | 1), Ek(b, B()), 0 === (K & 6) && (Hj = B() + 500, jg()));
      }
      break;
    case 13:
      Sk(function () {
        var b = Zg(a, 1);
        if (null !== b) {
          var c = L();
          mh(b, a, 1, c);
        }
      }), jl(a, 1);
  }
};
Fc = function Fc(a) {
  if (13 === a.tag) {
    var b = Zg(a, 134217728);
    if (null !== b) {
      var c = L();
      mh(b, a, 134217728, c);
    }
    jl(a, 134217728);
  }
};
Gc = function Gc(a) {
  if (13 === a.tag) {
    var b = lh(a),
      c = Zg(a, b);
    if (null !== c) {
      var d = L();
      mh(c, a, b, d);
    }
    jl(a, b);
  }
};
Hc = function Hc() {
  return C;
};
Ic = function Ic(a, b) {
  var c = C;
  try {
    return C = a, b();
  } finally {
    C = c;
  }
};
yb = function yb(a, b, c) {
  switch (b) {
    case "input":
      bb(a, c);
      b = c.name;
      if ("radio" === c.type && null != b) {
        for (c = a; c.parentNode;) c = c.parentNode;
        c = c.querySelectorAll("input[name=" + JSON.stringify("" + b) + '][type="radio"]');
        for (b = 0; b < c.length; b++) {
          var d = c[b];
          if (d !== a && d.form === a.form) {
            var e = Db(d);
            if (!e) throw Error(p(90));
            Wa(d);
            bb(d, e);
          }
        }
      }
      break;
    case "textarea":
      ib(a, c);
      break;
    case "select":
      b = c.value, null != b && fb(a, !!c.multiple, b, !1);
  }
};
Gb = Rk;
Hb = Sk;
var tl = {
    usingClientEntryPoint: !1,
    Events: [Cb, ue, Db, Eb, Fb, Rk]
  },
  ul = {
    findFiberByHostInstance: Wc,
    bundleType: 0,
    version: "18.2.0",
    rendererPackageName: "react-dom"
  };
var vl = {
  bundleType: ul.bundleType,
  version: ul.version,
  rendererPackageName: ul.rendererPackageName,
  rendererConfig: ul.rendererConfig,
  overrideHookState: null,
  overrideHookStateDeletePath: null,
  overrideHookStateRenamePath: null,
  overrideProps: null,
  overridePropsDeletePath: null,
  overridePropsRenamePath: null,
  setErrorHandler: null,
  setSuspenseHandler: null,
  scheduleUpdate: null,
  currentDispatcherRef: ua.ReactCurrentDispatcher,
  findHostInstanceByFiber: function findHostInstanceByFiber(a) {
    a = Zb(a);
    return null === a ? null : a.stateNode;
  },
  findFiberByHostInstance: ul.findFiberByHostInstance || kl,
  findHostInstancesForRefresh: null,
  scheduleRefresh: null,
  scheduleRoot: null,
  setRefreshHandler: null,
  getCurrentFiber: null,
  reconcilerVersion: "18.2.0-next-9e3b772b8-20220608"
};
if ("undefined" !== typeof __REACT_DEVTOOLS_GLOBAL_HOOK__) {
  var wl = __REACT_DEVTOOLS_GLOBAL_HOOK__;
  if (!wl.isDisabled && wl.supportsFiber) try {
    kc = wl.inject(vl), lc = wl;
  } catch (a) {}
}
exports.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = tl;
exports.createPortal = function (a, b) {
  var c = 2 < arguments.length && void 0 !== arguments[2] ? arguments[2] : null;
  if (!ol(b)) throw Error(p(200));
  return dl(a, b, null, c);
};
exports.createRoot = function (a, b) {
  if (!ol(a)) throw Error(p(299));
  var c = !1,
    d = "",
    e = ll;
  null !== b && void 0 !== b && (!0 === b.unstable_strictMode && (c = !0), void 0 !== b.identifierPrefix && (d = b.identifierPrefix), void 0 !== b.onRecoverableError && (e = b.onRecoverableError));
  b = cl(a, 1, !1, null, null, c, !1, d, e);
  a[uf] = b.current;
  sf(8 === a.nodeType ? a.parentNode : a);
  return new ml(b);
};
exports.findDOMNode = function (a) {
  if (null == a) return null;
  if (1 === a.nodeType) return a;
  var b = a._reactInternals;
  if (void 0 === b) {
    if ("function" === typeof a.render) throw Error(p(188));
    a = Object.keys(a).join(",");
    throw Error(p(268, a));
  }
  a = Zb(b);
  a = null === a ? null : a.stateNode;
  return a;
};
exports.flushSync = function (a) {
  return Sk(a);
};
exports.hydrate = function (a, b, c) {
  if (!pl(b)) throw Error(p(200));
  return sl(null, a, b, !0, c);
};
exports.hydrateRoot = function (a, b, c) {
  if (!ol(a)) throw Error(p(405));
  var d = null != c && c.hydratedSources || null,
    e = !1,
    f = "",
    g = ll;
  null !== c && void 0 !== c && (!0 === c.unstable_strictMode && (e = !0), void 0 !== c.identifierPrefix && (f = c.identifierPrefix), void 0 !== c.onRecoverableError && (g = c.onRecoverableError));
  b = fl(b, null, a, 1, null != c ? c : null, e, !1, f, g);
  a[uf] = b.current;
  sf(a);
  if (d) for (a = 0; a < d.length; a++) c = d[a], e = c._getVersion, e = e(c._source), null == b.mutableSourceEagerHydrationData ? b.mutableSourceEagerHydrationData = [c, e] : b.mutableSourceEagerHydrationData.push(c, e);
  return new nl(b);
};
exports.render = function (a, b, c) {
  if (!pl(b)) throw Error(p(200));
  return sl(null, a, b, !1, c);
};
exports.unmountComponentAtNode = function (a) {
  if (!pl(a)) throw Error(p(40));
  return a._reactRootContainer ? (Sk(function () {
    sl(null, null, a, !1, function () {
      a._reactRootContainer = null;
      a[uf] = null;
    });
  }), !0) : !1;
};
exports.unstable_batchedUpdates = Rk;
exports.unstable_renderSubtreeIntoContainer = function (a, b, c, d) {
  if (!pl(c)) throw Error(p(200));
  if (null == a || void 0 === a._reactInternals) throw Error(p(38));
  return sl(a, b, c, !1, d);
};
exports.version = "18.2.0-next-9e3b772b8-20220608";

/***/ }),

/***/ 545:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var m = __webpack_require__(1162);
if (true) {
  exports.createRoot = m.createRoot;
  exports.hydrateRoot = m.hydrateRoot;
} else { var i; }

/***/ }),

/***/ 1162:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


function checkDCE() {
  /* global __REACT_DEVTOOLS_GLOBAL_HOOK__ */
  if (typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ === 'undefined' || typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE !== 'function') {
    return;
  }
  if (false) {}
  try {
    // Verify that the code above has been dead code eliminated (DCE'd).
    __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(checkDCE);
  } catch (err) {
    // DevTools shouldn't crash React, no matter what.
    // We should still report in case we break this code.
    console.error(err);
  }
}
if (true) {
  // DCE check should happen before ReactDOM bundle executes so that
  // DevTools can report bad minification during injection.
  checkDCE();
  module.exports = __webpack_require__(5478);
} else {}

/***/ }),

/***/ 1672:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, _typeof(obj);
}
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "DraggableCore", ({
  enumerable: true,
  get: function get() {
    return _DraggableCore.default;
  }
}));
exports["default"] = void 0;
var React = _interopRequireWildcard(__webpack_require__(9512));
var _propTypes = _interopRequireDefault(__webpack_require__(1226));
var _reactDom = _interopRequireDefault(__webpack_require__(1162));
var _clsx2 = _interopRequireDefault(__webpack_require__(1569));
var _domFns = __webpack_require__(2156);
var _positionFns = __webpack_require__(4336);
var _shims = __webpack_require__(6776);
var _DraggableCore = _interopRequireDefault(__webpack_require__(8334));
var _log = _interopRequireDefault(__webpack_require__(6992));
var _excluded = ["axis", "bounds", "children", "defaultPosition", "defaultClassName", "defaultClassNameDragging", "defaultClassNameDragged", "position", "positionOffset", "scale"];
function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    default: obj
  };
}
function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}
function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }
  if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
    return {
      default: obj
    };
  }
  var cache = _getRequireWildcardCache(nodeInterop);
  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }
  var newObj = {};
  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }
  newObj.default = obj;
  if (cache) {
    cache.set(obj, newObj);
  }
  return newObj;
}
function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose(source, excluded);
  var key, i;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) {
    arr2[i] = arr[i];
  }
  return arr2;
}
function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];
  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;
  var _s, _e;
  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);
      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }
  return _arr;
}
function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  Object.defineProperty(subClass, "prototype", {
    writable: false
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived),
      result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  } else if (call !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }
  return _assertThisInitialized(self);
}
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self;
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

//
// Define <Draggable>
//
var Draggable = /*#__PURE__*/function (_React$Component) {
  _inherits(Draggable, _React$Component);
  var _super = _createSuper(Draggable);
  function Draggable(props
  /*: DraggableProps*/) {
    var _this;
    _classCallCheck(this, Draggable);
    _this = _super.call(this, props);
    _defineProperty(_assertThisInitialized(_this), "onDragStart", function (e, coreData) {
      (0, _log.default)('Draggable: onDragStart: %j', coreData); // Short-circuit if user's callback killed it.

      var shouldStart = _this.props.onStart(e, (0, _positionFns.createDraggableData)(_assertThisInitialized(_this), coreData)); // Kills start event on core as well, so move handlers are never bound.

      if (shouldStart === false) return false;
      _this.setState({
        dragging: true,
        dragged: true
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onDrag", function (e, coreData) {
      if (!_this.state.dragging) return false;
      (0, _log.default)('Draggable: onDrag: %j', coreData);
      var uiData = (0, _positionFns.createDraggableData)(_assertThisInitialized(_this), coreData);
      var newState
      /*: $Shape<DraggableState>*/ = {
        x: uiData.x,
        y: uiData.y
      }; // Keep within bounds.

      if (_this.props.bounds) {
        // Save original x and y.
        var x = newState.x,
          y = newState.y; // Add slack to the values used to calculate bound position. This will ensure that if
        // we start removing slack, the element won't react to it right away until it's been
        // completely removed.

        newState.x += _this.state.slackX;
        newState.y += _this.state.slackY; // Get bound position. This will ceil/floor the x and y within the boundaries.

        var _getBoundPosition = (0, _positionFns.getBoundPosition)(_assertThisInitialized(_this), newState.x, newState.y),
          _getBoundPosition2 = _slicedToArray(_getBoundPosition, 2),
          newStateX = _getBoundPosition2[0],
          newStateY = _getBoundPosition2[1];
        newState.x = newStateX;
        newState.y = newStateY; // Recalculate slack by noting how much was shaved by the boundPosition handler.

        newState.slackX = _this.state.slackX + (x - newState.x);
        newState.slackY = _this.state.slackY + (y - newState.y); // Update the event we fire to reflect what really happened after bounds took effect.

        uiData.x = newState.x;
        uiData.y = newState.y;
        uiData.deltaX = newState.x - _this.state.x;
        uiData.deltaY = newState.y - _this.state.y;
      } // Short-circuit if user's callback killed it.

      var shouldUpdate = _this.props.onDrag(e, uiData);
      if (shouldUpdate === false) return false;
      _this.setState(newState);
    });
    _defineProperty(_assertThisInitialized(_this), "onDragStop", function (e, coreData) {
      if (!_this.state.dragging) return false; // Short-circuit if user's callback killed it.

      var shouldContinue = _this.props.onStop(e, (0, _positionFns.createDraggableData)(_assertThisInitialized(_this), coreData));
      if (shouldContinue === false) return false;
      (0, _log.default)('Draggable: onDragStop: %j', coreData);
      var newState
      /*: $Shape<DraggableState>*/ = {
        dragging: false,
        slackX: 0,
        slackY: 0
      }; // If this is a controlled component, the result of this operation will be to
      // revert back to the old position. We expect a handler on `onDragStop`, at the least.

      var controlled = Boolean(_this.props.position);
      if (controlled) {
        var _this$props$position = _this.props.position,
          x = _this$props$position.x,
          y = _this$props$position.y;
        newState.x = x;
        newState.y = y;
      }
      _this.setState(newState);
    });
    _this.state = {
      // Whether or not we are currently dragging.
      dragging: false,
      // Whether or not we have been dragged before.
      dragged: false,
      // Current transform x and y.
      x: props.position ? props.position.x : props.defaultPosition.x,
      y: props.position ? props.position.y : props.defaultPosition.y,
      prevPropsPosition: _objectSpread({}, props.position),
      // Used for compensating for out-of-bounds drags
      slackX: 0,
      slackY: 0,
      // Can only determine if SVG after mounting
      isElementSVG: false
    };
    if (props.position && !(props.onDrag || props.onStop)) {
      // eslint-disable-next-line no-console
      console.warn('A `position` was applied to this <Draggable>, without drag handlers. This will make this ' + 'component effectively undraggable. Please attach `onDrag` or `onStop` handlers so you can adjust the ' + '`position` of this element.');
    }
    return _this;
  }
  _createClass(Draggable, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      // Check to see if the element passed is an instanceof SVGElement
      if (typeof window.SVGElement !== 'undefined' && this.findDOMNode() instanceof window.SVGElement) {
        this.setState({
          isElementSVG: true
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.setState({
        dragging: false
      }); // prevents invariant if unmounted while dragging
    } // React Strict Mode compatibility: if `nodeRef` is passed, we will use it instead of trying to find
    // the underlying DOM node ourselves. See the README for more information.
  }, {
    key: "findDOMNode",
    value: function findDOMNode() /*: ?HTMLElement*/
    {
      var _this$props$nodeRef$c, _this$props, _this$props$nodeRef;
      return (_this$props$nodeRef$c = (_this$props = this.props) === null || _this$props === void 0 ? void 0 : (_this$props$nodeRef = _this$props.nodeRef) === null || _this$props$nodeRef === void 0 ? void 0 : _this$props$nodeRef.current) !== null && _this$props$nodeRef$c !== void 0 ? _this$props$nodeRef$c : _reactDom.default.findDOMNode(this);
    }
  }, {
    key: "render",
    value: function render() /*: ReactElement<any>*/
    {
      var _clsx;
      var _this$props2 = this.props,
        axis = _this$props2.axis,
        bounds = _this$props2.bounds,
        children = _this$props2.children,
        defaultPosition = _this$props2.defaultPosition,
        defaultClassName = _this$props2.defaultClassName,
        defaultClassNameDragging = _this$props2.defaultClassNameDragging,
        defaultClassNameDragged = _this$props2.defaultClassNameDragged,
        position = _this$props2.position,
        positionOffset = _this$props2.positionOffset,
        scale = _this$props2.scale,
        draggableCoreProps = _objectWithoutProperties(_this$props2, _excluded);
      var style = {};
      var svgTransform = null; // If this is controlled, we don't want to move it - unless it's dragging.

      var controlled = Boolean(position);
      var draggable = !controlled || this.state.dragging;
      var validPosition = position || defaultPosition;
      var transformOpts = {
        // Set left if horizontal drag is enabled
        x: (0, _positionFns.canDragX)(this) && draggable ? this.state.x : validPosition.x,
        // Set top if vertical drag is enabled
        y: (0, _positionFns.canDragY)(this) && draggable ? this.state.y : validPosition.y
      }; // If this element was SVG, we use the `transform` attribute.

      if (this.state.isElementSVG) {
        svgTransform = (0, _domFns.createSVGTransform)(transformOpts, positionOffset);
      } else {
        // Add a CSS transform to move the element around. This allows us to move the element around
        // without worrying about whether or not it is relatively or absolutely positioned.
        // If the item you are dragging already has a transform set, wrap it in a <span> so <Draggable>
        // has a clean slate.
        style = (0, _domFns.createCSSTransform)(transformOpts, positionOffset);
      } // Mark with class while dragging

      var className = (0, _clsx2.default)(children.props.className || '', defaultClassName, (_clsx = {}, _defineProperty(_clsx, defaultClassNameDragging, this.state.dragging), _defineProperty(_clsx, defaultClassNameDragged, this.state.dragged), _clsx)); // Reuse the child provided
      // This makes it flexible to use whatever element is wanted (div, ul, etc)

      return /*#__PURE__*/React.createElement(_DraggableCore.default, _extends({}, draggableCoreProps, {
        onStart: this.onDragStart,
        onDrag: this.onDrag,
        onStop: this.onDragStop
      }), /*#__PURE__*/React.cloneElement(React.Children.only(children), {
        className: className,
        style: _objectSpread(_objectSpread({}, children.props.style), style),
        transform: svgTransform
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value:
    // React 16.3+
    // Arity (props, state)
    function getDerivedStateFromProps(_ref, _ref2) /*: ?$Shape<DraggableState>*/
    {
      var position = _ref.position;
      var prevPropsPosition = _ref2.prevPropsPosition;

      // Set x/y if a new position is provided in props that is different than the previous.
      if (position && (!prevPropsPosition || position.x !== prevPropsPosition.x || position.y !== prevPropsPosition.y)) {
        (0, _log.default)('Draggable: getDerivedStateFromProps %j', {
          position: position,
          prevPropsPosition: prevPropsPosition
        });
        return {
          x: position.x,
          y: position.y,
          prevPropsPosition: _objectSpread({}, position)
        };
      }
      return null;
    }
  }]);
  return Draggable;
}(React.Component);
exports["default"] = Draggable;
_defineProperty(Draggable, "displayName", 'Draggable');
_defineProperty(Draggable, "propTypes", _objectSpread(_objectSpread({}, _DraggableCore.default.propTypes), {}, {
  /**
   * `axis` determines which axis the draggable can move.
   *
   *  Note that all callbacks will still return data as normal. This only
   *  controls flushing to the DOM.
   *
   * 'both' allows movement horizontally and vertically.
   * 'x' limits movement to horizontal axis.
   * 'y' limits movement to vertical axis.
   * 'none' limits all movement.
   *
   * Defaults to 'both'.
   */
  axis: _propTypes.default.oneOf(['both', 'x', 'y', 'none']),
  /**
   * `bounds` determines the range of movement available to the element.
   * Available values are:
   *
   * 'parent' restricts movement within the Draggable's parent node.
   *
   * Alternatively, pass an object with the following properties, all of which are optional:
   *
   * {left: LEFT_BOUND, right: RIGHT_BOUND, bottom: BOTTOM_BOUND, top: TOP_BOUND}
   *
   * All values are in px.
   *
   * Example:
   *
   * ```jsx
   *   let App = React.createClass({
   *       render: function () {
   *         return (
   *            <Draggable bounds={{right: 300, bottom: 300}}>
   *              <div>Content</div>
   *           </Draggable>
   *         );
   *       }
   *   });
   * ```
   */
  bounds: _propTypes.default.oneOfType([_propTypes.default.shape({
    left: _propTypes.default.number,
    right: _propTypes.default.number,
    top: _propTypes.default.number,
    bottom: _propTypes.default.number
  }), _propTypes.default.string, _propTypes.default.oneOf([false])]),
  defaultClassName: _propTypes.default.string,
  defaultClassNameDragging: _propTypes.default.string,
  defaultClassNameDragged: _propTypes.default.string,
  /**
   * `defaultPosition` specifies the x and y that the dragged item should start at
   *
   * Example:
   *
   * ```jsx
   *      let App = React.createClass({
   *          render: function () {
   *              return (
   *                  <Draggable defaultPosition={{x: 25, y: 25}}>
   *                      <div>I start with transformX: 25px and transformY: 25px;</div>
   *                  </Draggable>
   *              );
   *          }
   *      });
   * ```
   */
  defaultPosition: _propTypes.default.shape({
    x: _propTypes.default.number,
    y: _propTypes.default.number
  }),
  positionOffset: _propTypes.default.shape({
    x: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    y: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string])
  }),
  /**
   * `position`, if present, defines the current position of the element.
   *
   *  This is similar to how form elements in React work - if no `position` is supplied, the component
   *  is uncontrolled.
   *
   * Example:
   *
   * ```jsx
   *      let App = React.createClass({
   *          render: function () {
   *              return (
   *                  <Draggable position={{x: 25, y: 25}}>
   *                      <div>I start with transformX: 25px and transformY: 25px;</div>
   *                  </Draggable>
   *              );
   *          }
   *      });
   * ```
   */
  position: _propTypes.default.shape({
    x: _propTypes.default.number,
    y: _propTypes.default.number
  }),
  /**
   * These properties should be defined on the child, not here.
   */
  className: _shims.dontSetMe,
  style: _shims.dontSetMe,
  transform: _shims.dontSetMe
}));
_defineProperty(Draggable, "defaultProps", _objectSpread(_objectSpread({}, _DraggableCore.default.defaultProps), {}, {
  axis: 'both',
  bounds: false,
  defaultClassName: 'react-draggable',
  defaultClassNameDragging: 'react-draggable-dragging',
  defaultClassNameDragged: 'react-draggable-dragged',
  defaultPosition: {
    x: 0,
    y: 0
  },
  scale: 1
}));

/***/ }),

/***/ 8334:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, _typeof(obj);
}
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var React = _interopRequireWildcard(__webpack_require__(9512));
var _propTypes = _interopRequireDefault(__webpack_require__(1226));
var _reactDom = _interopRequireDefault(__webpack_require__(1162));
var _domFns = __webpack_require__(2156);
var _positionFns = __webpack_require__(4336);
var _shims = __webpack_require__(6776);
var _log = _interopRequireDefault(__webpack_require__(6992));
function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    default: obj
  };
}
function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}
function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }
  if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
    return {
      default: obj
    };
  }
  var cache = _getRequireWildcardCache(nodeInterop);
  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }
  var newObj = {};
  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }
  newObj.default = obj;
  if (cache) {
    cache.set(obj, newObj);
  }
  return newObj;
}
function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) {
    arr2[i] = arr[i];
  }
  return arr2;
}
function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];
  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;
  var _s, _e;
  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);
      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }
  return _arr;
}
function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  Object.defineProperty(subClass, "prototype", {
    writable: false
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived),
      result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  } else if (call !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }
  return _assertThisInitialized(self);
}
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self;
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

// Simple abstraction for dragging events names.
var eventsFor = {
  touch: {
    start: 'touchstart',
    move: 'touchmove',
    stop: 'touchend'
  },
  mouse: {
    start: 'mousedown',
    move: 'mousemove',
    stop: 'mouseup'
  }
}; // Default to mouse events.

var dragEventFor = eventsFor.mouse;
/*:: type DraggableCoreState = {
  dragging: boolean,
  lastX: number,
  lastY: number,
  touchIdentifier: ?number
};*/

/*:: export type DraggableData = {
  node: HTMLElement,
  x: number, y: number,
  deltaX: number, deltaY: number,
  lastX: number, lastY: number,
};*/

/*:: export type DraggableEventHandler = (e: MouseEvent, data: DraggableData) => void | false;*/

/*:: export type ControlPosition = {x: number, y: number};*/

/*:: export type PositionOffsetControlPosition = {x: number|string, y: number|string};*/

/*:: export type DraggableCoreDefaultProps = {
  allowAnyClick: boolean,
  disabled: boolean,
  enableUserSelectHack: boolean,
  onStart: DraggableEventHandler,
  onDrag: DraggableEventHandler,
  onStop: DraggableEventHandler,
  onMouseDown: (e: MouseEvent) => void,
  scale: number,
};*/

/*:: export type DraggableCoreProps = {
  ...DraggableCoreDefaultProps,
  cancel: string,
  children: ReactElement<any>,
  offsetParent: HTMLElement,
  grid: [number, number],
  handle: string,
  nodeRef?: ?React.ElementRef<any>,
};*/

//
// Define <DraggableCore>.
//
// <DraggableCore> is for advanced usage of <Draggable>. It maintains minimal internal state so it can
// work well with libraries that require more control over the element.
//
var DraggableCore = /*#__PURE__*/function (_React$Component) {
  _inherits(DraggableCore, _React$Component);
  var _super = _createSuper(DraggableCore);
  function DraggableCore() {
    var _this;
    _classCallCheck(this, DraggableCore);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "state", {
      dragging: false,
      // Used while dragging to determine deltas.
      lastX: NaN,
      lastY: NaN,
      touchIdentifier: null
    });
    _defineProperty(_assertThisInitialized(_this), "mounted", false);
    _defineProperty(_assertThisInitialized(_this), "handleDragStart", function (e) {
      // Make it possible to attach event handlers on top of this one.
      _this.props.onMouseDown(e); // Only accept left-clicks.

      if (!_this.props.allowAnyClick && typeof e.button === 'number' && e.button !== 0) return false; // Get nodes. Be sure to grab relative document (could be iframed)

      var thisNode = _this.findDOMNode();
      if (!thisNode || !thisNode.ownerDocument || !thisNode.ownerDocument.body) {
        throw new Error('<DraggableCore> not mounted on DragStart!');
      }
      var ownerDocument = thisNode.ownerDocument; // Short circuit if handle or cancel prop was provided and selector doesn't match.

      if (_this.props.disabled || !(e.target instanceof ownerDocument.defaultView.Node) || _this.props.handle && !(0, _domFns.matchesSelectorAndParentsTo)(e.target, _this.props.handle, thisNode) || _this.props.cancel && (0, _domFns.matchesSelectorAndParentsTo)(e.target, _this.props.cancel, thisNode)) {
        return;
      } // Prevent scrolling on mobile devices, like ipad/iphone.
      // Important that this is after handle/cancel.

      if (e.type === 'touchstart') e.preventDefault(); // Set touch identifier in component state if this is a touch event. This allows us to
      // distinguish between individual touches on multitouch screens by identifying which
      // touchpoint was set to this element.

      var touchIdentifier = (0, _domFns.getTouchIdentifier)(e);
      _this.setState({
        touchIdentifier: touchIdentifier
      }); // Get the current drag point from the event. This is used as the offset.

      var position = (0, _positionFns.getControlPosition)(e, touchIdentifier, _assertThisInitialized(_this));
      if (position == null) return; // not possible but satisfies flow

      var x = position.x,
        y = position.y; // Create an event object with all the data parents need to make a decision here.

      var coreEvent = (0, _positionFns.createCoreData)(_assertThisInitialized(_this), x, y);
      (0, _log.default)('DraggableCore: handleDragStart: %j', coreEvent); // Call event handler. If it returns explicit false, cancel.

      (0, _log.default)('calling', _this.props.onStart);
      var shouldUpdate = _this.props.onStart(e, coreEvent);
      if (shouldUpdate === false || _this.mounted === false) return; // Add a style to the body to disable user-select. This prevents text from
      // being selected all over the page.

      if (_this.props.enableUserSelectHack) (0, _domFns.addUserSelectStyles)(ownerDocument); // Initiate dragging. Set the current x and y as offsets
      // so we know how much we've moved during the drag. This allows us
      // to drag elements around even if they have been moved, without issue.

      _this.setState({
        dragging: true,
        lastX: x,
        lastY: y
      }); // Add events to the document directly so we catch when the user's mouse/touch moves outside of
      // this element. We use different events depending on whether or not we have detected that this
      // is a touch-capable device.

      (0, _domFns.addEvent)(ownerDocument, dragEventFor.move, _this.handleDrag);
      (0, _domFns.addEvent)(ownerDocument, dragEventFor.stop, _this.handleDragStop);
    });
    _defineProperty(_assertThisInitialized(_this), "handleDrag", function (e) {
      // Get the current drag point from the event. This is used as the offset.
      var position = (0, _positionFns.getControlPosition)(e, _this.state.touchIdentifier, _assertThisInitialized(_this));
      if (position == null) return;
      var x = position.x,
        y = position.y; // Snap to grid if prop has been provided

      if (Array.isArray(_this.props.grid)) {
        var deltaX = x - _this.state.lastX,
          deltaY = y - _this.state.lastY;
        var _snapToGrid = (0, _positionFns.snapToGrid)(_this.props.grid, deltaX, deltaY);
        var _snapToGrid2 = _slicedToArray(_snapToGrid, 2);
        deltaX = _snapToGrid2[0];
        deltaY = _snapToGrid2[1];
        if (!deltaX && !deltaY) return; // skip useless drag

        x = _this.state.lastX + deltaX, y = _this.state.lastY + deltaY;
      }
      var coreEvent = (0, _positionFns.createCoreData)(_assertThisInitialized(_this), x, y);
      (0, _log.default)('DraggableCore: handleDrag: %j', coreEvent); // Call event handler. If it returns explicit false, trigger end.

      var shouldUpdate = _this.props.onDrag(e, coreEvent);
      if (shouldUpdate === false || _this.mounted === false) {
        try {
          // $FlowIgnore
          _this.handleDragStop(new MouseEvent('mouseup'));
        } catch (err) {
          // Old browsers
          var event = document.createEvent('MouseEvents')
          /*: any*/

          /*: MouseTouchEvent*/; // I see why this insanity was deprecated
          // $FlowIgnore

          event.initMouseEvent('mouseup', true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
          _this.handleDragStop(event);
        }
        return;
      }
      _this.setState({
        lastX: x,
        lastY: y
      });
    });
    _defineProperty(_assertThisInitialized(_this), "handleDragStop", function (e) {
      if (!_this.state.dragging) return;
      var position = (0, _positionFns.getControlPosition)(e, _this.state.touchIdentifier, _assertThisInitialized(_this));
      if (position == null) return;
      var x = position.x,
        y = position.y; // Snap to grid if prop has been provided

      if (Array.isArray(_this.props.grid)) {
        var deltaX = x - _this.state.lastX || 0;
        var deltaY = y - _this.state.lastY || 0;
        var _snapToGrid3 = (0, _positionFns.snapToGrid)(_this.props.grid, deltaX, deltaY);
        var _snapToGrid4 = _slicedToArray(_snapToGrid3, 2);
        deltaX = _snapToGrid4[0];
        deltaY = _snapToGrid4[1];
        x = _this.state.lastX + deltaX, y = _this.state.lastY + deltaY;
      }
      var coreEvent = (0, _positionFns.createCoreData)(_assertThisInitialized(_this), x, y); // Call event handler

      var shouldContinue = _this.props.onStop(e, coreEvent);
      if (shouldContinue === false || _this.mounted === false) return false;
      var thisNode = _this.findDOMNode();
      if (thisNode) {
        // Remove user-select hack
        if (_this.props.enableUserSelectHack) (0, _domFns.removeUserSelectStyles)(thisNode.ownerDocument);
      }
      (0, _log.default)('DraggableCore: handleDragStop: %j', coreEvent); // Reset the el.

      _this.setState({
        dragging: false,
        lastX: NaN,
        lastY: NaN
      });
      if (thisNode) {
        // Remove event handlers
        (0, _log.default)('DraggableCore: Removing handlers');
        (0, _domFns.removeEvent)(thisNode.ownerDocument, dragEventFor.move, _this.handleDrag);
        (0, _domFns.removeEvent)(thisNode.ownerDocument, dragEventFor.stop, _this.handleDragStop);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onMouseDown", function (e) {
      dragEventFor = eventsFor.mouse; // on touchscreen laptops we could switch back to mouse

      return _this.handleDragStart(e);
    });
    _defineProperty(_assertThisInitialized(_this), "onMouseUp", function (e) {
      dragEventFor = eventsFor.mouse;
      return _this.handleDragStop(e);
    });
    _defineProperty(_assertThisInitialized(_this), "onTouchStart", function (e) {
      // We're on a touch device now, so change the event handlers
      dragEventFor = eventsFor.touch;
      return _this.handleDragStart(e);
    });
    _defineProperty(_assertThisInitialized(_this), "onTouchEnd", function (e) {
      // We're on a touch device now, so change the event handlers
      dragEventFor = eventsFor.touch;
      return _this.handleDragStop(e);
    });
    return _this;
  }
  _createClass(DraggableCore, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.mounted = true; // Touch handlers must be added with {passive: false} to be cancelable.
      // https://developers.google.com/web/updates/2017/01/scrolling-intervention

      var thisNode = this.findDOMNode();
      if (thisNode) {
        (0, _domFns.addEvent)(thisNode, eventsFor.touch.start, this.onTouchStart, {
          passive: false
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.mounted = false; // Remove any leftover event handlers. Remove both touch and mouse handlers in case
      // some browser quirk caused a touch event to fire during a mouse move, or vice versa.

      var thisNode = this.findDOMNode();
      if (thisNode) {
        var ownerDocument = thisNode.ownerDocument;
        (0, _domFns.removeEvent)(ownerDocument, eventsFor.mouse.move, this.handleDrag);
        (0, _domFns.removeEvent)(ownerDocument, eventsFor.touch.move, this.handleDrag);
        (0, _domFns.removeEvent)(ownerDocument, eventsFor.mouse.stop, this.handleDragStop);
        (0, _domFns.removeEvent)(ownerDocument, eventsFor.touch.stop, this.handleDragStop);
        (0, _domFns.removeEvent)(thisNode, eventsFor.touch.start, this.onTouchStart, {
          passive: false
        });
        if (this.props.enableUserSelectHack) (0, _domFns.removeUserSelectStyles)(ownerDocument);
      }
    } // React Strict Mode compatibility: if `nodeRef` is passed, we will use it instead of trying to find
    // the underlying DOM node ourselves. See the README for more information.
  }, {
    key: "findDOMNode",
    value: function findDOMNode() /*: ?HTMLElement*/
    {
      var _this$props, _this$props2, _this$props2$nodeRef;
      return (_this$props = this.props) !== null && _this$props !== void 0 && _this$props.nodeRef ? (_this$props2 = this.props) === null || _this$props2 === void 0 ? void 0 : (_this$props2$nodeRef = _this$props2.nodeRef) === null || _this$props2$nodeRef === void 0 ? void 0 : _this$props2$nodeRef.current : _reactDom.default.findDOMNode(this);
    }
  }, {
    key: "render",
    value: function render() /*: React.Element<any>*/
    {
      // Reuse the child provided
      // This makes it flexible to use whatever element is wanted (div, ul, etc)
      return /*#__PURE__*/React.cloneElement(React.Children.only(this.props.children), {
        // Note: mouseMove handler is attached to document so it will still function
        // when the user drags quickly and leaves the bounds of the element.
        onMouseDown: this.onMouseDown,
        onMouseUp: this.onMouseUp,
        // onTouchStart is added on `componentDidMount` so they can be added with
        // {passive: false}, which allows it to cancel. See
        // https://developers.google.com/web/updates/2017/01/scrolling-intervention
        onTouchEnd: this.onTouchEnd
      });
    }
  }]);
  return DraggableCore;
}(React.Component);
exports["default"] = DraggableCore;
_defineProperty(DraggableCore, "displayName", 'DraggableCore');
_defineProperty(DraggableCore, "propTypes", {
  /**
   * `allowAnyClick` allows dragging using any mouse button.
   * By default, we only accept the left button.
   *
   * Defaults to `false`.
   */
  allowAnyClick: _propTypes.default.bool,
  /**
   * `disabled`, if true, stops the <Draggable> from dragging. All handlers,
   * with the exception of `onMouseDown`, will not fire.
   */
  disabled: _propTypes.default.bool,
  /**
   * By default, we add 'user-select:none' attributes to the document body
   * to prevent ugly text selection during drag. If this is causing problems
   * for your app, set this to `false`.
   */
  enableUserSelectHack: _propTypes.default.bool,
  /**
   * `offsetParent`, if set, uses the passed DOM node to compute drag offsets
   * instead of using the parent node.
   */
  offsetParent: function offsetParent(props
  /*: DraggableCoreProps*/, propName
  /*: $Keys<DraggableCoreProps>*/) {
    if (props[propName] && props[propName].nodeType !== 1) {
      throw new Error('Draggable\'s offsetParent must be a DOM Node.');
    }
  },
  /**
   * `grid` specifies the x and y that dragging should snap to.
   */
  grid: _propTypes.default.arrayOf(_propTypes.default.number),
  /**
   * `handle` specifies a selector to be used as the handle that initiates drag.
   *
   * Example:
   *
   * ```jsx
   *   let App = React.createClass({
   *       render: function () {
   *         return (
   *            <Draggable handle=".handle">
   *              <div>
   *                  <div className="handle">Click me to drag</div>
   *                  <div>This is some other content</div>
   *              </div>
   *           </Draggable>
   *         );
   *       }
   *   });
   * ```
   */
  handle: _propTypes.default.string,
  /**
   * `cancel` specifies a selector to be used to prevent drag initialization.
   *
   * Example:
   *
   * ```jsx
   *   let App = React.createClass({
   *       render: function () {
   *           return(
   *               <Draggable cancel=".cancel">
   *                   <div>
   *                     <div className="cancel">You can't drag from here</div>
   *                     <div>Dragging here works fine</div>
   *                   </div>
   *               </Draggable>
   *           );
   *       }
   *   });
   * ```
   */
  cancel: _propTypes.default.string,
  /* If running in React Strict mode, ReactDOM.findDOMNode() is deprecated.
   * Unfortunately, in order for <Draggable> to work properly, we need raw access
   * to the underlying DOM node. If you want to avoid the warning, pass a `nodeRef`
   * as in this example:
   *
   * function MyComponent() {
   *   const nodeRef = React.useRef(null);
   *   return (
   *     <Draggable nodeRef={nodeRef}>
   *       <div ref={nodeRef}>Example Target</div>
   *     </Draggable>
   *   );
   * }
   *
   * This can be used for arbitrarily nested components, so long as the ref ends up
   * pointing to the actual child DOM node and not a custom component.
   */
  nodeRef: _propTypes.default.object,
  /**
   * Called when dragging starts.
   * If this function returns the boolean false, dragging will be canceled.
   */
  onStart: _propTypes.default.func,
  /**
   * Called while dragging.
   * If this function returns the boolean false, dragging will be canceled.
   */
  onDrag: _propTypes.default.func,
  /**
   * Called when dragging stops.
   * If this function returns the boolean false, the drag will remain active.
   */
  onStop: _propTypes.default.func,
  /**
   * A workaround option which can be passed if onMouseDown needs to be accessed,
   * since it'll always be blocked (as there is internal use of onMouseDown)
   */
  onMouseDown: _propTypes.default.func,
  /**
   * `scale`, if set, applies scaling while dragging an element
   */
  scale: _propTypes.default.number,
  /**
   * These properties should be defined on the child, not here.
   */
  className: _shims.dontSetMe,
  style: _shims.dontSetMe,
  transform: _shims.dontSetMe
});
_defineProperty(DraggableCore, "defaultProps", {
  allowAnyClick: false,
  // by default only accept left click
  disabled: false,
  enableUserSelectHack: true,
  onStart: function onStart() {},
  onDrag: function onDrag() {},
  onStop: function onStop() {},
  onMouseDown: function onMouseDown() {},
  scale: 1
});

/***/ }),

/***/ 1710:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _require = __webpack_require__(1672),
  Draggable = _require.default,
  DraggableCore = _require.DraggableCore; // Previous versions of this lib exported <Draggable> as the root export. As to no-// them, or TypeScript, we export *both* as the root and as 'default'.
// See https://github.com/mzabriskie/react-draggable/pull/254
// and https://github.com/mzabriskie/react-draggable/issues/266

module.exports = Draggable;
module.exports["default"] = Draggable;
module.exports.DraggableCore = DraggableCore;

/***/ }),

/***/ 2156:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, _typeof(obj);
}
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.addClassName = addClassName;
exports.addEvent = addEvent;
exports.addUserSelectStyles = addUserSelectStyles;
exports.createCSSTransform = createCSSTransform;
exports.createSVGTransform = createSVGTransform;
exports.getTouch = getTouch;
exports.getTouchIdentifier = getTouchIdentifier;
exports.getTranslation = getTranslation;
exports.innerHeight = innerHeight;
exports.innerWidth = innerWidth;
exports.matchesSelector = matchesSelector;
exports.matchesSelectorAndParentsTo = matchesSelectorAndParentsTo;
exports.offsetXYFromParent = offsetXYFromParent;
exports.outerHeight = outerHeight;
exports.outerWidth = outerWidth;
exports.removeClassName = removeClassName;
exports.removeEvent = removeEvent;
exports.removeUserSelectStyles = removeUserSelectStyles;
var _shims = __webpack_require__(6776);
var _getPrefix = _interopRequireWildcard(__webpack_require__(8907));
function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}
function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }
  if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
    return {
      default: obj
    };
  }
  var cache = _getRequireWildcardCache(nodeInterop);
  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }
  var newObj = {};
  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }
  newObj.default = obj;
  if (cache) {
    cache.set(obj, newObj);
  }
  return newObj;
}
function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
var matchesSelectorFunc = '';
function matchesSelector(el
/*: Node*/, selector
/*: string*/) /*: boolean*/
{
  if (!matchesSelectorFunc) {
    matchesSelectorFunc = (0, _shims.findInArray)(['matches', 'webkitMatchesSelector', 'mozMatchesSelector', 'msMatchesSelector', 'oMatchesSelector'], function (method) {
      // $FlowIgnore: Doesn't think elements are indexable
      return (0, _shims.isFunction)(el[method]);
    });
  } // Might not be found entirely (not an Element?) - in that case, bail
  // $FlowIgnore: Doesn't think elements are indexable

  if (!(0, _shims.isFunction)(el[matchesSelectorFunc])) return false; // $FlowIgnore: Doesn't think elements are indexable

  return el[matchesSelectorFunc](selector);
} // Works up the tree to the draggable itself attempting to match selector.

function matchesSelectorAndParentsTo(el
/*: Node*/, selector
/*: string*/, baseNode
/*: Node*/) /*: boolean*/
{
  var node = el;
  do {
    if (matchesSelector(node, selector)) return true;
    if (node === baseNode) return false;
    node = node.parentNode;
  } while (node);
  return false;
}
function addEvent(el
/*: ?Node*/, event
/*: string*/, handler
/*: Function*/, inputOptions
/*: Object*/) /*: void*/
{
  if (!el) return;
  var options = _objectSpread({
    capture: true
  }, inputOptions); // $FlowIgnore[method-unbinding]

  if (el.addEventListener) {
    el.addEventListener(event, handler, options);
  } else if (el.attachEvent) {
    el.attachEvent('on' + event, handler);
  } else {
    // $FlowIgnore: Doesn't think elements are indexable
    el['on' + event] = handler;
  }
}
function removeEvent(el
/*: ?Node*/, event
/*: string*/, handler
/*: Function*/, inputOptions
/*: Object*/) /*: void*/
{
  if (!el) return;
  var options = _objectSpread({
    capture: true
  }, inputOptions); // $FlowIgnore[method-unbinding]

  if (el.removeEventListener) {
    el.removeEventListener(event, handler, options);
  } else if (el.detachEvent) {
    el.detachEvent('on' + event, handler);
  } else {
    // $FlowIgnore: Doesn't think elements are indexable
    el['on' + event] = null;
  }
}
function outerHeight(node
/*: HTMLElement*/) /*: number*/
{
  // This is deliberately excluding margin for our calculations, since we are using
  // offsetTop which is including margin. See getBoundPosition
  var height = node.clientHeight;
  var computedStyle = node.ownerDocument.defaultView.getComputedStyle(node);
  height += (0, _shims.int)(computedStyle.borderTopWidth);
  height += (0, _shims.int)(computedStyle.borderBottomWidth);
  return height;
}
function outerWidth(node
/*: HTMLElement*/) /*: number*/
{
  // This is deliberately excluding margin for our calculations, since we are using
  // offsetLeft which is including margin. See getBoundPosition
  var width = node.clientWidth;
  var computedStyle = node.ownerDocument.defaultView.getComputedStyle(node);
  width += (0, _shims.int)(computedStyle.borderLeftWidth);
  width += (0, _shims.int)(computedStyle.borderRightWidth);
  return width;
}
function innerHeight(node
/*: HTMLElement*/) /*: number*/
{
  var height = node.clientHeight;
  var computedStyle = node.ownerDocument.defaultView.getComputedStyle(node);
  height -= (0, _shims.int)(computedStyle.paddingTop);
  height -= (0, _shims.int)(computedStyle.paddingBottom);
  return height;
}
function innerWidth(node
/*: HTMLElement*/) /*: number*/
{
  var width = node.clientWidth;
  var computedStyle = node.ownerDocument.defaultView.getComputedStyle(node);
  width -= (0, _shims.int)(computedStyle.paddingLeft);
  width -= (0, _shims.int)(computedStyle.paddingRight);
  return width;
}
/*:: interface EventWithOffset {
  clientX: number, clientY: number
}*/

// Get from offsetParent
function offsetXYFromParent(evt
/*: EventWithOffset*/, offsetParent
/*: HTMLElement*/, scale
/*: number*/) /*: ControlPosition*/
{
  var isBody = offsetParent === offsetParent.ownerDocument.body;
  var offsetParentRect = isBody ? {
    left: 0,
    top: 0
  } : offsetParent.getBoundingClientRect();
  var x = (evt.clientX + offsetParent.scrollLeft - offsetParentRect.left) / scale;
  var y = (evt.clientY + offsetParent.scrollTop - offsetParentRect.top) / scale;
  return {
    x: x,
    y: y
  };
}
function createCSSTransform(controlPos
/*: ControlPosition*/, positionOffset
/*: PositionOffsetControlPosition*/) /*: Object*/
{
  var translation = getTranslation(controlPos, positionOffset, 'px');
  return _defineProperty({}, (0, _getPrefix.browserPrefixToKey)('transform', _getPrefix.default), translation);
}
function createSVGTransform(controlPos
/*: ControlPosition*/, positionOffset
/*: PositionOffsetControlPosition*/) /*: string*/
{
  var translation = getTranslation(controlPos, positionOffset, '');
  return translation;
}
function getTranslation(_ref2, positionOffset
/*: PositionOffsetControlPosition*/, unitSuffix
/*: string*/) /*: string*/
{
  var x = _ref2.x,
    y = _ref2.y;
  var translation = "translate(".concat(x).concat(unitSuffix, ",").concat(y).concat(unitSuffix, ")");
  if (positionOffset) {
    var defaultX = "".concat(typeof positionOffset.x === 'string' ? positionOffset.x : positionOffset.x + unitSuffix);
    var defaultY = "".concat(typeof positionOffset.y === 'string' ? positionOffset.y : positionOffset.y + unitSuffix);
    translation = "translate(".concat(defaultX, ", ").concat(defaultY, ")") + translation;
  }
  return translation;
}
function getTouch(e
/*: MouseTouchEvent*/, identifier
/*: number*/) /*: ?{clientX: number, clientY: number}*/
{
  return e.targetTouches && (0, _shims.findInArray)(e.targetTouches, function (t) {
    return identifier === t.identifier;
  }) || e.changedTouches && (0, _shims.findInArray)(e.changedTouches, function (t) {
    return identifier === t.identifier;
  });
}
function getTouchIdentifier(e
/*: MouseTouchEvent*/) /*: ?number*/
{
  if (e.targetTouches && e.targetTouches[0]) return e.targetTouches[0].identifier;
  if (e.changedTouches && e.changedTouches[0]) return e.changedTouches[0].identifier;
} // User-select Hacks:
//
// Useful for preventing blue highlights all over everything when dragging.
// Note we're passing `document` b/c we could be iframed

function addUserSelectStyles(doc
/*: ?Document*/) {
  if (!doc) return;
  var styleEl = doc.getElementById('react-draggable-style-el');
  if (!styleEl) {
    styleEl = doc.createElement('style');
    styleEl.type = 'text/css';
    styleEl.id = 'react-draggable-style-el';
    styleEl.innerHTML = '.react-draggable-transparent-selection *::-moz-selection {all: inherit;}\n';
    styleEl.innerHTML += '.react-draggable-transparent-selection *::selection {all: inherit;}\n';
    doc.getElementsByTagName('head')[0].appendChild(styleEl);
  }
  if (doc.body) addClassName(doc.body, 'react-draggable-transparent-selection');
}
function removeUserSelectStyles(doc
/*: ?Document*/) {
  if (!doc) return;
  try {
    if (doc.body) removeClassName(doc.body, 'react-draggable-transparent-selection'); // $FlowIgnore: IE

    if (doc.selection) {
      // $FlowIgnore: IE
      doc.selection.empty();
    } else {
      // Remove selection caused by scroll, unless it's a focused input
      // (we use doc.defaultView in case we're in an iframe)
      var selection = (doc.defaultView || window).getSelection();
      if (selection && selection.type !== 'Caret') {
        selection.removeAllRanges();
      }
    }
  } catch (e) {// probably IE
  }
}
function addClassName(el
/*: HTMLElement*/, className
/*: string*/) {
  if (el.classList) {
    el.classList.add(className);
  } else {
    if (!el.className.match(new RegExp("(?:^|\\s)".concat(className, "(?!\\S)")))) {
      el.className += " ".concat(className);
    }
  }
}
function removeClassName(el
/*: HTMLElement*/, className
/*: string*/) {
  if (el.classList) {
    el.classList.remove(className);
  } else {
    el.className = el.className.replace(new RegExp("(?:^|\\s)".concat(className, "(?!\\S)"), 'g'), '');
  }
}

/***/ }),

/***/ 8907:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.browserPrefixToKey = browserPrefixToKey;
exports.browserPrefixToStyle = browserPrefixToStyle;
exports["default"] = void 0;
exports.getPrefix = getPrefix;
var prefixes = ['Moz', 'Webkit', 'O', 'ms'];
function getPrefix() /*: string*/
{
  var _window$document, _window$document$docu;
  var prop
  /*: string*/ = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'transform';
  // Ensure we're running in an environment where there is actually a global
  // `window` obj
  if (typeof window === 'undefined') return ''; // If we're in a pseudo-browser server-side environment, this access
  // path may not exist, so bail out if it doesn't.

  var style = (_window$document = window.document) === null || _window$document === void 0 ? void 0 : (_window$document$docu = _window$document.documentElement) === null || _window$document$docu === void 0 ? void 0 : _window$document$docu.style;
  if (!style) return '';
  if (prop in style) return '';
  for (var i = 0; i < prefixes.length; i++) {
    if (browserPrefixToKey(prop, prefixes[i]) in style) return prefixes[i];
  }
  return '';
}
function browserPrefixToKey(prop
/*: string*/, prefix
/*: string*/) /*: string*/
{
  return prefix ? "".concat(prefix).concat(kebabToTitleCase(prop)) : prop;
}
function browserPrefixToStyle(prop
/*: string*/, prefix
/*: string*/) /*: string*/
{
  return prefix ? "-".concat(prefix.toLowerCase(), "-").concat(prop) : prop;
}
function kebabToTitleCase(str
/*: string*/) /*: string*/
{
  var out = '';
  var shouldCapitalize = true;
  for (var i = 0; i < str.length; i++) {
    if (shouldCapitalize) {
      out += str[i].toUpperCase();
      shouldCapitalize = false;
    } else if (str[i] === '-') {
      shouldCapitalize = true;
    } else {
      out += str[i];
    }
  }
  return out;
} // Default export is the prefix itself, like 'Moz', 'Webkit', etc
// Note that you may have to re-test for certain things; for instance, Chrome 50
// can handle unprefixed `transform`, but not unprefixed `user-select`

var _default = getPrefix()
/*: string*/;

exports["default"] = _default;

/***/ }),

/***/ 6992:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = log;

/*eslint no-console:0*/
function log() {
  var _console;
  if (false) {}
}

/***/ }),

/***/ 4336:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.canDragX = canDragX;
exports.canDragY = canDragY;
exports.createCoreData = createCoreData;
exports.createDraggableData = createDraggableData;
exports.getBoundPosition = getBoundPosition;
exports.getControlPosition = getControlPosition;
exports.snapToGrid = snapToGrid;
var _shims = __webpack_require__(6776);
var _domFns = __webpack_require__(2156);
function getBoundPosition(draggable
/*: Draggable*/, x
/*: number*/, y
/*: number*/) /*: [number, number]*/
{
  // If no bounds, short-circuit and move on
  if (!draggable.props.bounds) return [x, y]; // Clone new bounds

  var bounds = draggable.props.bounds;
  bounds = typeof bounds === 'string' ? bounds : cloneBounds(bounds);
  var node = findDOMNode(draggable);
  if (typeof bounds === 'string') {
    var ownerDocument = node.ownerDocument;
    var ownerWindow = ownerDocument.defaultView;
    var boundNode;
    if (bounds === 'parent') {
      boundNode = node.parentNode;
    } else {
      boundNode = ownerDocument.querySelector(bounds);
    }
    if (!(boundNode instanceof ownerWindow.HTMLElement)) {
      throw new Error('Bounds selector "' + bounds + '" could not find an element.');
    }
    var boundNodeEl
    /*: HTMLElement*/ = boundNode; // for Flow, can't seem to refine correctly

    var nodeStyle = ownerWindow.getComputedStyle(node);
    var boundNodeStyle = ownerWindow.getComputedStyle(boundNodeEl); // Compute bounds. This is a pain with padding and offsets but this gets it exactly right.

    bounds = {
      left: -node.offsetLeft + (0, _shims.int)(boundNodeStyle.paddingLeft) + (0, _shims.int)(nodeStyle.marginLeft),
      top: -node.offsetTop + (0, _shims.int)(boundNodeStyle.paddingTop) + (0, _shims.int)(nodeStyle.marginTop),
      right: (0, _domFns.innerWidth)(boundNodeEl) - (0, _domFns.outerWidth)(node) - node.offsetLeft + (0, _shims.int)(boundNodeStyle.paddingRight) - (0, _shims.int)(nodeStyle.marginRight),
      bottom: (0, _domFns.innerHeight)(boundNodeEl) - (0, _domFns.outerHeight)(node) - node.offsetTop + (0, _shims.int)(boundNodeStyle.paddingBottom) - (0, _shims.int)(nodeStyle.marginBottom)
    };
  } // Keep x and y below right and bottom limits...

  if ((0, _shims.isNum)(bounds.right)) x = Math.min(x, bounds.right);
  if ((0, _shims.isNum)(bounds.bottom)) y = Math.min(y, bounds.bottom); // But above left and top limits.

  if ((0, _shims.isNum)(bounds.left)) x = Math.max(x, bounds.left);
  if ((0, _shims.isNum)(bounds.top)) y = Math.max(y, bounds.top);
  return [x, y];
}
function snapToGrid(grid
/*: [number, number]*/, pendingX
/*: number*/, pendingY
/*: number*/) /*: [number, number]*/
{
  var x = Math.round(pendingX / grid[0]) * grid[0];
  var y = Math.round(pendingY / grid[1]) * grid[1];
  return [x, y];
}
function canDragX(draggable
/*: Draggable*/) /*: boolean*/
{
  return draggable.props.axis === 'both' || draggable.props.axis === 'x';
}
function canDragY(draggable
/*: Draggable*/) /*: boolean*/
{
  return draggable.props.axis === 'both' || draggable.props.axis === 'y';
} // Get {x, y} positions from event.

function getControlPosition(e
/*: MouseTouchEvent*/, touchIdentifier
/*: ?number*/, draggableCore
/*: DraggableCore*/) /*: ?ControlPosition*/
{
  var touchObj = typeof touchIdentifier === 'number' ? (0, _domFns.getTouch)(e, touchIdentifier) : null;
  if (typeof touchIdentifier === 'number' && !touchObj) return null; // not the right touch

  var node = findDOMNode(draggableCore); // User can provide an offsetParent if desired.

  var offsetParent = draggableCore.props.offsetParent || node.offsetParent || node.ownerDocument.body;
  return (0, _domFns.offsetXYFromParent)(touchObj || e, offsetParent, draggableCore.props.scale);
} // Create an data object exposed by <DraggableCore>'s events

function createCoreData(draggable
/*: DraggableCore*/, x
/*: number*/, y
/*: number*/) /*: DraggableData*/
{
  var state = draggable.state;
  var isStart = !(0, _shims.isNum)(state.lastX);
  var node = findDOMNode(draggable);
  if (isStart) {
    // If this is our first move, use the x and y as last coords.
    return {
      node: node,
      deltaX: 0,
      deltaY: 0,
      lastX: x,
      lastY: y,
      x: x,
      y: y
    };
  } else {
    // Otherwise calculate proper values.
    return {
      node: node,
      deltaX: x - state.lastX,
      deltaY: y - state.lastY,
      lastX: state.lastX,
      lastY: state.lastY,
      x: x,
      y: y
    };
  }
} // Create an data exposed by <Draggable>'s events

function createDraggableData(draggable
/*: Draggable*/, coreData
/*: DraggableData*/) /*: DraggableData*/
{
  var scale = draggable.props.scale;
  return {
    node: coreData.node,
    x: draggable.state.x + coreData.deltaX / scale,
    y: draggable.state.y + coreData.deltaY / scale,
    deltaX: coreData.deltaX / scale,
    deltaY: coreData.deltaY / scale,
    lastX: draggable.state.x,
    lastY: draggable.state.y
  };
} // A lot faster than stringify/parse

function cloneBounds(bounds
/*: Bounds*/) /*: Bounds*/
{
  return {
    left: bounds.left,
    top: bounds.top,
    right: bounds.right,
    bottom: bounds.bottom
  };
}
function findDOMNode(draggable
/*: Draggable | DraggableCore*/) /*: HTMLElement*/
{
  var node = draggable.findDOMNode();
  if (!node) {
    throw new Error('<DraggableCore>: Unmounted during event!');
  } // $FlowIgnore we can't assert on HTMLElement due to tests... FIXME

  return node;
}

/***/ }),

/***/ 6776:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.dontSetMe = dontSetMe;
exports.findInArray = findInArray;
exports.int = int;
exports.isFunction = isFunction;
exports.isNum = isNum;

// @credits https://gist.github.com/rogozhnikoff/a43cfed27c41e4e68cdc
function findInArray(array
/*: Array<any> | TouchList*/, callback
/*: Function*/) /*: any*/
{
  for (var i = 0, length = array.length; i < length; i++) {
    if (callback.apply(callback, [array[i], i, array])) return array[i];
  }
}
function isFunction(func
/*: any*/) /*: boolean %checks*/
{
  // $FlowIgnore[method-unbinding]
  return typeof func === 'function' || Object.prototype.toString.call(func) === '[object Function]';
}
function isNum(num
/*: any*/) /*: boolean %checks*/
{
  return typeof num === 'number' && !isNaN(num);
}
function int(a
/*: string*/) /*: number*/
{
  return parseInt(a, 10);
}
function dontSetMe(props
/*: Object*/, propName
/*: string*/, componentName
/*: string*/) /*: ?Error*/
{
  if (props[propName]) {
    return new Error("Invalid prop ".concat(propName, " passed to ").concat(componentName, " - do not set this, set it on the child."));
  }
}

/***/ }),

/***/ 8414:
/***/ (function(__unused_webpack_module, exports) {

"use strict";
/** @license React v16.13.1
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var b = "function" === typeof Symbol && Symbol.for,
  c = b ? Symbol.for("react.element") : 60103,
  d = b ? Symbol.for("react.portal") : 60106,
  e = b ? Symbol.for("react.fragment") : 60107,
  f = b ? Symbol.for("react.strict_mode") : 60108,
  g = b ? Symbol.for("react.profiler") : 60114,
  h = b ? Symbol.for("react.provider") : 60109,
  k = b ? Symbol.for("react.context") : 60110,
  l = b ? Symbol.for("react.async_mode") : 60111,
  m = b ? Symbol.for("react.concurrent_mode") : 60111,
  n = b ? Symbol.for("react.forward_ref") : 60112,
  p = b ? Symbol.for("react.suspense") : 60113,
  q = b ? Symbol.for("react.suspense_list") : 60120,
  r = b ? Symbol.for("react.memo") : 60115,
  t = b ? Symbol.for("react.lazy") : 60116,
  v = b ? Symbol.for("react.block") : 60121,
  w = b ? Symbol.for("react.fundamental") : 60117,
  x = b ? Symbol.for("react.responder") : 60118,
  y = b ? Symbol.for("react.scope") : 60119;
function z(a) {
  if ("object" === typeof a && null !== a) {
    var u = a.$$typeof;
    switch (u) {
      case c:
        switch (a = a.type, a) {
          case l:
          case m:
          case e:
          case g:
          case f:
          case p:
            return a;
          default:
            switch (a = a && a.$$typeof, a) {
              case k:
              case n:
              case t:
              case r:
              case h:
                return a;
              default:
                return u;
            }
        }
      case d:
        return u;
    }
  }
}
function A(a) {
  return z(a) === m;
}
exports.AsyncMode = l;
exports.ConcurrentMode = m;
exports.ContextConsumer = k;
exports.ContextProvider = h;
exports.Element = c;
exports.ForwardRef = n;
exports.Fragment = e;
exports.Lazy = t;
exports.Memo = r;
exports.Portal = d;
exports.Profiler = g;
exports.StrictMode = f;
exports.Suspense = p;
exports.isAsyncMode = function (a) {
  return A(a) || z(a) === l;
};
exports.isConcurrentMode = A;
exports.isContextConsumer = function (a) {
  return z(a) === k;
};
exports.isContextProvider = function (a) {
  return z(a) === h;
};
exports.isElement = function (a) {
  return "object" === typeof a && null !== a && a.$$typeof === c;
};
exports.isForwardRef = function (a) {
  return z(a) === n;
};
exports.isFragment = function (a) {
  return z(a) === e;
};
exports.isLazy = function (a) {
  return z(a) === t;
};
exports.isMemo = function (a) {
  return z(a) === r;
};
exports.isPortal = function (a) {
  return z(a) === d;
};
exports.isProfiler = function (a) {
  return z(a) === g;
};
exports.isStrictMode = function (a) {
  return z(a) === f;
};
exports.isSuspense = function (a) {
  return z(a) === p;
};
exports.isValidElementType = function (a) {
  return "string" === typeof a || "function" === typeof a || a === e || a === m || a === g || a === f || a === p || a === q || "object" === typeof a && null !== a && (a.$$typeof === t || a.$$typeof === r || a.$$typeof === h || a.$$typeof === k || a.$$typeof === n || a.$$typeof === w || a.$$typeof === x || a.$$typeof === y || a.$$typeof === v);
};
exports.typeOf = z;

/***/ }),

/***/ 4436:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


if (true) {
  module.exports = __webpack_require__(8414);
} else {}

/***/ }),

/***/ 130:
/***/ (function(__unused_webpack_module, exports) {

"use strict";
var __webpack_unused_export__;
/**
 * @license React
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */


var b = Symbol.for("react.element"),
  c = Symbol.for("react.portal"),
  d = Symbol.for("react.fragment"),
  e = Symbol.for("react.strict_mode"),
  f = Symbol.for("react.profiler"),
  g = Symbol.for("react.provider"),
  h = Symbol.for("react.context"),
  k = Symbol.for("react.server_context"),
  l = Symbol.for("react.forward_ref"),
  m = Symbol.for("react.suspense"),
  n = Symbol.for("react.suspense_list"),
  p = Symbol.for("react.memo"),
  q = Symbol.for("react.lazy"),
  t = Symbol.for("react.offscreen"),
  u;
u = Symbol.for("react.module.reference");
function v(a) {
  if ("object" === typeof a && null !== a) {
    var r = a.$$typeof;
    switch (r) {
      case b:
        switch (a = a.type, a) {
          case d:
          case f:
          case e:
          case m:
          case n:
            return a;
          default:
            switch (a = a && a.$$typeof, a) {
              case k:
              case h:
              case l:
              case q:
              case p:
              case g:
                return a;
              default:
                return r;
            }
        }
      case c:
        return r;
    }
  }
}
__webpack_unused_export__ = h;
__webpack_unused_export__ = g;
__webpack_unused_export__ = b;
__webpack_unused_export__ = l;
__webpack_unused_export__ = d;
__webpack_unused_export__ = q;
__webpack_unused_export__ = p;
__webpack_unused_export__ = c;
__webpack_unused_export__ = f;
__webpack_unused_export__ = e;
__webpack_unused_export__ = m;
__webpack_unused_export__ = n;
__webpack_unused_export__ = function () {
  return !1;
};
__webpack_unused_export__ = function () {
  return !1;
};
__webpack_unused_export__ = function (a) {
  return v(a) === h;
};
__webpack_unused_export__ = function (a) {
  return v(a) === g;
};
__webpack_unused_export__ = function (a) {
  return "object" === typeof a && null !== a && a.$$typeof === b;
};
__webpack_unused_export__ = function (a) {
  return v(a) === l;
};
__webpack_unused_export__ = function (a) {
  return v(a) === d;
};
__webpack_unused_export__ = function (a) {
  return v(a) === q;
};
__webpack_unused_export__ = function (a) {
  return v(a) === p;
};
__webpack_unused_export__ = function (a) {
  return v(a) === c;
};
__webpack_unused_export__ = function (a) {
  return v(a) === f;
};
__webpack_unused_export__ = function (a) {
  return v(a) === e;
};
__webpack_unused_export__ = function (a) {
  return v(a) === m;
};
__webpack_unused_export__ = function (a) {
  return v(a) === n;
};
exports.isValidElementType = function (a) {
  return "string" === typeof a || "function" === typeof a || a === d || a === f || a === e || a === m || a === n || a === t || "object" === typeof a && null !== a && (a.$$typeof === q || a.$$typeof === p || a.$$typeof === g || a.$$typeof === h || a.$$typeof === l || a.$$typeof === u || void 0 !== a.getModuleId) ? !0 : !1;
};
exports.typeOf = v;

/***/ }),

/***/ 9827:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


if (true) {
  module.exports = __webpack_require__(130);
} else {}

/***/ }),

/***/ 7939:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports["default"] = void 0;
var React = _interopRequireWildcard(__webpack_require__(9512));
var _reactDraggable = __webpack_require__(1710);
var _utils = __webpack_require__(7748);
var _propTypes = __webpack_require__(3691);
var _excluded = ["children", "className", "draggableOpts", "width", "height", "handle", "handleSize", "lockAspectRatio", "axis", "minConstraints", "maxConstraints", "onResize", "onResizeStop", "onResizeStart", "resizeHandles", "transformScale"];
function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}
function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }
  if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
    return {
      default: obj
    };
  }
  var cache = _getRequireWildcardCache(nodeInterop);
  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }
  var newObj = {};
  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }
  newObj.default = obj;
  if (cache) {
    cache.set(obj, newObj);
  }
  return newObj;
}
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
// The base <Resizable> component.
// This component does not have state and relies on the parent to set its props based on callback data.
var Resizable = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(Resizable, _React$Component);
  function Resizable() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.handleRefs = {};
    _this.lastHandleRect = null;
    _this.slack = null;
    return _this;
  }
  var _proto = Resizable.prototype;
  _proto.componentWillUnmount = function componentWillUnmount() {
    this.resetData();
  };
  _proto.resetData = function resetData() {
    this.lastHandleRect = this.slack = null;
  }

  // Clamp width and height within provided constraints
  ;

  _proto.runConstraints = function runConstraints(width, height) {
    var _this$props = this.props,
      minConstraints = _this$props.minConstraints,
      maxConstraints = _this$props.maxConstraints,
      lockAspectRatio = _this$props.lockAspectRatio;
    // short circuit
    if (!minConstraints && !maxConstraints && !lockAspectRatio) return [width, height];

    // If constraining to min and max, we need to also fit width and height to aspect ratio.
    if (lockAspectRatio) {
      var ratio = this.props.width / this.props.height;
      var deltaW = width - this.props.width;
      var deltaH = height - this.props.height;

      // Find which coordinate was greater and should push the other toward it.
      // E.g.:
      // ratio = 1, deltaW = 10, deltaH = 5, deltaH should become 10.
      // ratio = 2, deltaW = 10, deltaH = 6, deltaW should become 12.
      if (Math.abs(deltaW) > Math.abs(deltaH * ratio)) {
        height = width / ratio;
      } else {
        width = height * ratio;
      }
    }
    var oldW = width,
      oldH = height;

    // Add slack to the values used to calculate bound position. This will ensure that if
    // we start removing slack, the element won't react to it right away until it's been
    // completely removed.
    var _ref = this.slack || [0, 0],
      slackW = _ref[0],
      slackH = _ref[1];
    width += slackW;
    height += slackH;
    if (minConstraints) {
      width = Math.max(minConstraints[0], width);
      height = Math.max(minConstraints[1], height);
    }
    if (maxConstraints) {
      width = Math.min(maxConstraints[0], width);
      height = Math.min(maxConstraints[1], height);
    }

    // If the width or height changed, we must have introduced some slack. Record it for the next iteration.
    this.slack = [slackW + (oldW - width), slackH + (oldH - height)];
    return [width, height];
  }

  /**
   * Wrapper around drag events to provide more useful data.
   *
   * @param  {String} handlerName Handler name to wrap.
   * @return {Function}           Handler function.
   */;
  _proto.resizeHandler = function resizeHandler(handlerName, axis) {
    var _this2 = this;
    return function (e, _ref2) {
      var node = _ref2.node,
        deltaX = _ref2.deltaX,
        deltaY = _ref2.deltaY;
      // Reset data in case it was left over somehow (should not be possible)
      if (handlerName === 'onResizeStart') _this2.resetData();

      // Axis restrictions
      var canDragX = (_this2.props.axis === 'both' || _this2.props.axis === 'x') && axis !== 'n' && axis !== 's';
      var canDragY = (_this2.props.axis === 'both' || _this2.props.axis === 'y') && axis !== 'e' && axis !== 'w';
      // No dragging possible.
      if (!canDragX && !canDragY) return;

      // Decompose axis for later use
      var axisV = axis[0];
      var axisH = axis[axis.length - 1]; // intentionally not axis[1], so that this catches axis === 'w' for example

      // Track the element being dragged to account for changes in position.
      // If a handle's position is changed between callbacks, we need to factor this in to the next callback.
      // Failure to do so will cause the element to "skip" when resized upwards or leftwards.
      var handleRect = node.getBoundingClientRect();
      if (_this2.lastHandleRect != null) {
        // If the handle has repositioned on either axis since last render,
        // we need to increase our callback values by this much.
        // Only checking 'n', 'w' since resizing by 's', 'w' won't affect the overall position on page,
        if (axisH === 'w') {
          var deltaLeftSinceLast = handleRect.left - _this2.lastHandleRect.left;
          deltaX += deltaLeftSinceLast;
        }
        if (axisV === 'n') {
          var deltaTopSinceLast = handleRect.top - _this2.lastHandleRect.top;
          deltaY += deltaTopSinceLast;
        }
      }
      // Storage of last rect so we know how much it has really moved.
      _this2.lastHandleRect = handleRect;

      // Reverse delta if using top or left drag handles.
      if (axisH === 'w') deltaX = -deltaX;
      if (axisV === 'n') deltaY = -deltaY;

      // Update w/h by the deltas. Also factor in transformScale.
      var width = _this2.props.width + (canDragX ? deltaX / _this2.props.transformScale : 0);
      var height = _this2.props.height + (canDragY ? deltaY / _this2.props.transformScale : 0);

      // Run user-provided constraints.
      var _this2$runConstraints = _this2.runConstraints(width, height);
      width = _this2$runConstraints[0];
      height = _this2$runConstraints[1];
      var dimensionsChanged = width !== _this2.props.width || height !== _this2.props.height;

      // Call user-supplied callback if present.
      var cb = typeof _this2.props[handlerName] === 'function' ? _this2.props[handlerName] : null;
      // Don't call 'onResize' if dimensions haven't changed.
      var shouldSkipCb = handlerName === 'onResize' && !dimensionsChanged;
      if (cb && !shouldSkipCb) {
        e.persist == null ? void 0 : e.persist();
        cb(e, {
          node: node,
          size: {
            width: width,
            height: height
          },
          handle: axis
        });
      }

      // Reset internal data
      if (handlerName === 'onResizeStop') _this2.resetData();
    };
  }

  // Render a resize handle given an axis & DOM ref. Ref *must* be attached for
  // the underlying draggable library to work properly.
  ;

  _proto.renderResizeHandle = function renderResizeHandle(handleAxis, ref) {
    var handle = this.props.handle;
    // No handle provided, make the default
    if (!handle) {
      return /*#__PURE__*/React.createElement("span", {
        className: "react-resizable-handle react-resizable-handle-" + handleAxis,
        ref: ref
      });
    }
    // Handle is a function, such as:
    // `handle={(handleAxis) => <span className={...} />}`
    if (typeof handle === 'function') {
      return handle(handleAxis, ref);
    }
    // Handle is a React component (composite or DOM).
    var isDOMElement = typeof handle.type === 'string';
    var props = _objectSpread({
      ref: ref
    }, isDOMElement ? {} : {
      handleAxis: handleAxis
    });
    return /*#__PURE__*/React.cloneElement(handle, props);
  };
  _proto.render = function render() {
    var _this3 = this;
    // Pass along only props not meant for the `<Resizable>`.`
    // eslint-disable-next-line no-unused-vars
    var _this$props2 = this.props,
      children = _this$props2.children,
      className = _this$props2.className,
      draggableOpts = _this$props2.draggableOpts,
      width = _this$props2.width,
      height = _this$props2.height,
      handle = _this$props2.handle,
      handleSize = _this$props2.handleSize,
      lockAspectRatio = _this$props2.lockAspectRatio,
      axis = _this$props2.axis,
      minConstraints = _this$props2.minConstraints,
      maxConstraints = _this$props2.maxConstraints,
      onResize = _this$props2.onResize,
      onResizeStop = _this$props2.onResizeStop,
      onResizeStart = _this$props2.onResizeStart,
      resizeHandles = _this$props2.resizeHandles,
      transformScale = _this$props2.transformScale,
      p = _objectWithoutPropertiesLoose(_this$props2, _excluded);

    // What we're doing here is getting the child of this element, and cloning it with this element's props.
    // We are then defining its children as:
    // 1. Its original children (resizable's child's children), and
    // 2. One or more draggable handles.
    return (0, _utils.cloneElement)(children, _objectSpread(_objectSpread({}, p), {}, {
      className: (className ? className + " " : '') + "react-resizable",
      children: [].concat(children.props.children, resizeHandles.map(function (handleAxis) {
        var _this3$handleRefs$han;
        // Create a ref to the handle so that `<DraggableCore>` doesn't have to use ReactDOM.findDOMNode().
        var ref = (_this3$handleRefs$han = _this3.handleRefs[handleAxis]) != null ? _this3$handleRefs$han : _this3.handleRefs[handleAxis] = /*#__PURE__*/React.createRef();
        return /*#__PURE__*/React.createElement(_reactDraggable.DraggableCore, _extends({}, draggableOpts, {
          nodeRef: ref,
          key: "resizableHandle-" + handleAxis,
          onStop: _this3.resizeHandler('onResizeStop', handleAxis),
          onStart: _this3.resizeHandler('onResizeStart', handleAxis),
          onDrag: _this3.resizeHandler('onResize', handleAxis)
        }), _this3.renderResizeHandle(handleAxis, ref));
      }))
    }));
  };
  return Resizable;
}(React.Component);
exports["default"] = Resizable;
Resizable.propTypes = _propTypes.resizableProps;
Resizable.defaultProps = {
  axis: 'both',
  handleSize: [20, 20],
  lockAspectRatio: false,
  minConstraints: [20, 20],
  maxConstraints: [Infinity, Infinity],
  resizeHandles: ['se'],
  transformScale: 1
};

/***/ }),

/***/ 8690:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
var __webpack_unused_export__;


__webpack_unused_export__ = true;
exports["default"] = void 0;
var React = _interopRequireWildcard(__webpack_require__(9512));
var _propTypes = _interopRequireDefault(__webpack_require__(1226));
var _Resizable = _interopRequireDefault(__webpack_require__(7939));
var _propTypes2 = __webpack_require__(3691);
var _excluded = ["handle", "handleSize", "onResize", "onResizeStart", "onResizeStop", "draggableOpts", "minConstraints", "maxConstraints", "lockAspectRatio", "axis", "width", "height", "resizeHandles", "style", "transformScale"];
function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    default: obj
  };
}
function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}
function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }
  if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
    return {
      default: obj
    };
  }
  var cache = _getRequireWildcardCache(nodeInterop);
  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }
  var newObj = {};
  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }
  newObj.default = obj;
  if (cache) {
    cache.set(obj, newObj);
  }
  return newObj;
}
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
var ResizableBox = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(ResizableBox, _React$Component);
  function ResizableBox() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.state = {
      width: _this.props.width,
      height: _this.props.height,
      propsWidth: _this.props.width,
      propsHeight: _this.props.height
    };
    _this.onResize = function (e, data) {
      var size = data.size;
      if (_this.props.onResize) {
        e.persist == null ? void 0 : e.persist();
        _this.setState(size, function () {
          return _this.props.onResize && _this.props.onResize(e, data);
        });
      } else {
        _this.setState(size);
      }
    };
    return _this;
  }
  ResizableBox.getDerivedStateFromProps = function getDerivedStateFromProps(props, state) {
    // If parent changes height/width, set that in our state.
    if (state.propsWidth !== props.width || state.propsHeight !== props.height) {
      return {
        width: props.width,
        height: props.height,
        propsWidth: props.width,
        propsHeight: props.height
      };
    }
    return null;
  };
  var _proto = ResizableBox.prototype;
  _proto.render = function render() {
    // Basic wrapper around a Resizable instance.
    // If you use Resizable directly, you are responsible for updating the child component
    // with a new width and height.
    var _this$props = this.props,
      handle = _this$props.handle,
      handleSize = _this$props.handleSize,
      onResize = _this$props.onResize,
      onResizeStart = _this$props.onResizeStart,
      onResizeStop = _this$props.onResizeStop,
      draggableOpts = _this$props.draggableOpts,
      minConstraints = _this$props.minConstraints,
      maxConstraints = _this$props.maxConstraints,
      lockAspectRatio = _this$props.lockAspectRatio,
      axis = _this$props.axis,
      width = _this$props.width,
      height = _this$props.height,
      resizeHandles = _this$props.resizeHandles,
      style = _this$props.style,
      transformScale = _this$props.transformScale,
      props = _objectWithoutPropertiesLoose(_this$props, _excluded);
    return /*#__PURE__*/React.createElement(_Resizable.default, {
      axis: axis,
      draggableOpts: draggableOpts,
      handle: handle,
      handleSize: handleSize,
      height: this.state.height,
      lockAspectRatio: lockAspectRatio,
      maxConstraints: maxConstraints,
      minConstraints: minConstraints,
      onResizeStart: onResizeStart,
      onResize: this.onResize,
      onResizeStop: onResizeStop,
      resizeHandles: resizeHandles,
      transformScale: transformScale,
      width: this.state.width
    }, /*#__PURE__*/React.createElement("div", _extends({}, props, {
      style: _objectSpread(_objectSpread({}, style), {}, {
        width: this.state.width + 'px',
        height: this.state.height + 'px'
      })
    })));
  };
  return ResizableBox;
}(React.Component);
exports["default"] = ResizableBox;
// PropTypes are identical to <Resizable>, except that children are not strictly required to be present.
ResizableBox.propTypes = _objectSpread(_objectSpread({}, _propTypes2.resizableProps), {}, {
  children: _propTypes.default.element
});

/***/ }),

/***/ 3691:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.resizableProps = void 0;
var _propTypes = _interopRequireDefault(__webpack_require__(1226));
var _reactDraggable = __webpack_require__(1710);
function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    default: obj
  };
}
var resizableProps = {
  /*
  * Restricts resizing to a particular axis (default: 'both')
  * 'both' - allows resizing by width or height
  * 'x' - only allows the width to be changed
  * 'y' - only allows the height to be changed
  * 'none' - disables resizing altogether
  * */
  axis: _propTypes.default.oneOf(['both', 'x', 'y', 'none']),
  className: _propTypes.default.string,
  /*
  * Require that one and only one child be present.
  * */
  children: _propTypes.default.element.isRequired,
  /*
  * These will be passed wholesale to react-draggable's DraggableCore
  * */
  draggableOpts: _propTypes.default.shape({
    allowAnyClick: _propTypes.default.bool,
    cancel: _propTypes.default.string,
    children: _propTypes.default.node,
    disabled: _propTypes.default.bool,
    enableUserSelectHack: _propTypes.default.bool,
    offsetParent: _propTypes.default.node,
    grid: _propTypes.default.arrayOf(_propTypes.default.number),
    handle: _propTypes.default.string,
    nodeRef: _propTypes.default.object,
    onStart: _propTypes.default.func,
    onDrag: _propTypes.default.func,
    onStop: _propTypes.default.func,
    onMouseDown: _propTypes.default.func,
    scale: _propTypes.default.number
  }),
  /*
  * Initial height
  * */
  height: function height() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    var props = args[0];
    // Required if resizing height or both
    if (props.axis === 'both' || props.axis === 'y') {
      var _PropTypes$number;
      return (_PropTypes$number = _propTypes.default.number).isRequired.apply(_PropTypes$number, args);
    }
    return _propTypes.default.number.apply(_propTypes.default, args);
  },
  /*
  * Customize cursor resize handle
  * */
  handle: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.func]),
  /*
  * If you change this, be sure to update your css
  * */
  handleSize: _propTypes.default.arrayOf(_propTypes.default.number),
  lockAspectRatio: _propTypes.default.bool,
  /*
  * Max X & Y measure
  * */
  maxConstraints: _propTypes.default.arrayOf(_propTypes.default.number),
  /*
  * Min X & Y measure
  * */
  minConstraints: _propTypes.default.arrayOf(_propTypes.default.number),
  /*
  * Called on stop resize event
  * */
  onResizeStop: _propTypes.default.func,
  /*
  * Called on start resize event
  * */
  onResizeStart: _propTypes.default.func,
  /*
  * Called on resize event
  * */
  onResize: _propTypes.default.func,
  /*
  * Defines which resize handles should be rendered (default: 'se')
  * 's' - South handle (bottom-center)
  * 'w' - West handle (left-center)
  * 'e' - East handle (right-center)
  * 'n' - North handle (top-center)
  * 'sw' - Southwest handle (bottom-left)
  * 'nw' - Northwest handle (top-left)
  * 'se' - Southeast handle (bottom-right)
  * 'ne' - Northeast handle (top-center)
  * */
  resizeHandles: _propTypes.default.arrayOf(_propTypes.default.oneOf(['s', 'w', 'e', 'n', 'sw', 'nw', 'se', 'ne'])),
  /*
  * If `transform: scale(n)` is set on the parent, this should be set to `n`.
  * */
  transformScale: _propTypes.default.number,
  /*
   * Initial width
   */
  width: function width() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }
    var props = args[0];
    // Required if resizing width or both
    if (props.axis === 'both' || props.axis === 'x') {
      var _PropTypes$number2;
      return (_PropTypes$number2 = _propTypes.default.number).isRequired.apply(_PropTypes$number2, args);
    }
    return _propTypes.default.number.apply(_propTypes.default, args);
  }
};
exports.resizableProps = resizableProps;

/***/ }),

/***/ 7748:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.cloneElement = cloneElement;
var _react = _interopRequireDefault(__webpack_require__(9512));
function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    default: obj
  };
}
function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
// React.addons.cloneWithProps look-alike that merges style & className.
function cloneElement(element, props) {
  if (props.style && element.props.style) {
    props.style = _objectSpread(_objectSpread({}, element.props.style), props.style);
  }
  if (props.className && element.props.className) {
    props.className = element.props.className + " " + props.className;
  }
  return /*#__PURE__*/_react.default.cloneElement(element, props);
}

/***/ }),

/***/ 3350:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = function () {
  throw new Error("Don't instantiate Resizable directly! Use require('react-resizable').Resizable");
};
module.exports.Resizable = __webpack_require__(7939)["default"];
module.exports.ResizableBox = __webpack_require__(8690)["default"];

/***/ }),

/***/ 4992:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
/**
 * @license React
 * react-jsx-runtime.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */


var f = __webpack_require__(9512),
  k = Symbol.for("react.element"),
  l = Symbol.for("react.fragment"),
  m = Object.prototype.hasOwnProperty,
  n = f.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner,
  p = {
    key: !0,
    ref: !0,
    __self: !0,
    __source: !0
  };
function q(c, a, g) {
  var b,
    d = {},
    e = null,
    h = null;
  void 0 !== g && (e = "" + g);
  void 0 !== a.key && (e = "" + a.key);
  void 0 !== a.ref && (h = a.ref);
  for (b in a) m.call(a, b) && !p.hasOwnProperty(b) && (d[b] = a[b]);
  if (c && c.defaultProps) for (b in a = c.defaultProps, a) void 0 === d[b] && (d[b] = a[b]);
  return {
    $$typeof: k,
    type: c,
    key: e,
    ref: h,
    props: d,
    _owner: n.current
  };
}
exports.Fragment = l;
exports.jsx = q;
exports.jsxs = q;

/***/ }),

/***/ 7276:
/***/ (function(__unused_webpack_module, exports) {

"use strict";
/**
 * @license React
 * react.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */


var l = Symbol.for("react.element"),
  n = Symbol.for("react.portal"),
  p = Symbol.for("react.fragment"),
  q = Symbol.for("react.strict_mode"),
  r = Symbol.for("react.profiler"),
  t = Symbol.for("react.provider"),
  u = Symbol.for("react.context"),
  v = Symbol.for("react.forward_ref"),
  w = Symbol.for("react.suspense"),
  x = Symbol.for("react.memo"),
  y = Symbol.for("react.lazy"),
  z = Symbol.iterator;
function A(a) {
  if (null === a || "object" !== typeof a) return null;
  a = z && a[z] || a["@@iterator"];
  return "function" === typeof a ? a : null;
}
var B = {
    isMounted: function isMounted() {
      return !1;
    },
    enqueueForceUpdate: function enqueueForceUpdate() {},
    enqueueReplaceState: function enqueueReplaceState() {},
    enqueueSetState: function enqueueSetState() {}
  },
  C = Object.assign,
  D = {};
function E(a, b, e) {
  this.props = a;
  this.context = b;
  this.refs = D;
  this.updater = e || B;
}
E.prototype.isReactComponent = {};
E.prototype.setState = function (a, b) {
  if ("object" !== typeof a && "function" !== typeof a && null != a) throw Error("setState(...): takes an object of state variables to update or a function which returns an object of state variables.");
  this.updater.enqueueSetState(this, a, b, "setState");
};
E.prototype.forceUpdate = function (a) {
  this.updater.enqueueForceUpdate(this, a, "forceUpdate");
};
function F() {}
F.prototype = E.prototype;
function G(a, b, e) {
  this.props = a;
  this.context = b;
  this.refs = D;
  this.updater = e || B;
}
var H = G.prototype = new F();
H.constructor = G;
C(H, E.prototype);
H.isPureReactComponent = !0;
var I = Array.isArray,
  J = Object.prototype.hasOwnProperty,
  K = {
    current: null
  },
  L = {
    key: !0,
    ref: !0,
    __self: !0,
    __source: !0
  };
function M(a, b, e) {
  var d,
    c = {},
    k = null,
    h = null;
  if (null != b) for (d in void 0 !== b.ref && (h = b.ref), void 0 !== b.key && (k = "" + b.key), b) J.call(b, d) && !L.hasOwnProperty(d) && (c[d] = b[d]);
  var g = arguments.length - 2;
  if (1 === g) c.children = e;else if (1 < g) {
    for (var f = Array(g), m = 0; m < g; m++) f[m] = arguments[m + 2];
    c.children = f;
  }
  if (a && a.defaultProps) for (d in g = a.defaultProps, g) void 0 === c[d] && (c[d] = g[d]);
  return {
    $$typeof: l,
    type: a,
    key: k,
    ref: h,
    props: c,
    _owner: K.current
  };
}
function N(a, b) {
  return {
    $$typeof: l,
    type: a.type,
    key: b,
    ref: a.ref,
    props: a.props,
    _owner: a._owner
  };
}
function O(a) {
  return "object" === typeof a && null !== a && a.$$typeof === l;
}
function escape(a) {
  var b = {
    "=": "=0",
    ":": "=2"
  };
  return "$" + a.replace(/[=:]/g, function (a) {
    return b[a];
  });
}
var P = /\/+/g;
function Q(a, b) {
  return "object" === typeof a && null !== a && null != a.key ? escape("" + a.key) : b.toString(36);
}
function R(a, b, e, d, c) {
  var k = typeof a;
  if ("undefined" === k || "boolean" === k) a = null;
  var h = !1;
  if (null === a) h = !0;else switch (k) {
    case "string":
    case "number":
      h = !0;
      break;
    case "object":
      switch (a.$$typeof) {
        case l:
        case n:
          h = !0;
      }
  }
  if (h) return h = a, c = c(h), a = "" === d ? "." + Q(h, 0) : d, I(c) ? (e = "", null != a && (e = a.replace(P, "$&/") + "/"), R(c, b, e, "", function (a) {
    return a;
  })) : null != c && (O(c) && (c = N(c, e + (!c.key || h && h.key === c.key ? "" : ("" + c.key).replace(P, "$&/") + "/") + a)), b.push(c)), 1;
  h = 0;
  d = "" === d ? "." : d + ":";
  if (I(a)) for (var g = 0; g < a.length; g++) {
    k = a[g];
    var f = d + Q(k, g);
    h += R(k, b, e, f, c);
  } else if (f = A(a), "function" === typeof f) for (a = f.call(a), g = 0; !(k = a.next()).done;) k = k.value, f = d + Q(k, g++), h += R(k, b, e, f, c);else if ("object" === k) throw b = String(a), Error("Objects are not valid as a React child (found: " + ("[object Object]" === b ? "object with keys {" + Object.keys(a).join(", ") + "}" : b) + "). If you meant to render a collection of children, use an array instead.");
  return h;
}
function S(a, b, e) {
  if (null == a) return a;
  var d = [],
    c = 0;
  R(a, d, "", "", function (a) {
    return b.call(e, a, c++);
  });
  return d;
}
function T(a) {
  if (-1 === a._status) {
    var b = a._result;
    b = b();
    b.then(function (b) {
      if (0 === a._status || -1 === a._status) a._status = 1, a._result = b;
    }, function (b) {
      if (0 === a._status || -1 === a._status) a._status = 2, a._result = b;
    });
    -1 === a._status && (a._status = 0, a._result = b);
  }
  if (1 === a._status) return a._result.default;
  throw a._result;
}
var U = {
    current: null
  },
  V = {
    transition: null
  },
  W = {
    ReactCurrentDispatcher: U,
    ReactCurrentBatchConfig: V,
    ReactCurrentOwner: K
  };
exports.Children = {
  map: S,
  forEach: function forEach(a, b, e) {
    S(a, function () {
      b.apply(this, arguments);
    }, e);
  },
  count: function count(a) {
    var b = 0;
    S(a, function () {
      b++;
    });
    return b;
  },
  toArray: function toArray(a) {
    return S(a, function (a) {
      return a;
    }) || [];
  },
  only: function only(a) {
    if (!O(a)) throw Error("React.Children.only expected to receive a single React element child.");
    return a;
  }
};
exports.Component = E;
exports.Fragment = p;
exports.Profiler = r;
exports.PureComponent = G;
exports.StrictMode = q;
exports.Suspense = w;
exports.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = W;
exports.cloneElement = function (a, b, e) {
  if (null === a || void 0 === a) throw Error("React.cloneElement(...): The argument must be a React element, but you passed " + a + ".");
  var d = C({}, a.props),
    c = a.key,
    k = a.ref,
    h = a._owner;
  if (null != b) {
    void 0 !== b.ref && (k = b.ref, h = K.current);
    void 0 !== b.key && (c = "" + b.key);
    if (a.type && a.type.defaultProps) var g = a.type.defaultProps;
    for (f in b) J.call(b, f) && !L.hasOwnProperty(f) && (d[f] = void 0 === b[f] && void 0 !== g ? g[f] : b[f]);
  }
  var f = arguments.length - 2;
  if (1 === f) d.children = e;else if (1 < f) {
    g = Array(f);
    for (var m = 0; m < f; m++) g[m] = arguments[m + 2];
    d.children = g;
  }
  return {
    $$typeof: l,
    type: a.type,
    key: c,
    ref: k,
    props: d,
    _owner: h
  };
};
exports.createContext = function (a) {
  a = {
    $$typeof: u,
    _currentValue: a,
    _currentValue2: a,
    _threadCount: 0,
    Provider: null,
    Consumer: null,
    _defaultValue: null,
    _globalName: null
  };
  a.Provider = {
    $$typeof: t,
    _context: a
  };
  return a.Consumer = a;
};
exports.createElement = M;
exports.createFactory = function (a) {
  var b = M.bind(null, a);
  b.type = a;
  return b;
};
exports.createRef = function () {
  return {
    current: null
  };
};
exports.forwardRef = function (a) {
  return {
    $$typeof: v,
    render: a
  };
};
exports.isValidElement = O;
exports.lazy = function (a) {
  return {
    $$typeof: y,
    _payload: {
      _status: -1,
      _result: a
    },
    _init: T
  };
};
exports.memo = function (a, b) {
  return {
    $$typeof: x,
    type: a,
    compare: void 0 === b ? null : b
  };
};
exports.startTransition = function (a) {
  var b = V.transition;
  V.transition = {};
  try {
    a();
  } finally {
    V.transition = b;
  }
};
exports.unstable_act = function () {
  throw Error("act(...) is not supported in production builds of React.");
};
exports.useCallback = function (a, b) {
  return U.current.useCallback(a, b);
};
exports.useContext = function (a) {
  return U.current.useContext(a);
};
exports.useDebugValue = function () {};
exports.useDeferredValue = function (a) {
  return U.current.useDeferredValue(a);
};
exports.useEffect = function (a, b) {
  return U.current.useEffect(a, b);
};
exports.useId = function () {
  return U.current.useId();
};
exports.useImperativeHandle = function (a, b, e) {
  return U.current.useImperativeHandle(a, b, e);
};
exports.useInsertionEffect = function (a, b) {
  return U.current.useInsertionEffect(a, b);
};
exports.useLayoutEffect = function (a, b) {
  return U.current.useLayoutEffect(a, b);
};
exports.useMemo = function (a, b) {
  return U.current.useMemo(a, b);
};
exports.useReducer = function (a, b, e) {
  return U.current.useReducer(a, b, e);
};
exports.useRef = function (a) {
  return U.current.useRef(a);
};
exports.useState = function (a) {
  return U.current.useState(a);
};
exports.useSyncExternalStore = function (a, b, e) {
  return U.current.useSyncExternalStore(a, b, e);
};
exports.useTransition = function () {
  return U.current.useTransition();
};
exports.version = "18.2.0";

/***/ }),

/***/ 9512:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


if (true) {
  module.exports = __webpack_require__(7276);
} else {}

/***/ }),

/***/ 9386:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


if (true) {
  module.exports = __webpack_require__(4992);
} else {}

/***/ }),

/***/ 875:
/***/ (function(__unused_webpack_module, exports) {

"use strict";
/**
 * @license React
 * scheduler.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */


function f(a, b) {
  var c = a.length;
  a.push(b);
  a: for (; 0 < c;) {
    var d = c - 1 >>> 1,
      e = a[d];
    if (0 < g(e, b)) a[d] = b, a[c] = e, c = d;else break a;
  }
}
function h(a) {
  return 0 === a.length ? null : a[0];
}
function k(a) {
  if (0 === a.length) return null;
  var b = a[0],
    c = a.pop();
  if (c !== b) {
    a[0] = c;
    a: for (var d = 0, e = a.length, w = e >>> 1; d < w;) {
      var m = 2 * (d + 1) - 1,
        C = a[m],
        n = m + 1,
        x = a[n];
      if (0 > g(C, c)) n < e && 0 > g(x, C) ? (a[d] = x, a[n] = c, d = n) : (a[d] = C, a[m] = c, d = m);else if (n < e && 0 > g(x, c)) a[d] = x, a[n] = c, d = n;else break a;
    }
  }
  return b;
}
function g(a, b) {
  var c = a.sortIndex - b.sortIndex;
  return 0 !== c ? c : a.id - b.id;
}
if ("object" === typeof performance && "function" === typeof performance.now) {
  var l = performance;
  exports.unstable_now = function () {
    return l.now();
  };
} else {
  var p = Date,
    q = p.now();
  exports.unstable_now = function () {
    return p.now() - q;
  };
}
var r = [],
  t = [],
  u = 1,
  v = null,
  y = 3,
  z = !1,
  A = !1,
  B = !1,
  D = "function" === typeof setTimeout ? setTimeout : null,
  E = "function" === typeof clearTimeout ? clearTimeout : null,
  F = "undefined" !== typeof setImmediate ? setImmediate : null;
"undefined" !== typeof navigator && void 0 !== navigator.scheduling && void 0 !== navigator.scheduling.isInputPending && navigator.scheduling.isInputPending.bind(navigator.scheduling);
function G(a) {
  for (var b = h(t); null !== b;) {
    if (null === b.callback) k(t);else if (b.startTime <= a) k(t), b.sortIndex = b.expirationTime, f(r, b);else break;
    b = h(t);
  }
}
function H(a) {
  B = !1;
  G(a);
  if (!A) if (null !== h(r)) A = !0, I(J);else {
    var b = h(t);
    null !== b && K(H, b.startTime - a);
  }
}
function J(a, b) {
  A = !1;
  B && (B = !1, E(L), L = -1);
  z = !0;
  var c = y;
  try {
    G(b);
    for (v = h(r); null !== v && (!(v.expirationTime > b) || a && !M());) {
      var d = v.callback;
      if ("function" === typeof d) {
        v.callback = null;
        y = v.priorityLevel;
        var e = d(v.expirationTime <= b);
        b = exports.unstable_now();
        "function" === typeof e ? v.callback = e : v === h(r) && k(r);
        G(b);
      } else k(r);
      v = h(r);
    }
    if (null !== v) var w = !0;else {
      var m = h(t);
      null !== m && K(H, m.startTime - b);
      w = !1;
    }
    return w;
  } finally {
    v = null, y = c, z = !1;
  }
}
var N = !1,
  O = null,
  L = -1,
  P = 5,
  Q = -1;
function M() {
  return exports.unstable_now() - Q < P ? !1 : !0;
}
function R() {
  if (null !== O) {
    var a = exports.unstable_now();
    Q = a;
    var b = !0;
    try {
      b = O(!0, a);
    } finally {
      b ? S() : (N = !1, O = null);
    }
  } else N = !1;
}
var S;
if ("function" === typeof F) S = function S() {
  F(R);
};else if ("undefined" !== typeof MessageChannel) {
  var T = new MessageChannel(),
    U = T.port2;
  T.port1.onmessage = R;
  S = function S() {
    U.postMessage(null);
  };
} else S = function S() {
  D(R, 0);
};
function I(a) {
  O = a;
  N || (N = !0, S());
}
function K(a, b) {
  L = D(function () {
    a(exports.unstable_now());
  }, b);
}
exports.unstable_IdlePriority = 5;
exports.unstable_ImmediatePriority = 1;
exports.unstable_LowPriority = 4;
exports.unstable_NormalPriority = 3;
exports.unstable_Profiling = null;
exports.unstable_UserBlockingPriority = 2;
exports.unstable_cancelCallback = function (a) {
  a.callback = null;
};
exports.unstable_continueExecution = function () {
  A || z || (A = !0, I(J));
};
exports.unstable_forceFrameRate = function (a) {
  0 > a || 125 < a ? console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported") : P = 0 < a ? Math.floor(1E3 / a) : 5;
};
exports.unstable_getCurrentPriorityLevel = function () {
  return y;
};
exports.unstable_getFirstCallbackNode = function () {
  return h(r);
};
exports.unstable_next = function (a) {
  switch (y) {
    case 1:
    case 2:
    case 3:
      var b = 3;
      break;
    default:
      b = y;
  }
  var c = y;
  y = b;
  try {
    return a();
  } finally {
    y = c;
  }
};
exports.unstable_pauseExecution = function () {};
exports.unstable_requestPaint = function () {};
exports.unstable_runWithPriority = function (a, b) {
  switch (a) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      break;
    default:
      a = 3;
  }
  var c = y;
  y = a;
  try {
    return b();
  } finally {
    y = c;
  }
};
exports.unstable_scheduleCallback = function (a, b, c) {
  var d = exports.unstable_now();
  "object" === typeof c && null !== c ? (c = c.delay, c = "number" === typeof c && 0 < c ? d + c : d) : c = d;
  switch (a) {
    case 1:
      var e = -1;
      break;
    case 2:
      e = 250;
      break;
    case 5:
      e = 1073741823;
      break;
    case 4:
      e = 1E4;
      break;
    default:
      e = 5E3;
  }
  e = c + e;
  a = {
    id: u++,
    callback: b,
    priorityLevel: a,
    startTime: c,
    expirationTime: e,
    sortIndex: -1
  };
  c > d ? (a.sortIndex = c, f(t, a), null === h(r) && a === h(t) && (B ? (E(L), L = -1) : B = !0, K(H, c - d))) : (a.sortIndex = e, f(r, a), A || z || (A = !0, I(J)));
  return a;
};
exports.unstable_shouldYield = M;
exports.unstable_wrapCallback = function (a) {
  var b = y;
  return function () {
    var c = y;
    y = b;
    try {
      return a.apply(this, arguments);
    } finally {
      y = c;
    }
  };
};

/***/ }),

/***/ 4086:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


if (true) {
  module.exports = __webpack_require__(875);
} else {}

/***/ }),

/***/ 301:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var _classCallCheck = (__webpack_require__(8403)["default"]);
var _createClass = (__webpack_require__(2467)["default"]);
var ANY = Symbol('SemVer ANY');
// hoisted class for cyclic dependency
var Comparator = /*#__PURE__*/function () {
  "use strict";

  function Comparator(comp, options) {
    _classCallCheck(this, Comparator);
    options = parseOptions(options);
    if (comp instanceof Comparator) {
      if (comp.loose === !!options.loose) {
        return comp;
      } else {
        comp = comp.value;
      }
    }
    debug('comparator', comp, options);
    this.options = options;
    this.loose = !!options.loose;
    this.parse(comp);
    if (this.semver === ANY) {
      this.value = '';
    } else {
      this.value = this.operator + this.semver.version;
    }
    debug('comp', this);
  }
  _createClass(Comparator, [{
    key: "parse",
    value: function parse(comp) {
      var r = this.options.loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
      var m = comp.match(r);
      if (!m) {
        throw new TypeError("Invalid comparator: ".concat(comp));
      }
      this.operator = m[1] !== undefined ? m[1] : '';
      if (this.operator === '=') {
        this.operator = '';
      }

      // if it literally is just '>' or '' then allow anything.
      if (!m[2]) {
        this.semver = ANY;
      } else {
        this.semver = new SemVer(m[2], this.options.loose);
      }
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.value;
    }
  }, {
    key: "test",
    value: function test(version) {
      debug('Comparator.test', version, this.options.loose);
      if (this.semver === ANY || version === ANY) {
        return true;
      }
      if (typeof version === 'string') {
        try {
          version = new SemVer(version, this.options);
        } catch (er) {
          return false;
        }
      }
      return cmp(version, this.operator, this.semver, this.options);
    }
  }, {
    key: "intersects",
    value: function intersects(comp, options) {
      if (!(comp instanceof Comparator)) {
        throw new TypeError('a Comparator is required');
      }
      if (this.operator === '') {
        if (this.value === '') {
          return true;
        }
        return new Range(comp.value, options).test(this.value);
      } else if (comp.operator === '') {
        if (comp.value === '') {
          return true;
        }
        return new Range(this.value, options).test(comp.semver);
      }
      options = parseOptions(options);

      // Special cases where nothing can possibly be lower
      if (options.includePrerelease && (this.value === '<0.0.0-0' || comp.value === '<0.0.0-0')) {
        return false;
      }
      if (!options.includePrerelease && (this.value.startsWith('<0.0.0') || comp.value.startsWith('<0.0.0'))) {
        return false;
      }

      // Same direction increasing (> or >=)
      if (this.operator.startsWith('>') && comp.operator.startsWith('>')) {
        return true;
      }
      // Same direction decreasing (< or <=)
      if (this.operator.startsWith('<') && comp.operator.startsWith('<')) {
        return true;
      }
      // same SemVer and both sides are inclusive (<= or >=)
      if (this.semver.version === comp.semver.version && this.operator.includes('=') && comp.operator.includes('=')) {
        return true;
      }
      // opposite directions less than
      if (cmp(this.semver, '<', comp.semver, options) && this.operator.startsWith('>') && comp.operator.startsWith('<')) {
        return true;
      }
      // opposite directions greater than
      if (cmp(this.semver, '>', comp.semver, options) && this.operator.startsWith('<') && comp.operator.startsWith('>')) {
        return true;
      }
      return false;
    }
  }], [{
    key: "ANY",
    get: function get() {
      return ANY;
    }
  }]);
  return Comparator;
}();
module.exports = Comparator;
var parseOptions = __webpack_require__(504);
var _require = __webpack_require__(8369),
  re = _require.re,
  t = _require.t;
var cmp = __webpack_require__(9900);
var debug = __webpack_require__(6298);
var SemVer = __webpack_require__(1186);
var Range = __webpack_require__(7258);

/***/ }),

/***/ 7258:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var _toConsumableArray = (__webpack_require__(7685)["default"]);
var _createForOfIteratorHelper = (__webpack_require__(3762)["default"]);
var _classCallCheck = (__webpack_require__(8403)["default"]);
var _createClass = (__webpack_require__(2467)["default"]);
// hoisted class for cyclic dependency
var Range = /*#__PURE__*/function () {
  "use strict";

  function Range(range, options) {
    var _this = this;
    _classCallCheck(this, Range);
    options = parseOptions(options);
    if (range instanceof Range) {
      if (range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease) {
        return range;
      } else {
        return new Range(range.raw, options);
      }
    }
    if (range instanceof Comparator) {
      // just put it in the set and return
      this.raw = range.value;
      this.set = [[range]];
      this.format();
      return this;
    }
    this.options = options;
    this.loose = !!options.loose;
    this.includePrerelease = !!options.includePrerelease;

    // First, split based on boolean or ||
    this.raw = range;
    this.set = range.split('||')
    // map the range to a 2d array of comparators
    .map(function (r) {
      return _this.parseRange(r.trim());
    })
    // throw out any comparator lists that are empty
    // this generally means that it was not a valid range, which is allowed
    // in loose mode, but will still throw if the WHOLE range is invalid.
    .filter(function (c) {
      return c.length;
    });
    if (!this.set.length) {
      throw new TypeError("Invalid SemVer Range: ".concat(range));
    }

    // if we have any that are not the null set, throw out null sets.
    if (this.set.length > 1) {
      // keep the first one, in case they're all null sets
      var first = this.set[0];
      this.set = this.set.filter(function (c) {
        return !isNullSet(c[0]);
      });
      if (this.set.length === 0) {
        this.set = [first];
      } else if (this.set.length > 1) {
        // if we have any that are *, then the range is just *
        var _iterator = _createForOfIteratorHelper(this.set),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var c = _step.value;
            if (c.length === 1 && isAny(c[0])) {
              this.set = [c];
              break;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
    }
    this.format();
  }
  _createClass(Range, [{
    key: "format",
    value: function format() {
      this.range = this.set.map(function (comps) {
        return comps.join(' ').trim();
      }).join('||').trim();
      return this.range;
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.range;
    }
  }, {
    key: "parseRange",
    value: function parseRange(range) {
      var _this2 = this;
      range = range.trim();

      // memoize range parsing for performance.
      // this is a very hot path, and fully deterministic.
      var memoOpts = (this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE);
      var memoKey = memoOpts + ':' + range;
      var cached = cache.get(memoKey);
      if (cached) {
        return cached;
      }
      var loose = this.options.loose;
      // `1.2.3 - 1.2.4` => `>=1.2.3 <=1.2.4`
      var hr = loose ? re[t.HYPHENRANGELOOSE] : re[t.HYPHENRANGE];
      range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
      debug('hyphen replace', range);
      // `> 1.2.3 < 1.2.5` => `>1.2.3 <1.2.5`
      range = range.replace(re[t.COMPARATORTRIM], comparatorTrimReplace);
      debug('comparator trim', range);

      // `~ 1.2.3` => `~1.2.3`
      range = range.replace(re[t.TILDETRIM], tildeTrimReplace);

      // `^ 1.2.3` => `^1.2.3`
      range = range.replace(re[t.CARETTRIM], caretTrimReplace);

      // normalize spaces
      range = range.split(/\s+/).join(' ');

      // At this point, the range is completely trimmed and
      // ready to be split into comparators.

      var rangeList = range.split(' ').map(function (comp) {
        return parseComparator(comp, _this2.options);
      }).join(' ').split(/\s+/)
      // >=0.0.0 is equivalent to *
      .map(function (comp) {
        return replaceGTE0(comp, _this2.options);
      });
      if (loose) {
        // in loose mode, throw out any that are not valid comparators
        rangeList = rangeList.filter(function (comp) {
          debug('loose invalid filter', comp, _this2.options);
          return !!comp.match(re[t.COMPARATORLOOSE]);
        });
      }
      debug('range list', rangeList);

      // if any comparators are the null set, then replace with JUST null set
      // if more than one comparator, remove any * comparators
      // also, don't include the same comparator more than once
      var rangeMap = new Map();
      var comparators = rangeList.map(function (comp) {
        return new Comparator(comp, _this2.options);
      });
      var _iterator2 = _createForOfIteratorHelper(comparators),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var comp = _step2.value;
          if (isNullSet(comp)) {
            return [comp];
          }
          rangeMap.set(comp.value, comp);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      if (rangeMap.size > 1 && rangeMap.has('')) {
        rangeMap.delete('');
      }
      var result = _toConsumableArray(rangeMap.values());
      cache.set(memoKey, result);
      return result;
    }
  }, {
    key: "intersects",
    value: function intersects(range, options) {
      if (!(range instanceof Range)) {
        throw new TypeError('a Range is required');
      }
      return this.set.some(function (thisComparators) {
        return isSatisfiable(thisComparators, options) && range.set.some(function (rangeComparators) {
          return isSatisfiable(rangeComparators, options) && thisComparators.every(function (thisComparator) {
            return rangeComparators.every(function (rangeComparator) {
              return thisComparator.intersects(rangeComparator, options);
            });
          });
        });
      });
    }

    // if ANY of the sets match ALL of its comparators, then pass
  }, {
    key: "test",
    value: function test(version) {
      if (!version) {
        return false;
      }
      if (typeof version === 'string') {
        try {
          version = new SemVer(version, this.options);
        } catch (er) {
          return false;
        }
      }
      for (var i = 0; i < this.set.length; i++) {
        if (testSet(this.set[i], version, this.options)) {
          return true;
        }
      }
      return false;
    }
  }]);
  return Range;
}();
module.exports = Range;
var LRU = __webpack_require__(2346);
var cache = new LRU({
  max: 1000
});
var parseOptions = __webpack_require__(504);
var Comparator = __webpack_require__(301);
var debug = __webpack_require__(6298);
var SemVer = __webpack_require__(1186);
var _require = __webpack_require__(8369),
  re = _require.re,
  t = _require.t,
  comparatorTrimReplace = _require.comparatorTrimReplace,
  tildeTrimReplace = _require.tildeTrimReplace,
  caretTrimReplace = _require.caretTrimReplace;
var _require2 = __webpack_require__(6028),
  FLAG_INCLUDE_PRERELEASE = _require2.FLAG_INCLUDE_PRERELEASE,
  FLAG_LOOSE = _require2.FLAG_LOOSE;
var isNullSet = function isNullSet(c) {
  return c.value === '<0.0.0-0';
};
var isAny = function isAny(c) {
  return c.value === '';
};

// take a set of comparators and determine whether there
// exists a version which can satisfy it
var isSatisfiable = function isSatisfiable(comparators, options) {
  var result = true;
  var remainingComparators = comparators.slice();
  var testComparator = remainingComparators.pop();
  while (result && remainingComparators.length) {
    result = remainingComparators.every(function (otherComparator) {
      return testComparator.intersects(otherComparator, options);
    });
    testComparator = remainingComparators.pop();
  }
  return result;
};

// comprised of xranges, tildes, stars, and gtlt's at this point.
// already replaced the hyphen ranges
// turn into a set of JUST comparators.
var parseComparator = function parseComparator(comp, options) {
  debug('comp', comp, options);
  comp = replaceCarets(comp, options);
  debug('caret', comp);
  comp = replaceTildes(comp, options);
  debug('tildes', comp);
  comp = replaceXRanges(comp, options);
  debug('xrange', comp);
  comp = replaceStars(comp, options);
  debug('stars', comp);
  return comp;
};
var isX = function isX(id) {
  return !id || id.toLowerCase() === 'x' || id === '*';
};

// ~, ~> --> * (any, kinda silly)
// ~2, ~2.x, ~2.x.x, ~>2, ~>2.x ~>2.x.x --> >=2.0.0 <3.0.0-0
// ~2.0, ~2.0.x, ~>2.0, ~>2.0.x --> >=2.0.0 <2.1.0-0
// ~1.2, ~1.2.x, ~>1.2, ~>1.2.x --> >=1.2.0 <1.3.0-0
// ~1.2.3, ~>1.2.3 --> >=1.2.3 <1.3.0-0
// ~1.2.0, ~>1.2.0 --> >=1.2.0 <1.3.0-0
// ~0.0.1 --> >=0.0.1 <0.1.0-0
var replaceTildes = function replaceTildes(comp, options) {
  return comp.trim().split(/\s+/).map(function (c) {
    return replaceTilde(c, options);
  }).join(' ');
};
var replaceTilde = function replaceTilde(comp, options) {
  var r = options.loose ? re[t.TILDELOOSE] : re[t.TILDE];
  return comp.replace(r, function (_, M, m, p, pr) {
    debug('tilde', comp, _, M, m, p, pr);
    var ret;
    if (isX(M)) {
      ret = '';
    } else if (isX(m)) {
      ret = ">=".concat(M, ".0.0 <").concat(+M + 1, ".0.0-0");
    } else if (isX(p)) {
      // ~1.2 == >=1.2.0 <1.3.0-0
      ret = ">=".concat(M, ".").concat(m, ".0 <").concat(M, ".").concat(+m + 1, ".0-0");
    } else if (pr) {
      debug('replaceTilde pr', pr);
      ret = ">=".concat(M, ".").concat(m, ".").concat(p, "-").concat(pr, " <").concat(M, ".").concat(+m + 1, ".0-0");
    } else {
      // ~1.2.3 == >=1.2.3 <1.3.0-0
      ret = ">=".concat(M, ".").concat(m, ".").concat(p, " <").concat(M, ".").concat(+m + 1, ".0-0");
    }
    debug('tilde return', ret);
    return ret;
  });
};

// ^ --> * (any, kinda silly)
// ^2, ^2.x, ^2.x.x --> >=2.0.0 <3.0.0-0
// ^2.0, ^2.0.x --> >=2.0.0 <3.0.0-0
// ^1.2, ^1.2.x --> >=1.2.0 <2.0.0-0
// ^1.2.3 --> >=1.2.3 <2.0.0-0
// ^1.2.0 --> >=1.2.0 <2.0.0-0
// ^0.0.1 --> >=0.0.1 <0.0.2-0
// ^0.1.0 --> >=0.1.0 <0.2.0-0
var replaceCarets = function replaceCarets(comp, options) {
  return comp.trim().split(/\s+/).map(function (c) {
    return replaceCaret(c, options);
  }).join(' ');
};
var replaceCaret = function replaceCaret(comp, options) {
  debug('caret', comp, options);
  var r = options.loose ? re[t.CARETLOOSE] : re[t.CARET];
  var z = options.includePrerelease ? '-0' : '';
  return comp.replace(r, function (_, M, m, p, pr) {
    debug('caret', comp, _, M, m, p, pr);
    var ret;
    if (isX(M)) {
      ret = '';
    } else if (isX(m)) {
      ret = ">=".concat(M, ".0.0").concat(z, " <").concat(+M + 1, ".0.0-0");
    } else if (isX(p)) {
      if (M === '0') {
        ret = ">=".concat(M, ".").concat(m, ".0").concat(z, " <").concat(M, ".").concat(+m + 1, ".0-0");
      } else {
        ret = ">=".concat(M, ".").concat(m, ".0").concat(z, " <").concat(+M + 1, ".0.0-0");
      }
    } else if (pr) {
      debug('replaceCaret pr', pr);
      if (M === '0') {
        if (m === '0') {
          ret = ">=".concat(M, ".").concat(m, ".").concat(p, "-").concat(pr, " <").concat(M, ".").concat(m, ".").concat(+p + 1, "-0");
        } else {
          ret = ">=".concat(M, ".").concat(m, ".").concat(p, "-").concat(pr, " <").concat(M, ".").concat(+m + 1, ".0-0");
        }
      } else {
        ret = ">=".concat(M, ".").concat(m, ".").concat(p, "-").concat(pr, " <").concat(+M + 1, ".0.0-0");
      }
    } else {
      debug('no pr');
      if (M === '0') {
        if (m === '0') {
          ret = ">=".concat(M, ".").concat(m, ".").concat(p).concat(z, " <").concat(M, ".").concat(m, ".").concat(+p + 1, "-0");
        } else {
          ret = ">=".concat(M, ".").concat(m, ".").concat(p).concat(z, " <").concat(M, ".").concat(+m + 1, ".0-0");
        }
      } else {
        ret = ">=".concat(M, ".").concat(m, ".").concat(p, " <").concat(+M + 1, ".0.0-0");
      }
    }
    debug('caret return', ret);
    return ret;
  });
};
var replaceXRanges = function replaceXRanges(comp, options) {
  debug('replaceXRanges', comp, options);
  return comp.split(/\s+/).map(function (c) {
    return replaceXRange(c, options);
  }).join(' ');
};
var replaceXRange = function replaceXRange(comp, options) {
  comp = comp.trim();
  var r = options.loose ? re[t.XRANGELOOSE] : re[t.XRANGE];
  return comp.replace(r, function (ret, gtlt, M, m, p, pr) {
    debug('xRange', comp, ret, gtlt, M, m, p, pr);
    var xM = isX(M);
    var xm = xM || isX(m);
    var xp = xm || isX(p);
    var anyX = xp;
    if (gtlt === '=' && anyX) {
      gtlt = '';
    }

    // if we're including prereleases in the match, then we need
    // to fix this to -0, the lowest possible prerelease value
    pr = options.includePrerelease ? '-0' : '';
    if (xM) {
      if (gtlt === '>' || gtlt === '<') {
        // nothing is allowed
        ret = '<0.0.0-0';
      } else {
        // nothing is forbidden
        ret = '*';
      }
    } else if (gtlt && anyX) {
      // we know patch is an x, because we have any x at all.
      // replace X with 0
      if (xm) {
        m = 0;
      }
      p = 0;
      if (gtlt === '>') {
        // >1 => >=2.0.0
        // >1.2 => >=1.3.0
        gtlt = '>=';
        if (xm) {
          M = +M + 1;
          m = 0;
          p = 0;
        } else {
          m = +m + 1;
          p = 0;
        }
      } else if (gtlt === '<=') {
        // <=0.7.x is actually <0.8.0, since any 0.7.x should
        // pass.  Similarly, <=7.x is actually <8.0.0, etc.
        gtlt = '<';
        if (xm) {
          M = +M + 1;
        } else {
          m = +m + 1;
        }
      }
      if (gtlt === '<') {
        pr = '-0';
      }
      ret = "".concat(gtlt + M, ".").concat(m, ".").concat(p).concat(pr);
    } else if (xm) {
      ret = ">=".concat(M, ".0.0").concat(pr, " <").concat(+M + 1, ".0.0-0");
    } else if (xp) {
      ret = ">=".concat(M, ".").concat(m, ".0").concat(pr, " <").concat(M, ".").concat(+m + 1, ".0-0");
    }
    debug('xRange return', ret);
    return ret;
  });
};

// Because * is AND-ed with everything else in the comparator,
// and '' means "any version", just remove the *s entirely.
var replaceStars = function replaceStars(comp, options) {
  debug('replaceStars', comp, options);
  // Looseness is ignored here.  star is always as loose as it gets!
  return comp.trim().replace(re[t.STAR], '');
};
var replaceGTE0 = function replaceGTE0(comp, options) {
  debug('replaceGTE0', comp, options);
  return comp.trim().replace(re[options.includePrerelease ? t.GTE0PRE : t.GTE0], '');
};

// This function is passed to string.replace(re[t.HYPHENRANGE])
// M, m, patch, prerelease, build
// 1.2 - 3.4.5 => >=1.2.0 <=3.4.5
// 1.2.3 - 3.4 => >=1.2.0 <3.5.0-0 Any 3.4.x will do
// 1.2 - 3.4 => >=1.2.0 <3.5.0-0
var hyphenReplace = function hyphenReplace(incPr) {
  return function ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) {
    if (isX(fM)) {
      from = '';
    } else if (isX(fm)) {
      from = ">=".concat(fM, ".0.0").concat(incPr ? '-0' : '');
    } else if (isX(fp)) {
      from = ">=".concat(fM, ".").concat(fm, ".0").concat(incPr ? '-0' : '');
    } else if (fpr) {
      from = ">=".concat(from);
    } else {
      from = ">=".concat(from).concat(incPr ? '-0' : '');
    }
    if (isX(tM)) {
      to = '';
    } else if (isX(tm)) {
      to = "<".concat(+tM + 1, ".0.0-0");
    } else if (isX(tp)) {
      to = "<".concat(tM, ".").concat(+tm + 1, ".0-0");
    } else if (tpr) {
      to = "<=".concat(tM, ".").concat(tm, ".").concat(tp, "-").concat(tpr);
    } else if (incPr) {
      to = "<".concat(tM, ".").concat(tm, ".").concat(+tp + 1, "-0");
    } else {
      to = "<=".concat(to);
    }
    return "".concat(from, " ").concat(to).trim();
  };
};
var testSet = function testSet(set, version, options) {
  for (var i = 0; i < set.length; i++) {
    if (!set[i].test(version)) {
      return false;
    }
  }
  if (version.prerelease.length && !options.includePrerelease) {
    // Find the set of versions that are allowed to have prereleases
    // For example, ^1.2.3-pr.1 desugars to >=1.2.3-pr.1 <2.0.0
    // That should allow `1.2.3-pr.2` to pass.
    // However, `1.2.4-alpha.notready` should NOT be allowed,
    // even though it's within the range set by the comparators.
    for (var _i = 0; _i < set.length; _i++) {
      debug(set[_i].semver);
      if (set[_i].semver === Comparator.ANY) {
        continue;
      }
      if (set[_i].semver.prerelease.length > 0) {
        var allowed = set[_i].semver;
        if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
          return true;
        }
      }
    }

    // Version has a -pre, but it's not one of the ones we like.
    return false;
  }
  return true;
};

/***/ }),

/***/ 1186:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var _classCallCheck = (__webpack_require__(8403)["default"]);
var _createClass = (__webpack_require__(2467)["default"]);
var debug = __webpack_require__(6298);
var _require = __webpack_require__(6028),
  MAX_LENGTH = _require.MAX_LENGTH,
  MAX_SAFE_INTEGER = _require.MAX_SAFE_INTEGER;
var _require2 = __webpack_require__(8369),
  re = _require2.re,
  t = _require2.t;
var parseOptions = __webpack_require__(504);
var _require3 = __webpack_require__(1399),
  compareIdentifiers = _require3.compareIdentifiers;
var SemVer = /*#__PURE__*/function () {
  "use strict";

  function SemVer(version, options) {
    _classCallCheck(this, SemVer);
    options = parseOptions(options);
    if (version instanceof SemVer) {
      if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
        return version;
      } else {
        version = version.version;
      }
    } else if (typeof version !== 'string') {
      throw new TypeError("Invalid Version: ".concat(version));
    }
    if (version.length > MAX_LENGTH) {
      throw new TypeError("version is longer than ".concat(MAX_LENGTH, " characters"));
    }
    debug('SemVer', version, options);
    this.options = options;
    this.loose = !!options.loose;
    // this isn't actually relevant for versions, but keep it so that we
    // don't run into trouble passing this.options around.
    this.includePrerelease = !!options.includePrerelease;
    var m = version.trim().match(options.loose ? re[t.LOOSE] : re[t.FULL]);
    if (!m) {
      throw new TypeError("Invalid Version: ".concat(version));
    }
    this.raw = version;

    // these are actually numbers
    this.major = +m[1];
    this.minor = +m[2];
    this.patch = +m[3];
    if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
      throw new TypeError('Invalid major version');
    }
    if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
      throw new TypeError('Invalid minor version');
    }
    if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
      throw new TypeError('Invalid patch version');
    }

    // numberify any prerelease numeric ids
    if (!m[4]) {
      this.prerelease = [];
    } else {
      this.prerelease = m[4].split('.').map(function (id) {
        if (/^[0-9]+$/.test(id)) {
          var num = +id;
          if (num >= 0 && num < MAX_SAFE_INTEGER) {
            return num;
          }
        }
        return id;
      });
    }
    this.build = m[5] ? m[5].split('.') : [];
    this.format();
  }
  _createClass(SemVer, [{
    key: "format",
    value: function format() {
      this.version = "".concat(this.major, ".").concat(this.minor, ".").concat(this.patch);
      if (this.prerelease.length) {
        this.version += "-".concat(this.prerelease.join('.'));
      }
      return this.version;
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.version;
    }
  }, {
    key: "compare",
    value: function compare(other) {
      debug('SemVer.compare', this.version, this.options, other);
      if (!(other instanceof SemVer)) {
        if (typeof other === 'string' && other === this.version) {
          return 0;
        }
        other = new SemVer(other, this.options);
      }
      if (other.version === this.version) {
        return 0;
      }
      return this.compareMain(other) || this.comparePre(other);
    }
  }, {
    key: "compareMain",
    value: function compareMain(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
    }
  }, {
    key: "comparePre",
    value: function comparePre(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }

      // NOT having a prerelease is > having one
      if (this.prerelease.length && !other.prerelease.length) {
        return -1;
      } else if (!this.prerelease.length && other.prerelease.length) {
        return 1;
      } else if (!this.prerelease.length && !other.prerelease.length) {
        return 0;
      }
      var i = 0;
      do {
        var a = this.prerelease[i];
        var b = other.prerelease[i];
        debug('prerelease compare', i, a, b);
        if (a === undefined && b === undefined) {
          return 0;
        } else if (b === undefined) {
          return 1;
        } else if (a === undefined) {
          return -1;
        } else if (a === b) {
          continue;
        } else {
          return compareIdentifiers(a, b);
        }
      } while (++i);
    }
  }, {
    key: "compareBuild",
    value: function compareBuild(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      var i = 0;
      do {
        var a = this.build[i];
        var b = other.build[i];
        debug('prerelease compare', i, a, b);
        if (a === undefined && b === undefined) {
          return 0;
        } else if (b === undefined) {
          return 1;
        } else if (a === undefined) {
          return -1;
        } else if (a === b) {
          continue;
        } else {
          return compareIdentifiers(a, b);
        }
      } while (++i);
    }

    // preminor will bump the version up to the next minor release, and immediately
    // down to pre-release. premajor and prepatch work the same way.
  }, {
    key: "inc",
    value: function inc(release, identifier, identifierBase) {
      switch (release) {
        case 'premajor':
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor = 0;
          this.major++;
          this.inc('pre', identifier, identifierBase);
          break;
        case 'preminor':
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor++;
          this.inc('pre', identifier, identifierBase);
          break;
        case 'prepatch':
          // If this is already a prerelease, it will bump to the next version
          // drop any prereleases that might already exist, since they are not
          // relevant at this point.
          this.prerelease.length = 0;
          this.inc('patch', identifier, identifierBase);
          this.inc('pre', identifier, identifierBase);
          break;
        // If the input is a non-prerelease version, this acts the same as
        // prepatch.
        case 'prerelease':
          if (this.prerelease.length === 0) {
            this.inc('patch', identifier, identifierBase);
          }
          this.inc('pre', identifier, identifierBase);
          break;
        case 'major':
          // If this is a pre-major version, bump up to the same major version.
          // Otherwise increment major.
          // 1.0.0-5 bumps to 1.0.0
          // 1.1.0 bumps to 2.0.0
          if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
            this.major++;
          }
          this.minor = 0;
          this.patch = 0;
          this.prerelease = [];
          break;
        case 'minor':
          // If this is a pre-minor version, bump up to the same minor version.
          // Otherwise increment minor.
          // 1.2.0-5 bumps to 1.2.0
          // 1.2.1 bumps to 1.3.0
          if (this.patch !== 0 || this.prerelease.length === 0) {
            this.minor++;
          }
          this.patch = 0;
          this.prerelease = [];
          break;
        case 'patch':
          // If this is not a pre-release version, it will increment the patch.
          // If it is a pre-release it will bump up to the same patch version.
          // 1.2.0-5 patches to 1.2.0
          // 1.2.0 patches to 1.2.1
          if (this.prerelease.length === 0) {
            this.patch++;
          }
          this.prerelease = [];
          break;
        // This probably shouldn't be used publicly.
        // 1.0.0 'pre' would become 1.0.0-0 which is the wrong direction.
        case 'pre':
          if (this.prerelease.length === 0) {
            this.prerelease = [0];
          } else {
            var i = this.prerelease.length;
            while (--i >= 0) {
              if (typeof this.prerelease[i] === 'number') {
                this.prerelease[i]++;
                i = -2;
              }
            }
            if (i === -1) {
              // didn't increment anything
              this.prerelease.push(0);
            }
          }
          if (identifier) {
            var base = Number(identifierBase) ? 1 : 0;
            // 1.2.0-beta.1 bumps to 1.2.0-beta.2,
            // 1.2.0-beta.fooblz or 1.2.0-beta bumps to 1.2.0-beta.0
            if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
              if (isNaN(this.prerelease[1])) {
                this.prerelease = [identifier, base];
              }
            } else {
              this.prerelease = [identifier, base];
            }
          }
          break;
        default:
          throw new Error("invalid increment argument: ".concat(release));
      }
      this.format();
      this.raw = this.version;
      return this;
    }
  }]);
  return SemVer;
}();
module.exports = SemVer;

/***/ }),

/***/ 4129:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var parse = __webpack_require__(9050);
var clean = function clean(version, options) {
  var s = parse(version.trim().replace(/^[=v]+/, ''), options);
  return s ? s.version : null;
};
module.exports = clean;

/***/ }),

/***/ 9900:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var eq = __webpack_require__(488);
var neq = __webpack_require__(5956);
var gt = __webpack_require__(1524);
var gte = __webpack_require__(7488);
var lt = __webpack_require__(4025);
var lte = __webpack_require__(4518);
var cmp = function cmp(a, op, b, loose) {
  switch (op) {
    case '===':
      if (typeof a === 'object') {
        a = a.version;
      }
      if (typeof b === 'object') {
        b = b.version;
      }
      return a === b;
    case '!==':
      if (typeof a === 'object') {
        a = a.version;
      }
      if (typeof b === 'object') {
        b = b.version;
      }
      return a !== b;
    case '':
    case '=':
    case '==':
      return eq(a, b, loose);
    case '!=':
      return neq(a, b, loose);
    case '>':
      return gt(a, b, loose);
    case '>=':
      return gte(a, b, loose);
    case '<':
      return lt(a, b, loose);
    case '<=':
      return lte(a, b, loose);
    default:
      throw new TypeError("Invalid operator: ".concat(op));
  }
};
module.exports = cmp;

/***/ }),

/***/ 4349:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var parse = __webpack_require__(9050);
var _require = __webpack_require__(8369),
  re = _require.re,
  t = _require.t;
var coerce = function coerce(version, options) {
  if (version instanceof SemVer) {
    return version;
  }
  if (typeof version === 'number') {
    version = String(version);
  }
  if (typeof version !== 'string') {
    return null;
  }
  options = options || {};
  var match = null;
  if (!options.rtl) {
    match = version.match(re[t.COERCE]);
  } else {
    // Find the right-most coercible string that does not share
    // a terminus with a more left-ward coercible string.
    // Eg, '1.2.3.4' wants to coerce '2.3.4', not '3.4' or '4'
    //
    // Walk through the string checking with a /g regexp
    // Manually set the index so as to pick up overlapping matches.
    // Stop when we get a match that ends at the string end, since no
    // coercible string can be more right-ward without the same terminus.
    var next;
    while ((next = re[t.COERCERTL].exec(version)) && (!match || match.index + match[0].length !== version.length)) {
      if (!match || next.index + next[0].length !== match.index + match[0].length) {
        match = next;
      }
      re[t.COERCERTL].lastIndex = next.index + next[1].length + next[2].length;
    }
    // leave it in a clean state
    re[t.COERCERTL].lastIndex = -1;
  }
  if (match === null) {
    return null;
  }
  return parse("".concat(match[2], ".").concat(match[3] || '0', ".").concat(match[4] || '0'), options);
};
module.exports = coerce;

/***/ }),

/***/ 1999:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var compareBuild = function compareBuild(a, b, loose) {
  var versionA = new SemVer(a, loose);
  var versionB = new SemVer(b, loose);
  return versionA.compare(versionB) || versionA.compareBuild(versionB);
};
module.exports = compareBuild;

/***/ }),

/***/ 6368:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compare = __webpack_require__(1119);
var compareLoose = function compareLoose(a, b) {
  return compare(a, b, true);
};
module.exports = compareLoose;

/***/ }),

/***/ 1119:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var compare = function compare(a, b, loose) {
  return new SemVer(a, loose).compare(new SemVer(b, loose));
};
module.exports = compare;

/***/ }),

/***/ 754:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var parse = __webpack_require__(9050);
var eq = __webpack_require__(488);
var diff = function diff(version1, version2) {
  var v1 = parse(version1);
  var v2 = parse(version2);
  if (eq(v1, v2)) {
    return null;
  } else {
    var hasPre = v1.prerelease.length || v2.prerelease.length;
    var prefix = hasPre ? 'pre' : '';
    var defaultResult = hasPre ? 'prerelease' : '';
    if (v1.major !== v2.major) {
      return prefix + 'major';
    }
    if (v1.minor !== v2.minor) {
      return prefix + 'minor';
    }
    if (v1.patch !== v2.patch) {
      return prefix + 'patch';
    }
    if (!v1.prerelease.length || !v2.prerelease.length) {
      if (v1.patch) {
        return 'patch';
      }
      if (v1.minor) {
        return 'minor';
      }
      if (v1.major) {
        return 'major';
      }
    }
    return defaultResult; // may be undefined
  }
};

module.exports = diff;

/***/ }),

/***/ 488:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compare = __webpack_require__(1119);
var eq = function eq(a, b, loose) {
  return compare(a, b, loose) === 0;
};
module.exports = eq;

/***/ }),

/***/ 1524:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compare = __webpack_require__(1119);
var gt = function gt(a, b, loose) {
  return compare(a, b, loose) > 0;
};
module.exports = gt;

/***/ }),

/***/ 7488:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compare = __webpack_require__(1119);
var gte = function gte(a, b, loose) {
  return compare(a, b, loose) >= 0;
};
module.exports = gte;

/***/ }),

/***/ 5574:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var inc = function inc(version, release, options, identifier, identifierBase) {
  if (typeof options === 'string') {
    identifierBase = identifier;
    identifier = options;
    options = undefined;
  }
  try {
    return new SemVer(version instanceof SemVer ? version.version : version, options).inc(release, identifier, identifierBase).version;
  } catch (er) {
    return null;
  }
};
module.exports = inc;

/***/ }),

/***/ 4025:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compare = __webpack_require__(1119);
var lt = function lt(a, b, loose) {
  return compare(a, b, loose) < 0;
};
module.exports = lt;

/***/ }),

/***/ 4518:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compare = __webpack_require__(1119);
var lte = function lte(a, b, loose) {
  return compare(a, b, loose) <= 0;
};
module.exports = lte;

/***/ }),

/***/ 9715:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var major = function major(a, loose) {
  return new SemVer(a, loose).major;
};
module.exports = major;

/***/ }),

/***/ 2303:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var minor = function minor(a, loose) {
  return new SemVer(a, loose).minor;
};
module.exports = minor;

/***/ }),

/***/ 5956:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compare = __webpack_require__(1119);
var neq = function neq(a, b, loose) {
  return compare(a, b, loose) !== 0;
};
module.exports = neq;

/***/ }),

/***/ 9050:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var _require = __webpack_require__(6028),
  MAX_LENGTH = _require.MAX_LENGTH;
var SemVer = __webpack_require__(1186);
var parse = function parse(version, options) {
  if (version instanceof SemVer) {
    return version;
  }
  if (typeof version !== 'string') {
    return null;
  }
  if (version.length > MAX_LENGTH) {
    return null;
  }
  try {
    return new SemVer(version, options);
  } catch (er) {
    return null;
  }
};
module.exports = parse;

/***/ }),

/***/ 8210:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var patch = function patch(a, loose) {
  return new SemVer(a, loose).patch;
};
module.exports = patch;

/***/ }),

/***/ 2161:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var parse = __webpack_require__(9050);
var prerelease = function prerelease(version, options) {
  var parsed = parse(version, options);
  return parsed && parsed.prerelease.length ? parsed.prerelease : null;
};
module.exports = prerelease;

/***/ }),

/***/ 4698:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compare = __webpack_require__(1119);
var rcompare = function rcompare(a, b, loose) {
  return compare(b, a, loose);
};
module.exports = rcompare;

/***/ }),

/***/ 7331:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compareBuild = __webpack_require__(1999);
var rsort = function rsort(list, loose) {
  return list.sort(function (a, b) {
    return compareBuild(b, a, loose);
  });
};
module.exports = rsort;

/***/ }),

/***/ 3597:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var Range = __webpack_require__(7258);
var satisfies = function satisfies(version, range, options) {
  try {
    range = new Range(range, options);
  } catch (er) {
    return false;
  }
  return range.test(version);
};
module.exports = satisfies;

/***/ }),

/***/ 8097:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var compareBuild = __webpack_require__(1999);
var sort = function sort(list, loose) {
  return list.sort(function (a, b) {
    return compareBuild(a, b, loose);
  });
};
module.exports = sort;

/***/ }),

/***/ 1635:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var parse = __webpack_require__(9050);
var valid = function valid(version, options) {
  var v = parse(version, options);
  return v ? v.version : null;
};
module.exports = valid;

/***/ }),

/***/ 9383:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

// just pre-load all the stuff that index.js lazily exports
var internalRe = __webpack_require__(8369);
var constants = __webpack_require__(6028);
var SemVer = __webpack_require__(1186);
var identifiers = __webpack_require__(1399);
var parse = __webpack_require__(9050);
var valid = __webpack_require__(1635);
var clean = __webpack_require__(4129);
var inc = __webpack_require__(5574);
var diff = __webpack_require__(754);
var major = __webpack_require__(9715);
var minor = __webpack_require__(2303);
var patch = __webpack_require__(8210);
var prerelease = __webpack_require__(2161);
var compare = __webpack_require__(1119);
var rcompare = __webpack_require__(4698);
var compareLoose = __webpack_require__(6368);
var compareBuild = __webpack_require__(1999);
var sort = __webpack_require__(8097);
var rsort = __webpack_require__(7331);
var gt = __webpack_require__(1524);
var lt = __webpack_require__(4025);
var eq = __webpack_require__(488);
var neq = __webpack_require__(5956);
var gte = __webpack_require__(7488);
var lte = __webpack_require__(4518);
var cmp = __webpack_require__(9900);
var coerce = __webpack_require__(4349);
var Comparator = __webpack_require__(301);
var Range = __webpack_require__(7258);
var satisfies = __webpack_require__(3597);
var toComparators = __webpack_require__(9002);
var maxSatisfying = __webpack_require__(3711);
var minSatisfying = __webpack_require__(7245);
var minVersion = __webpack_require__(9074);
var validRange = __webpack_require__(5359);
var outside = __webpack_require__(8815);
var gtr = __webpack_require__(46);
var ltr = __webpack_require__(6062);
var intersects = __webpack_require__(9378);
var simplifyRange = __webpack_require__(4989);
var subset = __webpack_require__(8701);
module.exports = {
  parse: parse,
  valid: valid,
  clean: clean,
  inc: inc,
  diff: diff,
  major: major,
  minor: minor,
  patch: patch,
  prerelease: prerelease,
  compare: compare,
  rcompare: rcompare,
  compareLoose: compareLoose,
  compareBuild: compareBuild,
  sort: sort,
  rsort: rsort,
  gt: gt,
  lt: lt,
  eq: eq,
  neq: neq,
  gte: gte,
  lte: lte,
  cmp: cmp,
  coerce: coerce,
  Comparator: Comparator,
  Range: Range,
  satisfies: satisfies,
  toComparators: toComparators,
  maxSatisfying: maxSatisfying,
  minSatisfying: minSatisfying,
  minVersion: minVersion,
  validRange: validRange,
  outside: outside,
  gtr: gtr,
  ltr: ltr,
  intersects: intersects,
  simplifyRange: simplifyRange,
  subset: subset,
  SemVer: SemVer,
  re: internalRe.re,
  src: internalRe.src,
  tokens: internalRe.t,
  SEMVER_SPEC_VERSION: constants.SEMVER_SPEC_VERSION,
  RELEASE_TYPES: constants.RELEASE_TYPES,
  compareIdentifiers: identifiers.compareIdentifiers,
  rcompareIdentifiers: identifiers.rcompareIdentifiers
};

/***/ }),

/***/ 6028:
/***/ (function(module) {

// Note: this is the semver.org version of the spec that it implements
// Not necessarily the package version of this code.
var SEMVER_SPEC_VERSION = '2.0.0';
var MAX_LENGTH = 256;
var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */9007199254740991;

// Max safe segment length for coercion.
var MAX_SAFE_COMPONENT_LENGTH = 16;
var RELEASE_TYPES = ['major', 'premajor', 'minor', 'preminor', 'patch', 'prepatch', 'prerelease'];
module.exports = {
  MAX_LENGTH: MAX_LENGTH,
  MAX_SAFE_COMPONENT_LENGTH: MAX_SAFE_COMPONENT_LENGTH,
  MAX_SAFE_INTEGER: MAX_SAFE_INTEGER,
  RELEASE_TYPES: RELEASE_TYPES,
  SEMVER_SPEC_VERSION: SEMVER_SPEC_VERSION,
  FLAG_INCLUDE_PRERELEASE: 1,
  FLAG_LOOSE: 2
};

/***/ }),

/***/ 6298:
/***/ (function(module) {

var debug = typeof process === 'object' && ({"NODE_ENV":"production","PUBLIC_URL":"","WDS_SOCKET_HOST":undefined,"WDS_SOCKET_PATH":undefined,"WDS_SOCKET_PORT":undefined,"FAST_REFRESH":true,"REACT_APP_SERVER_ENV":"prod","REACT_APP_INSTALL_MODE":"developer","REACT_APP_PUBLISH_NAME":"publicServer"}) && ({"NODE_ENV":"production","PUBLIC_URL":"","WDS_SOCKET_HOST":undefined,"WDS_SOCKET_PATH":undefined,"WDS_SOCKET_PORT":undefined,"FAST_REFRESH":true,"REACT_APP_SERVER_ENV":"prod","REACT_APP_INSTALL_MODE":"developer","REACT_APP_PUBLISH_NAME":"publicServer"}).NODE_DEBUG && /\bsemver\b/i.test(({"NODE_ENV":"production","PUBLIC_URL":"","WDS_SOCKET_HOST":undefined,"WDS_SOCKET_PATH":undefined,"WDS_SOCKET_PORT":undefined,"FAST_REFRESH":true,"REACT_APP_SERVER_ENV":"prod","REACT_APP_INSTALL_MODE":"developer","REACT_APP_PUBLISH_NAME":"publicServer"}).NODE_DEBUG) ? function () {
  var _console;
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  return (_console = console).error.apply(_console, ['SEMVER'].concat(args));
} : function () {};
module.exports = debug;

/***/ }),

/***/ 1399:
/***/ (function(module) {

var numeric = /^[0-9]+$/;
var compareIdentifiers = function compareIdentifiers(a, b) {
  var anum = numeric.test(a);
  var bnum = numeric.test(b);
  if (anum && bnum) {
    a = +a;
    b = +b;
  }
  return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
};
var rcompareIdentifiers = function rcompareIdentifiers(a, b) {
  return compareIdentifiers(b, a);
};
module.exports = {
  compareIdentifiers: compareIdentifiers,
  rcompareIdentifiers: rcompareIdentifiers
};

/***/ }),

/***/ 504:
/***/ (function(module) {

// parse out just the options we care about
var looseOption = Object.freeze({
  loose: true
});
var emptyOpts = Object.freeze({});
var parseOptions = function parseOptions(options) {
  if (!options) {
    return emptyOpts;
  }
  if (typeof options !== 'object') {
    return looseOption;
  }
  return options;
};
module.exports = parseOptions;

/***/ }),

/***/ 8369:
/***/ (function(module, exports, __webpack_require__) {

var _require = __webpack_require__(6028),
  MAX_SAFE_COMPONENT_LENGTH = _require.MAX_SAFE_COMPONENT_LENGTH;
var debug = __webpack_require__(6298);
exports = module.exports = {};

// The actual regexps go on exports.re
var re = exports.re = [];
var src = exports.src = [];
var t = exports.t = {};
var R = 0;
var createToken = function createToken(name, value, isGlobal) {
  var index = R++;
  debug(name, index, value);
  t[name] = index;
  src[index] = value;
  re[index] = new RegExp(value, isGlobal ? 'g' : undefined);
};

// The following Regular Expressions can be used for tokenizing,
// validating, and parsing SemVer version strings.

// ## Numeric Identifier
// A single `0`, or a non-zero digit followed by zero or more digits.

createToken('NUMERICIDENTIFIER', '0|[1-9]\\d*');
createToken('NUMERICIDENTIFIERLOOSE', '[0-9]+');

// ## Non-numeric Identifier
// Zero or more digits, followed by a letter or hyphen, and then zero or
// more letters, digits, or hyphens.

createToken('NONNUMERICIDENTIFIER', '\\d*[a-zA-Z-][a-zA-Z0-9-]*');

// ## Main Version
// Three dot-separated numeric identifiers.

createToken('MAINVERSION', "(".concat(src[t.NUMERICIDENTIFIER], ")\\.") + "(".concat(src[t.NUMERICIDENTIFIER], ")\\.") + "(".concat(src[t.NUMERICIDENTIFIER], ")"));
createToken('MAINVERSIONLOOSE', "(".concat(src[t.NUMERICIDENTIFIERLOOSE], ")\\.") + "(".concat(src[t.NUMERICIDENTIFIERLOOSE], ")\\.") + "(".concat(src[t.NUMERICIDENTIFIERLOOSE], ")"));

// ## Pre-release Version Identifier
// A numeric identifier, or a non-numeric identifier.

createToken('PRERELEASEIDENTIFIER', "(?:".concat(src[t.NUMERICIDENTIFIER], "|").concat(src[t.NONNUMERICIDENTIFIER], ")"));
createToken('PRERELEASEIDENTIFIERLOOSE', "(?:".concat(src[t.NUMERICIDENTIFIERLOOSE], "|").concat(src[t.NONNUMERICIDENTIFIER], ")"));

// ## Pre-release Version
// Hyphen, followed by one or more dot-separated pre-release version
// identifiers.

createToken('PRERELEASE', "(?:-(".concat(src[t.PRERELEASEIDENTIFIER], "(?:\\.").concat(src[t.PRERELEASEIDENTIFIER], ")*))"));
createToken('PRERELEASELOOSE', "(?:-?(".concat(src[t.PRERELEASEIDENTIFIERLOOSE], "(?:\\.").concat(src[t.PRERELEASEIDENTIFIERLOOSE], ")*))"));

// ## Build Metadata Identifier
// Any combination of digits, letters, or hyphens.

createToken('BUILDIDENTIFIER', '[0-9A-Za-z-]+');

// ## Build Metadata
// Plus sign, followed by one or more period-separated build metadata
// identifiers.

createToken('BUILD', "(?:\\+(".concat(src[t.BUILDIDENTIFIER], "(?:\\.").concat(src[t.BUILDIDENTIFIER], ")*))"));

// ## Full Version String
// A main version, followed optionally by a pre-release version and
// build metadata.

// Note that the only major, minor, patch, and pre-release sections of
// the version string are capturing groups.  The build metadata is not a
// capturing group, because it should not ever be used in version
// comparison.

createToken('FULLPLAIN', "v?".concat(src[t.MAINVERSION]).concat(src[t.PRERELEASE], "?").concat(src[t.BUILD], "?"));
createToken('FULL', "^".concat(src[t.FULLPLAIN], "$"));

// like full, but allows v1.2.3 and =1.2.3, which people do sometimes.
// also, 1.0.0alpha1 (prerelease without the hyphen) which is pretty
// common in the npm registry.
createToken('LOOSEPLAIN', "[v=\\s]*".concat(src[t.MAINVERSIONLOOSE]).concat(src[t.PRERELEASELOOSE], "?").concat(src[t.BUILD], "?"));
createToken('LOOSE', "^".concat(src[t.LOOSEPLAIN], "$"));
createToken('GTLT', '((?:<|>)?=?)');

// Something like "2.*" or "1.2.x".
// Note that "x.x" is a valid xRange identifer, meaning "any version"
// Only the first item is strictly required.
createToken('XRANGEIDENTIFIERLOOSE', "".concat(src[t.NUMERICIDENTIFIERLOOSE], "|x|X|\\*"));
createToken('XRANGEIDENTIFIER', "".concat(src[t.NUMERICIDENTIFIER], "|x|X|\\*"));
createToken('XRANGEPLAIN', "[v=\\s]*(".concat(src[t.XRANGEIDENTIFIER], ")") + "(?:\\.(".concat(src[t.XRANGEIDENTIFIER], ")") + "(?:\\.(".concat(src[t.XRANGEIDENTIFIER], ")") + "(?:".concat(src[t.PRERELEASE], ")?").concat(src[t.BUILD], "?") + ")?)?");
createToken('XRANGEPLAINLOOSE', "[v=\\s]*(".concat(src[t.XRANGEIDENTIFIERLOOSE], ")") + "(?:\\.(".concat(src[t.XRANGEIDENTIFIERLOOSE], ")") + "(?:\\.(".concat(src[t.XRANGEIDENTIFIERLOOSE], ")") + "(?:".concat(src[t.PRERELEASELOOSE], ")?").concat(src[t.BUILD], "?") + ")?)?");
createToken('XRANGE', "^".concat(src[t.GTLT], "\\s*").concat(src[t.XRANGEPLAIN], "$"));
createToken('XRANGELOOSE', "^".concat(src[t.GTLT], "\\s*").concat(src[t.XRANGEPLAINLOOSE], "$"));

// Coercion.
// Extract anything that could conceivably be a part of a valid semver
createToken('COERCE', "".concat('(^|[^\\d])' + '(\\d{1,').concat(MAX_SAFE_COMPONENT_LENGTH, "})") + "(?:\\.(\\d{1,".concat(MAX_SAFE_COMPONENT_LENGTH, "}))?") + "(?:\\.(\\d{1,".concat(MAX_SAFE_COMPONENT_LENGTH, "}))?") + "(?:$|[^\\d])");
createToken('COERCERTL', src[t.COERCE], true);

// Tilde ranges.
// Meaning is "reasonably at or greater than"
createToken('LONETILDE', '(?:~>?)');
createToken('TILDETRIM', "(\\s*)".concat(src[t.LONETILDE], "\\s+"), true);
exports.tildeTrimReplace = '$1~';
createToken('TILDE', "^".concat(src[t.LONETILDE]).concat(src[t.XRANGEPLAIN], "$"));
createToken('TILDELOOSE', "^".concat(src[t.LONETILDE]).concat(src[t.XRANGEPLAINLOOSE], "$"));

// Caret ranges.
// Meaning is "at least and backwards compatible with"
createToken('LONECARET', '(?:\\^)');
createToken('CARETTRIM', "(\\s*)".concat(src[t.LONECARET], "\\s+"), true);
exports.caretTrimReplace = '$1^';
createToken('CARET', "^".concat(src[t.LONECARET]).concat(src[t.XRANGEPLAIN], "$"));
createToken('CARETLOOSE', "^".concat(src[t.LONECARET]).concat(src[t.XRANGEPLAINLOOSE], "$"));

// A simple gt/lt/eq thing, or just "" to indicate "any version"
createToken('COMPARATORLOOSE', "^".concat(src[t.GTLT], "\\s*(").concat(src[t.LOOSEPLAIN], ")$|^$"));
createToken('COMPARATOR', "^".concat(src[t.GTLT], "\\s*(").concat(src[t.FULLPLAIN], ")$|^$"));

// An expression to strip any whitespace between the gtlt and the thing
// it modifies, so that `> 1.2.3` ==> `>1.2.3`
createToken('COMPARATORTRIM', "(\\s*)".concat(src[t.GTLT], "\\s*(").concat(src[t.LOOSEPLAIN], "|").concat(src[t.XRANGEPLAIN], ")"), true);
exports.comparatorTrimReplace = '$1$2$3';

// Something like `1.2.3 - 1.2.4`
// Note that these all use the loose form, because they'll be
// checked against either the strict or loose comparator form
// later.
createToken('HYPHENRANGE', "^\\s*(".concat(src[t.XRANGEPLAIN], ")") + "\\s+-\\s+" + "(".concat(src[t.XRANGEPLAIN], ")") + "\\s*$");
createToken('HYPHENRANGELOOSE', "^\\s*(".concat(src[t.XRANGEPLAINLOOSE], ")") + "\\s+-\\s+" + "(".concat(src[t.XRANGEPLAINLOOSE], ")") + "\\s*$");

// Star ranges basically just allow anything at all.
createToken('STAR', '(<|>)?=?\\s*\\*');
// >=0.0.0 is like a star
createToken('GTE0', '^\\s*>=\\s*0\\.0\\.0\\s*$');
createToken('GTE0PRE', '^\\s*>=\\s*0\\.0\\.0-0\\s*$');

/***/ }),

/***/ 46:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

// Determine if version is greater than all the versions possible in the range.
var outside = __webpack_require__(8815);
var gtr = function gtr(version, range, options) {
  return outside(version, range, '>', options);
};
module.exports = gtr;

/***/ }),

/***/ 9378:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var Range = __webpack_require__(7258);
var intersects = function intersects(r1, r2, options) {
  r1 = new Range(r1, options);
  r2 = new Range(r2, options);
  return r1.intersects(r2, options);
};
module.exports = intersects;

/***/ }),

/***/ 6062:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var outside = __webpack_require__(8815);
// Determine if version is less than all the versions possible in the range
var ltr = function ltr(version, range, options) {
  return outside(version, range, '<', options);
};
module.exports = ltr;

/***/ }),

/***/ 3711:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var Range = __webpack_require__(7258);
var maxSatisfying = function maxSatisfying(versions, range, options) {
  var max = null;
  var maxSV = null;
  var rangeObj = null;
  try {
    rangeObj = new Range(range, options);
  } catch (er) {
    return null;
  }
  versions.forEach(function (v) {
    if (rangeObj.test(v)) {
      // satisfies(v, range, options)
      if (!max || maxSV.compare(v) === -1) {
        // compare(max, v, true)
        max = v;
        maxSV = new SemVer(max, options);
      }
    }
  });
  return max;
};
module.exports = maxSatisfying;

/***/ }),

/***/ 7245:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var Range = __webpack_require__(7258);
var minSatisfying = function minSatisfying(versions, range, options) {
  var min = null;
  var minSV = null;
  var rangeObj = null;
  try {
    rangeObj = new Range(range, options);
  } catch (er) {
    return null;
  }
  versions.forEach(function (v) {
    if (rangeObj.test(v)) {
      // satisfies(v, range, options)
      if (!min || minSV.compare(v) === 1) {
        // compare(min, v, true)
        min = v;
        minSV = new SemVer(min, options);
      }
    }
  });
  return min;
};
module.exports = minSatisfying;

/***/ }),

/***/ 9074:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var Range = __webpack_require__(7258);
var gt = __webpack_require__(1524);
var minVersion = function minVersion(range, loose) {
  range = new Range(range, loose);
  var minver = new SemVer('0.0.0');
  if (range.test(minver)) {
    return minver;
  }
  minver = new SemVer('0.0.0-0');
  if (range.test(minver)) {
    return minver;
  }
  minver = null;
  var _loop = function _loop() {
    var comparators = range.set[i];
    var setMin = null;
    comparators.forEach(function (comparator) {
      // Clone to avoid manipulating the comparator's semver object.
      var compver = new SemVer(comparator.semver.version);
      switch (comparator.operator) {
        case '>':
          if (compver.prerelease.length === 0) {
            compver.patch++;
          } else {
            compver.prerelease.push(0);
          }
          compver.raw = compver.format();
        /* fallthrough */
        case '':
        case '>=':
          if (!setMin || gt(compver, setMin)) {
            setMin = compver;
          }
          break;
        case '<':
        case '<=':
          /* Ignore maximum versions */
          break;
        /* istanbul ignore next */
        default:
          throw new Error("Unexpected operation: ".concat(comparator.operator));
      }
    });
    if (setMin && (!minver || gt(minver, setMin))) {
      minver = setMin;
    }
  };
  for (var i = 0; i < range.set.length; ++i) {
    _loop();
  }
  if (minver && range.test(minver)) {
    return minver;
  }
  return null;
};
module.exports = minVersion;

/***/ }),

/***/ 8815:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var SemVer = __webpack_require__(1186);
var Comparator = __webpack_require__(301);
var ANY = Comparator.ANY;
var Range = __webpack_require__(7258);
var satisfies = __webpack_require__(3597);
var gt = __webpack_require__(1524);
var lt = __webpack_require__(4025);
var lte = __webpack_require__(4518);
var gte = __webpack_require__(7488);
var outside = function outside(version, range, hilo, options) {
  version = new SemVer(version, options);
  range = new Range(range, options);
  var gtfn, ltefn, ltfn, comp, ecomp;
  switch (hilo) {
    case '>':
      gtfn = gt;
      ltefn = lte;
      ltfn = lt;
      comp = '>';
      ecomp = '>=';
      break;
    case '<':
      gtfn = lt;
      ltefn = gte;
      ltfn = gt;
      comp = '<';
      ecomp = '<=';
      break;
    default:
      throw new TypeError('Must provide a hilo val of "<" or ">"');
  }

  // If it satisfies the range it is not outside
  if (satisfies(version, range, options)) {
    return false;
  }

  // From now on, variable terms are as if we're in "gtr" mode.
  // but note that everything is flipped for the "ltr" function.
  var _loop = function _loop() {
    var comparators = range.set[i];
    var high = null;
    var low = null;
    comparators.forEach(function (comparator) {
      if (comparator.semver === ANY) {
        comparator = new Comparator('>=0.0.0');
      }
      high = high || comparator;
      low = low || comparator;
      if (gtfn(comparator.semver, high.semver, options)) {
        high = comparator;
      } else if (ltfn(comparator.semver, low.semver, options)) {
        low = comparator;
      }
    });

    // If the edge version comparator has a operator then our version
    // isn't outside it
    if (high.operator === comp || high.operator === ecomp) {
      return {
        v: false
      };
    }

    // If the lowest version comparator has an operator and our version
    // is less than it then it isn't higher than the range
    if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
      return {
        v: false
      };
    } else if (low.operator === ecomp && ltfn(version, low.semver)) {
      return {
        v: false
      };
    }
  };
  for (var i = 0; i < range.set.length; ++i) {
    var _ret = _loop();
    if (typeof _ret === "object") return _ret.v;
  }
  return true;
};
module.exports = outside;

/***/ }),

/***/ 4989:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var _slicedToArray = (__webpack_require__(6854)["default"]);
var _createForOfIteratorHelper = (__webpack_require__(3762)["default"]);
// given a set of versions and a range, create a "simplified" range
// that includes the same versions that the original range does
// If the original range is shorter than the simplified one, return that.
var satisfies = __webpack_require__(3597);
var compare = __webpack_require__(1119);
module.exports = function (versions, range, options) {
  var set = [];
  var first = null;
  var prev = null;
  var v = versions.sort(function (a, b) {
    return compare(a, b, options);
  });
  var _iterator = _createForOfIteratorHelper(v),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var version = _step.value;
      var included = satisfies(version, range, options);
      if (included) {
        prev = version;
        if (!first) {
          first = version;
        }
      } else {
        if (prev) {
          set.push([first, prev]);
        }
        prev = null;
        first = null;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  if (first) {
    set.push([first, null]);
  }
  var ranges = [];
  for (var _i = 0, _set = set; _i < _set.length; _i++) {
    var _set$_i = _slicedToArray(_set[_i], 2),
      min = _set$_i[0],
      max = _set$_i[1];
    if (min === max) {
      ranges.push(min);
    } else if (!max && min === v[0]) {
      ranges.push('*');
    } else if (!max) {
      ranges.push(">=".concat(min));
    } else if (min === v[0]) {
      ranges.push("<=".concat(max));
    } else {
      ranges.push("".concat(min, " - ").concat(max));
    }
  }
  var simplified = ranges.join(' || ');
  var original = typeof range.raw === 'string' ? range.raw : String(range);
  return simplified.length < original.length ? simplified : range;
};

/***/ }),

/***/ 8701:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var _createForOfIteratorHelper = (__webpack_require__(3762)["default"]);
var Range = __webpack_require__(7258);
var Comparator = __webpack_require__(301);
var ANY = Comparator.ANY;
var satisfies = __webpack_require__(3597);
var compare = __webpack_require__(1119);

// Complex range `r1 || r2 || ...` is a subset of `R1 || R2 || ...` iff:
// - Every simple range `r1, r2, ...` is a null set, OR
// - Every simple range `r1, r2, ...` which is not a null set is a subset of
//   some `R1, R2, ...`
//
// Simple range `c1 c2 ...` is a subset of simple range `C1 C2 ...` iff:
// - If c is only the ANY comparator
//   - If C is only the ANY comparator, return true
//   - Else if in prerelease mode, return false
//   - else replace c with `[>=0.0.0]`
// - If C is only the ANY comparator
//   - if in prerelease mode, return true
//   - else replace C with `[>=0.0.0]`
// - Let EQ be the set of = comparators in c
// - If EQ is more than one, return true (null set)
// - Let GT be the highest > or >= comparator in c
// - Let LT be the lowest < or <= comparator in c
// - If GT and LT, and GT.semver > LT.semver, return true (null set)
// - If any C is a = range, and GT or LT are set, return false
// - If EQ
//   - If GT, and EQ does not satisfy GT, return true (null set)
//   - If LT, and EQ does not satisfy LT, return true (null set)
//   - If EQ satisfies every C, return true
//   - Else return false
// - If GT
//   - If GT.semver is lower than any > or >= comp in C, return false
//   - If GT is >=, and GT.semver does not satisfy every C, return false
//   - If GT.semver has a prerelease, and not in prerelease mode
//     - If no C has a prerelease and the GT.semver tuple, return false
// - If LT
//   - If LT.semver is greater than any < or <= comp in C, return false
//   - If LT is <=, and LT.semver does not satisfy every C, return false
//   - If GT.semver has a prerelease, and not in prerelease mode
//     - If no C has a prerelease and the LT.semver tuple, return false
// - Else return true

var subset = function subset(sub, dom) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (sub === dom) {
    return true;
  }
  sub = new Range(sub, options);
  dom = new Range(dom, options);
  var sawNonNull = false;
  var _iterator = _createForOfIteratorHelper(sub.set),
    _step;
  try {
    OUTER: for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var simpleSub = _step.value;
      var _iterator2 = _createForOfIteratorHelper(dom.set),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var simpleDom = _step2.value;
          var isSub = simpleSubset(simpleSub, simpleDom, options);
          sawNonNull = sawNonNull || isSub !== null;
          if (isSub) {
            continue OUTER;
          }
        }
        // the null set is a subset of everything, but null simple ranges in
        // a complex range should be ignored.  so if we saw a non-null range,
        // then we know this isn't a subset, but if EVERY simple range was null,
        // then it is a subset.
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      if (sawNonNull) {
        return false;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return true;
};
var minimumVersionWithPreRelease = [new Comparator('>=0.0.0-0')];
var minimumVersion = [new Comparator('>=0.0.0')];
var simpleSubset = function simpleSubset(sub, dom, options) {
  if (sub === dom) {
    return true;
  }
  if (sub.length === 1 && sub[0].semver === ANY) {
    if (dom.length === 1 && dom[0].semver === ANY) {
      return true;
    } else if (options.includePrerelease) {
      sub = minimumVersionWithPreRelease;
    } else {
      sub = minimumVersion;
    }
  }
  if (dom.length === 1 && dom[0].semver === ANY) {
    if (options.includePrerelease) {
      return true;
    } else {
      dom = minimumVersion;
    }
  }
  var eqSet = new Set();
  var gt, lt;
  var _iterator3 = _createForOfIteratorHelper(sub),
    _step3;
  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var c = _step3.value;
      if (c.operator === '>' || c.operator === '>=') {
        gt = higherGT(gt, c, options);
      } else if (c.operator === '<' || c.operator === '<=') {
        lt = lowerLT(lt, c, options);
      } else {
        eqSet.add(c.semver);
      }
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }
  if (eqSet.size > 1) {
    return null;
  }
  var gtltComp;
  if (gt && lt) {
    gtltComp = compare(gt.semver, lt.semver, options);
    if (gtltComp > 0) {
      return null;
    } else if (gtltComp === 0 && (gt.operator !== '>=' || lt.operator !== '<=')) {
      return null;
    }
  }

  // will iterate one or zero times
  var _iterator4 = _createForOfIteratorHelper(eqSet),
    _step4;
  try {
    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
      var eq = _step4.value;
      if (gt && !satisfies(eq, String(gt), options)) {
        return null;
      }
      if (lt && !satisfies(eq, String(lt), options)) {
        return null;
      }
      var _iterator6 = _createForOfIteratorHelper(dom),
        _step6;
      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var _c = _step6.value;
          if (!satisfies(eq, String(_c), options)) {
            return false;
          }
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
      return true;
    }
  } catch (err) {
    _iterator4.e(err);
  } finally {
    _iterator4.f();
  }
  var higher, lower;
  var hasDomLT, hasDomGT;
  // if the subset has a prerelease, we need a comparator in the superset
  // with the same tuple and a prerelease, or it's not a subset
  var needDomLTPre = lt && !options.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
  var needDomGTPre = gt && !options.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
  // exception: <1.2.3-0 is the same as <1.2.3
  if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === '<' && needDomLTPre.prerelease[0] === 0) {
    needDomLTPre = false;
  }
  var _iterator5 = _createForOfIteratorHelper(dom),
    _step5;
  try {
    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
      var _c2 = _step5.value;
      hasDomGT = hasDomGT || _c2.operator === '>' || _c2.operator === '>=';
      hasDomLT = hasDomLT || _c2.operator === '<' || _c2.operator === '<=';
      if (gt) {
        if (needDomGTPre) {
          if (_c2.semver.prerelease && _c2.semver.prerelease.length && _c2.semver.major === needDomGTPre.major && _c2.semver.minor === needDomGTPre.minor && _c2.semver.patch === needDomGTPre.patch) {
            needDomGTPre = false;
          }
        }
        if (_c2.operator === '>' || _c2.operator === '>=') {
          higher = higherGT(gt, _c2, options);
          if (higher === _c2 && higher !== gt) {
            return false;
          }
        } else if (gt.operator === '>=' && !satisfies(gt.semver, String(_c2), options)) {
          return false;
        }
      }
      if (lt) {
        if (needDomLTPre) {
          if (_c2.semver.prerelease && _c2.semver.prerelease.length && _c2.semver.major === needDomLTPre.major && _c2.semver.minor === needDomLTPre.minor && _c2.semver.patch === needDomLTPre.patch) {
            needDomLTPre = false;
          }
        }
        if (_c2.operator === '<' || _c2.operator === '<=') {
          lower = lowerLT(lt, _c2, options);
          if (lower === _c2 && lower !== lt) {
            return false;
          }
        } else if (lt.operator === '<=' && !satisfies(lt.semver, String(_c2), options)) {
          return false;
        }
      }
      if (!_c2.operator && (lt || gt) && gtltComp !== 0) {
        return false;
      }
    }

    // if there was a < or >, and nothing in the dom, then must be false
    // UNLESS it was limited by another range in the other direction.
    // Eg, >1.0.0 <1.0.1 is still a subset of <2.0.0
  } catch (err) {
    _iterator5.e(err);
  } finally {
    _iterator5.f();
  }
  if (gt && hasDomLT && !lt && gtltComp !== 0) {
    return false;
  }
  if (lt && hasDomGT && !gt && gtltComp !== 0) {
    return false;
  }

  // we needed a prerelease range in a specific tuple, but didn't get one
  // then this isn't a subset.  eg >=1.2.3-pre is not a subset of >=1.0.0,
  // because it includes prereleases in the 1.2.3 tuple
  if (needDomGTPre || needDomLTPre) {
    return false;
  }
  return true;
};

// >=1.2.3 is lower than >1.2.3
var higherGT = function higherGT(a, b, options) {
  if (!a) {
    return b;
  }
  var comp = compare(a.semver, b.semver, options);
  return comp > 0 ? a : comp < 0 ? b : b.operator === '>' && a.operator === '>=' ? b : a;
};

// <=1.2.3 is higher than <1.2.3
var lowerLT = function lowerLT(a, b, options) {
  if (!a) {
    return b;
  }
  var comp = compare(a.semver, b.semver, options);
  return comp < 0 ? a : comp > 0 ? b : b.operator === '<' && a.operator === '<=' ? b : a;
};
module.exports = subset;

/***/ }),

/***/ 9002:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var Range = __webpack_require__(7258);

// Mostly just for testing and legacy API reasons
var toComparators = function toComparators(range, options) {
  return new Range(range, options).set.map(function (comp) {
    return comp.map(function (c) {
      return c.value;
    }).join(' ').trim().split(' ');
  });
};
module.exports = toComparators;

/***/ }),

/***/ 5359:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var Range = __webpack_require__(7258);
var validRange = function validRange(range, options) {
  try {
    // Return '*' instead of '' so that truthiness works.
    // This will throw if it's invalid anyway
    return new Range(range, options).range || '*';
  } catch (er) {
    return null;
  }
};
module.exports = validRange;

/***/ }),

/***/ 7537:
/***/ (function(module) {

//

module.exports = function shallowEqual(objA, objB, compare, compareContext) {
  var ret = compare ? compare.call(compareContext, objA, objB) : void 0;
  if (ret !== void 0) {
    return !!ret;
  }
  if (objA === objB) {
    return true;
  }
  if (typeof objA !== "object" || !objA || typeof objB !== "object" || !objB) {
    return false;
  }
  var keysA = Object.keys(objA);
  var keysB = Object.keys(objB);
  if (keysA.length !== keysB.length) {
    return false;
  }
  var bHasOwnProperty = Object.prototype.hasOwnProperty.bind(objB);

  // Test for A's keys different from B.
  for (var idx = 0; idx < keysA.length; idx++) {
    var key = keysA[idx];
    if (!bHasOwnProperty(key)) {
      return false;
    }
    var valueA = objA[key];
    var valueB = objB[key];
    ret = compare ? compare.call(compareContext, valueA, valueB, key) : void 0;
    if (ret === false || ret === void 0 && valueA !== valueB) {
      return false;
    }
  }
  return true;
};

/***/ }),

/***/ 9984:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _regeneratorRuntime = (__webpack_require__(8775)["default"]);
module.exports = function (Yallist) {
  Yallist.prototype[Symbol.iterator] = /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
    var walker;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          walker = this.head;
        case 1:
          if (!walker) {
            _context.next = 7;
            break;
          }
          _context.next = 4;
          return walker.value;
        case 4:
          walker = walker.next;
          _context.next = 1;
          break;
        case 7:
        case "end":
          return _context.stop();
      }
    }, _callee, this);
  });
};

/***/ }),

/***/ 6451:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


module.exports = Yallist;
Yallist.Node = Node;
Yallist.create = Yallist;
function Yallist(list) {
  var self = this;
  if (!(self instanceof Yallist)) {
    self = new Yallist();
  }
  self.tail = null;
  self.head = null;
  self.length = 0;
  if (list && typeof list.forEach === 'function') {
    list.forEach(function (item) {
      self.push(item);
    });
  } else if (arguments.length > 0) {
    for (var i = 0, l = arguments.length; i < l; i++) {
      self.push(arguments[i]);
    }
  }
  return self;
}
Yallist.prototype.removeNode = function (node) {
  if (node.list !== this) {
    throw new Error('removing node which does not belong to this list');
  }
  var next = node.next;
  var prev = node.prev;
  if (next) {
    next.prev = prev;
  }
  if (prev) {
    prev.next = next;
  }
  if (node === this.head) {
    this.head = next;
  }
  if (node === this.tail) {
    this.tail = prev;
  }
  node.list.length--;
  node.next = null;
  node.prev = null;
  node.list = null;
  return next;
};
Yallist.prototype.unshiftNode = function (node) {
  if (node === this.head) {
    return;
  }
  if (node.list) {
    node.list.removeNode(node);
  }
  var head = this.head;
  node.list = this;
  node.next = head;
  if (head) {
    head.prev = node;
  }
  this.head = node;
  if (!this.tail) {
    this.tail = node;
  }
  this.length++;
};
Yallist.prototype.pushNode = function (node) {
  if (node === this.tail) {
    return;
  }
  if (node.list) {
    node.list.removeNode(node);
  }
  var tail = this.tail;
  node.list = this;
  node.prev = tail;
  if (tail) {
    tail.next = node;
  }
  this.tail = node;
  if (!this.head) {
    this.head = node;
  }
  this.length++;
};
Yallist.prototype.push = function () {
  for (var i = 0, l = arguments.length; i < l; i++) {
    push(this, arguments[i]);
  }
  return this.length;
};
Yallist.prototype.unshift = function () {
  for (var i = 0, l = arguments.length; i < l; i++) {
    unshift(this, arguments[i]);
  }
  return this.length;
};
Yallist.prototype.pop = function () {
  if (!this.tail) {
    return undefined;
  }
  var res = this.tail.value;
  this.tail = this.tail.prev;
  if (this.tail) {
    this.tail.next = null;
  } else {
    this.head = null;
  }
  this.length--;
  return res;
};
Yallist.prototype.shift = function () {
  if (!this.head) {
    return undefined;
  }
  var res = this.head.value;
  this.head = this.head.next;
  if (this.head) {
    this.head.prev = null;
  } else {
    this.tail = null;
  }
  this.length--;
  return res;
};
Yallist.prototype.forEach = function (fn, thisp) {
  thisp = thisp || this;
  for (var walker = this.head, i = 0; walker !== null; i++) {
    fn.call(thisp, walker.value, i, this);
    walker = walker.next;
  }
};
Yallist.prototype.forEachReverse = function (fn, thisp) {
  thisp = thisp || this;
  for (var walker = this.tail, i = this.length - 1; walker !== null; i--) {
    fn.call(thisp, walker.value, i, this);
    walker = walker.prev;
  }
};
Yallist.prototype.get = function (n) {
  for (var i = 0, walker = this.head; walker !== null && i < n; i++) {
    // abort out of the list early if we hit a cycle
    walker = walker.next;
  }
  if (i === n && walker !== null) {
    return walker.value;
  }
};
Yallist.prototype.getReverse = function (n) {
  for (var i = 0, walker = this.tail; walker !== null && i < n; i++) {
    // abort out of the list early if we hit a cycle
    walker = walker.prev;
  }
  if (i === n && walker !== null) {
    return walker.value;
  }
};
Yallist.prototype.map = function (fn, thisp) {
  thisp = thisp || this;
  var res = new Yallist();
  for (var walker = this.head; walker !== null;) {
    res.push(fn.call(thisp, walker.value, this));
    walker = walker.next;
  }
  return res;
};
Yallist.prototype.mapReverse = function (fn, thisp) {
  thisp = thisp || this;
  var res = new Yallist();
  for (var walker = this.tail; walker !== null;) {
    res.push(fn.call(thisp, walker.value, this));
    walker = walker.prev;
  }
  return res;
};
Yallist.prototype.reduce = function (fn, initial) {
  var acc;
  var walker = this.head;
  if (arguments.length > 1) {
    acc = initial;
  } else if (this.head) {
    walker = this.head.next;
    acc = this.head.value;
  } else {
    throw new TypeError('Reduce of empty list with no initial value');
  }
  for (var i = 0; walker !== null; i++) {
    acc = fn(acc, walker.value, i);
    walker = walker.next;
  }
  return acc;
};
Yallist.prototype.reduceReverse = function (fn, initial) {
  var acc;
  var walker = this.tail;
  if (arguments.length > 1) {
    acc = initial;
  } else if (this.tail) {
    walker = this.tail.prev;
    acc = this.tail.value;
  } else {
    throw new TypeError('Reduce of empty list with no initial value');
  }
  for (var i = this.length - 1; walker !== null; i--) {
    acc = fn(acc, walker.value, i);
    walker = walker.prev;
  }
  return acc;
};
Yallist.prototype.toArray = function () {
  var arr = new Array(this.length);
  for (var i = 0, walker = this.head; walker !== null; i++) {
    arr[i] = walker.value;
    walker = walker.next;
  }
  return arr;
};
Yallist.prototype.toArrayReverse = function () {
  var arr = new Array(this.length);
  for (var i = 0, walker = this.tail; walker !== null; i++) {
    arr[i] = walker.value;
    walker = walker.prev;
  }
  return arr;
};
Yallist.prototype.slice = function (from, to) {
  to = to || this.length;
  if (to < 0) {
    to += this.length;
  }
  from = from || 0;
  if (from < 0) {
    from += this.length;
  }
  var ret = new Yallist();
  if (to < from || to < 0) {
    return ret;
  }
  if (from < 0) {
    from = 0;
  }
  if (to > this.length) {
    to = this.length;
  }
  for (var i = 0, walker = this.head; walker !== null && i < from; i++) {
    walker = walker.next;
  }
  for (; walker !== null && i < to; i++, walker = walker.next) {
    ret.push(walker.value);
  }
  return ret;
};
Yallist.prototype.sliceReverse = function (from, to) {
  to = to || this.length;
  if (to < 0) {
    to += this.length;
  }
  from = from || 0;
  if (from < 0) {
    from += this.length;
  }
  var ret = new Yallist();
  if (to < from || to < 0) {
    return ret;
  }
  if (from < 0) {
    from = 0;
  }
  if (to > this.length) {
    to = this.length;
  }
  for (var i = this.length, walker = this.tail; walker !== null && i > to; i--) {
    walker = walker.prev;
  }
  for (; walker !== null && i > from; i--, walker = walker.prev) {
    ret.push(walker.value);
  }
  return ret;
};
Yallist.prototype.splice = function (start, deleteCount) {
  if (start > this.length) {
    start = this.length - 1;
  }
  if (start < 0) {
    start = this.length + start;
  }
  for (var i = 0, walker = this.head; walker !== null && i < start; i++) {
    walker = walker.next;
  }
  var ret = [];
  for (var i = 0; walker && i < deleteCount; i++) {
    ret.push(walker.value);
    walker = this.removeNode(walker);
  }
  if (walker === null) {
    walker = this.tail;
  }
  if (walker !== this.head && walker !== this.tail) {
    walker = walker.prev;
  }
  for (var i = 0; i < (arguments.length <= 2 ? 0 : arguments.length - 2); i++) {
    walker = insert(this, walker, i + 2 < 2 || arguments.length <= i + 2 ? undefined : arguments[i + 2]);
  }
  return ret;
};
Yallist.prototype.reverse = function () {
  var head = this.head;
  var tail = this.tail;
  for (var walker = head; walker !== null; walker = walker.prev) {
    var p = walker.prev;
    walker.prev = walker.next;
    walker.next = p;
  }
  this.head = tail;
  this.tail = head;
  return this;
};
function insert(self, node, value) {
  var inserted = node === self.head ? new Node(value, null, node, self) : new Node(value, node, node.next, self);
  if (inserted.next === null) {
    self.tail = inserted;
  }
  if (inserted.prev === null) {
    self.head = inserted;
  }
  self.length++;
  return inserted;
}
function push(self, item) {
  self.tail = new Node(item, self.tail, null, self);
  if (!self.head) {
    self.head = self.tail;
  }
  self.length++;
}
function unshift(self, item) {
  self.head = new Node(item, null, self.head, self);
  if (!self.tail) {
    self.tail = self.head;
  }
  self.length++;
}
function Node(value, prev, next, list) {
  if (!(this instanceof Node)) {
    return new Node(value, prev, next, list);
  }
  this.list = list;
  this.value = value;
  if (prev) {
    prev.next = this;
    this.prev = prev;
  } else {
    this.prev = null;
  }
  if (next) {
    next.prev = this;
    this.next = next;
  } else {
    this.next = null;
  }
}
try {
  // add if support for Symbol.iterator is present
  __webpack_require__(9984)(Yallist);
} catch (er) {}

/***/ }),

/***/ 4823:
/***/ (function(module) {

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
  return arr2;
}
module.exports = _arrayLikeToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 5284:
/***/ (function(module) {

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}
module.exports = _arrayWithHoles, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 766:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var arrayLikeToArray = __webpack_require__(4823);
function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return arrayLikeToArray(arr);
}
module.exports = _arrayWithoutHoles, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 8403:
/***/ (function(module) {

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
module.exports = _classCallCheck, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 2467:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var toPropertyKey = __webpack_require__(8182);
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
module.exports = _createClass, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 3762:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var unsupportedIterableToArray = __webpack_require__(9093);
function _createForOfIteratorHelper(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (!it) {
    if (Array.isArray(o) || (it = unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
      if (it) o = it;
      var i = 0;
      var F = function F() {};
      return {
        s: F,
        n: function n() {
          if (i >= o.length) return {
            done: true
          };
          return {
            done: false,
            value: o[i++]
          };
        },
        e: function e(_e) {
          throw _e;
        },
        f: F
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var normalCompletion = true,
    didErr = false,
    err;
  return {
    s: function s() {
      it = it.call(o);
    },
    n: function n() {
      var step = it.next();
      normalCompletion = step.done;
      return step;
    },
    e: function e(_e2) {
      didErr = true;
      err = _e2;
    },
    f: function f() {
      try {
        if (!normalCompletion && it["return"] != null) it["return"]();
      } finally {
        if (didErr) throw err;
      }
    }
  };
}
module.exports = _createForOfIteratorHelper, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 9015:
/***/ (function(module) {

function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
module.exports = _iterableToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 9791:
/***/ (function(module) {

function _iterableToArrayLimit(arr, i) {
  var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
  if (null != _i) {
    var _s,
      _e,
      _x,
      _r,
      _arr = [],
      _n = !0,
      _d = !1;
    try {
      if (_x = (_i = _i.call(arr)).next, 0 === i) {
        if (Object(_i) !== _i) return;
        _n = !1;
      } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0);
    } catch (err) {
      _d = !0, _e = err;
    } finally {
      try {
        if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return;
      } finally {
        if (_d) throw _e;
      }
    }
    return _arr;
  }
}
module.exports = _iterableToArrayLimit, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 7698:
/***/ (function(module) {

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
module.exports = _nonIterableRest, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 9464:
/***/ (function(module) {

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
module.exports = _nonIterableSpread, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 8775:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var _typeof = (__webpack_require__(2929)["default"]);
function _regeneratorRuntime() {
  "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */
  module.exports = _regeneratorRuntime = function _regeneratorRuntime() {
    return exports;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports;
  var exports = {},
    Op = Object.prototype,
    hasOwn = Op.hasOwnProperty,
    defineProperty = Object.defineProperty || function (obj, key, desc) {
      obj[key] = desc.value;
    },
    $Symbol = "function" == typeof Symbol ? Symbol : {},
    iteratorSymbol = $Symbol.iterator || "@@iterator",
    asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
    toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
  function define(obj, key, value) {
    return Object.defineProperty(obj, key, {
      value: value,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }), obj[key];
  }
  try {
    define({}, "");
  } catch (err) {
    define = function define(obj, key, value) {
      return obj[key] = value;
    };
  }
  function wrap(innerFn, outerFn, self, tryLocsList) {
    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
      generator = Object.create(protoGenerator.prototype),
      context = new Context(tryLocsList || []);
    return defineProperty(generator, "_invoke", {
      value: makeInvokeMethod(innerFn, self, context)
    }), generator;
  }
  function tryCatch(fn, obj, arg) {
    try {
      return {
        type: "normal",
        arg: fn.call(obj, arg)
      };
    } catch (err) {
      return {
        type: "throw",
        arg: err
      };
    }
  }
  exports.wrap = wrap;
  var ContinueSentinel = {};
  function Generator() {}
  function GeneratorFunction() {}
  function GeneratorFunctionPrototype() {}
  var IteratorPrototype = {};
  define(IteratorPrototype, iteratorSymbol, function () {
    return this;
  });
  var getProto = Object.getPrototypeOf,
    NativeIteratorPrototype = getProto && getProto(getProto(values([])));
  NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
  var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
  function defineIteratorMethods(prototype) {
    ["next", "throw", "return"].forEach(function (method) {
      define(prototype, method, function (arg) {
        return this._invoke(method, arg);
      });
    });
  }
  function AsyncIterator(generator, PromiseImpl) {
    function invoke(method, arg, resolve, reject) {
      var record = tryCatch(generator[method], generator, arg);
      if ("throw" !== record.type) {
        var result = record.arg,
          value = result.value;
        return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
          invoke("next", value, resolve, reject);
        }, function (err) {
          invoke("throw", err, resolve, reject);
        }) : PromiseImpl.resolve(value).then(function (unwrapped) {
          result.value = unwrapped, resolve(result);
        }, function (error) {
          return invoke("throw", error, resolve, reject);
        });
      }
      reject(record.arg);
    }
    var previousPromise;
    defineProperty(this, "_invoke", {
      value: function value(method, arg) {
        function callInvokeWithMethodAndArg() {
          return new PromiseImpl(function (resolve, reject) {
            invoke(method, arg, resolve, reject);
          });
        }
        return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
      }
    });
  }
  function makeInvokeMethod(innerFn, self, context) {
    var state = "suspendedStart";
    return function (method, arg) {
      if ("executing" === state) throw new Error("Generator is already running");
      if ("completed" === state) {
        if ("throw" === method) throw arg;
        return doneResult();
      }
      for (context.method = method, context.arg = arg;;) {
        var delegate = context.delegate;
        if (delegate) {
          var delegateResult = maybeInvokeDelegate(delegate, context);
          if (delegateResult) {
            if (delegateResult === ContinueSentinel) continue;
            return delegateResult;
          }
        }
        if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
          if ("suspendedStart" === state) throw state = "completed", context.arg;
          context.dispatchException(context.arg);
        } else "return" === context.method && context.abrupt("return", context.arg);
        state = "executing";
        var record = tryCatch(innerFn, self, context);
        if ("normal" === record.type) {
          if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
          return {
            value: record.arg,
            done: context.done
          };
        }
        "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
      }
    };
  }
  function maybeInvokeDelegate(delegate, context) {
    var methodName = context.method,
      method = delegate.iterator[methodName];
    if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel;
    var record = tryCatch(method, delegate.iterator, context.arg);
    if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
    var info = record.arg;
    return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
  }
  function pushTryEntry(locs) {
    var entry = {
      tryLoc: locs[0]
    };
    1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
  }
  function resetTryEntry(entry) {
    var record = entry.completion || {};
    record.type = "normal", delete record.arg, entry.completion = record;
  }
  function Context(tryLocsList) {
    this.tryEntries = [{
      tryLoc: "root"
    }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
  }
  function values(iterable) {
    if (iterable) {
      var iteratorMethod = iterable[iteratorSymbol];
      if (iteratorMethod) return iteratorMethod.call(iterable);
      if ("function" == typeof iterable.next) return iterable;
      if (!isNaN(iterable.length)) {
        var i = -1,
          next = function next() {
            for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
            return next.value = undefined, next.done = !0, next;
          };
        return next.next = next;
      }
    }
    return {
      next: doneResult
    };
  }
  function doneResult() {
    return {
      value: undefined,
      done: !0
    };
  }
  return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", {
    value: GeneratorFunctionPrototype,
    configurable: !0
  }), defineProperty(GeneratorFunctionPrototype, "constructor", {
    value: GeneratorFunction,
    configurable: !0
  }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
    var ctor = "function" == typeof genFun && genFun.constructor;
    return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
  }, exports.mark = function (genFun) {
    return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
  }, exports.awrap = function (arg) {
    return {
      __await: arg
    };
  }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
    return this;
  }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
    void 0 === PromiseImpl && (PromiseImpl = Promise);
    var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
    return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
      return result.done ? result.value : iter.next();
    });
  }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
    return this;
  }), define(Gp, "toString", function () {
    return "[object Generator]";
  }), exports.keys = function (val) {
    var object = Object(val),
      keys = [];
    for (var key in object) keys.push(key);
    return keys.reverse(), function next() {
      for (; keys.length;) {
        var key = keys.pop();
        if (key in object) return next.value = key, next.done = !1, next;
      }
      return next.done = !0, next;
    };
  }, exports.values = values, Context.prototype = {
    constructor: Context,
    reset: function reset(skipTempReset) {
      if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
    },
    stop: function stop() {
      this.done = !0;
      var rootRecord = this.tryEntries[0].completion;
      if ("throw" === rootRecord.type) throw rootRecord.arg;
      return this.rval;
    },
    dispatchException: function dispatchException(exception) {
      if (this.done) throw exception;
      var context = this;
      function handle(loc, caught) {
        return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
      }
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i],
          record = entry.completion;
        if ("root" === entry.tryLoc) return handle("end");
        if (entry.tryLoc <= this.prev) {
          var hasCatch = hasOwn.call(entry, "catchLoc"),
            hasFinally = hasOwn.call(entry, "finallyLoc");
          if (hasCatch && hasFinally) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          } else if (hasCatch) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
          } else {
            if (!hasFinally) throw new Error("try statement without catch or finally");
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          }
        }
      }
    },
    abrupt: function abrupt(type, arg) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
          var finallyEntry = entry;
          break;
        }
      }
      finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
      var record = finallyEntry ? finallyEntry.completion : {};
      return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
    },
    complete: function complete(record, afterLoc) {
      if ("throw" === record.type) throw record.arg;
      return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
    },
    finish: function finish(finallyLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
      }
    },
    "catch": function _catch(tryLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc === tryLoc) {
          var record = entry.completion;
          if ("throw" === record.type) {
            var thrown = record.arg;
            resetTryEntry(entry);
          }
          return thrown;
        }
      }
      throw new Error("illegal catch attempt");
    },
    delegateYield: function delegateYield(iterable, resultName, nextLoc) {
      return this.delegate = {
        iterator: values(iterable),
        resultName: resultName,
        nextLoc: nextLoc
      }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
    }
  }, exports;
}
module.exports = _regeneratorRuntime, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 6854:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var arrayWithHoles = __webpack_require__(5284);
var iterableToArrayLimit = __webpack_require__(9791);
var unsupportedIterableToArray = __webpack_require__(9093);
var nonIterableRest = __webpack_require__(7698);
function _slicedToArray(arr, i) {
  return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || unsupportedIterableToArray(arr, i) || nonIterableRest();
}
module.exports = _slicedToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 7685:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var arrayWithoutHoles = __webpack_require__(766);
var iterableToArray = __webpack_require__(9015);
var unsupportedIterableToArray = __webpack_require__(9093);
var nonIterableSpread = __webpack_require__(9464);
function _toConsumableArray(arr) {
  return arrayWithoutHoles(arr) || iterableToArray(arr) || unsupportedIterableToArray(arr) || nonIterableSpread();
}
module.exports = _toConsumableArray, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 1105:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var _typeof = (__webpack_require__(2929)["default"]);
function _toPrimitive(input, hint) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
module.exports = _toPrimitive, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 8182:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var _typeof = (__webpack_require__(2929)["default"]);
var toPrimitive = __webpack_require__(1105);
function _toPropertyKey(arg) {
  var key = toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}
module.exports = _toPropertyKey, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 2929:
/***/ (function(module) {

function _typeof(obj) {
  "@babel/helpers - typeof";

  return (module.exports = _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports), _typeof(obj);
}
module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 9093:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var arrayLikeToArray = __webpack_require__(4823);
function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return arrayLikeToArray(o, minLen);
}
module.exports = _unsupportedIterableToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ 3664:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

// TODO(Babel 8): Remove this file.

var runtime = __webpack_require__(8775)();
module.exports = runtime;

// Copied from https://github.com/facebook/regenerator/blob/main/packages/runtime/runtime.js#L736=
try {
  regeneratorRuntime = runtime;
} catch (accidentalStrictMode) {
  if (typeof globalThis === "object") {
    globalThis.regeneratorRuntime = runtime;
  } else {
    Function("r", "regeneratorRuntime = r")(runtime);
  }
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/create fake namespace object */
/******/ 	!function() {
/******/ 		var getProto = Object.getPrototypeOf ? function(obj) { return Object.getPrototypeOf(obj); } : function(obj) { return obj.__proto__; };
/******/ 		var leafPrototypes;
/******/ 		// create a fake namespace object
/******/ 		// mode & 1: value is a module id, require it
/******/ 		// mode & 2: merge all properties of value into the ns
/******/ 		// mode & 4: return value when already ns object
/******/ 		// mode & 16: return value when it's Promise-like
/******/ 		// mode & 8|1: behave like require
/******/ 		__webpack_require__.t = function(value, mode) {
/******/ 			if(mode & 1) value = this(value);
/******/ 			if(mode & 8) return value;
/******/ 			if(typeof value === 'object' && value) {
/******/ 				if((mode & 4) && value.__esModule) return value;
/******/ 				if((mode & 16) && typeof value.then === 'function') return value;
/******/ 			}
/******/ 			var ns = Object.create(null);
/******/ 			__webpack_require__.r(ns);
/******/ 			var def = {};
/******/ 			leafPrototypes = leafPrototypes || [null, getProto({}), getProto([]), getProto(getProto)];
/******/ 			for(var current = mode & 2 && value; typeof current == 'object' && !~leafPrototypes.indexOf(current); current = getProto(current)) {
/******/ 				Object.getOwnPropertyNames(current).forEach(function(key) { def[key] = function() { return value[key]; }; });
/******/ 			}
/******/ 			def['default'] = function() { return value; };
/******/ 			__webpack_require__.d(ns, def);
/******/ 			return ns;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	!function() {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/nonce */
/******/ 	!function() {
/******/ 		__webpack_require__.nc = undefined;
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
!function() {
"use strict";

// UNUSED EXPORTS: default

;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/typeof.js
function typeof_typeof(obj) {
  "@babel/helpers - typeof";

  return typeof_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, typeof_typeof(obj);
}
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/regeneratorRuntime.js

function regeneratorRuntime_regeneratorRuntime() {
  "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */
  regeneratorRuntime_regeneratorRuntime = function _regeneratorRuntime() {
    return exports;
  };
  var exports = {},
    Op = Object.prototype,
    hasOwn = Op.hasOwnProperty,
    defineProperty = Object.defineProperty || function (obj, key, desc) {
      obj[key] = desc.value;
    },
    $Symbol = "function" == typeof Symbol ? Symbol : {},
    iteratorSymbol = $Symbol.iterator || "@@iterator",
    asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
    toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
  function define(obj, key, value) {
    return Object.defineProperty(obj, key, {
      value: value,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }), obj[key];
  }
  try {
    define({}, "");
  } catch (err) {
    define = function define(obj, key, value) {
      return obj[key] = value;
    };
  }
  function wrap(innerFn, outerFn, self, tryLocsList) {
    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
      generator = Object.create(protoGenerator.prototype),
      context = new Context(tryLocsList || []);
    return defineProperty(generator, "_invoke", {
      value: makeInvokeMethod(innerFn, self, context)
    }), generator;
  }
  function tryCatch(fn, obj, arg) {
    try {
      return {
        type: "normal",
        arg: fn.call(obj, arg)
      };
    } catch (err) {
      return {
        type: "throw",
        arg: err
      };
    }
  }
  exports.wrap = wrap;
  var ContinueSentinel = {};
  function Generator() {}
  function GeneratorFunction() {}
  function GeneratorFunctionPrototype() {}
  var IteratorPrototype = {};
  define(IteratorPrototype, iteratorSymbol, function () {
    return this;
  });
  var getProto = Object.getPrototypeOf,
    NativeIteratorPrototype = getProto && getProto(getProto(values([])));
  NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
  var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
  function defineIteratorMethods(prototype) {
    ["next", "throw", "return"].forEach(function (method) {
      define(prototype, method, function (arg) {
        return this._invoke(method, arg);
      });
    });
  }
  function AsyncIterator(generator, PromiseImpl) {
    function invoke(method, arg, resolve, reject) {
      var record = tryCatch(generator[method], generator, arg);
      if ("throw" !== record.type) {
        var result = record.arg,
          value = result.value;
        return value && "object" == typeof_typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
          invoke("next", value, resolve, reject);
        }, function (err) {
          invoke("throw", err, resolve, reject);
        }) : PromiseImpl.resolve(value).then(function (unwrapped) {
          result.value = unwrapped, resolve(result);
        }, function (error) {
          return invoke("throw", error, resolve, reject);
        });
      }
      reject(record.arg);
    }
    var previousPromise;
    defineProperty(this, "_invoke", {
      value: function value(method, arg) {
        function callInvokeWithMethodAndArg() {
          return new PromiseImpl(function (resolve, reject) {
            invoke(method, arg, resolve, reject);
          });
        }
        return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
      }
    });
  }
  function makeInvokeMethod(innerFn, self, context) {
    var state = "suspendedStart";
    return function (method, arg) {
      if ("executing" === state) throw new Error("Generator is already running");
      if ("completed" === state) {
        if ("throw" === method) throw arg;
        return doneResult();
      }
      for (context.method = method, context.arg = arg;;) {
        var delegate = context.delegate;
        if (delegate) {
          var delegateResult = maybeInvokeDelegate(delegate, context);
          if (delegateResult) {
            if (delegateResult === ContinueSentinel) continue;
            return delegateResult;
          }
        }
        if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
          if ("suspendedStart" === state) throw state = "completed", context.arg;
          context.dispatchException(context.arg);
        } else "return" === context.method && context.abrupt("return", context.arg);
        state = "executing";
        var record = tryCatch(innerFn, self, context);
        if ("normal" === record.type) {
          if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
          return {
            value: record.arg,
            done: context.done
          };
        }
        "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
      }
    };
  }
  function maybeInvokeDelegate(delegate, context) {
    var methodName = context.method,
      method = delegate.iterator[methodName];
    if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel;
    var record = tryCatch(method, delegate.iterator, context.arg);
    if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
    var info = record.arg;
    return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
  }
  function pushTryEntry(locs) {
    var entry = {
      tryLoc: locs[0]
    };
    1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
  }
  function resetTryEntry(entry) {
    var record = entry.completion || {};
    record.type = "normal", delete record.arg, entry.completion = record;
  }
  function Context(tryLocsList) {
    this.tryEntries = [{
      tryLoc: "root"
    }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
  }
  function values(iterable) {
    if (iterable) {
      var iteratorMethod = iterable[iteratorSymbol];
      if (iteratorMethod) return iteratorMethod.call(iterable);
      if ("function" == typeof iterable.next) return iterable;
      if (!isNaN(iterable.length)) {
        var i = -1,
          next = function next() {
            for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
            return next.value = undefined, next.done = !0, next;
          };
        return next.next = next;
      }
    }
    return {
      next: doneResult
    };
  }
  function doneResult() {
    return {
      value: undefined,
      done: !0
    };
  }
  return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", {
    value: GeneratorFunctionPrototype,
    configurable: !0
  }), defineProperty(GeneratorFunctionPrototype, "constructor", {
    value: GeneratorFunction,
    configurable: !0
  }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
    var ctor = "function" == typeof genFun && genFun.constructor;
    return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
  }, exports.mark = function (genFun) {
    return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
  }, exports.awrap = function (arg) {
    return {
      __await: arg
    };
  }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
    return this;
  }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
    void 0 === PromiseImpl && (PromiseImpl = Promise);
    var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
    return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
      return result.done ? result.value : iter.next();
    });
  }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
    return this;
  }), define(Gp, "toString", function () {
    return "[object Generator]";
  }), exports.keys = function (val) {
    var object = Object(val),
      keys = [];
    for (var key in object) keys.push(key);
    return keys.reverse(), function next() {
      for (; keys.length;) {
        var key = keys.pop();
        if (key in object) return next.value = key, next.done = !1, next;
      }
      return next.done = !0, next;
    };
  }, exports.values = values, Context.prototype = {
    constructor: Context,
    reset: function reset(skipTempReset) {
      if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
    },
    stop: function stop() {
      this.done = !0;
      var rootRecord = this.tryEntries[0].completion;
      if ("throw" === rootRecord.type) throw rootRecord.arg;
      return this.rval;
    },
    dispatchException: function dispatchException(exception) {
      if (this.done) throw exception;
      var context = this;
      function handle(loc, caught) {
        return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
      }
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i],
          record = entry.completion;
        if ("root" === entry.tryLoc) return handle("end");
        if (entry.tryLoc <= this.prev) {
          var hasCatch = hasOwn.call(entry, "catchLoc"),
            hasFinally = hasOwn.call(entry, "finallyLoc");
          if (hasCatch && hasFinally) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          } else if (hasCatch) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
          } else {
            if (!hasFinally) throw new Error("try statement without catch or finally");
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          }
        }
      }
    },
    abrupt: function abrupt(type, arg) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
          var finallyEntry = entry;
          break;
        }
      }
      finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
      var record = finallyEntry ? finallyEntry.completion : {};
      return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
    },
    complete: function complete(record, afterLoc) {
      if ("throw" === record.type) throw record.arg;
      return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
    },
    finish: function finish(finallyLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
      }
    },
    "catch": function _catch(tryLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc === tryLoc) {
          var record = entry.completion;
          if ("throw" === record.type) {
            var thrown = record.arg;
            resetTryEntry(entry);
          }
          return thrown;
        }
      }
      throw new Error("illegal catch attempt");
    },
    delegateYield: function delegateYield(iterable, resultName, nextLoc) {
      return this.delegate = {
        iterator: values(iterable),
        resultName: resultName,
        nextLoc: nextLoc
      }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
    }
  }, exports;
}
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/asyncToGenerator.js
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }
  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}
function asyncToGenerator_asyncToGenerator(fn) {
  return function () {
    var self = this,
      args = arguments;
    return new Promise(function (resolve, reject) {
      var gen = fn.apply(self, args);
      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }
      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }
      _next(undefined);
    });
  };
}
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/taggedTemplateLiteral.js
function _taggedTemplateLiteral(strings, raw) {
  if (!raw) {
    raw = strings.slice(0);
  }
  return Object.freeze(Object.defineProperties(strings, {
    raw: {
      value: Object.freeze(raw)
    }
  }));
}
// EXTERNAL MODULE: ./node_modules/_react@18.2.0@react/index.js
var _react_18_2_0_react = __webpack_require__(9512);
var _react_18_2_0_react_namespaceObject = /*#__PURE__*/__webpack_require__.t(_react_18_2_0_react, 2);
// EXTERNAL MODULE: ./node_modules/_react-dom@18.2.0@react-dom/client.js
var client = __webpack_require__(545);
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/extends.js
function extends_extends() {
  extends_extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return extends_extends.apply(this, arguments);
}
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/noop.js
/**
 * This method returns `undefined`.
 *
 * @static
 * @memberOf _
 * @since 2.3.0
 * @category Util
 * @example
 *
 * _.times(2, _.noop);
 * // => [undefined, undefined]
 */
function noop() {
  // No operation performed.
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_noop = (noop);
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/setPrototypeOf.js
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/inheritsLoose.js

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  _setPrototypeOf(subClass, superClass);
}
;// CONCATENATED MODULE: ./node_modules/_reconnecting-websocket@4.4.0@reconnecting-websocket/dist/reconnecting-websocket-mjs.js
/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */

var _extendStatics = function extendStatics(d, b) {
  _extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return _extendStatics(d, b);
};
function __extends(d, b) {
  _extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}
function __values(o) {
  var m = typeof Symbol === "function" && o[Symbol.iterator],
    i = 0;
  if (m) return m.call(o);
  return {
    next: function next() {
      if (o && i >= o.length) o = void 0;
      return {
        value: o && o[i++],
        done: !o
      };
    }
  };
}
function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o),
    r,
    ar = [],
    e;
  try {
    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  } catch (error) {
    e = {
      error: error
    };
  } finally {
    try {
      if (r && !r.done && (m = i["return"])) m.call(i);
    } finally {
      if (e) throw e.error;
    }
  }
  return ar;
}
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
  return ar;
}
var Event = /** @class */function () {
  function Event(type, target) {
    this.target = target;
    this.type = type;
  }
  return Event;
}();
var ErrorEvent = /** @class */function (_super) {
  __extends(ErrorEvent, _super);
  function ErrorEvent(error, target) {
    var _this = _super.call(this, 'error', target) || this;
    _this.message = error.message;
    _this.error = error;
    return _this;
  }
  return ErrorEvent;
}(Event);
var CloseEvent = /** @class */function (_super) {
  __extends(CloseEvent, _super);
  function CloseEvent(code, reason, target) {
    if (code === void 0) {
      code = 1000;
    }
    if (reason === void 0) {
      reason = '';
    }
    var _this = _super.call(this, 'close', target) || this;
    _this.wasClean = true;
    _this.code = code;
    _this.reason = reason;
    return _this;
  }
  return CloseEvent;
}(Event);

/*!
 * Reconnecting WebSocket
 * by Pedro Ladaria <pedro.ladaria@gmail.com>
 * https://github.com/pladaria/reconnecting-websocket
 * License MIT
 */
var getGlobalWebSocket = function getGlobalWebSocket() {
  if (typeof WebSocket !== 'undefined') {
    // @ts-ignore
    return WebSocket;
  }
};
/**
 * Returns true if given argument looks like a WebSocket class
 */
var isWebSocket = function isWebSocket(w) {
  return typeof w !== 'undefined' && !!w && w.CLOSING === 2;
};
var DEFAULT = {
  maxReconnectionDelay: 10000,
  minReconnectionDelay: 1000 + Math.random() * 4000,
  minUptime: 5000,
  reconnectionDelayGrowFactor: 1.3,
  connectionTimeout: 4000,
  maxRetries: Infinity,
  maxEnqueuedMessages: Infinity,
  startClosed: false,
  debug: false
};
var ReconnectingWebSocket = /** @class */function () {
  function ReconnectingWebSocket(url, protocols, options) {
    var _this = this;
    if (options === void 0) {
      options = {};
    }
    this._listeners = {
      error: [],
      message: [],
      open: [],
      close: []
    };
    this._retryCount = -1;
    this._shouldReconnect = true;
    this._connectLock = false;
    this._binaryType = 'blob';
    this._closeCalled = false;
    this._messageQueue = [];
    /**
     * An event listener to be called when the WebSocket connection's readyState changes to CLOSED
     */
    this.onclose = null;
    /**
     * An event listener to be called when an error occurs
     */
    this.onerror = null;
    /**
     * An event listener to be called when a message is received from the server
     */
    this.onmessage = null;
    /**
     * An event listener to be called when the WebSocket connection's readyState changes to OPEN;
     * this indicates that the connection is ready to send and receive data
     */
    this.onopen = null;
    this._handleOpen = function (event) {
      _this._debug('open event');
      var _a = _this._options.minUptime,
        minUptime = _a === void 0 ? DEFAULT.minUptime : _a;
      clearTimeout(_this._connectTimeout);
      _this._uptimeTimeout = setTimeout(function () {
        return _this._acceptOpen();
      }, minUptime);
      _this._ws.binaryType = _this._binaryType;
      // send enqueued messages (messages sent before websocket open event)
      _this._messageQueue.forEach(function (message) {
        return _this._ws.send(message);
      });
      _this._messageQueue = [];
      if (_this.onopen) {
        _this.onopen(event);
      }
      _this._listeners.open.forEach(function (listener) {
        return _this._callEventListener(event, listener);
      });
    };
    this._handleMessage = function (event) {
      _this._debug('message event');
      if (_this.onmessage) {
        _this.onmessage(event);
      }
      _this._listeners.message.forEach(function (listener) {
        return _this._callEventListener(event, listener);
      });
    };
    this._handleError = function (event) {
      _this._debug('error event', event.message);
      _this._disconnect(undefined, event.message === 'TIMEOUT' ? 'timeout' : undefined);
      if (_this.onerror) {
        _this.onerror(event);
      }
      _this._debug('exec error listeners');
      _this._listeners.error.forEach(function (listener) {
        return _this._callEventListener(event, listener);
      });
      _this._connect();
    };
    this._handleClose = function (event) {
      _this._debug('close event');
      _this._clearTimeouts();
      if (_this._shouldReconnect) {
        _this._connect();
      }
      if (_this.onclose) {
        _this.onclose(event);
      }
      _this._listeners.close.forEach(function (listener) {
        return _this._callEventListener(event, listener);
      });
    };
    this._url = url;
    this._protocols = protocols;
    this._options = options;
    if (this._options.startClosed) {
      this._shouldReconnect = false;
    }
    this._connect();
  }
  Object.defineProperty(ReconnectingWebSocket, "CONNECTING", {
    get: function get() {
      return 0;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket, "OPEN", {
    get: function get() {
      return 1;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket, "CLOSING", {
    get: function get() {
      return 2;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket, "CLOSED", {
    get: function get() {
      return 3;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "CONNECTING", {
    get: function get() {
      return ReconnectingWebSocket.CONNECTING;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "OPEN", {
    get: function get() {
      return ReconnectingWebSocket.OPEN;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "CLOSING", {
    get: function get() {
      return ReconnectingWebSocket.CLOSING;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "CLOSED", {
    get: function get() {
      return ReconnectingWebSocket.CLOSED;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "binaryType", {
    get: function get() {
      return this._ws ? this._ws.binaryType : this._binaryType;
    },
    set: function set(value) {
      this._binaryType = value;
      if (this._ws) {
        this._ws.binaryType = value;
      }
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "retryCount", {
    /**
     * Returns the number or connection retries
     */
    get: function get() {
      return Math.max(this._retryCount, 0);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "bufferedAmount", {
    /**
     * The number of bytes of data that have been queued using calls to send() but not yet
     * transmitted to the network. This value resets to zero once all queued data has been sent.
     * This value does not reset to zero when the connection is closed; if you keep calling send(),
     * this will continue to climb. Read only
     */
    get: function get() {
      var bytes = this._messageQueue.reduce(function (acc, message) {
        if (typeof message === 'string') {
          acc += message.length; // not byte size
        } else if (message instanceof Blob) {
          acc += message.size;
        } else {
          acc += message.byteLength;
        }
        return acc;
      }, 0);
      return bytes + (this._ws ? this._ws.bufferedAmount : 0);
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "extensions", {
    /**
     * The extensions selected by the server. This is currently only the empty string or a list of
     * extensions as negotiated by the connection
     */
    get: function get() {
      return this._ws ? this._ws.extensions : '';
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "protocol", {
    /**
     * A string indicating the name of the sub-protocol the server selected;
     * this will be one of the strings specified in the protocols parameter when creating the
     * WebSocket object
     */
    get: function get() {
      return this._ws ? this._ws.protocol : '';
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "readyState", {
    /**
     * The current state of the connection; this is one of the Ready state constants
     */
    get: function get() {
      if (this._ws) {
        return this._ws.readyState;
      }
      return this._options.startClosed ? ReconnectingWebSocket.CLOSED : ReconnectingWebSocket.CONNECTING;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ReconnectingWebSocket.prototype, "url", {
    /**
     * The URL as resolved by the constructor
     */
    get: function get() {
      return this._ws ? this._ws.url : '';
    },
    enumerable: true,
    configurable: true
  });
  /**
   * Closes the WebSocket connection or connection attempt, if any. If the connection is already
   * CLOSED, this method does nothing
   */
  ReconnectingWebSocket.prototype.close = function (code, reason) {
    if (code === void 0) {
      code = 1000;
    }
    this._closeCalled = true;
    this._shouldReconnect = false;
    this._clearTimeouts();
    if (!this._ws) {
      this._debug('close enqueued: no ws instance');
      return;
    }
    if (this._ws.readyState === this.CLOSED) {
      this._debug('close: already closed');
      return;
    }
    this._ws.close(code, reason);
  };
  /**
   * Closes the WebSocket connection or connection attempt and connects again.
   * Resets retry counter;
   */
  ReconnectingWebSocket.prototype.reconnect = function (code, reason) {
    this._shouldReconnect = true;
    this._closeCalled = false;
    this._retryCount = -1;
    if (!this._ws || this._ws.readyState === this.CLOSED) {
      this._connect();
    } else {
      this._disconnect(code, reason);
      this._connect();
    }
  };
  /**
   * Enqueue specified data to be transmitted to the server over the WebSocket connection
   */
  ReconnectingWebSocket.prototype.send = function (data) {
    if (this._ws && this._ws.readyState === this.OPEN) {
      this._debug('send', data);
      this._ws.send(data);
    } else {
      var _a = this._options.maxEnqueuedMessages,
        maxEnqueuedMessages = _a === void 0 ? DEFAULT.maxEnqueuedMessages : _a;
      if (this._messageQueue.length < maxEnqueuedMessages) {
        this._debug('enqueue', data);
        this._messageQueue.push(data);
      }
    }
  };
  /**
   * Register an event handler of a specific event type
   */
  ReconnectingWebSocket.prototype.addEventListener = function (type, listener) {
    if (this._listeners[type]) {
      // @ts-ignore
      this._listeners[type].push(listener);
    }
  };
  ReconnectingWebSocket.prototype.dispatchEvent = function (event) {
    var e_1, _a;
    var listeners = this._listeners[event.type];
    if (listeners) {
      try {
        for (var listeners_1 = __values(listeners), listeners_1_1 = listeners_1.next(); !listeners_1_1.done; listeners_1_1 = listeners_1.next()) {
          var listener = listeners_1_1.value;
          this._callEventListener(event, listener);
        }
      } catch (e_1_1) {
        e_1 = {
          error: e_1_1
        };
      } finally {
        try {
          if (listeners_1_1 && !listeners_1_1.done && (_a = listeners_1.return)) _a.call(listeners_1);
        } finally {
          if (e_1) throw e_1.error;
        }
      }
    }
    return true;
  };
  /**
   * Removes an event listener
   */
  ReconnectingWebSocket.prototype.removeEventListener = function (type, listener) {
    if (this._listeners[type]) {
      // @ts-ignore
      this._listeners[type] = this._listeners[type].filter(function (l) {
        return l !== listener;
      });
    }
  };
  ReconnectingWebSocket.prototype._debug = function () {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
      args[_i] = arguments[_i];
    }
    if (this._options.debug) {
      // not using spread because compiled version uses Symbols
      // tslint:disable-next-line
      console.log.apply(console, __spread(['RWS>'], args));
    }
  };
  ReconnectingWebSocket.prototype._getNextDelay = function () {
    var _a = this._options,
      _b = _a.reconnectionDelayGrowFactor,
      reconnectionDelayGrowFactor = _b === void 0 ? DEFAULT.reconnectionDelayGrowFactor : _b,
      _c = _a.minReconnectionDelay,
      minReconnectionDelay = _c === void 0 ? DEFAULT.minReconnectionDelay : _c,
      _d = _a.maxReconnectionDelay,
      maxReconnectionDelay = _d === void 0 ? DEFAULT.maxReconnectionDelay : _d;
    var delay = 0;
    if (this._retryCount > 0) {
      delay = minReconnectionDelay * Math.pow(reconnectionDelayGrowFactor, this._retryCount - 1);
      if (delay > maxReconnectionDelay) {
        delay = maxReconnectionDelay;
      }
    }
    this._debug('next delay', delay);
    return delay;
  };
  ReconnectingWebSocket.prototype._wait = function () {
    var _this = this;
    return new Promise(function (resolve) {
      setTimeout(resolve, _this._getNextDelay());
    });
  };
  ReconnectingWebSocket.prototype._getNextUrl = function (urlProvider) {
    if (typeof urlProvider === 'string') {
      return Promise.resolve(urlProvider);
    }
    if (typeof urlProvider === 'function') {
      var url = urlProvider();
      if (typeof url === 'string') {
        return Promise.resolve(url);
      }
      if (!!url.then) {
        return url;
      }
    }
    throw Error('Invalid URL');
  };
  ReconnectingWebSocket.prototype._connect = function () {
    var _this = this;
    if (this._connectLock || !this._shouldReconnect) {
      return;
    }
    this._connectLock = true;
    var _a = this._options,
      _b = _a.maxRetries,
      maxRetries = _b === void 0 ? DEFAULT.maxRetries : _b,
      _c = _a.connectionTimeout,
      connectionTimeout = _c === void 0 ? DEFAULT.connectionTimeout : _c,
      _d = _a.WebSocket,
      WebSocket = _d === void 0 ? getGlobalWebSocket() : _d;
    if (this._retryCount >= maxRetries) {
      this._debug('max retries reached', this._retryCount, '>=', maxRetries);
      return;
    }
    this._retryCount++;
    this._debug('connect', this._retryCount);
    this._removeListeners();
    if (!isWebSocket(WebSocket)) {
      throw Error('No valid WebSocket class provided');
    }
    this._wait().then(function () {
      return _this._getNextUrl(_this._url);
    }).then(function (url) {
      // close could be called before creating the ws
      if (_this._closeCalled) {
        return;
      }
      _this._debug('connect', {
        url: url,
        protocols: _this._protocols
      });
      _this._ws = _this._protocols ? new WebSocket(url, _this._protocols) : new WebSocket(url);
      _this._ws.binaryType = _this._binaryType;
      _this._connectLock = false;
      _this._addListeners();
      _this._connectTimeout = setTimeout(function () {
        return _this._handleTimeout();
      }, connectionTimeout);
    });
  };
  ReconnectingWebSocket.prototype._handleTimeout = function () {
    this._debug('timeout event');
    this._handleError(new ErrorEvent(Error('TIMEOUT'), this));
  };
  ReconnectingWebSocket.prototype._disconnect = function (code, reason) {
    if (code === void 0) {
      code = 1000;
    }
    this._clearTimeouts();
    if (!this._ws) {
      return;
    }
    this._removeListeners();
    try {
      this._ws.close(code, reason);
      this._handleClose(new CloseEvent(code, reason, this));
    } catch (error) {
      // ignore
    }
  };
  ReconnectingWebSocket.prototype._acceptOpen = function () {
    this._debug('accept open');
    this._retryCount = 0;
  };
  ReconnectingWebSocket.prototype._callEventListener = function (event, listener) {
    if ('handleEvent' in listener) {
      // @ts-ignore
      listener.handleEvent(event);
    } else {
      // @ts-ignore
      listener(event);
    }
  };
  ReconnectingWebSocket.prototype._removeListeners = function () {
    if (!this._ws) {
      return;
    }
    this._debug('removeListeners');
    this._ws.removeEventListener('open', this._handleOpen);
    this._ws.removeEventListener('close', this._handleClose);
    this._ws.removeEventListener('message', this._handleMessage);
    // @ts-ignore
    this._ws.removeEventListener('error', this._handleError);
  };
  ReconnectingWebSocket.prototype._addListeners = function () {
    if (!this._ws) {
      return;
    }
    this._debug('addListeners');
    this._ws.addEventListener('open', this._handleOpen);
    this._ws.addEventListener('close', this._handleClose);
    this._ws.addEventListener('message', this._handleMessage);
    // @ts-ignore
    this._ws.addEventListener('error', this._handleError);
  };
  ReconnectingWebSocket.prototype._clearTimeouts = function () {
    clearTimeout(this._connectTimeout);
    clearTimeout(this._uptimeTimeout);
  };
  return ReconnectingWebSocket;
}();
/* harmony default export */ var reconnecting_websocket_mjs = (ReconnectingWebSocket);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/report/index.js
var callback = function callback() {
  for (var _len = arguments.length, messages = new Array(_len), _key = 0; _key < _len; _key++) {
    messages[_key] = arguments[_key];
  }
  window.console.log('[tingwu-meeting] report: ', messages);
};
var implementReport = function implementReport(cb) {
  callback = cb;
};
var report = function report() {
  callback.apply(void 0, arguments);
};
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/toPrimitive.js

function _toPrimitive(input, hint) {
  if (typeof_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/toPropertyKey.js


function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof_typeof(key) === "symbol" ? key : String(key);
}
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/createClass.js

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-common@0.3.9@@ali/tingwu-common/dist-web/eventer.js

function _createForOfIteratorHelperLoose(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (it) return (it = it.call(o)).next.bind(it);
  if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
    if (it) o = it;
    var i = 0;
    return function () {
      if (i >= o.length) return {
        done: true
      };
      return {
        done: false,
        value: o[i++]
      };
    };
  }
  throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) {
    arr2[i] = arr[i];
  }
  return arr2;
}
var EventResult = /*#__PURE__*/function () {
  function EventResult() {
    this._isDefaultPrevented = false;
    this._isStopped = false;
  }
  var _proto = EventResult.prototype;
  _proto.preventDefault = function preventDefault() {
    this._isDefaultPrevented = true;
  };
  _proto.stop = function stop() {
    this._isStopped = true;
  };
  _createClass(EventResult, [{
    key: "isDefaultPrevented",
    get: function get() {
      return this._isDefaultPrevented;
    }
  }, {
    key: "isStopped",
    get: function get() {
      return this._isStopped;
    }
  }]);
  return EventResult;
}();
function nextTick(callback) {
  if (typeof window === 'object' && window.requestAnimationFrame) window.requestAnimationFrame(callback);else if (typeof setTimeout === 'function') setTimeout(callback, 1); // 若不支持setTimeout降级为同步方法（例如j2v8环境）
  else callback();
}
var Eventer = /*#__PURE__*/function () {
  function Eventer() {
    this.listeners = {};
  }
  var _proto2 = Eventer.prototype;

  /* 绑定事件监听器 */
  _proto2.on = function on(type, handler) {
    var _this = this;
    var list = this.listeners[type] || [];
    list.push(handler);
    this.listeners[type] = list;
    return function () {
      return _this.off(type, handler);
    };
  }
  /**
   * 把当前已经注册的监听器重新输送出去
   * @param callback 输出的回调
   * @param clearCurrent 输出后是否清除当前实例上的监听器
   */;

  _proto2.pipe = function pipe(callback, clearCurrent) {
    if (clearCurrent === void 0) {
      clearCurrent = true;
    }
    var listeners = this.listeners;
    Object.keys(listeners).forEach(function (key) {
      var list = listeners[key] || [];
      list.forEach(function (h) {
        return callback(key, h);
      });
    });
    if (clearCurrent) this.listeners = {};
  }
  /* 移除事件监听器 */;

  _proto2.off = function off(type, handler) {
    var list = this.listeners[type] || [];
    this.listeners[type] = handler ? list.filter(function (f) {
      return f !== handler;
    }) : [];
  }
  /* 移除所有监听器 */;

  _proto2.offAll = function offAll() {
    var _this2 = this;
    Object.keys(this.listeners).forEach(function (k) {
      _this2.listeners[k] = [];
    });
  }
  /* 触发事件（同步执行） */;

  _proto2.emit = function emit(type, event) {
    var eventResult = new EventResult();
    var list = this.listeners[type] || [];
    for (var _iterator = _createForOfIteratorHelperLoose(list), _step; !(_step = _iterator()).done;) {
      var _handler = _step.value;
      _handler(event, eventResult);
      if (eventResult.isStopped) {
        break;
      }
    }
    return eventResult;
  }
  /* 触发事件（下一帧执行） */;

  _proto2.emitAsync = function emitAsync(type, event) {
    var _this3 = this;
    nextTick(function () {
      return _this3.emit(type, event);
    });
  };
  return Eventer;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/connection/abstractConnection.js


var ConnectionState;
(function (ConnectionState) {
  ConnectionState[ConnectionState["Connected"] = 0] = "Connected";
  ConnectionState[ConnectionState["NotConnected"] = 1] = "NotConnected";
})(ConnectionState || (ConnectionState = {}));
var AbstractConnection = /*#__PURE__*/function (_Eventer) {
  _inheritsLoose(AbstractConnection, _Eventer);
  function AbstractConnection() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _Eventer.call.apply(_Eventer, [this].concat(args)) || this;
    _this.connectCount = 0;
    _this.state = ConnectionState.NotConnected;
    _this.onOpen = function () {
      _this.connectCount++;
      _this.state = ConnectionState.Connected;
      _this.emit('open', {});
    };
    _this.onMessage = function (event) {
      _this.emit('message', event);
    };
    _this.onError = function (event) {
      _this.emit('error', event);
    };
    return _this;
  }
  var _proto = AbstractConnection.prototype;
  _proto.connect = function connect(serverUrl) {
    this.connectCount = 0;
    this.implementConnect(serverUrl);
  };
  _proto.disconnect = function disconnect() {
    this.connectCount = 0;
    this.implementDisconnect();
  };
  _proto.reconnect = function reconnect() {
    this.implementReconnect();
  };
  _proto.onClose = function onClose(event) {
    this.state = ConnectionState.NotConnected;
    this.emit('close', event);
  };
  _proto.isReconnection = function isReconnection() {
    return this.connectCount > 1;
  };
  _proto.isConnected = function isConnected() {
    return this.state === ConnectionState.Connected;
  };
  return AbstractConnection;
}(Eventer);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/connection/rwsConnection.js




var RWSConnection = /*#__PURE__*/function (_AbstractConnection) {
  _inheritsLoose(RWSConnection, _AbstractConnection);
  function RWSConnection() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractConnection.call.apply(_AbstractConnection, [this].concat(args)) || this;
    _this.rws = void 0;
    _this.connectCount = 0;
    _this.userDisconnect = false;
    _this.params = {
      maxRetries: 60
    };
    _this.handleOpen = function () {
      report('ws创建');
      _this.onOpen();
    };
    _this.handleMessage = function (event) {
      _this.onMessage(event);
    };
    _this.handleError = function (event) {
      report('ws报错', "type=" + event.type + ";error=" + event.error + ";message=" + event.message);
      _this.onError(event);
    };
    _this.handleClose = function (event) {
      report('ws关闭', "code=" + event.code + ";reason=" + event.reason);
      _this.onClose(event);
      if (_this.userDisconnect) {
        _this.clearEvents();
        _this.userDisconnect = false;
      }
    };
    return _this;
  }
  var _proto = RWSConnection.prototype;
  _proto.setParams = function setParams(params) {
    this.params = params;
  };
  _proto.implementConnect = function implementConnect(serverUrl) {
    if (serverUrl === void 0) {
      serverUrl = '';
    }
    if (!this.params) {
      throw new Error('`params` cannot be undefined in RWSConnection');
    }
    if (this.rws) {
      this.clearEvents();
    }
    this.userDisconnect = false;
    var _this$params$maxRetri = this.params.maxRetries,
      maxRetries = _this$params$maxRetri === void 0 ? 60 : _this$params$maxRetri;
    this.rws = new reconnecting_websocket_mjs(serverUrl, '', {
      minReconnectionDelay: 5000,
      maxRetries: maxRetries
    });
    this.rws.addEventListener('open', this.handleOpen);
    this.rws.addEventListener('message', this.handleMessage);
    this.rws.addEventListener('error', this.handleError);
    this.rws.addEventListener('close', this.handleClose);
  };
  _proto.implementReconnect = function implementReconnect() {
    var _this$rws;
    (_this$rws = this.rws) == null ? void 0 : _this$rws.reconnect();
  };
  _proto.implementDisconnect = function implementDisconnect() {
    if (!this.rws) {
      return;
    }
    this.userDisconnect = true;
    this.rws.close();
  };
  _proto.clearEvents = function clearEvents() {
    if (!this.rws) {
      return;
    }
    this.rws.removeEventListener('open', this.handleOpen);
    this.rws.removeEventListener('message', this.handleMessage);
    this.rws.removeEventListener('error', this.handleError);
    this.rws.removeEventListener('close', this.handleClose);
    this.rws = undefined;
  };
  _proto.sendMessage = function sendMessage(message) {
    if (this.rws) {
      this.rws.send(message);
    }
  };
  return RWSConnection;
}(AbstractConnection);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/context/meetingContext.js
var MeetingContext = /*#__PURE__*/function () {
  function MeetingContext(meetingController, recorder, connection, timer) {
    this.meetingController = void 0;
    this.recorder = void 0;
    this.connection = void 0;
    this.meetingConnection = void 0;
    this.meetingConfig = void 0;
    this.messageInput = void 0;
    this.messageOutput = void 0;
    this.timer = void 0;
    this.isAlibabaVersion = false;
    this.meetingController = meetingController;
    this.recorder = recorder;
    this.connection = connection;
    this.timer = timer;
  }
  var _proto = MeetingContext.prototype;
  _proto.setMeetingConnection = function setMeetingConnection(meetingConnection) {
    this.meetingConnection = meetingConnection;
  };
  _proto.getMeetingConnection = function getMeetingConnection() {
    if (!this.meetingConnection) {
      throw new Error('You need init meetingConnection in MeetingContext');
    }
    return this.meetingConnection;
  };
  _proto.setMessageInput = function setMessageInput(messageInput) {
    this.messageInput = messageInput;
  };
  _proto.getMessageInput = function getMessageInput() {
    if (!this.messageInput) {
      throw new Error('You need init meesageInput in MeetingContext');
    }
    return this.messageInput;
  };
  _proto.setMessageOutput = function setMessageOutput(messageOutput) {
    this.messageOutput = messageOutput;
  };
  _proto.getMessageOutput = function getMessageOutput() {
    if (!this.messageOutput) {
      throw new Error('You need init meesageOutput in MeetingContext');
    }
    return this.messageOutput;
  };
  return MeetingContext;
}();
// EXTERNAL MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/regenerator/index.js
var regenerator = __webpack_require__(3664);
var regenerator_default = /*#__PURE__*/__webpack_require__.n(regenerator);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/meetingConfig/meetingConfig.js

var generateConfig = function generateConfig(params) {
  return extends_extends({
    format: 'opus',
    enableDenoise: false,
    enableTranslate: false
  }, params);
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/prepare/prepare.js
var Prepare = /*#__PURE__*/function () {
  function Prepare() {
    var _this = this;
    this.waitingResolve = void 0;
    this.waitingReject = void 0;
    this.isResolved = false;
    this.isRejected = false;
    this.isFinished = false;
    this.waiting = void 0;
    this.waiting = new Promise(function (resolve, reject) {
      _this.waitingResolve = resolve;
      _this.waitingReject = reject;
    });
  }
  var _proto = Prepare.prototype;
  _proto.resolve = function resolve() {
    this.isResolved = true;
    this.isFinished = true;
    if (this.waitingResolve) {
      this.waitingResolve();
    }
  };
  _proto.reject = function reject(reason) {
    this.isRejected = true;
    this.isFinished = true;
    if (this.waitingReject) {
      this.waitingReject(reason);
    }
  };
  return Prepare;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/prepare/timeoutPrepare.js


var TimeoutPrepare = /*#__PURE__*/function (_Prepare) {
  _inheritsLoose(TimeoutPrepare, _Prepare);
  function TimeoutPrepare(timeoutHandler, during) {
    var _this;
    _this = _Prepare.call(this) || this;
    _this.timeout = void 0;
    _this.timeout = setTimeout(function () {
      _this.reject();
      timeoutHandler();
    }, during);
    return _this;
  }
  var _proto = TimeoutPrepare.prototype;
  _proto.resolve = function resolve() {
    clearTimeout(this.timeout);
    _Prepare.prototype.resolve.call(this);
  };
  _proto.reject = function reject(reason) {
    clearTimeout(this.timeout);
    _Prepare.prototype.reject.call(this, reason);
  };
  return TimeoutPrepare;
}(Prepare);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/meeting/meetingModel.js


var MeetingState;
(function (MeetingState) {
  MeetingState[MeetingState["Idle"] = 0] = "Idle";
  MeetingState[MeetingState["PrepareStart"] = 1] = "PrepareStart";
  MeetingState[MeetingState["InMeeting"] = 2] = "InMeeting";
  MeetingState[MeetingState["PreparePause"] = 3] = "PreparePause";
  MeetingState[MeetingState["Pause"] = 4] = "Pause";
  MeetingState[MeetingState["PrepareResume"] = 5] = "PrepareResume";
  MeetingState[MeetingState["PrepareStop"] = 6] = "PrepareStop";
  MeetingState[MeetingState["Stop"] = 7] = "Stop";
})(MeetingState || (MeetingState = {}));
var MeetingModel = /*#__PURE__*/function (_Eventer) {
  _inheritsLoose(MeetingModel, _Eventer);
  function MeetingModel() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _Eventer.call.apply(_Eventer, [this].concat(args)) || this;
    _this.state = MeetingState.Idle;
    _this.isReadyToSendAudio = false;
    return _this;
  }
  var _proto = MeetingModel.prototype;
  _proto.setMeetingState = function setMeetingState(state) {
    this.state = state;
    this.emit('meetingStateChange', {
      state: state
    });
  };
  _proto.getMeetingState = function getMeetingState() {
    return this.state;
  };
  _proto.isMeetingState = function isMeetingState(state) {
    return this.state === state;
  };
  _proto.isInMeeting = function isInMeeting() {
    return this.state === MeetingState.InMeeting;
  };
  _proto.isEnteringMeeting = function isEnteringMeeting() {
    return [MeetingState.PrepareStart, MeetingState.PrepareResume].includes(this.state);
  };
  _proto.isLeavingMeeting = function isLeavingMeeting() {
    return [MeetingState.PrepareStop, MeetingState.PreparePause].includes(this.state);
  };
  _proto.isLikeInMeeting = function isLikeInMeeting() {
    return [MeetingState.InMeeting, MeetingState.PreparePause, MeetingState.PrepareStop].includes(this.state);
  };
  _proto.isMeetingIdle = function isMeetingIdle() {
    return this.state === MeetingState.Idle || this.state === MeetingState.Stop;
  };
  _proto.getIsReadyToSendAudio = function getIsReadyToSendAudio() {
    return this.isReadyToSendAudio;
  };
  _proto.setIsReadyToSendAudio = function setIsReadyToSendAudio(isReadyToSendAudio) {
    this.isReadyToSendAudio = isReadyToSendAudio;
    this.emit('isReadyToSendAudioChange', {
      isReadyToSendAudio: isReadyToSendAudio
    });
  };
  return MeetingModel;
}(Eventer);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/meeting/meetingController.js








var MeetingController = /*#__PURE__*/function (_Eventer) {
  _inheritsLoose(MeetingController, _Eventer);
  function MeetingController() {
    var _this;
    _this = _Eventer.call(this) || this;
    _this.model = new MeetingModel();
    _this.meetingConfig = void 0;
    _this.onIsReadyToSendAudioChange = function (event) {
      _this.emit('isReadyToSendAudioChange', event);
    };
    _this.onMeetingStateChange = function (event) {
      _this.emit('meetingStateChange', event);
    };
    _this.model = new MeetingModel();
    _this.listen();
    return _this;
  }
  var _proto = MeetingController.prototype;
  _proto.listen = function listen() {
    this.model.on('meetingStateChange', this.onMeetingStateChange);
    this.model.on('isReadyToSendAudioChange', this.onIsReadyToSendAudioChange);
  };
  _proto.unlisten = function unlisten() {
    this.model.off('meetingStateChange', this.onMeetingStateChange);
    this.model.off('isReadyToSendAudioChange', this.onIsReadyToSendAudioChange);
  };
  _proto.getMeetingState = function getMeetingState() {
    return this.model.state;
  };
  _proto.isMeetingIdle = function isMeetingIdle() {
    return this.model.isMeetingIdle();
  };
  _proto.isEnteringMeeting = function isEnteringMeeting() {
    return this.model.isEnteringMeeting();
  };
  _proto.isLeavingMeeting = function isLeavingMeeting() {
    return this.model.isLeavingMeeting();
  };
  _proto.isLikeInMeeting = function isLikeInMeeting() {
    return this.model.isLikeInMeeting();
  };
  _proto.isInMeeting = function isInMeeting() {
    return this.model.isInMeeting();
  };
  _proto.setIsReadyToSendAudio = function setIsReadyToSendAudio(isReadyToSendAudio) {
    this.model.setIsReadyToSendAudio(isReadyToSendAudio);
  };
  _proto.getIsReadyToSendAudio = function getIsReadyToSendAudio() {
    return this.model.getIsReadyToSendAudio();
  };
  _proto.startMeeting = /*#__PURE__*/function () {
    var _startMeeting = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee(meetingConfig) {
      var genratedConfig, errorObject;
      return regenerator_default().wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (this.isMeetingIdle()) {
                _context.next = 2;
                break;
              }
              return _context.abrupt("return");
            case 2:
              genratedConfig = generateConfig(meetingConfig);
              this.meetingConfig = genratedConfig;
              _context.prev = 4;
              this.emit('meetingConfigChange', {
                meetingConfig: genratedConfig
              });
              _context.next = 8;
              return this.prepareStart();
            case 8:
              this.model.setMeetingState(MeetingState.InMeeting); // eslint-disable-next-line alidocs/catch-call-function

              _context.next = 19;
              break;
            case 11:
              _context.prev = 11;
              _context.t0 = _context["catch"](4);
              report('开始会议失败', JSON.stringify(_context.t0));
              console.error(_context.t0);
              errorObject = _context.t0 == null ? void 0 : _context.t0.error;
              if (errorObject) {
                this.emit('detectStartMeetingFailed', {
                  error: errorObject
                });
              }
              this.model.setMeetingState(MeetingState.Idle);
              throw _context.t0;
            case 19:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, this, [[4, 11]]);
    }));
    function startMeeting(_x) {
      return _startMeeting.apply(this, arguments);
    }
    return startMeeting;
  }();
  _proto.prepareStart = /*#__PURE__*/function () {
    var _prepareStart = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee2() {
      var prepare;
      return regenerator_default().wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              this.model.setMeetingState(MeetingState.PrepareStart);
              prepare = new TimeoutPrepare(function () {
                report('开始会议超时');
              }, 5000);
              this.emit('requestPrepareStartMeeting', {
                prepare: prepare,
                isResume: false
              });
              _context2.next = 5;
              return prepare.waiting;
            case 5:
              return _context2.abrupt("return", _context2.sent);
            case 6:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));
    function prepareStart() {
      return _prepareStart.apply(this, arguments);
    }
    return prepareStart;
  }();
  _proto.pauseMeeing = /*#__PURE__*/function () {
    var _pauseMeeing = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee3() {
      return regenerator_default().wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              if (this.model.isMeetingState(MeetingState.InMeeting)) {
                _context3.next = 2;
                break;
              }
              return _context3.abrupt("return");
            case 2:
              _context3.prev = 2;
              _context3.next = 5;
              return this.preparePause();
            case 5:
              _context3.next = 11;
              break;
            case 7:
              _context3.prev = 7;
              _context3.t0 = _context3["catch"](2);
              report('暂停会议失败，按正常处理', JSON.stringify(_context3.t0));
              this.emit('detectPauseMeetingFailed', {});
            case 11:
              _context3.prev = 11;
              this.model.setMeetingState(MeetingState.Pause);
              return _context3.finish(11);
            case 14:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3, this, [[2, 7, 11, 14]]);
    }));
    function pauseMeeing() {
      return _pauseMeeing.apply(this, arguments);
    }
    return pauseMeeing;
  }();
  _proto.preparePause = /*#__PURE__*/function () {
    var _preparePause = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee4() {
      var prepare;
      return regenerator_default().wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              this.model.setMeetingState(MeetingState.PreparePause);
              prepare = new TimeoutPrepare(function () {
                report('暂停会议超时');
              }, 10000);
              this.emit('requestPrepareStopMeeting', {
                prepare: prepare,
                isPause: true
              });
              _context4.next = 5;
              return prepare.waiting;
            case 5:
              return _context4.abrupt("return", _context4.sent);
            case 6:
            case "end":
              return _context4.stop();
          }
        }
      }, _callee4, this);
    }));
    function preparePause() {
      return _preparePause.apply(this, arguments);
    }
    return preparePause;
  }();
  _proto.resumeMeeting = /*#__PURE__*/function () {
    var _resumeMeeting = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee5() {
      var errorObject;
      return regenerator_default().wrap(function _callee5$(_context5) {
        while (1) {
          switch (_context5.prev = _context5.next) {
            case 0:
              if (this.model.isMeetingState(MeetingState.Pause)) {
                _context5.next = 2;
                break;
              }
              return _context5.abrupt("return");
            case 2:
              _context5.prev = 2;
              _context5.next = 5;
              return this.prepareResume();
            case 5:
              this.model.setMeetingState(MeetingState.InMeeting); // eslint-disable-next-line alidocs/catch-call-function

              _context5.next = 16;
              break;
            case 8:
              _context5.prev = 8;
              _context5.t0 = _context5["catch"](2);
              report('恢复会议失败', JSON.stringify(_context5.t0));
              console.error(_context5.t0);
              errorObject = _context5.t0 == null ? void 0 : _context5.t0.error;
              if (errorObject) {
                this.emit('detectResumeMeetingFailed', {
                  error: errorObject
                });
              }
              this.model.setMeetingState(MeetingState.Pause);
              throw _context5.t0;
            case 16:
            case "end":
              return _context5.stop();
          }
        }
      }, _callee5, this, [[2, 8]]);
    }));
    function resumeMeeting() {
      return _resumeMeeting.apply(this, arguments);
    }
    return resumeMeeting;
  }();
  _proto.prepareResume = /*#__PURE__*/function () {
    var _prepareResume = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee6() {
      var prepare;
      return regenerator_default().wrap(function _callee6$(_context6) {
        while (1) {
          switch (_context6.prev = _context6.next) {
            case 0:
              this.model.setMeetingState(MeetingState.PrepareResume);
              prepare = new TimeoutPrepare(function () {
                report('恢复会议超时');
              }, 10000);
              this.emit('requestPrepareStartMeeting', {
                prepare: prepare,
                isResume: true
              });
              _context6.next = 5;
              return prepare.waiting;
            case 5:
              return _context6.abrupt("return", _context6.sent);
            case 6:
            case "end":
              return _context6.stop();
          }
        }
      }, _callee6, this);
    }));
    function prepareResume() {
      return _prepareResume.apply(this, arguments);
    }
    return prepareResume;
  }();
  _proto.stopMeeting = /*#__PURE__*/function () {
    var _stopMeeting = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee7() {
      return regenerator_default().wrap(function _callee7$(_context7) {
        while (1) {
          switch (_context7.prev = _context7.next) {
            case 0:
              if (!(!this.model.isMeetingState(MeetingState.InMeeting) && !this.model.isMeetingState(MeetingState.Pause))) {
                _context7.next = 2;
                break;
              }
              return _context7.abrupt("return");
            case 2:
              _context7.prev = 2;
              if (!(this.model.isMeetingState(MeetingState.InMeeting) || this.model.isMeetingState(MeetingState.Pause))) {
                _context7.next = 6;
                break;
              }
              _context7.next = 6;
              return this.prepareStop();
            case 6:
              _context7.next = 12;
              break;
            case 8:
              _context7.prev = 8;
              _context7.t0 = _context7["catch"](2);
              this.emit('detectStopMeetingFailed', {});
              report('停止会议失败，按正常处理', JSON.stringify(_context7.t0));
            case 12:
              _context7.prev = 12;
              this.model.setMeetingState(MeetingState.Stop);
              return _context7.finish(12);
            case 15:
            case "end":
              return _context7.stop();
          }
        }
      }, _callee7, this, [[2, 8, 12, 15]]);
    }));
    function stopMeeting() {
      return _stopMeeting.apply(this, arguments);
    }
    return stopMeeting;
  }();
  _proto.prepareStop = /*#__PURE__*/function () {
    var _prepareStop = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee8() {
      var prepare;
      return regenerator_default().wrap(function _callee8$(_context8) {
        while (1) {
          switch (_context8.prev = _context8.next) {
            case 0:
              this.model.setMeetingState(MeetingState.PrepareStop);
              prepare = new TimeoutPrepare(function () {
                report('停止会议超时');
              }, 10000);
              this.emit('requestPrepareStopMeeting', {
                prepare: prepare,
                isPause: false
              });
              _context8.next = 5;
              return prepare.waiting;
            case 5:
              return _context8.abrupt("return", _context8.sent);
            case 6:
            case "end":
              return _context8.stop();
          }
        }
      }, _callee8, this);
    }));
    function prepareStop() {
      return _prepareStop.apply(this, arguments);
    }
    return prepareStop;
  }();
  _proto.requestPrepareFlushRecordBuffer = /*#__PURE__*/function () {
    var _requestPrepareFlushRecordBuffer = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee9(timeout) {
      var prepare;
      return regenerator_default().wrap(function _callee9$(_context9) {
        while (1) {
          switch (_context9.prev = _context9.next) {
            case 0:
              if (timeout === void 0) {
                timeout = 3000;
              }
              prepare = new TimeoutPrepare(function () {}, timeout);
              this.emit('requestPrepareFlushRecordBuffer', {
                prepare: prepare
              });
              _context9.next = 5;
              return prepare.waiting;
            case 5:
              return _context9.abrupt("return", _context9.sent);
            case 6:
            case "end":
              return _context9.stop();
          }
        }
      }, _callee9, this);
    }));
    function requestPrepareFlushRecordBuffer(_x2) {
      return _requestPrepareFlushRecordBuffer.apply(this, arguments);
    }
    return requestPrepareFlushRecordBuffer;
  }();
  _proto.updateVocabularies = function updateVocabularies(vocabularies) {
    var prepare = new TimeoutPrepare(function () {}, 3000);
    this.emit('requestPrepareUpdateVocabularies', {
      prepare: prepare,
      vocabularies: vocabularies
    });
    return prepare.waiting;
  };
  _proto.updateSmartReplaceWords = function updateSmartReplaceWords(smartWordsMap) {
    var prepare = new TimeoutPrepare(function () {}, 3000);
    this.emit('requestPrepareUpdateSmartReplaceWords', {
      prepare: prepare,
      smartWordsMap: smartWordsMap
    });
    return prepare.waiting;
  };
  _proto.detectConnectionRetrySuccess = function detectConnectionRetrySuccess() {
    report('转写服务重连成功');
    this.emit('detectConnectionRetrySuccess', {});
  };
  _proto.detectConnectionRetryTimeout = function detectConnectionRetryTimeout() {
    report('转写服务重连超时');
    this.emit('detectConnectionRetryTimeout', {});
  };
  _proto.detectConnectionRetry = function detectConnectionRetry() {
    report('转写服务需要重连');
    this.emit('detectConnectionRetry', {});
  };
  _proto.detectConnectionServerDisconnect = function detectConnectionServerDisconnect() {
    report('转写服务主动断连');
    this.emit('detectConnectionServerDisconnect', {});
  };
  _proto.enableTranslate = function enableTranslate(targetLanguage) {
    var _this2 = this;
    var prepare = new TimeoutPrepare(function () {}, 3000); // 3s timeout

    this.emit('requestPrepareEnableTranslate', {
      prepare: prepare,
      targetLanguage: targetLanguage
    });
    prepare.waiting.then(function () {
      if (!_this2.meetingConfig) {
        return;
      }
      _this2.meetingConfig.enableTranslate = true;
      _this2.meetingConfig.targetLanguage = targetLanguage;
    });
    return prepare.waiting;
  };
  _proto.disableTranslate = function disableTranslate() {
    var _this3 = this;
    var prepare = new TimeoutPrepare(function () {}, 3000);
    this.emit('requestPrepareDisableTranslate', {
      prepare: prepare
    });
    prepare.waiting.then(function () {
      if (!_this3.meetingConfig) {
        return;
      }
      _this3.meetingConfig.enableTranslate = false;
    });
    return prepare.waiting;
  };
  return MeetingController;
}(Eventer);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/meetingConnection/meetingConnection.js
var MeetingConnection = /*#__PURE__*/function () {
  function MeetingConnection(meetingContext, commands) {
    var _this = this;
    this.meetingContext = void 0;
    this.stopPrepare = void 0;
    this.commands = [];
    this.onMeetingConfigChange = function (event) {
      _this.meetingContext.meetingConfig = event.meetingConfig;
    };
    this.meetingContext = meetingContext;
    this.meetingContext.setMeetingConnection(this);
    this.commands = commands;
    this.listen();
  }
  var _proto = MeetingConnection.prototype;
  _proto.listen = function listen() {
    var _this$meetingContext = this.meetingContext,
      meetingController = _this$meetingContext.meetingController,
      messageOutput = _this$meetingContext.messageOutput;
    this.commands.forEach(function (command) {
      command.onReady();
    });
    messageOutput && messageOutput.registerCommands(this.commands);
    meetingController.on('meetingConfigChange', this.onMeetingConfigChange);
  };
  _proto.unlisten = function unlisten() {
    var _this$meetingContext2 = this.meetingContext,
      meetingController = _this$meetingContext2.meetingController,
      messageOutput = _this$meetingContext2.messageOutput;
    this.commands.forEach(function (command) {
      command.cleanup();
      command.onDestroy();
    });
    messageOutput && messageOutput.unregisterCommands();
    meetingController.off('meetingConfigChange', this.onMeetingConfigChange);
  };
  return MeetingConnection;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/utils/uuid.js
var getUUID = function getUUID(len) {
  if (len === void 0) {
    len = 32;
  }

  // 16位16进制字符
  var digits = '0123456789abcdef';
  var str = '';
  for (var i = 0; i < len; i += 1) {
    var rand = Math.floor(Math.random() * digits.length);
    str += digits[rand];
  }
  return str;
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/message/messageInput.js

var MessageInput = /*#__PURE__*/function () {
  function MessageInput(context) {
    this.context = void 0;
    this.taskId = void 0;
    this.namespace = 'SpeechTranscriber';
    this.context = context;
    this.taskId = getUUID();
  }
  var _proto = MessageInput.prototype;
  _proto.createMessage = function createMessage(name, payload) {
    var meetingConfig = this.context.meetingConfig;
    if (!meetingConfig) {
      return;
    }
    var appKey = meetingConfig.appKey;
    var header = {
      task_id: this.taskId,
      message_id: getUUID(),
      namespace: this.namespace,
      name: name,
      appkey: appKey
    };
    return {
      header: header,
      payload: payload,
      context: {}
    };
  };
  _proto.send = function send(name, payload) {
    var connection = this.context.connection;
    connection.sendMessage(JSON.stringify(this.createMessage(name, payload)));
  };
  _proto.sendArrayBuffer = function sendArrayBuffer(arrayBuffer) {
    var connection = this.context.connection;
    connection.sendMessage(arrayBuffer);
  };
  return MessageInput;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/message/messageOutput.js
var MessageOutput = /*#__PURE__*/function () {
  function MessageOutput(meetingContext) {
    var _this = this;
    this.meetingContext = void 0;
    this.messageKeyAndCommandMapping = {};
    this.handleMessage = function (msg) {
      var message = JSON.parse(msg.data);
      var _ref = (message == null ? void 0 : message.header) || {},
        name = _ref.name;
      if (name && _this.messageKeyAndCommandMapping[name]) {
        var commands = _this.messageKeyAndCommandMapping[name] || [];
        var starCommands = _this.messageKeyAndCommandMapping['*'];
        starCommands == null ? void 0 : starCommands.forEach(function (command) {
          if (!commands.includes(command)) {
            commands.push(command);
          }
        });
        commands.forEach(function (command) {
          command.onMessage(message);
        });
      }
    };
    this.meetingContext = meetingContext;
    this.listen();
  }
  var _proto = MessageOutput.prototype;
  _proto.listen = function listen() {
    var connection = this.meetingContext.connection;
    connection.on('message', this.handleMessage);
  };
  _proto.unlisten = function unlisten() {
    var connection = this.meetingContext.connection;
    connection.off('message', this.handleMessage);
  };
  _proto.registerCommands = function registerCommands(commands) {
    var _this2 = this;
    commands.forEach(function (command) {
      if (command.watchMessageKeys && command.watchMessageKeys.length > 0) {
        command.watchMessageKeys.forEach(function (key) {
          if (!_this2.messageKeyAndCommandMapping[key]) {
            _this2.messageKeyAndCommandMapping[key] = [];
          }
          _this2.messageKeyAndCommandMapping[key].push(command);
        });
      }
    });
  };
  _proto.unregisterCommands = function unregisterCommands() {
    this.messageKeyAndCommandMapping = {};
  };
  return MessageOutput;
}();
;// CONCATENATED MODULE: ./node_modules/_@babel_runtime@7.21.0@@babel/runtime/helpers/esm/assertThisInitialized.js
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self;
}
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/abstractCommand.js
var AbstractCommand = /*#__PURE__*/function () {
  function AbstractCommand(context) {
    this.context = void 0;
    this.watchMessageKeys = [];
    this.cleanups = [];
    this.context = context;
  }
  var _proto = AbstractCommand.prototype;
  _proto.onReady = function onReady() {};
  _proto.onDestroy = function onDestroy() {};
  _proto.sendMessage = function sendMessage(name, payload) {
    if (payload === void 0) {
      payload = {};
    }
    this.context.getMessageInput().send(name, payload);
  };
  _proto.sendArrayBuffer = function sendArrayBuffer(arrayBuffer) {
    this.context.getMessageInput().sendArrayBuffer(arrayBuffer);
  };
  _proto.onMessage = function onMessage(_message) {};
  _proto.needCleanups = function needCleanups() {
    for (var _len = arguments.length, cleanups = new Array(_len), _key = 0; _key < _len; _key++) {
      cleanups[_key] = arguments[_key];
    }
    this.cleanups = this.cleanups.concat(cleanups);
  };
  _proto.cleanup = function cleanup() {
    this.cleanups.forEach(function (cleanup) {
      cleanup();
    });
    this.cleanups = [];
  };
  return AbstractCommand;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/opusCommand/abstractOpusAudioSenderDelegate.js
var AbstractOpusAudioSenderDelegate = function AbstractOpusAudioSenderDelegate() {};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/opusCommand/opusAudioSenderDelegate.js


var OpusAudioSenderDelegate = /*#__PURE__*/function (_AbstractOpusAudioSen) {
  _inheritsLoose(OpusAudioSenderDelegate, _AbstractOpusAudioSen);
  function OpusAudioSenderDelegate(command) {
    var _this;
    _this = _AbstractOpusAudioSen.call(this) || this;
    _this.command = void 0;
    _this.context = void 0;
    _this.command = command;
    _this.context = command.context;
    return _this;
  }
  var _proto = OpusAudioSenderDelegate.prototype;
  _proto.isCanSendBuffer = function isCanSendBuffer() {
    var _navigator$onLine;
    var _this$context = this.context,
      connection = _this$context.connection,
      meetingController = _this$context.meetingController;
    var isOnline = (_navigator$onLine = navigator.onLine) != null ? _navigator$onLine : true;
    if (!connection.isConnected() || !meetingController.isLikeInMeeting()) {
      return false;
    }
    if (!meetingController.getIsReadyToSendAudio()) {
      return false;
    }
    if (!isOnline) {
      return false;
    }
    return true;
  };
  _proto.sendBuffer = function sendBuffer(buffer) {
    this.command.sendArrayBuffer(buffer);
  };
  return OpusAudioSenderDelegate;
}(AbstractOpusAudioSenderDelegate);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/opusCommand/opusAudioRecordBuffer.js
var OPUS_HEADER_LENGTH = 2;
var OpusAudioRecordBuffer = /*#__PURE__*/function () {
  function OpusAudioRecordBuffer() {
    this.recordCount = 0;
    this.consumeCount = 0;
    this.audioBuffers = [];
    this.cahcedHeader = [];
  }
  var _proto = OpusAudioRecordBuffer.prototype;
  _proto.getCachedHeader = function getCachedHeader() {
    return this.cahcedHeader;
  };
  _proto.onRecordStop = function onRecordStop() {
    this.recordCount = 0;
    this.consumeCount = 0;
    this.audioBuffers = [];
    this.cahcedHeader = [];
  };
  _proto.productBuffer = function productBuffer(arrayBuffer) {
    this.audioBuffers.push(arrayBuffer);
    if (this.recordCount < OPUS_HEADER_LENGTH) {
      this.cahcedHeader.push(arrayBuffer);
    }
    this.recordCount++;
  };
  _proto.consumeBuffer = function consumeBuffer() {
    var buffer = this.audioBuffers.shift();
    if (buffer) {
      this.consumeCount++;
      return buffer;
    }
  };
  _proto.isConsumeHeader = function isConsumeHeader() {
    return this.consumeCount >= OPUS_HEADER_LENGTH;
  };
  _proto.isCanConsume = function isCanConsume() {
    return this.audioBuffers.length > 0;
  };
  return OpusAudioRecordBuffer;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/opusCommand/opusHeaderBuffer.js
var OpusHeaderBuffer = /*#__PURE__*/function () {
  function OpusHeaderBuffer(headerBuffer) {
    this.headerBuffer = [];
    this.headerBuffer = headerBuffer.slice();
  }
  var _proto = OpusHeaderBuffer.prototype;
  _proto.consumeBuffer = function consumeBuffer() {
    return this.headerBuffer.shift();
  };
  _proto.isCanConsume = function isCanConsume() {
    return this.headerBuffer.length > 0;
  };
  return OpusHeaderBuffer;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/opusCommand/opusAudioSender.js





var OpusAudioSender = /*#__PURE__*/function (_Eventer) {
  _inheritsLoose(OpusAudioSender, _Eventer);
  function OpusAudioSender(delegate) {
    var _this;
    _this = _Eventer.call(this) || this;
    _this.delegate = void 0;
    _this.opusAudioRecordBuffer = new OpusAudioRecordBuffer();
    _this.opusHeaderBuffer = void 0;
    _this.interval = void 0;
    _this.isRunning = false;
    _this.firstSendDate = void 0;
    _this.lastSendDate = void 0;
    _this.sendPackageCount = 0;
    _this.sendTotalSize = 0;
    _this.delegate = delegate;
    return _this;
  }
  var _proto = OpusAudioSender.prototype;
  _proto.clearLog = function clearLog() {
    this.firstSendDate = undefined;
    this.lastSendDate = undefined;
    this.sendPackageCount = 0;
    this.sendTotalSize = 0;
  };
  _proto.sendLog = function sendLog() {
    report('转写服务断开');
    report('音频发包总次数', String(this.sendPackageCount));
    report('音频发包总大小', this.sendTotalSize + "kb");
    if (this.firstSendDate) {
      report('首次发包时间', String(this.firstSendDate.getTime()));
    }
    if (this.lastSendDate) {
      report('末次发包时间', String(this.lastSendDate.getTime()));
    }
    this.clearLog();
  };
  _proto.start = function start() {
    if (this.isRunning) {
      return;
    }
    this.isRunning = true;
    this.startInterval();
  };
  _proto.stop = function stop() {
    if (!this.isRunning) {
      return;
    }
    this.sendLog();
    this.isRunning = false;
    this.stopInterval();
  };
  _proto.onRecordStop = function onRecordStop() {
    this.opusAudioRecordBuffer.onRecordStop();
  };
  _proto.onConnectionStart = function onConnectionStart() {
    if (this.opusAudioRecordBuffer.isConsumeHeader()) {
      this.opusHeaderBuffer = new OpusHeaderBuffer(this.opusAudioRecordBuffer.getCachedHeader());
    }
  };
  _proto.onProductBuffer = function onProductBuffer(buffer) {
    this.opusAudioRecordBuffer.productBuffer(buffer);
    if (this.isRunning) {
      this.startInterval();
    }
  };
  _proto.startInterval = function startInterval() {
    var _this2 = this;
    if (this.interval) {
      return;
    }
    this.interval = setInterval(function () {
      _this2.sendBufferIsNeed();
    }, 20);
  };
  _proto.stopInterval = function stopInterval() {
    if (this.interval) {
      clearInterval(this.interval);
      this.interval = undefined;
    }
  };
  _proto.sendBufferIsNeed = function sendBufferIsNeed() {
    if (!this.delegate.isCanSendBuffer()) {
      return;
    }
    var willConsumeCount = document.hidden ? 50 : 1;
    while (willConsumeCount-- > 0) {
      var buffer = this.getConsumeBuffer();
      if (!buffer) {
        break;
      }
      this.delegate.sendBuffer(buffer);
      if (!this.firstSendDate) {
        this.firstSendDate = new Date();
      }
      this.lastSendDate = new Date();
      this.sendPackageCount += 1;
      this.sendTotalSize += buffer.byteLength / 1024;
    }
    if (!this.opusAudioRecordBuffer.isCanConsume()) {
      this.emit('detectAudioBufferEmpty', {});
      this.stopInterval();
    }
  };
  _proto.getConsumeBuffer = function getConsumeBuffer() {
    var buffer;
    if (this.opusHeaderBuffer) {
      buffer = this.opusHeaderBuffer.consumeBuffer();
      if (!this.opusHeaderBuffer.isCanConsume()) {
        delete this.opusHeaderBuffer;
      }
    }
    if (!buffer) {
      buffer = this.opusAudioRecordBuffer.consumeBuffer();
    }
    return buffer;
  };
  return OpusAudioSender;
}(Eventer);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/opusCommand/opusCommand.js





var OpusCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(OpusCommand, _AbstractCommand);
  function OpusCommand(context) {
    var _this;
    _this = _AbstractCommand.call(this, context) || this;
    _this.flushPrepare = void 0;
    _this.opusAudioSender = void 0;
    _this.handleConnectionOpen = function () {
      if (!_this.isVaild()) {
        return;
      }
      _this.opusAudioSender.onConnectionStart();
      _this.opusAudioSender.start();
    };
    _this.handleConnectionClose = function () {
      if (!_this.isVaild()) {
        return;
      }
      _this.opusAudioSender.stop();
    };
    _this.handleDataavailable = function (event) {
      if (!_this.isVaild()) {
        return;
      }
      _this.opusAudioSender.onProductBuffer(event.data);
    };
    _this.handleIsReadyToSendAudioChange = function (event) {
      if (!_this.isVaild()) {
        return;
      }
      var isReadyToSendAudio = event.isReadyToSendAudio;
      if (isReadyToSendAudio) {
        _this.opusAudioSender.start();
      } else {
        _this.opusAudioSender.stop();
      }
    };
    _this.handleRecorderStop = function () {
      _this.opusAudioSender.onRecordStop();
    };
    _this.handleRequestPrepareFlushRecordBuffer = function (_ref) {
      var prepare = _ref.prepare;
      if (!_this.isVaild()) {
        return;
      }
      _this.flushPrepare = prepare;
      _this.opusAudioSender.start();
    };
    _this.handleDetectAudioBufferEmpty = function () {
      if (_this.flushPrepare) {
        _this.flushPrepare.resolve();
        _this.flushPrepare = undefined;
      }
    };
    var delegate = new OpusAudioSenderDelegate(_assertThisInitialized(_this));
    _this.opusAudioSender = new OpusAudioSender(delegate);
    return _this;
  }
  var _proto = OpusCommand.prototype;
  _proto.onReady = function onReady() {
    var _this$context = this.context,
      recorder = _this$context.recorder,
      connection = _this$context.connection,
      meetingController = _this$context.meetingController;
    connection.on('open', this.handleConnectionOpen);
    connection.on('close', this.handleConnectionClose);
    recorder.on('stop', this.handleRecorderStop);
    recorder.on('dataavailable', this.handleDataavailable);
    meetingController.on('isReadyToSendAudioChange', this.handleIsReadyToSendAudioChange);
    meetingController.on('requestPrepareFlushRecordBuffer', this.handleRequestPrepareFlushRecordBuffer);
    this.opusAudioSender.on('detectAudioBufferEmpty', this.handleDetectAudioBufferEmpty);
  };
  _proto.onDestroy = function onDestroy() {
    var _this$context2 = this.context,
      connection = _this$context2.connection,
      recorder = _this$context2.recorder,
      meetingController = _this$context2.meetingController;
    connection.off('open', this.handleConnectionOpen);
    connection.on('close', this.handleConnectionClose);
    recorder.on('stop', this.handleRecorderStop);
    recorder.off('dataavailable', this.handleDataavailable);
    meetingController.off('isReadyToSendAudioChange', this.handleIsReadyToSendAudioChange);
    meetingController.off('requestPrepareFlushRecordBuffer', this.handleRequestPrepareFlushRecordBuffer);
    this.opusAudioSender.off('detectAudioBufferEmpty', this.handleDetectAudioBufferEmpty);
  };
  _proto.isVaild = function isVaild() {
    var meetingConfig = this.context.meetingConfig;
    return meetingConfig && meetingConfig.format === 'opus';
  };
  return OpusCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/error/taskFailedError.js
var TaskFailedError = /*#__PURE__*/function () {
  function TaskFailedError(status) {
    this.status = void 0;
    this.status = status;
  }
  var _proto = TaskFailedError.prototype;
  _proto.isConcurrencyExceed = function isConcurrencyExceed() {
    return this.status === 43040001;
  };
  _proto.isInvaildMeeting = function isInvaildMeeting() {
    return this.status === 43040002;
  };
  _proto.isOtherError = function isOtherError() {
    return !this.isConcurrencyExceed() && !this.isInvaildMeeting();
  };
  return TaskFailedError;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/startCommand.js







var StartCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(StartCommand, _AbstractCommand);
  function StartCommand() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCommand.call.apply(_AbstractCommand, [this].concat(args)) || this;
    _this.watchMessageKeys = ['TranscriptionStarted', 'TaskFailed'];
    _this.startPrepare = void 0;
    _this.connectPrepare = void 0;
    _this.handleRequestPrepareStartMeeting = /*#__PURE__*/function () {
      var _ref = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee(event) {
        var _this$context, recorder, connection, meetingConfig, meetingController, prepare, isResume;
        return regenerator_default().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this$context = _this.context, recorder = _this$context.recorder, connection = _this$context.connection, meetingConfig = _this$context.meetingConfig, meetingController = _this$context.meetingController;
                prepare = event.prepare, isResume = event.isResume;
                _this.startPrepare = prepare;
                if (!(!meetingConfig || !meetingConfig.serverUrl)) {
                  _context.next = 5;
                  break;
                }
                return _context.abrupt("return");
              case 5:
                _context.prev = 5;
                if (isResume) {
                  recorder.resume();
                } else {
                  recorder.start();
                }
                meetingController.setIsReadyToSendAudio(false);
                connection.connect(meetingConfig.serverUrl);
                _context.next = 11;
                return prepare.waiting;
              case 11:
                _context.next = 18;
                break;
              case 13:
                _context.prev = 13;
                _context.t0 = _context["catch"](5);
                recorder.stop();
                connection.disconnect();
                prepare.reject();
              case 18:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[5, 13]]);
      }));
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }();
    _this.handleConnectionOpen = function () {
      var meetingConfig = _this.context.meetingConfig;
      if (!meetingConfig) {
        return;
      }
      _this.connectPrepare = new Prepare();
      _this.connectPrepare.waiting.then(function () {
        var _this$startPrepare;
        (_this$startPrepare = _this.startPrepare) == null ? void 0 : _this$startPrepare.resolve();
      })["catch"](function () {
        var _this$startPrepare2;
        (_this$startPrepare2 = _this.startPrepare) == null ? void 0 : _this$startPrepare2.reject();
      });
      var payload = {
        format: meetingConfig.format,
        enable_denoise: meetingConfig.enableDenoise
      };
      if (_this.context.isAlibabaVersion) {
        Object.assign(payload, {
          enable_translate: meetingConfig.enableTranslate,
          target_language: meetingConfig.targetLanguage
        });
      } else {
        Object.assign(payload, {
          translate_result_enabled: meetingConfig.enableTranslate,
          translate_languages: meetingConfig.targetLanguage
        });
      }
      _this.sendMessage('StartTranscription', payload);
      report('发送转写请求');
    };
    _this.handleConnectionClose = function () {
      var meetingController = _this.context.meetingController;
      meetingController.setIsReadyToSendAudio(false);
    };
    return _this;
  }
  var _proto = StartCommand.prototype;
  _proto.onReady = function onReady() {
    var _this$context2 = this.context,
      meetingController = _this$context2.meetingController,
      connection = _this$context2.connection;
    this.needCleanups(meetingController.on('requestPrepareStartMeeting', this.handleRequestPrepareStartMeeting), connection.on('open', this.handleConnectionOpen), connection.on('close', this.handleConnectionClose));
  };
  _proto.onMessage = function onMessage(message) {
    if (!this.connectPrepare || this.connectPrepare.isFinished) {
      return;
    }
    var meetingController = this.context.meetingController;
    var _ref2 = (message == null ? void 0 : message.header) || {},
      name = _ref2.name,
      status = _ref2.status;
    if (name === 'TranscriptionStarted') {
      report('收到开始转写指令：transcriptionStarted');
      report('创建转写服务成功');
      this.connectPrepare.resolve();
      meetingController.setIsReadyToSendAudio(true);
    } else if (name === 'TaskFailed') {
      var _this$startPrepare3;
      report('创建转写服务失败');
      var error = new TaskFailedError(status);
      if (error.isConcurrencyExceed()) {
        report('同时进行的推流并发超过限制');
      } else if (error.isInvaildMeeting()) {
        report('实时会议无效或已过期');
      }
      (_this$startPrepare3 = this.startPrepare) == null ? void 0 : _this$startPrepare3.reject({
        error: error
      });
      this.connectPrepare.reject();
    }
    this.connectPrepare = undefined;
  };
  return StartCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/stopCommand.js




var StopCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(StopCommand, _AbstractCommand);
  function StopCommand() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCommand.call.apply(_AbstractCommand, [this].concat(args)) || this;
    _this.watchMessageKeys = ['TranscriptionCompleted', 'TaskFailed'];
    _this.stopPrepare = void 0;
    _this.handleRequestPrepareStopMeeting = /*#__PURE__*/function () {
      var _ref = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee(event) {
        var _this$context, meetingController, connection, recorder, prepare, isPause;
        return regenerator_default().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this$context = _this.context, meetingController = _this$context.meetingController, connection = _this$context.connection, recorder = _this$context.recorder;
                prepare = event.prepare, isPause = event.isPause;
                if (isPause) {
                  recorder.pause();
                } else {
                  recorder.stop();
                }
                if (!connection.isConnected()) {
                  _context.next = 20;
                  break;
                }
                _context.prev = 4;
                _context.next = 7;
                return meetingController.requestPrepareFlushRecordBuffer();
              case 7:
                _context.prev = 7;
                meetingController.setIsReadyToSendAudio(false);
                _this.stopPrepare = prepare;
                _this.sendMessage('StopTranscription');
                _context.prev = 11;
                _context.next = 14;
                return _this.stopPrepare.waiting;
              case 14:
                _context.prev = 14;
                connection.disconnect();
                return _context.finish(14);
              case 17:
                return _context.finish(7);
              case 18:
                _context.next = 21;
                break;
              case 20:
                prepare.resolve();
              case 21:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[4,, 7, 18], [11,, 14, 17]]);
      }));
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }();
    _this.handleConnectionClose = function () {
      _this.stopPrepare = undefined;
    };
    return _this;
  }
  var _proto = StopCommand.prototype;
  _proto.onReady = function onReady() {
    var _this$context2 = this.context,
      meetingController = _this$context2.meetingController,
      connection = _this$context2.connection;
    this.needCleanups(meetingController.on('requestPrepareStopMeeting', this.handleRequestPrepareStopMeeting), connection.on('close', this.handleConnectionClose));
  };
  _proto.onMessage = function onMessage(message) {
    if (!this.stopPrepare) {
      return;
    }
    var _ref2 = (message == null ? void 0 : message.header) || {},
      name = _ref2.name; // 结束会议时遇到TranscriptionStarted和TaskFailed处理方案相同，都当正常结束

    if (name === 'TranscriptionCompleted' || name === 'TaskFailed') {
      if (!this.stopPrepare.isFinished) {
        this.stopPrepare.resolve();
      }
    }
    this.stopPrepare = undefined;
  };
  return StopCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/connectTimeoutCommand.js





var maxRetryDuration = 5 * 60 * 1000; // 最大重试重连时间5分钟

var ConnectTimeoutCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(ConnectTimeoutCommand, _AbstractCommand);
  function ConnectTimeoutCommand() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCommand.call.apply(_AbstractCommand, [this].concat(args)) || this;
    _this.disconnectAt = void 0;
    _this.isReconnecting = false;
    _this.handleConnectionOpen = function () {
      report('创建转写服务连接');
      var meetingController = _this.context.meetingController;
      _this.disconnectAt = undefined;
      if (_this.isReconnecting) {
        meetingController.detectConnectionRetrySuccess();
        _this.isReconnecting = false;
      }
    };
    _this.handleConnectionClose = /*#__PURE__*/function () {
      var _ref = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee(event) {
        var code, _this$context, meetingController, connection, disconnectDuration;
        return regenerator_default().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                code = event.code;
                _this$context = _this.context, meetingController = _this$context.meetingController, connection = _this$context.connection; // 不在会议中或即将结束时，则不会进入重连模式

                if (!(!meetingController.isInMeeting() || meetingController.isLeavingMeeting())) {
                  _context.next = 5;
                  break;
                }
                connection.disconnect();
                return _context.abrupt("return");
              case 5:
                if (code === 1006 || code === 1000) {
                  if (maxRetryDuration > 0) {
                    if (!_this.disconnectAt) {
                      _this.disconnectAt = new Date();
                    }
                    disconnectDuration = new Date().getTime() - _this.disconnectAt.getTime();
                    if (disconnectDuration > maxRetryDuration) {
                      // 重连超过时间，不在重连
                      connection.disconnect();
                      meetingController.detectConnectionRetryTimeout();
                    } else {
                      if (!_this.isReconnecting) {
                        _this.isReconnecting = true;
                        meetingController.detectConnectionRetry();
                      }
                      report('转写服务尝试重连');
                    }
                  }
                } else {
                  // 服务器断开
                  connection.disconnect();
                  meetingController.detectConnectionServerDisconnect();
                }
              case 6:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }();
    return _this;
  }
  var _proto = ConnectTimeoutCommand.prototype;
  _proto.onReady = function onReady() {
    var connection = this.context.connection;
    this.needCleanups(connection.on('open', this.handleConnectionOpen), connection.on('close', this.handleConnectionClose));
  };
  return ConnectTimeoutCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/inMeetingCommand.js


var InMeetingCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(InMeetingCommand, _AbstractCommand);
  function InMeetingCommand() {
    return _AbstractCommand.apply(this, arguments) || this;
  }
  var _proto = InMeetingCommand.prototype;
  _proto.onMessage = function onMessage(message) {
    var meetingController = this.context.meetingController;
    if (!meetingController.isInMeeting()) {
      return;
    }
    var _ref = (message == null ? void 0 : message.header) || {},
      name = _ref.name;
    if (name === 'TaskFailed') {// todo: 识别到一些致命错误，抛出错误
    }
  };
  return InMeetingCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/vocabularyCommand.js




var VocabularyCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(VocabularyCommand, _AbstractCommand);
  function VocabularyCommand() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCommand.call.apply(_AbstractCommand, [this].concat(args)) || this;
    _this.handleRequestPrepareUpdateVocabularies = /*#__PURE__*/function () {
      var _ref = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee(event) {
        var _this$context, meetingController, connection, prepare, vocabularies;
        return regenerator_default().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this$context = _this.context, meetingController = _this$context.meetingController, connection = _this$context.connection;
                prepare = event.prepare, vocabularies = event.vocabularies;
                if (!(!meetingController.isLikeInMeeting() || !connection.isConnected())) {
                  _context.next = 5;
                  break;
                }
                prepare.reject();
                return _context.abrupt("return");
              case 5:
                _this.sendMessage('ControlTranscriber', _this.getMessagePayload(vocabularies));
                prepare.resolve();
              case 7:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }();
    return _this;
  }
  var _proto = VocabularyCommand.prototype;
  _proto.onReady = function onReady() {
    var meetingController = this.context.meetingController;
    this.needCleanups(meetingController.on('requestPrepareUpdateVocabularies', this.handleRequestPrepareUpdateVocabularies));
  };
  _proto.getMessagePayload = function getMessagePayload(vocabularies) {
    var vocabulariesMapping = {};
    vocabularies.forEach(function (v) {
      vocabulariesMapping[v] = 3;
    });
    var payload = {
      vocabulary: vocabulariesMapping
    };
    return payload;
  };
  return VocabularyCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/smartReplaceWordCommand.js




var SmartReplaceWordCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(SmartReplaceWordCommand, _AbstractCommand);
  function SmartReplaceWordCommand() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCommand.call.apply(_AbstractCommand, [this].concat(args)) || this;
    _this.handleRequestPrepareUpdateSmartReplaceWords = /*#__PURE__*/function () {
      var _ref = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee(event) {
        var _this$context, meetingController, connection, prepare, smartWordsMap;
        return regenerator_default().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this$context = _this.context, meetingController = _this$context.meetingController, connection = _this$context.connection;
                prepare = event.prepare, smartWordsMap = event.smartWordsMap;
                if (!(!meetingController.isLikeInMeeting() || !connection.isConnected())) {
                  _context.next = 5;
                  break;
                }
                prepare.reject();
                return _context.abrupt("return");
              case 5:
                _this.sendMessage('UpdateConfig', _this.getMessagePayload(smartWordsMap));
                prepare.resolve();
              case 7:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }();
    return _this;
  }
  var _proto = SmartReplaceWordCommand.prototype;
  _proto.onReady = function onReady() {
    var meetingController = this.context.meetingController;
    this.needCleanups(meetingController.on('requestPrepareUpdateSmartReplaceWords', this.handleRequestPrepareUpdateSmartReplaceWords));
  };
  _proto.getMessagePayload = function getMessagePayload(smartWordsMap) {
    var payload = {
      smart_replace_words: smartWordsMap
    };
    return payload;
  };
  return SmartReplaceWordCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/inMeetingTranslateCommand.js



var InMeetingTranslateCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(InMeetingTranslateCommand, _AbstractCommand);
  function InMeetingTranslateCommand() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCommand.call.apply(_AbstractCommand, [this].concat(args)) || this;
    _this.watchMessageKeys = ['UpdateConfigAck'];
    _this.latestTargetTranslate = '';
    _this.enableTranslateInstructionId = void 0;
    _this.enableTranslatePrepare = void 0;
    _this.disableTranslateInstructionId = void 0;
    _this.disableTranslatePrepare = void 0;
    return _this;
  }
  var _proto = InMeetingTranslateCommand.prototype;
  _proto.onReady = function onReady() {
    var _this2 = this;
    var _this$context = this.context,
      meetingController = _this$context.meetingController,
      connection = _this$context.connection;
    this.needCleanups(meetingController.on('requestPrepareEnableTranslate', function (params) {
      var prepare = params.prepare,
        targetLanguage = params.targetLanguage;
      if (!connection.isConnected()) {
        prepare.resolve();
        return;
      }
      if (_this2.enableTranslateInstructionId) {
        prepare.reject();
        return;
      }
      _this2.enableTranslatePrepare = prepare;
      _this2.latestTargetTranslate = targetLanguage;
      _this2.sendEnableTranslateMessage(targetLanguage);
    }), meetingController.on('requestPrepareDisableTranslate', function (params) {
      var prepare = params.prepare;
      if (!connection.isConnected()) {
        prepare.resolve();
        return;
      }
      if (_this2.disableTranslateInstructionId) {
        prepare.reject();
        return;
      }
      _this2.disableTranslatePrepare = prepare;
      _this2.sendDisableTranslateMessage();
    }));
  };
  _proto.onMessage = function onMessage(message) {
    var meetingController = this.context.meetingController;
    if (!meetingController.isInMeeting()) {
      return;
    }
    var _ref = (message == null ? void 0 : message.header) || {},
      name = _ref.name;
    var _ref2 = message.payload || {},
      instructionId = _ref2.instruction_id;
    if (name === 'UpdateConfigAck' && instructionId) {
      if (this.enableTranslateInstructionId === instructionId) {
        var _this$enableTranslate;
        (_this$enableTranslate = this.enableTranslatePrepare) == null ? void 0 : _this$enableTranslate.resolve();
        this.enableTranslateInstructionId = undefined;
        this.enableTranslatePrepare = undefined;
      } else if (this.disableTranslateInstructionId === instructionId) {
        var _this$disableTranslat;
        (_this$disableTranslat = this.disableTranslatePrepare) == null ? void 0 : _this$disableTranslat.resolve();
        this.disableTranslateInstructionId = undefined;
        this.disableTranslatePrepare = undefined;
      }
    }
  };
  _proto.sendEnableTranslateMessage = function sendEnableTranslateMessage(targetLanguage) {
    this.enableTranslateInstructionId = getUUID();
    this.sendMessage('UpdateConfig', {
      translate_result_enabled: true,
      translate_languages: targetLanguage,
      instruction_id: this.enableTranslateInstructionId
    });
  };
  _proto.sendDisableTranslateMessage = function sendDisableTranslateMessage() {
    this.disableTranslateInstructionId = getUUID();
    this.sendMessage('UpdateConfig', {
      translate_result_enabled: false,
      translate_languages: this.latestTargetTranslate,
      instruction_id: this.disableTranslateInstructionId
    });
  };
  return InMeetingTranslateCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/utils/word.js
var getUniqueId = function () {
  var id = 10000;
  return function () {
    return "W" + ++id;
  };
}();
var word_getWordBySc = function getWordBySc(sc) {
  var _sc$tag;
  return {
    wid: sc.id != null ? String(sc.id) : getUniqueId(),
    beginTime: sc.bt,
    endTime: sc.et,
    sentenceId: String(sc.si),
    text: sc.tc,
    tag: ((_sc$tag = sc.tag) == null ? void 0 : _sc$tag.mark) || '',
    nFix: sc.pt === 1
  };
};
var getWordsBySces = function getWordsBySces(sces) {
  return sces.map(function (sc) {
    return word_getWordBySc(sc);
  });
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/model/book.js




function genDefaultTranscription() {
  return {
    paragraphs: {},
    words: {},
    pids: [],
    appearedWids: {},
    userChangedSidsMap: {}
  };
}
var Book = /*#__PURE__*/function (_Eventer) {
  _inheritsLoose(Book, _Eventer);
  function Book() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _Eventer.call.apply(_Eventer, [this].concat(args)) || this;
    _this.transcription = genDefaultTranscription();
    _this.paragraphVersions = {};
    _this.uniqueId = 0;
    return _this;
  }
  var _proto = Book.prototype;
  _proto.updateParagraphVersion = function updateParagraphVersion() {
    var _this2 = this;
    for (var _len2 = arguments.length, pids = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      pids[_key2] = arguments[_key2];
    }
    pids.forEach(function (pid) {
      _this2.paragraphVersions[pid] = ++_this2.uniqueId;
    });
  };
  _proto.resetModelValue = function resetModelValue() {
    this.transcription = genDefaultTranscription();
    this.paragraphVersions = {};
    this.uniqueId = 0;
  };
  _proto.updateWord = function updateWord(pid, wid, word, userChangeText) {
    this.transcription.words[wid] = word;
    if (userChangeText) {
      this.transcription.userChangedSidsMap[word.sentenceId] = true;
    }
    this.updateParagraphVersion(pid);
    this.emit('wordChange', {
      pid: pid,
      wid: wid,
      word: word
    });
    this.emit('paragraphChangeSpecific', {
      addParagraphPids: [],
      updateParagraphPids: [pid],
      removeParagraphPids: []
    });
  };
  _proto.updateWords = function updateWords(pid, words) {
    var _this3 = this;
    words.forEach(function (word) {
      _this3.transcription.words[word.wid] = word;
    });
    this.updateParagraphVersion(pid);
    this.emit('paragraphChange', {
      pid: pid
    });
    this.emit('paragraphChangeSpecific', {
      addParagraphPids: [],
      updateParagraphPids: [pid],
      removeParagraphPids: []
    });
  };
  _proto.deleteWord = function deleteWord(pid, wid, newOrder) {
    delete this.transcription.words[wid];
    this.transcription.paragraphs[pid].wids = newOrder;
    this.updateParagraphVersion(pid);
    this.emit('paragraphChange', {
      pid: pid
    });
    this.emit('paragraphChangeSpecific', {
      addParagraphPids: [],
      updateParagraphPids: [pid],
      removeParagraphPids: []
    });
  };
  _proto.addWord = function addWord(pid, word, newOrder) {
    this.transcription.words[word.wid] = word;
    this.transcription.paragraphs[pid].wids = newOrder;
    this.transcription.appearedWids[word.wid] = true;
    this.updateParagraphVersion(pid);
    this.emit('paragraphChange', {
      pid: pid
    });
    this.emit('paragraphChangeSpecific', {
      addParagraphPids: [],
      updateParagraphPids: [pid],
      removeParagraphPids: []
    });
  };
  _proto.isAppearedWid = function isAppearedWid(wid) {
    var _this$transcription$a;
    return (_this$transcription$a = this.transcription.appearedWids[wid]) != null ? _this$transcription$a : false;
  };
  _proto.moveWord = function moveWord(originPid, originNewOrder, targetPid, targetNewOrder) {
    this.transcription.paragraphs[originPid].wids = originNewOrder;
    this.transcription.paragraphs[targetPid].wids = targetNewOrder;
    this.updateParagraphVersion(originPid, targetPid);
    this.emit('paragraphChange', {
      pid: originPid
    });
    this.emit('paragraphChange', {
      pid: targetPid
    });
    this.emit('paragraphChangeSpecific', {
      addParagraphPids: [],
      updateParagraphPids: [originPid, targetPid],
      removeParagraphPids: []
    });
  };
  _proto.addParagraph = function addParagraph(prevPid, pid, paragraph) {
    var pids = this.transcription.pids;
    if (prevPid === undefined) {
      pids.unshift(pid);
    } else {
      var pos = pids.indexOf(prevPid);
      if (pos !== -1) {
        pids.splice(pos + 1, 0, pid);
      }
    }
    this.transcription.paragraphs[pid] = paragraph;
    var maybeChangedPids = prevPid ? [prevPid, pid] : [pid];
    this.updateParagraphVersion(pid);
    this.emit('paragraphListChange', {
      maybeChangedPids: maybeChangedPids
    });
    this.emit('paragraphChangeSpecific', {
      addParagraphPids: [pid],
      updateParagraphPids: [],
      removeParagraphPids: []
    });
  };
  _proto.removeParagraph = function removeParagraph(pid) {
    var _removeParagraphs;
    var _this$transcription = this.transcription,
      pids = _this$transcription.pids,
      paragraphs = _this$transcription.paragraphs;
    var willDeletedParagraph = paragraphs[pid];
    var pos = pids.indexOf(pid);
    var prevPid = pids[pos - 1];
    var nextPid = pids[pos + 1];
    if (pos !== -1) {
      pids.splice(pos, 1);
    }
    delete paragraphs[pid];
    var maybeChangedPids = [prevPid, nextPid].filter(function (i) {
      return i != null;
    });
    this.updateParagraphVersion.apply(this, maybeChangedPids.concat([pid]));
    this.emit('paragraphListChange', {
      maybeChangedPids: maybeChangedPids
    });
    this.emit('paragraphChangeSpecific', {
      addParagraphPids: [],
      updateParagraphPids: [],
      removeParagraphPids: [pid],
      removeParagraphs: (_removeParagraphs = {}, _removeParagraphs[pid] = willDeletedParagraph, _removeParagraphs)
    });
  };
  _proto.updateParagraph = function updateParagraph(pid, paragraph) {
    var oldParagraph = this.transcription.paragraphs[pid];
    this.transcription.paragraphs[pid] = paragraph;
    this.updateParagraphVersion(pid);
    this.emit('paragraphChange', {
      pid: pid
    });
    if (oldParagraph && oldParagraph.isUnfix && !paragraph.isUnfix) {
      this.emit('lastUnfixPidChange', {
        pid: pid
      });
    }
    this.emit('paragraphChangeSpecific', {
      addParagraphPids: [],
      updateParagraphPids: [pid],
      removeParagraphPids: []
    });
  };
  _proto.getWordBySc = function getWordBySc(_sc) {
    return word_getWordBySc(_sc);
  };
  _proto.getPByPid = function getPByPid(pid) {
    var paragraph = this.transcription.paragraphs[pid];
    var allWords = this.transcription.words;
    if (!paragraph) {
      return undefined;
    }
    var words = paragraph.wids.map(function (wid) {
      return allWords[wid];
    });
    var sc = words.map(function (word) {
      return extends_extends({
        id: Number(word.wid),
        bt: word.beginTime,
        et: word.endTime,
        si: Number(word.sentenceId),
        tc: word.text
      }, word.tag ? {
        tag: {
          mark: word.tag
        }
      } : {});
    });
    return {
      pi: pid,
      ui: paragraph.uid,
      sc: sc
    };
  };
  _proto.isUserChangedSentence = function isUserChangedSentence(sid) {
    var _this$transcription$u;
    return (_this$transcription$u = this.transcription.userChangedSidsMap[sid]) != null ? _this$transcription$u : false;
  };
  _proto.fromJSON = function fromJSON(model) {
    var _this4 = this;
    var paragraphs = {};
    var pids = [];
    var words = {};
    model.pg.forEach(function (_pg) {
      if (pids.indexOf(_pg.pi) > -1) {
        // 避免重复PID导致听悟后续流程错误，重复PID检测目前在应用层，这里暂时不做上报
        return;
      }
      var wids = [];
      _pg.sc.forEach(function (_sc) {
        var word = _this4.getWordBySc(_sc);
        words[word.wid] = word;
        wids.push(word.wid);
      });
      paragraphs[_pg.pi] = {
        pid: _pg.pi,
        uid: _pg.ui,
        wids: wids
      };
      pids.push(_pg.pi);
    });
    this.transcription = {
      paragraphs: paragraphs,
      pids: pids,
      words: words,
      appearedWids: {},
      userChangedSidsMap: {}
    };
  };
  _proto.toJSON = function toJSON() {
    var _this5 = this;
    var pg = [];
    this.transcription.pids.forEach(function (pid) {
      var p = _this5.getPByPid(pid);
      if (p) {
        pg.push(p);
      }
    });
    return {
      pg: pg
    };
  };
  return Book;
}(Eventer);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/persist/op.js
function createOperation(action, payload) {
  return {
    action: action,
    payload: payload
  };
}
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/model/op.js

var invertOp = function invertOp(op) {
  if (op.action === 'updateWord') {
    var _op$payload = op.payload,
      pid = _op$payload.pid,
      wid = _op$payload.wid,
      oldValue = _op$payload.oldValue,
      newValue = _op$payload.newValue;
    return createOperation('updateWord', {
      pid: pid,
      wid: wid,
      newValue: oldValue,
      oldValue: newValue
    });
  } else if (op.action === 'updateWords') {
    var _op$payload2 = op.payload,
      _pid = _op$payload2.pid,
      _oldValue = _op$payload2.oldValue,
      _newValue = _op$payload2.newValue;
    return createOperation('updateWords', {
      pid: _pid,
      newValue: _oldValue,
      oldValue: _newValue
    });
  } else if (op.action === 'deleteWord') {
    var _op$payload3 = op.payload,
      _pid2 = _op$payload3.pid,
      _wid = _op$payload3.wid,
      word = _op$payload3.word,
      oldOrder = _op$payload3.oldOrder,
      newOrder = _op$payload3.newOrder;
    return createOperation('addWord', {
      pid: _pid2,
      wid: _wid,
      word: word,
      oldOrder: newOrder,
      newOrder: oldOrder
    });
  } else if (op.action === 'addWord') {
    var _op$payload4 = op.payload,
      _pid3 = _op$payload4.pid,
      _wid2 = _op$payload4.wid,
      _word = _op$payload4.word,
      _oldOrder = _op$payload4.oldOrder,
      _newOrder = _op$payload4.newOrder;
    return createOperation('deleteWord', {
      pid: _pid3,
      wid: _wid2,
      word: _word,
      oldOrder: _newOrder,
      newOrder: _oldOrder
    });
  } else if (op.action === 'addParagraph') {
    var _op$payload5 = op.payload,
      prevPid = _op$payload5.prevPid,
      _pid4 = _op$payload5.pid,
      paragraph = _op$payload5.paragraph;
    return createOperation('removeParagraph', {
      prevPid: prevPid,
      pid: _pid4,
      paragraph: paragraph
    });
  } else if (op.action === 'removeParagraph') {
    var _op$payload6 = op.payload,
      _prevPid = _op$payload6.prevPid,
      _pid5 = _op$payload6.pid,
      _paragraph = _op$payload6.paragraph;
    return createOperation('addParagraph', {
      prevPid: _prevPid,
      pid: _pid5,
      paragraph: _paragraph
    });
  } else if (op.action === 'updateParagraph') {
    var _op$payload7 = op.payload,
      _pid6 = _op$payload7.pid,
      oldParagraph = _op$payload7.oldParagraph,
      _paragraph2 = _op$payload7.paragraph;
    return createOperation('updateParagraph', {
      pid: _pid6,
      oldParagraph: _paragraph2,
      paragraph: oldParagraph
    });
  } else if (op.action === 'moveWord') {
    var _op$payload8 = op.payload,
      originPid = _op$payload8.originPid,
      targetPid = _op$payload8.targetPid,
      originOldOrder = _op$payload8.originOldOrder,
      originNewOrder = _op$payload8.originNewOrder,
      targetOldOrder = _op$payload8.targetOldOrder,
      targetNewOrder = _op$payload8.targetNewOrder;
    return createOperation('moveWord', {
      originPid: originPid,
      targetPid: targetPid,
      originOldOrder: originNewOrder,
      originNewOrder: originOldOrder,
      targetOldOrder: targetNewOrder,
      targetNewOrder: targetOldOrder
    });
  }
  return null;
};
var applyOp = function applyOp(book, op) {
  if (op.action === 'updateWord') {
    var _op$payload9 = op.payload,
      pid = _op$payload9.pid,
      wid = _op$payload9.wid,
      newValue = _op$payload9.newValue,
      userChangeText = _op$payload9.userChangeText;
    book.updateWord(pid, wid, newValue, userChangeText);
  } else if (op.action === 'updateWords') {
    var _op$payload10 = op.payload,
      _pid7 = _op$payload10.pid,
      _newValue2 = _op$payload10.newValue;
    book.updateWords(_pid7, _newValue2);
  } else if (op.action === 'deleteWord') {
    var _op$payload11 = op.payload,
      _pid8 = _op$payload11.pid,
      _wid3 = _op$payload11.wid,
      newOrder = _op$payload11.newOrder;
    book.deleteWord(_pid8, _wid3, newOrder);
  } else if (op.action === 'addWord') {
    var _op$payload12 = op.payload,
      _pid9 = _op$payload12.pid,
      word = _op$payload12.word,
      _newOrder2 = _op$payload12.newOrder;
    book.addWord(_pid9, word, _newOrder2);
  } else if (op.action === 'addParagraph') {
    var _op$payload13 = op.payload,
      prevPid = _op$payload13.prevPid,
      _pid10 = _op$payload13.pid,
      paragraph = _op$payload13.paragraph;
    book.addParagraph(prevPid, _pid10, paragraph);
  } else if (op.action === 'removeParagraph') {
    var _pid11 = op.payload.pid;
    book.removeParagraph(_pid11);
  } else if (op.action === 'updateParagraph') {
    var _op$payload14 = op.payload,
      _pid12 = _op$payload14.pid,
      _paragraph3 = _op$payload14.paragraph;
    book.updateParagraph(_pid12, _paragraph3);
  } else if (op.action === 'moveWord') {
    var _op$payload15 = op.payload,
      originPid = _op$payload15.originPid,
      originNewOrder = _op$payload15.originNewOrder,
      targetPid = _op$payload15.targetPid,
      targetNewOrder = _op$payload15.targetNewOrder;
    book.moveWord(originPid, originNewOrder, targetPid, targetNewOrder);
  }
  return invertOp(op);
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/model/index.js



var Model = /*#__PURE__*/function () {
  function Model() {
    this.book = void 0;
    this.book = new Book();
  }
  var _proto = Model.prototype;
  _proto.fromJSON = function fromJSON(json) {
    this.book.fromJSON(json);
  };
  _proto.toJSON = function toJSON() {
    return this.book.toJSON();
  };
  _proto.serialize = function serialize() {
    var clone = this.toJSON();
    return JSON.stringify(clone);
  };
  _proto.deserialize = function deserialize(jsonStr) {
    try {
      var json = JSON.parse(jsonStr);
      this.fromJSON(json);
    } catch (error) {
      // TODO: report this error
      console.error(error);
      throw error;
    }
  };
  _proto.applyOps = function applyOps(ops) {
    var _this = this;
    var reverseOps = [];
    ops.forEach(function (op) {
      var reverseOp = applyOp(_this.book, op);
      reverseOps.unshift(reverseOp);
    });
    return reverseOps;
  };
  return Model;
}();
;// CONCATENATED MODULE: ./node_modules/_css-line-break@2.1.0@css-line-break/dist/css-line-break.es5.js
/*
 * css-line-break 2.1.0 <https://github.com/niklasvh/css-line-break#readme>
 * Copyright (c) 2022 Niklas von Hertzen <https://hertzen.com>
 * Released under MIT License
 */
var toCodePoints = function toCodePoints(str) {
  var codePoints = [];
  var i = 0;
  var length = str.length;
  while (i < length) {
    var value = str.charCodeAt(i++);
    if (value >= 0xd800 && value <= 0xdbff && i < length) {
      var extra = str.charCodeAt(i++);
      if ((extra & 0xfc00) === 0xdc00) {
        codePoints.push(((value & 0x3ff) << 10) + (extra & 0x3ff) + 0x10000);
      } else {
        codePoints.push(value);
        i--;
      }
    } else {
      codePoints.push(value);
    }
  }
  return codePoints;
};
var fromCodePoint = function fromCodePoint() {
  var codePoints = [];
  for (var _i = 0; _i < arguments.length; _i++) {
    codePoints[_i] = arguments[_i];
  }
  if (String.fromCodePoint) {
    return String.fromCodePoint.apply(String, codePoints);
  }
  var length = codePoints.length;
  if (!length) {
    return '';
  }
  var codeUnits = [];
  var index = -1;
  var result = '';
  while (++index < length) {
    var codePoint = codePoints[index];
    if (codePoint <= 0xffff) {
      codeUnits.push(codePoint);
    } else {
      codePoint -= 0x10000;
      codeUnits.push((codePoint >> 10) + 0xd800, codePoint % 0x400 + 0xdc00);
    }
    if (index + 1 === length || codeUnits.length > 0x4000) {
      result += String.fromCharCode.apply(String, codeUnits);
      codeUnits.length = 0;
    }
  }
  return result;
};
var chars$2 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
// Use a lookup table to find the index.
var lookup$2 = typeof Uint8Array === 'undefined' ? [] : new Uint8Array(256);
for (var i$2 = 0; i$2 < chars$2.length; i$2++) {
  lookup$2[chars$2.charCodeAt(i$2)] = i$2;
}

/*
 * utrie 1.0.2 <https://github.com/niklasvh/utrie>
 * Copyright (c) 2022 Niklas von Hertzen <https://hertzen.com>
 * Released under MIT License
 */
var chars$1 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
// Use a lookup table to find the index.
var lookup$1 = typeof Uint8Array === 'undefined' ? [] : new Uint8Array(256);
for (var i$1 = 0; i$1 < chars$1.length; i$1++) {
  lookup$1[chars$1.charCodeAt(i$1)] = i$1;
}
var decode = function decode(base64) {
  var bufferLength = base64.length * 0.75,
    len = base64.length,
    i,
    p = 0,
    encoded1,
    encoded2,
    encoded3,
    encoded4;
  if (base64[base64.length - 1] === '=') {
    bufferLength--;
    if (base64[base64.length - 2] === '=') {
      bufferLength--;
    }
  }
  var buffer = typeof ArrayBuffer !== 'undefined' && typeof Uint8Array !== 'undefined' && typeof Uint8Array.prototype.slice !== 'undefined' ? new ArrayBuffer(bufferLength) : new Array(bufferLength);
  var bytes = Array.isArray(buffer) ? buffer : new Uint8Array(buffer);
  for (i = 0; i < len; i += 4) {
    encoded1 = lookup$1[base64.charCodeAt(i)];
    encoded2 = lookup$1[base64.charCodeAt(i + 1)];
    encoded3 = lookup$1[base64.charCodeAt(i + 2)];
    encoded4 = lookup$1[base64.charCodeAt(i + 3)];
    bytes[p++] = encoded1 << 2 | encoded2 >> 4;
    bytes[p++] = (encoded2 & 15) << 4 | encoded3 >> 2;
    bytes[p++] = (encoded3 & 3) << 6 | encoded4 & 63;
  }
  return buffer;
};
var polyUint16Array = function polyUint16Array(buffer) {
  var length = buffer.length;
  var bytes = [];
  for (var i = 0; i < length; i += 2) {
    bytes.push(buffer[i + 1] << 8 | buffer[i]);
  }
  return bytes;
};
var polyUint32Array = function polyUint32Array(buffer) {
  var length = buffer.length;
  var bytes = [];
  for (var i = 0; i < length; i += 4) {
    bytes.push(buffer[i + 3] << 24 | buffer[i + 2] << 16 | buffer[i + 1] << 8 | buffer[i]);
  }
  return bytes;
};

/** Shift size for getting the index-2 table offset. */
var UTRIE2_SHIFT_2 = 5;
/** Shift size for getting the index-1 table offset. */
var UTRIE2_SHIFT_1 = 6 + 5;
/**
 * Shift size for shifting left the index array values.
 * Increases possible data size with 16-bit index values at the cost
 * of compactability.
 * This requires data blocks to be aligned by UTRIE2_DATA_GRANULARITY.
 */
var UTRIE2_INDEX_SHIFT = 2;
/**
 * Difference between the two shift sizes,
 * for getting an index-1 offset from an index-2 offset. 6=11-5
 */
var UTRIE2_SHIFT_1_2 = UTRIE2_SHIFT_1 - UTRIE2_SHIFT_2;
/**
 * The part of the index-2 table for U+D800..U+DBFF stores values for
 * lead surrogate code _units_ not code _points_.
 * Values for lead surrogate code _points_ are indexed with this portion of the table.
 * Length=32=0x20=0x400>>UTRIE2_SHIFT_2. (There are 1024=0x400 lead surrogates.)
 */
var UTRIE2_LSCP_INDEX_2_OFFSET = 0x10000 >> UTRIE2_SHIFT_2;
/** Number of entries in a data block. 32=0x20 */
var UTRIE2_DATA_BLOCK_LENGTH = 1 << UTRIE2_SHIFT_2;
/** Mask for getting the lower bits for the in-data-block offset. */
var UTRIE2_DATA_MASK = UTRIE2_DATA_BLOCK_LENGTH - 1;
var UTRIE2_LSCP_INDEX_2_LENGTH = 0x400 >> UTRIE2_SHIFT_2;
/** Count the lengths of both BMP pieces. 2080=0x820 */
var UTRIE2_INDEX_2_BMP_LENGTH = UTRIE2_LSCP_INDEX_2_OFFSET + UTRIE2_LSCP_INDEX_2_LENGTH;
/**
 * The 2-byte UTF-8 version of the index-2 table follows at offset 2080=0x820.
 * Length 32=0x20 for lead bytes C0..DF, regardless of UTRIE2_SHIFT_2.
 */
var UTRIE2_UTF8_2B_INDEX_2_OFFSET = UTRIE2_INDEX_2_BMP_LENGTH;
var UTRIE2_UTF8_2B_INDEX_2_LENGTH = 0x800 >> 6; /* U+0800 is the first code point after 2-byte UTF-8 */
/**
 * The index-1 table, only used for supplementary code points, at offset 2112=0x840.
 * Variable length, for code points up to highStart, where the last single-value range starts.
 * Maximum length 512=0x200=0x100000>>UTRIE2_SHIFT_1.
 * (For 0x100000 supplementary code points U+10000..U+10ffff.)
 *
 * The part of the index-2 table for supplementary code points starts
 * after this index-1 table.
 *
 * Both the index-1 table and the following part of the index-2 table
 * are omitted completely if there is only BMP data.
 */
var UTRIE2_INDEX_1_OFFSET = UTRIE2_UTF8_2B_INDEX_2_OFFSET + UTRIE2_UTF8_2B_INDEX_2_LENGTH;
/**
 * Number of index-1 entries for the BMP. 32=0x20
 * This part of the index-1 table is omitted from the serialized form.
 */
var UTRIE2_OMITTED_BMP_INDEX_1_LENGTH = 0x10000 >> UTRIE2_SHIFT_1;
/** Number of entries in an index-2 block. 64=0x40 */
var UTRIE2_INDEX_2_BLOCK_LENGTH = 1 << UTRIE2_SHIFT_1_2;
/** Mask for getting the lower bits for the in-index-2-block offset. */
var UTRIE2_INDEX_2_MASK = UTRIE2_INDEX_2_BLOCK_LENGTH - 1;
var slice16 = function slice16(view, start, end) {
  if (view.slice) {
    return view.slice(start, end);
  }
  return new Uint16Array(Array.prototype.slice.call(view, start, end));
};
var slice32 = function slice32(view, start, end) {
  if (view.slice) {
    return view.slice(start, end);
  }
  return new Uint32Array(Array.prototype.slice.call(view, start, end));
};
var createTrieFromBase64 = function createTrieFromBase64(base64, _byteLength) {
  var buffer = decode(base64);
  var view32 = Array.isArray(buffer) ? polyUint32Array(buffer) : new Uint32Array(buffer);
  var view16 = Array.isArray(buffer) ? polyUint16Array(buffer) : new Uint16Array(buffer);
  var headerLength = 24;
  var index = slice16(view16, headerLength / 2, view32[4] / 2);
  var data = view32[5] === 2 ? slice16(view16, (headerLength + view32[4]) / 2) : slice32(view32, Math.ceil((headerLength + view32[4]) / 4));
  return new Trie(view32[0], view32[1], view32[2], view32[3], index, data);
};
var Trie = /** @class */function () {
  function Trie(initialValue, errorValue, highStart, highValueIndex, index, data) {
    this.initialValue = initialValue;
    this.errorValue = errorValue;
    this.highStart = highStart;
    this.highValueIndex = highValueIndex;
    this.index = index;
    this.data = data;
  }
  /**
   * Get the value for a code point as stored in the Trie.
   *
   * @param codePoint the code point
   * @return the value
   */
  Trie.prototype.get = function (codePoint) {
    var ix;
    if (codePoint >= 0) {
      if (codePoint < 0x0d800 || codePoint > 0x0dbff && codePoint <= 0x0ffff) {
        // Ordinary BMP code point, excluding leading surrogates.
        // BMP uses a single level lookup.  BMP index starts at offset 0 in the Trie2 index.
        // 16 bit data is stored in the index array itself.
        ix = this.index[codePoint >> UTRIE2_SHIFT_2];
        ix = (ix << UTRIE2_INDEX_SHIFT) + (codePoint & UTRIE2_DATA_MASK);
        return this.data[ix];
      }
      if (codePoint <= 0xffff) {
        // Lead Surrogate Code Point.  A Separate index section is stored for
        // lead surrogate code units and code points.
        //   The main index has the code unit data.
        //   For this function, we need the code point data.
        // Note: this expression could be refactored for slightly improved efficiency, but
        //       surrogate code points will be so rare in practice that it's not worth it.
        ix = this.index[UTRIE2_LSCP_INDEX_2_OFFSET + (codePoint - 0xd800 >> UTRIE2_SHIFT_2)];
        ix = (ix << UTRIE2_INDEX_SHIFT) + (codePoint & UTRIE2_DATA_MASK);
        return this.data[ix];
      }
      if (codePoint < this.highStart) {
        // Supplemental code point, use two-level lookup.
        ix = UTRIE2_INDEX_1_OFFSET - UTRIE2_OMITTED_BMP_INDEX_1_LENGTH + (codePoint >> UTRIE2_SHIFT_1);
        ix = this.index[ix];
        ix += codePoint >> UTRIE2_SHIFT_2 & UTRIE2_INDEX_2_MASK;
        ix = this.index[ix];
        ix = (ix << UTRIE2_INDEX_SHIFT) + (codePoint & UTRIE2_DATA_MASK);
        return this.data[ix];
      }
      if (codePoint <= 0x10ffff) {
        return this.data[this.highValueIndex];
      }
    }
    // Fall through.  The code point is outside of the legal range of 0..0x10ffff.
    return this.errorValue;
  };
  return Trie;
}();

/*
 * base64-arraybuffer 1.0.2 <https://github.com/niklasvh/base64-arraybuffer>
 * Copyright (c) 2022 Niklas von Hertzen <https://hertzen.com>
 * Released under MIT License
 */
var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
// Use a lookup table to find the index.
var lookup = typeof Uint8Array === 'undefined' ? [] : new Uint8Array(256);
for (var i = 0; i < chars.length; i++) {
  lookup[chars.charCodeAt(i)] = i;
}
var base64 = 'KwAAAAAAAAAACA4AUD0AADAgAAACAAAAAAAIABAAGABAAEgAUABYAGAAaABgAGgAYgBqAF8AZwBgAGgAcQB5AHUAfQCFAI0AlQCdAKIAqgCyALoAYABoAGAAaABgAGgAwgDKAGAAaADGAM4A0wDbAOEA6QDxAPkAAQEJAQ8BFwF1AH0AHAEkASwBNAE6AUIBQQFJAVEBWQFhAWgBcAF4ATAAgAGGAY4BlQGXAZ8BpwGvAbUBvQHFAc0B0wHbAeMB6wHxAfkBAQIJAvEBEQIZAiECKQIxAjgCQAJGAk4CVgJeAmQCbAJ0AnwCgQKJApECmQKgAqgCsAK4ArwCxAIwAMwC0wLbAjAA4wLrAvMC+AIAAwcDDwMwABcDHQMlAy0DNQN1AD0DQQNJA0kDSQNRA1EDVwNZA1kDdQB1AGEDdQBpA20DdQN1AHsDdQCBA4kDkQN1AHUAmQOhA3UAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AKYDrgN1AHUAtgO+A8YDzgPWAxcD3gPjA+sD8wN1AHUA+wMDBAkEdQANBBUEHQQlBCoEFwMyBDgEYABABBcDSARQBFgEYARoBDAAcAQzAXgEgASIBJAEdQCXBHUAnwSnBK4EtgS6BMIEyAR1AHUAdQB1AHUAdQCVANAEYABgAGAAYABgAGAAYABgANgEYADcBOQEYADsBPQE/AQEBQwFFAUcBSQFLAU0BWQEPAVEBUsFUwVbBWAAYgVgAGoFcgV6BYIFigWRBWAAmQWfBaYFYABgAGAAYABgAKoFYACxBbAFuQW6BcEFwQXHBcEFwQXPBdMF2wXjBeoF8gX6BQIGCgYSBhoGIgYqBjIGOgZgAD4GRgZMBmAAUwZaBmAAYABgAGAAYABgAGAAYABgAGAAYABgAGIGYABpBnAGYABgAGAAYABgAGAAYABgAGAAYAB4Bn8GhQZgAGAAYAB1AHcDFQSLBmAAYABgAJMGdQA9A3UAmwajBqsGqwaVALMGuwbDBjAAywbSBtIG1QbSBtIG0gbSBtIG0gbdBuMG6wbzBvsGAwcLBxMHAwcbByMHJwcsBywHMQcsB9IGOAdAB0gHTgfSBkgHVgfSBtIG0gbSBtIG0gbSBtIG0gbSBiwHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAdgAGAALAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAdbB2MHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsB2kH0gZwB64EdQB1AHUAdQB1AHUAdQB1AHUHfQdgAIUHjQd1AHUAlQedB2AAYAClB6sHYACzB7YHvgfGB3UAzgfWBzMB3gfmB1EB7gf1B/0HlQENAQUIDQh1ABUIHQglCBcDLQg1CD0IRQhNCEEDUwh1AHUAdQBbCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIaQhjCGQIZQhmCGcIaAhpCGMIZAhlCGYIZwhoCGkIYwhkCGUIZghnCGgIcAh3CHoIMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwAIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIgggwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAALAcsBywHLAcsBywHLAcsBywHLAcsB4oILAcsB44I0gaWCJ4Ipgh1AHUAqgiyCHUAdQB1AHUAdQB1AHUAdQB1AHUAtwh8AXUAvwh1AMUIyQjRCNkI4AjoCHUAdQB1AO4I9gj+CAYJDgkTCS0HGwkjCYIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiCCIIIggiAAIAAAAFAAYABgAGIAXwBgAHEAdQBFAJUAogCyAKAAYABgAEIA4ABGANMA4QDxAMEBDwE1AFwBLAE6AQEBUQF4QkhCmEKoQrhCgAHIQsAB0MLAAcABwAHAAeDC6ABoAHDCwMMAAcABwAHAAdDDGMMAAcAB6MM4wwjDWMNow3jDaABoAGgAaABoAGgAaABoAGgAaABoAGgAaABoAGgAaABoAGgAaABoAEjDqABWw6bDqABpg6gAaABoAHcDvwOPA+gAaABfA/8DvwO/A78DvwO/A78DvwO/A78DvwO/A78DvwO/A78DvwO/A78DvwO/A78DvwO/A78DvwO/A78DpcPAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcABwAHAAcAB9cPKwkyCToJMAB1AHUAdQBCCUoJTQl1AFUJXAljCWcJawkwADAAMAAwAHMJdQB2CX4JdQCECYoJjgmWCXUAngkwAGAAYABxAHUApgn3A64JtAl1ALkJdQDACTAAMAAwADAAdQB1AHUAdQB1AHUAdQB1AHUAowYNBMUIMAAwADAAMADICcsJ0wnZCRUE4QkwAOkJ8An4CTAAMAB1AAAKvwh1AAgKDwoXCh8KdQAwACcKLgp1ADYKqAmICT4KRgowADAAdQB1AE4KMAB1AFYKdQBeCnUAZQowADAAMAAwADAAMAAwADAAMAAVBHUAbQowADAAdQC5CXUKMAAwAHwBxAijBogEMgF9CoQKiASMCpQKmgqIBKIKqgquCogEDQG2Cr4KxgrLCjAAMADTCtsKCgHjCusK8Qr5CgELMAAwADAAMAB1AIsECQsRC3UANAEZCzAAMAAwADAAMAB1ACELKQswAHUANAExCzkLdQBBC0kLMABRC1kLMAAwADAAMAAwADAAdQBhCzAAMAAwAGAAYABpC3ELdwt/CzAAMACHC4sLkwubC58Lpwt1AK4Ltgt1APsDMAAwADAAMAAwADAAMAAwAL4LwwvLC9IL1wvdCzAAMADlC+kL8Qv5C/8LSQswADAAMAAwADAAMAAwADAAMAAHDDAAMAAwADAAMAAODBYMHgx1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1ACYMMAAwADAAdQB1AHUALgx1AHUAdQB1AHUAdQA2DDAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwAHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AD4MdQBGDHUAdQB1AHUAdQB1AEkMdQB1AHUAdQB1AFAMMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwAHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQBYDHUAdQB1AF8MMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUA+wMVBGcMMAAwAHwBbwx1AHcMfwyHDI8MMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAYABgAJcMMAAwADAAdQB1AJ8MlQClDDAAMACtDCwHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsB7UMLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHdQB1AHUAdQB1AHUAdQB1AHUAdQB1AHUAdQB1AA0EMAC9DDAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAsBywHLAcsBywHLAcsBywHLQcwAMEMyAwsBywHLAcsBywHLAcsBywHLAcsBywHzAwwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwAHUAdQB1ANQM2QzhDDAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMABgAGAAYABgAGAAYABgAOkMYADxDGAA+AwADQYNYABhCWAAYAAODTAAMAAwADAAFg1gAGAAHg37AzAAMAAwADAAYABgACYNYAAsDTQNPA1gAEMNPg1LDWAAYABgAGAAYABgAGAAYABgAGAAUg1aDYsGVglhDV0NcQBnDW0NdQ15DWAAYABgAGAAYABgAGAAYABgAGAAYABgAGAAYABgAGAAlQCBDZUAiA2PDZcNMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAnw2nDTAAMAAwADAAMAAwAHUArw23DTAAMAAwADAAMAAwADAAMAAwADAAMAB1AL8NMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAB1AHUAdQB1AHUAdQDHDTAAYABgAM8NMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAA1w11ANwNMAAwAD0B5A0wADAAMAAwADAAMADsDfQN/A0EDgwOFA4wABsOMAAwADAAMAAwADAAMAAwANIG0gbSBtIG0gbSBtIG0gYjDigOwQUuDsEFMw7SBjoO0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIGQg5KDlIOVg7SBtIGXg5lDm0OdQ7SBtIGfQ6EDooOjQ6UDtIGmg6hDtIG0gaoDqwO0ga0DrwO0gZgAGAAYADEDmAAYAAkBtIGzA5gANIOYADaDokO0gbSBt8O5w7SBu8O0gb1DvwO0gZgAGAAxA7SBtIG0gbSBtIGYABgAGAAYAAED2AAsAUMD9IG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIGFA8sBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAccD9IGLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHJA8sBywHLAcsBywHLAccDywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywPLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAc0D9IG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIGLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAccD9IG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIGFA8sBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHLAcsBywHPA/SBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gbSBtIG0gYUD0QPlQCVAJUAMAAwADAAMACVAJUAlQCVAJUAlQCVAEwPMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAA//8EAAQABAAEAAQABAAEAAQABAANAAMAAQABAAIABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQACgATABcAHgAbABoAHgAXABYAEgAeABsAGAAPABgAHABLAEsASwBLAEsASwBLAEsASwBLABgAGAAeAB4AHgATAB4AUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQABYAGwASAB4AHgAeAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAWAA0AEQAeAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAAQABAAEAAQABAAFAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAJABYAGgAbABsAGwAeAB0AHQAeAE8AFwAeAA0AHgAeABoAGwBPAE8ADgBQAB0AHQAdAE8ATwAXAE8ATwBPABYAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAB0AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAdAFAAUABQAFAAUABQAFAAUAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAFAAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAeAB4AHgAeAFAATwBAAE8ATwBPAEAATwBQAFAATwBQAB4AHgAeAB4AHgAeAB0AHQAdAB0AHgAdAB4ADgBQAFAAUABQAFAAHgAeAB4AHgAeAB4AHgBQAB4AUAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4ABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAJAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAkACQAJAAkACQAJAAkABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAeAB4AHgAeAFAAHgAeAB4AKwArAFAAUABQAFAAGABQACsAKwArACsAHgAeAFAAHgBQAFAAUAArAFAAKwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4ABAAEAAQABAAEAAQABAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAUAAeAB4AHgAeAB4AHgBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAYAA0AKwArAB4AHgAbACsABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQADQAEAB4ABAAEAB4ABAAEABMABAArACsAKwArACsAKwArACsAVgBWAFYAVgBWAFYAVgBWAFYAVgBWAFYAVgBWAFYAVgBWAFYAVgBWAFYAVgBWAFYAVgBWAFYAKwArACsAKwBWAFYAVgBWAB4AHgArACsAKwArACsAKwArACsAKwArACsAHgAeAB4AHgAeAB4AHgAeAB4AGgAaABoAGAAYAB4AHgAEAAQABAAEAAQABAAEAAQABAAEAAQAEwAEACsAEwATAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABABLAEsASwBLAEsASwBLAEsASwBLABoAGQAZAB4AUABQAAQAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQABMAUAAEAAQABAAEAAQABAAEAB4AHgAEAAQABAAEAAQABABQAFAABAAEAB4ABAAEAAQABABQAFAASwBLAEsASwBLAEsASwBLAEsASwBQAFAAUAAeAB4AUAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwAeAFAABABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAAEAAQABAAEAFAAKwArACsAKwArACsAKwArACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAAEAAQAUABQAB4AHgAYABMAUAArACsABAAbABsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAFAABAAEAAQABAAEAFAABAAEAAQAUAAEAAQABAAEAAQAKwArAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAArACsAHgArAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsAKwArACsAKwArACsAKwArAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAB4ABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAAEAFAABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQAUAAEAAQABAAEAAQABAAEAFAAUABQAFAAUABQAFAAUABQAFAABAAEAA0ADQBLAEsASwBLAEsASwBLAEsASwBLAB4AUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAArAFAAUABQAFAAUABQAFAAUAArACsAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQACsAUAArACsAKwBQAFAAUABQACsAKwAEAFAABAAEAAQABAAEAAQABAArACsABAAEACsAKwAEAAQABABQACsAKwArACsAKwArACsAKwAEACsAKwArACsAUABQACsAUABQAFAABAAEACsAKwBLAEsASwBLAEsASwBLAEsASwBLAFAAUAAaABoAUABQAFAAUABQAEwAHgAbAFAAHgAEACsAKwAEAAQABAArAFAAUABQAFAAUABQACsAKwArACsAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQACsAUABQACsAUABQACsAUABQACsAKwAEACsABAAEAAQABAAEACsAKwArACsABAAEACsAKwAEAAQABAArACsAKwAEACsAKwArACsAKwArACsAUABQAFAAUAArAFAAKwArACsAKwArACsAKwBLAEsASwBLAEsASwBLAEsASwBLAAQABABQAFAAUAAEAB4AKwArACsAKwArACsAKwArACsAKwAEAAQABAArAFAAUABQAFAAUABQAFAAUABQACsAUABQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQACsAUABQACsAUABQAFAAUABQACsAKwAEAFAABAAEAAQABAAEAAQABAAEACsABAAEAAQAKwAEAAQABAArACsAUAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwBQAFAABAAEACsAKwBLAEsASwBLAEsASwBLAEsASwBLAB4AGwArACsAKwArACsAKwArAFAABAAEAAQABAAEAAQAKwAEAAQABAArAFAAUABQAFAAUABQAFAAUAArACsAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAAEAAQABAArACsABAAEACsAKwAEAAQABAArACsAKwArACsAKwArAAQABAAEACsAKwArACsAUABQACsAUABQAFAABAAEACsAKwBLAEsASwBLAEsASwBLAEsASwBLAB4AUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArAAQAUAArAFAAUABQAFAAUABQACsAKwArAFAAUABQACsAUABQAFAAUAArACsAKwBQAFAAKwBQACsAUABQACsAKwArAFAAUAArACsAKwBQAFAAUAArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArAAQABAAEAAQABAArACsAKwAEAAQABAArAAQABAAEAAQAKwArAFAAKwArACsAKwArACsABAArACsAKwArACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAUABQAFAAHgAeAB4AHgAeAB4AGwAeACsAKwArACsAKwAEAAQABAAEAAQAUABQAFAAUABQAFAAUABQACsAUABQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsAUAAEAAQABAAEAAQABAAEACsABAAEAAQAKwAEAAQABAAEACsAKwArACsAKwArACsABAAEACsAUABQAFAAKwArACsAKwArAFAAUAAEAAQAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAKwAOAFAAUABQAFAAUABQAFAAHgBQAAQABAAEAA4AUABQAFAAUABQAFAAUABQACsAUABQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAKwArAAQAUAAEAAQABAAEAAQABAAEACsABAAEAAQAKwAEAAQABAAEACsAKwArACsAKwArACsABAAEACsAKwArACsAKwArACsAUAArAFAAUAAEAAQAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwBQAFAAKwArACsAKwArACsAKwArACsAKwArACsAKwAEAAQABAAEAFAAUABQAFAAUABQAFAAUABQACsAUABQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAFAABAAEAAQABAAEAAQABAArAAQABAAEACsABAAEAAQABABQAB4AKwArACsAKwBQAFAAUAAEAFAAUABQAFAAUABQAFAAUABQAFAABAAEACsAKwBLAEsASwBLAEsASwBLAEsASwBLAFAAUABQAFAAUABQAFAAUABQABoAUABQAFAAUABQAFAAKwAEAAQABAArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAUABQAFAAUABQACsAUAArACsAUABQAFAAUABQAFAAUAArACsAKwAEACsAKwArACsABAAEAAQABAAEAAQAKwAEACsABAAEAAQABAAEAAQABAAEACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArAAQABAAeACsAKwArACsAKwArACsAKwArACsAKwArAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXAAqAFwAXAAqACoAKgAqACoAKgAqACsAKwArACsAGwBcAFwAXABcAFwAXABcACoAKgAqACoAKgAqACoAKgAeAEsASwBLAEsASwBLAEsASwBLAEsADQANACsAKwArACsAKwBcAFwAKwBcACsAXABcAFwAXABcACsAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcACsAXAArAFwAXABcAFwAXABcAFwAXABcAFwAKgBcAFwAKgAqACoAKgAqACoAKgAqACoAXAArACsAXABcAFwAXABcACsAXAArACoAKgAqACoAKgAqACsAKwBLAEsASwBLAEsASwBLAEsASwBLACsAKwBcAFwAXABcAFAADgAOAA4ADgAeAA4ADgAJAA4ADgANAAkAEwATABMAEwATAAkAHgATAB4AHgAeAAQABAAeAB4AHgAeAB4AHgBLAEsASwBLAEsASwBLAEsASwBLAFAAUABQAFAAUABQAFAAUABQAFAADQAEAB4ABAAeAAQAFgARABYAEQAEAAQAUABQAFAAUABQAFAAUABQACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsAKwAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQADQAEAAQABAAEAAQADQAEAAQAUABQAFAAUABQAAQABAAEAAQABAAEAAQABAAEAAQABAArAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAArAA0ADQAeAB4AHgAeAB4AHgAEAB4AHgAeAB4AHgAeACsAHgAeAA4ADgANAA4AHgAeAB4AHgAeAAkACQArACsAKwArACsAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgBcAEsASwBLAEsASwBLAEsASwBLAEsADQANAB4AHgAeAB4AXABcAFwAXABcAFwAKgAqACoAKgBcAFwAXABcACoAKgAqAFwAKgAqACoAXABcACoAKgAqACoAKgAqACoAXABcAFwAKgAqACoAKgBcAFwAXABcAFwAXABcAFwAXABcAFwAXABcACoAKgAqACoAKgAqACoAKgAqACoAKgAqAFwAKgBLAEsASwBLAEsASwBLAEsASwBLACoAKgAqACoAKgAqAFAAUABQAFAAUABQACsAUAArACsAKwArACsAUAArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAHgBQAFAAUABQAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFAAUABQAFAAUABQAFAAUABQACsAUABQAFAAUAArACsAUABQAFAAUABQAFAAUAArAFAAKwBQAFAAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAKwArAFAAUABQAFAAUABQAFAAKwBQACsAUABQAFAAUAArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsABAAEAAQAHgANAB4AHgAeAB4AHgAeAB4AUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAHgAeAB4AHgAeAB4AHgAeAB4AHgArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwBQAFAAUABQAFAAUAArACsADQBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAHgAeAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAANAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAWABEAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAA0ADQANAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAAQABAAEACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAANAA0AKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEACsAKwArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUAArAAQABAArACsAKwArACsAKwArACsAKwArACsAKwBcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqAA0ADQAVAFwADQAeAA0AGwBcACoAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwAeAB4AEwATAA0ADQAOAB4AEwATAB4ABAAEAAQACQArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArAFAAUABQAFAAUAAEAAQAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQAUAArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwAEAAQABAAEAAQABAAEAAQABAAEAAQABAArACsAKwArAAQABAAEAAQABAAEAAQABAAEAAQABAAEACsAKwArACsAHgArACsAKwATABMASwBLAEsASwBLAEsASwBLAEsASwBcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXAArACsAXABcAFwAXABcACsAKwArACsAKwArACsAKwArACsAKwBcAFwAXABcAFwAXABcAFwAXABcAFwAXAArACsAKwArAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAXAArACsAKwAqACoAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAAEAAQABAArACsAHgAeAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcACoAKgAqACoAKgAqACoAKgAqACoAKwAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKwArAAQASwBLAEsASwBLAEsASwBLAEsASwArACsAKwArACsAKwBLAEsASwBLAEsASwBLAEsASwBLACsAKwArACsAKwArACoAKgAqACoAKgAqACoAXAAqACoAKgAqACoAKgArACsABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsABAAEAAQABAAEAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAAEAAQABABQAFAAUABQAFAAUABQACsAKwArACsASwBLAEsASwBLAEsASwBLAEsASwANAA0AHgANAA0ADQANAB4AHgAeAB4AHgAeAB4AHgAeAB4ABAAEAAQABAAEAAQABAAEAAQAHgAeAB4AHgAeAB4AHgAeAB4AKwArACsABAAEAAQAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAAEAAQABAAEAAQABABQAFAASwBLAEsASwBLAEsASwBLAEsASwBQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEACsAKwArACsAKwArACsAKwAeAB4AHgAeAFAAUABQAFAABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEACsAKwArAA0ADQANAA0ADQBLAEsASwBLAEsASwBLAEsASwBLACsAKwArAFAAUABQAEsASwBLAEsASwBLAEsASwBLAEsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAA0ADQBQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwBQAFAAUAAeAB4AHgAeAB4AHgAeAB4AKwArACsAKwArACsAKwArAAQABAAEAB4ABAAEAAQABAAEAAQABAAEAAQABAAEAAQABABQAFAAUABQAAQAUABQAFAAUABQAFAABABQAFAABAAEAAQAUAArACsAKwArACsABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEACsABAAEAAQABAAEAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwArAFAAUABQAFAAUABQACsAKwBQAFAAUABQAFAAUABQAFAAKwBQACsAUAArAFAAKwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeACsAKwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArAB4AHgAeAB4AHgAeAB4AHgBQAB4AHgAeAFAAUABQACsAHgAeAB4AHgAeAB4AHgAeAB4AHgBQAFAAUABQACsAKwAeAB4AHgAeAB4AHgArAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwArAFAAUABQACsAHgAeAB4AHgAeAB4AHgAOAB4AKwANAA0ADQANAA0ADQANAAkADQANAA0ACAAEAAsABAAEAA0ACQANAA0ADAAdAB0AHgAXABcAFgAXABcAFwAWABcAHQAdAB4AHgAUABQAFAANAAEAAQAEAAQABAAEAAQACQAaABoAGgAaABoAGgAaABoAHgAXABcAHQAVABUAHgAeAB4AHgAeAB4AGAAWABEAFQAVABUAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4ADQAeAA0ADQANAA0AHgANAA0ADQAHAB4AHgAeAB4AKwAEAAQABAAEAAQABAAEAAQABAAEAFAAUAArACsATwBQAFAAUABQAFAAHgAeAB4AFgARAE8AUABPAE8ATwBPAFAAUABQAFAAUAAeAB4AHgAWABEAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArABsAGwAbABsAGwAbABsAGgAbABsAGwAbABsAGwAbABsAGwAbABsAGwAbABsAGgAbABsAGwAbABoAGwAbABoAGwAbABsAGwAbABsAGwAbABsAGwAbABsAGwAbABsAGwAbAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQAHgAeAFAAGgAeAB0AHgBQAB4AGgAeAB4AHgAeAB4AHgAeAB4AHgBPAB4AUAAbAB4AHgBQAFAAUABQAFAAHgAeAB4AHQAdAB4AUAAeAFAAHgBQAB4AUABPAFAAUAAeAB4AHgAeAB4AHgAeAFAAUABQAFAAUAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAFAAHgBQAFAAUABQAE8ATwBQAFAAUABQAFAATwBQAFAATwBQAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAFAAUABQAFAATwBPAE8ATwBPAE8ATwBPAE8ATwBQAFAAUABQAFAAUABQAFAAUAAeAB4AUABQAFAAUABPAB4AHgArACsAKwArAB0AHQAdAB0AHQAdAB0AHQAdAB0AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB0AHgAdAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAdAB4AHQAdAB4AHgAeAB0AHQAeAB4AHQAeAB4AHgAdAB4AHQAbABsAHgAdAB4AHgAeAB4AHQAeAB4AHQAdAB0AHQAeAB4AHQAeAB0AHgAdAB0AHQAdAB0AHQAeAB0AHgAeAB4AHgAeAB0AHQAdAB0AHgAeAB4AHgAdAB0AHgAeAB4AHgAeAB4AHgAeAB4AHgAdAB4AHgAeAB0AHgAeAB4AHgAeAB0AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAdAB0AHgAeAB0AHQAdAB0AHgAeAB0AHQAeAB4AHQAdAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB0AHQAeAB4AHQAdAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHQAeAB4AHgAdAB4AHgAeAB4AHgAeAB4AHQAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB0AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AFAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeABYAEQAWABEAHgAeAB4AHgAeAB4AHQAeAB4AHgAeAB4AHgAeACUAJQAeAB4AHgAeAB4AHgAeAB4AHgAWABEAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AJQAlACUAJQAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAFAAHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHgAeAB4AHgAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAeAB4AHQAdAB0AHQAeAB4AHgAeAB4AHgAeAB4AHgAeAB0AHQAeAB0AHQAdAB0AHQAdAB0AHgAeAB4AHgAeAB4AHgAeAB0AHQAeAB4AHQAdAB4AHgAeAB4AHQAdAB4AHgAeAB4AHQAdAB0AHgAeAB0AHgAeAB0AHQAdAB0AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAdAB0AHQAdAB4AHgAeAB4AHgAeAB4AHgAeAB0AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAlACUAJQAlAB4AHQAdAB4AHgAdAB4AHgAeAB4AHQAdAB4AHgAeAB4AJQAlAB0AHQAlAB4AJQAlACUAIAAlACUAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAlACUAJQAeAB4AHgAeAB0AHgAdAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAdAB0AHgAdAB0AHQAeAB0AJQAdAB0AHgAdAB0AHgAdAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeACUAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHQAdAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAlACUAJQAlACUAJQAlACUAJQAlACUAJQAdAB0AHQAdACUAHgAlACUAJQAdACUAJQAdAB0AHQAlACUAHQAdACUAHQAdACUAJQAlAB4AHQAeAB4AHgAeAB0AHQAlAB0AHQAdAB0AHQAdACUAJQAlACUAJQAdACUAJQAgACUAHQAdACUAJQAlACUAJQAlACUAJQAeAB4AHgAlACUAIAAgACAAIAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB0AHgAeAB4AFwAXABcAFwAXABcAHgATABMAJQAeAB4AHgAWABEAFgARABYAEQAWABEAFgARABYAEQAWABEATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeABYAEQAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAWABEAFgARABYAEQAWABEAFgARAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AFgARABYAEQAWABEAFgARABYAEQAWABEAFgARABYAEQAWABEAFgARABYAEQAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAWABEAFgARAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AFgARAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAdAB0AHQAdAB0AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArACsAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AUABQAFAAUAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAEAAQABAAeAB4AKwArACsAKwArABMADQANAA0AUAATAA0AUABQAFAAUABQAFAAUABQACsAKwArACsAKwArACsAUAANACsAKwArACsAKwArACsAKwArACsAKwArACsAKwAEAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQACsAUABQAFAAUABQAFAAUAArAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQACsAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXAA0ADQANAA0ADQANAA0ADQAeAA0AFgANAB4AHgAXABcAHgAeABcAFwAWABEAFgARABYAEQAWABEADQANAA0ADQATAFAADQANAB4ADQANAB4AHgAeAB4AHgAMAAwADQANAA0AHgANAA0AFgANAA0ADQANAA0ADQANAA0AHgANAB4ADQANAB4AHgAeACsAKwArACsAKwArACsAKwArACsAKwArACsAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACsAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAKwArACsAKwArACsAKwArACsAKwArACsAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwAlACUAJQAlACUAJQAlACUAJQAlACUAJQArACsAKwArAA0AEQARACUAJQBHAFcAVwAWABEAFgARABYAEQAWABEAFgARACUAJQAWABEAFgARABYAEQAWABEAFQAWABEAEQAlAFcAVwBXAFcAVwBXAFcAVwBXAAQABAAEAAQABAAEACUAVwBXAFcAVwA2ACUAJQBXAFcAVwBHAEcAJQAlACUAKwBRAFcAUQBXAFEAVwBRAFcAUQBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFEAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBRAFcAUQBXAFEAVwBXAFcAVwBXAFcAUQBXAFcAVwBXAFcAVwBRAFEAKwArAAQABAAVABUARwBHAFcAFQBRAFcAUQBXAFEAVwBRAFcAUQBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFEAVwBRAFcAUQBXAFcAVwBXAFcAVwBRAFcAVwBXAFcAVwBXAFEAUQBXAFcAVwBXABUAUQBHAEcAVwArACsAKwArACsAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAKwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAKwAlACUAVwBXAFcAVwAlACUAJQAlACUAJQAlACUAJQAlACsAKwArACsAKwArACsAKwArACsAKwArAFEAUQBRAFEAUQBRAFEAUQBRAFEAUQBRAFEAUQBRAFEAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQArAFcAVwBXAFcAVwBXAFcAVwBXAFcAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQBPAE8ATwBPAE8ATwBPAE8AJQBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXACUAJQAlAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAEcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAKwArACsAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAADQATAA0AUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABLAEsASwBLAEsASwBLAEsASwBLAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAFAABAAEAAQABAAeAAQABAAEAAQABAAEAAQABAAEAAQAHgBQAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AUABQAAQABABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAAeAA0ADQANAA0ADQArACsAKwArACsAKwArACsAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAFAAUABQAFAAUABQAFAAUABQAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AUAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgBQAB4AHgAeAB4AHgAeAFAAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArACsAHgAeAB4AHgAeAB4AHgAeAB4AKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwAeAB4AUABQAFAAUABQAFAAUABQAFAAUABQAAQAUABQAFAABABQAFAAUABQAAQAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAAEAAQABAAeAB4AHgAeAAQAKwArACsAUABQAFAAUABQAFAAHgAeABoAHgArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAADgAOABMAEwArACsAKwArACsAKwArACsABAAEAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAAEAAQABAAEACsAKwArACsAKwArACsAKwANAA0ASwBLAEsASwBLAEsASwBLAEsASwArACsAKwArACsAKwAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABABQAFAAUABQAFAAUAAeAB4AHgBQAA4AUABQAAQAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAAEAA0ADQBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQAKwArACsAKwArACsAKwArACsAKwArAB4AWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYAFgAWABYACsAKwArAAQAHgAeAB4AHgAeAB4ADQANAA0AHgAeAB4AHgArAFAASwBLAEsASwBLAEsASwBLAEsASwArACsAKwArAB4AHgBcAFwAXABcAFwAKgBcAFwAXABcAFwAXABcAFwAXABcAEsASwBLAEsASwBLAEsASwBLAEsAXABcAFwAXABcACsAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEACsAKwArACsAKwArACsAKwArAFAAUABQAAQAUABQAFAAUABQAFAAUABQAAQABAArACsASwBLAEsASwBLAEsASwBLAEsASwArACsAHgANAA0ADQBcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAKgAqACoAXAAqACoAKgBcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXAAqAFwAKgAqACoAXABcACoAKgBcAFwAXABcAFwAKgAqAFwAKgBcACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAFwAXABcACoAKgBQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAA0ADQBQAFAAUAAEAAQAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUAArACsAUABQAFAAUABQAFAAKwArAFAAUABQAFAAUABQACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAHgAeACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAAQADQAEAAQAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAVABVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBUAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVAFUAVQBVACsAKwArACsAKwArACsAKwArACsAKwArAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAWQBZAFkAKwArACsAKwBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAWgBaAFoAKwArACsAKwAGAAYABgAGAAYABgAGAAYABgAGAAYABgAGAAYABgAGAAYABgAGAAYABgAGAAYABgAGAAYABgAGAAYABgAGAAYAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXACUAJQBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAJQAlACUAJQAlACUAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAKwArACsAKwArAFYABABWAFYAVgBWAFYAVgBWAFYAVgBWAB4AVgBWAFYAVgBWAFYAVgBWAFYAVgBWAFYAVgArAFYAVgBWAFYAVgArAFYAKwBWAFYAKwBWAFYAKwBWAFYAVgBWAFYAVgBWAFYAVgBWAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAEQAWAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUAAaAB4AKwArAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQAGAARABEAGAAYABMAEwAWABEAFAArACsAKwArACsAKwAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEACUAJQAlACUAJQAWABEAFgARABYAEQAWABEAFgARABYAEQAlACUAFgARACUAJQAlACUAJQAlACUAEQAlABEAKwAVABUAEwATACUAFgARABYAEQAWABEAJQAlACUAJQAlACUAJQAlACsAJQAbABoAJQArACsAKwArAFAAUABQAFAAUAArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArAAcAKwATACUAJQAbABoAJQAlABYAEQAlACUAEQAlABEAJQBXAFcAVwBXAFcAVwBXAFcAVwBXABUAFQAlACUAJQATACUAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXABYAJQARACUAJQAlAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwAWACUAEQAlABYAEQARABYAEQARABUAVwBRAFEAUQBRAFEAUQBRAFEAUQBRAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAEcARwArACsAVwBXAFcAVwBXAFcAKwArAFcAVwBXAFcAVwBXACsAKwBXAFcAVwBXAFcAVwArACsAVwBXAFcAKwArACsAGgAbACUAJQAlABsAGwArAB4AHgAeAB4AHgAeAB4AKwArACsAKwArACsAKwArACsAKwAEAAQABAAQAB0AKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsADQANAA0AKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArAB4AHgAeAB4AHgAeAB4AHgAeAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgBQAFAAHgAeAB4AKwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAAQAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwAEAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArAA0AUABQAFAAUAArACsAKwArAFAAUABQAFAAUABQAFAAUAANAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwArACsAKwArACsAKwAeACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAKwArAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUAArACsAKwBQACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwANAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAeAB4AUABQAFAAUABQAFAAUAArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUAArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArAA0AUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwAeAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAUABQAFAAUABQAAQABAAEACsABAAEACsAKwArACsAKwAEAAQABAAEAFAAUABQAFAAKwBQAFAAUAArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArAAQABAAEACsAKwArACsABABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArAA0ADQANAA0ADQANAA0ADQAeACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAeAFAAUABQAFAAUABQAFAAUAAeAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAArACsAKwArAFAAUABQAFAAUAANAA0ADQANAA0ADQAUACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsADQANAA0ADQANAA0ADQBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArAB4AHgAeAB4AKwArACsAKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArAFAAUABQAFAAUABQAAQABAAEAAQAKwArACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUAArAAQABAANACsAKwBQAFAAKwArACsAKwArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAAQABAAEAAQABAAEAAQABAAEAAQABABQAFAAUABQAB4AHgAeAB4AHgArACsAKwArACsAKwAEAAQABAAEAAQABAAEAA0ADQAeAB4AHgAeAB4AKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsABABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAAQABAAEAAQABAAEAAQABAAEAAQABAAeAB4AHgANAA0ADQANACsAKwArACsAKwArACsAKwArACsAKwAeACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsAKwArACsAKwBLAEsASwBLAEsASwBLAEsASwBLACsAKwArACsAKwArAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEACsASwBLAEsASwBLAEsASwBLAEsASwANAA0ADQANAFAABAAEAFAAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAeAA4AUAArACsAKwArACsAKwArACsAKwAEAFAAUABQAFAADQANAB4ADQAEAAQABAAEAB4ABAAEAEsASwBLAEsASwBLAEsASwBLAEsAUAAOAFAADQANAA0AKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAAQABAAEAAQABAANAA0AHgANAA0AHgAEACsAUABQAFAAUABQAFAAUAArAFAAKwBQAFAAUABQACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAA0AKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAAQABAAEAAQAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsABAAEAAQABAArAFAAUABQAFAAUABQAFAAUAArACsAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQACsAUABQACsAUABQAFAAUABQACsABAAEAFAABAAEAAQABAAEAAQABAArACsABAAEACsAKwAEAAQABAArACsAUAArACsAKwArACsAKwAEACsAKwArACsAKwBQAFAAUABQAFAABAAEACsAKwAEAAQABAAEAAQABAAEACsAKwArAAQABAAEAAQABAArACsAKwArACsAKwArACsAKwArACsABAAEAAQABAAEAAQABABQAFAAUABQAA0ADQANAA0AHgBLAEsASwBLAEsASwBLAEsASwBLAA0ADQArAB4ABABQAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwAEAAQABAAEAFAAUAAeAFAAKwArACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAArACsABAAEAAQABAAEAAQABAAEAAQADgANAA0AEwATAB4AHgAeAA0ADQANAA0ADQANAA0ADQANAA0ADQANAA0ADQANAFAAUABQAFAABAAEACsAKwAEAA0ADQAeAFAAKwArACsAKwArACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAFAAKwArACsAKwArACsAKwBLAEsASwBLAEsASwBLAEsASwBLACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAXABcAFwAKwArACoAKgAqACoAKgAqACoAKgAqACoAKgAqACoAKgAqACsAKwArACsASwBLAEsASwBLAEsASwBLAEsASwBcAFwADQANAA0AKgBQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAeACsAKwArACsASwBLAEsASwBLAEsASwBLAEsASwBQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAKwArAFAAKwArAFAAUABQAFAAUABQAFAAUAArAFAAUAArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQAKwAEAAQAKwArAAQABAAEAAQAUAAEAFAABAAEAA0ADQANACsAKwArACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAArACsABAAEAAQABAAEAAQABABQAA4AUAAEACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAFAABAAEAAQABAAEAAQABAAEAAQABABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAFAABAAEAAQABAAOAB4ADQANAA0ADQAOAB4ABAArACsAKwArACsAKwArACsAUAAEAAQABAAEAAQABAAEAAQABAAEAAQAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAA0ADQANAFAADgAOAA4ADQANACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAEAAQABAAEACsABAAEAAQABAAEAAQABAAEAFAADQANAA0ADQANACsAKwArACsAKwArACsAKwArACsASwBLAEsASwBLAEsASwBLAEsASwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwAOABMAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAArAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQACsAUABQACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAArACsAKwAEACsABAAEACsABAAEAAQABAAEAAQABABQAAQAKwArACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAUABQAFAAUABQAFAAKwBQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQAKwAEAAQAKwAEAAQABAAEAAQAUAArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAABAAEAAQABAAeAB4AKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwBQACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAB4AHgAeAB4AHgAeAB4AHgAaABoAGgAaAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArACsAKwArACsAKwArACsAKwArACsAKwArAA0AUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsADQANAA0ADQANACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAASABIAEgAQwBDAEMAUABQAFAAUABDAFAAUABQAEgAQwBIAEMAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAASABDAEMAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwAJAAkACQAJAAkACQAJABYAEQArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABIAEMAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwANAA0AKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArAAQABAAEAAQABAANACsAKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEAA0ADQANAB4AHgAeAB4AHgAeAFAAUABQAFAADQAeACsAKwArACsAKwArACsAKwArACsASwBLAEsASwBLAEsASwBLAEsASwArAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAANAA0AHgAeACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsAKwAEAFAABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQAKwArACsAKwArACsAKwAEAAQABAAEAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAARwBHABUARwAJACsAKwArACsAKwArACsAKwArACsAKwAEAAQAKwArACsAKwArACsAKwArACsAKwArACsAKwArAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXACsAKwArACsAKwArACsAKwBXAFcAVwBXAFcAVwBXAFcAVwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAUQBRAFEAKwArACsAKwArACsAKwArACsAKwArACsAKwBRAFEAUQBRACsAKwArACsAKwArACsAKwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUAArACsAHgAEAAQADQAEAAQABAAEACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArACsAKwArACsAKwArACsAKwArAB4AHgAeAB4AHgAeAB4AKwArAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAAQABAAEAAQABAAeAB4AHgAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAB4AHgAEAAQABAAEAAQABAAEAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4ABAAEAAQABAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4ABAAEAAQAHgArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwArACsAKwArACsAKwArACsAKwArAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArACsAKwArACsAKwArACsAKwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwBQAFAAKwArAFAAKwArAFAAUAArACsAUABQAFAAUAArAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeACsAUAArAFAAUABQAFAAUABQAFAAKwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwBQAFAAUABQACsAKwBQAFAAUABQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQACsAHgAeAFAAUABQAFAAUAArAFAAKwArACsAUABQAFAAUABQAFAAUAArAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAHgBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgBQAFAAUABQAFAAUABQAFAAUABQAFAAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAB4AHgAeAB4AHgAeAB4AHgAeACsAKwBLAEsASwBLAEsASwBLAEsASwBLAEsASwBLAEsASwBLAEsASwBLAEsASwBLAEsASwBLAEsASwBLAEsASwBLAEsASwBLAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAeAB4AHgAeAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAeAB4AHgAeAB4AHgAeAB4ABAAeAB4AHgAeAB4AHgAeAB4AHgAeAAQAHgAeAA0ADQANAA0AHgArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwAEAAQABAAEAAQAKwAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAAQABAAEAAQABAAEAAQAKwAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQAKwArAAQABAAEAAQABAAEAAQAKwAEAAQAKwAEAAQABAAEAAQAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwAEAAQABAAEAAQABAAEAFAAUABQAFAAUABQAFAAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwBQAB4AKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArABsAUABQAFAAUABQACsAKwBQAFAAUABQAFAAUABQAFAAUAAEAAQABAAEAAQABAAEACsAKwArACsAKwArACsAKwArAB4AHgAeAB4ABAAEAAQABAAEAAQABABQACsAKwArACsASwBLAEsASwBLAEsASwBLAEsASwArACsAKwArABYAFgArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAGgBQAFAAUAAaAFAAUABQAFAAKwArACsAKwArACsAKwArACsAKwArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAAeAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQACsAKwBQAFAAUABQACsAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwBQAFAAKwBQACsAKwBQACsAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAKwBQACsAUAArACsAKwArACsAKwBQACsAKwArACsAUAArAFAAKwBQACsAUABQAFAAKwBQAFAAKwBQACsAKwBQACsAUAArAFAAKwBQACsAUAArAFAAUAArAFAAKwArAFAAUABQAFAAKwBQAFAAUABQAFAAUABQACsAUABQAFAAUAArAFAAUABQAFAAKwBQACsAUABQAFAAUABQAFAAUABQAFAAUAArAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUAArACsAKwArACsAUABQAFAAKwBQAFAAUABQAFAAKwBQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAUABQAFAAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwAeAB4AKwArACsAKwArACsAKwArACsAKwArACsAKwArAE8ATwBPAE8ATwBPAE8ATwBPAE8ATwBPAE8AJQAlACUAHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHgAeAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB4AHgAeACUAJQAlAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAdAB0AHQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQApACkAKQApACkAKQApACkAKQApACkAKQApACkAKQApACkAKQApACkAKQApACkAKQApACkAJQAlACUAJQAlACAAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAeAB4AJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlAB4AHgAlACUAJQAlACUAHgAlACUAJQAlACUAIAAgACAAJQAlACAAJQAlACAAIAAgACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACEAIQAhACEAIQAlACUAIAAgACUAJQAgACAAIAAgACAAIAAgACAAIAAgACAAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAJQAlACUAIAAlACUAJQAlACAAIAAgACUAIAAgACAAJQAlACUAJQAlACUAJQAgACUAIAAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAHgAlAB4AJQAeACUAJQAlACUAJQAgACUAJQAlACUAHgAlAB4AHgAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlAB4AHgAeAB4AHgAeAB4AJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAeAB4AHgAeAB4AHgAeAB4AHgAeACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACAAIAAlACUAJQAlACAAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACAAJQAlACUAJQAgACAAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAHgAeAB4AHgAeAB4AHgAeACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAeAB4AHgAeAB4AHgAlACUAJQAlACUAJQAlACAAIAAgACUAJQAlACAAIAAgACAAIAAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeABcAFwAXABUAFQAVAB4AHgAeAB4AJQAlACUAIAAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACAAIAAgACUAJQAlACUAJQAlACUAJQAlACAAJQAlACUAJQAlACUAJQAlACUAJQAlACAAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AJQAlACUAJQAlACUAJQAlACUAJQAlACUAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AJQAlACUAJQAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeACUAJQAlACUAJQAlACUAJQAeAB4AHgAeAB4AHgAeAB4AHgAeACUAJQAlACUAJQAlAB4AHgAeAB4AHgAeAB4AHgAlACUAJQAlACUAJQAlACUAHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAgACUAJQAgACUAJQAlACUAJQAlACUAJQAgACAAIAAgACAAIAAgACAAJQAlACUAJQAlACUAIAAlACUAJQAlACUAJQAlACUAJQAgACAAIAAgACAAIAAgACAAIAAgACUAJQAgACAAIAAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAgACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACAAIAAlACAAIAAlACAAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAgACAAIAAlACAAIAAgACAAIAAgACAAIAAgACAAIAAgACAAJQAlAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AKwAeAB4AHgAeAB4AHgAeAB4AHgAeAB4AHgArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAEsASwBLAEsASwBLAEsASwBLAEsAKwArACsAKwArACsAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAKwArAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXACUAJQBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwAlACUAJQAlACUAJQAlACUAJQAlACUAVwBXACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQBXAFcAVwBXAFcAVwBXAFcAVwBXAFcAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAJQAlACUAKwAEACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQABAAEAAQAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArACsAKwArAA==';
var LETTER_NUMBER_MODIFIER = 50;
// Non-tailorable Line Breaking Classes
var BK = 1; //  Cause a line break (after)
var CR = 2; //  Cause a line break (after), except between CR and LF
var LF = 3; //  Cause a line break (after)
var CM = 4; //  Prohibit a line break between the character and the preceding character
var NL = 5; //  Cause a line break (after)
var WJ = 7; //  Prohibit line breaks before and after
var ZW = 8; //  Provide a break opportunity
var GL = 9; //  Prohibit line breaks before and after
var SP = 10; // Enable indirect line breaks
var ZWJ = 11; // Prohibit line breaks within joiner sequences
// Break Opportunities
var B2 = 12; //  Provide a line break opportunity before and after the character
var BA = 13; //  Generally provide a line break opportunity after the character
var BB = 14; //  Generally provide a line break opportunity before the character
var HY = 15; //  Provide a line break opportunity after the character, except in numeric context
var CB = 16; //   Provide a line break opportunity contingent on additional information
// Characters Prohibiting Certain Breaks
var CL = 17; //  Prohibit line breaks before
var CP = 18; //  Prohibit line breaks before
var EX = 19; //  Prohibit line breaks before
var IN = 20; //  Allow only indirect line breaks between pairs
var NS = 21; //  Allow only indirect line breaks before
var OP = 22; //  Prohibit line breaks after
var QU = 23; //  Act like they are both opening and closing
// Numeric Context
var IS = 24; //  Prevent breaks after any and before numeric
var NU = 25; //  Form numeric expressions for line breaking purposes
var PO = 26; //  Do not break following a numeric expression
var PR = 27; //  Do not break in front of a numeric expression
var SY = 28; //  Prevent a break before; and allow a break after
// Other Characters
var AI = 29; //  Act like AL when the resolvedEAW is N; otherwise; act as ID
var AL = 30; //  Are alphabetic characters or symbols that are used with alphabetic characters
var CJ = 31; //  Treat as NS or ID for strict or normal breaking.
var EB = 32; //  Do not break from following Emoji Modifier
var EM = 33; //  Do not break from preceding Emoji Base
var H2 = 34; //  Form Korean syllable blocks
var H3 = 35; //  Form Korean syllable blocks
var HL = 36; //  Do not break around a following hyphen; otherwise act as Alphabetic
var ID = 37; //  Break before or after; except in some numeric context
var JL = 38; //  Form Korean syllable blocks
var JV = 39; //  Form Korean syllable blocks
var JT = 40; //  Form Korean syllable blocks
var RI = 41; //  Keep pairs together. For pairs; break before and after other classes
var SA = 42; //  Provide a line break opportunity contingent on additional, language-specific context analysis
var XX = 43; //  Have as yet unknown line breaking behavior or unassigned code positions
var ea_OP = [0x2329, 0xff08];
var BREAK_MANDATORY = '!';
var BREAK_NOT_ALLOWED = '×';
var BREAK_ALLOWED = '÷';
var UnicodeTrie = createTrieFromBase64(base64);
var ALPHABETICS = [AL, HL];
var HARD_LINE_BREAKS = [BK, CR, LF, NL];
var SPACE = [SP, ZW];
var PREFIX_POSTFIX = [PR, PO];
var LINE_BREAKS = HARD_LINE_BREAKS.concat(SPACE);
var KOREAN_SYLLABLE_BLOCK = [JL, JV, JT, H2, H3];
var HYPHEN = [HY, BA];
var codePointsToCharacterClasses = function codePointsToCharacterClasses(codePoints, lineBreak) {
  if (lineBreak === void 0) {
    lineBreak = 'strict';
  }
  var types = [];
  var indices = [];
  var categories = [];
  codePoints.forEach(function (codePoint, index) {
    var classType = UnicodeTrie.get(codePoint);
    if (classType > LETTER_NUMBER_MODIFIER) {
      categories.push(true);
      classType -= LETTER_NUMBER_MODIFIER;
    } else {
      categories.push(false);
    }
    if (['normal', 'auto', 'loose'].indexOf(lineBreak) !== -1) {
      // U+2010, – U+2013, 〜 U+301C, ゠ U+30A0
      if ([0x2010, 0x2013, 0x301c, 0x30a0].indexOf(codePoint) !== -1) {
        indices.push(index);
        return types.push(CB);
      }
    }
    if (classType === CM || classType === ZWJ) {
      // LB10 Treat any remaining combining mark or ZWJ as AL.
      if (index === 0) {
        indices.push(index);
        return types.push(AL);
      }
      // LB9 Do not break a combining character sequence; treat it as if it has the line breaking class of
      // the base character in all of the following rules. Treat ZWJ as if it were CM.
      var prev = types[index - 1];
      if (LINE_BREAKS.indexOf(prev) === -1) {
        indices.push(indices[index - 1]);
        return types.push(prev);
      }
      indices.push(index);
      return types.push(AL);
    }
    indices.push(index);
    if (classType === CJ) {
      return types.push(lineBreak === 'strict' ? NS : ID);
    }
    if (classType === SA) {
      return types.push(AL);
    }
    if (classType === AI) {
      return types.push(AL);
    }
    // For supplementary characters, a useful default is to treat characters in the range 10000..1FFFD as AL
    // and characters in the ranges 20000..2FFFD and 30000..3FFFD as ID, until the implementation can be revised
    // to take into account the actual line breaking properties for these characters.
    if (classType === XX) {
      if (codePoint >= 0x20000 && codePoint <= 0x2fffd || codePoint >= 0x30000 && codePoint <= 0x3fffd) {
        return types.push(ID);
      } else {
        return types.push(AL);
      }
    }
    types.push(classType);
  });
  return [indices, types, categories];
};
var isAdjacentWithSpaceIgnored = function isAdjacentWithSpaceIgnored(a, b, currentIndex, classTypes) {
  var current = classTypes[currentIndex];
  if (Array.isArray(a) ? a.indexOf(current) !== -1 : a === current) {
    var i = currentIndex;
    while (i <= classTypes.length) {
      i++;
      var next = classTypes[i];
      if (next === b) {
        return true;
      }
      if (next !== SP) {
        break;
      }
    }
  }
  if (current === SP) {
    var i = currentIndex;
    while (i > 0) {
      i--;
      var prev = classTypes[i];
      if (Array.isArray(a) ? a.indexOf(prev) !== -1 : a === prev) {
        var n = currentIndex;
        while (n <= classTypes.length) {
          n++;
          var next = classTypes[n];
          if (next === b) {
            return true;
          }
          if (next !== SP) {
            break;
          }
        }
      }
      if (prev !== SP) {
        break;
      }
    }
  }
  return false;
};
var previousNonSpaceClassType = function previousNonSpaceClassType(currentIndex, classTypes) {
  var i = currentIndex;
  while (i >= 0) {
    var type = classTypes[i];
    if (type === SP) {
      i--;
    } else {
      return type;
    }
  }
  return 0;
};
var _lineBreakAtIndex = function _lineBreakAtIndex(codePoints, classTypes, indicies, index, forbiddenBreaks) {
  if (indicies[index] === 0) {
    return BREAK_NOT_ALLOWED;
  }
  var currentIndex = index - 1;
  if (Array.isArray(forbiddenBreaks) && forbiddenBreaks[currentIndex] === true) {
    return BREAK_NOT_ALLOWED;
  }
  var beforeIndex = currentIndex - 1;
  var afterIndex = currentIndex + 1;
  var current = classTypes[currentIndex];
  // LB4 Always break after hard line breaks.
  // LB5 Treat CR followed by LF, as well as CR, LF, and NL as hard line breaks.
  var before = beforeIndex >= 0 ? classTypes[beforeIndex] : 0;
  var next = classTypes[afterIndex];
  if (current === CR && next === LF) {
    return BREAK_NOT_ALLOWED;
  }
  if (HARD_LINE_BREAKS.indexOf(current) !== -1) {
    return BREAK_MANDATORY;
  }
  // LB6 Do not break before hard line breaks.
  if (HARD_LINE_BREAKS.indexOf(next) !== -1) {
    return BREAK_NOT_ALLOWED;
  }
  // LB7 Do not break before spaces or zero width space.
  if (SPACE.indexOf(next) !== -1) {
    return BREAK_NOT_ALLOWED;
  }
  // LB8 Break before any character following a zero-width space, even if one or more spaces intervene.
  if (previousNonSpaceClassType(currentIndex, classTypes) === ZW) {
    return BREAK_ALLOWED;
  }
  // LB8a Do not break after a zero width joiner.
  if (UnicodeTrie.get(codePoints[currentIndex]) === ZWJ) {
    return BREAK_NOT_ALLOWED;
  }
  // zwj emojis
  if ((current === EB || current === EM) && UnicodeTrie.get(codePoints[afterIndex]) === ZWJ) {
    return BREAK_NOT_ALLOWED;
  }
  // LB11 Do not break before or after Word joiner and related characters.
  if (current === WJ || next === WJ) {
    return BREAK_NOT_ALLOWED;
  }
  // LB12 Do not break after NBSP and related characters.
  if (current === GL) {
    return BREAK_NOT_ALLOWED;
  }
  // LB12a Do not break before NBSP and related characters, except after spaces and hyphens.
  if ([SP, BA, HY].indexOf(current) === -1 && next === GL) {
    return BREAK_NOT_ALLOWED;
  }
  // LB13 Do not break before ‘]’ or ‘!’ or ‘;’ or ‘/’, even after spaces.
  if ([CL, CP, EX, IS, SY].indexOf(next) !== -1) {
    return BREAK_NOT_ALLOWED;
  }
  // LB14 Do not break after ‘[’, even after spaces.
  if (previousNonSpaceClassType(currentIndex, classTypes) === OP) {
    return BREAK_NOT_ALLOWED;
  }
  // LB15 Do not break within ‘”[’, even with intervening spaces.
  if (isAdjacentWithSpaceIgnored(QU, OP, currentIndex, classTypes)) {
    return BREAK_NOT_ALLOWED;
  }
  // LB16 Do not break between closing punctuation and a nonstarter (lb=NS), even with intervening spaces.
  if (isAdjacentWithSpaceIgnored([CL, CP], NS, currentIndex, classTypes)) {
    return BREAK_NOT_ALLOWED;
  }
  // LB17 Do not break within ‘——’, even with intervening spaces.
  if (isAdjacentWithSpaceIgnored(B2, B2, currentIndex, classTypes)) {
    return BREAK_NOT_ALLOWED;
  }
  // LB18 Break after spaces.
  if (current === SP) {
    return BREAK_ALLOWED;
  }
  // LB19 Do not break before or after quotation marks, such as ‘ ” ’.
  if (current === QU || next === QU) {
    return BREAK_NOT_ALLOWED;
  }
  // LB20 Break before and after unresolved CB.
  if (next === CB || current === CB) {
    return BREAK_ALLOWED;
  }
  // LB21 Do not break before hyphen-minus, other hyphens, fixed-width spaces, small kana, and other non-starters, or after acute accents.
  if ([BA, HY, NS].indexOf(next) !== -1 || current === BB) {
    return BREAK_NOT_ALLOWED;
  }
  // LB21a Don't break after Hebrew + Hyphen.
  if (before === HL && HYPHEN.indexOf(current) !== -1) {
    return BREAK_NOT_ALLOWED;
  }
  // LB21b Don’t break between Solidus and Hebrew letters.
  if (current === SY && next === HL) {
    return BREAK_NOT_ALLOWED;
  }
  // LB22 Do not break before ellipsis.
  if (next === IN) {
    return BREAK_NOT_ALLOWED;
  }
  // LB23 Do not break between digits and letters.
  if (ALPHABETICS.indexOf(next) !== -1 && current === NU || ALPHABETICS.indexOf(current) !== -1 && next === NU) {
    return BREAK_NOT_ALLOWED;
  }
  // LB23a Do not break between numeric prefixes and ideographs, or between ideographs and numeric postfixes.
  if (current === PR && [ID, EB, EM].indexOf(next) !== -1 || [ID, EB, EM].indexOf(current) !== -1 && next === PO) {
    return BREAK_NOT_ALLOWED;
  }
  // LB24 Do not break between numeric prefix/postfix and letters, or between letters and prefix/postfix.
  if (ALPHABETICS.indexOf(current) !== -1 && PREFIX_POSTFIX.indexOf(next) !== -1 || PREFIX_POSTFIX.indexOf(current) !== -1 && ALPHABETICS.indexOf(next) !== -1) {
    return BREAK_NOT_ALLOWED;
  }
  // LB25 Do not break between the following pairs of classes relevant to numbers:
  if (
  // (PR | PO) × ( OP | HY )? NU
  [PR, PO].indexOf(current) !== -1 && (next === NU || [OP, HY].indexOf(next) !== -1 && classTypes[afterIndex + 1] === NU) ||
  // ( OP | HY ) × NU
  [OP, HY].indexOf(current) !== -1 && next === NU ||
  // NU ×	(NU | SY | IS)
  current === NU && [NU, SY, IS].indexOf(next) !== -1) {
    return BREAK_NOT_ALLOWED;
  }
  // NU (NU | SY | IS)* × (NU | SY | IS | CL | CP)
  if ([NU, SY, IS, CL, CP].indexOf(next) !== -1) {
    var prevIndex = currentIndex;
    while (prevIndex >= 0) {
      var type = classTypes[prevIndex];
      if (type === NU) {
        return BREAK_NOT_ALLOWED;
      } else if ([SY, IS].indexOf(type) !== -1) {
        prevIndex--;
      } else {
        break;
      }
    }
  }
  // NU (NU | SY | IS)* (CL | CP)? × (PO | PR))
  if ([PR, PO].indexOf(next) !== -1) {
    var prevIndex = [CL, CP].indexOf(current) !== -1 ? beforeIndex : currentIndex;
    while (prevIndex >= 0) {
      var type = classTypes[prevIndex];
      if (type === NU) {
        return BREAK_NOT_ALLOWED;
      } else if ([SY, IS].indexOf(type) !== -1) {
        prevIndex--;
      } else {
        break;
      }
    }
  }
  // LB26 Do not break a Korean syllable.
  if (JL === current && [JL, JV, H2, H3].indexOf(next) !== -1 || [JV, H2].indexOf(current) !== -1 && [JV, JT].indexOf(next) !== -1 || [JT, H3].indexOf(current) !== -1 && next === JT) {
    return BREAK_NOT_ALLOWED;
  }
  // LB27 Treat a Korean Syllable Block the same as ID.
  if (KOREAN_SYLLABLE_BLOCK.indexOf(current) !== -1 && [IN, PO].indexOf(next) !== -1 || KOREAN_SYLLABLE_BLOCK.indexOf(next) !== -1 && current === PR) {
    return BREAK_NOT_ALLOWED;
  }
  // LB28 Do not break between alphabetics (“at”).
  if (ALPHABETICS.indexOf(current) !== -1 && ALPHABETICS.indexOf(next) !== -1) {
    return BREAK_NOT_ALLOWED;
  }
  // LB29 Do not break between numeric punctuation and alphabetics (“e.g.”).
  if (current === IS && ALPHABETICS.indexOf(next) !== -1) {
    return BREAK_NOT_ALLOWED;
  }
  // LB30 Do not break between letters, numbers, or ordinary symbols and opening or closing parentheses.
  if (ALPHABETICS.concat(NU).indexOf(current) !== -1 && next === OP && ea_OP.indexOf(codePoints[afterIndex]) === -1 || ALPHABETICS.concat(NU).indexOf(next) !== -1 && current === CP) {
    return BREAK_NOT_ALLOWED;
  }
  // LB30a Break between two regional indicator symbols if and only if there are an even number of regional
  // indicators preceding the position of the break.
  if (current === RI && next === RI) {
    var i = indicies[currentIndex];
    var count = 1;
    while (i > 0) {
      i--;
      if (classTypes[i] === RI) {
        count++;
      } else {
        break;
      }
    }
    if (count % 2 !== 0) {
      return BREAK_NOT_ALLOWED;
    }
  }
  // LB30b Do not break between an emoji base and an emoji modifier.
  if (current === EB && next === EM) {
    return BREAK_NOT_ALLOWED;
  }
  return BREAK_ALLOWED;
};
var cssFormattedClasses = function cssFormattedClasses(codePoints, options) {
  if (!options) {
    options = {
      lineBreak: 'normal',
      wordBreak: 'normal'
    };
  }
  var _a = codePointsToCharacterClasses(codePoints, options.lineBreak),
    indicies = _a[0],
    classTypes = _a[1],
    isLetterNumber = _a[2];
  if (options.wordBreak === 'break-all' || options.wordBreak === 'break-word') {
    classTypes = classTypes.map(function (type) {
      return [NU, AL, SA].indexOf(type) !== -1 ? ID : type;
    });
  }
  var forbiddenBreakpoints = options.wordBreak === 'keep-all' ? isLetterNumber.map(function (letterNumber, i) {
    return letterNumber && codePoints[i] >= 0x4e00 && codePoints[i] <= 0x9fff;
  }) : undefined;
  return [indicies, classTypes, forbiddenBreakpoints];
};
var Break = /** @class */function () {
  function Break(codePoints, lineBreak, start, end) {
    this.codePoints = codePoints;
    this.required = lineBreak === BREAK_MANDATORY;
    this.start = start;
    this.end = end;
  }
  Break.prototype.slice = function () {
    return fromCodePoint.apply(void 0, this.codePoints.slice(this.start, this.end));
  };
  return Break;
}();
var LineBreaker = function LineBreaker(str, options) {
  var codePoints = toCodePoints(str);
  var _a = cssFormattedClasses(codePoints, options),
    indicies = _a[0],
    classTypes = _a[1],
    forbiddenBreakpoints = _a[2];
  var length = codePoints.length;
  var lastEnd = 0;
  var nextIndex = 0;
  return {
    next: function next() {
      if (nextIndex >= length) {
        return {
          done: true,
          value: null
        };
      }
      var lineBreak = BREAK_NOT_ALLOWED;
      while (nextIndex < length && (lineBreak = _lineBreakAtIndex(codePoints, classTypes, indicies, ++nextIndex, forbiddenBreakpoints)) === BREAK_NOT_ALLOWED) {}
      if (lineBreak !== BREAK_NOT_ALLOWED || nextIndex === length) {
        var value = new Break(codePoints, lineBreak, lastEnd, nextIndex);
        lastEnd = nextIndex;
        return {
          value: value,
          done: false
        };
      }
      return {
        done: true,
        value: null
      };
    }
  };
};

;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-common@0.3.9@@ali/tingwu-common/dist-web/words.js

var getWordsCount = function getWordsCount(str) {
  try {
    var breaker = LineBreaker(str);
    var wordsCount = 0;
    while (!breaker.next().done) {
      wordsCount += 1;
    }
    return wordsCount;
    /* eslint-disable alidocs/catch-call-function */
  } catch (e) {
    return 0;
  }
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/abstractCmdController.js
var AbstractCmdController = function AbstractCmdController(controller) {
  this.controller = void 0;
  this.controller = controller;
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/liveMeetingController.js


var LiveMeetingController = /*#__PURE__*/function (_AbstractCmdControlle) {
  _inheritsLoose(LiveMeetingController, _AbstractCmdControlle);
  function LiveMeetingController() {
    return _AbstractCmdControlle.apply(this, arguments) || this;
  }
  var _proto = LiveMeetingController.prototype;
  _proto.startLiveMeeting = function startLiveMeeting() {};
  _proto.endLiveMeeting = function endLiveMeeting() {};
  return LiveMeetingController;
}(AbstractCmdController);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_freeGlobal.js
/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;
/* harmony default export */ var _freeGlobal = (freeGlobal);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_root.js


/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = _freeGlobal || freeSelf || Function('return this')();
/* harmony default export */ var _root = (root);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_Symbol.js


/** Built-in value references. */
var _Symbol_Symbol = _root.Symbol;
/* harmony default export */ var _Symbol = (_Symbol_Symbol);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getRawTag.js


/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _getRawTag_hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = _getRawTag_hasOwnProperty.call(value, symToStringTag),
    tag = value[symToStringTag];
  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}
  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}
/* harmony default export */ var _getRawTag = (getRawTag);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_objectToString.js
/** Used for built-in method references. */
var _objectToString_objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var _objectToString_nativeObjectToString = _objectToString_objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return _objectToString_nativeObjectToString.call(value);
}
/* harmony default export */ var _objectToString = (objectToString);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseGetTag.js




/** `Object#toString` result references. */
var nullTag = '[object Null]',
  undefinedTag = '[object Undefined]';

/** Built-in value references. */
var _baseGetTag_symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return _baseGetTag_symToStringTag && _baseGetTag_symToStringTag in Object(value) ? _getRawTag(value) : _objectToString(value);
}
/* harmony default export */ var _baseGetTag = (baseGetTag);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isObject.js
/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isObject = (isObject);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isFunction.js



/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
  funcTag = '[object Function]',
  genTag = '[object GeneratorFunction]',
  proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!_lodash_es_4_17_21_lodash_es_isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = _baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isFunction = (isFunction);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_coreJsData.js


/** Used to detect overreaching core-js shims. */
var coreJsData = _root["__core-js_shared__"];
/* harmony default export */ var _coreJsData = (coreJsData);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_isMasked.js


/** Used to detect methods masquerading as native. */
var maskSrcKey = function () {
  var uid = /[^.]+$/.exec(_coreJsData && _coreJsData.keys && _coreJsData.keys.IE_PROTO || '');
  return uid ? 'Symbol(src)_1.' + uid : '';
}();

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && maskSrcKey in func;
}
/* harmony default export */ var _isMasked = (isMasked);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_toSource.js
/** Used for built-in method references. */
var funcProto = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return func + '';
    } catch (e) {}
  }
  return '';
}
/* harmony default export */ var _toSource = (toSource);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseIsNative.js





/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var _baseIsNative_funcProto = Function.prototype,
  _baseIsNative_objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var _baseIsNative_funcToString = _baseIsNative_funcProto.toString;

/** Used to check objects for own properties. */
var _baseIsNative_hasOwnProperty = _baseIsNative_objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' + _baseIsNative_funcToString.call(_baseIsNative_hasOwnProperty).replace(reRegExpChar, '\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$');

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!_lodash_es_4_17_21_lodash_es_isObject(value) || _isMasked(value)) {
    return false;
  }
  var pattern = _lodash_es_4_17_21_lodash_es_isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(_toSource(value));
}
/* harmony default export */ var _baseIsNative = (baseIsNative);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getValue.js
/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}
/* harmony default export */ var _getValue = (getValue);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getNative.js



/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = _getValue(object, key);
  return _baseIsNative(value) ? value : undefined;
}
/* harmony default export */ var _getNative = (getNative);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_nativeCreate.js


/* Built-in method references that are verified to be native. */
var nativeCreate = _getNative(Object, 'create');
/* harmony default export */ var _nativeCreate = (nativeCreate);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_hashClear.js


/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = _nativeCreate ? _nativeCreate(null) : {};
  this.size = 0;
}
/* harmony default export */ var _hashClear = (hashClear);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_hashDelete.js
/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}
/* harmony default export */ var _hashDelete = (hashDelete);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_hashGet.js


/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var _hashGet_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _hashGet_hasOwnProperty = _hashGet_objectProto.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (_nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return _hashGet_hasOwnProperty.call(data, key) ? data[key] : undefined;
}
/* harmony default export */ var _hashGet = (hashGet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_hashHas.js


/** Used for built-in method references. */
var _hashHas_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _hashHas_hasOwnProperty = _hashHas_objectProto.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return _nativeCreate ? data[key] !== undefined : _hashHas_hasOwnProperty.call(data, key);
}
/* harmony default export */ var _hashHas = (hashHas);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_hashSet.js


/** Used to stand-in for `undefined` hash values. */
var _hashSet_HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = _nativeCreate && value === undefined ? _hashSet_HASH_UNDEFINED : value;
  return this;
}
/* harmony default export */ var _hashSet = (hashSet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_Hash.js






/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
    length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = _hashClear;
Hash.prototype['delete'] = _hashDelete;
Hash.prototype.get = _hashGet;
Hash.prototype.has = _hashHas;
Hash.prototype.set = _hashSet;
/* harmony default export */ var _Hash = (Hash);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_listCacheClear.js
/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}
/* harmony default export */ var _listCacheClear = (listCacheClear);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/eq.js
/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || value !== value && other !== other;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_eq = (eq);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_assocIndexOf.js


/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (_lodash_es_4_17_21_lodash_es_eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}
/* harmony default export */ var _assocIndexOf = (assocIndexOf);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_listCacheDelete.js


/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
    index = _assocIndexOf(data, key);
  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}
/* harmony default export */ var _listCacheDelete = (listCacheDelete);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_listCacheGet.js


/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
    index = _assocIndexOf(data, key);
  return index < 0 ? undefined : data[index][1];
}
/* harmony default export */ var _listCacheGet = (listCacheGet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_listCacheHas.js


/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return _assocIndexOf(this.__data__, key) > -1;
}
/* harmony default export */ var _listCacheHas = (listCacheHas);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_listCacheSet.js


/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
    index = _assocIndexOf(data, key);
  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}
/* harmony default export */ var _listCacheSet = (listCacheSet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_ListCache.js






/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
    length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = _listCacheClear;
ListCache.prototype['delete'] = _listCacheDelete;
ListCache.prototype.get = _listCacheGet;
ListCache.prototype.has = _listCacheHas;
ListCache.prototype.set = _listCacheSet;
/* harmony default export */ var _ListCache = (ListCache);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_Map.js



/* Built-in method references that are verified to be native. */
var _Map_Map = _getNative(_root, 'Map');
/* harmony default export */ var _Map = (_Map_Map);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_mapCacheClear.js




/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new _Hash(),
    'map': new (_Map || _ListCache)(),
    'string': new _Hash()
  };
}
/* harmony default export */ var _mapCacheClear = (mapCacheClear);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_isKeyable.js
/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean' ? value !== '__proto__' : value === null;
}
/* harmony default export */ var _isKeyable = (isKeyable);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getMapData.js


/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return _isKeyable(key) ? data[typeof key == 'string' ? 'string' : 'hash'] : data.map;
}
/* harmony default export */ var _getMapData = (getMapData);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_mapCacheDelete.js


/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = _getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}
/* harmony default export */ var _mapCacheDelete = (mapCacheDelete);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_mapCacheGet.js


/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return _getMapData(this, key).get(key);
}
/* harmony default export */ var _mapCacheGet = (mapCacheGet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_mapCacheHas.js


/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return _getMapData(this, key).has(key);
}
/* harmony default export */ var _mapCacheHas = (mapCacheHas);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_mapCacheSet.js


/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = _getMapData(this, key),
    size = data.size;
  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}
/* harmony default export */ var _mapCacheSet = (mapCacheSet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_MapCache.js






/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
    length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = _mapCacheClear;
MapCache.prototype['delete'] = _mapCacheDelete;
MapCache.prototype.get = _mapCacheGet;
MapCache.prototype.has = _mapCacheHas;
MapCache.prototype.set = _mapCacheSet;
/* harmony default export */ var _MapCache = (MapCache);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_setCacheAdd.js
/** Used to stand-in for `undefined` hash values. */
var _setCacheAdd_HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, _setCacheAdd_HASH_UNDEFINED);
  return this;
}
/* harmony default export */ var _setCacheAdd = (setCacheAdd);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_setCacheHas.js
/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}
/* harmony default export */ var _setCacheHas = (setCacheHas);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_SetCache.js




/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
    length = values == null ? 0 : values.length;
  this.__data__ = new _MapCache();
  while (++index < length) {
    this.add(values[index]);
  }
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = _setCacheAdd;
SetCache.prototype.has = _setCacheHas;
/* harmony default export */ var _SetCache = (SetCache);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseFindIndex.js
/**
 * The base implementation of `_.findIndex` and `_.findLastIndex` without
 * support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} predicate The function invoked per iteration.
 * @param {number} fromIndex The index to search from.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseFindIndex(array, predicate, fromIndex, fromRight) {
  var length = array.length,
    index = fromIndex + (fromRight ? 1 : -1);
  while (fromRight ? index-- : ++index < length) {
    if (predicate(array[index], index, array)) {
      return index;
    }
  }
  return -1;
}
/* harmony default export */ var _baseFindIndex = (baseFindIndex);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseIsNaN.js
/**
 * The base implementation of `_.isNaN` without support for number objects.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
 */
function baseIsNaN(value) {
  return value !== value;
}
/* harmony default export */ var _baseIsNaN = (baseIsNaN);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_strictIndexOf.js
/**
 * A specialized version of `_.indexOf` which performs strict equality
 * comparisons of values, i.e. `===`.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function strictIndexOf(array, value, fromIndex) {
  var index = fromIndex - 1,
    length = array.length;
  while (++index < length) {
    if (array[index] === value) {
      return index;
    }
  }
  return -1;
}
/* harmony default export */ var _strictIndexOf = (strictIndexOf);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseIndexOf.js




/**
 * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseIndexOf(array, value, fromIndex) {
  return value === value ? _strictIndexOf(array, value, fromIndex) : _baseFindIndex(array, _baseIsNaN, fromIndex);
}
/* harmony default export */ var _baseIndexOf = (baseIndexOf);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_arrayIncludes.js


/**
 * A specialized version of `_.includes` for arrays without support for
 * specifying an index to search from.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludes(array, value) {
  var length = array == null ? 0 : array.length;
  return !!length && _baseIndexOf(array, value, 0) > -1;
}
/* harmony default export */ var _arrayIncludes = (arrayIncludes);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_arrayIncludesWith.js
/**
 * This function is like `arrayIncludes` except that it accepts a comparator.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @param {Function} comparator The comparator invoked per element.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludesWith(array, value, comparator) {
  var index = -1,
    length = array == null ? 0 : array.length;
  while (++index < length) {
    if (comparator(value, array[index])) {
      return true;
    }
  }
  return false;
}
/* harmony default export */ var _arrayIncludesWith = (arrayIncludesWith);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_cacheHas.js
/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}
/* harmony default export */ var _cacheHas = (cacheHas);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_Set.js



/* Built-in method references that are verified to be native. */
var _Set_Set = _getNative(_root, 'Set');
/* harmony default export */ var _Set = (_Set_Set);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_setToArray.js
/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
    result = Array(set.size);
  set.forEach(function (value) {
    result[++index] = value;
  });
  return result;
}
/* harmony default export */ var _setToArray = (setToArray);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_createSet.js




/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Creates a set object of `values`.
 *
 * @private
 * @param {Array} values The values to add to the set.
 * @returns {Object} Returns the new set.
 */
var createSet = !(_Set && 1 / _setToArray(new _Set([, -0]))[1] == INFINITY) ? _lodash_es_4_17_21_lodash_es_noop : function (values) {
  return new _Set(values);
};
/* harmony default export */ var _createSet = (createSet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseUniq.js







/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of `_.uniqBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new duplicate free array.
 */
function baseUniq(array, iteratee, comparator) {
  var index = -1,
    includes = _arrayIncludes,
    length = array.length,
    isCommon = true,
    result = [],
    seen = result;
  if (comparator) {
    isCommon = false;
    includes = _arrayIncludesWith;
  } else if (length >= LARGE_ARRAY_SIZE) {
    var set = iteratee ? null : _createSet(array);
    if (set) {
      return _setToArray(set);
    }
    isCommon = false;
    includes = _cacheHas;
    seen = new _SetCache();
  } else {
    seen = iteratee ? [] : result;
  }
  outer: while (++index < length) {
    var value = array[index],
      computed = iteratee ? iteratee(value) : value;
    value = comparator || value !== 0 ? value : 0;
    if (isCommon && computed === computed) {
      var seenIndex = seen.length;
      while (seenIndex--) {
        if (seen[seenIndex] === computed) {
          continue outer;
        }
      }
      if (iteratee) {
        seen.push(computed);
      }
      result.push(value);
    } else if (!includes(seen, computed, comparator)) {
      if (seen !== result) {
        seen.push(computed);
      }
      result.push(value);
    }
  }
  return result;
}
/* harmony default export */ var _baseUniq = (baseUniq);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/uniq.js


/**
 * Creates a duplicate-free version of an array, using
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons, in which only the first occurrence of each element
 * is kept. The order of result values is determined by the order they occur
 * in the array.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {Array} array The array to inspect.
 * @returns {Array} Returns the new duplicate free array.
 * @example
 *
 * _.uniq([2, 1, 2]);
 * // => [2, 1]
 */
function uniq(array) {
  return array && array.length ? _baseUniq(array) : [];
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_uniq = (uniq);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/utils/search.js

var findSelections = function findSelections(textContent, keyword, extraParams) {
  var offset = 0;
  var keywordLength = keyword.length;
  var foundTexts = [];
  while (true) {
    var pos = textContent.indexOf(keyword, offset);
    if (pos > -1) {
      var startOffset = pos;
      var endOffset = pos + keywordLength;
      foundTexts.push(extends_extends({
        startOffset: startOffset,
        endOffset: endOffset
      }, extraParams || {}));
      offset = pos + keywordLength;
    } else {
      break;
    }
  }
  return foundTexts;
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/translateController.js



var TranslateMode;
(function (TranslateMode) {
  TranslateMode[TranslateMode["OriginAndTranslate"] = 0] = "OriginAndTranslate";
  TranslateMode[TranslateMode["TranslateOnly"] = 1] = "TranslateOnly";
  TranslateMode[TranslateMode["Disabled"] = 2] = "Disabled";
})(TranslateMode || (TranslateMode = {}));
var TranslateController = /*#__PURE__*/function (_AbstractCmdControlle) {
  _inheritsLoose(TranslateController, _AbstractCmdControlle);
  function TranslateController() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCmdControlle.call.apply(_AbstractCmdControlle, [this].concat(args)) || this;
    _this.fixParagraphTranslate = {};
    _this.unfixParagraphTranslate = {
      fixContentTranslate: [],
      unfixContentTranslate: ''
    };
    _this.translateMode = TranslateMode.Disabled;
    return _this;
  }
  var _proto = TranslateController.prototype;
  _proto.setTranslateMode = function setTranslateMode(translateMode) {
    var oldTranslateMode = this.translateMode;
    this.translateMode = translateMode;
    var livingMode = this.controller.getLivingMode();
    if (livingMode && oldTranslateMode === TranslateMode.Disabled && translateMode !== TranslateMode.Disabled) {
      // 当开启翻译时，触发一次unfixContentChange，为了能够触发一次翻译
      this.controller.emitUnfixContentChange();
    }
    this.controller.emit('translateModeChange', {
      translateMode: translateMode
    });
  };
  _proto.getTranslateMode = function getTranslateMode(_pid) {
    return this.translateMode;
  };
  _proto.setTranslating = function setTranslating(pid, isTranslating) {
    var translate = this.fixParagraphTranslate[pid];
    if (translate && translate.isTranslating === isTranslating && !translate.isTranslateError) {
      return;
    }
    if (translate == null) {
      this.fixParagraphTranslate[pid] = {
        translateResult: [],
        pid: pid,
        isTranslating: isTranslating,
        isTranslateError: false
      };
    } else {
      translate.isTranslating = true;
      translate.isTranslateError = false;
    }
    this.controller.emit('fixParagraphTranslateChange', {
      pid: pid,
      translate: this.fixParagraphTranslate[pid]
    });
  };
  _proto.isTranslateError = function isTranslateError(words) {
    return words.map(function (word) {
      return word.text;
    }).join('').length === 0;
  } //
  // return isSuccessful
  ;

  _proto.setTranslate = function setTranslate(pid, translate) {
    return this.setTranslateByWords(pid, getWordsBySces(translate));
  } //
  // return isSuccessful
  ;

  _proto.setTranslateByWords = function setTranslateByWords(pid, translate) {
    var isHasContent = this.controller.getTextContent(pid);
    var isError = isHasContent && this.isTranslateError(translate);
    if (!this.fixParagraphTranslate[pid]) {
      this.fixParagraphTranslate[pid] = {
        pid: pid,
        translateResult: []
      };
    }
    this.fixParagraphTranslate[pid].isTranslating = false;
    if (isError) {
      this.fixParagraphTranslate[pid].isTranslateError = true;
    } else {
      this.fixParagraphTranslate[pid].isTranslateError = false;
      this.fixParagraphTranslate[pid].translateResult = translate;
    }
    this.controller.emit('fixParagraphTranslateChange', {
      pid: pid,
      translate: this.fixParagraphTranslate[pid]
    });
    return !isError;
  };
  _proto.getTranslate = function getTranslate(pid) {
    return this.fixParagraphTranslate[pid];
  };
  _proto.setUnfixTranslate = function setUnfixTranslate(pid, unfixContentTranslate, fixContentTranslate) {
    this.setUnfixTranslateByWords(pid, unfixContentTranslate, getWordsBySces(fixContentTranslate));
  };
  _proto.setUnfixTranslateByWords = function setUnfixTranslateByWords(pid, unfixContentTranslate, fixContentTranslate) {
    this.unfixParagraphTranslate = {
      pid: pid,
      unfixContentTranslate: unfixContentTranslate,
      fixContentTranslate: fixContentTranslate
    };
    this.controller.emit('unfixParagraphTranslateChange', this.unfixParagraphTranslate);
  };
  _proto.getUnfixTranslate = function getUnfixTranslate() {
    return this.unfixParagraphTranslate;
  };
  _proto.setUnfixToFixed = function setUnfixToFixed(newUnfixPid) {
    var _this$getUnfixTransla = this.getUnfixTranslate(),
      pid = _this$getUnfixTransla.pid,
      fixContentTranslate = _this$getUnfixTransla.fixContentTranslate;
    if (pid) {
      this.setUnfixTranslate(newUnfixPid, '', []);
      this.setTranslateByWords(pid, fixContentTranslate);
    }
  };
  _proto.reset = function reset() {
    this.fixParagraphTranslate = {};
    this.unfixParagraphTranslate = {
      fixContentTranslate: [],
      unfixContentTranslate: ''
    };
  };
  return TranslateController;
}(AbstractCmdController);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/searchReplaceController.js





var SearchReplaceController = /*#__PURE__*/function (_AbstractCmdControlle) {
  _inheritsLoose(SearchReplaceController, _AbstractCmdControlle);
  function SearchReplaceController(controller) {
    var _this;
    _this = _AbstractCmdControlle.call(this, controller) || this;
    _this.keyword = '';
    _this.foundResultMap = {};
    _this.activeIndex = undefined;
    _this.isSearchTranslate = true;
    controller.on('paragraphChange', function (_ref) {
      var pid = _ref.pid;
      if (_this.keyword) {
        var foundResult = _this.findTextContent(pid, _this.keyword);
        if (foundResult.origin.length > 0 || foundResult.translate.length > 0) {
          _this.foundResultMap[pid] = foundResult;
        } else {
          delete _this.foundResultMap[pid];
        }
        setTimeout(function () {
          _this.emitSearchReplaceEvent(false);
        }, 0);
      }
    });
    return _this;
  }
  var _proto = SearchReplaceController.prototype;
  _proto.getFoundSelections = function getFoundSelections() {
    var _this2 = this;
    var controller = this.controller;
    var pids = controller.getPids(true);
    var foundSelections = [];
    pids.forEach(function (pid) {
      var result = _this2.foundResultMap[pid];
      if (result) {
        if (result.origin.length > 0) {
          foundSelections.push.apply(foundSelections, result.origin);
        }
        if (result.translate.length > 0) {
          foundSelections.push.apply(foundSelections, result.translate);
        }
      }
    });
    return foundSelections;
  };
  _proto.getFoundSelectionsByPid = function getFoundSelectionsByPid(pid) {
    return this.foundResultMap[pid];
  };
  _proto.getActiveFoundSelection = function getActiveFoundSelection() {
    if (this.activeIndex === undefined) {
      return undefined;
    }
    return this.getFoundSelections()[this.activeIndex];
  };
  _proto.findTextContent = function findTextContent(pid, _keyword) {
    var foundResult = {
      origin: [],
      translate: []
    };
    var translateMode = this.controller.getTranslateMode(pid);
    if (translateMode === TranslateMode.Disabled || translateMode === TranslateMode.OriginAndTranslate) {
      foundResult.origin = this.findOriginTextContent(pid, _keyword);
    }
    if (this.isSearchTranslate) {
      if (translateMode === TranslateMode.TranslateOnly || translateMode === TranslateMode.OriginAndTranslate) {
        foundResult.translate = this.findTranslateContent(pid, _keyword);
      }
    }
    return foundResult;
  };
  _proto.findOriginTextContent = function findOriginTextContent(pid, _keyword) {
    var _textContent = this.controller.getTextContent(pid);
    var textContent = _textContent.toLowerCase();
    var keyword = _keyword.toLowerCase();
    if (!keyword) {
      return [];
    }
    return findSelections(textContent, keyword, {
      pid: pid
    });
  };
  _proto.findTranslateContent = function findTranslateContent(pid, _keyword) {
    var translate = this.controller.getTranslate(pid);
    if (!translate || translate.translateResult.length === 0) {
      return [];
    }
    var textContent = translate.translateResult.reduce(function (result, word) {
      return result + word.text;
    }, '').toLowerCase();
    var keyword = _keyword.toLowerCase();
    if (!keyword) {
      return [];
    }
    return findSelections(textContent, keyword, {
      pid: pid,
      readonly: true
    });
  };
  _proto.find = function find(keyword, isSearchTranslate) {
    var _this3 = this;
    if (isSearchTranslate === void 0) {
      isSearchTranslate = true;
    }
    var controller = this.controller;
    this.keyword = keyword;
    this.isSearchTranslate = isSearchTranslate;
    var pids = controller.getPids(true);
    this.foundResultMap = {};
    pids.forEach(function (pid) {
      var foundeds = _this3.findTextContent(pid, keyword);
      if (foundeds.origin.length > 0 || foundeds.translate.length > 0) {
        _this3.foundResultMap[pid] = foundeds;
      }
    });
  };
  _proto.findAndMark = function findAndMark(keyword, isSearchTranslate, enableScroll) {
    var _maybeChangedPids;
    if (isSearchTranslate === void 0) {
      isSearchTranslate = true;
    }
    if (enableScroll === void 0) {
      enableScroll = true;
    }
    var maybeChangedPids = Object.keys(this.foundResultMap);
    this.find(keyword, isSearchTranslate);
    var selectionLength = this.getFoundSelections().length;
    if (selectionLength > 0) {
      if (!this.activeIndex || selectionLength <= this.activeIndex) {
        this.activeIndex = 0;
      }
    } else {
      this.activeIndex = undefined;
    }
    maybeChangedPids = _lodash_es_4_17_21_lodash_es_uniq((_maybeChangedPids = maybeChangedPids).concat.apply(_maybeChangedPids, Object.keys(this.foundResultMap)));
    this.controller.emit('paragraphListChange', {
      maybeChangedPids: maybeChangedPids
    });
    this.emitSearchReplaceEvent(enableScroll);
    return this.foundResultMap;
  };
  _proto.reFindAndMark = function reFindAndMark() {
    if (this.keyword) {
      this.findAndMark(this.keyword, this.isSearchTranslate, false);
    }
  };
  _proto.generateFoundPrevNext = function generateFoundPrevNext(type) {
    var selections = this.getFoundSelections();
    var maybeChangedPids = [];
    if (this.activeIndex !== undefined) {
      maybeChangedPids.push(selections[this.activeIndex].pid);
    }
    if (this.activeIndex === undefined) {
      this.activeIndex = 0;
    }
    if (type === 'prev') {
      if (this.activeIndex === 0) {
        this.activeIndex = selections.length - 1;
      } else {
        this.activeIndex--;
      }
    } else if (type === 'next') {
      if (this.activeIndex + 1 === selections.length) {
        this.activeIndex = 0;
      } else {
        this.activeIndex++;
      }
    }
    maybeChangedPids.push(selections[this.activeIndex].pid);
    this.controller.emit('paragraphListChange', {
      maybeChangedPids: maybeChangedPids
    });
    this.emitSearchReplaceEvent();
  };
  _proto.prev = function prev() {
    this.generateFoundPrevNext('prev');
  };
  _proto.next = function next() {
    this.generateFoundPrevNext('next');
  };
  _proto.replace = function replace(text) {
    if (this.activeIndex === undefined) {
      return;
    }
    var selections = this.getFoundSelections();
    var length = selections.length;
    var selection = selections[this.activeIndex];
    var nextSelection = selections[this.activeIndex + 1];
    var prevSelection = selections[this.activeIndex - 1];
    if (selection.readonly) {
      return;
    }
    this.controller.dontSelectNext().replaceText(selection.pid, selection.startOffset, selection.endOffset, text);
    var maybeChangedPids = [selection.pid];
    if (nextSelection === undefined) {
      this.activeIndex = length - 1;
      if (prevSelection) {
        maybeChangedPids.push(prevSelection.pid);
      }
    } else {
      maybeChangedPids.push(nextSelection.pid);
    }
    this.controller.emit('paragraphListChange', {
      maybeChangedPids: maybeChangedPids
    });
    this.emitSearchReplaceEvent();
  };
  _proto.replaceAll = function replaceAll(text) {
    var maybeChangedPids = Object.keys(this.foundResultMap);
    var pLength = maybeChangedPids.length;
    if (pLength === 0) {
      return;
    }
    this.controller.dontSelectNext();
    var pIndex = 0;
    for (var _i = 0, _Object$entries = Object.entries(this.foundResultMap); _i < _Object$entries.length; _i++) {
      var _Object$entries$_i = _Object$entries[_i],
        foundResult = _Object$entries$_i[1];
      var origin = foundResult.origin;
      var offset = 0;
      var selectionLength = origin.length;
      for (var i = 0; i < selectionLength; i++) {
        var selection = origin[i];
        this.controller.replaceText(selection.pid, selection.startOffset + offset, selection.endOffset + offset, text, !(pIndex + 1 === pLength && i + 1 === selectionLength));
        offset += text.length - (selection.endOffset - selection.startOffset);
      }
      pIndex++;
    }
    this.reFindAndMark();
    this.controller.emit('paragraphListChange', {
      maybeChangedPids: maybeChangedPids
    });
    this.emitSearchReplaceEvent();
  };
  _proto.emitSearchReplaceEvent = function emitSearchReplaceEvent(enableScroll) {
    var _this$activeIndex;
    if (enableScroll === void 0) {
      enableScroll = true;
    }
    var selections = this.getFoundSelections();
    this.controller.emit('searchReplaceChange', {
      keyword: this.keyword,
      activeIndex: (_this$activeIndex = this.activeIndex) != null ? _this$activeIndex : 0,
      foundLength: selections.length,
      selections: selections,
      enableScroll: enableScroll
    });
  };
  _proto.resetFind = function resetFind() {
    var maybeChangedPids = Object.keys(this.foundResultMap);
    this.keyword = '';
    this.activeIndex = undefined;
    this.foundResultMap = {};
    this.controller.emit('paragraphListChange', {
      maybeChangedPids: maybeChangedPids
    });
    this.emitSearchReplaceEvent();
  };
  _proto.reset = function reset() {
    this.keyword = '';
    this.activeIndex = undefined;
    this.isSearchTranslate = true;
    this.foundResultMap = {};
  };
  return SearchReplaceController;
}(AbstractCmdController);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/voiceWordController.js


var VoiceWordController = /*#__PURE__*/function (_AbstractCmdControlle) {
  _inheritsLoose(VoiceWordController, _AbstractCmdControlle);
  function VoiceWordController() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCmdControlle.call.apply(_AbstractCmdControlle, [this].concat(args)) || this;
    _this.playingVoicePid = void 0;
    _this.playingVoiceWord = void 0;
    _this.isEnablePlayingVoice = false;
    return _this;
  }
  var _proto = VoiceWordController.prototype;
  _proto.startPlayingVoiceWord = function startPlayingVoiceWord() {
    this.isEnablePlayingVoice = true;
    this.controller.emit('blurCurrentTextEditor', {});
    this.controller.emit('playingVoiceWordEnableChange', {
      enable: true
    });
  };
  _proto.endPlayingVoiceWord = function endPlayingVoiceWord() {
    this.isEnablePlayingVoice = false;
    this.controller.emit('playingVoiceWordEnableChange', {
      enable: false
    });
  };
  _proto.getIsEnablePlayingVoice = function getIsEnablePlayingVoice() {
    return this.isEnablePlayingVoice;
  };
  _proto.setPlayingVoiceWord = function setPlayingVoiceWord(pid, word, forceDisplay) {
    if (forceDisplay === void 0) {
      forceDisplay = false;
    }
    var playingVoicePid = this.playingVoicePid;
    this.playingVoicePid = pid;
    this.playingVoiceWord = word;
    if (playingVoicePid && playingVoicePid !== pid) {
      this.controller.emit('playingVoiceWordChange', {
        pid: playingVoicePid,
        word: undefined
      });
    }
    this.controller.emit('playingVoiceWordChange', {
      pid: pid,
      word: word,
      forceDisplay: forceDisplay
    });
  };
  _proto.getPlayingPidAndWord = function getPlayingPidAndWord() {
    return [this.playingVoicePid, this.playingVoiceWord];
  };
  _proto.getPlayingWord = function getPlayingWord(pid) {
    if (this.playingVoicePid === pid) {
      return this.playingVoiceWord;
    }
    return undefined;
  };
  _proto.setPlayingVoiceWordByTime = function setPlayingVoiceWordByTime(timestamp, forceDisplay) {
    if (forceDisplay === void 0) {
      forceDisplay = false;
    }
    var _ref = this.controller.getLastWordByTime(timestamp) || [],
      pid = _ref[0],
      word = _ref[1];
    if (pid && word) {
      this.setPlayingVoiceWord(pid, word, forceDisplay);
    }
  };
  _proto.getNextSentencesByTime = function getNextSentencesByTime(timestamp) {
    var _this$controller$getM = this.controller.getMatchedWordsByTime(timestamp),
      allWords = _this$controller$getM[0],
      pos = _this$controller$getM[1],
      words = _this$controller$getM[2];
    var _ref2 = words.length > 0 ? words[words.length - 1] : allWords[pos],
      lastWord = _ref2[1];
    var length = allWords.length;
    var foundSentenceId;
    var sentences = [];
    for (var i = 0; i < length; i++) {
      var _allWords$i = allWords[i],
        word = _allWords$i[1];
      if (!foundSentenceId && Number(word.sentenceId) > Number(lastWord.sentenceId)) {
        foundSentenceId = word.sentenceId;
      }
      if (foundSentenceId && word.sentenceId === foundSentenceId) {
        sentences.push(word);
      }
    }
    return sentences;
  };
  _proto.getPrevSentencesByTime = function getPrevSentencesByTime(timestamp) {
    var _this$controller$getM2 = this.controller.getMatchedWordsByTime(timestamp),
      allWords = _this$controller$getM2[0],
      pos = _this$controller$getM2[1],
      words = _this$controller$getM2[2];
    var _ref3 = words.length > 0 ? words[0] : allWords[pos],
      firstWord = _ref3[1];
    var length = allWords.length;
    var foundSentenceId;
    var sentences = [];
    for (var i = length - 1; i >= 0; i--) {
      var _allWords$i2 = allWords[i],
        word = _allWords$i2[1];
      if (!foundSentenceId && Number(word.sentenceId) < Number(firstWord.sentenceId)) {
        foundSentenceId = word.sentenceId;
      }
      if (foundSentenceId && word.sentenceId === foundSentenceId) {
        sentences.unshift(word);
      }
    }
    return sentences;
  };
  _proto.clearPlayingVoiceWord = function clearPlayingVoiceWord() {
    var playingVoicePid = this.playingVoicePid;
    this.reset();
    if (playingVoicePid) {
      this.controller.emit('playingVoiceWordChange', {
        pid: playingVoicePid,
        word: undefined
      });
    }
  };
  _proto.reset = function reset() {
    this.playingVoicePid = undefined;
    this.playingVoiceWord = undefined;
  };
  return VoiceWordController;
}(AbstractCmdController);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/agendaController.js


var AgendaController = /*#__PURE__*/function (_AbstractCmdControlle) {
  _inheritsLoose(AgendaController, _AbstractCmdControlle);
  function AgendaController() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCmdControlle.call.apply(_AbstractCmdControlle, [this].concat(args)) || this;
    _this.agendas = [];
    _this.activeAgendaIndex = void 0;
    _this.enableActiveAgenda = false;
    return _this;
  }
  var _proto = AgendaController.prototype;
  _proto.getEnableActiveAgenda = function getEnableActiveAgenda() {
    return this.enableActiveAgenda;
  };
  _proto.setAgendas = function setAgendas(agendas) {
    this.agendas = agendas;
    this.controller.emit('agendasChange', {
      agendas: agendas
    });
  };
  _proto.getAgendas = function getAgendas() {
    return this.agendas;
  };
  _proto.fromJSON = function fromJSON(agendaCheckpoints) {
    if (!agendaCheckpoints || agendaCheckpoints.length === 0) {
      this.setAgendas([]);
    }
    var agendas = agendaCheckpoints.map(function (cp) {
      return {
        id: String(cp.id),
        title: cp.value,
        beginTime: cp.time || 0,
        endTime: cp.endTime || 0,
        highlightContents: (cp.extensions || []).map(function (ext) {
          return {
            beginTime: ext.startTime,
            endTime: ext.endTime,
            sid: String(ext.sId)
          };
        })
      };
    });
    this.setAgendas(agendas);
  };
  _proto.getActiveAgenda = function getActiveAgenda() {
    if (this.activeAgendaIndex == null || !this.agendas) {
      return undefined;
    }
    return this.agendas[this.activeAgendaIndex];
  };
  _proto.setActiveAgendaById = function setActiveAgendaById(id) {
    if (!this.agendas) {
      return;
    }
    var length = this.agendas.length;
    for (var i = 0; i < length; i++) {
      var agenda = this.agendas[i];
      if (agenda.id === id) {
        if (this.activeAgendaIndex === i) {
          return;
        }
        this.enableActiveAgenda = true;
        this.activeAgendaIndex = i;
        this.controller.emit('activeAgendaChange', {
          agenda: this.agendas[i]
        });
        return;
      }
    }
    this.clearActiveAgenda();
  };
  _proto.clearActiveAgenda = function clearActiveAgenda() {
    this.enableActiveAgenda = false;
    this.activeAgendaIndex = undefined;
    this.controller.emit('activeAgendaChange', {
      agenda: undefined
    });
  };
  _proto.setActiveAgendaByTime = function setActiveAgendaByTime(timestamp) {
    var _this2 = this;
    if (!this.agendas) {
      return;
    }
    this.agendas.some(function (agenda) {
      if (agenda) {
        if (timestamp >= agenda.beginTime && timestamp <= agenda.endTime) {
          _this2.setActiveAgendaById(agenda.id);
          return true;
        }
      }
      return false;
    });
  };
  _proto.getActiveAgendaHighlightSids = function getActiveAgendaHighlightSids() {
    if (this.activeAgendaIndex == null || !this.agendas) {
      return [];
    }
    return this.agendas[this.activeAgendaIndex].highlightContents.map(function (c) {
      return c.sid;
    });
  };
  _proto.reset = function reset() {
    this.agendas = [];
    this.activeAgendaIndex = undefined;
    this.enableActiveAgenda = false;
  };
  return AgendaController;
}(AbstractCmdController);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/paragraphFilterController.js


var ParagraphFilterController = /*#__PURE__*/function (_AbstractCmdControlle) {
  _inheritsLoose(ParagraphFilterController, _AbstractCmdControlle);
  function ParagraphFilterController() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCmdControlle.call.apply(_AbstractCmdControlle, [this].concat(args)) || this;
    _this.filterOption = {};
    return _this;
  }
  var _proto = ParagraphFilterController.prototype;
  _proto.setFilterOption = function setFilterOption(filterOption) {
    this.filterOption = filterOption;
  };
  _proto.getFilterOption = function getFilterOption() {
    return this.filterOption;
  };
  _proto.isPidVisible = function isPidVisible(pid) {
    var paragraph = this.controller.getParagraph(pid);
    var words = this.controller.getWords(pid);
    var _this$filterOption = this.filterOption,
      filterMarkParagraph = _this$filterOption.filterMarkParagraph,
      filterIncludeUids = _this$filterOption.filterIncludeUids,
      filterTags = _this$filterOption.filterTags,
      _this$filterOption$fi = _this$filterOption.filterUnfix,
      filterUnfix = _this$filterOption$fi === void 0 ? true : _this$filterOption$fi;
    if (filterUnfix === false && paragraph.isUnfix) {
      return true;
    }
    if (filterMarkParagraph && !this.controller.isHasParagraphMarkColor(pid)) {
      return false;
    }
    if (filterIncludeUids) {
      if (filterIncludeUids.length === 0) {
        return false;
      }
      if (!filterIncludeUids.includes(paragraph.uid)) {
        return false;
      }
    }
    if (filterTags && filterTags.length > 0) {
      var length = filterTags.length;
      var isFound = false;
      var _loop = function _loop(i) {
        var tag = filterTags[i];
        var found = words.find(function (word) {
          return word.tag === tag;
        });
        if (found) {
          isFound = true;
          return "continue";
        }
      };
      for (var i = 0; i < length; i++) {
        var _ret = _loop(i);
        if (_ret === "continue") continue;
      }
      if (!isFound) {
        return false;
      }
    }
    return true;
  };
  _proto.reset = function reset() {
    this.setFilterOption({});
  };
  return ParagraphFilterController;
}(AbstractCmdController);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/unfixToFixedController.js


var UnfixToFixedController = /*#__PURE__*/function (_AbstractCmdControlle) {
  _inheritsLoose(UnfixToFixedController, _AbstractCmdControlle);
  function UnfixToFixedController() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _AbstractCmdControlle.call.apply(_AbstractCmdControlle, [this].concat(args)) || this;
    _this.unfixToFixedPid = void 0;
    _this.unfixToFixedKeepFocusPid = void 0;
    _this.lastUnfixPid = void 0;
    _this.lastUnfixIsFocus = false;
    _this.firstUnfixPid = void 0;
    return _this;
  }
  var _proto = UnfixToFixedController.prototype;
  _proto.setLastUnfixPid = function setLastUnfixPid(lastUnfixPid) {
    if (!this.firstUnfixPid) {
      this.firstUnfixPid = lastUnfixPid;
    }
    if (this.lastUnfixPid) {
      if (this.lastUnfixIsFocus) {
        this.unfixToFixedKeepFocusPid = this.lastUnfixPid;
      }
      this.unfixToFixedPid = this.lastUnfixPid;
    }
    this.lastUnfixPid = lastUnfixPid;
    this.lastUnfixIsFocus = false;
  };
  _proto.getLastUnfixPid = function getLastUnfixPid() {
    return this.lastUnfixPid;
  };
  _proto.getUnfixToFixedPid = function getUnfixToFixedPid() {
    return this.unfixToFixedPid;
  };
  _proto.setLastUnfixIsFocus = function setLastUnfixIsFocus(isFocus) {
    this.lastUnfixIsFocus = isFocus;
  };
  _proto.clearFocus = function clearFocus() {
    this.lastUnfixIsFocus = false;
    this.unfixToFixedKeepFocusPid = undefined;
  };
  _proto.getUnfixToFixedKeepFocusPid = function getUnfixToFixedKeepFocusPid() {
    return this.unfixToFixedKeepFocusPid;
  };
  _proto.getFirstUnfixPid = function getFirstUnfixPid() {
    return this.firstUnfixPid;
  };
  _proto.isFirstUnfixPid = function isFirstUnfixPid(pid) {
    var unfixPid = this.controller.getUnfixPid();
    if (unfixPid && unfixPid !== this.firstUnfixPid) {
      return false;
    }
    return this.firstUnfixPid === pid;
  };
  _proto.reset = function reset() {
    this.unfixToFixedPid = undefined;
    this.lastUnfixPid = undefined;
    this.firstUnfixPid = undefined;
    this.unfixToFixedKeepFocusPid = undefined;
    this.lastUnfixIsFocus = false;
  };
  return UnfixToFixedController;
}(AbstractCmdController);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseClamp.js
/**
 * The base implementation of `_.clamp` which doesn't coerce arguments.
 *
 * @private
 * @param {number} number The number to clamp.
 * @param {number} [lower] The lower bound.
 * @param {number} upper The upper bound.
 * @returns {number} Returns the clamped number.
 */
function baseClamp(number, lower, upper) {
  if (number === number) {
    if (upper !== undefined) {
      number = number <= upper ? number : upper;
    }
    if (lower !== undefined) {
      number = number >= lower ? number : lower;
    }
  }
  return number;
}
/* harmony default export */ var _baseClamp = (baseClamp);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_arrayMap.js
/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
    length = array == null ? 0 : array.length,
    result = Array(length);
  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}
/* harmony default export */ var _arrayMap = (arrayMap);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isArray.js
/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isArray = (isArray);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isObjectLike.js
/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isObjectLike = (isObjectLike);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isSymbol.js



/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' || _lodash_es_4_17_21_lodash_es_isObjectLike(value) && _baseGetTag(value) == symbolTag;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isSymbol = (isSymbol);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseToString.js





/** Used as references for various `Number` constants. */
var _baseToString_INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = _Symbol ? _Symbol.prototype : undefined,
  symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (_lodash_es_4_17_21_lodash_es_isArray(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return _arrayMap(value, baseToString) + '';
  }
  if (_lodash_es_4_17_21_lodash_es_isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = value + '';
  return result == '0' && 1 / value == -_baseToString_INFINITY ? '-0' : result;
}
/* harmony default export */ var _baseToString = (baseToString);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_trimmedEndIndex.js
/** Used to match a single whitespace character. */
var reWhitespace = /\s/;

/**
 * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
 * character of `string`.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {number} Returns the index of the last non-whitespace character.
 */
function trimmedEndIndex(string) {
  var index = string.length;
  while (index-- && reWhitespace.test(string.charAt(index))) {}
  return index;
}
/* harmony default export */ var _trimmedEndIndex = (trimmedEndIndex);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseTrim.js


/** Used to match leading whitespace. */
var reTrimStart = /^\s+/;

/**
 * The base implementation of `_.trim`.
 *
 * @private
 * @param {string} string The string to trim.
 * @returns {string} Returns the trimmed string.
 */
function baseTrim(string) {
  return string ? string.slice(0, _trimmedEndIndex(string) + 1).replace(reTrimStart, '') : string;
}
/* harmony default export */ var _baseTrim = (baseTrim);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/toNumber.js




/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (_lodash_es_4_17_21_lodash_es_isSymbol(value)) {
    return NAN;
  }
  if (_lodash_es_4_17_21_lodash_es_isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = _lodash_es_4_17_21_lodash_es_isObject(other) ? other + '' : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = _baseTrim(value);
  var isBinary = reIsBinary.test(value);
  return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_toNumber = (toNumber);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/toFinite.js


/** Used as references for various `Number` constants. */
var toFinite_INFINITY = 1 / 0,
  MAX_INTEGER = 1.7976931348623157e+308;

/**
 * Converts `value` to a finite number.
 *
 * @static
 * @memberOf _
 * @since 4.12.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted number.
 * @example
 *
 * _.toFinite(3.2);
 * // => 3.2
 *
 * _.toFinite(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toFinite(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toFinite('3.2');
 * // => 3.2
 */
function toFinite(value) {
  if (!value) {
    return value === 0 ? value : 0;
  }
  value = _lodash_es_4_17_21_lodash_es_toNumber(value);
  if (value === toFinite_INFINITY || value === -toFinite_INFINITY) {
    var sign = value < 0 ? -1 : 1;
    return sign * MAX_INTEGER;
  }
  return value === value ? value : 0;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_toFinite = (toFinite);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/toInteger.js


/**
 * Converts `value` to an integer.
 *
 * **Note:** This method is loosely based on
 * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted integer.
 * @example
 *
 * _.toInteger(3.2);
 * // => 3
 *
 * _.toInteger(Number.MIN_VALUE);
 * // => 0
 *
 * _.toInteger(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toInteger('3.2');
 * // => 3
 */
function toInteger(value) {
  var result = _lodash_es_4_17_21_lodash_es_toFinite(value),
    remainder = result % 1;
  return result === result ? remainder ? result - remainder : result : 0;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_toInteger = (toInteger);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/toString.js


/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString_toString(value) {
  return value == null ? '' : _baseToString(value);
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_toString = (toString_toString);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/startsWith.js





/**
 * Checks if `string` starts with the given target string.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to inspect.
 * @param {string} [target] The string to search for.
 * @param {number} [position=0] The position to search from.
 * @returns {boolean} Returns `true` if `string` starts with `target`,
 *  else `false`.
 * @example
 *
 * _.startsWith('abc', 'a');
 * // => true
 *
 * _.startsWith('abc', 'b');
 * // => false
 *
 * _.startsWith('abc', 'b', 1);
 * // => true
 */
function startsWith(string, target, position) {
  string = _lodash_es_4_17_21_lodash_es_toString(string);
  position = position == null ? 0 : _baseClamp(_lodash_es_4_17_21_lodash_es_toInteger(position), 0, string.length);
  target = _baseToString(target);
  return string.slice(position, position + target.length) == target;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_startsWith = (startsWith);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/utils/speaker.js

var getSpeaker = function getSpeaker(uid, speakers) {
  var found = speakers.find(function (speaker) {
    return speaker.uid === uid;
  });
  return found;
};
var defaultSpeakerName = '发言人';
var firstSpeaker = {
  uid: '1',
  name: ''
};
var getSpeakerName = function getSpeakerName(speaker, getDefaultName) {
  return speaker && speaker.name || getDefaultName(speaker);
};
var UID_START_WORD = 'c';
var isUserGeneratedSpeaker = function isUserGeneratedSpeaker(speaker) {
  return _lodash_es_4_17_21_lodash_es_startsWith(speaker.uid, UID_START_WORD);
};
var isAlibabaEmployeeSpeaker = function isAlibabaEmployeeSpeaker(speaker) {
  return Boolean(speaker.bizUid);
};
var getNextGeneratedUid = function getNextGeneratedUid(speakers) {
  var id = 0;
  speakers.filter(function (speaker) {
    return isUserGeneratedSpeaker(speaker);
  }).forEach(function (speaker) {
    var match = speaker.uid.match(/\d+$/);
    if (match) {
      var parsedId = parseInt(match[0], 10);
      if (parsedId > id) {
        id = parsedId;
      }
    }
  });
  return ++id;
};
var generateSpeakerUid = function generateSpeakerUid(speakers) {
  var id = getNextGeneratedUid(speakers);
  return "" + UID_START_WORD + id;
};
var getDisplayAlibabaEmployeeName = function getDisplayAlibabaEmployeeName(employee) {
  return "" + employee.name + (employee.nickName ? "(" + employee.nickName + ")" : '');
};
var findSpeakerPosByBizUid = function findSpeakerPosByBizUid(speakers, bizUid) {
  var length = speakers.length;
  for (var i = 0; i < length; i++) {
    var _speaker = speakers[i];
    if (_speaker.bizUid === bizUid) {
      return i;
    }
  }
  return -1;
};
var findSpeakerByBizUid = function findSpeakerByBizUid(speakers, bizUid) {
  return speakers[findSpeakerPosByBizUid(speakers, bizUid)];
};
var findSpeakerPosByUid = function findSpeakerPosByUid(speakers, uid) {
  var length = speakers.length;
  for (var i = 0; i < length; i++) {
    var _speaker2 = speakers[i];
    if (_speaker2.uid === uid) {
      return i;
    }
  }
  return -1;
};
var findSpeakerByUid = function findSpeakerByUid(speakers, uid) {
  return speakers[findSpeakerPosByUid(speakers, uid)];
};
var findNotAlibabaSpeakerPosByName = function findNotAlibabaSpeakerPosByName(speakers, name, getDefaultSpeakerName) {
  var length = speakers.length;
  for (var i = 0; i < length; i++) {
    var _speaker3 = speakers[i];
    var speakerName = _speaker3.name || getDefaultSpeakerName(_speaker3);
    var isAlibaba = isAlibabaEmployeeSpeaker(_speaker3);
    if (!isAlibaba && speakerName === name) {
      return i;
    }
  }
  return -1;
};
var findNotAlibabaSpeakerByName = function findNotAlibabaSpeakerByName(speakers, name, getDefaultSpeakerName) {
  return speakers[findNotAlibabaSpeakerPosByName(speakers, name, getDefaultSpeakerName)];
};
var getBeforeChangeSpeakers = function getBeforeChangeSpeakers(controller, currentSpeakers, targetPids, newUid) {
  var otherParagraphs = controller.getParagraphs().filter(function (paragraph) {
    return targetPids.indexOf(paragraph.pid) === -1;
  });
  var uids = otherParagraphs.map(function (paragraph) {
    return paragraph.uid;
  });
  var tempUid = controller.getEmptyUnfixTempUid();
  if (tempUid) {
    uids.push(tempUid);
  }
  if (newUid) {
    uids.push(newUid);
  }
  var newSpeakers = [];
  currentSpeakers.forEach(function (speaker) {
    if (uids.includes(speaker.uid)) {
      newSpeakers.push(speaker);
    }
  });
  return newSpeakers;
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/speakerController.js



var MAX_SPEAKER = 50;
var SpeakerController = /*#__PURE__*/function (_AbstractCmdControlle) {
  _inheritsLoose(SpeakerController, _AbstractCmdControlle);
  function SpeakerController(controller) {
    var _this;
    _this = _AbstractCmdControlle.call(this, controller) || this;
    _this.speakersGetter = void 0;
    _this.speakersSetter = void 0;
    _this.defaultSpeakerNameGetter = function () {
      return '发言人';
    };
    _this.tempRemovedSpeakers = {};
    _this.commonUseSpeakersGetter = void 0;
    _this.commonUseSpeakersSetter = void 0;
    _this.maxSpeaker = MAX_SPEAKER;
    _this.getCommonUseSpeakers = function () {
      if (!_this.commonUseSpeakersGetter) {
        throw new Error('You need implement `commonUseSpeakersGetter`, ' + 'please use `controller.injectCommonUseSpeakersGetter` to implement it.');
      }
      return _this.commonUseSpeakersGetter() || [];
    };
    _this.setCommonUseSpeakers = function (speakers) {
      if (!_this.commonUseSpeakersSetter) {
        throw new Error('You need implement `commonUseSpeakersSetter`, ' + 'please use `controller.injectCommonUseSpeakersSetter` to implement it.');
      }
      return _this.commonUseSpeakersSetter(speakers);
    };
    _this.getSpeakers = function () {
      if (!_this.speakersGetter) {
        throw new Error('You need implement `speakersGetter`, ' + 'please use `controller.injectSpeakersGetter` to implement it.');
      }
      return _this.speakersGetter() || [];
    };
    _this.setSpeakers = function (speakers) {
      if (!_this.speakersSetter) {
        throw new Error('You need implement `speakersSetter`, ' + 'please use `controller.injectSpeakersSetter` to implement it.');
      }
      return _this.speakersSetter(speakers);
    };
    _this.getDefaultSpeakerName = function (speaker) {
      return _this.defaultSpeakerNameGetter(speaker);
    };
    _this.listenEvents();
    return _this;
  }
  var _proto = SpeakerController.prototype;
  _proto.injectSpeakersGetter = function injectSpeakersGetter(speakersGetter) {
    this.speakersGetter = speakersGetter;
  };
  _proto.injectSpeakersSetter = function injectSpeakersSetter(speakersSetter) {
    this.speakersSetter = speakersSetter;
  };
  _proto.injectCommonUseSpeakersGetter = function injectCommonUseSpeakersGetter(commonUseSpeakersGetter) {
    this.commonUseSpeakersGetter = commonUseSpeakersGetter;
  };
  _proto.injectCommonUseSpeakersSetter = function injectCommonUseSpeakersSetter(commonUseSpeakersSetter) {
    this.commonUseSpeakersSetter = commonUseSpeakersSetter;
  };
  _proto.injectDefaultSpeakerNameGetter = function injectDefaultSpeakerNameGetter(defaultSpeakerNameGetter) {
    this.defaultSpeakerNameGetter = defaultSpeakerNameGetter;
  };
  _proto.listenEvents = function listenEvents() {
    var _this2 = this;
    this.controller.on('emptyUnfixParagraphShowUp', function () {
      var speakers = _this2.getSpeakers() || [];
      var found = speakers.find(function (speaker) {
        return speaker.uid === firstSpeaker.uid;
      });
      if (!found) {
        _this2.setSpeakers(speakers.concat(firstSpeaker));
        _this2.controller.setEmptyUnfixTempUid(firstSpeaker.uid);
      }
    });
    this.controller.on('paragraphChange', function (_ref) {
      var pid = _ref.pid;
      var paragraph = _this2.controller.getParagraph(pid);
      if (paragraph.isUnfix) {
        return;
      }
      var speakers = _this2.getSpeakers() || [];
      var found = speakers.find(function (speaker) {
        return speaker.uid === paragraph.uid;
      });
      if (!found) {
        var addedSpeaker = {
          uid: paragraph.uid,
          name: getSpeakerName(undefined, function () {
            return '';
          })
        };
        _this2.setSpeakers(speakers.concat(addedSpeaker));
      }
    });
    this.controller.on('bookParagraphChangeSpecific', function (_ref2) {
      var removeParagraphPids = _ref2.removeParagraphPids,
        removeParagraphs = _ref2.removeParagraphs,
        addParagraphPids = _ref2.addParagraphPids;
      var speakers = _this2.getSpeakers();
      if (removeParagraphPids.length > 0) {
        Object.keys(removeParagraphs || {}).forEach(function (pid) {
          var paragraph = removeParagraphs[pid];
          var uid = paragraph.uid;
          var speaker = findSpeakerByUid(speakers, uid);
          if (speaker) {
            _this2.tempRemovedSpeakers[uid] = speaker;
          }
        });
        var newSpeakers = getBeforeChangeSpeakers(_this2.controller, speakers, []);
        _this2.setSpeakers(newSpeakers);
      } else if (addParagraphPids.length > 0) {
        addParagraphPids.forEach(function (pid) {
          var paragraph = _this2.controller.getParagraph(pid);
          var uid = paragraph.uid;
          var speaker = findSpeakerByUid(speakers, uid);
          if (_this2.tempRemovedSpeakers[uid]) {
            if (!speaker) {
              var _newSpeakers = speakers.concat(_this2.tempRemovedSpeakers[uid]);
              _this2.setSpeakers(_newSpeakers);
              _this2.controller.emit('speakerNameChange', {
                uid: uid
              });
            }
            delete _this2.tempRemovedSpeakers[uid];
          }
        });
      }
    });
  };

  // 常用发言人列表更新
  _proto.updateCommonUseSpeakersList = function updateCommonUseSpeakersList(speakers) {
    // const speakers = this.getCommonUseSpeakers();
    this.setCommonUseSpeakers(speakers);
  };
  _proto.setMaxSpeaker = function setMaxSpeaker(maxSpeaker) {
    if (maxSpeaker === void 0) {
      maxSpeaker = MAX_SPEAKER;
    }
    this.maxSpeaker = maxSpeaker;
  };
  _proto.getMaxSpeaker = function getMaxSpeaker() {
    return Math.max(this.getSpeakers().length, this.maxSpeaker);
  };
  _proto.isVaildSpeakers = function isVaildSpeakers(speakers) {
    if (speakers.length > this.getMaxSpeaker()) {
      this.controller.emit('detectSpeakerFull', {});
      return false;
    }
    return true;
  };
  _proto.updateOneByAlibabaEmployeeOnEmptyUnfix = function updateOneByAlibabaEmployeeOnEmptyUnfix(alibabaEmployee) {
    var speakers = this.getSpeakers();
    var speaker = findSpeakerByBizUid(speakers, alibabaEmployee.bizUid);
    var tempUid = this.controller.getEmptyUnfixTempUid();
    if (speaker) {
      if (tempUid !== speaker.uid) {
        this.controller.setEmptyUnfixTempUid(speaker.uid);
        var newSpeakers = getBeforeChangeSpeakers(this.controller, speakers, [], speaker.uid);
        if (this.isVaildSpeakers(newSpeakers)) {
          this.setSpeakers(newSpeakers);
          this.controller.setEmptyUnfixTempUid(speaker.uid);
        }
      }
    } else {
      var uid = generateSpeakerUid(speakers);
      var addedSpeaker = {
        uid: uid,
        name: getDisplayAlibabaEmployeeName(alibabaEmployee),
        avatarUrl: alibabaEmployee.avatarUrl,
        bizUid: alibabaEmployee.bizUid
      };
      var _newSpeakers2 = getBeforeChangeSpeakers(this.controller, speakers, [], uid).concat(addedSpeaker);
      if (this.isVaildSpeakers(_newSpeakers2)) {
        this.setSpeakers(_newSpeakers2);
        this.controller.setEmptyUnfixTempUid(uid);
      }
    }
  };
  _proto.updateOneByHistorySpeakerOnEmptyUnfix = function updateOneByHistorySpeakerOnEmptyUnfix(speaker) {
    var tempUid = this.controller.getEmptyUnfixTempUid();
    var speakers = this.getSpeakers();
    if (tempUid !== speaker.uid) {
      this.controller.setEmptyUnfixTempUid(speaker.uid);
      var newSpeakers = getBeforeChangeSpeakers(this.controller, speakers, [], speaker.uid);
      if (this.isVaildSpeakers(newSpeakers)) {
        this.setSpeakers(newSpeakers);
      }
    }
  };
  _proto.updateOneByInputTextOnEmptyUnfix = function updateOneByInputTextOnEmptyUnfix(oldInputText, inputText) {
    if (oldInputText === inputText || !inputText) {
      return;
    }
    var tempUid = this.controller.getEmptyUnfixTempUid();
    var speakers = this.getSpeakers();
    var speaker = tempUid ? findSpeakerByUid(speakers, tempUid) : undefined;
    var sameNameSpeaker = findNotAlibabaSpeakerByName(speakers, inputText, this.getDefaultSpeakerName);
    if (sameNameSpeaker && sameNameSpeaker.uid !== tempUid) {
      var newSpeakers = getBeforeChangeSpeakers(this.controller, speakers, [], sameNameSpeaker.uid);
      if (this.isVaildSpeakers(newSpeakers)) {
        this.setSpeakers(newSpeakers);
        this.controller.setEmptyUnfixTempUid(sameNameSpeaker.uid);
      }
    } else if (!speaker || speaker.name !== inputText) {
      var uid = generateSpeakerUid(speakers);
      var addedSpeaker = {
        uid: uid,
        name: inputText
      };
      var _newSpeakers3 = getBeforeChangeSpeakers(this.controller, speakers, [], uid).concat(addedSpeaker);
      if (this.isVaildSpeakers(_newSpeakers3)) {
        this.controller.setEmptyUnfixTempUid(uid);
        this.setSpeakers(_newSpeakers3);
      }
    }
  };
  _proto.updateOneByAlibabaEmployee = function updateOneByAlibabaEmployee(pid, alibabaEmployee) {
    var paragraph = this.controller.getParagraph(pid);
    var speakers = this.getSpeakers();
    var speaker = findSpeakerByBizUid(speakers, alibabaEmployee.bizUid);
    if (speaker) {
      if (paragraph.uid !== speaker.uid) {
        var newSpeakers = getBeforeChangeSpeakers(this.controller, speakers, [paragraph.pid], speaker.uid);
        if (this.isVaildSpeakers(newSpeakers)) {
          this.setSpeakers(newSpeakers);
          this.controller.updateUserByPid(pid, speaker.uid);
          this.controller.emit('speakerNameChange', {
            uid: speaker.uid
          });
        }
      }
    } else {
      var uid = generateSpeakerUid(speakers);
      var addedSpeaker = {
        uid: uid,
        name: getDisplayAlibabaEmployeeName(alibabaEmployee),
        avatarUrl: alibabaEmployee.avatarUrl,
        bizUid: alibabaEmployee.bizUid
      };
      var _newSpeakers4 = getBeforeChangeSpeakers(this.controller, speakers, [paragraph.pid], uid).concat(addedSpeaker);
      if (this.isVaildSpeakers(_newSpeakers4)) {
        this.setSpeakers(_newSpeakers4);
        this.controller.updateUserByPid(pid, uid);
      }
    }
  };
  _proto.updateOneByHistorySpeaker = function updateOneByHistorySpeaker(pid, speaker) {
    var paragraph = this.controller.getParagraph(pid);
    var speakers = this.getSpeakers();
    if (paragraph.uid !== speaker.uid) {
      this.controller.updateUserByPid(pid, speaker.uid);
      var newSpeakers = getBeforeChangeSpeakers(this.controller, speakers, [paragraph.pid], speaker.uid);
      if (this.isVaildSpeakers(newSpeakers)) {
        this.setSpeakers(newSpeakers);
        this.controller.emit('speakerNameChange', {
          uid: speaker.uid
        });
      }
    }
  };
  _proto.updateOneByInputText = function updateOneByInputText(pid, oldInputText, inputText) {
    if (oldInputText === inputText || !inputText) {
      return;
    }
    var paragraph = this.controller.getParagraph(pid);
    var speakers = this.getSpeakers();
    var speaker = findSpeakerByUid(speakers, paragraph.uid);
    var sameNameSpeaker = findNotAlibabaSpeakerByName(speakers, inputText, this.getDefaultSpeakerName);
    if (sameNameSpeaker && sameNameSpeaker.uid !== paragraph.uid) {
      var newSpeakers = getBeforeChangeSpeakers(this.controller, speakers, [paragraph.pid], sameNameSpeaker.uid);
      if (this.isVaildSpeakers(newSpeakers)) {
        this.setSpeakers(newSpeakers);
        this.controller.updateUserByPid(pid, sameNameSpeaker.uid);
      }
    } else if (!speaker || speaker.name !== inputText) {
      var uid = generateSpeakerUid(speakers);
      var addedSpeaker = {
        uid: uid,
        name: inputText
      };
      var _newSpeakers5 = getBeforeChangeSpeakers(this.controller, speakers, [paragraph.pid], uid).concat(addedSpeaker);
      if (this.isVaildSpeakers(_newSpeakers5)) {
        this.setSpeakers(_newSpeakers5);
        this.controller.updateUserByPid(pid, uid);
      }
    }
  };
  _proto.updateManyByAlibabaEmployee = function updateManyByAlibabaEmployee(currentPid, alibabaEmployee) {
    var paragraph = this.controller.getParagraph(currentPid);
    var speakers = this.getSpeakers();
    var pids = this.controller.getParagraphsByUid(paragraph.uid).map(function (p) {
      return p.pid;
    });
    var speaker = findSpeakerByBizUid(speakers, alibabaEmployee.bizUid);
    if (speaker) {
      var uid = speaker.uid;
      var updatedSpeaker = {
        uid: uid,
        name: getDisplayAlibabaEmployeeName(alibabaEmployee),
        avatarUrl: alibabaEmployee.avatarUrl,
        bizUid: alibabaEmployee.bizUid
      };
      var newSpeakers = getBeforeChangeSpeakers(this.controller, speakers, pids, uid);
      var pos = findSpeakerPosByBizUid(newSpeakers, alibabaEmployee.bizUid);
      newSpeakers[pos] = updatedSpeaker;
      if (this.isVaildSpeakers(newSpeakers)) {
        this.setSpeakers(newSpeakers);
        this.controller.updateAllUsers(pids, uid);
      }
    } else {
      var _uid = generateSpeakerUid(speakers);
      var addedSpeaker = {
        uid: _uid,
        name: getDisplayAlibabaEmployeeName(alibabaEmployee),
        avatarUrl: alibabaEmployee.avatarUrl,
        bizUid: alibabaEmployee.bizUid
      };
      var _newSpeakers6 = getBeforeChangeSpeakers(this.controller, speakers, pids, _uid).concat(addedSpeaker);
      if (this.isVaildSpeakers(_newSpeakers6)) {
        this.setSpeakers(_newSpeakers6);
        this.controller.updateAllUsers(pids, _uid);
      }
    }
  };
  _proto.updateManyByHistorySpeaker = function updateManyByHistorySpeaker(currentPid, speaker) {
    var speakers = this.getSpeakers();
    var paragraph = this.controller.getParagraph(currentPid);
    var pids = this.controller.getParagraphsByUid(paragraph.uid).map(function (p) {
      return p.pid;
    });
    var newSpeakers = getBeforeChangeSpeakers(this.controller, speakers, pids, speaker.uid);
    if (this.isVaildSpeakers(newSpeakers)) {
      this.setSpeakers(newSpeakers);
      this.controller.updateAllUsers(pids, speaker.uid);
    }
  };
  _proto.updateManyByInputText = function updateManyByInputText(currentPid, oldInputText, inputText) {
    if (oldInputText === inputText || !inputText) {
      return;
    }
    var speakers = this.getSpeakers();
    var paragraph = this.controller.getParagraph(currentPid);
    var pids = this.controller.getParagraphsByUid(paragraph.uid).map(function (p) {
      return p.pid;
    });
    var speaker = findSpeakerByUid(speakers, paragraph.uid);
    var sameNameSpeaker = findNotAlibabaSpeakerByName(speakers, inputText, this.getDefaultSpeakerName);
    if (sameNameSpeaker) {
      var newSpeakers = getBeforeChangeSpeakers(this.controller, speakers, pids, sameNameSpeaker.uid);
      if (this.isVaildSpeakers(newSpeakers)) {
        this.setSpeakers(newSpeakers);
        this.controller.updateAllUsers(pids, sameNameSpeaker.uid);
      }
    } else if (speaker) {
      if (speaker.name === inputText) {
        var _newSpeakers7 = getBeforeChangeSpeakers(this.controller, speakers, pids, speaker.uid);
        if (this.isVaildSpeakers(_newSpeakers7)) {
          this.setSpeakers(_newSpeakers7);
          this.controller.updateAllUsers(pids, speaker.uid);
        }
      } else {
        var uid = generateSpeakerUid(speakers);
        var newSpeaker = {
          uid: uid,
          name: inputText
        };
        var _newSpeakers8 = getBeforeChangeSpeakers(this.controller, speakers, pids, uid).concat(newSpeaker);
        if (this.isVaildSpeakers(_newSpeakers8)) {
          this.setSpeakers(_newSpeakers8);
          this.controller.updateAllUsers(pids, uid);
        }
      }
    } else {
      var _uid2 = generateSpeakerUid(speakers);
      var addedSpeaker = {
        uid: _uid2,
        name: inputText
      };
      var _newSpeakers9 = getBeforeChangeSpeakers(this.controller, speakers, pids, _uid2).concat(addedSpeaker);
      if (this.isVaildSpeakers(_newSpeakers9)) {
        this.setSpeakers(_newSpeakers9);
        this.controller.updateAllUsers(pids, _uid2);
      }
    }
  };
  _proto.renderSpeakerName = function renderSpeakerName(uid) {
    if (uid) {
      var _speakers = this.getSpeakers() || [];
      var _speaker = getSpeaker(uid, _speakers);
      var _name = getSpeakerName(_speaker, this.getDefaultSpeakerName);
      return _name;
    } else {
      return getSpeakerName(undefined, this.getDefaultSpeakerName);
    }
  };
  return SpeakerController;
}(AbstractCmdController);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-common@0.3.9@@ali/tingwu-common/dist-web/range.js
var isIntersectRanges = function isIntersectRanges(range1, range2) {
  // 计算两个区间[a,b] [c,d]是否有重叠, 通过判断min(b,d) > max(a,c)来判断是否重叠
  return Math.min(range1.end, range2.end) > Math.max(range1.start, range2.start);
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/reader/book.js

var book_Book = /*#__PURE__*/function () {
  function Book(model) {
    this.model = void 0;
    this.cachedWords = {};
    this.model = model;
  }
  var _proto = Book.prototype;
  _proto.getPids = function getPids() {
    return this.model.book.transcription.pids;
  } // There is no cached support.
  ;

  _proto.getParagraphs = function getParagraphs() {
    var _this = this;
    return this.getPids().map(function (pid) {
      return _this.getParagraph(pid);
    });
  };
  _proto.getParagraph = function getParagraph(pid) {
    return this.model.book.transcription.paragraphs[pid];
  };
  _proto.getParagraphByWid = function getParagraphByWid(wid) {
    var paragraphs = this.getParagraphs();
    var length = paragraphs.length;
    for (var i = 0; i < length; i++) {
      var paragraph = paragraphs[i];
      if (paragraph.wids.indexOf(wid) > -1) {
        return paragraph;
      }
    }
    return undefined;
  };
  _proto.getParagraphBySid = function getParagraphBySid(sid) {
    var paragraphs = this.getParagraphs();
    var length = paragraphs.length;
    for (var i = 0; i < length; i++) {
      var paragraph = paragraphs[i];
      var words = this.getWords(paragraph.pid);
      var wordLength = words.length;
      for (var j = 0; j < wordLength; j++) {
        var word = words[j];
        if (word.sentenceId === sid) {
          return paragraph;
        }
      }
    }
    return undefined;
  };
  _proto.getCurrentWords = function getCurrentWords(pid) {
    var _this$model$book$tran = this.model.book.transcription,
      paragraphs = _this$model$book$tran.paragraphs,
      allWords = _this$model$book$tran.words;
    if (!paragraphs[pid]) {
      return [];
    }
    var words = [];
    paragraphs[pid].wids.forEach(function (wid) {
      var word = allWords[wid];
      if (word) {
        words.push(word);
      }
    });
    return words;
  };
  _proto.getWords = function getWords(pid) {
    var cache = this.cachedWords[pid];
    var version = this.model.book.paragraphVersions[pid];
    if (!cache || cache.version !== version) {
      var words = this.getCurrentWords(pid);
      if (words.length === 0) {
        // `modelValue` was not ready, dont goto cache.
        return [];
      }
      this.cachedWords[pid] = {
        words: words,
        version: version
      };
    }
    return this.cachedWords[pid].words;
  };
  _proto.getWordsByWids = function getWordsByWids(wids) {
    var _this2 = this;
    var words = [];
    wids.forEach(function (wid) {
      var word = _this2.model.book.transcription.words[wid];
      if (word) {
        words.push(word);
      }
    });
    return words;
  };
  _proto.getWord = function getWord(wid) {
    return this.model.book.transcription.words[wid];
  };
  _proto.getTextContent = function getTextContent(pid) {
    return this.getWords(pid).map(function (w) {
      return w.text;
    }).join('');
  };
  _proto.getTextContentWithoutNfixing = function getTextContentWithoutNfixing(pid) {
    return this.getWords(pid).filter(function (w) {
      return !w.nFix;
    }).map(function (w) {
      return w.text;
    }).join('');
  };
  _proto.getWordByOffset = function getWordByOffset(pid, offset) {
    var words = this.getWords(pid);
    var foundWord;
    var pos = 0;
    words.some(function (word) {
      pos += word.text.length;
      if (pos > offset) {
        foundWord = word;
        return true;
      }
      return false;
    });
    return foundWord;
  };
  _proto.getAllTextContent = function getAllTextContent() {
    var _this3 = this;
    return this.getPids().map(function (pid) {
      return _this3.getTextContent(pid);
    });
  };
  _proto.getSentencesBySids = function getSentencesBySids(sids) {
    var _this4 = this;
    var pids = this.getPids();
    var sentences = {};
    pids.forEach(function (pid) {
      var words = _this4.getWords(pid);
      words.forEach(function (word) {
        if (sids.indexOf(word.sentenceId) > -1) {
          if (!sentences[word.sentenceId]) {
            sentences[word.sentenceId] = {
              sid: word.sentenceId,
              wids: [word.wid]
            };
          } else {
            sentences[word.sentenceId].wids.push(word.wid);
          }
        }
      });
    });
    return sentences;
  };
  _proto.getFirstWordBySid = function getFirstWordBySid(sid) {
    var sentenceMap = this.getSentencesBySids([sid]);
    var sentence = sentenceMap[sid];
    if (!sentence) {
      return undefined;
    }
    var wids = sentence.wids;
    return this.getWord(wids[0]);
  };
  _proto.getParagraphByTimestampRange = function getParagraphByTimestampRange(range) {
    var _this5 = this;
    var paragraphs = this.getParagraphs();
    return paragraphs.filter(function (paragraph) {
      var words = _this5.getWords(paragraph.pid);
      if (words.length === 0) {
        return false;
      }
      var beginTime = words[0].beginTime;
      var endTime = words[words.length - 1].endTime;
      var paragraphRange = {
        start: beginTime,
        end: endTime
      };
      return isIntersectRanges(range, paragraphRange);
    });
  };
  _proto.isAppearedWid = function isAppearedWid(wid) {
    return this.model.book.isAppearedWid(wid);
  };
  _proto.isUserChangedSentence = function isUserChangedSentence(sid) {
    return this.model.book.isUserChangedSentence(sid);
  };
  _proto.getLatestSid = function getLatestSid() {
    var paragraphs = this.getParagraphs();
    for (var i = paragraphs.length - 1; i >= 0; i--) {
      var paragraph = paragraphs[i];
      if (paragraph.wids.length > 0) {
        var word = this.getWord(paragraph.wids[paragraph.wids.length - 1]);
        if (word) {
          return word.sentenceId;
        }
      }
    }
    return undefined;
  };
  return Book;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/reader/index.js

var createReader = function createReader(model) {
  return {
    book: new book_Book(model)
  };
};
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_stackClear.js


/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new _ListCache();
  this.size = 0;
}
/* harmony default export */ var _stackClear = (stackClear);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_stackDelete.js
/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
    result = data['delete'](key);
  this.size = data.size;
  return result;
}
/* harmony default export */ var _stackDelete = (stackDelete);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_stackGet.js
/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}
/* harmony default export */ var _stackGet = (stackGet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_stackHas.js
/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}
/* harmony default export */ var _stackHas = (stackHas);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_stackSet.js




/** Used as the size to enable large array optimizations. */
var _stackSet_LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof _ListCache) {
    var pairs = data.__data__;
    if (!_Map || pairs.length < _stackSet_LARGE_ARRAY_SIZE - 1) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new _MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}
/* harmony default export */ var _stackSet = (stackSet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_Stack.js







/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new _ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = _stackClear;
Stack.prototype['delete'] = _stackDelete;
Stack.prototype.get = _stackGet;
Stack.prototype.has = _stackHas;
Stack.prototype.set = _stackSet;
/* harmony default export */ var _Stack = (Stack);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_arrayEach.js
/**
 * A specialized version of `_.forEach` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns `array`.
 */
function arrayEach(array, iteratee) {
  var index = -1,
    length = array == null ? 0 : array.length;
  while (++index < length) {
    if (iteratee(array[index], index, array) === false) {
      break;
    }
  }
  return array;
}
/* harmony default export */ var _arrayEach = (arrayEach);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_defineProperty.js

var defineProperty = function () {
  try {
    var func = _getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}();
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_defineProperty = (defineProperty);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseAssignValue.js


/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && _lodash_es_4_17_21_lodash_es_defineProperty) {
    _lodash_es_4_17_21_lodash_es_defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}
/* harmony default export */ var _baseAssignValue = (baseAssignValue);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_assignValue.js



/** Used for built-in method references. */
var _assignValue_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _assignValue_hasOwnProperty = _assignValue_objectProto.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(_assignValue_hasOwnProperty.call(object, key) && _lodash_es_4_17_21_lodash_es_eq(objValue, value)) || value === undefined && !(key in object)) {
    _baseAssignValue(object, key, value);
  }
}
/* harmony default export */ var _assignValue = (assignValue);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_copyObject.js



/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});
  var index = -1,
    length = props.length;
  while (++index < length) {
    var key = props[index];
    var newValue = customizer ? customizer(object[key], source[key], key, object, source) : undefined;
    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      _baseAssignValue(object, key, newValue);
    } else {
      _assignValue(object, key, newValue);
    }
  }
  return object;
}
/* harmony default export */ var _copyObject = (copyObject);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseTimes.js
/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
    result = Array(n);
  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}
/* harmony default export */ var _baseTimes = (baseTimes);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseIsArguments.js



/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return _lodash_es_4_17_21_lodash_es_isObjectLike(value) && _baseGetTag(value) == argsTag;
}
/* harmony default export */ var _baseIsArguments = (baseIsArguments);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isArguments.js



/** Used for built-in method references. */
var isArguments_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var isArguments_hasOwnProperty = isArguments_objectProto.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = isArguments_objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = _baseIsArguments(function () {
  return arguments;
}()) ? _baseIsArguments : function (value) {
  return _lodash_es_4_17_21_lodash_es_isObjectLike(value) && isArguments_hasOwnProperty.call(value, 'callee') && !propertyIsEnumerable.call(value, 'callee');
};
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isArguments = (isArguments);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/stubFalse.js
/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_stubFalse = (stubFalse);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isBuffer.js



/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? _root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || _lodash_es_4_17_21_lodash_es_stubFalse;
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isBuffer = (isBuffer);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_isIndex.js
/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length && (type == 'number' || type != 'symbol' && reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
}
/* harmony default export */ var _isIndex = (isIndex);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isLength.js
/** Used as references for various `Number` constants. */
var isLength_MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= isLength_MAX_SAFE_INTEGER;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isLength = (isLength);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseIsTypedArray.js




/** `Object#toString` result references. */
var _baseIsTypedArray_argsTag = '[object Arguments]',
  arrayTag = '[object Array]',
  boolTag = '[object Boolean]',
  dateTag = '[object Date]',
  errorTag = '[object Error]',
  _baseIsTypedArray_funcTag = '[object Function]',
  mapTag = '[object Map]',
  numberTag = '[object Number]',
  objectTag = '[object Object]',
  regexpTag = '[object RegExp]',
  setTag = '[object Set]',
  stringTag = '[object String]',
  weakMapTag = '[object WeakMap]';
var arrayBufferTag = '[object ArrayBuffer]',
  dataViewTag = '[object DataView]',
  float32Tag = '[object Float32Array]',
  float64Tag = '[object Float64Array]',
  int8Tag = '[object Int8Array]',
  int16Tag = '[object Int16Array]',
  int32Tag = '[object Int32Array]',
  uint8Tag = '[object Uint8Array]',
  uint8ClampedTag = '[object Uint8ClampedArray]',
  uint16Tag = '[object Uint16Array]',
  uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
typedArrayTags[_baseIsTypedArray_argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[_baseIsTypedArray_funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return _lodash_es_4_17_21_lodash_es_isObjectLike(value) && _lodash_es_4_17_21_lodash_es_isLength(value.length) && !!typedArrayTags[_baseGetTag(value)];
}
/* harmony default export */ var _baseIsTypedArray = (baseIsTypedArray);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseUnary.js
/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function (value) {
    return func(value);
  };
}
/* harmony default export */ var _baseUnary = (baseUnary);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_nodeUtil.js


/** Detect free variable `exports`. */
var _nodeUtil_freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var _nodeUtil_freeModule = _nodeUtil_freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var _nodeUtil_moduleExports = _nodeUtil_freeModule && _nodeUtil_freeModule.exports === _nodeUtil_freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = _nodeUtil_moduleExports && _freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = function () {
  try {
    // Use `util.types` for Node.js 10+.
    var types = _nodeUtil_freeModule && _nodeUtil_freeModule.require && _nodeUtil_freeModule.require('util').types;
    if (types) {
      return types;
    }

    // Legacy `process.binding('util')` for Node.js < 10.
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}();
/* harmony default export */ var _nodeUtil = (nodeUtil);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isTypedArray.js




/* Node.js helper references. */
var nodeIsTypedArray = _nodeUtil && _nodeUtil.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? _baseUnary(nodeIsTypedArray) : _baseIsTypedArray;
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isTypedArray = (isTypedArray);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_arrayLikeKeys.js







/** Used for built-in method references. */
var _arrayLikeKeys_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _arrayLikeKeys_hasOwnProperty = _arrayLikeKeys_objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = _lodash_es_4_17_21_lodash_es_isArray(value),
    isArg = !isArr && _lodash_es_4_17_21_lodash_es_isArguments(value),
    isBuff = !isArr && !isArg && _lodash_es_4_17_21_lodash_es_isBuffer(value),
    isType = !isArr && !isArg && !isBuff && _lodash_es_4_17_21_lodash_es_isTypedArray(value),
    skipIndexes = isArr || isArg || isBuff || isType,
    result = skipIndexes ? _baseTimes(value.length, String) : [],
    length = result.length;
  for (var key in value) {
    if ((inherited || _arrayLikeKeys_hasOwnProperty.call(value, key)) && !(skipIndexes && (
    // Safari 9 has enumerable `arguments.length` in strict mode.
    key == 'length' ||
    // Node.js 0.10 has enumerable non-index properties on buffers.
    isBuff && (key == 'offset' || key == 'parent') ||
    // PhantomJS 2 has enumerable non-index properties on typed arrays.
    isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset') ||
    // Skip index properties.
    _isIndex(key, length)))) {
      result.push(key);
    }
  }
  return result;
}
/* harmony default export */ var _arrayLikeKeys = (arrayLikeKeys);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_isPrototype.js
/** Used for built-in method references. */
var _isPrototype_objectProto = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
    proto = typeof Ctor == 'function' && Ctor.prototype || _isPrototype_objectProto;
  return value === proto;
}
/* harmony default export */ var _isPrototype = (isPrototype);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_overArg.js
/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function (arg) {
    return func(transform(arg));
  };
}
/* harmony default export */ var _overArg = (overArg);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_nativeKeys.js


/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = _overArg(Object.keys, Object);
/* harmony default export */ var _nativeKeys = (nativeKeys);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseKeys.js



/** Used for built-in method references. */
var _baseKeys_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _baseKeys_hasOwnProperty = _baseKeys_objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!_isPrototype(object)) {
    return _nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (_baseKeys_hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}
/* harmony default export */ var _baseKeys = (baseKeys);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isArrayLike.js



/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && _lodash_es_4_17_21_lodash_es_isLength(value.length) && !_lodash_es_4_17_21_lodash_es_isFunction(value);
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isArrayLike = (isArrayLike);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/keys.js




/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return _lodash_es_4_17_21_lodash_es_isArrayLike(object) ? _arrayLikeKeys(object) : _baseKeys(object);
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_keys = (keys);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseAssign.js



/**
 * The base implementation of `_.assign` without support for multiple sources
 * or `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssign(object, source) {
  return object && _copyObject(source, _lodash_es_4_17_21_lodash_es_keys(source), object);
}
/* harmony default export */ var _baseAssign = (baseAssign);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_nativeKeysIn.js
/**
 * This function is like
 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * except that it includes inherited enumerable properties.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function nativeKeysIn(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}
/* harmony default export */ var _nativeKeysIn = (nativeKeysIn);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseKeysIn.js




/** Used for built-in method references. */
var _baseKeysIn_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _baseKeysIn_hasOwnProperty = _baseKeysIn_objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeysIn(object) {
  if (!_lodash_es_4_17_21_lodash_es_isObject(object)) {
    return _nativeKeysIn(object);
  }
  var isProto = _isPrototype(object),
    result = [];
  for (var key in object) {
    if (!(key == 'constructor' && (isProto || !_baseKeysIn_hasOwnProperty.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}
/* harmony default export */ var _baseKeysIn = (baseKeysIn);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/keysIn.js




/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  return _lodash_es_4_17_21_lodash_es_isArrayLike(object) ? _arrayLikeKeys(object, true) : _baseKeysIn(object);
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_keysIn = (keysIn);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseAssignIn.js



/**
 * The base implementation of `_.assignIn` without support for multiple sources
 * or `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssignIn(object, source) {
  return object && _copyObject(source, _lodash_es_4_17_21_lodash_es_keysIn(source), object);
}
/* harmony default export */ var _baseAssignIn = (baseAssignIn);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_cloneBuffer.js


/** Detect free variable `exports`. */
var _cloneBuffer_freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var _cloneBuffer_freeModule = _cloneBuffer_freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var _cloneBuffer_moduleExports = _cloneBuffer_freeModule && _cloneBuffer_freeModule.exports === _cloneBuffer_freeExports;

/** Built-in value references. */
var _cloneBuffer_Buffer = _cloneBuffer_moduleExports ? _root.Buffer : undefined,
  allocUnsafe = _cloneBuffer_Buffer ? _cloneBuffer_Buffer.allocUnsafe : undefined;

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length,
    result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
  buffer.copy(result);
  return result;
}
/* harmony default export */ var _cloneBuffer = (cloneBuffer);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_copyArray.js
/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
    length = source.length;
  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}
/* harmony default export */ var _copyArray = (copyArray);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_arrayFilter.js
/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
    length = array == null ? 0 : array.length,
    resIndex = 0,
    result = [];
  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}
/* harmony default export */ var _arrayFilter = (arrayFilter);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/stubArray.js
/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_stubArray = (stubArray);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getSymbols.js



/** Used for built-in method references. */
var _getSymbols_objectProto = Object.prototype;

/** Built-in value references. */
var _getSymbols_propertyIsEnumerable = _getSymbols_objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? _lodash_es_4_17_21_lodash_es_stubArray : function (object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return _arrayFilter(nativeGetSymbols(object), function (symbol) {
    return _getSymbols_propertyIsEnumerable.call(object, symbol);
  });
};
/* harmony default export */ var _getSymbols = (getSymbols);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_copySymbols.js



/**
 * Copies own symbols of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy symbols from.
 * @param {Object} [object={}] The object to copy symbols to.
 * @returns {Object} Returns `object`.
 */
function copySymbols(source, object) {
  return _copyObject(source, _getSymbols(source), object);
}
/* harmony default export */ var _copySymbols = (copySymbols);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_arrayPush.js
/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
    length = values.length,
    offset = array.length;
  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}
/* harmony default export */ var _arrayPush = (arrayPush);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getPrototype.js


/** Built-in value references. */
var getPrototype = _overArg(Object.getPrototypeOf, Object);
/* harmony default export */ var _getPrototype = (getPrototype);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getSymbolsIn.js





/* Built-in method references for those with the same name as other `lodash` methods. */
var _getSymbolsIn_nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own and inherited enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbolsIn = !_getSymbolsIn_nativeGetSymbols ? _lodash_es_4_17_21_lodash_es_stubArray : function (object) {
  var result = [];
  while (object) {
    _arrayPush(result, _getSymbols(object));
    object = _getPrototype(object);
  }
  return result;
};
/* harmony default export */ var _getSymbolsIn = (getSymbolsIn);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_copySymbolsIn.js



/**
 * Copies own and inherited symbols of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy symbols from.
 * @param {Object} [object={}] The object to copy symbols to.
 * @returns {Object} Returns `object`.
 */
function copySymbolsIn(source, object) {
  return _copyObject(source, _getSymbolsIn(source), object);
}
/* harmony default export */ var _copySymbolsIn = (copySymbolsIn);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseGetAllKeys.js



/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return _lodash_es_4_17_21_lodash_es_isArray(object) ? result : _arrayPush(result, symbolsFunc(object));
}
/* harmony default export */ var _baseGetAllKeys = (baseGetAllKeys);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getAllKeys.js




/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return _baseGetAllKeys(object, _lodash_es_4_17_21_lodash_es_keys, _getSymbols);
}
/* harmony default export */ var _getAllKeys = (getAllKeys);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getAllKeysIn.js




/**
 * Creates an array of own and inherited enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeysIn(object) {
  return _baseGetAllKeys(object, _lodash_es_4_17_21_lodash_es_keysIn, _getSymbolsIn);
}
/* harmony default export */ var _getAllKeysIn = (getAllKeysIn);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_DataView.js



/* Built-in method references that are verified to be native. */
var DataView = _getNative(_root, 'DataView');
/* harmony default export */ var _DataView = (DataView);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_Promise.js



/* Built-in method references that are verified to be native. */
var _Promise_Promise = _getNative(_root, 'Promise');
/* harmony default export */ var _Promise = (_Promise_Promise);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_WeakMap.js



/* Built-in method references that are verified to be native. */
var _WeakMap_WeakMap = _getNative(_root, 'WeakMap');
/* harmony default export */ var _WeakMap = (_WeakMap_WeakMap);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_getTag.js








/** `Object#toString` result references. */
var _getTag_mapTag = '[object Map]',
  _getTag_objectTag = '[object Object]',
  promiseTag = '[object Promise]',
  _getTag_setTag = '[object Set]',
  _getTag_weakMapTag = '[object WeakMap]';
var _getTag_dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = _toSource(_DataView),
  mapCtorString = _toSource(_Map),
  promiseCtorString = _toSource(_Promise),
  setCtorString = _toSource(_Set),
  weakMapCtorString = _toSource(_WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = _baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if (_DataView && getTag(new _DataView(new ArrayBuffer(1))) != _getTag_dataViewTag || _Map && getTag(new _Map()) != _getTag_mapTag || _Promise && getTag(_Promise.resolve()) != promiseTag || _Set && getTag(new _Set()) != _getTag_setTag || _WeakMap && getTag(new _WeakMap()) != _getTag_weakMapTag) {
  getTag = function getTag(value) {
    var result = _baseGetTag(value),
      Ctor = result == _getTag_objectTag ? value.constructor : undefined,
      ctorString = Ctor ? _toSource(Ctor) : '';
    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString:
          return _getTag_dataViewTag;
        case mapCtorString:
          return _getTag_mapTag;
        case promiseCtorString:
          return promiseTag;
        case setCtorString:
          return _getTag_setTag;
        case weakMapCtorString:
          return _getTag_weakMapTag;
      }
    }
    return result;
  };
}
/* harmony default export */ var _getTag = (getTag);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_initCloneArray.js
/** Used for built-in method references. */
var _initCloneArray_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var _initCloneArray_hasOwnProperty = _initCloneArray_objectProto.hasOwnProperty;

/**
 * Initializes an array clone.
 *
 * @private
 * @param {Array} array The array to clone.
 * @returns {Array} Returns the initialized clone.
 */
function initCloneArray(array) {
  var length = array.length,
    result = new array.constructor(length);

  // Add properties assigned by `RegExp#exec`.
  if (length && typeof array[0] == 'string' && _initCloneArray_hasOwnProperty.call(array, 'index')) {
    result.index = array.index;
    result.input = array.input;
  }
  return result;
}
/* harmony default export */ var _initCloneArray = (initCloneArray);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_Uint8Array.js


/** Built-in value references. */
var _Uint8Array_Uint8Array = _root.Uint8Array;
/* harmony default export */ var _Uint8Array = (_Uint8Array_Uint8Array);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_cloneArrayBuffer.js


/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new _Uint8Array(result).set(new _Uint8Array(arrayBuffer));
  return result;
}
/* harmony default export */ var _cloneArrayBuffer = (cloneArrayBuffer);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_cloneDataView.js


/**
 * Creates a clone of `dataView`.
 *
 * @private
 * @param {Object} dataView The data view to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned data view.
 */
function cloneDataView(dataView, isDeep) {
  var buffer = isDeep ? _cloneArrayBuffer(dataView.buffer) : dataView.buffer;
  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}
/* harmony default export */ var _cloneDataView = (cloneDataView);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_cloneRegExp.js
/** Used to match `RegExp` flags from their coerced string values. */
var reFlags = /\w*$/;

/**
 * Creates a clone of `regexp`.
 *
 * @private
 * @param {Object} regexp The regexp to clone.
 * @returns {Object} Returns the cloned regexp.
 */
function cloneRegExp(regexp) {
  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
  result.lastIndex = regexp.lastIndex;
  return result;
}
/* harmony default export */ var _cloneRegExp = (cloneRegExp);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_cloneSymbol.js


/** Used to convert symbols to primitives and strings. */
var _cloneSymbol_symbolProto = _Symbol ? _Symbol.prototype : undefined,
  symbolValueOf = _cloneSymbol_symbolProto ? _cloneSymbol_symbolProto.valueOf : undefined;

/**
 * Creates a clone of the `symbol` object.
 *
 * @private
 * @param {Object} symbol The symbol object to clone.
 * @returns {Object} Returns the cloned symbol object.
 */
function cloneSymbol(symbol) {
  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
}
/* harmony default export */ var _cloneSymbol = (cloneSymbol);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_cloneTypedArray.js


/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? _cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}
/* harmony default export */ var _cloneTypedArray = (cloneTypedArray);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_initCloneByTag.js






/** `Object#toString` result references. */
var _initCloneByTag_boolTag = '[object Boolean]',
  _initCloneByTag_dateTag = '[object Date]',
  _initCloneByTag_mapTag = '[object Map]',
  _initCloneByTag_numberTag = '[object Number]',
  _initCloneByTag_regexpTag = '[object RegExp]',
  _initCloneByTag_setTag = '[object Set]',
  _initCloneByTag_stringTag = '[object String]',
  _initCloneByTag_symbolTag = '[object Symbol]';
var _initCloneByTag_arrayBufferTag = '[object ArrayBuffer]',
  _initCloneByTag_dataViewTag = '[object DataView]',
  _initCloneByTag_float32Tag = '[object Float32Array]',
  _initCloneByTag_float64Tag = '[object Float64Array]',
  _initCloneByTag_int8Tag = '[object Int8Array]',
  _initCloneByTag_int16Tag = '[object Int16Array]',
  _initCloneByTag_int32Tag = '[object Int32Array]',
  _initCloneByTag_uint8Tag = '[object Uint8Array]',
  _initCloneByTag_uint8ClampedTag = '[object Uint8ClampedArray]',
  _initCloneByTag_uint16Tag = '[object Uint16Array]',
  _initCloneByTag_uint32Tag = '[object Uint32Array]';

/**
 * Initializes an object clone based on its `toStringTag`.
 *
 * **Note:** This function only supports cloning values with tags of
 * `Boolean`, `Date`, `Error`, `Map`, `Number`, `RegExp`, `Set`, or `String`.
 *
 * @private
 * @param {Object} object The object to clone.
 * @param {string} tag The `toStringTag` of the object to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneByTag(object, tag, isDeep) {
  var Ctor = object.constructor;
  switch (tag) {
    case _initCloneByTag_arrayBufferTag:
      return _cloneArrayBuffer(object);
    case _initCloneByTag_boolTag:
    case _initCloneByTag_dateTag:
      return new Ctor(+object);
    case _initCloneByTag_dataViewTag:
      return _cloneDataView(object, isDeep);
    case _initCloneByTag_float32Tag:
    case _initCloneByTag_float64Tag:
    case _initCloneByTag_int8Tag:
    case _initCloneByTag_int16Tag:
    case _initCloneByTag_int32Tag:
    case _initCloneByTag_uint8Tag:
    case _initCloneByTag_uint8ClampedTag:
    case _initCloneByTag_uint16Tag:
    case _initCloneByTag_uint32Tag:
      return _cloneTypedArray(object, isDeep);
    case _initCloneByTag_mapTag:
      return new Ctor();
    case _initCloneByTag_numberTag:
    case _initCloneByTag_stringTag:
      return new Ctor(object);
    case _initCloneByTag_regexpTag:
      return _cloneRegExp(object);
    case _initCloneByTag_setTag:
      return new Ctor();
    case _initCloneByTag_symbolTag:
      return _cloneSymbol(object);
  }
}
/* harmony default export */ var _initCloneByTag = (initCloneByTag);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseCreate.js


/** Built-in value references. */
var objectCreate = Object.create;

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} proto The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = function () {
  function object() {}
  return function (proto) {
    if (!_lodash_es_4_17_21_lodash_es_isObject(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object();
    object.prototype = undefined;
    return result;
  };
}();
/* harmony default export */ var _baseCreate = (baseCreate);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_initCloneObject.js




/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return typeof object.constructor == 'function' && !_isPrototype(object) ? _baseCreate(_getPrototype(object)) : {};
}
/* harmony default export */ var _initCloneObject = (initCloneObject);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseIsMap.js



/** `Object#toString` result references. */
var _baseIsMap_mapTag = '[object Map]';

/**
 * The base implementation of `_.isMap` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a map, else `false`.
 */
function baseIsMap(value) {
  return _lodash_es_4_17_21_lodash_es_isObjectLike(value) && _getTag(value) == _baseIsMap_mapTag;
}
/* harmony default export */ var _baseIsMap = (baseIsMap);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isMap.js




/* Node.js helper references. */
var nodeIsMap = _nodeUtil && _nodeUtil.isMap;

/**
 * Checks if `value` is classified as a `Map` object.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a map, else `false`.
 * @example
 *
 * _.isMap(new Map);
 * // => true
 *
 * _.isMap(new WeakMap);
 * // => false
 */
var isMap = nodeIsMap ? _baseUnary(nodeIsMap) : _baseIsMap;
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isMap = (isMap);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseIsSet.js



/** `Object#toString` result references. */
var _baseIsSet_setTag = '[object Set]';

/**
 * The base implementation of `_.isSet` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a set, else `false`.
 */
function baseIsSet(value) {
  return _lodash_es_4_17_21_lodash_es_isObjectLike(value) && _getTag(value) == _baseIsSet_setTag;
}
/* harmony default export */ var _baseIsSet = (baseIsSet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isSet.js




/* Node.js helper references. */
var nodeIsSet = _nodeUtil && _nodeUtil.isSet;

/**
 * Checks if `value` is classified as a `Set` object.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a set, else `false`.
 * @example
 *
 * _.isSet(new Set);
 * // => true
 *
 * _.isSet(new WeakSet);
 * // => false
 */
var isSet = nodeIsSet ? _baseUnary(nodeIsSet) : _baseIsSet;
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isSet = (isSet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseClone.js























/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1,
  CLONE_FLAT_FLAG = 2,
  CLONE_SYMBOLS_FLAG = 4;

/** `Object#toString` result references. */
var _baseClone_argsTag = '[object Arguments]',
  _baseClone_arrayTag = '[object Array]',
  _baseClone_boolTag = '[object Boolean]',
  _baseClone_dateTag = '[object Date]',
  _baseClone_errorTag = '[object Error]',
  _baseClone_funcTag = '[object Function]',
  _baseClone_genTag = '[object GeneratorFunction]',
  _baseClone_mapTag = '[object Map]',
  _baseClone_numberTag = '[object Number]',
  _baseClone_objectTag = '[object Object]',
  _baseClone_regexpTag = '[object RegExp]',
  _baseClone_setTag = '[object Set]',
  _baseClone_stringTag = '[object String]',
  _baseClone_symbolTag = '[object Symbol]',
  _baseClone_weakMapTag = '[object WeakMap]';
var _baseClone_arrayBufferTag = '[object ArrayBuffer]',
  _baseClone_dataViewTag = '[object DataView]',
  _baseClone_float32Tag = '[object Float32Array]',
  _baseClone_float64Tag = '[object Float64Array]',
  _baseClone_int8Tag = '[object Int8Array]',
  _baseClone_int16Tag = '[object Int16Array]',
  _baseClone_int32Tag = '[object Int32Array]',
  _baseClone_uint8Tag = '[object Uint8Array]',
  _baseClone_uint8ClampedTag = '[object Uint8ClampedArray]',
  _baseClone_uint16Tag = '[object Uint16Array]',
  _baseClone_uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values supported by `_.clone`. */
var cloneableTags = {};
cloneableTags[_baseClone_argsTag] = cloneableTags[_baseClone_arrayTag] = cloneableTags[_baseClone_arrayBufferTag] = cloneableTags[_baseClone_dataViewTag] = cloneableTags[_baseClone_boolTag] = cloneableTags[_baseClone_dateTag] = cloneableTags[_baseClone_float32Tag] = cloneableTags[_baseClone_float64Tag] = cloneableTags[_baseClone_int8Tag] = cloneableTags[_baseClone_int16Tag] = cloneableTags[_baseClone_int32Tag] = cloneableTags[_baseClone_mapTag] = cloneableTags[_baseClone_numberTag] = cloneableTags[_baseClone_objectTag] = cloneableTags[_baseClone_regexpTag] = cloneableTags[_baseClone_setTag] = cloneableTags[_baseClone_stringTag] = cloneableTags[_baseClone_symbolTag] = cloneableTags[_baseClone_uint8Tag] = cloneableTags[_baseClone_uint8ClampedTag] = cloneableTags[_baseClone_uint16Tag] = cloneableTags[_baseClone_uint32Tag] = true;
cloneableTags[_baseClone_errorTag] = cloneableTags[_baseClone_funcTag] = cloneableTags[_baseClone_weakMapTag] = false;

/**
 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
 * traversed objects.
 *
 * @private
 * @param {*} value The value to clone.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Deep clone
 *  2 - Flatten inherited properties
 *  4 - Clone symbols
 * @param {Function} [customizer] The function to customize cloning.
 * @param {string} [key] The key of `value`.
 * @param {Object} [object] The parent object of `value`.
 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
 * @returns {*} Returns the cloned value.
 */
function baseClone(value, bitmask, customizer, key, object, stack) {
  var result,
    isDeep = bitmask & CLONE_DEEP_FLAG,
    isFlat = bitmask & CLONE_FLAT_FLAG,
    isFull = bitmask & CLONE_SYMBOLS_FLAG;
  if (customizer) {
    result = object ? customizer(value, key, object, stack) : customizer(value);
  }
  if (result !== undefined) {
    return result;
  }
  if (!_lodash_es_4_17_21_lodash_es_isObject(value)) {
    return value;
  }
  var isArr = _lodash_es_4_17_21_lodash_es_isArray(value);
  if (isArr) {
    result = _initCloneArray(value);
    if (!isDeep) {
      return _copyArray(value, result);
    }
  } else {
    var tag = _getTag(value),
      isFunc = tag == _baseClone_funcTag || tag == _baseClone_genTag;
    if (_lodash_es_4_17_21_lodash_es_isBuffer(value)) {
      return _cloneBuffer(value, isDeep);
    }
    if (tag == _baseClone_objectTag || tag == _baseClone_argsTag || isFunc && !object) {
      result = isFlat || isFunc ? {} : _initCloneObject(value);
      if (!isDeep) {
        return isFlat ? _copySymbolsIn(value, _baseAssignIn(result, value)) : _copySymbols(value, _baseAssign(result, value));
      }
    } else {
      if (!cloneableTags[tag]) {
        return object ? value : {};
      }
      result = _initCloneByTag(value, tag, isDeep);
    }
  }
  // Check for circular references and return its corresponding clone.
  stack || (stack = new _Stack());
  var stacked = stack.get(value);
  if (stacked) {
    return stacked;
  }
  stack.set(value, result);
  if (_lodash_es_4_17_21_lodash_es_isSet(value)) {
    value.forEach(function (subValue) {
      result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
    });
  } else if (_lodash_es_4_17_21_lodash_es_isMap(value)) {
    value.forEach(function (subValue, key) {
      result.set(key, baseClone(subValue, bitmask, customizer, key, value, stack));
    });
  }
  var keysFunc = isFull ? isFlat ? _getAllKeysIn : _getAllKeys : isFlat ? _lodash_es_4_17_21_lodash_es_keysIn : _lodash_es_4_17_21_lodash_es_keys;
  var props = isArr ? undefined : keysFunc(value);
  _arrayEach(props || value, function (subValue, key) {
    if (props) {
      key = subValue;
      subValue = value[key];
    }
    // Recursively populate clone (susceptible to call stack limits).
    _assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
  });
  return result;
}
/* harmony default export */ var _baseClone = (baseClone);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/cloneDeep.js


/** Used to compose bitmasks for cloning. */
var cloneDeep_CLONE_DEEP_FLAG = 1,
  cloneDeep_CLONE_SYMBOLS_FLAG = 4;

/**
 * This method is like `_.clone` except that it recursively clones `value`.
 *
 * @static
 * @memberOf _
 * @since 1.0.0
 * @category Lang
 * @param {*} value The value to recursively clone.
 * @returns {*} Returns the deep cloned value.
 * @see _.clone
 * @example
 *
 * var objects = [{ 'a': 1 }, { 'b': 2 }];
 *
 * var deep = _.cloneDeep(objects);
 * console.log(deep[0] === objects[0]);
 * // => false
 */
function cloneDeep(value) {
  return _baseClone(value, cloneDeep_CLONE_DEEP_FLAG | cloneDeep_CLONE_SYMBOLS_FLAG);
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_cloneDeep = (cloneDeep);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/utils/text.js



var insertWordByPos = function insertWordByPos(text, word, pos) {
  return [text.slice(0, pos), word, text.slice(pos)].join('');
};
var getIndexByReverseIndex = function getIndexByReverseIndex(index, length) {
  return length - index - 1;
};
var getOrdersByDeleteId = function getOrdersByDeleteId(wids, deleteWid) {
  return {
    oldOrder: wids,
    newOrder: wids.filter(function (wid) {
      return wid !== deleteWid;
    })
  };
};
var getIsSelectAllText = function getIsSelectAllText(controller, pid, startOffset, endOffset) {
  var textContent = controller.getTextContent(pid);
  return textContent.length === endOffset - startOffset && startOffset === 0;
};
var generateDeleteTextRangeOps = function generateDeleteTextRangeOps(controller, pid, startOffset, endOffset) {
  var ops = [];
  if (startOffset === endOffset) {
    return ops;
  }
  var words = controller.getWords(pid);
  var paragraph = controller.getParagraph(pid);
  var wids = paragraph.wids.slice();
  var offset = 0;
  var isSelectAllText = getIsSelectAllText(controller, pid, startOffset, endOffset);
  words.some(function (word, index) {
    offset += word.text.length;
    var wordStartAt = offset - word.text.length;
    var oldValue = word.text;
    if (endOffset < wordStartAt) {
      return true;
    } else if (startOffset <= wordStartAt && endOffset >= offset) {
      if (isSelectAllText && index === 0) {
        var newWord = _lodash_es_4_17_21_lodash_es_cloneDeep(word);
        newWord.text = '';
        ops.push(createOperation('updateWord', {
          pid: pid,
          wid: word.wid,
          oldValue: word,
          newValue: newWord
        }));
      } else {
        var _getOrdersByDeleteId = getOrdersByDeleteId(wids, word.wid),
          oldOrder = _getOrdersByDeleteId.oldOrder,
          newOrder = _getOrdersByDeleteId.newOrder;
        wids = newOrder;
        ops.push(createOperation('deleteWord', {
          pid: pid,
          wid: word.wid,
          word: word,
          oldOrder: oldOrder,
          newOrder: newOrder
        }));
      }
    } else {
      var newValue = '';
      if (startOffset > wordStartAt && endOffset < offset) {
        newValue = [oldValue.slice(0, startOffset - wordStartAt), oldValue.slice(endOffset - wordStartAt)].join('');
      } else if (startOffset > wordStartAt && startOffset < offset) {
        newValue = oldValue.slice(0, startOffset - wordStartAt);
      } else if (endOffset < offset && endOffset > wordStartAt) {
        newValue = oldValue.slice(endOffset - wordStartAt);
      }
      if (newValue) {
        var _newWord = _lodash_es_4_17_21_lodash_es_cloneDeep(word);
        _newWord.text = newValue;
        ops.push(createOperation('updateWord', {
          pid: pid,
          wid: word.wid,
          oldValue: word,
          newValue: _newWord
        }));
      }
    }
    return false;
  });
  return ops;
};
var generateInsertTextOps = function generateInsertTextOps(controller, pid, startOffset, text) {
  var words = controller.getWords(pid);
  var offset = 0;
  var ops = [];
  words.some(function (word) {
    offset += word.text.length;
    if (startOffset <= offset) {
      var oldValue = word.text;
      var pos = startOffset - (offset - oldValue.length);
      var newValue = [oldValue.slice(0, pos), text, oldValue.slice(pos)].join('');
      var newWord = _lodash_es_4_17_21_lodash_es_cloneDeep(word);
      newWord.text = newValue;
      ops.push(createOperation('updateWord', {
        pid: pid,
        wid: word.wid,
        oldValue: word,
        newValue: newWord,
        userChangeText: true
      }));
      return true;
    }
    return false;
  });
  return ops;
};
var generateUpdateWords = function generateUpdateWords(pid, words, attrs) {
  var ops = [];
  var oldWords = [];
  var newWords = [];
  words.forEach(function (word) {
    oldWords.push(word);
    newWords.push(extends_extends({}, word, attrs));
  });
  ops.push(createOperation('updateWords', {
    pid: pid,
    oldValue: oldWords,
    newValue: newWords
  }));
  return ops;
};
var getSidWidsMap = function getSidWidsMap(controller, wids) {
  var sidWidsMap = {};
  var sids = [];
  wids.forEach(function (wid) {
    var word = controller.getWord(wid);
    if (!word) {
      return;
    }
    if (!sidWidsMap[word.sentenceId]) {
      sidWidsMap[word.sentenceId] = {
        isNfixing: false,
        wids: []
      };
      sids.push(word.sentenceId);
    }
    sidWidsMap[word.sentenceId].wids.push(wid);
    if (word.nFix) {
      sidWidsMap[word.sentenceId].isNfixing = true;
    }
  });
  return {
    sidWidsMap: sidWidsMap,
    sids: sids
  };
};
var getUnfixSidWidsMap = function getUnfixSidWidsMap(controller) {
  var result = {
    sidWidsMap: {},
    sids: []
  };
  var unfixPid = controller.getUnfixPid();
  if (unfixPid) {
    var paragraph = controller.getParagraph(unfixPid);
    result = getSidWidsMap(controller, paragraph.wids);
  }
  return result;
};
var getNfixingWids = function getNfixingWids(controller, wids) {
  var _getSidWidsMap = getSidWidsMap(controller, wids),
    sidWidsMap = _getSidWidsMap.sidWidsMap;
  var nfixingWids = [];
  Object.keys(sidWidsMap).forEach(function (sid) {
    if (sidWidsMap[sid].isNfixing) {
      nfixingWids.push.apply(nfixingWids, sidWidsMap[sid].wids);
    }
  });
  return nfixingWids;
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/utils/report.js
var report_callback = function callback() {};
var report_implementReport = function implementReport(cb) {
  report_callback = cb;
};
var report_report = function report(type, payload) {
  report_callback(type, payload);
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/utils/paragraph.js





var generatePid = function generatePid(prevPid, nextPid) {
  if (!prevPid) {
    if (!nextPid) {
      return +new Date() + "500000";
    } else {
      var _c = parseInt(nextPid.slice(0, 13), 10);
      var _c2 = 0;
      var _n = parseInt(nextPid.slice(0, 13), 10);
      var _n2 = parseInt(nextPid.slice(13), 10);
      return "" + Math.floor((_c + _n) / 2) + Math.floor((_c2 + _n2) / 2);
    }
  }
  var c1 = parseInt(prevPid.slice(0, 10), 10);
  var c2 = parseInt(prevPid.slice(10), 10);
  if (!nextPid) {
    return "" + c1 + (c2 + 500000);
  }
  var n1 = parseInt(nextPid.slice(0, 10), 10);
  var n2 = parseInt(nextPid.slice(10), 10);
  return "" + Math.floor((c1 + n1) / 2) + Math.floor((c2 + n2) / 2);
};
var tokenSeed = +new Date();
var generateWid = function generateWid() {
  return String(tokenSeed++ * 10 + 1); // 客户端生成的ID以1结尾，服务端以0结尾
};

var generateAddParagraphOps = function generateAddParagraphOps(controller, prevPid, newPid, startOffset) {
  var paragraph = controller.getParagraph(prevPid);
  var words = controller.getWords(prevPid);
  var ops = [];
  var newParagraph = _lodash_es_4_17_21_lodash_es_cloneDeep(paragraph);
  newParagraph.pid = newPid;
  newParagraph.wids = [];
  delete newParagraph.isUnfix;
  ops.push(createOperation('addParagraph', {
    prevPid: prevPid,
    pid: newPid,
    paragraph: newParagraph
  }));
  var offset = 0;
  var toMoveIds = [];
  var newParagraphOrder = [];
  var oldParagraphOrder = paragraph.wids;
  words.forEach(function (word) {
    var startAt = offset;
    offset += word.text.length;
    if (startOffset < offset) {
      if (startOffset > startAt) {
        var newWordToUpdate = _lodash_es_4_17_21_lodash_es_cloneDeep(word);
        newWordToUpdate.text = word.text.slice(0, startOffset - startAt);
        var newWordToAdd = _lodash_es_4_17_21_lodash_es_cloneDeep(word);
        newWordToAdd.wid = generateWid();
        newWordToAdd.text = word.text.slice(startOffset - startAt);
        ops.push(createOperation('updateWord', {
          pid: prevPid,
          wid: word.wid,
          oldValue: word,
          newValue: newWordToUpdate
        }), createOperation('addWord', {
          pid: newPid,
          wid: newWordToAdd.wid,
          word: newWordToAdd,
          oldOrder: newParagraphOrder,
          newOrder: newParagraphOrder = newParagraphOrder.concat(newWordToAdd.wid)
        }));
      } else {
        toMoveIds.push(word.wid);
      }
    }
  });
  if (toMoveIds.length > 0) {
    ops.push(createOperation('moveWord', {
      originPid: prevPid,
      targetPid: newPid,
      originOldOrder: oldParagraphOrder,
      originNewOrder: oldParagraphOrder = oldParagraphOrder.filter(function (wid) {
        return toMoveIds.indexOf(wid) === -1;
      }),
      targetOldOrder: newParagraphOrder,
      targetNewOrder: newParagraphOrder = newParagraphOrder.concat(toMoveIds)
    })); // move all words

    if (toMoveIds.length === words.length) {
      var firstWord = words[0];
      var newWord = _lodash_es_4_17_21_lodash_es_cloneDeep(firstWord);
      newWord.wid = generateWid();
      newWord.text = '';
      newWord.beginTime = firstWord.beginTime;
      newWord.endTime = firstWord.beginTime;
      ops.push(createOperation('addWord', {
        pid: prevPid,
        wid: newWord.wid,
        word: newWord,
        oldOrder: oldParagraphOrder,
        newOrder: oldParagraphOrder = oldParagraphOrder.concat(newWord.wid)
      }));
    }
  } // press `Enter` by tail -- no addWord, no updateWord, no moveWord

  if (ops.length === 1) {
    var lastWord = words[words.length - 1];
    var _newWord = _lodash_es_4_17_21_lodash_es_cloneDeep(lastWord);
    _newWord.wid = generateWid();
    _newWord.text = '';
    _newWord.beginTime = lastWord.endTime;
    _newWord.endTime = lastWord.endTime;
    ops.push(createOperation('addWord', {
      pid: newPid,
      wid: _newWord.wid,
      word: _newWord,
      oldOrder: newParagraphOrder,
      newOrder: newParagraphOrder = newParagraphOrder.concat(_newWord.wid)
    }));
  }
  return ops;
};
var getPreviousPid = function getPreviousPid(controller, pid) {
  var pids = controller.getPids();
  var pos = pids.indexOf(pid);
  if (pos !== -1) {
    return pids[pos - 1] || undefined;
  }
  return undefined;
};
var generateMergeParagraphOps = function generateMergeParagraphOps(controller, prevPid, pid) {
  var ops = [];
  if (!prevPid) {
    return ops;
  }
  var prevParagraph = controller.getParagraph(prevPid);
  var currentParagraph = controller.getParagraph(pid);
  var wids = currentParagraph.wids;
  if (controller.getTextContent(pid).length === 0 && wids.length === 1) {
    ops.push(createOperation('deleteWord', {
      pid: pid,
      wid: wids[0],
      word: controller.getWord(wids[0]),
      oldOrder: currentParagraph.wids,
      newOrder: []
    }));
  } else {
    ops.push(createOperation('moveWord', {
      originPid: currentParagraph.pid,
      originOldOrder: currentParagraph.wids,
      originNewOrder: [],
      targetPid: prevParagraph.pid,
      targetOldOrder: prevParagraph.wids,
      targetNewOrder: prevParagraph.wids.concat(currentParagraph.wids)
    }));
  }
  ops.push(createOperation('removeParagraph', {
    prevPid: prevParagraph.pid,
    pid: currentParagraph.pid,
    paragraph: currentParagraph
  }));
  return ops;
};
var generateRemoveParagraphOps = function generateRemoveParagraphOps(controller, pid) {
  var ops = [];
  var pids = controller.getPids();
  var pos = pids.indexOf(pid);
  if (pos === -1) {
    return ops;
  }
  var prevPid = pos === 0 ? undefined : pids[pos - 1];
  var paragraph = controller.getParagraph(pid);
  var wids = paragraph.wids;
  var tempOrder = wids.slice();
  wids.forEach(function (wid) {
    var word = controller.getWord(wid);
    var oldOrder = tempOrder;
    var newOrder = tempOrder.splice(1);
    tempOrder = newOrder;
    ops.push(createOperation('deleteWord', {
      pid: pid,
      wid: wid,
      word: word,
      oldOrder: oldOrder,
      newOrder: newOrder
    }));
  });
  ops.push(createOperation('removeParagraph', {
    prevPid: prevPid,
    pid: pid,
    paragraph: paragraph
  }));
  return ops;
}; // 存储临时wids，用于下一次unfix段落使用

var tempWidsStore = {
  wids: []
};
var generateFixParagraph = function generateFixParagraph(controller, pid) {
  var ops = [];
  var paragraph = controller.getParagraph(pid);
  if (paragraph.isUnfix) {
    var newWids = paragraph.wids;
    var nfixingWids = getNfixingWids(controller, paragraph.wids);
    if (nfixingWids.length > 0) {
      tempWidsStore.wids = nfixingWids;
      report_report('write tempWidsStore', {
        tempWidsStore: tempWidsStore
      }); // 成段时剔除nfixing的word

      newWids = paragraph.wids.filter(function (wid) {
        return !nfixingWids.includes(wid);
      });
    }
    var isEmptyContent = newWids.length === 0 || newWids.length === 1 && !controller.getWord(newWids[0]).text;
    if (isEmptyContent) {
      var pids = controller.getPids().filter(function (p) {
        return p !== pid;
      });
      var prevPid = pids.length > 0 ? pids[pids.length - 1] : undefined;
      ops.push(createOperation('removeParagraph', {
        prevPid: prevPid,
        pid: pid,
        paragraph: paragraph
      }));
    } else {
      ops.push(createOperation('updateParagraph', {
        pid: pid,
        oldParagraph: paragraph,
        paragraph: extends_extends({}, paragraph, {
          wids: newWids,
          isUnfix: false
        })
      }));
    }
  }
  return ops;
};
var generateAddUnfixParagraph = function generateAddUnfixParagraph(controller, pid, uid, paragraphAttrs) {
  if (paragraphAttrs === void 0) {
    paragraphAttrs = {};
  }
  var ops = [];
  var pids = controller.getPids();
  var prevPid = pids.length === 0 ? undefined : pids[pids.length - 1];
  if (prevPid) {
    var fixOps = generateFixParagraph(controller, prevPid);
    if (fixOps.length > 0) {
      ops.push.apply(ops, fixOps);
    }
  } // 避免words添加之前被删掉，导致wid和words不同步。

  var wids = tempWidsStore.wids.filter(function (wid) {
    return controller.getWord(wid);
  });
  report_report('read tempWidsStore', {
    tempWidsStore: tempWidsStore,
    wids: wids
  });
  tempWidsStore.wids = [];
  ops.push(createOperation('addParagraph', {
    prevPid: prevPid,
    pid: pid,
    paragraph: extends_extends({
      pid: pid,
      wids: wids,
      uid: uid,
      isUnfix: true
    }, paragraphAttrs)
  }));
  return ops;
};
var generateAppendWords = function generateAppendWords(controller, pid, words) {
  var ops = [];
  var paragraph = controller.getParagraph(pid);
  var wids = paragraph.wids.slice();
  words.forEach(function (word) {
    var isAppeared = controller.isAppearedWid(word.wid);
    if (isAppeared) {
      var oldWord = controller.getWord(word.wid); // 当有旧词时更新

      if (oldWord) {
        ops.push(createOperation('updateWord', {
          pid: pid,
          wid: word.wid,
          oldValue: oldWord,
          newValue: extends_extends({}, oldWord, {
            sentenceId: word.sentenceId,
            beginTime: word.beginTime,
            endTime: word.endTime,
            nFix: word.nFix
          })
        }));
      }
    } else {
      ops.push(createOperation('addWord', {
        pid: pid,
        wid: word.wid,
        word: word,
        oldOrder: wids,
        newOrder: wids = wids.concat(word.wid)
      }));
    }
  });
  return ops;
};
var generateSetParagraphMark = function generateSetParagraphMark(controller, pid, tagColor) {
  var ops = [];
  var paragraph = controller.getParagraph(pid);
  if (!paragraph) {
    return [];
  }
  var oldWords = [];
  var newWords = [];
  paragraph.wids.forEach(function (wid) {
    var word = controller.getWord(wid);
    if (!word) {
      return;
    }
    var newWord = _lodash_es_4_17_21_lodash_es_cloneDeep(word);
    newWord.tag = tagColor;
    oldWords.push(word);
    newWords.push(newWord);
  });
  if (newWords.length > 0) {
    ops.push(createOperation('updateWords', {
      pid: pid,
      oldValue: oldWords,
      newValue: newWords
    }));
  }
  return ops;
};
var generateUpdateUserByPid = function generateUpdateUserByPid(controller, pid, uid) {
  var ops = [];
  var paragraph = controller.getParagraph(pid);
  ops.push(createOperation('updateParagraph', {
    pid: pid,
    oldParagraph: paragraph,
    paragraph: extends_extends({}, paragraph, {
      uid: uid
    })
  }));
  return ops;
};
var generateUpdateAllUsers = function generateUpdateAllUsers(controller, pids, uid) {
  var ops = [];
  pids.forEach(function (pid) {
    var paragraph = controller.getParagraph(pid);
    ops.push(createOperation('updateParagraph', {
      pid: pid,
      oldParagraph: paragraph,
      paragraph: extends_extends({}, paragraph, {
        uid: uid
      })
    }));
  });
  return ops;
};
var paragraph_insertTextAndAddParagraph = function insertTextAndAddParagraph(controller, pid, startOffset, text) {
  var ops = generateInsertTextOps(controller, pid, startOffset, text);
  var pids = controller.getPids();
  var pos = pids.indexOf(pid);
  var prevPid = pids[pos - 1];
  var newPid = generatePid(prevPid, pid);
  var paragraph = controller.getParagraph(pid);
  var newParagraph = _lodash_es_4_17_21_lodash_es_cloneDeep(paragraph);
  newParagraph.pid = newPid;
  newParagraph.wids = [];
  delete newParagraph.isUnfix;
  var nfixingWids = getNfixingWids(controller, paragraph.wids);
  var originOldOrder = paragraph.wids;
  var originNewOrder = paragraph.wids.filter(function (wi) {
    return nfixingWids.includes(wi);
  });
  var targetOldOrder = newParagraph.wids;
  var targetNewOrder = paragraph.wids.filter(function (wi) {
    return !nfixingWids.includes(wi);
  });
  if (targetNewOrder.length > 0) {
    ops.push(createOperation('addParagraph', {
      prevPid: prevPid,
      pid: newPid,
      paragraph: newParagraph
    }));
    ops.push(createOperation('moveWord', {
      originPid: pid,
      originOldOrder: originOldOrder,
      originNewOrder: originNewOrder,
      targetPid: newPid,
      targetOldOrder: targetOldOrder,
      targetNewOrder: targetNewOrder
    }));
  }
  if (originNewOrder.length === 0) {
    var wid = paragraph.wids[paragraph.wids.length - 1];
    var word = controller.getWord(wid);
    var newWord = extends_extends({}, word, {
      wid: generateWid(),
      text: '',
      beginTime: word.endTime,
      tag: ''
    });
    ops.push(createOperation('addWord', {
      pid: pid,
      wid: newWord.wid,
      word: newWord,
      oldOrder: [],
      newOrder: [newWord.wid]
    }));
  }
  return ops;
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/setter/book.js

var createSetterBook = function createSetterBook(controller, apply) {
  return {
    insertText: function insertText(pid, startOffset, text) {
      var ops = generateInsertTextOps(controller, pid, startOffset, text);
      var nextSelection = {
        pid: pid,
        startOffset: startOffset + text.length,
        endOffset: startOffset + text.length
      };
      apply(ops, nextSelection);
    },
    insertTextAndAddParagraph: function insertTextAndAddParagraph(pid, startOffset, text) {
      var ops = paragraph_insertTextAndAddParagraph(controller, pid, startOffset, text);
      var userFixedPid;
      var nextSelection;
      var addParagraphOp = ops.find(function (op) {
        return op.action === 'addParagraph';
      });
      if ((addParagraphOp == null ? void 0 : addParagraphOp.action) === 'addParagraph') {
        userFixedPid = addParagraphOp.payload.pid;
        var addWordOp = ops.find(function (op) {
          return op.action === 'addWord';
        });
        var moveWordOp = ops.find(function (op) {
          return op.action === 'moveWord';
        });
        if (addWordOp) {
          var offset = startOffset + text.length;
          nextSelection = {
            pid: userFixedPid,
            startOffset: offset,
            endOffset: offset
          };
        } else if (moveWordOp) {
          var newWids = moveWordOp.payload.targetNewOrder;
          var newWordsLength = newWids.reduce(function (prev, wid) {
            var word = controller.getWord(wid);
            return prev + word.text.length;
          }, 0);
          var _offset = Math.max(0, startOffset + text.length - newWordsLength);
          nextSelection = {
            pid: pid,
            startOffset: _offset,
            endOffset: _offset
          };
        }
      }
      return apply(ops, nextSelection, {
        userFixedPid: userFixedPid
      });
    },
    deleteTextRange: function deleteTextRange(pid, startOffset, endOffset) {
      var ops = generateDeleteTextRangeOps(controller, pid, startOffset, endOffset);
      var nextSelection = {
        pid: pid,
        startOffset: startOffset,
        endOffset: startOffset
      };
      apply(ops, nextSelection);
    },
    addParagraph: function addParagraph(prevPid, newPid, startOffset) {
      var ops = generateAddParagraphOps(controller, prevPid, newPid, startOffset);
      var nextSelection;
      var addParagraphOp = ops.find(function (op) {
        return op.action === 'addParagraph';
      });
      if ((addParagraphOp == null ? void 0 : addParagraphOp.action) === 'addParagraph') {
        nextSelection = {
          pid: addParagraphOp.payload.pid,
          startOffset: 0,
          endOffset: 0
        };
      }
      apply(ops, nextSelection);
    },
    mergeParagraph: function mergeParagraph(prevPid, pid) {
      var ops = generateMergeParagraphOps(controller, prevPid, pid);
      var text = controller.getTextContent(prevPid);
      var nextSelection = {
        pid: prevPid,
        startOffset: text.length,
        endOffset: text.length
      };
      apply(ops, nextSelection);
    },
    removeParagraph: function removeParagraph(pid) {
      var ops = generateRemoveParagraphOps(controller, pid);
      var pids = controller.getPids();
      var pos = pids.indexOf(pid);
      var nextPid = pids[pos + 1];
      var nextSelection;
      if (nextPid != null) {
        nextSelection = {
          pid: nextPid,
          startOffset: 0,
          endOffset: 0
        };
      }
      apply(ops, nextSelection);
    },
    addUnfixParagraph: function addUnfixParagraph(pid, uid, attrs) {
      var ops = generateAddUnfixParagraph(controller, pid, uid, attrs);
      apply(ops);
    },
    addFixParagraph: function addFixParagraph(pid, selection) {
      var ops = generateFixParagraph(controller, pid);
      apply(ops, selection);
    },
    appendWords: function appendWords(pid, words) {
      var ops = generateAppendWords(controller, pid, words);
      apply(ops);
    },
    setParagraphMark: function setParagraphMark(pid, tagColor) {
      var ops = generateSetParagraphMark(controller, pid, tagColor);
      apply(ops);
    },
    updateUserByPid: function updateUserByPid(pid, uid) {
      var ops = generateUpdateUserByPid(controller, pid, uid);
      apply(ops);
    },
    updateAllUsers: function updateAllUsers(pids, uid) {
      var ops = generateUpdateAllUsers(controller, pids, uid);
      apply(ops);
    },
    updateWords: function updateWords(pid, words, attrs, oldSelection) {
      var ops = generateUpdateWords(pid, words, attrs);
      var originWords = controller.getWords(pid);
      var offset = 0;
      var lastWord = words[words.length - 1];
      originWords.some(function (word) {
        offset += word.text.length;
        return word.wid === lastWord.wid;
      });
      var nextSelection = {
        pid: pid,
        startOffset: offset,
        endOffset: offset
      };
      apply(ops, oldSelection || nextSelection);
    }
  };
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/setter/index.js


var createSetter = function createSetter(controller, model, hooks) {
  var isNextSilent = false;
  var isNextPreteat = false;
  function apply(change, nextSelection, extPayload) {
    hooks.beforeApply(isNextSilent, extPayload);
    var inverse = model.applyOps(change);
    hooks.afterApply(change, inverse, nextSelection, isNextSilent, isNextPreteat);
    isNextSilent = false;
    isNextPreteat = false;
  }
  function nextApplyPreteat() {
    isNextPreteat = true;
  }
  function nextApplySilent() {
    isNextSilent = true;
  }
  return {
    apply: apply,
    nextApplyPreteat: nextApplyPreteat,
    nextApplySilent: nextApplySilent,
    book: createSetterBook(controller, apply)
  };
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/model/stacker.js
var UndoRedoStacker = /*#__PURE__*/function () {
  function UndoRedoStacker(model, hooks) {
    this.waiting = undefined;
    this.undoStack = [];
    this.redoStack = [];
    this.model = void 0;
    this.hooks = void 0;
    this.maxStackerLength = void 0;
    this.model = model;
    this.hooks = hooks;
    this.maxStackerLength = 100;
  }
  var _proto = UndoRedoStacker.prototype;
  _proto.stash = function stash(change, inverse, prevSelection, nextSelection) {
    var waiting = this.waiting;
    if (waiting) {
      waiting.change = waiting.change.concat(change);
      waiting.inverse = inverse.concat(waiting.inverse);
      if (!waiting.selection.prev) {
        waiting.selection.prev = prevSelection;
      }
      waiting.selection.next = nextSelection;
    } else {
      this.waiting = {
        change: change,
        inverse: inverse,
        selection: {
          prev: prevSelection,
          next: nextSelection
        }
      };
    }
    this.submit();
  };
  _proto.preteat = function preteat(change, inverse, prevSelection) {
    var waiting = this.waiting;
    if (!waiting) {
      this.waiting = {
        change: change,
        inverse: inverse,
        selection: {
          prev: prevSelection
        }
      };
    } else {
      waiting.change = waiting.change.concat(change);
      waiting.inverse = inverse.concat(waiting.inverse);
      if (!waiting.selection.prev) {
        waiting.selection.prev = prevSelection;
      }
    }
  };
  _proto.commit = function commit(change, inverse) {
    this.stash(change, inverse);
  };
  _proto.hasStash = function hasStash() {
    return this.waiting !== undefined;
  };
  _proto.getPopStash = function getPopStash() {
    var waiting = this.waiting;
    this.waiting = undefined;
    return waiting;
  };
  _proto.submit = function submit() {
    var popStash = this.getPopStash();
    if (!popStash) {
      return;
    }
    this.pushUndoStack(popStash);
    this.redoStack = [];
  };
  _proto.pushUndoStack = function pushUndoStack(stash) {
    if (this.undoStack.length >= this.maxStackerLength) {
      this.undoStack.shift();
    }
    this.undoStack.push(stash);
  };
  _proto.restoreSelection = function restoreSelection(selection) {
    this.hooks.restoreSelection(selection);
  };
  _proto.undo = function undo() {
    var undoStack = this.undoStack,
      model = this.model,
      redoStack = this.redoStack;
    var last = undoStack.pop();
    if (!last) {
      return;
    }
    var inverse = last.inverse,
      prev = last.selection.prev;
    model.applyOps(inverse);
    redoStack.push(last);
    if (prev) {
      this.restoreSelection(prev);
    }
  };
  _proto.redo = function redo() {
    var undoStack = this.undoStack,
      model = this.model,
      redoStack = this.redoStack;
    var last = redoStack.pop();
    if (!last) {
      return;
    }
    var change = last.change,
      next = last.selection.next;
    model.applyOps(change);
    undoStack.push(last);
    if (next) {
      this.restoreSelection(next);
    }
  };
  _proto.canRedo = function canRedo() {
    return this.redoStack.length > 0;
  };
  _proto.canUndo = function canUndo() {
    return this.undoStack.length > 0;
  };
  _proto.reset = function reset() {
    this.undoStack = [];
    this.redoStack = [];
  };
  return UndoRedoStacker;
}();
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/utils/controller.js
var id = 0;
var generateControllerId = function generateControllerId() {
  return String(++id);
};
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_assignMergeValue.js



/**
 * This function is like `assignValue` except that it doesn't assign
 * `undefined` values.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignMergeValue(object, key, value) {
  if (value !== undefined && !_lodash_es_4_17_21_lodash_es_eq(object[key], value) || value === undefined && !(key in object)) {
    _baseAssignValue(object, key, value);
  }
}
/* harmony default export */ var _assignMergeValue = (assignMergeValue);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_createBaseFor.js
/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function (object, iteratee, keysFunc) {
    var index = -1,
      iterable = Object(object),
      props = keysFunc(object),
      length = props.length;
    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}
/* harmony default export */ var _createBaseFor = (createBaseFor);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseFor.js


/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = _createBaseFor();
/* harmony default export */ var _baseFor = (baseFor);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isArrayLikeObject.js



/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return _lodash_es_4_17_21_lodash_es_isObjectLike(value) && _lodash_es_4_17_21_lodash_es_isArrayLike(value);
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isArrayLikeObject = (isArrayLikeObject);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/isPlainObject.js




/** `Object#toString` result references. */
var isPlainObject_objectTag = '[object Object]';

/** Used for built-in method references. */
var isPlainObject_funcProto = Function.prototype,
  isPlainObject_objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var isPlainObject_funcToString = isPlainObject_funcProto.toString;

/** Used to check objects for own properties. */
var isPlainObject_hasOwnProperty = isPlainObject_objectProto.hasOwnProperty;

/** Used to infer the `Object` constructor. */
var objectCtorString = isPlainObject_funcToString.call(Object);

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * @static
 * @memberOf _
 * @since 0.8.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  if (!_lodash_es_4_17_21_lodash_es_isObjectLike(value) || _baseGetTag(value) != isPlainObject_objectTag) {
    return false;
  }
  var proto = _getPrototype(value);
  if (proto === null) {
    return true;
  }
  var Ctor = isPlainObject_hasOwnProperty.call(proto, 'constructor') && proto.constructor;
  return typeof Ctor == 'function' && Ctor instanceof Ctor && isPlainObject_funcToString.call(Ctor) == objectCtorString;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_isPlainObject = (isPlainObject);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_safeGet.js
/**
 * Gets the value at `key`, unless `key` is "__proto__" or "constructor".
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function safeGet(object, key) {
  if (key === 'constructor' && typeof object[key] === 'function') {
    return;
  }
  if (key == '__proto__') {
    return;
  }
  return object[key];
}
/* harmony default export */ var _safeGet = (safeGet);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/toPlainObject.js



/**
 * Converts `value` to a plain object flattening inherited enumerable string
 * keyed properties of `value` to own properties of the plain object.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {Object} Returns the converted plain object.
 * @example
 *
 * function Foo() {
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.assign({ 'a': 1 }, new Foo);
 * // => { 'a': 1, 'b': 2 }
 *
 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
 * // => { 'a': 1, 'b': 2, 'c': 3 }
 */
function toPlainObject(value) {
  return _copyObject(value, _lodash_es_4_17_21_lodash_es_keysIn(value));
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_toPlainObject = (toPlainObject);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseMergeDeep.js
















/**
 * A specialized version of `baseMerge` for arrays and objects which performs
 * deep merges and tracks traversed objects enabling objects with circular
 * references to be merged.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {string} key The key of the value to merge.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} mergeFunc The function to merge values.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
  var objValue = _safeGet(object, key),
    srcValue = _safeGet(source, key),
    stacked = stack.get(srcValue);
  if (stacked) {
    _assignMergeValue(object, key, stacked);
    return;
  }
  var newValue = customizer ? customizer(objValue, srcValue, key + '', object, source, stack) : undefined;
  var isCommon = newValue === undefined;
  if (isCommon) {
    var isArr = _lodash_es_4_17_21_lodash_es_isArray(srcValue),
      isBuff = !isArr && _lodash_es_4_17_21_lodash_es_isBuffer(srcValue),
      isTyped = !isArr && !isBuff && _lodash_es_4_17_21_lodash_es_isTypedArray(srcValue);
    newValue = srcValue;
    if (isArr || isBuff || isTyped) {
      if (_lodash_es_4_17_21_lodash_es_isArray(objValue)) {
        newValue = objValue;
      } else if (_lodash_es_4_17_21_lodash_es_isArrayLikeObject(objValue)) {
        newValue = _copyArray(objValue);
      } else if (isBuff) {
        isCommon = false;
        newValue = _cloneBuffer(srcValue, true);
      } else if (isTyped) {
        isCommon = false;
        newValue = _cloneTypedArray(srcValue, true);
      } else {
        newValue = [];
      }
    } else if (_lodash_es_4_17_21_lodash_es_isPlainObject(srcValue) || _lodash_es_4_17_21_lodash_es_isArguments(srcValue)) {
      newValue = objValue;
      if (_lodash_es_4_17_21_lodash_es_isArguments(objValue)) {
        newValue = _lodash_es_4_17_21_lodash_es_toPlainObject(objValue);
      } else if (!_lodash_es_4_17_21_lodash_es_isObject(objValue) || _lodash_es_4_17_21_lodash_es_isFunction(objValue)) {
        newValue = _initCloneObject(srcValue);
      }
    } else {
      isCommon = false;
    }
  }
  if (isCommon) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    stack.set(srcValue, newValue);
    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
    stack['delete'](srcValue);
  }
  _assignMergeValue(object, key, newValue);
}
/* harmony default export */ var _baseMergeDeep = (baseMergeDeep);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseMerge.js








/**
 * The base implementation of `_.merge` without support for multiple sources.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMerge(object, source, srcIndex, customizer, stack) {
  if (object === source) {
    return;
  }
  _baseFor(source, function (srcValue, key) {
    stack || (stack = new _Stack());
    if (_lodash_es_4_17_21_lodash_es_isObject(srcValue)) {
      _baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
    } else {
      var newValue = customizer ? customizer(_safeGet(object, key), srcValue, key + '', object, source, stack) : undefined;
      if (newValue === undefined) {
        newValue = srcValue;
      }
      _assignMergeValue(object, key, newValue);
    }
  }, _lodash_es_4_17_21_lodash_es_keysIn);
}
/* harmony default export */ var _baseMerge = (baseMerge);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/identity.js
/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_identity = (identity);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_apply.js
/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0:
      return func.call(thisArg);
    case 1:
      return func.call(thisArg, args[0]);
    case 2:
      return func.call(thisArg, args[0], args[1]);
    case 3:
      return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}
/* harmony default export */ var _apply = (apply);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_overRest.js


/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * A specialized version of `baseRest` which transforms the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @param {Function} transform The rest array transform.
 * @returns {Function} Returns the new function.
 */
function overRest(func, start, transform) {
  start = nativeMax(start === undefined ? func.length - 1 : start, 0);
  return function () {
    var args = arguments,
      index = -1,
      length = nativeMax(args.length - start, 0),
      array = Array(length);
    while (++index < length) {
      array[index] = args[start + index];
    }
    index = -1;
    var otherArgs = Array(start + 1);
    while (++index < start) {
      otherArgs[index] = args[index];
    }
    otherArgs[start] = transform(array);
    return _apply(func, this, otherArgs);
  };
}
/* harmony default export */ var _overRest = (overRest);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/constant.js
/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant(value) {
  return function () {
    return value;
  };
}
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_constant = (constant);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseSetToString.js




/**
 * The base implementation of `setToString` without support for hot loop shorting.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var baseSetToString = !_lodash_es_4_17_21_lodash_es_defineProperty ? _lodash_es_4_17_21_lodash_es_identity : function (func, string) {
  return _lodash_es_4_17_21_lodash_es_defineProperty(func, 'toString', {
    'configurable': true,
    'enumerable': false,
    'value': _lodash_es_4_17_21_lodash_es_constant(string),
    'writable': true
  });
};
/* harmony default export */ var _baseSetToString = (baseSetToString);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_shortOut.js
/** Used to detect hot functions by number of calls within a span of milliseconds. */
var HOT_COUNT = 800,
  HOT_SPAN = 16;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeNow = Date.now;

/**
 * Creates a function that'll short out and invoke `identity` instead
 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
 * milliseconds.
 *
 * @private
 * @param {Function} func The function to restrict.
 * @returns {Function} Returns the new shortable function.
 */
function shortOut(func) {
  var count = 0,
    lastCalled = 0;
  return function () {
    var stamp = nativeNow(),
      remaining = HOT_SPAN - (stamp - lastCalled);
    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count = 0;
    }
    return func.apply(undefined, arguments);
  };
}
/* harmony default export */ var _shortOut = (shortOut);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_setToString.js



/**
 * Sets the `toString` method of `func` to return `string`.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var setToString = _shortOut(_baseSetToString);
/* harmony default export */ var _setToString = (setToString);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_baseRest.js




/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return _setToString(_overRest(func, start, _lodash_es_4_17_21_lodash_es_identity), func + '');
}
/* harmony default export */ var _baseRest = (baseRest);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_isIterateeCall.js





/**
 * Checks if the given arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
 *  else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!_lodash_es_4_17_21_lodash_es_isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number' ? _lodash_es_4_17_21_lodash_es_isArrayLike(object) && _isIndex(index, object.length) : type == 'string' && index in object) {
    return _lodash_es_4_17_21_lodash_es_eq(object[index], value);
  }
  return false;
}
/* harmony default export */ var _isIterateeCall = (isIterateeCall);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/_createAssigner.js



/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return _baseRest(function (object, sources) {
    var index = -1,
      length = sources.length,
      customizer = length > 1 ? sources[length - 1] : undefined,
      guard = length > 2 ? sources[2] : undefined;
    customizer = assigner.length > 3 && typeof customizer == 'function' ? (length--, customizer) : undefined;
    if (guard && _isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}
/* harmony default export */ var _createAssigner = (createAssigner);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/mergeWith.js



/**
 * This method is like `_.merge` except that it accepts `customizer` which
 * is invoked to produce the merged values of the destination and source
 * properties. If `customizer` returns `undefined`, merging is handled by the
 * method instead. The `customizer` is invoked with six arguments:
 * (objValue, srcValue, key, object, source, stack).
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} sources The source objects.
 * @param {Function} customizer The function to customize assigned values.
 * @returns {Object} Returns `object`.
 * @example
 *
 * function customizer(objValue, srcValue) {
 *   if (_.isArray(objValue)) {
 *     return objValue.concat(srcValue);
 *   }
 * }
 *
 * var object = { 'a': [1], 'b': [2] };
 * var other = { 'a': [3], 'b': [4] };
 *
 * _.mergeWith(object, other, customizer);
 * // => { 'a': [1, 3], 'b': [2, 4] }
 */
var mergeWith = _createAssigner(function (object, source, srcIndex, customizer) {
  _baseMerge(object, source, srcIndex, customizer);
});
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_mergeWith = (mergeWith);
;// CONCATENATED MODULE: ./node_modules/_lodash-es@4.17.21@lodash-es/assign.js







/** Used for built-in method references. */
var assign_objectProto = Object.prototype;

/** Used to check objects for own properties. */
var assign_hasOwnProperty = assign_objectProto.hasOwnProperty;

/**
 * Assigns own enumerable string keyed properties of source objects to the
 * destination object. Source objects are applied from left to right.
 * Subsequent sources overwrite property assignments of previous sources.
 *
 * **Note:** This method mutates `object` and is loosely based on
 * [`Object.assign`](https://mdn.io/Object/assign).
 *
 * @static
 * @memberOf _
 * @since 0.10.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @see _.assignIn
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * function Bar() {
 *   this.c = 3;
 * }
 *
 * Foo.prototype.b = 2;
 * Bar.prototype.d = 4;
 *
 * _.assign({ 'a': 0 }, new Foo, new Bar);
 * // => { 'a': 1, 'c': 3 }
 */
var assign_assign = _createAssigner(function (object, source) {
  if (_isPrototype(source) || _lodash_es_4_17_21_lodash_es_isArrayLike(source)) {
    _copyObject(source, _lodash_es_4_17_21_lodash_es_keys(source), object);
    return;
  }
  for (var key in source) {
    if (assign_hasOwnProperty.call(source, key)) {
      _assignValue(object, key, source[key]);
    }
  }
});
/* harmony default export */ var _lodash_es_4_17_21_lodash_es_assign = (assign_assign);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/event.js

var formatParagraphChangeSpecificEvent = function formatParagraphChangeSpecificEvent(event) {
  var newEvent = _lodash_es_4_17_21_lodash_es_cloneDeep(event);
  newEvent.updateParagraphPids = newEvent.updateParagraphPids.filter(function (pid) {
    return newEvent.addParagraphPids.indexOf(pid) === -1;
  });
  newEvent.updateParagraphPids = newEvent.updateParagraphPids.filter(function (pid) {
    return newEvent.removeParagraphPids.indexOf(pid) === -1;
  });
  return newEvent;
};
var createParagraphChangeSpecificHandler = function createParagraphChangeSpecificHandler(callback) {
  function genEmptyHolder() {
    return {
      addParagraphPids: [],
      removeParagraphPids: [],
      updateParagraphPids: [],
      removeParagraphs: {}
    };
  }
  var holder = genEmptyHolder();
  var timer;
  return function (args) {
    _lodash_es_4_17_21_lodash_es_mergeWith(holder, args, function (a, b) {
      if (_lodash_es_4_17_21_lodash_es_isArray(a)) {
        return _lodash_es_4_17_21_lodash_es_uniq(a.concat(b));
      } else {
        _lodash_es_4_17_21_lodash_es_assign({}, a, b);
      }
    });
    clearTimeout(timer);
    timer = setTimeout(function () {
      callback(formatParagraphChangeSpecificEvent(holder));
      holder = genEmptyHolder();
    }, 0);
  };
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/captionCmdController.js


var CaptionCmdController = /*#__PURE__*/function (_AbstractCmdControlle) {
  _inheritsLoose(CaptionCmdController, _AbstractCmdControlle);
  function CaptionCmdController(controller) {
    var _this;
    _this = _AbstractCmdControlle.call(this, controller) || this;
    _this.paragraphCaptionMap = {};
    _this.listen();
    return _this;
  }
  var _proto = CaptionCmdController.prototype;
  _proto.listen = function listen() {
    var _this2 = this;
    this.controller.on('modelValueChange', function () {
      _this2.calcAllCaptions();
      _this2.controller.emit('captionChange', {});
    });
    this.controller.on('paragraphChangeSpecific', function (event) {
      var addParagraphPids = event.addParagraphPids,
        removeParagraphPids = event.removeParagraphPids,
        updateParagraphPids = event.updateParagraphPids;
      [].concat(addParagraphPids, updateParagraphPids).forEach(function (pid) {
        _this2.calcCaptionsByPid(pid);
      });
      removeParagraphPids.forEach(function (pid) {
        delete _this2.paragraphCaptionMap[pid];
      });
      _this2.controller.emit('captionChange', {});
    });
  };
  _proto.getParagraphCaptionsMap = function getParagraphCaptionsMap() {
    return this.paragraphCaptionMap;
  };
  _proto.getCaptionArray = function getCaptionArray() {
    var _this3 = this;
    var pids = this.controller.getPids();
    var captions = [];
    pids.forEach(function (pid) {
      var paragraphCaption = _this3.paragraphCaptionMap[pid];
      if (paragraphCaption) {
        captions.push.apply(captions, paragraphCaption.captions);
      }
    });
    return captions;
  };
  _proto.getCaptionByTimestamp = function getCaptionByTimestamp(timestamp) {
    var _this4 = this;
    var pids = Object.keys(this.paragraphCaptionMap);
    var foundCaption;
    pids.some(function (pid) {
      var paragraphCaption = _this4.paragraphCaptionMap[pid];
      if (timestamp >= paragraphCaption.beginTime && timestamp <= paragraphCaption.endTime) {
        paragraphCaption.captions.some(function (caption) {
          if (timestamp >= caption.beginTime && timestamp <= caption.endTime) {
            foundCaption = caption;
            return true;
          }
          return false;
        });
        return true;
      }
      return false;
    });
    return foundCaption;
  };
  _proto.calcAllCaptions = function calcAllCaptions() {
    var _this5 = this;
    var pids = this.controller.getPids();
    this.paragraphCaptionMap = {};
    pids.forEach(function (pid) {
      _this5.calcCaptionsByPid(pid);
    });
  };
  _proto.calcCaptionsByPid = function calcCaptionsByPid(pid) {
    var paragraph = this.controller.getParagraph(pid);
    delete this.paragraphCaptionMap[pid];
    if (!paragraph) {
      return;
    }
    var uid = paragraph.uid;
    var words = this.controller.getWords(pid);
    if (words.length === 0) {
      return;
    }
    var beginTime = words[0].beginTime;
    var endTime = words[words.length - 1].endTime;
    var paragraphCaption = {
      pid: pid,
      beginTime: beginTime,
      endTime: endTime,
      captions: []
    };
    var captionBeginTime;
    var catptionText = '';
    words.forEach(function (word) {
      catptionText += word.text;
      if (!captionBeginTime) {
        captionBeginTime = word.beginTime;
      }
      if (/[，。？,.?](\s)*$/.test(catptionText)) {
        catptionText = catptionText.replace(/[，。？,.?](\s)*$/, '');
        paragraphCaption.captions.push({
          beginTime: captionBeginTime,
          endTime: word.endTime,
          text: catptionText,
          uid: uid
        });
        catptionText = '';
        captionBeginTime = undefined;
      }
    });
    this.paragraphCaptionMap[pid] = paragraphCaption;
  };
  return CaptionCmdController;
}(AbstractCmdController);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-core@0.3.9@@ali/tingwu-core/dist-web/controller/index.js




















 // 特殊情况
// 1. click pause btn
// 2. has unfix paragraph
// 3. fix && stash_text为空 -> 不显示蓝色气泡
// 4. 增加stash_text -> 显示蓝色气泡
// 5. fix
// 6. complete -> 不显示蓝色气泡

var TranscriptingState;
(function (TranscriptingState) {
  TranscriptingState[TranscriptingState["Enabled"] = 0] = "Enabled";
  TranscriptingState[TranscriptingState["Disabing"] = 1] = "Disabing";
  TranscriptingState[TranscriptingState["Disabled"] = 2] = "Disabled";
})(TranscriptingState || (TranscriptingState = {}));
var Controller = /*#__PURE__*/function (_Eventer) {
  _inheritsLoose(Controller, _Eventer);

  // 实时模式unfix区编辑文字数超过下列数量时会主动成段
  function Controller(runningOnServer) {
    var _this;
    if (runningOnServer === void 0) {
      runningOnServer = false;
    }
    _this = _Eventer.call(this) || this;
    _this.id = void 0;
    _this.reader = void 0;
    _this.setter = void 0;
    _this.runningOnServer = void 0;
    _this.model = void 0;
    _this.liveMeetingController = void 0;
    _this.searchReplaceController = void 0;
    _this.voiceWordController = void 0;
    _this.paragraphFilterController = void 0;
    _this.translateController = void 0;
    _this.agendaController = void 0;
    _this.speakerController = void 0;
    _this.unfixToFixedController = void 0;
    _this.captionCmdController = void 0;
    _this.undoRedoStacker = void 0;
    _this.livingMode = false;
    _this.transcriptingState = TranscriptingState.Disabled;
    _this.unfixChangedWaiting = {};
    _this.lastUnfixPid = void 0;
    _this.userFixedPid = void 0;
    _this.tempUid = void 0;
    _this.tempMark = void 0;
    _this.holdUnfixContent = '';
    _this.editorFocusPid = void 0;
    _this.readonly = false;
    _this.unfixMaxWords = 160;
    _this.prevRecordSelection = void 0;
    _this.nextRecordSelection = void 0;
    _this.nextSelection = void 0;
    _this.currentSelection = void 0;
    _this.isDontSelectNext = false;
    _this.genSelectWordHandler = function (callback) {
      return function (args) {
        var selection = args.selection;
        if (selection) {
          var pid = selection.pid,
            startOffset = selection.startOffset,
            endOffset = selection.endOffset,
            readonly = selection.readonly;
          if (readonly) {
            // translate
            return;
          }
          var _words = _this.getWords(pid);
          var matchWords = [];
          var offset = 0;
          _words.some(function (word, index) {
            var nextOffset = offset + word.text.length;
            if (startOffset === endOffset) {
              if (startOffset > offset && startOffset <= nextOffset) {
                matchWords.push(word);
                return true;
              } else if (startOffset === 0 && index === 0) {
                matchWords.push(word);
                return true;
              }
            } else if (startOffset <= offset && endOffset > offset || endOffset >= nextOffset && startOffset < nextOffset) {
              matchWords.push(word);
            }
            if (endOffset < offset) {
              return true;
            }
            offset = nextOffset;
            return false;
          });
          callback(matchWords);
        } else {
          callback(undefined);
        }
      };
    };
    _this.listenSelectWordhandler = undefined;
    _this.listenSearchReplaceChagnehandler = undefined;
    _this.listenNeedSeekToWord = undefined;
    _this.startListenSelectWordCallback = void 0;
    _this.startListenSelectWord = function (callback) {
      if (_this.listenSelectWordhandler != null) {
        console.error('You are listening `select word` events. ' + 'please check your code. ' + 'dont listen this events twice.');
        return;
      }
      _this.startListenSelectWordCallback = callback;
      _this.listenSelectWordhandler = _this.genSelectWordHandler(callback);
      var _assertThisInitialize = _assertThisInitialized(_this),
        listenSelectWordhandler = _assertThisInitialize.listenSelectWordhandler;
      _this.listenSearchReplaceChagnehandler = function (event) {
        listenSelectWordhandler({
          selection: event.selections[event.activeIndex]
        });
      };
      _this.listenNeedSeekToWord = function (event) {
        return callback([event.word]);
      };
      _this.on('mouseUpSelectionChange', _this.listenSelectWordhandler);
      _this.on('searchReplaceChange', _this.listenSearchReplaceChagnehandler);
      _this.on('needSeekToWord', _this.listenNeedSeekToWord);
      return _this.endListenSelectWord;
    };
    _this.endListenSelectWord = function () {
      _this.off('mouseUpSelectionChange', _this.listenSelectWordhandler);
      _this.off('searchReplaceChange', _this.listenSearchReplaceChagnehandler);
      _this.off('needSeekToWord', _this.listenNeedSeekToWord);
      _this.listenSelectWordhandler = undefined;
      _this.listenSearchReplaceChagnehandler = undefined;
      _this.listenNeedSeekToWord = undefined;
      _this.startListenSelectWordCallback = undefined;
    };
    _this.recordTimeout = void 0;
    _this.id = generateControllerId();
    _this.runningOnServer = runningOnServer;
    _this.model = new Model();
    _this.undoRedoStacker = new UndoRedoStacker(_this.model, {
      restoreSelection: function restoreSelection(s) {
        _this.handleSelectionChange(s);
      }
    });
    _this.reader = createReader(_this.model);
    _this.setter = createSetter(_assertThisInitialized(_this), _this.model, {
      beforeApply: function beforeApply(isSilent, extPayload) {
        var _ref = extPayload || {},
          userFixedPid = _ref.userFixedPid;
        _this.userFixedPid = userFixedPid;
        if (isSilent) {
          if (_this.currentSelection) {
            _this.handleSelectionChange(_this.currentSelection);
          }
        } else if (!_this.prevRecordSelection && _this.currentSelection) {
          _this.recordPrevSelection(_this.currentSelection);
        }
      },
      afterApply: function afterApply(c, i, nextSelection, isSilent, isPreteat) {
        report_report('applyOps', c);
        if (isSilent) {
          return;
        }
        if (c.length === 0) {
          _this.recordPrevSelection(undefined);
          return;
        }
        if (isPreteat) {
          _this.undoRedoStacker.preteat(c, i, _this.getPopPrevSelection());
        } else {
          _this.undoRedoStacker.stash(c, i, _this.getPopPrevSelection(), nextSelection);
          if (nextSelection && !_this.getDontSelectNext()) {
            _this.handleSelectionChange(nextSelection);
          }
        }
      }
    });
    _this.liveMeetingController = new LiveMeetingController(_assertThisInitialized(_this));
    _this.searchReplaceController = new SearchReplaceController(_assertThisInitialized(_this));
    _this.voiceWordController = new VoiceWordController(_assertThisInitialized(_this));
    _this.paragraphFilterController = new ParagraphFilterController(_assertThisInitialized(_this));
    _this.translateController = new TranslateController(_assertThisInitialized(_this));
    _this.agendaController = new AgendaController(_assertThisInitialized(_this));
    _this.speakerController = new SpeakerController(_assertThisInitialized(_this));
    _this.unfixToFixedController = new UnfixToFixedController(_assertThisInitialized(_this));
    _this.captionCmdController = new CaptionCmdController(_assertThisInitialized(_this));
    _this.listenModelEvents();
    return _this;
  }
  var _proto = Controller.prototype;
  _proto.getReadonly = function getReadonly() {
    return this.readonly;
  };
  _proto.setReadonly = function setReadonly(readonly) {
    this.readonly = readonly;
    this.emit('readonlyChange', {
      readonly: readonly
    });
  };
  _proto.getEditorFocusPid = function getEditorFocusPid() {
    return this.editorFocusPid;
  };
  _proto.setEditorFocusPid = function setEditorFocusPid(pid) {
    this.editorFocusPid = pid;
    this.emit('editorFocusChange', {
      pid: pid
    });
    if (pid && pid === this.unfixToFixedController.getLastUnfixPid()) {
      this.unfixToFixedController.setLastUnfixIsFocus(true);
    } else {
      this.unfixToFixedController.clearFocus();
    }
  };
  _proto.dontSelectNext = function dontSelectNext() {
    this.isDontSelectNext = true;
    return this;
  };
  _proto.getDontSelectNext = function getDontSelectNext() {
    var isDontSelectNext = this.isDontSelectNext;
    this.isDontSelectNext = false;
    return isDontSelectNext;
  };
  _proto.setCurrentSelection = function setCurrentSelection(selection) {
    this.currentSelection = selection;
    this.emit('selectionChange', {
      selection: selection
    });
  };
  _proto.getCurrentSelection = function getCurrentSelection() {
    return this.currentSelection;
  };
  _proto.setEmptyUnfixTempUid = function setEmptyUnfixTempUid(tempUid) {
    this.tempUid = tempUid;
    this.emit('emptyUnfixSpeakerChange', {});
  };
  _proto.setEmptyUnfixTempParagraphMark = function setEmptyUnfixTempParagraphMark(tempMark) {
    if (this.tempMark === tempMark) {
      return;
    }
    this.tempMark = tempMark;
    this.emit('emptyUnfixParagraphChange', {});
  };
  _proto.getEmptyUnfixTempParagraphMark = function getEmptyUnfixTempParagraphMark() {
    return this.tempMark;
  };
  _proto.getEmptyUnfixTempUid = function getEmptyUnfixTempUid() {
    return this.tempUid;
  };
  _proto.isHasParagraphMarkColor = function isHasParagraphMarkColor(pid, color) {
    var _this2 = this;
    if (color === void 0) {
      color = '';
    }
    var paragraph = this.getParagraph(pid);
    if (!paragraph) {
      return false;
    }
    var wids = paragraph.wids;
    var matchTag = color;
    var isSame = wids.length > 0;
    wids.some(function (wid) {
      var word = _this2.getWord(wid);
      if (!matchTag) {
        matchTag = word.tag;
      } else if (matchTag !== word.tag) {
        isSame = false;
        return true;
      }
      return false;
    });
    return isSame;
  };
  _proto.setLivingMode = function setLivingMode(livingMode) {
    this.livingMode = livingMode; // TODO: maybe another events??

    this.emit('livingModeChange', {
      livingMode: livingMode
    });
  };
  _proto.getLivingMode = function getLivingMode() {
    return this.livingMode;
  };
  _proto.setTranscriptingState = function setTranscriptingState(transcriptingState) {
    this.transcriptingState = transcriptingState;
    if (transcriptingState === TranscriptingState.Disabled) {
      this.setUnfixSentense('');
      this.setUnfixTranslate(undefined, '', []);
    }
    this.emit('transcriptingStateChange', {
      transcriptingState: transcriptingState
    });
  };
  _proto.getTranscriptingState = function getTranscriptingState() {
    return this.transcriptingState;
  };
  _proto.getUnfixPid = function getUnfixPid() {
    var pids = this.getPids();
    if (pids.length === 0) {
      return undefined;
    }
    var lastPid = pids[pids.length - 1];
    var paragraph = this.getParagraph(lastPid);
    return paragraph.isUnfix ? lastPid : undefined;
  } // 存在空白unfix区时，有文字进入，生成unfixParagraph
  // 此操作不进入历史堆栈
  ;

  _proto.addUnfixParagraph = function addUnfixParagraph(pid, uid, words) {
    var _this3 = this;
    report_report('call addUnfixParagraph', {
      pid: pid,
      uid: uid,
      words: words
    });
    if (!this.livingMode) {
      return;
    }
    var paragraph = this.getParagraph(pid);
    if (paragraph && paragraph.isUnfix) {
      this.emit('report', {
        type: 'exception',
        message: "Exist pid: '" + pid + "' found in 'addUnfixParagraph'"
      });
      return;
    }
    var _uid = uid;
    var tempUid = this.getEmptyUnfixTempUid();
    if (tempUid && tempUid !== _uid) {
      this.unfixChangedWaiting[pid] = true;
      _uid = tempUid;
    }
    this.silent();
    this.setter.book.addUnfixParagraph(pid, _uid);
    if (words) {
      var formatedWords = words.map(function (word) {
        if (!_this3.tempMark) {
          return word;
        }
        var newWord = _lodash_es_4_17_21_lodash_es_cloneDeep(word);
        newWord.tag = _this3.tempMark;
        return newWord;
      });
      this.setter.book.appendWords(pid, formatedWords);
    }
    this.tempMark = undefined;
    this.emitAsync('addFixParagraph', {});
    this.setEmptyUnfixTempUid();
    this.translateController.setUnfixToFixed(pid);
    this.unfixToFixedController.setLastUnfixPid(pid);
  } // 此操作不进入历史堆栈
  // 当前pid必须是unfix段落，才可以调用此方法
  ;

  _proto.addFixParagraph = function addFixParagraph(pid) {
    report_report('call addFixParagraph', {
      pid: pid
    });
    if (!this.livingMode) {
      return;
    }
    var paragraph = this.getParagraph(pid);
    if (!paragraph || !paragraph.isUnfix) {
      this.emit('report', {
        type: 'exception',
        message: "Exist pid: '" + pid + "' found in 'addFixParagraph'"
      });
      return;
    }
    this.silent();
    this.setter.book.addFixParagraph(pid);
    this.setEmptyUnfixTempUid();
    this.emitAsync('addFixParagraph', {}); // 清空unfix区内容

    this.setUnfixTranslateByWords(undefined, '', []);
    if (this.getTranscriptingState() === TranscriptingState.Enabled && !this.getUnfixPid()) {
      this.emit('emptyUnfixParagraphShowUp', {});
    }
  } // 添加句子
  // 此操作不进入历史堆栈
  ;

  _proto.appendWords = function appendWords(pid, words) {
    report_report('call appendWords', {
      pid: pid,
      words: words
    });
    this.silent();
    this.setter.book.appendWords(pid, words);
  } // 此操作不进入历史堆栈
  ;

  _proto.setParagraphMark = function setParagraphMark(pid, tagColor) {
    report_report('call setParagraphMark', {
      pid: pid,
      tagColor: tagColor
    });
    var paragraph = this.getParagraph(pid);
    if (tagColor && this.isHasParagraphMarkColor(pid, tagColor)) {
      return;
    }
    this.silent();
    this.setter.book.setParagraphMark(pid, tagColor);
    if (paragraph.isUnfix) {
      this.unfixChangedWaiting[pid] = true;
    }
    this.emit('markWordsChanged', {
      markedContinuousWords: this.getMarkedContinuousWords()
    });
  } // 修改未成句句子
  ;

  _proto.setUnfixSentense = function setUnfixSentense(text) {
    if (this.holdUnfixContent === text) {
      return;
    }
    this.holdUnfixContent = text;
    this.emit('unfixSentenseChange', {
      text: text
    });
    this.emitUnfixContentChange();
  };
  _proto.getUnfixContent = function getUnfixContent() {
    return this.holdUnfixContent;
  };
  _proto.emitUnfixContentChange = function emitUnfixContentChange() {
    var pid = this.getUnfixPid();
    var words = pid ? this.getWords(pid) : [];
    this.emit('unfixContentChange', {
      unfixContent: this.holdUnfixContent,
      fixWords: words,
      pid: pid
    });
  };
  _proto.recordPrevSelection = function recordPrevSelection(selection) {
    if (this.undoRedoStacker.hasStash()) {
      return;
    }
    this.prevRecordSelection = selection;
  };
  _proto.recordNextSelection = function recordNextSelection(selection) {
    this.nextRecordSelection = selection;
  };
  _proto.getPopPrevSelection = function getPopPrevSelection() {
    var prevRecordSelection = this.prevRecordSelection;
    this.prevRecordSelection = undefined;
    return prevRecordSelection;
  };
  _proto.getPopNextSelection = function getPopNextSelection() {
    var nextRecordSelection = this.nextRecordSelection;
    this.nextRecordSelection = undefined;
    return nextRecordSelection;
  };
  _proto.handleSelectionChange = function handleSelectionChange(selection) {
    this.nextSelection = selection;
    this.currentSelection = selection;
    this.emit('selectionChange', {
      selection: selection
    });
  };
  _proto.getPopSelection = function getPopSelection(pid) {
    var nextSelection = this.nextSelection;
    if (nextSelection && nextSelection.pid === pid) {
      this.nextSelection = undefined;
      return nextSelection;
    }
    return undefined;
  };
  _proto.listenModelEvents = function listenModelEvents() {
    var _this4 = this;
    var book = this.model.book;
    book.on('lastUnfixPidChange', function (_ref2) {
      var pid = _ref2.pid;
      _this4.lastUnfixPid = pid;
    });
    book.on('wordChange', function (_ref3) {
      var pid = _ref3.pid;
      _this4.emit('paragraphChange', {
        pid: pid
      });
    });
    book.on('paragraphChange', function (_ref4) {
      var pid = _ref4.pid;
      _this4.emit('paragraphChange', {
        pid: pid
      });
    });
    book.on('paragraphListChange', function (args) {
      _this4.emit('paragraphListChange', args);
    });
    book.on('paragraphChangeSpecific', function (args) {
      _this4.emit('bookParagraphChangeSpecific', args);
    });
    book.on('paragraphChangeSpecific', createParagraphChangeSpecificHandler(function (args) {
      var updateParagraphUserChangedPids = [];
      var unfixToFixedPids = [];
      var userFixedPids = [];
      args.updateParagraphPids.forEach(function (pid) {
        if (_this4.lastUnfixPid === pid) {
          _this4.lastUnfixPid = undefined;
          unfixToFixedPids.push(pid);
          if (_this4.unfixChangedWaiting[pid]) {
            updateParagraphUserChangedPids.push(pid);
            delete _this4.unfixChangedWaiting[pid];
          }
        }
      });
      if (_this4.userFixedPid) {
        userFixedPids.push(_this4.userFixedPid);
        _this4.userFixedPid = undefined;
      }
      _this4.emit('paragraphChangeSpecific', extends_extends({}, args, {
        updateParagraphUserChangedPids: updateParagraphUserChangedPids,
        unfixToFixedPids: unfixToFixedPids,
        userFixedPids: userFixedPids
      }));
    }));
  };
  _proto.resetControllerInfos = function resetControllerInfos() {
    this.undoRedoStacker.reset();
    this.voiceWordController.reset();
    this.searchReplaceController.reset();
    this.paragraphFilterController.reset();
    this.translateController.reset();
    this.agendaController.reset();
    this.unfixToFixedController.reset();
    this.prevRecordSelection = undefined;
    this.nextRecordSelection = undefined;
    this.nextSelection = undefined;
    this.currentSelection = undefined;
    this.livingMode = false;
  };
  _proto.setModelValue = function setModelValue(tranModel) {
    if (tranModel == null || tranModel.pg == null) {
      this.resetModelValue();
    } else {
      this.model.fromJSON(tranModel);
      this.resetControllerInfos();
      this.emit('paragraphListChange', {
        maybeChangedPids: []
      });
      this.emit('modelValueChange', {});
    }
  };
  _proto.getModelValue = function getModelValue() {
    return this.model.book.toJSON();
  };
  _proto.resetModelValue = function resetModelValue() {
    this.model.book.resetModelValue();
    this.resetControllerInfos();
    this.emit('paragraphListChange', {
      maybeChangedPids: []
    });
    this.emit('modelValueChange', {});
  };
  _proto.getPByPid = function getPByPid(pid) {
    return this.model.book.getPByPid(pid);
  };
  _proto.getWordsBySces = function getWordsBySces(sces) {
    var _this5 = this;
    return sces.map(function (sc) {
      return _this5.model.book.getWordBySc(sc);
    });
  };
  _proto.getParagraph = function getParagraph(pid) {
    return this.model.book.transcription.paragraphs[pid];
  };
  _proto.isUserChangedSentence = function isUserChangedSentence(sid) {
    return this.reader.book.isUserChangedSentence(sid);
  };
  _proto.getSentencesBySids = function getSentencesBySids(sids) {
    return this.reader.book.getSentencesBySids(sids);
  };
  _proto.getPids = function getPids(seeUseSence) {
    var _this6 = this;
    if (seeUseSence === void 0) {
      seeUseSence = false;
    }
    var pids = this.reader.book.getPids();
    if (seeUseSence) {
      return pids.filter(function (pid) {
        return _this6.paragraphFilterController.isPidVisible(pid);
      });
    }
    return pids;
  };
  _proto.getParagraphs = function getParagraphs() {
    return this.reader.book.getParagraphs();
  };
  _proto.getParagraphsByUid = function getParagraphsByUid(uid) {
    return this.getParagraphs().filter(function (paragraph) {
      return paragraph.uid === uid;
    });
  };
  _proto.getParagraphByWid = function getParagraphByWid(wid) {
    return this.reader.book.getParagraphByWid(wid);
  };
  _proto.getParagraphBySid = function getParagraphBySid(sid) {
    return this.reader.book.getParagraphBySid(sid);
  };
  _proto.getWords = function getWords(pid) {
    return this.reader.book.getWords(pid);
  };
  _proto.getWordsByWids = function getWordsByWids(wids) {
    return this.reader.book.getWordsByWids(wids);
  };
  _proto.getWord = function getWord(wid) {
    return this.reader.book.getWord(wid);
  };
  _proto.isAppearedWid = function isAppearedWid(wid) {
    return this.reader.book.isAppearedWid(wid);
  };
  _proto.getFirstWordBySid = function getFirstWordBySid(sid) {
    return this.reader.book.getFirstWordBySid(sid);
  };
  _proto.getLatestSid = function getLatestSid() {
    return this.reader.book.getLatestSid();
  };
  _proto.getWordsBySelection = function getWordsBySelection(selection) {
    var startOffset = selection.startOffset,
      endOffset = selection.endOffset;
    var words = this.getWords(selection.pid);
    var matchedWords = [];
    var offset = 0;
    words.forEach(function (word) {
      var nextOffset = offset + word.text.length;
      if (startOffset < nextOffset && endOffset > offset) {
        matchedWords.push(word);
      }
      offset = nextOffset;
    });
    return matchedWords;
  };
  _proto.getTextContent = function getTextContent(pid) {
    return this.reader.book.getTextContent(pid);
  };
  _proto.getTextContentWithoutNfixing = function getTextContentWithoutNfixing(pid) {
    return this.reader.book.getTextContentWithoutNfixing(pid);
  };
  _proto.getWordByOffset = function getWordByOffset(pid, offset) {
    return this.reader.book.getWordByOffset(pid, offset);
  };
  _proto.getAllTextContent = function getAllTextContent() {
    return this.reader.book.getAllTextContent();
  };
  _proto.getAllTextContentByTag = function getAllTextContentByTag(tag) {
    var _this7 = this;
    var textContent = [];
    this.getPids().forEach(function (pid) {
      var words = _this7.getWords(pid);
      var text = words.filter(function (word) {
        return word.tag === tag;
      }).map(function (word) {
        return word.text;
      });
      if (text) {
        textContent.push.apply(textContent, text);
      }
    });
    return textContent;
  };
  _proto.getAllWords = function getAllWords(seeUseSence) {
    var _this8 = this;
    if (seeUseSence === void 0) {
      seeUseSence = false;
    }
    var pids = this.getPids(seeUseSence);
    var allWords = pids.map(function (pid) {
      return [pid, _this8.getWords(pid)];
    }).reduce(function (result, _ref5) {
      var pid = _ref5[0],
        words = _ref5[1];
      result.push.apply(result, words.map(function (word) {
        return [pid, word];
      }));
      return result;
    }, []);
    return allWords;
  } // return [allWords, firstFindPos, matchedWord]
  ;

  _proto.getMatchedWordsByTime = function getMatchedWordsByTime(timestamp) {
    var allWord = this.getAllWords();
    var lastFindPos = 0;
    var matchedWords = [];
    allWord.some(function (_ref6, index) {
      var pid = _ref6[0],
        word = _ref6[1];
      if (timestamp > word.endTime) {
        lastFindPos = index + 1;
      } else if (timestamp < word.beginTime) {
        return true;
      } else if (word.beginTime <= timestamp && word.endTime >= timestamp) {
        matchedWords.push([pid, word]);
      }
      return false;
    });
    return [allWord, lastFindPos, matchedWords];
  };
  _proto.getFirstWordByTime = function getFirstWordByTime(timestamp) {
    var _this$getMatchedWords = this.getMatchedWordsByTime(timestamp),
      allWords = _this$getMatchedWords[0],
      pos = _this$getMatchedWords[1],
      matchedWords = _this$getMatchedWords[2];
    return matchedWords.length > 0 ? matchedWords[0] : allWords[pos];
  };
  _proto.getLastWordByTime = function getLastWordByTime(timestamp) {
    var _this$getMatchedWords2 = this.getMatchedWordsByTime(timestamp),
      allWords = _this$getMatchedWords2[0],
      pos = _this$getMatchedWords2[1],
      matchedWords = _this$getMatchedWords2[2];
    return matchedWords.length > 0 ? matchedWords[matchedWords.length - 1] : allWords[Math.max(pos - 1, 0)];
  };
  _proto.getVisibleParagraphBySids = function getVisibleParagraphBySids(sids) {
    var visiblePids = this.getPids(true);
    var length = sids.length;
    for (var i = 0; i < length; i++) {
      var sid = sids[i];
      var paragraph = this.getParagraphBySid(sid);
      if (paragraph && visiblePids.includes(paragraph.pid)) {
        return paragraph;
      }
    }
    return undefined;
  };
  _proto.getParagraphByTimestampRange = function getParagraphByTimestampRange(range) {
    return this.reader.book.getParagraphByTimestampRange(range);
  };
  _proto.getVisibleParagraphByTimestampRange = function getVisibleParagraphByTimestampRange(range) {
    var visiblePids = this.getPids(true);
    return this.getParagraphByTimestampRange(range).filter(function (paragraph) {
      return visiblePids.includes(paragraph.pid);
    });
  };
  _proto.silent = function silent() {
    this.setter.nextApplySilent();
    return this;
  };
  _proto.preteat = function preteat() {
    this.setter.nextApplyPreteat();
    return this;
  };
  _proto.deleteTextRange = function deleteTextRange(pid, startOffset, endOffset) {
    if (startOffset === endOffset) {
      return;
    }
    if (this.getParagraph(pid).isUnfix) {
      this.unfixChangedWaiting[pid] = true;
    }
    this.setter.book.deleteTextRange(pid, startOffset, endOffset);
  };
  _proto.setUnfixMaxWords = function setUnfixMaxWords(unfixMaxWords) {
    this.unfixMaxWords = unfixMaxWords;
  };
  _proto.getUnfixMaxWords = function getUnfixMaxWords() {
    return this.unfixMaxWords;
  } // 不在包含nfixing中文字的计算
  ;

  _proto.isGreaterThenMaxCount = function isGreaterThenMaxCount(pid, startOffset, text) {
    report_report('call isGreaterThenMaxCount', {
      pid: pid,
      startOffset: startOffset,
      text: text
    });
    if (this.getLivingMode() === false) {
      return false;
    }
    var paragraph = this.getParagraph(pid);
    if (!paragraph.isUnfix) {
      return false;
    }
    var word = this.getWordByOffset(pid, startOffset);
    if (word != null && word.nFix) {
      return false;
    }
    var textContent = this.getTextContentWithoutNfixing(pid);
    var string = textContent + text;
    var length = getWordsCount(string);
    report_report('call isGreaterThenMaxCount: word and length', {
      word: word,
      length: length
    });
    return length > this.getUnfixMaxWords();
  };
  _proto.insertText = function insertText(pid, startOffset, text) {
    report_report('call insertText', {
      pid: pid,
      startOffset: startOffset,
      text: text
    });
    if (this.getParagraph(pid).isUnfix) {
      this.unfixChangedWaiting[pid] = true;
    }
    this.setter.book.insertText(pid, startOffset, text);
  } // 不在包含nfixing中文字的计算
  ;

  _proto.insertTextAndAddParagraph = function insertTextAndAddParagraph(pid, startOffset, text) {
    report_report('call insertTextAndAddParagraph', {
      pid: pid,
      startOffset: startOffset,
      text: text
    });
    if (this.getParagraph(pid).isUnfix) {
      this.unfixChangedWaiting[pid] = true;
    }
    this.setter.book.insertTextAndAddParagraph(pid, startOffset, text);
    this.emitAsync('addFixParagraph', {});
    this.emit('uglyUserManualAddParagraph', {});
  };
  _proto.genNewPid = function genNewPid(prevPid) {
    var pids = this.getPids();
    var pos = pids.indexOf(prevPid);
    var nextPid = pids[pos + 1];
    var newPid = generatePid(prevPid, nextPid);
    if (newPid !== prevPid && newPid !== nextPid) {
      return newPid;
    }
    return undefined;
  };
  _proto.addParagraph = function addParagraph(prevPid, startOffset) {
    if (this.getParagraph(prevPid).isUnfix) {
      this.unfixChangedWaiting[prevPid] = true;
    }
    var newPid = this.genNewPid(prevPid);
    if (newPid) {
      this.setter.book.addParagraph(prevPid, newPid, startOffset);
    }
  };
  _proto.mergePrevParagraph = function mergePrevParagraph(pid) {
    var prevId = getPreviousPid(this, pid);
    if (!prevId) {
      return;
    }
    if (this.getParagraph(pid).isUnfix) {
      this.unfixChangedWaiting[pid] = true;
    }
    this.setter.book.mergeParagraph(prevId, pid);
  };
  _proto.removeParagraph = function removeParagraph(pid) {
    this.setter.book.removeParagraph(pid);
  };
  _proto.replaceText = function replaceText(pid, startOffset, endOffset, _replaceText, preteatInsertText) {
    if (preteatInsertText === void 0) {
      preteatInsertText = false;
    }
    if (this.getParagraph(pid).isUnfix) {
      this.unfixChangedWaiting[pid] = true;
    }
    this.preteat();
    this.deleteTextRange(pid, startOffset, endOffset);
    if (preteatInsertText) {
      this.preteat();
    }
    this.insertText(pid, startOffset, _replaceText);
  };
  _proto.updateUserByPid = function updateUserByPid(pid, uid) {
    if (this.getParagraph(pid).isUnfix) {
      this.unfixChangedWaiting[pid] = true;
    }
    this.setter.book.updateUserByPid(pid, uid);
  } // unfix场景没有修改全部用户功能，暂不增加unfixChangedWaiting逻辑
  ;

  _proto.updateAllUsers = function updateAllUsers(pids, uid) {
    this.setter.book.updateAllUsers(pids, uid);
  };
  _proto.startLiveTranscription = function startLiveTranscription() {
    if (this.runningOnServer) {
      return;
    }
    this.liveMeetingController.startLiveMeeting();
  };
  _proto.findAndMark = function findAndMark(keyword, isSearchTranslate) {
    if (isSearchTranslate === void 0) {
      isSearchTranslate = true;
    }
    return this.searchReplaceController.findAndMark(keyword, isSearchTranslate);
  };
  _proto.findNext = function findNext() {
    return this.searchReplaceController.next();
  };
  _proto.findPrev = function findPrev() {
    return this.searchReplaceController.prev();
  };
  _proto.replace = function replace(text) {
    return this.searchReplaceController.replace(text);
  };
  _proto.replaceAll = function replaceAll(text) {
    return this.searchReplaceController.replaceAll(text);
  };
  _proto.getFoundSelectionsByPid = function getFoundSelectionsByPid(pid) {
    return this.searchReplaceController.getFoundSelectionsByPid(pid);
  };
  _proto.getActiveFoundSelection = function getActiveFoundSelection() {
    return this.searchReplaceController.getActiveFoundSelection();
  };
  _proto.resetFind = function resetFind() {
    return this.searchReplaceController.resetFind();
  };
  _proto.setPlayingVoiceWord = function setPlayingVoiceWord(pid, word, forceDisplay) {
    if (forceDisplay === void 0) {
      forceDisplay = false;
    }
    this.voiceWordController.setPlayingVoiceWord(pid, word, forceDisplay);
    if (this.agendaController.getEnableActiveAgenda() && word) {
      this.setActiveAgendaByTime(word.beginTime);
    }
  };
  _proto.setPlayingVoiceWordByTime = function setPlayingVoiceWordByTime(timestamp, forceDisplay) {
    if (forceDisplay === void 0) {
      forceDisplay = false;
    }
    this.voiceWordController.setPlayingVoiceWordByTime(timestamp, forceDisplay);
    if (this.agendaController.getEnableActiveAgenda()) {
      this.agendaController.setActiveAgendaByTime(timestamp);
    }
  };
  _proto.getPlayingPidAndWord = function getPlayingPidAndWord() {
    return this.voiceWordController.getPlayingPidAndWord();
  };
  _proto.getPlayingWord = function getPlayingWord(pid) {
    return this.voiceWordController.getPlayingWord(pid);
  };
  _proto.clearPlayingVoiceWord = function clearPlayingVoiceWord() {
    this.voiceWordController.clearPlayingVoiceWord();
  };
  _proto.getNextSentencesByTime = function getNextSentencesByTime(timestamp) {
    return this.voiceWordController.getNextSentencesByTime(timestamp);
  };
  _proto.getPrevSentencesByTime = function getPrevSentencesByTime(timestamp) {
    return this.voiceWordController.getPrevSentencesByTime(timestamp);
  };
  _proto.setActiveAgendaById = function setActiveAgendaById(agendaId) {
    this.agendaController.setActiveAgendaById(agendaId);
    var activeAgenda = this.getActiveAgenda();
    if (activeAgenda) {
      var beginTime = activeAgenda.highlightContents.length > 0 ? activeAgenda.highlightContents[0].beginTime : activeAgenda.beginTime;
      this.voiceWordController.setPlayingVoiceWordByTime(beginTime);
    }
  };
  _proto.clearActiveAgenda = function clearActiveAgenda() {
    this.agendaController.clearActiveAgenda();
  };
  _proto.setActiveAgendaByTime = function setActiveAgendaByTime(timestamp) {
    this.agendaController.setActiveAgendaByTime(timestamp);
  };
  _proto.getActiveAgenda = function getActiveAgenda() {
    return this.agendaController.getActiveAgenda();
  };
  _proto.setAgendasFromJSON = function setAgendasFromJSON(cps) {
    this.agendaController.fromJSON(cps);
  };
  _proto.getActiveAgendaHighlightSids = function getActiveAgendaHighlightSids() {
    return this.agendaController.getActiveAgendaHighlightSids();
  };
  _proto.getAgendas = function getAgendas() {
    return this.agendaController.getAgendas();
  };
  _proto.setAgendas = function setAgendas(agendas) {
    this.agendaController.setAgendas(agendas);
  };
  _proto.detectedFirstShowUpAgenda = function detectedFirstShowUpAgenda(agenda) {
    this.emit('detectedFirstShowUpAgenda', {
      agenda: agenda
    });
  };
  _proto.getEnableActiveAgenda = function getEnableActiveAgenda() {
    return this.agendaController.getEnableActiveAgenda();
  }
  /**
    * @deprecated
    */;

  _proto.prepareSetPlayingWord = function prepareSetPlayingWord() {
    console.warn('请替换prepareSetPlayingWord为startPlayingVoiceWord');
    this.startPlayingVoiceWord();
  };
  _proto.startPlayingVoiceWord = function startPlayingVoiceWord() {
    this.voiceWordController.startPlayingVoiceWord();
  };
  _proto.endPlayingVoiceWord = function endPlayingVoiceWord() {
    this.voiceWordController.endPlayingVoiceWord();
  };
  _proto.getIsEnablePlayingVoice = function getIsEnablePlayingVoice() {
    return this.voiceWordController.getIsEnablePlayingVoice();
  };
  _proto.seekToWord = function seekToWord(word) {
    this.emit('needSeekToWord', {
      word: word
    });
  };
  _proto.readonlyClickWord = function readonlyClickWord(words) {
    if (this.startListenSelectWordCallback) {
      this.startListenSelectWordCallback(words);
    }
  };
  _proto.extraSelectContents = function extraSelectContents(selection) {
    var startOffset = selection.startOffset,
      endOffset = selection.endOffset,
      pid = selection.pid;
    if (startOffset === endOffset) {
      return;
    }
    var textContent = this.getTextContent(pid);
    this.emit('extraContents', {
      contents: [textContent.slice(startOffset, endOffset)]
    });
  };
  _proto.markSelectContents = function markSelectContents(selection, tag) {
    var words = this.getWordsBySelection(selection);
    var attrs = {
      tag: tag
    };
    var pid = selection.pid;
    var paragraph = this.getParagraph(pid);
    if (paragraph.isUnfix) {
      this.unfixChangedWaiting[pid] = true;
    }
    this.setter.book.updateWords(pid, words, attrs);
    this.emit('markWordsChanged', {
      markedContinuousWords: this.getMarkedContinuousWords()
    });
  };
  _proto.getSelectionMarkTag = function getSelectionMarkTag() {
    var selection = this.getCurrentSelection();
    if (!selection) {
      return undefined;
    }
    var words = this.getWordsBySelection(selection);
    var result;
    words.some(function (word) {
      if (result == null) {
        result = word.tag;
      } else if (result !== word.tag) {
        result = undefined;
        return true;
      }
      return false;
    });
    return result;
  };
  _proto.getMarkedContinuousWords = function getMarkedContinuousWords(tag) {
    var continuousWords = [];
    var allWords = this.getAllWords();
    var foundTag;
    var length = allWords.length;
    for (var i = 0; i < length; i++) {
      var _allWords$i = allWords[i],
        _word = _allWords$i[1];
      if (!foundTag || _word.tag !== foundTag) {
        if (_word.tag && (tag == null || _word.tag === tag)) {
          foundTag = _word.tag;
          continuousWords.push([]);
        } else {
          foundTag = undefined;
        }
      }
      if (foundTag && _word.tag === foundTag) {
        continuousWords[continuousWords.length - 1].push(_word);
      }
    }
    return continuousWords;
  };
  _proto.needStartPlayVoiceWithSelection = function needStartPlayVoiceWithSelection(selection) {
    var words = this.getWordsBySelection(selection);
    this.emit('needStartPlayVoice', {
      words: words
    });
  };
  _proto.setFilterOption = function setFilterOption(filterOption) {
    this.paragraphFilterController.setFilterOption(filterOption);
    this.searchReplaceController.reFindAndMark();
    this.emit('paragraphFilterChange', {});
  };
  _proto.getFilterOption = function getFilterOption() {
    return this.paragraphFilterController.getFilterOption();
  };
  _proto.setTranslateMode = function setTranslateMode(mode) {
    this.translateController.setTranslateMode(mode);
    this.searchReplaceController.reFindAndMark();
  };
  _proto.getTranslateMode = function getTranslateMode(pid) {
    return this.translateController.getTranslateMode(pid);
  };
  _proto.setTranslate = function setTranslate(pid, translate) {
    var isSuccessful = this.translateController.setTranslate(pid, translate);
    if (isSuccessful) {
      this.searchReplaceController.reFindAndMark();
    }
  };
  _proto.setTranslateByWords = function setTranslateByWords(pid, translate) {
    var isSuccessful = this.translateController.setTranslateByWords(pid, translate);
    if (isSuccessful) {
      this.searchReplaceController.reFindAndMark();
    }
  };
  _proto.setTranslating = function setTranslating(pid, isTranslating) {
    this.translateController.setTranslating(pid, isTranslating);
  };
  _proto.getTranslate = function getTranslate(pid) {
    return this.translateController.getTranslate(pid);
  };
  _proto.setUnfixTranslate = function setUnfixTranslate(pid, unfixContentTranslate, fixContentTranslate) {
    this.translateController.setUnfixTranslate(pid, unfixContentTranslate, fixContentTranslate);
    this.searchReplaceController.reFindAndMark();
  };
  _proto.setUnfixTranslateByWords = function setUnfixTranslateByWords(pid, unfixContentTranslate, fixContentTranslate) {
    this.translateController.setUnfixTranslateByWords(pid, unfixContentTranslate, fixContentTranslate);
    this.searchReplaceController.reFindAndMark();
  };
  _proto.getUnfixTranslate = function getUnfixTranslate() {
    return this.translateController.getUnfixTranslate();
  };
  _proto.emitParagraphNeedTranslate = function emitParagraphNeedTranslate(pid) {
    this.emit('paragraphNeedTranslate', {
      pid: pid
    });
  };
  _proto.injectSpeakersGetter = function injectSpeakersGetter(speakersGetter) {
    this.speakerController.injectSpeakersGetter(speakersGetter);
  };
  _proto.injectSpeakersSetter = function injectSpeakersSetter(speakersSetter) {
    this.speakerController.injectSpeakersSetter(speakersSetter);
  } // 常用发言人
  ;

  _proto.injectCommonUseSpeakersGetter = function injectCommonUseSpeakersGetter(speakersGetter) {
    this.speakerController.injectCommonUseSpeakersGetter(speakersGetter);
  } // 常用发言人
  ;

  _proto.injectCommonUseSpeakersSetter = function injectCommonUseSpeakersSetter(speakersSetter) {
    this.speakerController.injectCommonUseSpeakersSetter(speakersSetter);
  };
  _proto.injectDefaultSpeakerNameGetter = function injectDefaultSpeakerNameGetter(defaultSpeakerNameGetter) {
    this.speakerController.injectDefaultSpeakerNameGetter(defaultSpeakerNameGetter);
  };
  _proto.getSpeakers = function getSpeakers() {
    return this.speakerController.getSpeakers();
  };
  _proto.setSpeakers = function setSpeakers(speakers) {
    this.speakerController.setSpeakers(speakers);
  };
  _proto.setMaxSpeaker = function setMaxSpeaker(maxSpeaker) {
    this.speakerController.setMaxSpeaker(maxSpeaker);
  };
  _proto.getMaxSpeaker = function getMaxSpeaker() {
    return this.speakerController.getMaxSpeaker();
  };
  _proto.getCommonUseSpeakers = function getCommonUseSpeakers() {
    return this.speakerController.getCommonUseSpeakers();
  };
  _proto.setCommonUseSpeakers = function setCommonUseSpeakers(speakers) {
    this.speakerController.setCommonUseSpeakers(speakers);
  } // todo----未必会使用，可能只有set就够了
  ;

  _proto.updateCommonUseSpeakersList = function updateCommonUseSpeakersList(speakers) {
    this.speakerController.updateCommonUseSpeakersList(speakers);
  };
  _proto.updateOneByAlibabaEmployeeOnEmptyUnfix = function updateOneByAlibabaEmployeeOnEmptyUnfix(alibabaEmployee) {
    this.speakerController.updateOneByAlibabaEmployeeOnEmptyUnfix(alibabaEmployee);
  };
  _proto.updateOneByHistorySpeakerOnEmptyUnfix = function updateOneByHistorySpeakerOnEmptyUnfix(speaker) {
    this.speakerController.updateOneByHistorySpeakerOnEmptyUnfix(speaker);
  };
  _proto.updateOneByInputTextOnEmptyUnfix = function updateOneByInputTextOnEmptyUnfix(oldInputText, inputText) {
    this.speakerController.updateOneByInputTextOnEmptyUnfix(oldInputText, inputText);
  };
  _proto.updateOneByAlibabaEmployee = function updateOneByAlibabaEmployee(pid, alibabaEmployee) {
    this.speakerController.updateOneByAlibabaEmployee(pid, alibabaEmployee);
  };
  _proto.updateOneByHistorySpeaker = function updateOneByHistorySpeaker(pid, speaker) {
    this.speakerController.updateOneByHistorySpeaker(pid, speaker);
  };
  _proto.updateOneByInputText = function updateOneByInputText(pid, oldInputText, inputText) {
    this.speakerController.updateOneByInputText(pid, oldInputText, inputText);
  };
  _proto.updateManyByAlibabaEmployee = function updateManyByAlibabaEmployee(currentPid, alibabaEmployee) {
    this.speakerController.updateManyByAlibabaEmployee(currentPid, alibabaEmployee);
  };
  _proto.updateManyByHistorySpeaker = function updateManyByHistorySpeaker(currentPid, speaker) {
    this.speakerController.updateManyByHistorySpeaker(currentPid, speaker);
  };
  _proto.updateManyByInputText = function updateManyByInputText(currentPid, oldInputText, inputText) {
    this.speakerController.updateManyByInputText(currentPid, oldInputText, inputText);
  };
  _proto.renderSpeakerName = function renderSpeakerName(uid) {
    return this.speakerController.renderSpeakerName(uid);
  };
  _proto.getLastUnfixPid = function getLastUnfixPid() {
    return this.unfixToFixedController.getLastUnfixPid();
  };
  _proto.getUnfixToFixedPid = function getUnfixToFixedPid() {
    return this.unfixToFixedController.getUnfixToFixedPid();
  };
  _proto.getUnfixToFixedKeepFocusPid = function getUnfixToFixedKeepFocusPid() {
    return this.unfixToFixedController.getUnfixToFixedKeepFocusPid();
  };
  _proto.isFirstUnfixPid = function isFirstUnfixPid(pid) {
    return this.unfixToFixedController.isFirstUnfixPid(pid);
  };
  _proto.emitSaveDocument = function emitSaveDocument() {
    this.emit('saveDocument', {});
  };
  _proto.getParagraphCaptionsMap = function getParagraphCaptionsMap() {
    return this.captionCmdController.getParagraphCaptionsMap();
  };
  _proto.getCaptionArray = function getCaptionArray() {
    return this.captionCmdController.getCaptionArray();
  };
  _proto.getCaptionByTimestamp = function getCaptionByTimestamp(timestamp) {
    return this.captionCmdController.getCaptionByTimestamp(timestamp);
  };
  _proto.undo = function undo() {
    this.undoRedoStacker.undo();
  };
  _proto.redo = function redo() {
    this.undoRedoStacker.redo();
  };
  _proto.canUndo = function canUndo() {
    return this.undoRedoStacker.canUndo();
  };
  _proto.canRedo = function canRedo() {
    return this.undoRedoStacker.canRedo();
  };
  _proto.isHasContent = function isHasContent() {
    return this.getAllTextContent().join('') !== '';
  };
  _proto.startRecordResultCheck = function startRecordResultCheck() {
    var _this9 = this;
    if (this.isHasContent()) {
      return;
    }
    this.recordTimeout = setTimeout(function () {
      if (!_this9.isHasContent()) {
        _this9.emit('detectEmptyContent', {});
        _this9.stopRecordResultCheck();
      }
    }, 30000);
  };
  _proto.stopRecordResultCheck = function stopRecordResultCheck() {
    clearTimeout(this.recordTimeout);
    this.recordTimeout = undefined;
  };
  _proto.clearNoRecordTip = function clearNoRecordTip() {
    // 外部可控制关闭NoRecordTip
    this.emit('closeNoRecordTip', {});
  };
  return Controller;
}(Eventer);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/transcriptionCommand.js




var TranscriptionCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(TranscriptionCommand, _AbstractCommand);
  function TranscriptionCommand(context, controller) {
    var _this;
    _this = _AbstractCommand.call(this, context) || this;
    _this.watchMessageKeys = ['TranscriptionResultChanged', 'ParagraphChanged'];
    _this.controller = void 0;
    _this.handleMeetingStateChange = function (event) {
      var state = event.state;
      var meetingController = _this.context.meetingController;
      if (meetingController.isInMeeting()) {
        _this.controller.setTranscriptingState(TranscriptingState.Enabled);
      } else if (state === MeetingState.PreparePause || state === MeetingState.PrepareStop) {
        _this.controller.setTranscriptingState(TranscriptingState.Disabing);
      } else {
        _this.controller.setTranscriptingState(TranscriptingState.Disabled);
      }
    };
    _this.controller = controller;
    return _this;
  }
  var _proto = TranscriptionCommand.prototype;
  _proto.onReady = function onReady() {
    var meetingController = this.context.meetingController;
    this.needCleanups(meetingController.on('meetingStateChange', this.handleMeetingStateChange));
  };
  _proto.onMessage = function onMessage(message) {
    var _ref = (message == null ? void 0 : message.header) || {},
      name = _ref.name;
    if (name === 'TranscriptionResultChanged') {
      this.handleUnfixContentChange(message.payload);
    } else if (name === 'ParagraphChanged') {
      this.handleParagraphChange(message.payload);
    }
  };
  _proto.handleUnfixContentChange = function handleUnfixContentChange(payload) {
    var _payload$stash_result;
    this.controller.setUnfixSentense(((_payload$stash_result = payload.stash_result) == null ? void 0 : _payload$stash_result.text) || '');
  };
  _proto.handleParagraphChange = function handleParagraphChange(payload) {
    var _payload$pg, _payload$pg2, _payload$stash_result2;
    var controller = this.controller;
    var timer = this.context.timer;
    payload.pg.forEach(function (item) {
      var partial = item.partial,
        pi = item.pi,
        sc = item.sc,
        ui = item.ui;
      var paragraph = controller.getParagraph(pi);
      var words = controller.getWordsBySces(sc);
      if (partial) {
        if (!paragraph) {
          controller.addUnfixParagraph(pi, ui);
        }
        controller.appendWords(pi, words);
      } else if (!paragraph) {
        controller.addUnfixParagraph(pi, ui);
        controller.addFixParagraph(pi);
        controller.appendWords(pi, words);
      } else {
        controller.appendWords(pi, words);
        controller.addFixParagraph(pi);
      }
    }); // 记录时长与录音时长比对

    var time = timer.getTime();
    var pgLength = payload == null ? void 0 : (_payload$pg = payload.pg) == null ? void 0 : _payload$pg.length;
    if (pgLength && (_payload$pg2 = payload.pg[pgLength - 1]) != null && _payload$pg2.sc) {
      var _words;
      var words = payload.pg[pgLength - 1].sc;
      var wordsLength = words == null ? void 0 : words.length;
      if (wordsLength && (_words = words[wordsLength - 1]) != null && _words.et) {
        var endTime = words[wordsLength - 1].et; // fixed 返回的endTime实际上与录音时长会有4～5s的误差

        if (Math.abs(time - endTime) > 10000) {
          timer.reset(endTime + 5000);
        }
      }
    }
    controller.setUnfixSentense(((_payload$stash_result2 = payload.stash_result) == null ? void 0 : _payload$stash_result2.text) || '');
  };
  return TranscriptionCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/utils/translate.js
var transformTSToSC = function transformTSToSC(ts) {
  return ts.map(function (value) {
    return {
      id: 0,
      bt: value.bt,
      et: value.et,
      si: value.si,
      tc: value.txt
    };
  });
};
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/translateCommand.js



var TranslateCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(TranslateCommand, _AbstractCommand);
  function TranslateCommand(context, controller) {
    var _this;
    _this = _AbstractCommand.call(this, context) || this;
    _this.watchMessageKeys = ['ParagraphTranslated'];
    _this.controller = void 0;
    _this.handleParagraphTranslate = function (payload) {
      var _payload$pg;
      (_payload$pg = payload.pg) == null ? void 0 : _payload$pg.forEach(function (pg) {
        var pi = pg.pi,
          ts = pg.ts;
        var sc = transformTSToSC(ts);
        _this.controller.setTranslate(pi, sc);
      });
    };
    _this.controller = controller;
    return _this;
  }
  var _proto = TranslateCommand.prototype;
  _proto.onMessage = function onMessage(message) {
    var _ref = (message == null ? void 0 : message.header) || {},
      name = _ref.name;
    if (name === 'ParagraphTranslated') {
      this.handleParagraphTranslate(message.payload);
    }
  };
  return TranslateCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/asrCommand.js




var AsrCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(AsrCommand, _AbstractCommand);
  function AsrCommand(context, controller) {
    var _this;
    _this = _AbstractCommand.call(this, context) || this;
    _this.controller = void 0;
    _this.controller = controller;
    return _this;
  }
  var _proto = AsrCommand.prototype;
  _proto.onReady = function onReady() {
    var _this2 = this;
    var meetingController = this.context.meetingController;
    return this.needCleanups(meetingController.on('meetingStateChange', function (_ref) {
      var state = _ref.state;
      if ([MeetingState.Idle, MeetingState.Pause, MeetingState.Stop].includes(state)) {
        _this2.controller.setTranscriptingState(TranscriptingState.Disabled);
      } else if ([MeetingState.PreparePause, MeetingState.PrepareStop].includes(state)) {
        _this2.controller.setTranscriptingState(TranscriptingState.Disabing);
      } else {
        _this2.controller.setTranscriptingState(TranscriptingState.Enabled);
      }
    }));
  };
  return AsrCommand;
}(AbstractCommand);
;// CONCATENATED MODULE: ./node_modules/_@ali_tingwu-meeting@0.3.9@@ali/tingwu-meeting/dist-web/command/pingPongCommand.js







var defaultPingPongCommandParams = {
  pingWaiting: 10000,
  pongWaiting: 5000,
  pingPongTimeout: 30000
};
var PingPongCommand = /*#__PURE__*/function (_AbstractCommand) {
  _inheritsLoose(PingPongCommand, _AbstractCommand);
  function PingPongCommand(context, params) {
    var _this;
    if (params === void 0) {
      params = {};
    }
    _this = _AbstractCommand.call(this, context) || this;
    _this.params = void 0;
    _this.watchMessageKeys = ['UpdateConfigAck'];
    _this.interval = void 0;
    _this.pingPongTimeoutTimer = void 0;
    _this.lastPingId = void 0;
    _this.pingPrepare = void 0;
    _this.params = Object.assign({}, defaultPingPongCommandParams, params);
    return _this;
  }
  var _proto = PingPongCommand.prototype;
  _proto.onReady = function onReady() {
    var _this2 = this;
    var connection = this.context.connection;
    this.needCleanups(connection.on('open', function () {
      _this2.startPingPong();
    }), connection.on('close', function () {
      _this2.stopPingPong();
    }));
  };
  _proto.onMessage = function onMessage(message) {
    var _ref = (message == null ? void 0 : message.header) || {},
      name = _ref.name;
    if (name === 'UpdateConfigAck') {
      var _ref2 = message.payload || {},
        pong = _ref2.pong;
      if (pong && this.lastPingId === pong) {
        if (this.pingPrepare) {
          this.pingPrepare.resolve();
          this.pingPrepare = undefined;
          report('收到Pong', pong);
        }
      }
    }
  };
  _proto.doPingPong = /*#__PURE__*/function () {
    var _doPingPong = asyncToGenerator_asyncToGenerator( /*#__PURE__*/regenerator_default().mark(function _callee() {
      var _this3 = this;
      var connection, payload, _this$lastPingId;
      return regenerator_default().wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              connection = this.context.connection;
              _context.prev = 1;
              if (this.pingPrepare) {
                this.pingPrepare.reject();
              }
              this.lastPingId = getUUID();
              payload = {
                ping: this.lastPingId
              };
              this.pingPrepare = new TimeoutPrepare(function () {}, this.params.pongWaiting);
              this.sendMessage('UpdateConfig', payload);
              report('发送Ping', this.lastPingId);
              _context.next = 10;
              return this.pingPrepare.waiting;
            case 10:
              this.stopPingPongTiemout(); // eslint-disable-next-line alidocs/catch-call-function

              _context.next = 17;
              break;
            case 13:
              _context.prev = 13;
              _context.t0 = _context["catch"](1);
              report('识别到pong超时, 尝试中重新ping', (_this$lastPingId = this.lastPingId) != null ? _this$lastPingId : '未知pingId'); // detect break connection;

              if (!this.pingPongTimeoutTimer) {
                this.pingPongTimeoutTimer = setTimeout(function () {
                  if (connection.isConnected()) {
                    var _this3$lastPingId;
                    report('识别到pong超时, 启动重连网络', (_this3$lastPingId = _this3.lastPingId) != null ? _this3$lastPingId : '未知pingId');
                    connection.reconnect();
                  } else {
                    var _this3$lastPingId2;
                    report('识别到pong超时, 网络已经在停止状态', (_this3$lastPingId2 = _this3.lastPingId) != null ? _this3$lastPingId2 : '未知pingId');
                  }
                  _this3.pingPongTimeoutTimer = undefined;
                }, this.params.pingPongTimeout);
              }
            case 17:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, this, [[1, 13]]);
    }));
    function doPingPong() {
      return _doPingPong.apply(this, arguments);
    }
    return doPingPong;
  }();
  _proto.startPingPong = function startPingPong() {
    var _this4 = this;
    if (this.interval) {
      this.stopPingPong();
    }
    this.interval = setInterval(function () {
      _this4.doPingPong();
    }, this.params.pingWaiting);
  };
  _proto.stopPingPong = function stopPingPong() {
    if (!this.interval) {
      return;
    }
    clearInterval(this.interval);
    this.interval = undefined;
    this.lastPingId = undefined;
    this.pingPrepare = undefined;
    this.stopPingPongTiemout();
  };
  _proto.stopPingPongTiemout = function stopPingPongTiemout() {
    if (this.pingPongTimeoutTimer) {
      clearTimeout(thi